package com.twjitm.core.common.system;

import com.twjitm.core.utils.logs.LoggerUtils;
import org.apache.log4j.Logger;

import java.util.Properties;

/**
 * @author twjitm - [Created on 2018-08-17 10:53]
 * @company https://github.com/twjitm/
 * @jdk java version "1.8.0_77"
 * system service
 */
public class SystemService {
    private static Logger logger = LoggerUtils.getLogger(SystemService.class);

    public static System getSystem() {
        Properties properties = java.lang.System.getProperties();
        String os = properties.getProperty("os.name");
        System system = new System();

        System.SystemType type = null;
        if (os.contains("windows")) {
            type = System.SystemType.WINDOWS;
        }
        if (os.contains("linux") || os.contains("centos") || os.contains("ubuntu")) {
            type = System.SystemType.LINUX;
        }
        if (os.contains("mac")) {
            type = System.SystemType.MAC;
        }
        system.setVersion(os);
        system.setType(type);
        logger.info("OPERATING SYSTEM: " + os);
        logger.info("JAVA RUNTIME VERSION: " + properties.getProperty("java.runtime.version"));
        logger.info("JAVA CLASS VERSION: " + properties.getProperty("java.class.version"));
        logger.info("JAVA VM VERSION: " + properties.getProperty("java.vm.version"));
        return system;
    }

}
