package com.twjitm.core.common.service.rpc.service;

import com.twjitm.core.common.config.global.NettyGameServiceConfig;
import com.twjitm.core.common.config.global.NettyGameServiceConfigService;
import com.twjitm.core.common.config.rpc.RpcServerConfig;
import com.twjitm.core.common.enums.NettyGameTypeEnum;
import com.twjitm.core.common.service.IService;
import com.twjitm.core.common.service.rpc.client.AbstractNettyRpcConnectManager;
import com.twjitm.core.common.service.rpc.manager.NettyDbRpcConnectManager;
import com.twjitm.core.common.service.rpc.manager.NettyGameRpcConnectManager;
import com.twjitm.core.common.service.rpc.manager.NettyWorldRpcConnectManager;
import com.twjitm.core.common.service.rpc.server.NettySdServer;
import com.twjitm.core.common.zookeeper.NettyZookeeperNodeInfo;
import com.twjitm.core.common.zookeeper.NettyZookeeperNodeNettyGameTypeEnum;
import com.twjitm.core.spring.SpringServiceManager;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author twjitm - [Created on 2018-08-20 13:26]
 * @company https://github.com/twjitm/
 * @jdk java version "1.8.0_77"
 * <p>
 * RPC 服务发现
 */
@Service
public class NettyRpcClientConnectService implements IService {

    @Resource
    NettyWorldRpcConnectManager worldRpcConnectManager;
    @Resource
    NettyGameRpcConnectManager gameRpcConnectManager;
    @Resource
    NettyDbRpcConnectManager dbRpcConnectManager;

    @Override
    public String getId() {
        return null;
    }

    @Override
    public void startup() throws Exception {
        initManager();
        initServer();
    }

    @Override
    public void shutdown() throws Exception {
        worldRpcConnectManager.stop();
        gameRpcConnectManager.stop();
        dbRpcConnectManager.stop();
    }

    private void initManager() {
        worldRpcConnectManager.initManager();
        gameRpcConnectManager.initManager();
        dbRpcConnectManager.initManager();
    }

    private void initServer() throws InterruptedException {
        initWordServer();
        initGameServer();
        initDbServer();
    }

    private void initDbServer() throws InterruptedException {
        NettyGameServiceConfigService config = SpringServiceManager.getSpringLoadService().getNettyGameServiceConfigService();
        RpcServerConfig serviceConfig = config.getRpcServerConfig();
        List<NettySdServer> nettySdServerList = serviceConfig.getDbNettySdServerList();
        dbRpcConnectManager.initServers(nettySdServerList);
    }

    private void initGameServer() throws InterruptedException {
        NettyGameServiceConfigService config = SpringServiceManager.getSpringLoadService().getNettyGameServiceConfigService();
        RpcServerConfig serviceConfig = config.getRpcServerConfig();
        List<NettySdServer> nettySdServerList = serviceConfig.getGameNettySdServerList();
        gameRpcConnectManager.initServers(nettySdServerList);

    }

    private void initWordServer() throws InterruptedException {
        NettyGameServiceConfigService config = SpringServiceManager.getSpringLoadService().getNettyGameServiceConfigService();
        RpcServerConfig serviceConfig = config.getRpcServerConfig();
        List<NettySdServer> nettySdServerList = serviceConfig.getWorldNettySdServerList();
        worldRpcConnectManager.initServers(nettySdServerList);
    }

    public AbstractNettyRpcConnectManager getNettyRpcConnectManager(NettyGameTypeEnum boEnum){
        AbstractNettyRpcConnectManager abstractRpcConnectManager = worldRpcConnectManager;
        if(boEnum.equals(NettyGameTypeEnum.GAME)){
            abstractRpcConnectManager = gameRpcConnectManager;
        }else if (boEnum.equals(NettyGameTypeEnum.DB)){
            abstractRpcConnectManager = dbRpcConnectManager;
        }
        return abstractRpcConnectManager;
    }

    public AbstractNettyRpcConnectManager getNettyRpcConnectManager(NettyZookeeperNodeNettyGameTypeEnum zooKeeperNodeBoEnu){
        AbstractNettyRpcConnectManager abstractRpcConnectManager = worldRpcConnectManager;
        if(zooKeeperNodeBoEnu.equals(NettyZookeeperNodeNettyGameTypeEnum.GAME)){
            abstractRpcConnectManager = gameRpcConnectManager;
        }else if (zooKeeperNodeBoEnu.equals(NettyZookeeperNodeNettyGameTypeEnum.DB)){
            abstractRpcConnectManager = dbRpcConnectManager;
        }
        return abstractRpcConnectManager;
    }
    public void notifyConnect(NettyZookeeperNodeNettyGameTypeEnum   nettyGameTypeEnum, List<NettyZookeeperNodeInfo> nettyZookeeperNodeInfoList) {
        getNettyRpcConnectManager(nettyGameTypeEnum).initNettyZookeeperRpcServers(nettyZookeeperNodeInfoList);

    }
}
