package com.twjitm.core.common.service.rpc.server;

import com.twjitm.core.utils.logs.LoggerUtils;
import org.apache.log4j.Logger;
import org.jdom2.DataConversionException;
import org.jdom2.Element;

/**
 * @author twjitm - [Created on 2018-08-20 13:36]
 * @company https://github.com/twjitm/
 * @jdk java version "1.8.0_77"
 * rpc 配置文件sd对象
 */
public class NettySdServer {
    private Logger logger = LoggerUtils.getLogger(NettySdServer.class);
    /**
     * 服务器配置id
     */
    private int serverId;
    private String ip;
    private int port;
    /**
     * 域名
     */
    private String domain;
    /**
     * 域名端口
     */
    private int domainPort;

    /**
     * 权重
     */
    private int weight;

    /**
     * 最大数量
     */
    private int maxNumber;


    /**
     * 通讯短端口
     */
    private int rpcPort;
    /**
     * 通讯链接数量
     */
    private int rpcClientNumber;

    public int getServerId() {
        return serverId;
    }

    public void setServerId(int serverId) {
        this.serverId = serverId;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getWeight() {
        return weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getMaxNumber() {
        return maxNumber;
    }

    public void setMaxNumber(int maxNumber) {
        this.maxNumber = maxNumber;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public int getDomainPort() {
        return domainPort;
    }

    public void setDomainPort(int domainPort) {
        this.domainPort = domainPort;
    }

    public int getRpcPort() {
        return rpcPort;
    }

    public void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public int getRpcClientNumber() {
        return rpcClientNumber;
    }

    public void setRpcClientNumber(int rpcClientNumber) {
        this.rpcClientNumber = rpcClientNumber;
    }

    public void load(Element element) throws DataConversionException {
        serverId = element.getAttribute("serverId").getIntValue();
        domain = element.getAttributeValue("domain");
        domainPort = element.getAttribute("domainPort").getIntValue();
        ip = element.getAttributeValue("ip");
        port = element.getAttribute("port").getIntValue();
        weight = element.getAttribute("weight").getIntValue();
        maxNumber = element.getAttribute("maxNumber").getIntValue();
        rpcClientNumber = element.getAttribute("rpcClientNumber").getIntValue();
        rpcPort = element.getAttribute("rpcPort").getIntValue();
        logger.info("LOAD RPC REGISTER MESSAGE [serverId=" + serverId +
                ",domain=" + domain + ",domainPort" + domainPort + ",ip=" +
                ip + ",port=" + port + ",weight=" + weight + ",maxNumber=" + maxNumber
                + ",rpcClientNumber=" + rpcClientNumber + ",rpcPort=" + rpcPort + "]");
    }

}
