package com.twjitm.core.common.service.rpc.client;

import com.twjitm.core.common.enums.NettyGameTypeEnum;

/**
 * rpc上下文持有者对像。主要包含请求信息，服务器信息，请求类型
 * 在rpc请求之前需要将基本信息保存到此对象中，底层需要获取基本消息，来路由
 * 到具体的远程服务器上。
 *
 * @author twjitm - [Created on 2018-08-20 12:31]
 * @jdk java version "1.8.0_77"
 */
public class NettyRpcContextHolderObject {
    private NettyGameTypeEnum nettyGameTypeEnum;
    private int serviceId;

    public NettyRpcContextHolderObject(NettyGameTypeEnum nettyGameTypeEnum, int serviceId) {
        this.nettyGameTypeEnum = nettyGameTypeEnum;
        this.serviceId = serviceId;
    }

    public NettyGameTypeEnum getNettyGameTypeEnum() {
        return nettyGameTypeEnum;
    }

    public void setNettyGameTypeEnum(NettyGameTypeEnum nettyGameTypeEnum) {
        this.nettyGameTypeEnum = nettyGameTypeEnum;
    }

    public int getServiceId() {
        return serviceId;
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }
}
