package com.twjitm.core.common.service.rpc.client;

/**
 * rpc信息上下文持有者
 *
 * @author twjitm - [Created on 2018-08-20 12:28]
 * @company https://github.com/twjitm/
 * @jdk java version "1.8.0_77"
 */
public class NettyRpcContextHolder {
    /**
     * 采用ThreadLocal 模式实现一个线程安全的上下文切换。
     */
    private static final ThreadLocal<NettyRpcContextHolderObject> contextHolder = new
            ThreadLocal<NettyRpcContextHolderObject>();

    public static NettyRpcContextHolderObject getContext() {
        return (NettyRpcContextHolderObject) contextHolder.get();
    }

    /**
     * 通过字符串选择数据源
     *
     * @param
     */
    public static void setContextHolder(NettyRpcContextHolderObject rpcContextHolderObject) {
        contextHolder.set(rpcContextHolderObject);
    }
}
