package com.twjitm.core.common.config.rpc;

import com.twjitm.core.common.config.global.GlobalConstants;
import com.twjitm.core.common.enums.NettyGameTypeEnum;
import com.twjitm.core.common.service.rpc.server.NettySdRpcServiceProvider;
import com.twjitm.core.common.service.rpc.server.NettySdServer;
import com.twjitm.core.utils.file.FileUtil;
import com.twjitm.core.utils.xml.JdomUtils;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author twjitm - [Created on 2018-08-20 14:11]
 * @company https://github.com/twjitm/
 * @jdk java version "1.8.0_77"
 */
@Service
public class RpcServerConfig {
    private List<NettySdServer> dbNettySdServerList;
    private List<NettySdServer> gameNettySdServerList;
    private List<NettySdServer> worldNettySdServerList;

    protected final Object lock = new Object();

    private NettySdRpcServiceProvider provider;


    public void init() throws DataConversionException {
       Element rootElement = JdomUtils.getRootElementByStream(GlobalConstants.ConfigFile.RPC_SERVER_REGISTER_CONFIG);
        List<NettySdServer> sdWorldServers = new ArrayList<>();
        Element element = rootElement.getChild(NettyGameTypeEnum.WORLD.toString().toLowerCase());
        List<Element> childrenElements = element.getChildren("server");
        for (Element childElement : childrenElements) {
            NettySdServer sdServer = new NettySdServer();
            sdServer.load(childElement);
            sdWorldServers.add(sdServer);
        }

        List<NettySdServer> sdGameServers = new ArrayList<>();
        element = rootElement.getChild(NettyGameTypeEnum.GAME.toString().toLowerCase());
        childrenElements = element.getChildren("server");
        for (Element childElement : childrenElements) {
            NettySdServer sdServer = new NettySdServer();
            sdServer.load(childElement);
            sdGameServers.add(sdServer);
        }

        List<NettySdServer> sdDbServers = new ArrayList<>();
        element = rootElement.getChild(NettyGameTypeEnum.DB.toString().toLowerCase());
        childrenElements = element.getChildren("server");
        for (Element childElement : childrenElements) {
            NettySdServer sdServer = new NettySdServer();
            sdServer.load(childElement);
            sdDbServers.add(sdServer);
        }

        synchronized (this.lock) {
            this.worldNettySdServerList = sdWorldServers;
            this.gameNettySdServerList = sdGameServers;
            this.dbNettySdServerList = sdDbServers;
        }

        NettySdRpcServiceProvider sdRpcServiceProvider = new NettySdRpcServiceProvider();
        rootElement = JdomUtils.getRootElementByStream(GlobalConstants.ConfigFile.RPC_SERVICE_CONFIG);
        childrenElements = rootElement.getChildren("service");
        for (Element childElement : childrenElements) {
            sdRpcServiceProvider.load(childElement);
        }

        synchronized (this.lock) {
            this.provider = sdRpcServiceProvider;
        }
    }

    public List<NettySdServer> getDbNettySdServerList() {
        return dbNettySdServerList;
    }

    public void setDbNettySdServerList(List<NettySdServer> dbNettySdServerList) {
        this.dbNettySdServerList = dbNettySdServerList;
    }

    public List<NettySdServer> getGameNettySdServerList() {
        return gameNettySdServerList;
    }

    public void setGameNettySdServerList(List<NettySdServer> gameNettySdServerList) {
        this.gameNettySdServerList = gameNettySdServerList;
    }

    public List<NettySdServer> getWorldNettySdServerList() {
        return worldNettySdServerList;
    }

    public void setWorldNettySdServerList(List<NettySdServer> worldNettySdServerList) {
        this.worldNettySdServerList = worldNettySdServerList;
    }

    public NettySdRpcServiceProvider getProvider() {
        return provider;
    }

    public void setProvider(NettySdRpcServiceProvider provider) {
        this.provider = provider;
    }
    public boolean validServer(int boId){
        return provider.validServer(boId);
    }
}
