package com.twjitm.core.common.config.global;

import com.twjitm.core.utils.xml.JdomUtils;
import org.jdom2.Element;
import org.springframework.stereotype.Service;


/**
 * @author twjitm - [Created on 2018-08-22 17:42]
 * @company https://github.com/twjitm/
 * @jdk java version "1.8.0_77"
 */
@Service
public class NettyGameUdpConfig extends NettyGameConfig {

    /**
     * udp消息处理器工作线程大小
     */
    private int updQueueMessageProcessWorkerSize;
    /**
     * udp消息出路方式：true:有序队列。false:线程池生产者消费者阻塞队列
     */
    private boolean messageInOrderQueue;

    public void init() {
        Element rootElement = JdomUtils.getRootElementByStream(GlobalConstants.ConfigFile.UDP_SERVER_CONFIG_FILE_PATH);
        Element element = rootElement.getChild("server");
        super.init(element);
        updQueueMessageProcessWorkerSize = Integer.parseInt(element.getChildTextTrim("queueWorkSize"));
        messageInOrderQueue = Boolean.parseBoolean(element.getChildTextTrim("orderFlag"));
    }

    public int getUpdQueueMessageProcessWorkerSize() {
        return updQueueMessageProcessWorkerSize;
    }

    public boolean isMessageInOrderQueue() {
        return messageInOrderQueue;
    }
}
