package com.twjitm.core.common.config.global;

import com.twjitm.core.utils.xml.JdomUtils;
import org.jdom2.Element;
import org.springframework.stereotype.Service;

/**
 * @author twjitm - [Created on 2018-08-22 17:43]
 * @company https://github.com/twjitm/
 * @jdk java version "1.8.0_77"
 */
@Service
public class NettyGameHttpConfig extends NettyGameConfig {

    private boolean openSSL;
    private int handleThreadSize;

    public void init() {
        String file = GlobalConstants.ConfigFile.HTTP_SERVER_CONFIG;
        Element rootElement = JdomUtils.getRootElementByStream(file);
        Element element = rootElement.getChild("server");
        super.init(element);
        openSSL = Boolean.parseBoolean(element.getChildTextTrim("openSSL"));
        handleThreadSize = Integer.parseInt(element.getChildTextTrim("handleThreadSize"));
    }

    public boolean isOpenSSL() {
        return openSSL;
    }

    public int getHandleThreadSize() {
        return handleThreadSize;
    }
}
