"""List of all CSS keywords."""

from typing import List

from mixt.internal.html import __tags__


# pylint: disable=line-too-long

# https://www.w3.org/TR/css3-mediaqueries/
# https://developer.mozilla.org/en-US/docs/Web/CSS/Media_Queries/Using_media_queries

MEDIA_QUERIES_KEYWORDS: str = """
aural braille handheld print projection screen tty tv embossed speech all
min max
width
height
device-width
device-height
orientation portrait landscape
aspect-ratio
device-aspect-ratio
color
color-index
monochrome
resolution
scan interlace progressive
grid
update none slow fast
overflow-block none scroll optional-paged paged
overflow-inline none scroll
color-gamut srgb p3 rec2020
display-mode fullscreen standalone minimal-ui browser
inverted-colors none inverted
pointer none coarse fine
hover none hover
any-pointer none coarse fine
any-hover none hover
light-level dim normal washed
scripting none initial-only enabled
"""

VENDOR_PREFIXES: str = "webkit moz o ms"

TAGS = [
    tag
    for tag in __tags__
    if not tag.startswith("_") and ("html" not in tag or tag == "html")
]

# for reference:
# - https://github.com/mdn/data/blob/master/css/properties.json
# - https://github.com/mdn/data/blob/master/css/syntaxes.json
# - https://github.com/mdn/data/blob/master/css/at-rules.json

# Current list generated with (`curl` and `jq` are needed):

# (curl -s https://raw.githubusercontent.com/mdn/data/f27b8c30ea5593c09e35292a63618147983a274c/css/properties.json \
# && curl -s https://raw.githubusercontent.com/mdn/data/f27b8c30ea5593c09e35292a63618147983a274c/css/syntaxes.json \
# && curl -s https://raw.githubusercontent.com/mdn/data/f27b8c30ea5593c09e35292a63618147983a274c/css/at-rules.json) |
# jq 'with_entries(.value |= .syntax)'  | sed -e 's/ /\n/g' -e 's/(/\n(/g' | grep -vP '[<>]|\\n' |
# grep -o -P '(\-?[a-zA-Z]+(-[a-zA-Z]+)*)' | sed -e 's/^-//g' | sort -u

CSS_KEYWORDS: str = """
above
absolute
absolute-size
active
ActiveBorder
ActiveCaption
add
additive-symbols
after
alias
aliceblue
align-content
align-items
align-self
all
allow-end
all-petite-caps
all-scroll
all-small-caps
alpha
alphabetic
alpha-value
alternate
alternate-reverse
always
and
angle
angle-percentage
animateable-feature
animation
animation-delay
animation-direction
animation-duration
animation-fill-mode
animation-iteration-count
animation-name
animation-play-state
animation-timing-function
annotation
antiquewhite
appearance
AppWorkspace
aqua
aquamarine
at
attachment
attr
attribute-selector
attr-matcher
attr-modifier
auto
auto-fill
auto-fit
auto-flow
auto-repeat
auto-track-list
available
avoid
avoid-column
avoid-page
avoid-region
azimuth
azure
backdrop-filter
backface-visibility
background
Background
background-attachment
background-blend-mode
background-clip
background-color
background-image
background-origin
background-position
background-position-x
background-position-y
background-repeat
background-size
backwards
balance
balance-all
baseline
baseline-position
basic-shape
before
behind
beige
below
bg-image
bg-layer
bg-position
bg-size
bidi-override
bisque
black
blanchedalmond
blank
blend-mode
blink
block
block-axis
block-end
block-overflow
block-size
block-start
blue
blueviolet
blur
bold
bolder
border
border-block-end
border-block-end-color
border-block-end-style
border-block-end-width
border-block-start
border-block-start-color
border-block-start-style
border-block-start-width
border-bottom
border-bottom-color
border-bottom-left-radius
border-bottom-right-radius
border-bottom-style
border-bottom-width
border-box
border-collapse
border-color
border-image
border-image-outset
border-image-repeat
border-image-slice
border-image-source
border-image-width
border-inline-end
border-inline-end-color
border-inline-end-style
border-inline-end-width
border-inline-start
border-inline-start-color
border-inline-start-style
border-inline-start-width
border-left
border-left-color
border-left-style
border-left-width
border-radius
border-right
border-right-color
border-right-style
border-right-width
border-spacing
border-style
border-top
border-top-color
border-top-left-radius
border-top-right-radius
border-top-style
border-top-width
border-width
both
bottom
bottom-center
bottom-left
bottom-left-corner
bottom-right
bottom-right-corner
box
box-align
box-decoration
box-decoration-break
box-direction
box-flex
box-flex-group
box-lines
box-ordinal-group
box-orient
box-pack
box-shadow
box-sizing
break-after
break-all
break-before
break-inside
break-word
brightness
brown
br-style
br-width
bt
burlywood
button
button-arrow-down
button-arrow-next
button-arrow-previous
button-arrow-up
button-bevel
ButtonFace
button-focus
ButtonHighlight
ButtonShadow
ButtonText
cadetblue
calc
calc-product
calc-sum
calc-value
capitalize
caption
caption-side
CaptionText
caret
caret-color
cell
center
center-left
center-right
cf-final-image
cf-mixing-image
chained
character-variant
charset
chartreuse
checkbox
checkbox-container
checkbox-label
checkmenuitem
chocolate
circle
class-selector
clear
clip
clip-path
clip-source
clone
close-quote
closest-corner
closest-side
cm
collapse
color
color-adjust
color-burn
color-dodge
color-stop
color-stop-list
col-resize
column
column-count
column-fill
column-gap
column-reverse
column-rule
column-rule-color
column-rule-style
column-rule-width
columns
column-span
column-width
common-ligatures
common-lig-values
composite-style
compositing-operator
compound-selector
compound-selector-list
condensed
contain
content
content-box
content-distribution
content-list
content-position
content-replacement
contents
context-menu
contextual
contextual-alt-values
contrast
copy
coral
cornflowerblue
cornsilk
counter-increment
counter-reset
counter-style
counter-style-name
cover
crimson
crisp-edges
cross-fade
crosshair
cubic-bezier
cubic-bezier-timing-function
currentcolor
cursive
cursor
cyan
d
darkblue
darkcyan
darken
darkgoldenrod
darkgray
darkgreen
darkgrey
darkkhaki
darkmagenta
darkolivegreen
darkorange
darkorchid
darkred
darksalmon
darkseagreen
darkslateblue
darkslategray
darkslategrey
darkturquoise
darkviolet
dashed
deeppink
deepskyblue
default
default-button
deg
dense
deprecated-system-color
destination-atop
destination-in
destination-out
destination-over
diagonal-fractions
difference
digits
dimgray
dimgrey
direction
disabled
discretionary-ligatures
discretionary-lig-values
display
display-box
display-inside
display-internal
display-legacy
display-listitem
display-outside
dlight-color
document
dodgerblue
domain
dot
dotted
double
double-circle
drag
drop-shadow
dualbutton
each-line
ease
ease-in
ease-in-out
ease-out
east-asian-variant-values
east-asian-width-values
economy
edges
element
ellipse
ellipsis
em
embed
empty-cells
enabled
end
ending-shape
e-resize
even
evenodd
ew-resize
ex
exact
exclude
exclusion
expanded
explicit-track-list
extra-condensed
extra-expanded
fallback
false
family-name
fantasy
far-left
far-right
farthest-corner
farthest-side
feature-tag-value
feature-type
feature-value-block
feature-value-block-list
feature-value-declaration
feature-value-declaration-list
feature-value-name
fill
fill-available
fill-box
filled
fill-opacity
fill-rule
filter
filter-function
filter-function-list
final-bg-layer
firebrick
first
first-letter
fit-content
fixed
fixed-breadth
fixed-repeat
fixed-size
flat
flex
flex-basis
flex-direction
flex-end
flex-flow
flex-grow
flex-shrink
flex-start
flex-wrap
flip
float
floralwhite
flow
flow-root
font
font-face
font-family
font-feature-settings
font-feature-values
font-kerning
font-language-override
font-optical-sizing
font-size
font-size-adjust
font-stretch
font-stretch-absolute
font-style
font-synthesis
font-variant
font-variant-alternates
font-variant-caps
font-variant-css
font-variant-east-asian
font-variant-ligatures
font-variant-numeric
font-variant-position
font-variation-settings
font-weight
font-weight-absolute
force-end
forestgreen
forwards
frames
frames-timing-function
frequency
frequency-percentage
from
from-image
fuchsia
full-width
gainsboro
gap
general-enclosed
generic-family
generic-name
geometricPrecision
geometry-box
ghostwhite
gold
goldenrod
grab
grabbing
grad
gradient
gray
grayscale
GrayText
green
greenyellow
grey
grid
grid-area
grid-auto-columns
grid-auto-flow
grid-auto-rows
grid-column
grid-column-end
grid-column-gap
grid-column-start
grid-gap
grid-line
grid-row
grid-row-end
grid-row-gap
grid-row-start
grid-template
grid-template-areas
grid-template-columns
grid-template-rows
grippers
groove
groupbox
hanging
hanging-punctuation
hard-light
height
help
hidden
hide
Highlight
HighlightText
historical-forms
historical-ligatures
historical-lig-values
honeydew
horizontal
horizontal-tb
hotpink
hsl
hsla
hue
hue-rotate
hyphens
Hz
i
icon
ideograph-alpha
ideographic
ideograph-numeric
ideograph-parenthesis
ideograph-space
id-selector
ignore
image
image-orientation
image-rendering
image-resolution
image-set
image-set-option
ime-mode
import
in
inactive
InactiveBorder
InactiveCaption
InactiveCaptionText
indianred
indigo
infinite
inflexible-breadth
InfoBackground
InfoText
inherit
initial
initial-letter
initial-letter-align
inline
inline-axis
inline-block
inline-end
inline-flex
inline-grid
inline-list-item
inline-size
inline-start
inline-table
inner-spin-button
inset
inside
integer
inter-character
intersect
inter-word
invert
isolate
isolate-override
isolation
italic
ivory
jis
justify
justify-content
justify-items
justify-self
keep-all
keyframe-block
keyframe-block-list
keyframes
keyframe-selector
keyframes-name
khaki
kHz
large
larger
last
lavender
lavenderblush
lawngreen
layout
leader
leader-type
leading-spaces
left
left-bottom
left-middle
left-side
left-top
leftwards
legacy
lemonchiffon
length
length-percentage
letter-spacing
lightblue
lightcoral
lightcyan
lighten
lighter
lightgoldenrodyellow
lightgray
lightgreen
lightgrey
lightpink
lightsalmon
lightseagreen
lightskyblue
lightslategray
lightslategrey
lightsteelblue
lightyellow
lime
limegreen
linear
linear-gradient
line-break
line-clamp
line-height
line-height-step
linen
line-name-list
line-names
line-through
lining-nums
listbox
listitem
list-item
list-style
list-style-image
list-style-position
list-style-type
local
loose
lowercase
lr
ltr
luminance
luminosity
magenta
mandatory
manipulation
manual
margin
margin-block-end
margin-block-start
margin-bottom
margin-box
margin-inline-end
margin-inline-start
margin-left
margin-right
margin-top
markers
maroon
mask
mask-border
mask-border-mode
mask-border-outset
mask-border-repeat
mask-border-slice
mask-border-source
mask-border-width
mask-clip
mask-composite
mask-image
masking-mode
mask-layer
mask-mode
mask-origin
mask-position
mask-reference
mask-repeat
mask-size
mask-source
mask-type
match-parent
match-source
matrix
max-block-size
max-content
max-height
maximum
max-inline-size
max-lines
max-width
media
media-and
media-condition
media-condition-without-or
media-controls-background
media-controls-fullscreen-background
media-current-time-display
media-enter-fullscreen-button
media-exit-fullscreen-button
media-feature
media-fullscreen-button
media-in-parens
media-mute-button
media-not
media-or
media-overlay-play-button
media-play-button
media-query
media-query-list
media-seek-back-button
media-seek-forward-button
media-slider
media-sliderthumb
media-time-remaining-display
media-toggle-closed-captions-button
media-type
media-volume-slider
media-volume-slider-container
media-volume-sliderthumb
medium
mediumaquamarine
mediumblue
mediumorchid
mediumpurple
mediumseagreen
mediumslateblue
mediumspringgreen
mediumturquoise
mediumvioletred
menu
Menu
menuarrow
menubar
menucheckbox
menuimage
menuitem
menuitemtext
menulist
menulist-button
menulist-text
menulist-textfield
menupopup
menuradio
menuseparator
MenuText
message-box
meter
meterbar
meterchunk
mf-boolean
mf-name
mf-plain
mf-range
mf-value
middle
midnightblue
min-block-size
min-content
min-height
min-inline-size
minmax
mintcream
min-width
mistyrose
mix-blend-mode
mixed
mm
moccasin
monospace
move
moz-appearance
moz-binding
moz-border-bottom-colors
moz-border-left-colors
moz-border-right-colors
moz-border-top-colors
moz-context-properties
moz-float-edge
moz-force-broken-image-icon
moz-image-region
moz-mac-unified-toolbar
moz-orient
moz-outline-radius
moz-outline-radius-bottomleft
moz-outline-radius-bottomright
moz-outline-radius-topleft
moz-outline-radius-topright
moz-stack-sizing
moz-text-blink
moz-user-focus
moz-user-input
moz-user-modify
moz-win-borderless-glass
moz-win-browsertabbar-toolbox
moz-win-communicationstext
moz-win-communications-toolbox
moz-window-button-box
moz-window-button-box-maximized
moz-window-button-close
moz-window-button-maximize
moz-window-button-minimize
moz-window-button-restore
moz-window-dragging
moz-window-frame-bottom
moz-window-frame-left
moz-window-frame-right
moz-window-shadow
moz-window-titlebar
moz-window-titlebar-maximized
moz-win-exclude-glass
moz-win-glass
moz-win-mediatext
moz-win-media-toolbox
ms
ms-accelerator
ms-autohiding-scrollbar
ms-block-progression
ms-content-zoom-chaining
ms-content-zooming
ms-content-zoom-limit
ms-content-zoom-limit-max
ms-content-zoom-limit-min
ms-content-zoom-snap
ms-content-zoom-snap-points
ms-content-zoom-snap-type
ms-filter
ms-flow-from
ms-flow-into
ms-high-contrast-adjust
ms-hyphenate-limit-chars
ms-hyphenate-limit-lines
ms-hyphenate-limit-zone
ms-ime-align
ms-overflow-style
ms-scrollbar
ms-scrollbar-arrow-color
ms-scrollbar-base-color
ms-scrollbar-darkshadow-color
ms-scrollbar-face-color
ms-scrollbar-highlight-color
ms-scrollbar-shadow-color
ms-scrollbar-track-color
ms-scroll-chaining
ms-scroll-limit
ms-scroll-limit-x-max
ms-scroll-limit-x-min
ms-scroll-limit-y-max
ms-scroll-limit-y-min
ms-scroll-rails
ms-scroll-snap-points-x
ms-scroll-snap-points-y
ms-scroll-snap-type
ms-scroll-snap-x
ms-scroll-snap-y
ms-scroll-translation
ms-text-autospace
ms-touch-select
ms-user-select
ms-wrap-flow
ms-wrap-margin
ms-wrap-through
multiple
multiply
named-color
namespace
namespace-prefix
navajowhite
navy
negative
ne-resize
nesw-resize
no-clip
no-close-quote
no-common-ligatures
no-contextual
no-discretionary-ligatures
no-drag
no-drop
no-historical-ligatures
no-limit
none
nonzero
no-open-quote
no-repeat
normal
not
not-allowed
nowrap
n-resize
ns-prefix
ns-resize
nth
number
number-percentage
numeric-figure-values
numeric-fraction-values
numeric-spacing-values
nw-resize
nwse-resize
object-fit
object-position
objects
oblique
odd
off
offset
offset-anchor
offset-block-end
offset-block-start
offset-distance
offset-inline-end
offset-inline-start
offset-path
offset-position
offset-rotate
oldlace
oldstyle-nums
olive
olivedrab
on
only
opacity
open
open-quote
optimizeLegibility
optimizeSpeed
or
orange
orangered
orchid
order
ordinal
ornaments
orphans
outline
outline-color
outline-offset
outline-radius
outline-style
outline-width
outset
outside
over
overflow
overflow-anchor
overflow-block
overflow-clip-box
overflow-inline
overflow-position
overflow-wrap
overflow-x
overflow-y
overlay
overline
overscroll-behavior
overscroll-behavior-x
overscroll-behavior-y
pad
padding
padding-block-end
padding-block-start
padding-bottom
padding-box
padding-inline-end
padding-inline-start
padding-left
padding-right
padding-top
page
page-body
page-break-after
page-break-before
page-break-inside
page-margin-box
page-margin-box-type
page-selector
page-selector-list
paint
painted
paint-order
palegoldenrod
palegreen
paleturquoise
palevioletred
pan-down
pan-left
pan-right
pan-up
pan-x
pan-y
papayawhip
paused
pc
peachpuff
perspective
perspective-origin
peru
petite-caps
pinch-zoom
pink
pixelated
place-content
plaintext
plum
pointer
pointer-events
polygon
position
powderblue
pre
prefix
pre-line
preserve
pre-wrap
progress
progressbar
progress-bar
progress-bar-value
progressbar-vertical
progresschunk
progresschunk-vertical
proportional-nums
proportional-width
proximity
pseudo-class-selector
pseudo-element-selector
pseudo-page
pt
purple
push-button
px
q
quote
quotes
rad
radial-gradient
radio
radio-container
radio-label
radiomenuitem
railed
range
range-thumb
ray
read-only
read-write
read-write-plaintext-only
rebeccapurple
rect
recto
red
regexp
region
relative
relative-size
rem
repeat
repeating-linear-gradient
repeating-radial-gradient
repeat-style
repeat-x
repeat-y
reset
resize
resizer
resizerpanel
reverse
revert
rgb
rgba
ridge
right
right-bottom
right-middle
right-side
right-top
rightwards
rl
rosybrown
rotate
rotateX
rotateY
rotateZ
round
row
row-gap
row-resize
row-reverse
royalblue
rtl
ruby
ruby-align
ruby-base
ruby-base-container
ruby-merge
ruby-position
ruby-text
ruby-text-container
run-in
running
s
saddlebrown
safe
salmon
sandybrown
sans-serif
saturate
saturation
scale
scale-down
scale-horizontal
scalethumbend
scalethumb-horizontal
scalethumbstart
scalethumbtick
scalethumb-vertical
scale-vertical
scaleX
scaleY
scaleZ
screen
scroll
scrollbar
Scrollbar
scrollbarbutton-down
scrollbarbutton-left
scrollbarbutton-right
scrollbarbutton-up
scrollbarthumb-horizontal
scrollbarthumb-vertical
scrollbartrack-horizontal
scrollbartrack-vertical
scroll-behavior
scroll-position
scroll-snap-coordinate
scroll-snap-destination
scroll-snap-points-x
scroll-snap-points-y
scroll-snap-type
scroll-snap-type-x
scroll-snap-type-y
seagreen
searchfield
searchfield-cancel-button
searchfield-decoration
searchfield-results-button
searchfield-results-decoration
seashell
select-after
select-all
select-before
select-menu
select-same
self-end
self-position
self-start
semi-condensed
semi-expanded
separate
separator
sepia
se-resize
serif
sesame
shadow
shadow-t
shape
shape-box
shape-image-threshold
shape-margin
shape-outside
shape-radius
sheet
show
side-or-corner
sideways
sideways-lr
sideways-rl
sienna
silver
simplified
single
single-animation
single-animation-direction
single-animation-fill-mode
single-animation-iteration-count
single-animation-play-state
single-timing-function
single-transition
single-transition-property
single-transition-timing-function
size
skew
skewX
skewY
skyblue
slashed-zero
slateblue
slategray
slategrey
slice
slider-horizontal
sliderthumb-horizontal
sliderthumb-vertical
slider-vertical
small
small-caps
small-caption
smaller
smooth
snap
snapInterval
snapList
snow
soft-light
solid
source-atop
source-in
source-out
source-over
space
space-around
space-between
space-evenly
spaces
span
speak-as
spinner
spinner-downbutton
spinner-textfield
spinner-upbutton
splitter
springgreen
square-button
src
s-resize
stacked-fractions
start
static
statusbar
status-bar
statusbarpanel
steelblue
step-end
steps
step-start
step-timing-function
sticky
stretch
stretch-to-fit
strict
string
stroke
stroke-box
stroke-opacity
style
styleset
stylistic
sub
subclass-selector
subgrid
subtract
suffix
super
supports
swash
sw-resize
symbol
symbols
system
tab
table
table-caption
table-cell
table-column
table-column-group
table-footer-group
table-header-group
table-layout
table-row
table-row-group
tabpanel
tabpanels
tab-scroll-arrow-back
tab-scroll-arrow-forward
tab-size
tabular-nums
tan
target
target-counter
target-counters
target-text
tb
teal
text
text-align
text-align-last
textarea
text-bottom
text-combine-upright
text-decoration
text-decoration-color
text-decoration-line
text-decoration-skip
text-decoration-skip-ink
text-decoration-style
text-emphasis
text-emphasis-color
text-emphasis-position
text-emphasis-style
textfield
textfield-multiline
text-indent
text-justify
text-orientation
text-overflow
text-rendering
text-shadow
text-size-adjust
text-top
text-transform
text-underline-position
thick
thin
thistle
ThreeDDarkShadow
ThreeDFace
ThreeDHighlight
ThreeDLightShadow
ThreeDShadow
time
time-percentage
titling-caps
to
tomato
toolbar
toolbarbutton
toolbarbutton-dropdown
toolbargripper
toolbox
tooltip
top
top-center
top-left
top-left-corner
top-right
top-right-corner
touch
touch-action
track-breadth
track-list
track-repeat
track-size
traditional
trailing-spaces
transform
transform-box
transform-function
transform-list
transform-origin
transform-style
transition
transition-delay
transition-duration
transition-property
transition-timing-function
translate
translateX
translateY
translateZ
transparent
treeheader
treeheadercell
treeheadersortarrow
treeitem
treeline
treetwisty
treetwistyopen
treeview
triangle
true
turquoise
type-or-unit
type-selector
ultra-condensed
ultra-expanded
under
underline
unicase
unicode-bidi
unicode-range
unsafe
unset
uppercase
upright
url
url-prefix
user-select
var
verso
vertical
vertical-align
vertical-lr
vertical-rl
vertical-text
vertical-to-horizontal
vh
view-box
viewport
viewport-length
violet
visibility
visible
visibleFill
visiblePainted
visibleStroke
vmax
vmin
vw
wait
wavy
webkit-appearance
webkit-border-before
webkit-border-before-color
webkit-border-before-style
webkit-border-before-width
webkit-box-reflect
webkit-mask
webkit-mask-attachment
webkit-mask-clip
webkit-mask-composite
webkit-mask-image
webkit-mask-origin
webkit-mask-position
webkit-mask-position-x
webkit-mask-position-y
webkit-mask-repeat
webkit-mask-repeat-x
webkit-mask-repeat-y
webkit-mask-size
webkit-overflow-scrolling
webkit-tap-highlight-color
webkit-text-fill-color
webkit-text-stroke
webkit-text-stroke-color
webkit-text-stroke-width
webkit-touch-callout
webkit-user-modify
weight
wheat
white
whitesmoke
white-space
widows
width
will-change
Window
WindowFrame
WindowText
word-break
word-spacing
word-wrap
wq-name
wrap
wrap-reverse
w-resize
write-only
writing-mode
x
x-end
x-large
xor
x-small
x-start
xx-large
xx-small
y
yellow
yellowgreen
y-end
y-start
z
z-index
zoom
zoom-in
zoom-out
"""

CSS_KEYWORDS_IGNORE = {"type-or-unit"}

KEYWORDS: List[str] = sorted(
    set(
        list(set(CSS_KEYWORDS.split()) - CSS_KEYWORDS_IGNORE)
        + MEDIA_QUERIES_KEYWORDS.split()
        + VENDOR_PREFIXES.split()
        + TAGS
    )
)
