<?php

declare(strict_types=1);

namespace Turanjanin\SerbianLanguageTools\Transformers;

class ToLatin extends WordTransformer
{
    protected function getMap(): array
    {
        return [
            'А' => 'A',
            'Б' => 'B',
            'В' => 'V',
            'Г' => 'G',
            'Д' => 'D',
            'Ђ' => 'Đ',
            'Е' => 'E',
            'Ж' => 'Ž',
            'З' => 'Z',
            'И' => 'I',
            'Ј' => 'J',
            'К' => 'K',
            'Л' => 'L',
            'Љ' => 'LJ',
            'М' => 'M',
            'Н' => 'N',
            'Њ' => 'NJ',
            'О' => 'O',
            'П' => 'P',
            'Р' => 'R',
            'С' => 'S',
            'Т' => 'T',
            'Ћ' => 'Ć',
            'У' => 'U',
            'Ф' => 'F',
            'Х' => 'H',
            'Ц' => 'C',
            'Ч' => 'Č',
            'Џ' => 'DŽ',
            'Ш' => 'Š',
            'а' => 'a',
            'б' => 'b',
            'в' => 'v',
            'г' => 'g',
            'д' => 'd',
            'ђ' => 'đ',
            'е' => 'e',
            'ж' => 'ž',
            'з' => 'z',
            'и' => 'i',
            'ј' => 'j',
            'к' => 'k',
            'л' => 'l',
            'љ' => 'lj',
            'м' => 'm',
            'н' => 'n',
            'њ' => 'nj',
            'о' => 'o',
            'п' => 'p',
            'р' => 'r',
            'с' => 's',
            'т' => 't',
            'ћ' => 'ć',
            'у' => 'u',
            'ф' => 'f',
            'х' => 'h',
            'ц' => 'c',
            'ч' => 'č',
            'џ' => 'dž',
            'ш' => 'š',
            'Ња' => 'Nja',
            'Ње' => 'Nje',
            'Њи' => 'Nji',
            'Њо' => 'Njo',
            'Њу' => 'Nju',
            'Ља' => 'Lja',
            'Ље' => 'Lje',
            'Љи' => 'Lji',
            'Љо' => 'Ljo',
            'Љу' => 'Lju',
            'Џа' => 'Dža',
            'Џе' => 'Dže',
            'Џи' => 'Dži',
            'Џо' => 'Džo',
            'Џу' => 'Džu',
        ];
    }
}
