# 🗈 Confluence API Helper Functions
Welcome to the Confluence Server REST API Helper Functions repository! This comprehensive collection of helper functions is designed to simplify and streamline your interactions with the Confluence Server REST API. Whether you're a developer building integrations, automating tasks, or creating custom applications on top of Confluence Server, these helper functions provide a convenient and efficient way to interact with the API.

Get started today by exploring the repository, checking out the documentation, and leveraging the power of Confluence Server REST API Helper Functions to supercharge your Confluence Server development experience.


# Confluence Server REST API Documentation
[https://developer.atlassian.com/server/confluence/confluence-rest-api-examples/](https://developer.atlassian.com/server/confluence/confluence-rest-api-examples/)

# Confluence Server Docker Setup
[https://hub.docker.com/r/atlassian/confluence-server/](https://hub.docker.com/r/atlassian/confluence-server/)
```
docker run -v /data/your-confluence-home:/var/atlassian/application-data/confluence --name="confluence" -d -p 8090:8090 -p 8091:8091 atlassian/confluence
```

## PHP
[Get Number of Attachments of a page](php/get_number_of_attachments_of_a_page.php)

## JAVA
[Get Number of Attachments of a page](java/get_number_of_attachments_of_a_page.java)

## Python
[Get Number of Attachments of a page](python/get_number_of_attachments_of_a_page.py)

## Node.js
[Get Number of Attachments of a page](node/get_number_of_attachments_of_a_page.js)

## API
coming soon

## Todo
- [ ] Get Page Content  
- [ ] Get Page Children
- [ ] Get Number of Children of a page
- [ ] Get Page Attachments 
- [x] Get Number of Attachments of a page
- [ ] Get Space Tree  


## Feedback
Please create a GitHub Issue for any bugs, feature requests, etc. Happy to accept pull requests too!

## Contribute
If you would like to Contribute to this project please follow the guide lines described on the [Contribution page](CONTRIBUTING.md)


## Thank you for the Support
- ⭐ Give this repo a ⭐ star ⭐ at the top of the page
- 🐦 Follow me on twitter [twitter](https://twitter.com/tshenolo)
- 📺 Subscribe to my [Youtube channel](https://www.youtube.com/@tshenolo?sub_confirmation=1)



