// ReSharper disable once CheckNamespace
namespace LangChain.Providers.Amazon.Bedrock.Predefined.Anthropic;

/// <inheritdoc />
public class ClaudeInstantV1Model(BedrockProvider provider)
    : AnthropicClaudeChatModel(provider, id: "anthropic.claude-instant-v1");

/// <inheritdoc />
public class ClaudeV2Model(BedrockProvider provider)
    : AnthropicClaudeChatModel(provider, id: "anthropic.claude-v2");

/// <inheritdoc />
public class ClaudeV21Model(BedrockProvider provider)
    : AnthropicClaudeChatModel(provider, id: "anthropic.claude-v2:1");

/// <inheritdoc />
public class Claude3SonnetModel(BedrockProvider provider)
    : AnthropicClaude3ChatModel(provider, id: "anthropic.claude-3-sonnet-20240229-v1:0");

/// <inheritdoc />
public class Claude3HaikuModel(BedrockProvider provider)
    : AnthropicClaude3ChatModel(provider, id: "anthropic.claude-3-haiku-20240307-v1:0");

/// <inheritdoc />
public class Claude3OpusModel(BedrockProvider provider)
    : AnthropicClaude3ChatModel(provider, id: "anthropic.claude-3-opus-20240229-v1:0");

/// <inheritdoc />
public class Claude35SonnetModel(BedrockProvider provider)
    : AnthropicClaude3ChatModel(provider, id: "anthropic.claude-3-5-sonnet-20240620-v1:0");