// ReSharper disable once CheckNamespace
// ReSharper disable ConditionalAccessQualifierIsNonNullableAccordingToAPIContract
namespace LangChain.Providers;

#pragma warning disable CA2225

/// <summary>
/// 
/// </summary>
public class ChatResponse
{
    /// <summary>
    /// 
    /// </summary>
    public required IReadOnlyList<Message> Messages { get; init; }

    /// <summary>
    /// 
    /// </summary>
    public required ChatSettings UsedSettings { get; init; }

    /// <summary>
    /// 
    /// </summary>
    public ChatResponseDelta? Delta { get; init; }

    /// <inheritdoc cref="ChatResponseFinishReason"/>
    public ChatResponseFinishReason? FinishReason { get; init; }

    /// <summary>
    /// 
    /// </summary>
    public Usage Usage { get; init; } = Usage.Empty;

    /// <summary>
    /// Tool calls generated by the model. Contains the id, the name and arguments of a function that should be called.
    /// </summary>
    public IReadOnlyList<ChatToolCall> ToolCalls { get; set; } = [];

    /// <summary>
    /// Returns the last message content or string.Empty.
    /// </summary>
    public string LastMessageContent => LastMessage?.Content ?? string.Empty;

    /// <summary>
    /// Returns the last message or null.
    /// </summary>
    public Message? LastMessage => Messages.Count == 0
        ? null
        : Messages[^1];

    /// <inheritdoc />
    public override string ToString()
    {
        if (Delta != null)
        {
            return Delta.ToString();
        }

        return LastMessageContent;
    }

    public void Deconstruct(
        out Message message,
        out Usage usage)
    {
        message = LastMessage ?? Message.Empty;
        usage = Usage;
    }

    public void Deconstruct(
        out Message message,
        out Usage usage,
        out ChatSettings usedSettings)
    {
        message = LastMessage ?? Message.Empty;
        usage = Usage;
        usedSettings = UsedSettings;
    }

    public static implicit operator Message[](ChatResponse response)
    {
        return response?.Messages.ToArray() ?? [];
    }

    public static implicit operator Message(ChatResponse response)
    {
        return response?.LastMessage ?? Message.Empty;
    }

    public static implicit operator string(ChatResponse response)
    {
        return response?.ToString() ?? string.Empty;
    }

    public static implicit operator Usage(ChatResponse response)
    {
        return response?.Usage ?? Usage.Empty;
    }
}