
#nullable enable

namespace Cohere
{
    /// <summary>
    /// 
    /// </summary>
    public enum TextContentType
    {
        /// <summary>
        /// 
        /// </summary>
        Text,
    }

    /// <summary>
    /// Enum extensions to do fast conversions without the reflection.
    /// </summary>
    public static class TextContentTypeExtensions
    {
        /// <summary>
        /// Converts an enum to a string.
        /// </summary>
        public static string ToValueString(this TextContentType value)
        {
            return value switch
            {
                TextContentType.Text => "text",
                _ => throw new global::System.ArgumentOutOfRangeException(nameof(value), value, null),
            };
        }
        /// <summary>
        /// Converts an string to a enum.
        /// </summary>
        public static TextContentType? ToEnum(string value)
        {
            return value switch
            {
                "text" => TextContentType.Text,
                _ => null,
            };
        }
    }
}