
#nullable enable

namespace Cohere
{
    /// <summary>
    /// 
    /// </summary>
    public enum DocumentContentType
    {
        /// <summary>
        /// 
        /// </summary>
        Document,
    }

    /// <summary>
    /// Enum extensions to do fast conversions without the reflection.
    /// </summary>
    public static class DocumentContentTypeExtensions
    {
        /// <summary>
        /// Converts an enum to a string.
        /// </summary>
        public static string ToValueString(this DocumentContentType value)
        {
            return value switch
            {
                DocumentContentType.Document => "document",
                _ => throw new global::System.ArgumentOutOfRangeException(nameof(value), value, null),
            };
        }
        /// <summary>
        /// Converts an string to a enum.
        /// </summary>
        public static DocumentContentType? ToEnum(string value)
        {
            return value switch
            {
                "document" => DocumentContentType.Document,
                _ => null,
            };
        }
    }
}