/*
 * Contains interfaces used by the autogenerated RPC mechanism for IO.
 */
#ifndef LIBRPC_RT_RPCIOSTREAM_H
#define LIBRPC_RT_RPCIOSTREAM_H

#include <cstddef>
#include <span>

namespace rpc::rt {
/**
 * Abstract interface for an RPC client's IO stream.
 */
class ClientRpcIoStream {
    public:
        virtual ~ClientRpcIoStream() = default;

        /// Send the serialized request to the remote connection
        virtual bool sendRequest(const std::span<std::byte> &buf) = 0;
        /// Receive a reply from the remote connection
        virtual bool receiveReply(std::span<std::byte> &outRxBuf) = 0;
};


/**
 * Abstract interface for an RPC server's IO stream
 */
class ServerRpcIoStream {
    public:
        virtual ~ServerRpcIoStream() = default;

        /// Pop oldest message from receive queue
        virtual bool receive(std::span<std::byte> &outRxBuf, const bool block) = 0;
        /// Send a reply to the most recently received message
        virtual bool reply(const std::span<std::byte> &buf) = 0;
};
}

#endif
