/*
 * This RPC client stub was autogenerated by idlc (version c8601c6e). DO NOT EDIT!
 * Generated from Display.idl for interface Display at 2021-07-08T01:00:48-0500
 *
 * You may use these generated stubs directly as the RPC interface, or you can subclass it to
 * override the behavior of the function calls, or to perform some preprocessing to the data as
 * needed before sending it.
 *
 * See the full RPC documentation for more details.
 */
#include "Client_Display.hpp"
#include "RpcHelpers_Display.hpp"

#include <algorithm>
#include <cstddef>
#include <cstdint>
#include <cstdio>
#include <cstdlib>
#include <cstring>

#include <rpc/rt/RpcIoStream.hpp>

using namespace rpc;

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-variable"
using Client = DisplayClient;

// stubs for custom type serialization
template<typename... _blah>
constexpr auto TemplatedFalseFlag = false;

/// Given a byte range, decodes the given type
template<typename T>
inline bool deserialize(const std::span<std::byte> &, T &) {
    static_assert(TemplatedFalseFlag<T>, "rpc::deserialize not implemented for custom type");
}
/// Determine how many bytes of memory are required to serialize the given type.
template<typename T>
inline size_t bytesFor(const T &) {
    static_assert(TemplatedFalseFlag<T>, "rpc::bytesFor not implemented for custom type");
}
/// Encodes the given type into the provided region of memory
template<typename T>
inline bool serialize(std::span<std::byte> &, const T &) {
    static_assert(TemplatedFalseFlag<T>, "rpc::serialize not implemented for custom type");
}
/**
 * Creates a new client instance, with the given IO stream.
 */
Client::DisplayClient(const std::shared_ptr<IoStream> &stream) : io(stream) {
}

/**
 * Shuts down the RPC client, releasing any allocated resources.
 */
Client::~DisplayClient() {
    free(this->txBuf);
}

/// Sends the message that's been built up in the transmit message buffer.
uint32_t Client::_sendRequest(const uint64_t type, const size_t payloadBytes) {
    const size_t len = sizeof(MessageHeader) + payloadBytes;

    const auto tag = __atomic_add_fetch(&this->nextTag, 1, __ATOMIC_RELAXED);
    auto hdr = reinterpret_cast<MessageHeader *>(this->txBuf);
    memset(hdr, 0, sizeof(*hdr));
    hdr->type = type;
    hdr->flags = MessageHeader::Flags::Request;
    hdr->tag = tag;

    const std::span<std::byte> txBufSpan(reinterpret_cast<std::byte *>(this->txBuf), len);
    if(!this->io->sendRequest(txBufSpan)) {
        this->_HandleError(true, "Failed to send RPC request");
        return 0;
    }

    return tag;
}

// Allocates an aligned transmit buffer of the given size
void Client::_ensureTxBuf(const size_t payloadBytes) {
    const size_t len = sizeof(MessageHeader) + payloadBytes + 16;
    if(len > this->txBufSize) {
        free(this->txBuf);
        int err = posix_memalign(&this->txBuf, 16, len);
        if(err) {
            return this->_HandleError(true, "Failed to allocate RPC send buffer");
        }
        this->txBufSize = len;
    }
}

/**
 * Handles an error that occurred on the client connection. Implementations may override this
 * method if they want to use exceptions, for example.
 *
 * @param fatal If set, the error precludes further operation on this RPC connection
 * @param what Descriptive string for the error
 */
void Client::_HandleError(const bool fatal, const std::string_view &what) {
    fprintf(stderr, "[RPCC] %s: Encountered %s RPC error: %s\n", kServiceName.data(),
        fatal ? "fatal" : "recoverable", what.data());
    if(fatal) exit(-1);
}
/*
 * Autogenerated call method for 'GetDeviceCapabilities' (id $b3be16a171616697)
 * Have 0 parameter(s), 2 return(s); method is sync
 */
Client::GetDeviceCapabilitiesReturn Client::GetDeviceCapabilities() {
    uint32_t sentTag;
    {
        internals::GetDeviceCapabilitiesRequest request;

        const auto numBytes = bytesFor(request);
        this->_ensureTxBuf(numBytes);

        auto packet = reinterpret_cast<MessageHeader *>(this->txBuf);
        std::span<std::byte> data(packet->payload, numBytes);
        serialize(data, request);
        sentTag = this->_sendRequest(static_cast<uint64_t>(internals::Type::GetDeviceCapabilities), numBytes);
    }
    {
        std::span<std::byte> buf;
        if(!this->io->receiveReply(buf)) this->_HandleError(false, "Failed to receive RPC reply");
        if(buf.size() < sizeof(MessageHeader)) this->_HandleError(false, "Received message too small");
        const auto hdr = reinterpret_cast<const MessageHeader *>(buf.data());
        if(hdr->tag != sentTag) this->_HandleError(false, "Invalid tag in reply RPC packet");
        else if(hdr->type != static_cast<uint64_t>(internals::Type::GetDeviceCapabilities)) this->_HandleError(false, "Invalid type in reply RPC packet");
        const auto payload = buf.subspan(offsetof(MessageHeader, payload));

        internals::GetDeviceCapabilitiesResponse reply;
        if(!deserialize(payload, reply)) this->_HandleError(false, "Failed to decode message");
        GetDeviceCapabilitiesReturn r;
        r.status =  reply.status;
        r.caps =  reply.caps;
        return r;

    }
}
/*
 * Autogenerated call method for 'SetOutputEnabled' (id $d3ddaaa17cd66af0)
 * Have 1 parameter(s), 1 return(s); method is sync
 */
int32_t Client::SetOutputEnabled(bool enabled) {
    uint32_t sentTag;
    {
        internals::SetOutputEnabledRequest request;
        request.enabled = enabled;

        const auto numBytes = bytesFor(request);
        this->_ensureTxBuf(numBytes);

        auto packet = reinterpret_cast<MessageHeader *>(this->txBuf);
        std::span<std::byte> data(packet->payload, numBytes);
        serialize(data, request);
        sentTag = this->_sendRequest(static_cast<uint64_t>(internals::Type::SetOutputEnabled), numBytes);
    }
    {
        std::span<std::byte> buf;
        if(!this->io->receiveReply(buf)) this->_HandleError(false, "Failed to receive RPC reply");
        if(buf.size() < sizeof(MessageHeader)) this->_HandleError(false, "Received message too small");
        const auto hdr = reinterpret_cast<const MessageHeader *>(buf.data());
        if(hdr->tag != sentTag) this->_HandleError(false, "Invalid tag in reply RPC packet");
        else if(hdr->type != static_cast<uint64_t>(internals::Type::SetOutputEnabled)) this->_HandleError(false, "Invalid type in reply RPC packet");
        const auto payload = buf.subspan(offsetof(MessageHeader, payload));

        internals::SetOutputEnabledResponse reply;
        if(!deserialize(payload, reply)) this->_HandleError(false, "Failed to decode message");
        return reply.status;
    }
}
/*
 * Autogenerated call method for 'SetOutputMode' (id $f472a05edc874b12)
 * Have 1 parameter(s), 1 return(s); method is sync
 */
int32_t Client::SetOutputMode(const DriverSupport::gfx::DisplayMode &mode) {
    uint32_t sentTag;
    {
        internals::SetOutputModeRequest request;
        request.mode = mode;

        const auto numBytes = bytesFor(request);
        this->_ensureTxBuf(numBytes);

        auto packet = reinterpret_cast<MessageHeader *>(this->txBuf);
        std::span<std::byte> data(packet->payload, numBytes);
        serialize(data, request);
        sentTag = this->_sendRequest(static_cast<uint64_t>(internals::Type::SetOutputMode), numBytes);
    }
    {
        std::span<std::byte> buf;
        if(!this->io->receiveReply(buf)) this->_HandleError(false, "Failed to receive RPC reply");
        if(buf.size() < sizeof(MessageHeader)) this->_HandleError(false, "Received message too small");
        const auto hdr = reinterpret_cast<const MessageHeader *>(buf.data());
        if(hdr->tag != sentTag) this->_HandleError(false, "Invalid tag in reply RPC packet");
        else if(hdr->type != static_cast<uint64_t>(internals::Type::SetOutputMode)) this->_HandleError(false, "Invalid type in reply RPC packet");
        const auto payload = buf.subspan(offsetof(MessageHeader, payload));

        internals::SetOutputModeResponse reply;
        if(!deserialize(payload, reply)) this->_HandleError(false, "Failed to decode message");
        return reply.status;
    }
}
/*
 * Autogenerated call method for 'RegionUpdated' (id $f470173c1b34148a)
 * Have 4 parameter(s), 1 return(s); method is sync
 */
int32_t Client::RegionUpdated(int32_t x, int32_t y, uint32_t w, uint32_t h) {
    uint32_t sentTag;
    {
        internals::RegionUpdatedRequest request;
        request.x = x;
        request.y = y;
        request.w = w;
        request.h = h;

        const auto numBytes = bytesFor(request);
        this->_ensureTxBuf(numBytes);

        auto packet = reinterpret_cast<MessageHeader *>(this->txBuf);
        std::span<std::byte> data(packet->payload, numBytes);
        serialize(data, request);
        sentTag = this->_sendRequest(static_cast<uint64_t>(internals::Type::RegionUpdated), numBytes);
    }
    {
        std::span<std::byte> buf;
        if(!this->io->receiveReply(buf)) this->_HandleError(false, "Failed to receive RPC reply");
        if(buf.size() < sizeof(MessageHeader)) this->_HandleError(false, "Received message too small");
        const auto hdr = reinterpret_cast<const MessageHeader *>(buf.data());
        if(hdr->tag != sentTag) this->_HandleError(false, "Invalid tag in reply RPC packet");
        else if(hdr->type != static_cast<uint64_t>(internals::Type::RegionUpdated)) this->_HandleError(false, "Invalid type in reply RPC packet");
        const auto payload = buf.subspan(offsetof(MessageHeader, payload));

        internals::RegionUpdatedResponse reply;
        if(!deserialize(payload, reply)) this->_HandleError(false, "Failed to decode message");
        return reply.status;
    }
}
/*
 * Autogenerated call method for 'GetFramebuffer' (id $390defeeb047275d)
 * Have 0 parameter(s), 3 return(s); method is sync
 */
Client::GetFramebufferReturn Client::GetFramebuffer() {
    uint32_t sentTag;
    {
        internals::GetFramebufferRequest request;

        const auto numBytes = bytesFor(request);
        this->_ensureTxBuf(numBytes);

        auto packet = reinterpret_cast<MessageHeader *>(this->txBuf);
        std::span<std::byte> data(packet->payload, numBytes);
        serialize(data, request);
        sentTag = this->_sendRequest(static_cast<uint64_t>(internals::Type::GetFramebuffer), numBytes);
    }
    {
        std::span<std::byte> buf;
        if(!this->io->receiveReply(buf)) this->_HandleError(false, "Failed to receive RPC reply");
        if(buf.size() < sizeof(MessageHeader)) this->_HandleError(false, "Received message too small");
        const auto hdr = reinterpret_cast<const MessageHeader *>(buf.data());
        if(hdr->tag != sentTag) this->_HandleError(false, "Invalid tag in reply RPC packet");
        else if(hdr->type != static_cast<uint64_t>(internals::Type::GetFramebuffer)) this->_HandleError(false, "Invalid type in reply RPC packet");
        const auto payload = buf.subspan(offsetof(MessageHeader, payload));

        internals::GetFramebufferResponse reply;
        if(!deserialize(payload, reply)) this->_HandleError(false, "Failed to decode message");
        GetFramebufferReturn r;
        r.status =  reply.status;
        r.handle =  reply.handle;
        r.size =  reply.size;
        return r;

    }
}
/*
 * Autogenerated call method for 'GetFramebufferInfo' (id $b103a5bbd55c1dc9)
 * Have 0 parameter(s), 4 return(s); method is sync
 */
Client::GetFramebufferInfoReturn Client::GetFramebufferInfo() {
    uint32_t sentTag;
    {
        internals::GetFramebufferInfoRequest request;

        const auto numBytes = bytesFor(request);
        this->_ensureTxBuf(numBytes);

        auto packet = reinterpret_cast<MessageHeader *>(this->txBuf);
        std::span<std::byte> data(packet->payload, numBytes);
        serialize(data, request);
        sentTag = this->_sendRequest(static_cast<uint64_t>(internals::Type::GetFramebufferInfo), numBytes);
    }
    {
        std::span<std::byte> buf;
        if(!this->io->receiveReply(buf)) this->_HandleError(false, "Failed to receive RPC reply");
        if(buf.size() < sizeof(MessageHeader)) this->_HandleError(false, "Received message too small");
        const auto hdr = reinterpret_cast<const MessageHeader *>(buf.data());
        if(hdr->tag != sentTag) this->_HandleError(false, "Invalid tag in reply RPC packet");
        else if(hdr->type != static_cast<uint64_t>(internals::Type::GetFramebufferInfo)) this->_HandleError(false, "Invalid type in reply RPC packet");
        const auto payload = buf.subspan(offsetof(MessageHeader, payload));

        internals::GetFramebufferInfoResponse reply;
        if(!deserialize(payload, reply)) this->_HandleError(false, "Failed to decode message");
        GetFramebufferInfoReturn r;
        r.status =  reply.status;
        r.w =  reply.w;
        r.h =  reply.h;
        r.pitch =  reply.pitch;
        return r;

    }
}
#pragma clang diagnostic pop
