/*
 * This RPC serialization code was autogenerated by idlc (version 8a02fc5d). DO NOT EDIT!
 * Generated from DiskDriver.idl for interface DiskDriver at 2021-06-26T17:21:52-0500
 *
 * The structs and methods within are used by the RPC system to serialize and deserialize the
 * arguments and return values on method calls. They work internally in the same way that encoding
 * custom types in RPC messages works.
 *
 * See the full RPC documentation for more details.
 */
#ifndef RPC_HELPERS_GENERATED_17065700451208530523
#define RPC_HELPERS_GENERATED_17065700451208530523

#include <algorithm>
#include <cstddef>
#include <cstdint>
#include <cstdio>
#include <cstring>
#include <string>
#include <span>
#include <string_view>

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-variable"

#define RPC_USER_TYPES_INCLUDES
#include <DriverSupport/disk/Types.h>
#undef RPC_USER_TYPES_INCLUDES


namespace rpc {
/**
 * Method to handle a failure to deserialize a field; this will log the failure if built in debug
 * mode.
 */
static inline void HandleDecodeError(const char *typeName, const char *fieldName,
    const uintptr_t offset) {
    fprintf(stderr, "[RPC] Decode error for type %s, field %s at offset $%x\n", typeName, fieldName,
        offset);
}
static inline void HandleDecodeError(const char *typeName, const char *fieldName,
    const uintptr_t offset, const uint32_t blobDataOffset, const uint32_t blobSz) {
    fprintf(stderr, "[RPC] Decode error for type %s, field %s at offset $%x "
        "(blob offset $%x, $%x bytes)\n", typeName, fieldName, offset, blobDataOffset, blobSz);
}

/*
 * Serialization functions for various C++ built in types
 */
inline size_t bytesFor(const std::string &s) {
    return s.length();
}
inline bool serialize(std::span<std::byte> &out, const std::string &str) {
    if(str.empty()) return true;
    else if(out.size() < str.length()) return false;
    memcpy(out.data(), str.c_str(), str.length());
    return true;
}
inline bool deserialize(const std::span<std::byte> &in, std::string &outStr) {
    if(in.empty()) {
        outStr = "";
    } else {
        outStr = std::string(reinterpret_cast<const char *>(in.data()), in.size());
    }
    return true;
}

// XXX: this only works for POD types!
template<typename T>
inline size_t bytesFor(const std::vector<T> &s) {
    return s.size() * sizeof(T);
}
template<typename T>
inline bool serialize(std::span<std::byte> &out, const std::vector<T> &vec) {
    const size_t numBytes = vec.size() * sizeof(T);
    if(out.size() < numBytes) return false;
    memcpy(out.data(), vec.data(), out.size());
    return true;
}
template <typename T>
inline bool deserialize(const std::span<std::byte> &in, std::vector<T> &outVec) {
    const size_t elements = in.size() / sizeof(T);
    outVec.resize(elements);
    memcpy(outVec.data(), in.data(), in.size());
    return true;
}


/*
 * Definitions of serialization structures for messages and message replies. These use the
 * autogenerated stubs to convert to/from the wire format.
 */
namespace internals {
/// Message ids for each of the RPC messages
enum class Type: uint64_t {
                                         GetCapacity = 0x91df49e5f38b0cb5ULL,
                                         OpenSession = 0xf4e1aa89aee2c5fULL,
                                        CloseSession = 0xbdac3777974760fbULL,
                                    CreateReadBuffer = 0x5c63169ecba56263ULL,
                                   CreateWriteBuffer = 0x2647106809f005fcULL,
                                      ExecuteCommand = 0xaae5bbef0049e019ULL,
                                  ReleaseReadCommand = 0xdcc360757768916aULL,
                                    AllocWriteMemory = 0x3dc1fae0d30f6af6ULL,
};
/**
 * Request structure for method 'GetCapacity'
 */
struct GetCapacityRequest {
    uint64_t diskId;

    constexpr static const size_t kElementSizes[1] {
     8
    };
    constexpr static const size_t kElementOffsets[1] {
     0
    };
    constexpr static const size_t kScalarBytes{8};
    constexpr static const size_t kBlobStartOffset{8};
};
/**
 * Reply structure for method 'GetCapacity'
 */
struct GetCapacityResponse {
    int32_t status;
    uint32_t sectorSize;
    uint64_t numSectors;

    constexpr static const size_t kElementSizes[3] {
     4,  4,  8
    };
    constexpr static const size_t kElementOffsets[3] {
     0,  4,  8
    };
    constexpr static const size_t kScalarBytes{16};
    constexpr static const size_t kBlobStartOffset{16};
};

/**
 * Request structure for method 'OpenSession'
 */
struct OpenSessionRequest {

    constexpr static const size_t kElementSizes[0] {
    
    };
    constexpr static const size_t kElementOffsets[0] {
    
    };
    constexpr static const size_t kScalarBytes{0};
    constexpr static const size_t kBlobStartOffset{0};
};
/**
 * Reply structure for method 'OpenSession'
 */
struct OpenSessionResponse {
    int32_t status;
    uint64_t sessionToken;
    uint64_t regionHandle;
    uint64_t regionSize;
    uint64_t numCommands;

    constexpr static const size_t kElementSizes[5] {
     4,  8,  8,  8,  8
    };
    constexpr static const size_t kElementOffsets[5] {
     0,  4, 12, 20, 28
    };
    constexpr static const size_t kScalarBytes{36};
    constexpr static const size_t kBlobStartOffset{40};
};

/**
 * Request structure for method 'CloseSession'
 */
struct CloseSessionRequest {
    uint64_t session;

    constexpr static const size_t kElementSizes[1] {
     8
    };
    constexpr static const size_t kElementOffsets[1] {
     0
    };
    constexpr static const size_t kScalarBytes{8};
    constexpr static const size_t kBlobStartOffset{8};
};
/**
 * Reply structure for method 'CloseSession'
 */
struct CloseSessionResponse {
    int32_t status;

    constexpr static const size_t kElementSizes[1] {
     4
    };
    constexpr static const size_t kElementOffsets[1] {
     0
    };
    constexpr static const size_t kScalarBytes{4};
    constexpr static const size_t kBlobStartOffset{8};
};

/**
 * Request structure for method 'CreateReadBuffer'
 */
struct CreateReadBufferRequest {
    uint64_t session;
    uint64_t requestedSize;

    constexpr static const size_t kElementSizes[2] {
     8,  8
    };
    constexpr static const size_t kElementOffsets[2] {
     0,  8
    };
    constexpr static const size_t kScalarBytes{16};
    constexpr static const size_t kBlobStartOffset{16};
};
/**
 * Reply structure for method 'CreateReadBuffer'
 */
struct CreateReadBufferResponse {
    int32_t status;
    uint64_t readBufHandle;
    uint64_t readBufMaxSize;

    constexpr static const size_t kElementSizes[3] {
     4,  8,  8
    };
    constexpr static const size_t kElementOffsets[3] {
     0,  4, 12
    };
    constexpr static const size_t kScalarBytes{20};
    constexpr static const size_t kBlobStartOffset{24};
};

/**
 * Request structure for method 'CreateWriteBuffer'
 */
struct CreateWriteBufferRequest {
    uint64_t session;
    uint64_t requestedSize;

    constexpr static const size_t kElementSizes[2] {
     8,  8
    };
    constexpr static const size_t kElementOffsets[2] {
     0,  8
    };
    constexpr static const size_t kScalarBytes{16};
    constexpr static const size_t kBlobStartOffset{16};
};
/**
 * Reply structure for method 'CreateWriteBuffer'
 */
struct CreateWriteBufferResponse {
    int32_t status;
    uint64_t writeBufHandle;
    uint64_t writeBufMaxSize;

    constexpr static const size_t kElementSizes[3] {
     4,  8,  8
    };
    constexpr static const size_t kElementOffsets[3] {
     0,  4, 12
    };
    constexpr static const size_t kScalarBytes{20};
    constexpr static const size_t kBlobStartOffset{24};
};

/**
 * Request structure for method 'ExecuteCommand'
 */
struct ExecuteCommandRequest {
    uint64_t session;
    uint32_t slot;

    constexpr static const size_t kElementSizes[2] {
     8,  4
    };
    constexpr static const size_t kElementOffsets[2] {
     0,  8
    };
    constexpr static const size_t kScalarBytes{12};
    constexpr static const size_t kBlobStartOffset{16};
};

/**
 * Request structure for method 'ReleaseReadCommand'
 */
struct ReleaseReadCommandRequest {
    uint64_t session;
    uint32_t slot;

    constexpr static const size_t kElementSizes[2] {
     8,  4
    };
    constexpr static const size_t kElementOffsets[2] {
     0,  8
    };
    constexpr static const size_t kScalarBytes{12};
    constexpr static const size_t kBlobStartOffset{16};
};

/**
 * Request structure for method 'AllocWriteMemory'
 */
struct AllocWriteMemoryRequest {
    uint64_t session;
    uint64_t bytesRequested;

    constexpr static const size_t kElementSizes[2] {
     8,  8
    };
    constexpr static const size_t kElementOffsets[2] {
     0,  8
    };
    constexpr static const size_t kScalarBytes{16};
    constexpr static const size_t kBlobStartOffset{16};
};
/**
 * Reply structure for method 'AllocWriteMemory'
 */
struct AllocWriteMemoryResponse {
    int32_t status;
    uint64_t offset;
    uint64_t bytesAllocated;

    constexpr static const size_t kElementSizes[3] {
     4,  8,  8
    };
    constexpr static const size_t kElementOffsets[3] {
     0,  4, 12
    };
    constexpr static const size_t kScalarBytes{20};
    constexpr static const size_t kBlobStartOffset{24};
};

} // namespace rpc::internals


inline size_t bytesFor(const internals::GetCapacityRequest &x) {
    using namespace internals;
    size_t len = GetCapacityRequest::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::GetCapacityRequest &x) {
    using namespace internals;
    uint32_t blobOff = GetCapacityRequest::kBlobStartOffset;
    {
        const auto off = GetCapacityRequest::kElementOffsets[0];
        const auto size = GetCapacityRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.diskId, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::GetCapacityRequest &x) {
    using namespace internals;
    if(in.size() < GetCapacityRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(GetCapacityRequest::kBlobStartOffset);
    {
        const auto off = GetCapacityRequest::kElementOffsets[0];
        const auto size = GetCapacityRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.diskId, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::GetCapacityResponse &x) {
    using namespace internals;
    size_t len = GetCapacityResponse::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::GetCapacityResponse &x) {
    using namespace internals;
    uint32_t blobOff = GetCapacityResponse::kBlobStartOffset;
    {
        const auto off = GetCapacityResponse::kElementOffsets[0];
        const auto size = GetCapacityResponse::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.status, range.size());
    }
    {
        const auto off = GetCapacityResponse::kElementOffsets[1];
        const auto size = GetCapacityResponse::kElementSizes[1];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.sectorSize, range.size());
    }
    {
        const auto off = GetCapacityResponse::kElementOffsets[2];
        const auto size = GetCapacityResponse::kElementSizes[2];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.numSectors, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::GetCapacityResponse &x) {
    using namespace internals;
    if(in.size() < GetCapacityResponse::kScalarBytes) return false;
    const auto blobRegion = in.subspan(GetCapacityResponse::kBlobStartOffset);
    {
        const auto off = GetCapacityResponse::kElementOffsets[0];
        const auto size = GetCapacityResponse::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.status, range.data(), range.size());
    }
    {
        const auto off = GetCapacityResponse::kElementOffsets[1];
        const auto size = GetCapacityResponse::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.sectorSize, range.data(), range.size());
    }
    {
        const auto off = GetCapacityResponse::kElementOffsets[2];
        const auto size = GetCapacityResponse::kElementSizes[2];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.numSectors, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::OpenSessionRequest &x) {
    using namespace internals;
    size_t len = OpenSessionRequest::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::OpenSessionRequest &x) {
    using namespace internals;
    uint32_t blobOff = OpenSessionRequest::kBlobStartOffset;

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::OpenSessionRequest &x) {
    using namespace internals;
    if(in.size() < OpenSessionRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(OpenSessionRequest::kBlobStartOffset);

    return true;
}

inline size_t bytesFor(const internals::OpenSessionResponse &x) {
    using namespace internals;
    size_t len = OpenSessionResponse::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::OpenSessionResponse &x) {
    using namespace internals;
    uint32_t blobOff = OpenSessionResponse::kBlobStartOffset;
    {
        const auto off = OpenSessionResponse::kElementOffsets[0];
        const auto size = OpenSessionResponse::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.status, range.size());
    }
    {
        const auto off = OpenSessionResponse::kElementOffsets[1];
        const auto size = OpenSessionResponse::kElementSizes[1];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.sessionToken, range.size());
    }
    {
        const auto off = OpenSessionResponse::kElementOffsets[2];
        const auto size = OpenSessionResponse::kElementSizes[2];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.regionHandle, range.size());
    }
    {
        const auto off = OpenSessionResponse::kElementOffsets[3];
        const auto size = OpenSessionResponse::kElementSizes[3];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.regionSize, range.size());
    }
    {
        const auto off = OpenSessionResponse::kElementOffsets[4];
        const auto size = OpenSessionResponse::kElementSizes[4];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.numCommands, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::OpenSessionResponse &x) {
    using namespace internals;
    if(in.size() < OpenSessionResponse::kScalarBytes) return false;
    const auto blobRegion = in.subspan(OpenSessionResponse::kBlobStartOffset);
    {
        const auto off = OpenSessionResponse::kElementOffsets[0];
        const auto size = OpenSessionResponse::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.status, range.data(), range.size());
    }
    {
        const auto off = OpenSessionResponse::kElementOffsets[1];
        const auto size = OpenSessionResponse::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.sessionToken, range.data(), range.size());
    }
    {
        const auto off = OpenSessionResponse::kElementOffsets[2];
        const auto size = OpenSessionResponse::kElementSizes[2];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.regionHandle, range.data(), range.size());
    }
    {
        const auto off = OpenSessionResponse::kElementOffsets[3];
        const auto size = OpenSessionResponse::kElementSizes[3];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.regionSize, range.data(), range.size());
    }
    {
        const auto off = OpenSessionResponse::kElementOffsets[4];
        const auto size = OpenSessionResponse::kElementSizes[4];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.numCommands, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::CloseSessionRequest &x) {
    using namespace internals;
    size_t len = CloseSessionRequest::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::CloseSessionRequest &x) {
    using namespace internals;
    uint32_t blobOff = CloseSessionRequest::kBlobStartOffset;
    {
        const auto off = CloseSessionRequest::kElementOffsets[0];
        const auto size = CloseSessionRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.session, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::CloseSessionRequest &x) {
    using namespace internals;
    if(in.size() < CloseSessionRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(CloseSessionRequest::kBlobStartOffset);
    {
        const auto off = CloseSessionRequest::kElementOffsets[0];
        const auto size = CloseSessionRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.session, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::CloseSessionResponse &x) {
    using namespace internals;
    size_t len = CloseSessionResponse::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::CloseSessionResponse &x) {
    using namespace internals;
    uint32_t blobOff = CloseSessionResponse::kBlobStartOffset;
    {
        const auto off = CloseSessionResponse::kElementOffsets[0];
        const auto size = CloseSessionResponse::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.status, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::CloseSessionResponse &x) {
    using namespace internals;
    if(in.size() < CloseSessionResponse::kScalarBytes) return false;
    const auto blobRegion = in.subspan(CloseSessionResponse::kBlobStartOffset);
    {
        const auto off = CloseSessionResponse::kElementOffsets[0];
        const auto size = CloseSessionResponse::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.status, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::CreateReadBufferRequest &x) {
    using namespace internals;
    size_t len = CreateReadBufferRequest::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::CreateReadBufferRequest &x) {
    using namespace internals;
    uint32_t blobOff = CreateReadBufferRequest::kBlobStartOffset;
    {
        const auto off = CreateReadBufferRequest::kElementOffsets[0];
        const auto size = CreateReadBufferRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.session, range.size());
    }
    {
        const auto off = CreateReadBufferRequest::kElementOffsets[1];
        const auto size = CreateReadBufferRequest::kElementSizes[1];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.requestedSize, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::CreateReadBufferRequest &x) {
    using namespace internals;
    if(in.size() < CreateReadBufferRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(CreateReadBufferRequest::kBlobStartOffset);
    {
        const auto off = CreateReadBufferRequest::kElementOffsets[0];
        const auto size = CreateReadBufferRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.session, range.data(), range.size());
    }
    {
        const auto off = CreateReadBufferRequest::kElementOffsets[1];
        const auto size = CreateReadBufferRequest::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.requestedSize, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::CreateReadBufferResponse &x) {
    using namespace internals;
    size_t len = CreateReadBufferResponse::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::CreateReadBufferResponse &x) {
    using namespace internals;
    uint32_t blobOff = CreateReadBufferResponse::kBlobStartOffset;
    {
        const auto off = CreateReadBufferResponse::kElementOffsets[0];
        const auto size = CreateReadBufferResponse::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.status, range.size());
    }
    {
        const auto off = CreateReadBufferResponse::kElementOffsets[1];
        const auto size = CreateReadBufferResponse::kElementSizes[1];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.readBufHandle, range.size());
    }
    {
        const auto off = CreateReadBufferResponse::kElementOffsets[2];
        const auto size = CreateReadBufferResponse::kElementSizes[2];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.readBufMaxSize, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::CreateReadBufferResponse &x) {
    using namespace internals;
    if(in.size() < CreateReadBufferResponse::kScalarBytes) return false;
    const auto blobRegion = in.subspan(CreateReadBufferResponse::kBlobStartOffset);
    {
        const auto off = CreateReadBufferResponse::kElementOffsets[0];
        const auto size = CreateReadBufferResponse::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.status, range.data(), range.size());
    }
    {
        const auto off = CreateReadBufferResponse::kElementOffsets[1];
        const auto size = CreateReadBufferResponse::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.readBufHandle, range.data(), range.size());
    }
    {
        const auto off = CreateReadBufferResponse::kElementOffsets[2];
        const auto size = CreateReadBufferResponse::kElementSizes[2];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.readBufMaxSize, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::CreateWriteBufferRequest &x) {
    using namespace internals;
    size_t len = CreateWriteBufferRequest::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::CreateWriteBufferRequest &x) {
    using namespace internals;
    uint32_t blobOff = CreateWriteBufferRequest::kBlobStartOffset;
    {
        const auto off = CreateWriteBufferRequest::kElementOffsets[0];
        const auto size = CreateWriteBufferRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.session, range.size());
    }
    {
        const auto off = CreateWriteBufferRequest::kElementOffsets[1];
        const auto size = CreateWriteBufferRequest::kElementSizes[1];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.requestedSize, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::CreateWriteBufferRequest &x) {
    using namespace internals;
    if(in.size() < CreateWriteBufferRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(CreateWriteBufferRequest::kBlobStartOffset);
    {
        const auto off = CreateWriteBufferRequest::kElementOffsets[0];
        const auto size = CreateWriteBufferRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.session, range.data(), range.size());
    }
    {
        const auto off = CreateWriteBufferRequest::kElementOffsets[1];
        const auto size = CreateWriteBufferRequest::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.requestedSize, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::CreateWriteBufferResponse &x) {
    using namespace internals;
    size_t len = CreateWriteBufferResponse::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::CreateWriteBufferResponse &x) {
    using namespace internals;
    uint32_t blobOff = CreateWriteBufferResponse::kBlobStartOffset;
    {
        const auto off = CreateWriteBufferResponse::kElementOffsets[0];
        const auto size = CreateWriteBufferResponse::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.status, range.size());
    }
    {
        const auto off = CreateWriteBufferResponse::kElementOffsets[1];
        const auto size = CreateWriteBufferResponse::kElementSizes[1];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.writeBufHandle, range.size());
    }
    {
        const auto off = CreateWriteBufferResponse::kElementOffsets[2];
        const auto size = CreateWriteBufferResponse::kElementSizes[2];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.writeBufMaxSize, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::CreateWriteBufferResponse &x) {
    using namespace internals;
    if(in.size() < CreateWriteBufferResponse::kScalarBytes) return false;
    const auto blobRegion = in.subspan(CreateWriteBufferResponse::kBlobStartOffset);
    {
        const auto off = CreateWriteBufferResponse::kElementOffsets[0];
        const auto size = CreateWriteBufferResponse::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.status, range.data(), range.size());
    }
    {
        const auto off = CreateWriteBufferResponse::kElementOffsets[1];
        const auto size = CreateWriteBufferResponse::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.writeBufHandle, range.data(), range.size());
    }
    {
        const auto off = CreateWriteBufferResponse::kElementOffsets[2];
        const auto size = CreateWriteBufferResponse::kElementSizes[2];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.writeBufMaxSize, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::ExecuteCommandRequest &x) {
    using namespace internals;
    size_t len = ExecuteCommandRequest::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::ExecuteCommandRequest &x) {
    using namespace internals;
    uint32_t blobOff = ExecuteCommandRequest::kBlobStartOffset;
    {
        const auto off = ExecuteCommandRequest::kElementOffsets[0];
        const auto size = ExecuteCommandRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.session, range.size());
    }
    {
        const auto off = ExecuteCommandRequest::kElementOffsets[1];
        const auto size = ExecuteCommandRequest::kElementSizes[1];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.slot, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::ExecuteCommandRequest &x) {
    using namespace internals;
    if(in.size() < ExecuteCommandRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(ExecuteCommandRequest::kBlobStartOffset);
    {
        const auto off = ExecuteCommandRequest::kElementOffsets[0];
        const auto size = ExecuteCommandRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.session, range.data(), range.size());
    }
    {
        const auto off = ExecuteCommandRequest::kElementOffsets[1];
        const auto size = ExecuteCommandRequest::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.slot, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::ReleaseReadCommandRequest &x) {
    using namespace internals;
    size_t len = ReleaseReadCommandRequest::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::ReleaseReadCommandRequest &x) {
    using namespace internals;
    uint32_t blobOff = ReleaseReadCommandRequest::kBlobStartOffset;
    {
        const auto off = ReleaseReadCommandRequest::kElementOffsets[0];
        const auto size = ReleaseReadCommandRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.session, range.size());
    }
    {
        const auto off = ReleaseReadCommandRequest::kElementOffsets[1];
        const auto size = ReleaseReadCommandRequest::kElementSizes[1];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.slot, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::ReleaseReadCommandRequest &x) {
    using namespace internals;
    if(in.size() < ReleaseReadCommandRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(ReleaseReadCommandRequest::kBlobStartOffset);
    {
        const auto off = ReleaseReadCommandRequest::kElementOffsets[0];
        const auto size = ReleaseReadCommandRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.session, range.data(), range.size());
    }
    {
        const auto off = ReleaseReadCommandRequest::kElementOffsets[1];
        const auto size = ReleaseReadCommandRequest::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.slot, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::AllocWriteMemoryRequest &x) {
    using namespace internals;
    size_t len = AllocWriteMemoryRequest::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::AllocWriteMemoryRequest &x) {
    using namespace internals;
    uint32_t blobOff = AllocWriteMemoryRequest::kBlobStartOffset;
    {
        const auto off = AllocWriteMemoryRequest::kElementOffsets[0];
        const auto size = AllocWriteMemoryRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.session, range.size());
    }
    {
        const auto off = AllocWriteMemoryRequest::kElementOffsets[1];
        const auto size = AllocWriteMemoryRequest::kElementSizes[1];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.bytesRequested, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::AllocWriteMemoryRequest &x) {
    using namespace internals;
    if(in.size() < AllocWriteMemoryRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(AllocWriteMemoryRequest::kBlobStartOffset);
    {
        const auto off = AllocWriteMemoryRequest::kElementOffsets[0];
        const auto size = AllocWriteMemoryRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.session, range.data(), range.size());
    }
    {
        const auto off = AllocWriteMemoryRequest::kElementOffsets[1];
        const auto size = AllocWriteMemoryRequest::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.bytesRequested, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::AllocWriteMemoryResponse &x) {
    using namespace internals;
    size_t len = AllocWriteMemoryResponse::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::AllocWriteMemoryResponse &x) {
    using namespace internals;
    uint32_t blobOff = AllocWriteMemoryResponse::kBlobStartOffset;
    {
        const auto off = AllocWriteMemoryResponse::kElementOffsets[0];
        const auto size = AllocWriteMemoryResponse::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.status, range.size());
    }
    {
        const auto off = AllocWriteMemoryResponse::kElementOffsets[1];
        const auto size = AllocWriteMemoryResponse::kElementSizes[1];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.offset, range.size());
    }
    {
        const auto off = AllocWriteMemoryResponse::kElementOffsets[2];
        const auto size = AllocWriteMemoryResponse::kElementSizes[2];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.bytesAllocated, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::AllocWriteMemoryResponse &x) {
    using namespace internals;
    if(in.size() < AllocWriteMemoryResponse::kScalarBytes) return false;
    const auto blobRegion = in.subspan(AllocWriteMemoryResponse::kBlobStartOffset);
    {
        const auto off = AllocWriteMemoryResponse::kElementOffsets[0];
        const auto size = AllocWriteMemoryResponse::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.status, range.data(), range.size());
    }
    {
        const auto off = AllocWriteMemoryResponse::kElementOffsets[1];
        const auto size = AllocWriteMemoryResponse::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.offset, range.data(), range.size());
    }
    {
        const auto off = AllocWriteMemoryResponse::kElementOffsets[2];
        const auto size = AllocWriteMemoryResponse::kElementSizes[2];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.bytesAllocated, range.data(), range.size());
    }

    return true;
}

}; // namespace rpc

#pragma clang diagnostic push

#endif // defined(RPC_HELPERS_GENERATED_17065700451208530523)
