/*
 * This RPC client stub was autogenerated by idlc (version 8a02fc5d). DO NOT EDIT!
 * Generated from DiskDriver.idl for interface DiskDriver at 2021-06-26T17:21:52-0500
 *
 * You may use these generated stubs directly as the RPC interface, or you can subclass it to
 * override the behavior of the function calls, or to perform some preprocessing to the data as
 * needed before sending it.
 *
 * See the full RPC documentation for more details.
 */
#ifndef RPC_CLIENT_GENERATED_17065700451208530523
#define RPC_CLIENT_GENERATED_17065700451208530523

#include <string>
#include <cstddef>
#include <cstdint>
#include <memory>
#include <span>
#include <string_view>
#include <vector>

#define RPC_USER_TYPES_INCLUDES
#include <DriverSupport/disk/Types.h>
#undef RPC_USER_TYPES_INCLUDES

namespace rpc {
namespace rt { class ClientRpcIoStream; }
class DiskDriverClient {
    struct MessageHeader {
        enum Flags: uint32_t {
            Request                     = (1 << 0),
            Response                    = (1 << 1),
        };

        uint64_t type;
        Flags flags;
        uint32_t tag;

        std::byte payload[];
    };
    static_assert(!(offsetof(MessageHeader, payload) % sizeof(uintptr_t)),
        "message header's payload is not word aligned");

    constexpr static const std::string_view kServiceName{"DiskDriver"};

    protected:
        using IoStream = rt::ClientRpcIoStream;

    public:
        // Return types for method 'GetCapacity'
        struct GetCapacityReturn {
            int32_t status;
            uint32_t sectorSize;
            uint64_t numSectors;
        };
        // Return types for method 'OpenSession'
        struct OpenSessionReturn {
            int32_t status;
            uint64_t sessionToken;
            uint64_t regionHandle;
            uint64_t regionSize;
            uint64_t numCommands;
        };
        // Return types for method 'CreateReadBuffer'
        struct CreateReadBufferReturn {
            int32_t status;
            uint64_t readBufHandle;
            uint64_t readBufMaxSize;
        };
        // Return types for method 'CreateWriteBuffer'
        struct CreateWriteBufferReturn {
            int32_t status;
            uint64_t writeBufHandle;
            uint64_t writeBufMaxSize;
        };
        // Return types for method 'AllocWriteMemory'
        struct AllocWriteMemoryReturn {
            int32_t status;
            uint64_t offset;
            uint64_t bytesAllocated;
        };

    public:
        DiskDriverClient(const std::shared_ptr<IoStream> &stream);
        virtual ~DiskDriverClient();

        virtual GetCapacityReturn GetCapacity(uint64_t diskId);
        virtual OpenSessionReturn OpenSession();
        virtual int32_t CloseSession(uint64_t session);
        virtual CreateReadBufferReturn CreateReadBuffer(uint64_t session, uint64_t requestedSize);
        virtual CreateWriteBufferReturn CreateWriteBuffer(uint64_t session, uint64_t requestedSize);
        virtual void ExecuteCommand(uint64_t session, uint32_t slot);
        virtual void ReleaseReadCommand(uint64_t session, uint32_t slot);
        virtual AllocWriteMemoryReturn AllocWriteMemory(uint64_t session, uint64_t bytesRequested);

    // Helpers provided to subclasses for implementation of interface methods
    protected:
        constexpr inline auto &getIo() {
            return this->io;
        }

        /// Handles errors occurring during client operations; typically terminates the task
        virtual void _HandleError(const bool fatal, const std::string_view &what);

    // Implementation details; pretend this does not exist
    private:
        std::shared_ptr<IoStream> io;
        size_t txBufSize{0};
        void *txBuf{nullptr};

        uint32_t nextTag{0};

        void _ensureTxBuf(const size_t);
        uint32_t _sendRequest(const uint64_t type, const size_t payloadBytes);
}; // class DiskDriverClient
} // namespace rpc
#endif // defined(RPC_CLIENT_GENERATED_17065700451208530523)
