/*
 * This RPC serialization code was autogenerated by idlc (version c8601c6e). DO NOT EDIT!
 * Generated from WindowServer.idl for interface WindowServer at 2021-07-11T18:46:48-0500
 *
 * The structs and methods within are used by the RPC system to serialize and deserialize the
 * arguments and return values on method calls. They work internally in the same way that encoding
 * custom types in RPC messages works.
 *
 * See the full RPC documentation for more details.
 */
#ifndef RPC_HELPERS_GENERATED_16174174863144938629
#define RPC_HELPERS_GENERATED_16174174863144938629

#include <algorithm>
#include <cstddef>
#include <cstdint>
#include <cstdio>
#include <cstring>
#include <string>
#include <span>
#include <string_view>

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-variable"


namespace rpc {
/**
 * Method to handle a failure to deserialize a field; this will log the failure if built in debug
 * mode.
 */
static inline void HandleDecodeError(const char *typeName, const char *fieldName,
    const uintptr_t offset) {
    fprintf(stderr, "[RPC] Decode error for type %s, field %s at offset $%x\n", typeName, fieldName,
        offset);
}
static inline void HandleDecodeError(const char *typeName, const char *fieldName,
    const uintptr_t offset, const uint32_t blobDataOffset, const uint32_t blobSz) {
    fprintf(stderr, "[RPC] Decode error for type %s, field %s at offset $%x "
        "(blob offset $%x, $%x bytes)\n", typeName, fieldName, offset, blobDataOffset, blobSz);
}

/*
 * Serialization functions for various C++ built in types
 */
inline size_t bytesFor(const std::string &s) {
    return s.length();
}
inline bool serialize(std::span<std::byte> &out, const std::string &str) {
    if(str.empty()) return true;
    else if(out.size() < str.length()) return false;
    memcpy(out.data(), str.c_str(), str.length());
    return true;
}
inline bool deserialize(const std::span<std::byte> &in, std::string &outStr) {
    if(in.empty()) {
        outStr = "";
    } else {
        outStr = std::string(reinterpret_cast<const char *>(in.data()), in.size());
    }
    return true;
}

// XXX: this only works for POD types!
template<typename T>
inline size_t bytesFor(const std::vector<T> &s) {
    return s.size() * sizeof(T);
}
template<typename T>
inline bool serialize(std::span<std::byte> &out, const std::vector<T> &vec) {
    const size_t numBytes = vec.size() * sizeof(T);
    if(out.size() < numBytes) return false;
    memcpy(out.data(), vec.data(), out.size());
    return true;
}
template <typename T>
inline bool deserialize(const std::span<std::byte> &in, std::vector<T> &outVec) {
    const size_t elements = in.size() / sizeof(T);
    outVec.resize(elements);
    memcpy(outVec.data(), in.data(), in.size());
    return true;
}


/*
 * Definitions of serialization structures for messages and message replies. These use the
 * autogenerated stubs to convert to/from the wire format.
 */
namespace internals {
/// Message ids for each of the RPC messages
enum class Type: uint64_t {
                                      SubmitKeyEvent = 0x5313353be07b5c96ULL,
                                    SubmitMouseEvent = 0x46e5a95b9576c0cULL,
};
/**
 * Request structure for method 'SubmitKeyEvent'
 */
struct SubmitKeyEventRequest {
    uint32_t scancode;
    bool release;

    constexpr static const size_t kElementSizes[2] {
     4,  1
    };
    constexpr static const size_t kElementOffsets[2] {
     0,  4
    };
    constexpr static const size_t kScalarBytes{5};
    constexpr static const size_t kBlobStartOffset{8};
};

/**
 * Request structure for method 'SubmitMouseEvent'
 */
struct SubmitMouseEventRequest {
    uint32_t buttons;
    int32_t dX;
    int32_t dY;
    int32_t dZ;

    constexpr static const size_t kElementSizes[4] {
     4,  4,  4,  4
    };
    constexpr static const size_t kElementOffsets[4] {
     0,  4,  8, 12
    };
    constexpr static const size_t kScalarBytes{16};
    constexpr static const size_t kBlobStartOffset{16};
};

} // namespace rpc::internals


inline size_t bytesFor(const internals::SubmitKeyEventRequest &x) {
    using namespace internals;
    size_t len = SubmitKeyEventRequest::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::SubmitKeyEventRequest &x) {
    using namespace internals;
    uint32_t blobOff = SubmitKeyEventRequest::kBlobStartOffset;
    {
        const auto off = SubmitKeyEventRequest::kElementOffsets[0];
        const auto size = SubmitKeyEventRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.scancode, range.size());
    }
    {
        const auto off = SubmitKeyEventRequest::kElementOffsets[1];
        const auto size = SubmitKeyEventRequest::kElementSizes[1];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.release, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::SubmitKeyEventRequest &x) {
    using namespace internals;
    if(in.size() < SubmitKeyEventRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(SubmitKeyEventRequest::kBlobStartOffset);
    {
        const auto off = SubmitKeyEventRequest::kElementOffsets[0];
        const auto size = SubmitKeyEventRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.scancode, range.data(), range.size());
    }
    {
        const auto off = SubmitKeyEventRequest::kElementOffsets[1];
        const auto size = SubmitKeyEventRequest::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.release, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::SubmitMouseEventRequest &x) {
    using namespace internals;
    size_t len = SubmitMouseEventRequest::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::SubmitMouseEventRequest &x) {
    using namespace internals;
    uint32_t blobOff = SubmitMouseEventRequest::kBlobStartOffset;
    {
        const auto off = SubmitMouseEventRequest::kElementOffsets[0];
        const auto size = SubmitMouseEventRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.buttons, range.size());
    }
    {
        const auto off = SubmitMouseEventRequest::kElementOffsets[1];
        const auto size = SubmitMouseEventRequest::kElementSizes[1];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.dX, range.size());
    }
    {
        const auto off = SubmitMouseEventRequest::kElementOffsets[2];
        const auto size = SubmitMouseEventRequest::kElementSizes[2];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.dY, range.size());
    }
    {
        const auto off = SubmitMouseEventRequest::kElementOffsets[3];
        const auto size = SubmitMouseEventRequest::kElementSizes[3];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.dZ, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::SubmitMouseEventRequest &x) {
    using namespace internals;
    if(in.size() < SubmitMouseEventRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(SubmitMouseEventRequest::kBlobStartOffset);
    {
        const auto off = SubmitMouseEventRequest::kElementOffsets[0];
        const auto size = SubmitMouseEventRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.buttons, range.data(), range.size());
    }
    {
        const auto off = SubmitMouseEventRequest::kElementOffsets[1];
        const auto size = SubmitMouseEventRequest::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.dX, range.data(), range.size());
    }
    {
        const auto off = SubmitMouseEventRequest::kElementOffsets[2];
        const auto size = SubmitMouseEventRequest::kElementSizes[2];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.dY, range.data(), range.size());
    }
    {
        const auto off = SubmitMouseEventRequest::kElementOffsets[3];
        const auto size = SubmitMouseEventRequest::kElementSizes[3];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.dZ, range.data(), range.size());
    }

    return true;
}

}; // namespace rpc

#pragma clang diagnostic push

#endif // defined(RPC_HELPERS_GENERATED_16174174863144938629)
