/*
 * This RPC client stub was autogenerated by idlc (version c8601c6e). DO NOT EDIT!
 * Generated from WindowServer.idl for interface WindowServer at 2021-07-11T18:46:48-0500
 *
 * You may use these generated stubs directly as the RPC interface, or you can subclass it to
 * override the behavior of the function calls, or to perform some preprocessing to the data as
 * needed before sending it.
 *
 * See the full RPC documentation for more details.
 */
#include "Client_WindowServer.hpp"
#include "RpcHelpers_WindowServer.hpp"

#include <algorithm>
#include <cstddef>
#include <cstdint>
#include <cstdio>
#include <cstdlib>
#include <cstring>

#include <rpc/rt/RpcIoStream.hpp>

using namespace rpc;

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-variable"
using Client = WindowServerClient;

/**
 * Creates a new client instance, with the given IO stream.
 */
Client::WindowServerClient(const std::shared_ptr<IoStream> &stream) : io(stream) {
}

/**
 * Shuts down the RPC client, releasing any allocated resources.
 */
Client::~WindowServerClient() {
    free(this->txBuf);
}

/// Sends the message that's been built up in the transmit message buffer.
uint32_t Client::_sendRequest(const uint64_t type, const size_t payloadBytes) {
    const size_t len = sizeof(MessageHeader) + payloadBytes;

    const auto tag = __atomic_add_fetch(&this->nextTag, 1, __ATOMIC_RELAXED);
    auto hdr = reinterpret_cast<MessageHeader *>(this->txBuf);
    memset(hdr, 0, sizeof(*hdr));
    hdr->type = type;
    hdr->flags = MessageHeader::Flags::Request;
    hdr->tag = tag;

    const std::span<std::byte> txBufSpan(reinterpret_cast<std::byte *>(this->txBuf), len);
    if(!this->io->sendRequest(txBufSpan)) {
        this->_HandleError(true, "Failed to send RPC request");
        return 0;
    }

    return tag;
}

// Allocates an aligned transmit buffer of the given size
void Client::_ensureTxBuf(const size_t payloadBytes) {
    const size_t len = sizeof(MessageHeader) + payloadBytes + 16;
    if(len > this->txBufSize) {
        free(this->txBuf);
        int err = posix_memalign(&this->txBuf, 16, len);
        if(err) {
            return this->_HandleError(true, "Failed to allocate RPC send buffer");
        }
        this->txBufSize = len;
    }
}

/**
 * Handles an error that occurred on the client connection. Implementations may override this
 * method if they want to use exceptions, for example.
 *
 * @param fatal If set, the error precludes further operation on this RPC connection
 * @param what Descriptive string for the error
 */
void Client::_HandleError(const bool fatal, const std::string_view &what) {
    fprintf(stderr, "[RPCC] %s: Encountered %s RPC error: %s\n", kServiceName.data(),
        fatal ? "fatal" : "recoverable", what.data());
    if(fatal) exit(-1);
}
/*
 * Autogenerated call method for 'SubmitKeyEvent' (id $5313353be07b5c96)
 * Have 2 parameter(s), 0 return(s); method is async
 */
void Client::SubmitKeyEvent(uint32_t scancode, bool release) {
    {
        internals::SubmitKeyEventRequest request;
        request.scancode = scancode;
        request.release = release;

        const auto numBytes = bytesFor(request);
        this->_ensureTxBuf(numBytes);

        auto packet = reinterpret_cast<MessageHeader *>(this->txBuf);
        std::span<std::byte> data(packet->payload, numBytes);
        serialize(data, request);
        this->_sendRequest(static_cast<uint64_t>(internals::Type::SubmitKeyEvent), numBytes);
    }
}
/*
 * Autogenerated call method for 'SubmitMouseEvent' (id $46e5a95b9576c0c)
 * Have 4 parameter(s), 0 return(s); method is async
 */
void Client::SubmitMouseEvent(uint32_t buttons, int32_t dX, int32_t dY, int32_t dZ) {
    {
        internals::SubmitMouseEventRequest request;
        request.buttons = buttons;
        request.dX = dX;
        request.dY = dY;
        request.dZ = dZ;

        const auto numBytes = bytesFor(request);
        this->_ensureTxBuf(numBytes);

        auto packet = reinterpret_cast<MessageHeader *>(this->txBuf);
        std::span<std::byte> data(packet->payload, numBytes);
        serialize(data, request);
        this->_sendRequest(static_cast<uint64_t>(internals::Type::SubmitMouseEvent), numBytes);
    }
}
#pragma clang diagnostic pop
