/*
 * This RPC client stub was autogenerated by idlc (version 8a02fc5d). DO NOT EDIT!
 * Generated from UserClient.idl for interface PciDriverUser at 2021-06-26T17:21:36-0500
 *
 * You may use these generated stubs directly as the RPC interface, or you can subclass it to
 * override the behavior of the function calls, or to perform some preprocessing to the data as
 * needed before sending it.
 *
 * See the full RPC documentation for more details.
 */
#include "Client_PciDriverUser.hpp"
#include "RpcHelpers_PciDriverUser.hpp"

#include <algorithm>
#include <cstddef>
#include <cstdint>
#include <cstdio>
#include <cstdlib>
#include <cstring>

#include <rpc/rt/RpcIoStream.hpp>

using namespace rpc;

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-variable"
using Client = PciDriverUserClient;

// stubs for custom type serialization
template<typename... _blah>
constexpr auto TemplatedFalseFlag = false;

/// Given a byte range, decodes the given type
template<typename T>
inline bool deserialize(const std::span<std::byte> &, T &) {
    static_assert(TemplatedFalseFlag<T>, "rpc::deserialize not implemented for custom type");
}
/// Determine how many bytes of memory are required to serialize the given type.
template<typename T>
inline size_t bytesFor(const T &) {
    static_assert(TemplatedFalseFlag<T>, "rpc::bytesFor not implemented for custom type");
}
/// Encodes the given type into the provided region of memory
template<typename T>
inline bool serialize(std::span<std::byte> &, const T &) {
    static_assert(TemplatedFalseFlag<T>, "rpc::serialize not implemented for custom type");
}
/**
 * Creates a new client instance, with the given IO stream.
 */
Client::PciDriverUserClient(const std::shared_ptr<IoStream> &stream) : io(stream) {
}

/**
 * Shuts down the RPC client, releasing any allocated resources.
 */
Client::~PciDriverUserClient() {
    free(this->txBuf);
}

/// Sends the message that's been built up in the transmit message buffer.
uint32_t Client::_sendRequest(const uint64_t type, const size_t payloadBytes) {
    const size_t len = sizeof(MessageHeader) + payloadBytes;

    const auto tag = __atomic_add_fetch(&this->nextTag, 1, __ATOMIC_RELAXED);
    auto hdr = reinterpret_cast<MessageHeader *>(this->txBuf);
    memset(hdr, 0, sizeof(*hdr));
    hdr->type = type;
    hdr->flags = MessageHeader::Flags::Request;
    hdr->tag = tag;

    const std::span<std::byte> txBufSpan(reinterpret_cast<std::byte *>(this->txBuf), len);
    if(!this->io->sendRequest(txBufSpan)) {
        this->_HandleError(true, "Failed to send RPC request");
        return 0;
    }

    return tag;
}

// Allocates an aligned transmit buffer of the given size
void Client::_ensureTxBuf(const size_t payloadBytes) {
    const size_t len = sizeof(MessageHeader) + payloadBytes + 16;
    if(len > this->txBufSize) {
        free(this->txBuf);
        int err = posix_memalign(&this->txBuf, 16, len);
        if(err) {
            return this->_HandleError(true, "Failed to allocate RPC send buffer");
        }
        this->txBufSize = len;
    }
}

/**
 * Handles an error that occurred on the client connection. Implementations may override this
 * method if they want to use exceptions, for example.
 *
 * @param fatal If set, the error precludes further operation on this RPC connection
 * @param what Descriptive string for the error
 */
void Client::_HandleError(const bool fatal, const std::string_view &what) {
    fprintf(stderr, "[RPCC] %s: Encountered %s RPC error: %s\n", kServiceName.data(),
        fatal ? "fatal" : "recoverable", what.data());
    if(fatal) exit(-1);
}
/*
 * Autogenerated call method for 'GetDeviceAt' (id $d5b64160331233f1)
 * Have 1 parameter(s), 1 return(s); method is sync
 */
std::string Client::GetDeviceAt(const libpci::BusAddress &address) {
    uint32_t sentTag;
    {
        internals::GetDeviceAtRequest request;
        request.address = address;

        const auto numBytes = bytesFor(request);
        this->_ensureTxBuf(numBytes);

        auto packet = reinterpret_cast<MessageHeader *>(this->txBuf);
        std::span<std::byte> data(packet->payload, numBytes);
        serialize(data, request);
        sentTag = this->_sendRequest(static_cast<uint64_t>(internals::Type::GetDeviceAt), numBytes);
    }
    {
        std::span<std::byte> buf;
        if(!this->io->receiveReply(buf)) this->_HandleError(false, "Failed to receive RPC reply");
        if(buf.size() < sizeof(MessageHeader)) this->_HandleError(false, "Received message too small");
        const auto hdr = reinterpret_cast<const MessageHeader *>(buf.data());
        if(hdr->tag != sentTag) this->_HandleError(false, "Invalid tag in reply RPC packet");
        else if(hdr->type != static_cast<uint64_t>(internals::Type::GetDeviceAt)) this->_HandleError(false, "Invalid type in reply RPC packet");
        const auto payload = buf.subspan(offsetof(MessageHeader, payload));

        internals::GetDeviceAtResponse reply;
        if(!deserialize(payload, reply)) this->_HandleError(false, "Failed to decode message");
        return reply.path;
    }
}
/*
 * Autogenerated call method for 'ReadCfgSpace32' (id $441bae330756a108)
 * Have 2 parameter(s), 1 return(s); method is sync
 */
uint32_t Client::ReadCfgSpace32(const libpci::BusAddress &address, uint16_t offset) {
    uint32_t sentTag;
    {
        internals::ReadCfgSpace32Request request;
        request.address = address;
        request.offset = offset;

        const auto numBytes = bytesFor(request);
        this->_ensureTxBuf(numBytes);

        auto packet = reinterpret_cast<MessageHeader *>(this->txBuf);
        std::span<std::byte> data(packet->payload, numBytes);
        serialize(data, request);
        sentTag = this->_sendRequest(static_cast<uint64_t>(internals::Type::ReadCfgSpace32), numBytes);
    }
    {
        std::span<std::byte> buf;
        if(!this->io->receiveReply(buf)) this->_HandleError(false, "Failed to receive RPC reply");
        if(buf.size() < sizeof(MessageHeader)) this->_HandleError(false, "Received message too small");
        const auto hdr = reinterpret_cast<const MessageHeader *>(buf.data());
        if(hdr->tag != sentTag) this->_HandleError(false, "Invalid tag in reply RPC packet");
        else if(hdr->type != static_cast<uint64_t>(internals::Type::ReadCfgSpace32)) this->_HandleError(false, "Invalid type in reply RPC packet");
        const auto payload = buf.subspan(offsetof(MessageHeader, payload));

        internals::ReadCfgSpace32Response reply;
        if(!deserialize(payload, reply)) this->_HandleError(false, "Failed to decode message");
        return reply.result;
    }
}
/*
 * Autogenerated call method for 'WriteCfgSpace32' (id $de92bb2db0b09f5d)
 * Have 3 parameter(s), 0 return(s); method is sync
 */
void Client::WriteCfgSpace32(const libpci::BusAddress &address, uint16_t offset, uint32_t value) {
    uint32_t sentTag;
    {
        internals::WriteCfgSpace32Request request;
        request.address = address;
        request.offset = offset;
        request.value = value;

        const auto numBytes = bytesFor(request);
        this->_ensureTxBuf(numBytes);

        auto packet = reinterpret_cast<MessageHeader *>(this->txBuf);
        std::span<std::byte> data(packet->payload, numBytes);
        serialize(data, request);
        sentTag = this->_sendRequest(static_cast<uint64_t>(internals::Type::WriteCfgSpace32), numBytes);
    }
    {
        std::span<std::byte> buf;
        if(!this->io->receiveReply(buf)) this->_HandleError(false, "Failed to receive RPC reply");
        if(buf.size() < sizeof(MessageHeader)) this->_HandleError(false, "Received message too small");
        const auto hdr = reinterpret_cast<const MessageHeader *>(buf.data());
        if(hdr->tag != sentTag) this->_HandleError(false, "Invalid tag in reply RPC packet");
        else if(hdr->type != static_cast<uint64_t>(internals::Type::WriteCfgSpace32)) this->_HandleError(false, "Invalid type in reply RPC packet");
        const auto payload = buf.subspan(offsetof(MessageHeader, payload));

        internals::WriteCfgSpace32Response reply;
        if(!deserialize(payload, reply)) this->_HandleError(false, "Failed to decode message");

    }
}
#pragma clang diagnostic pop
