/*
 * This RPC serialization code was autogenerated by idlc (version 8a02fc5d). DO NOT EDIT!
 * Generated from Filesystem.idl for interface Filesystem at 2021-06-26T17:21:48-0500
 *
 * The structs and methods within are used by the RPC system to serialize and deserialize the
 * arguments and return values on method calls. They work internally in the same way that encoding
 * custom types in RPC messages works.
 *
 * See the full RPC documentation for more details.
 */
#ifndef RPC_HELPERS_GENERATED_18393244566832765147
#define RPC_HELPERS_GENERATED_18393244566832765147

#include <algorithm>
#include <cstddef>
#include <cstdint>
#include <cstdio>
#include <cstring>
#include <string>
#include <span>
#include <string_view>

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-variable"


namespace rpc {
/**
 * Method to handle a failure to deserialize a field; this will log the failure if built in debug
 * mode.
 */
static inline void HandleDecodeError(const char *typeName, const char *fieldName,
    const uintptr_t offset) {
    fprintf(stderr, "[RPC] Decode error for type %s, field %s at offset $%x\n", typeName, fieldName,
        offset);
}
static inline void HandleDecodeError(const char *typeName, const char *fieldName,
    const uintptr_t offset, const uint32_t blobDataOffset, const uint32_t blobSz) {
    fprintf(stderr, "[RPC] Decode error for type %s, field %s at offset $%x "
        "(blob offset $%x, $%x bytes)\n", typeName, fieldName, offset, blobDataOffset, blobSz);
}

/*
 * Serialization functions for various C++ built in types
 */
inline size_t bytesFor(const std::string &s) {
    return s.length();
}
inline bool serialize(std::span<std::byte> &out, const std::string &str) {
    if(str.empty()) return true;
    else if(out.size() < str.length()) return false;
    memcpy(out.data(), str.c_str(), str.length());
    return true;
}
inline bool deserialize(const std::span<std::byte> &in, std::string &outStr) {
    if(in.empty()) {
        outStr = "";
    } else {
        outStr = std::string(reinterpret_cast<const char *>(in.data()), in.size());
    }
    return true;
}

// XXX: this only works for POD types!
template<typename T>
inline size_t bytesFor(const std::vector<T> &s) {
    return s.size() * sizeof(T);
}
template<typename T>
inline bool serialize(std::span<std::byte> &out, const std::vector<T> &vec) {
    const size_t numBytes = vec.size() * sizeof(T);
    if(out.size() < numBytes) return false;
    memcpy(out.data(), vec.data(), out.size());
    return true;
}
template <typename T>
inline bool deserialize(const std::span<std::byte> &in, std::vector<T> &outVec) {
    const size_t elements = in.size() / sizeof(T);
    outVec.resize(elements);
    memcpy(outVec.data(), in.data(), in.size());
    return true;
}


/*
 * Definitions of serialization structures for messages and message replies. These use the
 * autogenerated stubs to convert to/from the wire format.
 */
namespace internals {
/// Message ids for each of the RPC messages
enum class Type: uint64_t {
                                            OpenFile = 0xdccae6ca6448b367ULL,
                                            SlowRead = 0xfb13530a05a3aaf2ULL,
                                           CloseFile = 0xbe7b08fc61ccb369ULL,
};
/**
 * Request structure for method 'OpenFile'
 */
struct OpenFileRequest {
    std::string path;
    uint32_t mode;

    constexpr static const size_t kElementSizes[2] {
     8,  4
    };
    constexpr static const size_t kElementOffsets[2] {
     0,  8
    };
    constexpr static const size_t kScalarBytes{12};
    constexpr static const size_t kBlobStartOffset{16};
};
/**
 * Reply structure for method 'OpenFile'
 */
struct OpenFileResponse {
    int32_t status;
    uint64_t handle;
    uint64_t fileSize;

    constexpr static const size_t kElementSizes[3] {
     4,  8,  8
    };
    constexpr static const size_t kElementOffsets[3] {
     0,  4, 12
    };
    constexpr static const size_t kScalarBytes{20};
    constexpr static const size_t kBlobStartOffset{24};
};

/**
 * Request structure for method 'SlowRead'
 */
struct SlowReadRequest {
    uint64_t handle;
    uint64_t offset;
    uint16_t numBytes;

    constexpr static const size_t kElementSizes[3] {
     8,  8,  2
    };
    constexpr static const size_t kElementOffsets[3] {
     0,  8, 16
    };
    constexpr static const size_t kScalarBytes{18};
    constexpr static const size_t kBlobStartOffset{24};
};
/**
 * Reply structure for method 'SlowRead'
 */
struct SlowReadResponse {
    int32_t status;
    std::vector<std::byte> data;

    constexpr static const size_t kElementSizes[2] {
     4,  8
    };
    constexpr static const size_t kElementOffsets[2] {
     0,  4
    };
    constexpr static const size_t kScalarBytes{12};
    constexpr static const size_t kBlobStartOffset{16};
};

/**
 * Request structure for method 'CloseFile'
 */
struct CloseFileRequest {
    uint64_t handle;

    constexpr static const size_t kElementSizes[1] {
     8
    };
    constexpr static const size_t kElementOffsets[1] {
     0
    };
    constexpr static const size_t kScalarBytes{8};
    constexpr static const size_t kBlobStartOffset{8};
};
/**
 * Reply structure for method 'CloseFile'
 */
struct CloseFileResponse {
    int32_t status;

    constexpr static const size_t kElementSizes[1] {
     4
    };
    constexpr static const size_t kElementOffsets[1] {
     0
    };
    constexpr static const size_t kScalarBytes{4};
    constexpr static const size_t kBlobStartOffset{8};
};

} // namespace rpc::internals


inline size_t bytesFor(const internals::OpenFileRequest &x) {
    using namespace internals;
    size_t len = OpenFileRequest::kBlobStartOffset;
    len += bytesFor(x.path);

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::OpenFileRequest &x) {
    using namespace internals;
    uint32_t blobOff = OpenFileRequest::kBlobStartOffset;
    {
        const auto off = OpenFileRequest::kElementOffsets[0];
        const auto size = OpenFileRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        const uint32_t blobSz = bytesFor(x.path);
        const uint32_t blobDataOffset = blobOff;
        auto blobRange = out.subspan(blobDataOffset, blobSz);
        if(!serialize(blobRange, x.path)) return false;
        blobOff += blobSz;
        memcpy(range.data(), &blobDataOffset, sizeof(blobDataOffset));
        memcpy(range.data()+sizeof(blobDataOffset), &blobSz, sizeof(blobSz));
    }
    {
        const auto off = OpenFileRequest::kElementOffsets[1];
        const auto size = OpenFileRequest::kElementSizes[1];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.mode, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::OpenFileRequest &x) {
    using namespace internals;
    if(in.size() < OpenFileRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(OpenFileRequest::kBlobStartOffset);
    {
        const auto off = OpenFileRequest::kElementOffsets[0];
        const auto size = OpenFileRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        uint32_t blobSz{0}, blobDataOffset{0};
        memcpy(&blobDataOffset, range.data(), sizeof(blobDataOffset));
        memcpy(&blobSz, range.data()+sizeof(blobDataOffset), sizeof(blobSz));
        auto blobRange = in.subspan(blobDataOffset, blobSz);
       if(!deserialize(blobRange, x.path)) {
            HandleDecodeError("OpenFileRequest", "path", off, blobDataOffset, blobSz);
            return false;
        }
    }
    {
        const auto off = OpenFileRequest::kElementOffsets[1];
        const auto size = OpenFileRequest::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.mode, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::OpenFileResponse &x) {
    using namespace internals;
    size_t len = OpenFileResponse::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::OpenFileResponse &x) {
    using namespace internals;
    uint32_t blobOff = OpenFileResponse::kBlobStartOffset;
    {
        const auto off = OpenFileResponse::kElementOffsets[0];
        const auto size = OpenFileResponse::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.status, range.size());
    }
    {
        const auto off = OpenFileResponse::kElementOffsets[1];
        const auto size = OpenFileResponse::kElementSizes[1];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.handle, range.size());
    }
    {
        const auto off = OpenFileResponse::kElementOffsets[2];
        const auto size = OpenFileResponse::kElementSizes[2];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.fileSize, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::OpenFileResponse &x) {
    using namespace internals;
    if(in.size() < OpenFileResponse::kScalarBytes) return false;
    const auto blobRegion = in.subspan(OpenFileResponse::kBlobStartOffset);
    {
        const auto off = OpenFileResponse::kElementOffsets[0];
        const auto size = OpenFileResponse::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.status, range.data(), range.size());
    }
    {
        const auto off = OpenFileResponse::kElementOffsets[1];
        const auto size = OpenFileResponse::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.handle, range.data(), range.size());
    }
    {
        const auto off = OpenFileResponse::kElementOffsets[2];
        const auto size = OpenFileResponse::kElementSizes[2];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.fileSize, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::SlowReadRequest &x) {
    using namespace internals;
    size_t len = SlowReadRequest::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::SlowReadRequest &x) {
    using namespace internals;
    uint32_t blobOff = SlowReadRequest::kBlobStartOffset;
    {
        const auto off = SlowReadRequest::kElementOffsets[0];
        const auto size = SlowReadRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.handle, range.size());
    }
    {
        const auto off = SlowReadRequest::kElementOffsets[1];
        const auto size = SlowReadRequest::kElementSizes[1];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.offset, range.size());
    }
    {
        const auto off = SlowReadRequest::kElementOffsets[2];
        const auto size = SlowReadRequest::kElementSizes[2];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.numBytes, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::SlowReadRequest &x) {
    using namespace internals;
    if(in.size() < SlowReadRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(SlowReadRequest::kBlobStartOffset);
    {
        const auto off = SlowReadRequest::kElementOffsets[0];
        const auto size = SlowReadRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.handle, range.data(), range.size());
    }
    {
        const auto off = SlowReadRequest::kElementOffsets[1];
        const auto size = SlowReadRequest::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.offset, range.data(), range.size());
    }
    {
        const auto off = SlowReadRequest::kElementOffsets[2];
        const auto size = SlowReadRequest::kElementSizes[2];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.numBytes, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::SlowReadResponse &x) {
    using namespace internals;
    size_t len = SlowReadResponse::kBlobStartOffset;
    len += bytesFor(x.data);

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::SlowReadResponse &x) {
    using namespace internals;
    uint32_t blobOff = SlowReadResponse::kBlobStartOffset;
    {
        const auto off = SlowReadResponse::kElementOffsets[0];
        const auto size = SlowReadResponse::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.status, range.size());
    }
    {
        const auto off = SlowReadResponse::kElementOffsets[1];
        const auto size = SlowReadResponse::kElementSizes[1];
        auto range = out.subspan(off, size);
        const uint32_t blobSz = bytesFor(x.data);
        const uint32_t blobDataOffset = blobOff;
        auto blobRange = out.subspan(blobDataOffset, blobSz);
        if(!serialize(blobRange, x.data)) return false;
        blobOff += blobSz;
        memcpy(range.data(), &blobDataOffset, sizeof(blobDataOffset));
        memcpy(range.data()+sizeof(blobDataOffset), &blobSz, sizeof(blobSz));
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::SlowReadResponse &x) {
    using namespace internals;
    if(in.size() < SlowReadResponse::kScalarBytes) return false;
    const auto blobRegion = in.subspan(SlowReadResponse::kBlobStartOffset);
    {
        const auto off = SlowReadResponse::kElementOffsets[0];
        const auto size = SlowReadResponse::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.status, range.data(), range.size());
    }
    {
        const auto off = SlowReadResponse::kElementOffsets[1];
        const auto size = SlowReadResponse::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        uint32_t blobSz{0}, blobDataOffset{0};
        memcpy(&blobDataOffset, range.data(), sizeof(blobDataOffset));
        memcpy(&blobSz, range.data()+sizeof(blobDataOffset), sizeof(blobSz));
        auto blobRange = in.subspan(blobDataOffset, blobSz);
       if(!deserialize(blobRange, x.data)) {
            HandleDecodeError("SlowReadResponse", "data", off, blobDataOffset, blobSz);
            return false;
        }
    }

    return true;
}

inline size_t bytesFor(const internals::CloseFileRequest &x) {
    using namespace internals;
    size_t len = CloseFileRequest::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::CloseFileRequest &x) {
    using namespace internals;
    uint32_t blobOff = CloseFileRequest::kBlobStartOffset;
    {
        const auto off = CloseFileRequest::kElementOffsets[0];
        const auto size = CloseFileRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.handle, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::CloseFileRequest &x) {
    using namespace internals;
    if(in.size() < CloseFileRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(CloseFileRequest::kBlobStartOffset);
    {
        const auto off = CloseFileRequest::kElementOffsets[0];
        const auto size = CloseFileRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.handle, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::CloseFileResponse &x) {
    using namespace internals;
    size_t len = CloseFileResponse::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::CloseFileResponse &x) {
    using namespace internals;
    uint32_t blobOff = CloseFileResponse::kBlobStartOffset;
    {
        const auto off = CloseFileResponse::kElementOffsets[0];
        const auto size = CloseFileResponse::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.status, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::CloseFileResponse &x) {
    using namespace internals;
    if(in.size() < CloseFileResponse::kScalarBytes) return false;
    const auto blobRegion = in.subspan(CloseFileResponse::kBlobStartOffset);
    {
        const auto off = CloseFileResponse::kElementOffsets[0];
        const auto size = CloseFileResponse::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.status, range.data(), range.size());
    }

    return true;
}

}; // namespace rpc

#pragma clang diagnostic push

#endif // defined(RPC_HELPERS_GENERATED_18393244566832765147)
