/*
 * This RPC client stub was autogenerated by idlc (version 8a02fc5d). DO NOT EDIT!
 * Generated from Filesystem.idl for interface Filesystem at 2021-06-26T17:21:48-0500
 *
 * You may use these generated stubs directly as the RPC interface, or you can subclass it to
 * override the behavior of the function calls, or to perform some preprocessing to the data as
 * needed before sending it.
 *
 * See the full RPC documentation for more details.
 */
#include "Client_Filesystem.hpp"
#include "RpcHelpers_Filesystem.hpp"

#include <algorithm>
#include <cstddef>
#include <cstdint>
#include <cstdio>
#include <cstdlib>
#include <cstring>

#include <rpc/rt/RpcIoStream.hpp>

using namespace rpc;

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-variable"
using Client = FilesystemClient;

/**
 * Creates a new client instance, with the given IO stream.
 */
Client::FilesystemClient(const std::shared_ptr<IoStream> &stream) : io(stream) {
}

/**
 * Shuts down the RPC client, releasing any allocated resources.
 */
Client::~FilesystemClient() {
    free(this->txBuf);
}

/// Sends the message that's been built up in the transmit message buffer.
uint32_t Client::_sendRequest(const uint64_t type, const size_t payloadBytes) {
    const size_t len = sizeof(MessageHeader) + payloadBytes;

    const auto tag = __atomic_add_fetch(&this->nextTag, 1, __ATOMIC_RELAXED);
    auto hdr = reinterpret_cast<MessageHeader *>(this->txBuf);
    memset(hdr, 0, sizeof(*hdr));
    hdr->type = type;
    hdr->flags = MessageHeader::Flags::Request;
    hdr->tag = tag;

    const std::span<std::byte> txBufSpan(reinterpret_cast<std::byte *>(this->txBuf), len);
    if(!this->io->sendRequest(txBufSpan)) {
        this->_HandleError(true, "Failed to send RPC request");
        return 0;
    }

    return tag;
}

// Allocates an aligned transmit buffer of the given size
void Client::_ensureTxBuf(const size_t payloadBytes) {
    const size_t len = sizeof(MessageHeader) + payloadBytes + 16;
    if(len > this->txBufSize) {
        free(this->txBuf);
        int err = posix_memalign(&this->txBuf, 16, len);
        if(err) {
            return this->_HandleError(true, "Failed to allocate RPC send buffer");
        }
        this->txBufSize = len;
    }
}

/**
 * Handles an error that occurred on the client connection. Implementations may override this
 * method if they want to use exceptions, for example.
 *
 * @param fatal If set, the error precludes further operation on this RPC connection
 * @param what Descriptive string for the error
 */
void Client::_HandleError(const bool fatal, const std::string_view &what) {
    fprintf(stderr, "[RPCC] %s: Encountered %s RPC error: %s\n", kServiceName.data(),
        fatal ? "fatal" : "recoverable", what.data());
    if(fatal) exit(-1);
}
/*
 * Autogenerated call method for 'OpenFile' (id $dccae6ca6448b367)
 * Have 2 parameter(s), 3 return(s); method is sync
 */
Client::OpenFileReturn Client::OpenFile(const std::string &path, uint32_t mode) {
    uint32_t sentTag;
    {
        internals::OpenFileRequest request;
        request.path = path;
        request.mode = mode;

        const auto numBytes = bytesFor(request);
        this->_ensureTxBuf(numBytes);

        auto packet = reinterpret_cast<MessageHeader *>(this->txBuf);
        std::span<std::byte> data(packet->payload, numBytes);
        serialize(data, request);
        sentTag = this->_sendRequest(static_cast<uint64_t>(internals::Type::OpenFile), numBytes);
    }
    {
        std::span<std::byte> buf;
        if(!this->io->receiveReply(buf)) this->_HandleError(false, "Failed to receive RPC reply");
        if(buf.size() < sizeof(MessageHeader)) this->_HandleError(false, "Received message too small");
        const auto hdr = reinterpret_cast<const MessageHeader *>(buf.data());
        if(hdr->tag != sentTag) this->_HandleError(false, "Invalid tag in reply RPC packet");
        else if(hdr->type != static_cast<uint64_t>(internals::Type::OpenFile)) this->_HandleError(false, "Invalid type in reply RPC packet");
        const auto payload = buf.subspan(offsetof(MessageHeader, payload));

        internals::OpenFileResponse reply;
        if(!deserialize(payload, reply)) this->_HandleError(false, "Failed to decode message");
        OpenFileReturn r;
        r.status =  reply.status;
        r.handle =  reply.handle;
        r.fileSize =  reply.fileSize;
        return r;

    }
}
/*
 * Autogenerated call method for 'SlowRead' (id $fb13530a05a3aaf2)
 * Have 3 parameter(s), 2 return(s); method is sync
 */
Client::SlowReadReturn Client::SlowRead(uint64_t handle, uint64_t offset, uint16_t numBytes) {
    uint32_t sentTag;
    {
        internals::SlowReadRequest request;
        request.handle = handle;
        request.offset = offset;
        request.numBytes = numBytes;

        const auto numBytes = bytesFor(request);
        this->_ensureTxBuf(numBytes);

        auto packet = reinterpret_cast<MessageHeader *>(this->txBuf);
        std::span<std::byte> data(packet->payload, numBytes);
        serialize(data, request);
        sentTag = this->_sendRequest(static_cast<uint64_t>(internals::Type::SlowRead), numBytes);
    }
    {
        std::span<std::byte> buf;
        if(!this->io->receiveReply(buf)) this->_HandleError(false, "Failed to receive RPC reply");
        if(buf.size() < sizeof(MessageHeader)) this->_HandleError(false, "Received message too small");
        const auto hdr = reinterpret_cast<const MessageHeader *>(buf.data());
        if(hdr->tag != sentTag) this->_HandleError(false, "Invalid tag in reply RPC packet");
        else if(hdr->type != static_cast<uint64_t>(internals::Type::SlowRead)) this->_HandleError(false, "Invalid type in reply RPC packet");
        const auto payload = buf.subspan(offsetof(MessageHeader, payload));

        internals::SlowReadResponse reply;
        if(!deserialize(payload, reply)) this->_HandleError(false, "Failed to decode message");
        SlowReadReturn r;
        r.status =  reply.status;
        r.data =  reply.data;
        return r;

    }
}
/*
 * Autogenerated call method for 'CloseFile' (id $be7b08fc61ccb369)
 * Have 1 parameter(s), 1 return(s); method is sync
 */
int32_t Client::CloseFile(uint64_t handle) {
    uint32_t sentTag;
    {
        internals::CloseFileRequest request;
        request.handle = handle;

        const auto numBytes = bytesFor(request);
        this->_ensureTxBuf(numBytes);

        auto packet = reinterpret_cast<MessageHeader *>(this->txBuf);
        std::span<std::byte> data(packet->payload, numBytes);
        serialize(data, request);
        sentTag = this->_sendRequest(static_cast<uint64_t>(internals::Type::CloseFile), numBytes);
    }
    {
        std::span<std::byte> buf;
        if(!this->io->receiveReply(buf)) this->_HandleError(false, "Failed to receive RPC reply");
        if(buf.size() < sizeof(MessageHeader)) this->_HandleError(false, "Received message too small");
        const auto hdr = reinterpret_cast<const MessageHeader *>(buf.data());
        if(hdr->tag != sentTag) this->_HandleError(false, "Invalid tag in reply RPC packet");
        else if(hdr->type != static_cast<uint64_t>(internals::Type::CloseFile)) this->_HandleError(false, "Invalid type in reply RPC packet");
        const auto payload = buf.subspan(offsetof(MessageHeader, payload));

        internals::CloseFileResponse reply;
        if(!deserialize(payload, reply)) this->_HandleError(false, "Failed to decode message");
        return reply.status;
    }
}
#pragma clang diagnostic pop
