/*
 * This RPC serialization code was autogenerated by idlc (version 8a02fc5d). DO NOT EDIT!
 * Generated from Driverman.idl for interface Driverman at 2021-06-26T17:21:35-0500
 *
 * The structs and methods within are used by the RPC system to serialize and deserialize the
 * arguments and return values on method calls. They work internally in the same way that encoding
 * custom types in RPC messages works.
 *
 * See the full RPC documentation for more details.
 */
#ifndef RPC_HELPERS_GENERATED_11260871874244005202
#define RPC_HELPERS_GENERATED_11260871874244005202

#include <algorithm>
#include <cstddef>
#include <cstdint>
#include <cstdio>
#include <cstring>
#include <string>
#include <span>
#include <string_view>

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-variable"


namespace rpc {
/**
 * Method to handle a failure to deserialize a field; this will log the failure if built in debug
 * mode.
 */
static inline void HandleDecodeError(const char *typeName, const char *fieldName,
    const uintptr_t offset) {
    fprintf(stderr, "[RPC] Decode error for type %s, field %s at offset $%x\n", typeName, fieldName,
        offset);
}
static inline void HandleDecodeError(const char *typeName, const char *fieldName,
    const uintptr_t offset, const uint32_t blobDataOffset, const uint32_t blobSz) {
    fprintf(stderr, "[RPC] Decode error for type %s, field %s at offset $%x "
        "(blob offset $%x, $%x bytes)\n", typeName, fieldName, offset, blobDataOffset, blobSz);
}

/*
 * Serialization functions for various C++ built in types
 */
inline size_t bytesFor(const std::string &s) {
    return s.length();
}
inline bool serialize(std::span<std::byte> &out, const std::string &str) {
    if(str.empty()) return true;
    else if(out.size() < str.length()) return false;
    memcpy(out.data(), str.c_str(), str.length());
    return true;
}
inline bool deserialize(const std::span<std::byte> &in, std::string &outStr) {
    if(in.empty()) {
        outStr = "";
    } else {
        outStr = std::string(reinterpret_cast<const char *>(in.data()), in.size());
    }
    return true;
}

// XXX: this only works for POD types!
template<typename T>
inline size_t bytesFor(const std::vector<T> &s) {
    return s.size() * sizeof(T);
}
template<typename T>
inline bool serialize(std::span<std::byte> &out, const std::vector<T> &vec) {
    const size_t numBytes = vec.size() * sizeof(T);
    if(out.size() < numBytes) return false;
    memcpy(out.data(), vec.data(), out.size());
    return true;
}
template <typename T>
inline bool deserialize(const std::span<std::byte> &in, std::vector<T> &outVec) {
    const size_t elements = in.size() / sizeof(T);
    outVec.resize(elements);
    memcpy(outVec.data(), in.data(), in.size());
    return true;
}


/*
 * Definitions of serialization structures for messages and message replies. These use the
 * autogenerated stubs to convert to/from the wire format.
 */
namespace internals {
/// Message ids for each of the RPC messages
enum class Type: uint64_t {
                                           AddDevice = 0xe2cd5678129683feULL,
                                   SetDeviceProperty = 0x4fe09a246da305bcULL,
                                   GetDeviceProperty = 0xfaac446645be5520ULL,
                                         StartDevice = 0x6a7cbf9e2efa75f0ULL,
                                          StopDevice = 0xee8b158787490a80ULL,
                                              Notify = 0x63ce1044c4349828ULL,
};
/**
 * Request structure for method 'addDevice'
 */
struct AddDeviceRequest {
    std::string parent;
    std::string driverId;

    constexpr static const size_t kElementSizes[2] {
     8,  8
    };
    constexpr static const size_t kElementOffsets[2] {
     0,  8
    };
    constexpr static const size_t kScalarBytes{16};
    constexpr static const size_t kBlobStartOffset{16};
};
/**
 * Reply structure for method 'addDevice'
 */
struct AddDeviceResponse {
    std::string path;

    constexpr static const size_t kElementSizes[1] {
     8
    };
    constexpr static const size_t kElementOffsets[1] {
     0
    };
    constexpr static const size_t kScalarBytes{8};
    constexpr static const size_t kBlobStartOffset{8};
};

/**
 * Request structure for method 'SetDeviceProperty'
 */
struct SetDevicePropertyRequest {
    std::string path;
    std::string key;
    std::vector<std::byte> data;

    constexpr static const size_t kElementSizes[3] {
     8,  8,  8
    };
    constexpr static const size_t kElementOffsets[3] {
     0,  8, 16
    };
    constexpr static const size_t kScalarBytes{24};
    constexpr static const size_t kBlobStartOffset{24};
};
/**
 * Reply structure for method 'SetDeviceProperty'
 */
struct SetDevicePropertyResponse {
    int32_t status;

    constexpr static const size_t kElementSizes[1] {
     4
    };
    constexpr static const size_t kElementOffsets[1] {
     0
    };
    constexpr static const size_t kScalarBytes{4};
    constexpr static const size_t kBlobStartOffset{8};
};

/**
 * Request structure for method 'GetDeviceProperty'
 */
struct GetDevicePropertyRequest {
    std::string path;
    std::string key;

    constexpr static const size_t kElementSizes[2] {
     8,  8
    };
    constexpr static const size_t kElementOffsets[2] {
     0,  8
    };
    constexpr static const size_t kScalarBytes{16};
    constexpr static const size_t kBlobStartOffset{16};
};
/**
 * Reply structure for method 'GetDeviceProperty'
 */
struct GetDevicePropertyResponse {
    int32_t status;
    std::vector<std::byte> data;

    constexpr static const size_t kElementSizes[2] {
     4,  8
    };
    constexpr static const size_t kElementOffsets[2] {
     0,  4
    };
    constexpr static const size_t kScalarBytes{12};
    constexpr static const size_t kBlobStartOffset{16};
};

/**
 * Request structure for method 'StartDevice'
 */
struct StartDeviceRequest {
    std::string path;

    constexpr static const size_t kElementSizes[1] {
     8
    };
    constexpr static const size_t kElementOffsets[1] {
     0
    };
    constexpr static const size_t kScalarBytes{8};
    constexpr static const size_t kBlobStartOffset{8};
};
/**
 * Reply structure for method 'StartDevice'
 */
struct StartDeviceResponse {
    int32_t status;

    constexpr static const size_t kElementSizes[1] {
     4
    };
    constexpr static const size_t kElementOffsets[1] {
     0
    };
    constexpr static const size_t kScalarBytes{4};
    constexpr static const size_t kBlobStartOffset{8};
};

/**
 * Request structure for method 'StopDevice'
 */
struct StopDeviceRequest {
    std::string path;

    constexpr static const size_t kElementSizes[1] {
     8
    };
    constexpr static const size_t kElementOffsets[1] {
     0
    };
    constexpr static const size_t kScalarBytes{8};
    constexpr static const size_t kBlobStartOffset{8};
};
/**
 * Reply structure for method 'StopDevice'
 */
struct StopDeviceResponse {
    int32_t status;

    constexpr static const size_t kElementSizes[1] {
     4
    };
    constexpr static const size_t kElementOffsets[1] {
     0
    };
    constexpr static const size_t kScalarBytes{4};
    constexpr static const size_t kBlobStartOffset{8};
};

/**
 * Request structure for method 'Notify'
 */
struct NotifyRequest {
    std::string path;
    uint64_t key;

    constexpr static const size_t kElementSizes[2] {
     8,  8
    };
    constexpr static const size_t kElementOffsets[2] {
     0,  8
    };
    constexpr static const size_t kScalarBytes{16};
    constexpr static const size_t kBlobStartOffset{16};
};
/**
 * Reply structure for method 'Notify'
 */
struct NotifyResponse {
    int32_t status;

    constexpr static const size_t kElementSizes[1] {
     4
    };
    constexpr static const size_t kElementOffsets[1] {
     0
    };
    constexpr static const size_t kScalarBytes{4};
    constexpr static const size_t kBlobStartOffset{8};
};

} // namespace rpc::internals


inline size_t bytesFor(const internals::AddDeviceRequest &x) {
    using namespace internals;
    size_t len = AddDeviceRequest::kBlobStartOffset;
    len += bytesFor(x.parent);
    len += bytesFor(x.driverId);

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::AddDeviceRequest &x) {
    using namespace internals;
    uint32_t blobOff = AddDeviceRequest::kBlobStartOffset;
    {
        const auto off = AddDeviceRequest::kElementOffsets[0];
        const auto size = AddDeviceRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        const uint32_t blobSz = bytesFor(x.parent);
        const uint32_t blobDataOffset = blobOff;
        auto blobRange = out.subspan(blobDataOffset, blobSz);
        if(!serialize(blobRange, x.parent)) return false;
        blobOff += blobSz;
        memcpy(range.data(), &blobDataOffset, sizeof(blobDataOffset));
        memcpy(range.data()+sizeof(blobDataOffset), &blobSz, sizeof(blobSz));
    }
    {
        const auto off = AddDeviceRequest::kElementOffsets[1];
        const auto size = AddDeviceRequest::kElementSizes[1];
        auto range = out.subspan(off, size);
        const uint32_t blobSz = bytesFor(x.driverId);
        const uint32_t blobDataOffset = blobOff;
        auto blobRange = out.subspan(blobDataOffset, blobSz);
        if(!serialize(blobRange, x.driverId)) return false;
        blobOff += blobSz;
        memcpy(range.data(), &blobDataOffset, sizeof(blobDataOffset));
        memcpy(range.data()+sizeof(blobDataOffset), &blobSz, sizeof(blobSz));
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::AddDeviceRequest &x) {
    using namespace internals;
    if(in.size() < AddDeviceRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(AddDeviceRequest::kBlobStartOffset);
    {
        const auto off = AddDeviceRequest::kElementOffsets[0];
        const auto size = AddDeviceRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        uint32_t blobSz{0}, blobDataOffset{0};
        memcpy(&blobDataOffset, range.data(), sizeof(blobDataOffset));
        memcpy(&blobSz, range.data()+sizeof(blobDataOffset), sizeof(blobSz));
        auto blobRange = in.subspan(blobDataOffset, blobSz);
       if(!deserialize(blobRange, x.parent)) {
            HandleDecodeError("AddDeviceRequest", "parent", off, blobDataOffset, blobSz);
            return false;
        }
    }
    {
        const auto off = AddDeviceRequest::kElementOffsets[1];
        const auto size = AddDeviceRequest::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        uint32_t blobSz{0}, blobDataOffset{0};
        memcpy(&blobDataOffset, range.data(), sizeof(blobDataOffset));
        memcpy(&blobSz, range.data()+sizeof(blobDataOffset), sizeof(blobSz));
        auto blobRange = in.subspan(blobDataOffset, blobSz);
       if(!deserialize(blobRange, x.driverId)) {
            HandleDecodeError("AddDeviceRequest", "driverId", off, blobDataOffset, blobSz);
            return false;
        }
    }

    return true;
}

inline size_t bytesFor(const internals::AddDeviceResponse &x) {
    using namespace internals;
    size_t len = AddDeviceResponse::kBlobStartOffset;
    len += bytesFor(x.path);

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::AddDeviceResponse &x) {
    using namespace internals;
    uint32_t blobOff = AddDeviceResponse::kBlobStartOffset;
    {
        const auto off = AddDeviceResponse::kElementOffsets[0];
        const auto size = AddDeviceResponse::kElementSizes[0];
        auto range = out.subspan(off, size);
        const uint32_t blobSz = bytesFor(x.path);
        const uint32_t blobDataOffset = blobOff;
        auto blobRange = out.subspan(blobDataOffset, blobSz);
        if(!serialize(blobRange, x.path)) return false;
        blobOff += blobSz;
        memcpy(range.data(), &blobDataOffset, sizeof(blobDataOffset));
        memcpy(range.data()+sizeof(blobDataOffset), &blobSz, sizeof(blobSz));
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::AddDeviceResponse &x) {
    using namespace internals;
    if(in.size() < AddDeviceResponse::kScalarBytes) return false;
    const auto blobRegion = in.subspan(AddDeviceResponse::kBlobStartOffset);
    {
        const auto off = AddDeviceResponse::kElementOffsets[0];
        const auto size = AddDeviceResponse::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        uint32_t blobSz{0}, blobDataOffset{0};
        memcpy(&blobDataOffset, range.data(), sizeof(blobDataOffset));
        memcpy(&blobSz, range.data()+sizeof(blobDataOffset), sizeof(blobSz));
        auto blobRange = in.subspan(blobDataOffset, blobSz);
       if(!deserialize(blobRange, x.path)) {
            HandleDecodeError("AddDeviceResponse", "path", off, blobDataOffset, blobSz);
            return false;
        }
    }

    return true;
}

inline size_t bytesFor(const internals::SetDevicePropertyRequest &x) {
    using namespace internals;
    size_t len = SetDevicePropertyRequest::kBlobStartOffset;
    len += bytesFor(x.path);
    len += bytesFor(x.key);
    len += bytesFor(x.data);

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::SetDevicePropertyRequest &x) {
    using namespace internals;
    uint32_t blobOff = SetDevicePropertyRequest::kBlobStartOffset;
    {
        const auto off = SetDevicePropertyRequest::kElementOffsets[0];
        const auto size = SetDevicePropertyRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        const uint32_t blobSz = bytesFor(x.path);
        const uint32_t blobDataOffset = blobOff;
        auto blobRange = out.subspan(blobDataOffset, blobSz);
        if(!serialize(blobRange, x.path)) return false;
        blobOff += blobSz;
        memcpy(range.data(), &blobDataOffset, sizeof(blobDataOffset));
        memcpy(range.data()+sizeof(blobDataOffset), &blobSz, sizeof(blobSz));
    }
    {
        const auto off = SetDevicePropertyRequest::kElementOffsets[1];
        const auto size = SetDevicePropertyRequest::kElementSizes[1];
        auto range = out.subspan(off, size);
        const uint32_t blobSz = bytesFor(x.key);
        const uint32_t blobDataOffset = blobOff;
        auto blobRange = out.subspan(blobDataOffset, blobSz);
        if(!serialize(blobRange, x.key)) return false;
        blobOff += blobSz;
        memcpy(range.data(), &blobDataOffset, sizeof(blobDataOffset));
        memcpy(range.data()+sizeof(blobDataOffset), &blobSz, sizeof(blobSz));
    }
    {
        const auto off = SetDevicePropertyRequest::kElementOffsets[2];
        const auto size = SetDevicePropertyRequest::kElementSizes[2];
        auto range = out.subspan(off, size);
        const uint32_t blobSz = bytesFor(x.data);
        const uint32_t blobDataOffset = blobOff;
        auto blobRange = out.subspan(blobDataOffset, blobSz);
        if(!serialize(blobRange, x.data)) return false;
        blobOff += blobSz;
        memcpy(range.data(), &blobDataOffset, sizeof(blobDataOffset));
        memcpy(range.data()+sizeof(blobDataOffset), &blobSz, sizeof(blobSz));
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::SetDevicePropertyRequest &x) {
    using namespace internals;
    if(in.size() < SetDevicePropertyRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(SetDevicePropertyRequest::kBlobStartOffset);
    {
        const auto off = SetDevicePropertyRequest::kElementOffsets[0];
        const auto size = SetDevicePropertyRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        uint32_t blobSz{0}, blobDataOffset{0};
        memcpy(&blobDataOffset, range.data(), sizeof(blobDataOffset));
        memcpy(&blobSz, range.data()+sizeof(blobDataOffset), sizeof(blobSz));
        auto blobRange = in.subspan(blobDataOffset, blobSz);
       if(!deserialize(blobRange, x.path)) {
            HandleDecodeError("SetDevicePropertyRequest", "path", off, blobDataOffset, blobSz);
            return false;
        }
    }
    {
        const auto off = SetDevicePropertyRequest::kElementOffsets[1];
        const auto size = SetDevicePropertyRequest::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        uint32_t blobSz{0}, blobDataOffset{0};
        memcpy(&blobDataOffset, range.data(), sizeof(blobDataOffset));
        memcpy(&blobSz, range.data()+sizeof(blobDataOffset), sizeof(blobSz));
        auto blobRange = in.subspan(blobDataOffset, blobSz);
       if(!deserialize(blobRange, x.key)) {
            HandleDecodeError("SetDevicePropertyRequest", "key", off, blobDataOffset, blobSz);
            return false;
        }
    }
    {
        const auto off = SetDevicePropertyRequest::kElementOffsets[2];
        const auto size = SetDevicePropertyRequest::kElementSizes[2];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        uint32_t blobSz{0}, blobDataOffset{0};
        memcpy(&blobDataOffset, range.data(), sizeof(blobDataOffset));
        memcpy(&blobSz, range.data()+sizeof(blobDataOffset), sizeof(blobSz));
        auto blobRange = in.subspan(blobDataOffset, blobSz);
       if(!deserialize(blobRange, x.data)) {
            HandleDecodeError("SetDevicePropertyRequest", "data", off, blobDataOffset, blobSz);
            return false;
        }
    }

    return true;
}

inline size_t bytesFor(const internals::SetDevicePropertyResponse &x) {
    using namespace internals;
    size_t len = SetDevicePropertyResponse::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::SetDevicePropertyResponse &x) {
    using namespace internals;
    uint32_t blobOff = SetDevicePropertyResponse::kBlobStartOffset;
    {
        const auto off = SetDevicePropertyResponse::kElementOffsets[0];
        const auto size = SetDevicePropertyResponse::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.status, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::SetDevicePropertyResponse &x) {
    using namespace internals;
    if(in.size() < SetDevicePropertyResponse::kScalarBytes) return false;
    const auto blobRegion = in.subspan(SetDevicePropertyResponse::kBlobStartOffset);
    {
        const auto off = SetDevicePropertyResponse::kElementOffsets[0];
        const auto size = SetDevicePropertyResponse::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.status, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::GetDevicePropertyRequest &x) {
    using namespace internals;
    size_t len = GetDevicePropertyRequest::kBlobStartOffset;
    len += bytesFor(x.path);
    len += bytesFor(x.key);

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::GetDevicePropertyRequest &x) {
    using namespace internals;
    uint32_t blobOff = GetDevicePropertyRequest::kBlobStartOffset;
    {
        const auto off = GetDevicePropertyRequest::kElementOffsets[0];
        const auto size = GetDevicePropertyRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        const uint32_t blobSz = bytesFor(x.path);
        const uint32_t blobDataOffset = blobOff;
        auto blobRange = out.subspan(blobDataOffset, blobSz);
        if(!serialize(blobRange, x.path)) return false;
        blobOff += blobSz;
        memcpy(range.data(), &blobDataOffset, sizeof(blobDataOffset));
        memcpy(range.data()+sizeof(blobDataOffset), &blobSz, sizeof(blobSz));
    }
    {
        const auto off = GetDevicePropertyRequest::kElementOffsets[1];
        const auto size = GetDevicePropertyRequest::kElementSizes[1];
        auto range = out.subspan(off, size);
        const uint32_t blobSz = bytesFor(x.key);
        const uint32_t blobDataOffset = blobOff;
        auto blobRange = out.subspan(blobDataOffset, blobSz);
        if(!serialize(blobRange, x.key)) return false;
        blobOff += blobSz;
        memcpy(range.data(), &blobDataOffset, sizeof(blobDataOffset));
        memcpy(range.data()+sizeof(blobDataOffset), &blobSz, sizeof(blobSz));
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::GetDevicePropertyRequest &x) {
    using namespace internals;
    if(in.size() < GetDevicePropertyRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(GetDevicePropertyRequest::kBlobStartOffset);
    {
        const auto off = GetDevicePropertyRequest::kElementOffsets[0];
        const auto size = GetDevicePropertyRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        uint32_t blobSz{0}, blobDataOffset{0};
        memcpy(&blobDataOffset, range.data(), sizeof(blobDataOffset));
        memcpy(&blobSz, range.data()+sizeof(blobDataOffset), sizeof(blobSz));
        auto blobRange = in.subspan(blobDataOffset, blobSz);
       if(!deserialize(blobRange, x.path)) {
            HandleDecodeError("GetDevicePropertyRequest", "path", off, blobDataOffset, blobSz);
            return false;
        }
    }
    {
        const auto off = GetDevicePropertyRequest::kElementOffsets[1];
        const auto size = GetDevicePropertyRequest::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        uint32_t blobSz{0}, blobDataOffset{0};
        memcpy(&blobDataOffset, range.data(), sizeof(blobDataOffset));
        memcpy(&blobSz, range.data()+sizeof(blobDataOffset), sizeof(blobSz));
        auto blobRange = in.subspan(blobDataOffset, blobSz);
       if(!deserialize(blobRange, x.key)) {
            HandleDecodeError("GetDevicePropertyRequest", "key", off, blobDataOffset, blobSz);
            return false;
        }
    }

    return true;
}

inline size_t bytesFor(const internals::GetDevicePropertyResponse &x) {
    using namespace internals;
    size_t len = GetDevicePropertyResponse::kBlobStartOffset;
    len += bytesFor(x.data);

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::GetDevicePropertyResponse &x) {
    using namespace internals;
    uint32_t blobOff = GetDevicePropertyResponse::kBlobStartOffset;
    {
        const auto off = GetDevicePropertyResponse::kElementOffsets[0];
        const auto size = GetDevicePropertyResponse::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.status, range.size());
    }
    {
        const auto off = GetDevicePropertyResponse::kElementOffsets[1];
        const auto size = GetDevicePropertyResponse::kElementSizes[1];
        auto range = out.subspan(off, size);
        const uint32_t blobSz = bytesFor(x.data);
        const uint32_t blobDataOffset = blobOff;
        auto blobRange = out.subspan(blobDataOffset, blobSz);
        if(!serialize(blobRange, x.data)) return false;
        blobOff += blobSz;
        memcpy(range.data(), &blobDataOffset, sizeof(blobDataOffset));
        memcpy(range.data()+sizeof(blobDataOffset), &blobSz, sizeof(blobSz));
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::GetDevicePropertyResponse &x) {
    using namespace internals;
    if(in.size() < GetDevicePropertyResponse::kScalarBytes) return false;
    const auto blobRegion = in.subspan(GetDevicePropertyResponse::kBlobStartOffset);
    {
        const auto off = GetDevicePropertyResponse::kElementOffsets[0];
        const auto size = GetDevicePropertyResponse::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.status, range.data(), range.size());
    }
    {
        const auto off = GetDevicePropertyResponse::kElementOffsets[1];
        const auto size = GetDevicePropertyResponse::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        uint32_t blobSz{0}, blobDataOffset{0};
        memcpy(&blobDataOffset, range.data(), sizeof(blobDataOffset));
        memcpy(&blobSz, range.data()+sizeof(blobDataOffset), sizeof(blobSz));
        auto blobRange = in.subspan(blobDataOffset, blobSz);
       if(!deserialize(blobRange, x.data)) {
            HandleDecodeError("GetDevicePropertyResponse", "data", off, blobDataOffset, blobSz);
            return false;
        }
    }

    return true;
}

inline size_t bytesFor(const internals::StartDeviceRequest &x) {
    using namespace internals;
    size_t len = StartDeviceRequest::kBlobStartOffset;
    len += bytesFor(x.path);

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::StartDeviceRequest &x) {
    using namespace internals;
    uint32_t blobOff = StartDeviceRequest::kBlobStartOffset;
    {
        const auto off = StartDeviceRequest::kElementOffsets[0];
        const auto size = StartDeviceRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        const uint32_t blobSz = bytesFor(x.path);
        const uint32_t blobDataOffset = blobOff;
        auto blobRange = out.subspan(blobDataOffset, blobSz);
        if(!serialize(blobRange, x.path)) return false;
        blobOff += blobSz;
        memcpy(range.data(), &blobDataOffset, sizeof(blobDataOffset));
        memcpy(range.data()+sizeof(blobDataOffset), &blobSz, sizeof(blobSz));
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::StartDeviceRequest &x) {
    using namespace internals;
    if(in.size() < StartDeviceRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(StartDeviceRequest::kBlobStartOffset);
    {
        const auto off = StartDeviceRequest::kElementOffsets[0];
        const auto size = StartDeviceRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        uint32_t blobSz{0}, blobDataOffset{0};
        memcpy(&blobDataOffset, range.data(), sizeof(blobDataOffset));
        memcpy(&blobSz, range.data()+sizeof(blobDataOffset), sizeof(blobSz));
        auto blobRange = in.subspan(blobDataOffset, blobSz);
       if(!deserialize(blobRange, x.path)) {
            HandleDecodeError("StartDeviceRequest", "path", off, blobDataOffset, blobSz);
            return false;
        }
    }

    return true;
}

inline size_t bytesFor(const internals::StartDeviceResponse &x) {
    using namespace internals;
    size_t len = StartDeviceResponse::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::StartDeviceResponse &x) {
    using namespace internals;
    uint32_t blobOff = StartDeviceResponse::kBlobStartOffset;
    {
        const auto off = StartDeviceResponse::kElementOffsets[0];
        const auto size = StartDeviceResponse::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.status, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::StartDeviceResponse &x) {
    using namespace internals;
    if(in.size() < StartDeviceResponse::kScalarBytes) return false;
    const auto blobRegion = in.subspan(StartDeviceResponse::kBlobStartOffset);
    {
        const auto off = StartDeviceResponse::kElementOffsets[0];
        const auto size = StartDeviceResponse::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.status, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::StopDeviceRequest &x) {
    using namespace internals;
    size_t len = StopDeviceRequest::kBlobStartOffset;
    len += bytesFor(x.path);

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::StopDeviceRequest &x) {
    using namespace internals;
    uint32_t blobOff = StopDeviceRequest::kBlobStartOffset;
    {
        const auto off = StopDeviceRequest::kElementOffsets[0];
        const auto size = StopDeviceRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        const uint32_t blobSz = bytesFor(x.path);
        const uint32_t blobDataOffset = blobOff;
        auto blobRange = out.subspan(blobDataOffset, blobSz);
        if(!serialize(blobRange, x.path)) return false;
        blobOff += blobSz;
        memcpy(range.data(), &blobDataOffset, sizeof(blobDataOffset));
        memcpy(range.data()+sizeof(blobDataOffset), &blobSz, sizeof(blobSz));
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::StopDeviceRequest &x) {
    using namespace internals;
    if(in.size() < StopDeviceRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(StopDeviceRequest::kBlobStartOffset);
    {
        const auto off = StopDeviceRequest::kElementOffsets[0];
        const auto size = StopDeviceRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        uint32_t blobSz{0}, blobDataOffset{0};
        memcpy(&blobDataOffset, range.data(), sizeof(blobDataOffset));
        memcpy(&blobSz, range.data()+sizeof(blobDataOffset), sizeof(blobSz));
        auto blobRange = in.subspan(blobDataOffset, blobSz);
       if(!deserialize(blobRange, x.path)) {
            HandleDecodeError("StopDeviceRequest", "path", off, blobDataOffset, blobSz);
            return false;
        }
    }

    return true;
}

inline size_t bytesFor(const internals::StopDeviceResponse &x) {
    using namespace internals;
    size_t len = StopDeviceResponse::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::StopDeviceResponse &x) {
    using namespace internals;
    uint32_t blobOff = StopDeviceResponse::kBlobStartOffset;
    {
        const auto off = StopDeviceResponse::kElementOffsets[0];
        const auto size = StopDeviceResponse::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.status, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::StopDeviceResponse &x) {
    using namespace internals;
    if(in.size() < StopDeviceResponse::kScalarBytes) return false;
    const auto blobRegion = in.subspan(StopDeviceResponse::kBlobStartOffset);
    {
        const auto off = StopDeviceResponse::kElementOffsets[0];
        const auto size = StopDeviceResponse::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.status, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::NotifyRequest &x) {
    using namespace internals;
    size_t len = NotifyRequest::kBlobStartOffset;
    len += bytesFor(x.path);

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::NotifyRequest &x) {
    using namespace internals;
    uint32_t blobOff = NotifyRequest::kBlobStartOffset;
    {
        const auto off = NotifyRequest::kElementOffsets[0];
        const auto size = NotifyRequest::kElementSizes[0];
        auto range = out.subspan(off, size);
        const uint32_t blobSz = bytesFor(x.path);
        const uint32_t blobDataOffset = blobOff;
        auto blobRange = out.subspan(blobDataOffset, blobSz);
        if(!serialize(blobRange, x.path)) return false;
        blobOff += blobSz;
        memcpy(range.data(), &blobDataOffset, sizeof(blobDataOffset));
        memcpy(range.data()+sizeof(blobDataOffset), &blobSz, sizeof(blobSz));
    }
    {
        const auto off = NotifyRequest::kElementOffsets[1];
        const auto size = NotifyRequest::kElementSizes[1];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.key, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::NotifyRequest &x) {
    using namespace internals;
    if(in.size() < NotifyRequest::kScalarBytes) return false;
    const auto blobRegion = in.subspan(NotifyRequest::kBlobStartOffset);
    {
        const auto off = NotifyRequest::kElementOffsets[0];
        const auto size = NotifyRequest::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        uint32_t blobSz{0}, blobDataOffset{0};
        memcpy(&blobDataOffset, range.data(), sizeof(blobDataOffset));
        memcpy(&blobSz, range.data()+sizeof(blobDataOffset), sizeof(blobSz));
        auto blobRange = in.subspan(blobDataOffset, blobSz);
       if(!deserialize(blobRange, x.path)) {
            HandleDecodeError("NotifyRequest", "path", off, blobDataOffset, blobSz);
            return false;
        }
    }
    {
        const auto off = NotifyRequest::kElementOffsets[1];
        const auto size = NotifyRequest::kElementSizes[1];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.key, range.data(), range.size());
    }

    return true;
}

inline size_t bytesFor(const internals::NotifyResponse &x) {
    using namespace internals;
    size_t len = NotifyResponse::kBlobStartOffset;

    return len;
}
inline bool serialize(std::span<std::byte> &out, const internals::NotifyResponse &x) {
    using namespace internals;
    uint32_t blobOff = NotifyResponse::kBlobStartOffset;
    {
        const auto off = NotifyResponse::kElementOffsets[0];
        const auto size = NotifyResponse::kElementSizes[0];
        auto range = out.subspan(off, size);
        memcpy(range.data(), &x.status, range.size());
    }

    return true;
}
inline bool deserialize(const std::span<std::byte> &in, internals::NotifyResponse &x) {
    using namespace internals;
    if(in.size() < NotifyResponse::kScalarBytes) return false;
    const auto blobRegion = in.subspan(NotifyResponse::kBlobStartOffset);
    {
        const auto off = NotifyResponse::kElementOffsets[0];
        const auto size = NotifyResponse::kElementSizes[0];
        auto range = in.subspan(off, size);
        if(range.empty() || range.size() != size) return false;
        memcpy(&x.status, range.data(), range.size());
    }

    return true;
}

}; // namespace rpc

#pragma clang diagnostic push

#endif // defined(RPC_HELPERS_GENERATED_11260871874244005202)
