import Svg, { Path, SvgProps } from 'react-native-svg';

import { useIllustrationColors } from '@suite-native/atoms';

export const NoTransactionsSvg = (props: SvgProps) => {
    const { lineColor, fillColor } = useIllustrationColors();

    return (
        <Svg width={224} height={224} fill="none" {...props}>
            <Path
                d="M25.782 137.055v15.039s-.064 6.908 7.237 12.344c7.301 5.435 48.21 14.793 87.406 13.619 39.195-1.173 71.425-11.942 77.057-24.515l.706-3.596-.1-18.335s-.025-12.076-32.42-18.765c-32.396-6.69-68.27-4.907-81.898-3.097s-38.46 6.318-49.594 14.259c0 0-8.923 3.841-8.394 13.044v.003z"
                fill={fillColor}
            />
            <Path
                d="M145.563 109.024c-13.141-2.499-26.735-2.428-40.042-1.738-14.514.75-29.085 2.33-43.3 5.424-5.524 1.204-11.046 2.627-16.304 4.727-3.823 1.525-7.63 3.175-11.212 5.212-2.558 1.456-5.126 3.152-7.063 5.397-3.49 4.041-3.324 8.903-.676 13.368 1.509 2.543 3.407 4.857 5.854 6.537 2.787 1.915 6 3.213 9.178 4.323 8.729 3.047 17.964 4.733 27.07 6.188a255.93 255.93 0 0 0 28.18 2.931c19.521.933 39.376-.191 58.564-3.993 7.874-1.561 15.723-3.587 23.193-6.554 5.674-2.256 11.607-5.068 15.933-9.496 2.472-2.532 4.417-5.87 3.988-9.526-.376-3.205-2.441-5.868-4.821-7.916-4.777-4.115-10.896-6.623-16.797-8.64-16.06-5.489-33.314-7.625-50.216-8.154-16.902-.529-32.68.094-48.758 2.485-3.138.468-6.222 1.099-9.327 1.752-.883.186-.51 1.536.374 1.351 6.592-1.387 13.392-2.018 20.09-2.638a314.175 314.175 0 0 1 23.915-1.262c16.44-.254 32.875.748 48.985 4.179 7.503 1.6 15.045 3.64 22.022 6.875 4.816 2.234 11.608 5.749 12.826 11.47 1.472 6.908-6.427 11.978-11.608 14.776-6.149 3.324-12.872 5.585-19.609 7.387-17.751 4.749-36.403 6.424-54.733 6.515a254.943 254.943 0 0 1-55.04-5.735c-7.368-1.591-15.41-3.346-21.86-7.447-2.526-1.608-4.427-3.881-5.927-6.46-1.202-2.062-2.09-4.475-1.642-6.889 1.016-5.471 7.479-8.71 11.943-10.913a93.329 93.329 0 0 1 17.48-6.537c13.025-3.446 26.548-5.228 39.949-6.388 13.597-1.179 27.325-1.619 40.955-.805 2.765.166 5.525.41 8.27.789.385.052.568-.523.166-.601v.006z"
                fill={lineColor}
            />
            <Path
                d="M181.822 121.835c-5.978-3.028-12.57-4.768-19.099-6.152-7.747-1.642-15.618-2.729-23.503-3.435-13.49-1.207-27.071-.944-40.56.086-9.192.703-18.519 1.453-27.602 3.05-.385.069-.302.719.094.689 8.29-.678 16.534-1.935 24.823-2.671 7.008-.623 14.043-1.085 21.081-1.16 14.193-.152 28.474 1.016 42.415 3.715 7.553 1.461 15.042 3.418 22.235 6.163.163.064.277-.205.119-.285h-.003zM45.92 148.837c10.774 3.852 22.49 5.41 33.812 6.703a262.085 262.085 0 0 0 36.165 1.624c12.128-.298 24.278-1.325 36.242-3.357 9.471-1.608 19.05-3.791 27.871-7.683 3.813-1.682 7.768-3.75 10.663-6.814 1.547-1.638 2.826-3.697 2.898-6.011.072-2.314-1.24-4.481-2.903-6.094-.327-.316-.797.163-.496.495 1.678 1.849 2.912 4.099 2.358 6.664-.553 2.566-2.49 4.534-4.436 6.087-2.652 2.117-5.737 3.694-8.834 5.045-8.522 3.717-17.736 5.87-26.861 7.475-22.791 4.011-46.469 4.371-69.46 2.01-12.374-1.271-24.936-3.106-36.94-6.441-.196-.055-.268.233-.082.299l.002-.002zM67.587 116.236c-4.824.346-9.653 1.617-14.273 3.014a87.093 87.093 0 0 0-12.089 4.689c-4.337 2.064-11.079 5.449-10.755 11.203.177 3.13 2.314 6.236 4.592 8.248.277.246.805-.089.55-.424-1.674-2.197-3.697-4.328-4.181-7.16-.407-2.366.636-4.467 2.272-6.124 2.164-2.195 4.984-3.673 7.752-4.96a91.45 91.45 0 0 1 11.503-4.42c4.832-1.492 9.839-2.303 14.67-3.761.161-.05.142-.319-.04-.305z"
                fill={lineColor}
            />
            <Path
                d="M25.472 152.094c-.288 4.91 3.07 10.047 6.897 12.889 4.31 3.197 9.761 4.965 14.87 6.393 13.626 3.806 27.92 5.84 42 6.972 14.826 1.193 29.683.886 44.49-.412 13.332-1.168 26.752-3.294 39.505-7.443 5.311-1.729 10.592-3.838 15.388-6.728 4.689-2.828 10.114-7.027 10.252-12.991.022-.93-1.287-.864-1.401 0-.691 5.217-5.549 8.89-9.758 11.439-4.102 2.485-8.555 4.364-13.072 5.944-11.832 4.141-24.294 6.455-36.727 7.838-27.543 3.07-55.879 1.481-82.922-4.574-6.41-1.434-13.11-3.042-18.958-6.125-2.19-1.154-4.104-2.558-5.688-4.467-2.037-2.458-4.043-5.455-4.253-8.732-.025-.399-.601-.402-.623 0v-.003zM89.684 127.927c-4.489-.133-9.056.67-13.484 1.356-4.132.642-8.24 1.42-12.316 2.358-3.711.855-7.412 1.78-11.06 2.881-3.196.966-6.653 1.921-9.584 3.557-.343.191-.113.755.271.639 3.225-.963 6.327-2.355 9.543-3.371a122.567 122.567 0 0 1 11.04-2.942 204.78 204.78 0 0 1 12.344-2.256c4.412-.672 8.926-.963 13.285-1.92.177-.039.13-.302-.042-.305l.003.003zM163.697 131.608c-8.524-2.397-17.63-3.285-26.428-4.08-9.233-.833-18.541-1.115-27.81-.979-5.311.077-10.794.071-16.055.871-.396.061-.293.689.094.689 4.791-.019 9.596-.528 14.389-.669 4.794-.141 9.324-.177 13.98-.02 9.091.31 18.18 1.105 27.189 2.364 4.868.681 9.712 1.597 14.6 2.131.177.019.204-.26.041-.304v-.003zM189.608 139.728c-1.766-1.97-5.198-2.917-7.631-3.733-1.635-.551-3.299-1.036-4.951-1.534-1.796-.542-3.687-1.226-5.563-1.375-.429-.033-.426.55-.094.689 1.716.706 3.65.988 5.441 1.469 1.602.429 3.169.939 4.724 1.509 1.492.548 2.976 1.112 4.423 1.774 1.138.52 2.27 1.184 3.498 1.464.155.036.255-.144.153-.26v-.003z"
                fill={lineColor}
            />
            <Path
                d="M25.502 132.56c-.606 3.877-.362 7.94-.373 11.857-.009 2.961-.371 6.171.204 9.1.9 4.575 3.93 11.632 9.463 11.729.374.005.429-.529.086-.637-2.881-.91-4.935-2.936-6.255-5.626-.974-1.985-1.854-4.52-2.026-6.751-.504-6.52.68-13.182-.277-19.672-.06-.41-.76-.407-.825 0h.003zM197.518 129.516c-.54 2.252-.377 4.854-.354 7.165.019 2.167.041 4.334.058 6.501.019 2.607.257 5.286.047 7.885-.224 2.798-1.484 5.004-3.352 7.025-.219.235.053.556.329.429 5.06-2.345 4.8-9.114 4.728-13.753-.039-2.438-.083-4.874-.128-7.312-.047-2.56.117-5.455-.531-7.938-.102-.39-.706-.401-.8 0l.003-.002z"
                fill={lineColor}
            />
            <Path
                d="M178.216 167.158c-.395-1.826-.941-3.6-1.522-5.374l-.614.614c2.313.852 4.63 1.702 6.947 2.549.398.147.736-.36.536-.697a203.825 203.825 0 0 1-6.753-12.336l-.168.639c.985-.517 3.027 1.996 3.708 2.585a56.674 56.674 0 0 0 8.743 6.25c.407.238.93-.246.664-.664a149.452 149.452 0 0 1-6.924-11.99l-.723.722c4.16 2.749 8.328 5.48 12.505 8.204.379.246.955-.166.794-.609-1.431-3.911-3.244-7.655-5.494-11.162l-.62.808a43.051 43.051 0 0 1 8.635 4.832c.432.313.919-.279.692-.691a54.6 54.6 0 0 0-5.554-8.218l-.485.831c1.473.603 2.942 1.22 4.426 1.799.481.188.744-.474.462-.797-.999-1.143-1.619-2.414-1.99-3.881l-.526.526c.819.255 1.639.509 2.458.767.528.163.753-.662.227-.825-.819-.255-1.639-.509-2.458-.767-.321-.099-.603.222-.526.526.407 1.605 1.099 3.039 2.142 4.326l.576-.747c-1.5-.651-3.017-1.262-4.528-1.885-.512-.21-.755.498-.484.83a53.265 53.265 0 0 1 5.383 8.027l.692-.692c-2.76-2.035-5.682-3.712-8.854-5.018-.448-.186-.866.429-.62.808a53.496 53.496 0 0 1 5.403 10.894l.794-.609c-4.165-2.74-8.333-5.469-12.515-8.182-.465-.301-.958.28-.723.723a158.951 158.951 0 0 0 7 11.945l.664-.664a55.735 55.735 0 0 1-7.822-5.441c-1.118-.933-2.133-1.988-3.254-2.912-.734-.606-1.467-.911-2.339-.451-.232.122-.277.421-.169.639a227.754 227.754 0 0 0 6.739 12.344l.537-.698c-2.311-.866-4.622-1.735-6.933-2.598-.357-.133-.725.271-.614.614.581 1.807 1.201 3.59 1.965 5.331.136.31.587.08.52-.219v-.006z"
                fill={lineColor}
            />
            <Path
                d="m70.341 153.478 36.381 2.463s-3.977-5.577-3.841-5.391c.135.185 43.535-33.154 43.535-33.154l-12.169-15.341-29.163 22.028-15.242 10.179-11.178-13.988-8.32 33.207-.003-.003z"
                fill={fillColor}
            />
            <Path
                d="m160.55 59.012-47.338-1.11s11.677 15.131 11.542 14.948c-.136-.182-43.536 33.154-43.536 33.154l12.17 15.341 29.162-22.027 15.242-10.18 11.179 13.988 11.579-44.114z"
                fill={fillColor}
            />
            <Path
                d="M137.739 88.236c.55.686.069.473.207.969.155.564.46 1.018.795 1.491.611.87 1.273 1.708 1.926 2.544 1.259 1.605 2.518 3.208 3.775 4.816 1.257 1.608 2.604 3.512 4.218 4.915.393.343 1.24.022.988-.576-.808-1.915-2.322-3.578-3.604-5.192-1.281-1.613-2.576-3.208-3.871-4.807-.72-.892-1.442-1.796-2.215-2.64-.395-.435-.766-.828-1.287-1.11-.434-.236-.404.218-.921-.424-.009-.011-.022.006-.014.014h.003zM112.852 58.279c.376.274.221.454.307.819.103.426.366.778.623 1.124.764 1.024 1.616 2 2.438 2.978 1.179 1.4 2.345 2.814 3.504 4.231 1.464 1.791 2.903 3.817 4.719 5.264.515.41 1.248-.088.93-.716-1.079-2.12-2.859-4-4.384-5.812a363.866 363.866 0 0 0-3.673-4.312c-.841-.972-1.696-2.018-2.698-2.826-.604-.485-1.212-.371-1.758-.77-.011-.008-.022.011-.011.017l.003.003z"
                fill={lineColor}
            />
            <Path
                d="M116.336 61.957c-.379-1.52-1.801-3.033-2.684-4.315l-.443.77c7.888.41 15.798.528 23.694.63 3.863.05 7.73.078 11.593.084 3.864.005 8.182.315 12.162-.105.739-.078.755-1.102 0-1.163-3.906-.321-7.963.03-11.885.036-3.922.006-7.913-.011-11.87-.05-7.899-.077-15.795-.326-23.694-.456-.357-.006-.678.45-.443.769.949 1.276 1.954 3.15 3.294 4.008.141.09.312-.059.274-.21l.002.002z"
                fill={lineColor}
            />
            <Path
                d="M145.485 98.842c.565 1.53 2.145 2.875 3.197 4.099.255.296.769.13.861-.227 1.887-7.36 3.661-14.744 5.604-22.09.95-3.591 1.924-7.176 2.917-10.757 1.033-3.72 2.439-7.481 3.156-11.273.141-.744-.847-1.002-1.121-.31-1.384 3.499-2.151 7.368-3.147 10.994a887.595 887.595 0 0 0-2.959 11.029c-1.921 7.348-3.827 14.712-5.441 22.133l.861-.227c-1.069-1.152-2.237-2.87-3.651-3.582-.133-.066-.335.047-.274.21h-.003zM124.924 72.239c-2.028.847-3.766 2.161-5.571 3.41a223.012 223.012 0 0 0-5.466 3.93 617.32 617.32 0 0 0-11.292 8.54c-7.251 5.6-14.414 11.31-21.657 16.919-.252.194-.169.576 0 .784 4.11 4.995 7.943 10.196 11.973 15.252.36.451 1.118-.138.8-.617-1.774-2.657-3.853-5.142-5.826-7.653-1.973-2.51-4.066-5.208-6.16-7.763l-.112.869c7.28-5.613 14.5-11.3 21.807-16.88a628.932 628.932 0 0 1 11.131-8.325c1.813-1.32 3.64-2.624 5.464-3.933 1.788-1.284 3.667-2.444 5.219-4.01.202-.205 0-.645-.301-.52l-.009-.003z"
                fill={lineColor}
            />
            <Path
                d="M93.653 121.041c2-1.088 3.788-2.627 5.61-3.985a529.614 529.614 0 0 0 5.355-4.052c3.736-2.865 7.478-5.721 11.248-8.547a539.574 539.574 0 0 1 11.38-8.328 346.495 346.495 0 0 1 5.5-3.825c.896-.609 1.799-1.212 2.698-1.818.822-.55 1.73-1.01 2.317-1.821.218-.302-.141-.642-.446-.579-.996.208-1.838.925-2.679 1.476-.974.639-1.937 1.295-2.898 1.95a346.764 346.764 0 0 0-5.505 3.845 549.396 549.396 0 0 0-11.38 8.35 1371.534 1371.534 0 0 0-11.229 8.549 513.294 513.294 0 0 0-5.034 3.925c-1.785 1.409-3.734 2.732-5.314 4.37-.246.257.067.659.377.49z"
                fill={lineColor}
            />
            <Path
                d="M141.921 93.392c-.487-1.226-1.185-2.31-1.976-3.365-.476-.631-1.185-2.049-1.996-2.242-.863-.208-1.918.94-2.538 1.39-1.068.771-2.322 1.483-3.111 2.548-.232.316.155.8.515.67.891-.321 1.6-.936 2.375-1.472.775-.537 1.84-1.559 2.756-1.797l-.675-.18c1.592 1.348 2.66 3.291 4.248 4.678.161.14.496.008.399-.233l.003.003zM122.254 69.515c.431.537.899 1.041 1.292 1.606.169.24.479.63.57.91l.191.285-.556.308c-1.071.6-2.361 1.228-3.119 2.214-.249.324.16.747.503.656.961-.258 1.844-.977 2.666-1.525.478-.319 1.431-.709 1.555-1.36.125-.65-.495-1.275-.841-1.707-.557-.7-1.193-1.317-1.974-1.76-.249-.141-.451.171-.29.373h.003zM115.271 60.38a8.565 8.565 0 0 0-.853-1.249c-.296-.36-.777-.77-.943-1.21l-.529.696c.515-.061 1.029-.1 1.55-.114.432-.011.883.072 1.267-.144.136-.075.169-.285.05-.39-.332-.302-.783-.307-1.215-.36a13.718 13.718 0 0 0-1.652-.089.555.555 0 0 0-.529.695c.164.581.548.972.972 1.378.47.452.927.836 1.467 1.202.257.174.556-.164.412-.413l.003-.002zM90 134.589c-.551-.687-.07-.474-.208-.969-.155-.565-.46-1.019-.794-1.492-.612-.869-1.273-1.708-1.927-2.543-1.259-1.606-2.518-3.208-3.775-4.816-1.256-1.608-2.604-3.512-4.218-4.915-.392-.344-1.24-.023-.988.575.809 1.915 2.322 3.579 3.604 5.192 1.281 1.614 2.577 3.208 3.872 4.808.72.891 1.442 1.796 2.214 2.64.396.435.767.828 1.287 1.11.434.235.404-.219.922.423.008.011.022-.005.013-.013H90zM108.061 156.81l.033-.033a.604.604 0 0 0 .155-.59c-.301-1.013-1.184-1.862-1.835-2.676-.954-1.196-1.879-2.726-3.24-3.471-.438-.238-1.027.158-.87.667.216.701 4.664 7.238 5.754 6.103h.003z"
                fill={lineColor}
            />
            <Path
                d="M82.253 123.983c-.548-1.542-2.131-2.887-3.18-4.116-.269-.312-.805-.133-.905.238-1.459 5.577-2.72 11.207-4.157 16.792a588.51 588.51 0 0 1-2.081 7.879c-.795 2.931-1.869 5.89-2.414 8.873-.136.742.853 1.008 1.121.31 1.063-2.751 1.652-5.773 2.416-8.621a624 624 0 0 0 2.115-8.12c1.414-5.585 2.848-11.187 4.04-16.825l-.905.238c1.077 1.149 2.242 2.868 3.67 3.562.133.067.332-.044.274-.21h.006zM102.817 150.586c2.028-.847 3.766-2.162 5.571-3.41a230.165 230.165 0 0 0 5.466-3.93c3.8-2.798 7.559-5.657 11.292-8.541 7.251-5.599 14.414-11.309 21.657-16.919.252-.194.169-.576 0-.783-4.11-4.996-7.943-10.196-11.973-15.253-.36-.451-1.118.139-.8.617 1.774 2.657 3.853 5.143 5.826 7.653 2.043 2.599 4.066 5.209 6.161 7.763l.111-.869c-7.279 5.613-14.5 11.301-21.807 16.88a625.27 625.27 0 0 1-11.131 8.325c-1.813 1.321-3.64 2.624-5.464 3.933-1.823 1.309-3.667 2.444-5.219 4.011-.202.204 0 .644.301.52l.009.003z"
                fill={lineColor}
            />
            <Path
                d="M134.085 101.786c-2.001 1.088-3.788 2.627-5.61 3.986a519.367 519.367 0 0 0-5.355 4.052c-3.736 2.864-7.478 5.72-11.248 8.546a541.524 541.524 0 0 1-11.38 8.328 350.152 350.152 0 0 1-5.5 3.825c-.897.609-1.799 1.212-2.698 1.818-.822.551-1.73 1.01-2.317 1.821-.218.302.141.642.446.579.996-.208 1.838-.925 2.679-1.475A193.95 193.95 0 0 0 96 131.314a345.145 345.145 0 0 0 5.505-3.844 549.767 549.767 0 0 0 11.38-8.35c3.761-2.826 7.498-5.685 11.229-8.549a485.496 485.496 0 0 0 5.034-3.925c1.785-1.408 3.733-2.731 5.314-4.37.246-.257-.067-.659-.377-.49z"
                fill={lineColor}
            />
            <Path
                d="M85.818 129.432c.487 1.226 1.184 2.311 1.976 3.366.476.631 1.184 2.048 1.995 2.242.864.207 1.918-.941 2.538-1.39 1.069-.772 2.322-1.483 3.111-2.549.233-.315-.155-.8-.515-.669-.89.321-1.6.935-2.374 1.472-.775.537-1.84 1.558-2.757 1.796l.675.18c-1.591-1.348-2.66-3.291-4.248-4.677-.16-.141-.495-.009-.398.232l-.003-.003zM105.485 153.309c-.432-.537-.9-1.041-1.293-1.605-.169-.241-.479-.631-.57-.911l-.191-.285.556-.307c1.071-.601 2.361-1.229 3.119-2.214.249-.324-.16-.748-.503-.656-.961.257-1.844.977-2.666 1.525-.478.318-1.43.708-1.555 1.359-.125.65.495 1.276.841 1.707.557.701 1.193 1.318 1.974 1.761.249.141.451-.172.29-.374h-.002zM96.23 135.502c2.09-1.11 3.958-2.699 5.865-4.096 1.907-1.398 3.686-2.754 5.524-4.138s3.675-2.77 5.513-4.157c1.838-1.386 3.714-2.585 5.25-4.165.166-.172-.044-.435-.252-.327-2.086 1.099-3.957 2.726-5.848 4.127-1.848 1.367-3.694 2.737-5.543 4.104-1.849 1.37-3.701 2.735-5.527 4.13-1.827 1.394-3.678 2.604-5.234 4.193-.169.171.044.437.252.326v.003zM127.203 113.034c1.447-.924 2.991-1.782 4.359-2.82.155-.119.022-.371-.158-.269-1.495.845-2.898 1.927-4.32 2.887-.125.083-.011.282.119.202zM99.34 111.88c10.842-8.574 21.511-17.248 33.063-24.87.473-.313.03-1.077-.446-.761-11.474 7.616-22.86 15.875-32.655 25.595-.025.025.01.058.036.036h.003zM156.083 62.724c-.382.877-1.015 1.621-1.004 2.629.005.517.672.667.944.255.542-.823.409-1.752.561-2.674.045-.277-.365-.518-.498-.21h-.003zM153.094 73.307c-.628 2.184-1.256 4.381-2.001 6.53-.622 1.795-1.527 3.782-1.251 5.723.042.29.523.348.64.083.833-1.868 1.289-4.041 1.818-6.02.553-2.079.949-4.13 1.151-6.269.02-.207-.301-.24-.357-.047zM91.583 81.106c-.16-.132-.338-.202-.548-.155-.16.036-.305.18-.385.319a.85.85 0 0 0-.02.802c.164.319.576.474.89.28a.712.712 0 0 0 .312-.424.6.6 0 0 0-.02-.382c-.055-.13-.127-.188-.235-.268-.19-.141-.534-.042-.633.166-.034.066-.078.13-.084.205-.005.075.067-.108.02-.042a.384.384 0 0 1 .202-.157h.268l-.036-.009a.336.336 0 0 1 .164.094c-.053-.052.08.128.03.034.036.094.047.118.033.072-.01-.05-.008-.023.009.08v-.036c.002-.053 0-.025-.011.08 0-.011.005-.025.008-.036.017-.047.005-.025-.03.07.05-.098-.08.08-.028.03-.083.058-.103.074-.061.05a.524.524 0 0 0 .183-.183l.013-.025a.343.343 0 0 1-.124.127c.116-.086.19-.174.21-.32.017-.128-.016-.286-.122-.372h-.005zM77.177 77.658c-.813.55-1.52 1.126-2.156 1.88-.548.647-1.256 1.325-1.09 2.235.044.241.326.36.542.308.797-.189 1.146-1.013 1.611-1.609.545-.7 1.085-1.408 1.644-2.1.296-.368-.086-1.027-.55-.714z"
                fill={lineColor}
            />
            <Path
                d="M73.272 78.646c.869.886 1.718 1.788 2.637 2.618.767.692 1.525 1.567 2.544 1.86.335.097.528-.26.41-.534-.446-1.027-1.545-1.75-2.378-2.458-.877-.744-1.816-1.42-2.729-2.12-.37-.282-.797.316-.487.631l.003.003zM165.072 95.33c-.802.666-1.621 1.314-2.377 2.03-.62.59-1.564 1.219-1.727 2.11-.064.349.199.6.543.542.893-.152 1.533-1.085 2.136-1.7.728-.74 1.389-1.552 2.068-2.34.384-.449-.194-1.016-.643-.643z"
                fill={lineColor}
            />
            <Path
                d="M160.694 96.428c.615.836 1.262 1.636 2.073 2.289.736.592 1.528 1.26 2.51 1.309.352.019.615-.426.416-.722-.485-.712-1.282-1.105-1.968-1.594-.806-.573-1.611-1.155-2.356-1.802-.34-.296-.979.102-.672.517l-.003.003zM64.061 103.63l.072-.216a.557.557 0 0 0-.144-.543.557.557 0 0 0-.542-.144l-.216.072a.69.69 0 0 0-.473.474.676.676 0 0 0 1.303.357zM170.857 88.629l-.476.2c-.216.09-.399.298-.316.553.092.276.332.476.634.467a.77.77 0 0 0 .623-.37c.171-.302.069-.704-.285-.806a1.45 1.45 0 0 0-.861.028c-.352.124-.393.548-.1.758.271.197.631.244.95.138a.376.376 0 0 0 .268-.412c-.025-.166-.18-.349-.368-.326-.064.008-.141.01-.202.024-.086.025-.152.086-.216.144l.13-.074-.1.025c-.254.06-.265.47 0 .525.034.009.067.014.1.022l-.13-.074c.066.055.13.116.216.14.064.018.135.018.202.023v-.75a.83.83 0 0 1-.166.003c.064.008-.053-.014-.058-.017a.61.61 0 0 1-.119-.044c.058.028-.072-.053-.083-.061l-.1.758a.616.616 0 0 1 .465-.013l-.291-.291c.014.05.017.03.006-.053a.143.143 0 0 1 .011-.108c.008-.022.086-.11.039-.066l.05-.041c-.031.016-.028.016.011 0 .074-.028-.003 0-.017 0 .1-.017.058-.014-.011-.012-.039 0-.017 0 .066.009l.07.03c.025.017.119.136.088.078l-.16.617c.149-.089.299-.177.451-.263a.414.414 0 0 0 .169-.518c-.075-.168-.297-.32-.49-.24v-.003zM136.377 45.506c-1.356.368-3.138 1.01-3.855 2.325-.191.351.136.916.57.744.651-.254 1.174-.728 1.755-1.104.617-.401 1.212-.816 1.868-1.157.448-.232.136-.935-.34-.805l.002-.003z"
                fill={lineColor}
            />
            <Path
                d="M132.749 45.448c.764 1.17 1.541 2.294 2.607 3.213.396.343 1.11-.105.775-.598-.806-1.173-1.821-2.078-2.912-2.978-.243-.199-.667.056-.468.363h-.002zM66.444 137.293c-.443-.186-.985.024-1.206.442a.498.498 0 0 0 .074.584c.529.551 1.534.258 1.708-.478a.53.53 0 0 0-.133-.501c-.144-.144-.313-.158-.5-.133-.078.011-.156.022-.233.03-.222.031-.382.296-.382.501a.57.57 0 0 0 .02.138c.088.291.353.41.638.363l.23-.039-.634-.634c-.008.042-.05.122 0 .02-.027.055-.01.008.014-.014-.08.075.089-.033-.014.014-.083.039.059 0 0 .003-.027 0-.066.019-.091.022.075-.014.055.008.003-.009-.058-.019.097.02.002 0-.077-.016.023.014.05.039l.125.468c-.028.072.028-.039.039-.055.03-.045.033-.053.01-.025l.05-.05a.244.244 0 0 1 .142-.047.325.325 0 0 0 .318-.282c.02-.175-.078-.291-.233-.357h.003zM135.359 137.813c-.554.39-1.041.797-1.484 1.312-.368.429-.974 1.002-.946 1.599.011.241.26.51.526.402.539-.222.783-.811 1.129-1.26.39-.503.8-1.001 1.215-1.483.252-.291-.081-.825-.44-.57z"
                fill={lineColor}
            />
            <Path
                d="M132.624 138.117c.471.518.955 1.03 1.473 1.503.44.404.982.897 1.58 1.024a.342.342 0 0 0 .382-.495c-.277-.537-.858-.941-1.326-1.312a27.296 27.296 0 0 1-1.522-1.306c-.393-.363-.947.191-.587.586z"
                fill={lineColor}
            />
        </Svg>
    );
};
