import { Screen, ScreenSubHeader } from '@suite-native/navigation';
import { VStack } from '@suite-native/atoms';
import { useTranslate } from '@suite-native/intl';

import { FAQInfoPanel } from '../components/FAQInfoPanel';
import { SupportCard } from '../components/SupportCard';

export const SettingsFAQScreen = () => {
    const { translate } = useTranslate();

    return (
        <Screen
            screenHeader={<ScreenSubHeader content={translate('moduleSettings.faq.title')} />}
            noTopPadding
        >
            <VStack spacing="sp24">
                <FAQInfoPanel />
                <SupportCard />
            </VStack>
        </Screen>
    );
};
