import { createNativeStackNavigator } from '@react-navigation/native-stack';

import {
    SendStackParamList,
    SendStackRoutes,
    stackNavigationOptionsConfig,
} from '@suite-native/navigation';

import { SendAccountsScreen } from '../screens/SendAccountsScreen';
import { SendOutputsScreen } from '../screens/SendOutputsScreen';
import { SendFeesScreen } from '../screens/SendFeesScreen';
import { SendAddressReviewScreen } from '../screens/SendAddressReviewScreen';
import { SendOutputsReviewScreen } from '../screens/SendOutputsReviewScreen';
import { SendDestinationTagReviewScreen } from '../screens/SendDestinationTagReviewScreen';

const SendStack = createNativeStackNavigator<SendStackParamList>();

export const SendStackNavigator = () => (
    <SendStack.Navigator
        initialRouteName={SendStackRoutes.SendAccounts}
        screenOptions={stackNavigationOptionsConfig}
    >
        <SendStack.Screen name={SendStackRoutes.SendAccounts} component={SendAccountsScreen} />
        <SendStack.Screen name={SendStackRoutes.SendOutputs} component={SendOutputsScreen} />
        <SendStack.Screen name={SendStackRoutes.SendFees} component={SendFeesScreen} />
        <SendStack.Group
            screenOptions={{
                gestureEnabled: false, // To not interrupt send review by back navigation.
            }}
        >
            <SendStack.Screen
                name={SendStackRoutes.SendDestinationTagReview}
                component={SendDestinationTagReviewScreen}
            />
            <SendStack.Screen
                name={SendStackRoutes.SendAddressReview}
                component={SendAddressReviewScreen}
            />
            <SendStack.Screen
                name={SendStackRoutes.SendOutputsReview}
                component={SendOutputsReviewScreen}
            />
        </SendStack.Group>
    </SendStack.Navigator>
);
