import * as React from 'react';
import Svg, { G, Path, ClipPath, Defs, Rect } from 'react-native-svg';

import { useNativeStyles } from '@trezor/styles';

export const ReviewSuccessSvg = () => {
    const { utils } = useNativeStyles();
    const lineColor = utils.colors.backgroundPrimaryDefault;

    return (
        <Svg width="106" height="80" viewBox="0 0 106 80" fill="none">
            <G clipPath="url(#clip0_2225_18577)">
                <Path
                    d="M17.926 69.6146C19.0812 69.9179 20.4598 69.778 21.6531 69.7835C23.0354 69.7907 24.4176 69.7689 25.7981 69.7526C28.5008 69.7199 31.2054 69.6636 33.9081 69.5873C34.7128 69.5637 34.7146 68.3105 33.9081 68.3359C31.2054 68.4194 28.5026 68.4812 25.7981 68.5175C24.4758 68.5357 23.1553 68.543 21.833 68.5557C20.5106 68.5684 19.1411 68.4176 17.926 68.7282C17.4864 68.8408 17.49 69.5001 17.926 69.6146Z"
                    fill={lineColor}
                />
                <Path
                    d="M0.718829 30.8222C1.01126 31.5342 1.2038 32.2716 1.44719 33C1.78322 34.008 2.27182 35.0033 2.71682 35.9659C3.88293 38.4851 4.90372 41.0642 6.20968 43.5144C9.23755 49.1921 10.974 55.4129 13.4479 61.3303C14.614 64.122 15.7892 66.9935 17.6164 69.4219C17.9343 69.8433 18.6953 69.6235 18.5264 69.0386C17.789 66.4704 16.6537 64.0911 15.6112 61.6337C14.3815 58.7349 13.0011 55.9269 11.6497 53.0862C10.2275 50.0966 8.8434 46.9744 7.84622 43.8177C6.9889 41.1042 5.90272 38.5269 4.73662 35.9332C3.83025 33.9172 2.8367 32.0954 1.31641 30.4735C1.08573 30.2283 0.580786 30.4826 0.718829 30.8222Z"
                    fill={lineColor}
                />
                <Path
                    d="M53.142 53.1843C54.1392 52.7538 55.0674 51.6404 55.8884 50.9303C56.8274 50.1184 57.7629 49.3047 58.6928 48.4837C60.5655 46.8327 62.4363 45.1799 64.3054 43.5253C68.0707 40.1924 71.7416 36.7542 75.476 33.3832C81.401 28.0342 87.2769 22.6362 93.1419 17.2201C94.4588 16.0032 95.7992 14.779 96.9127 13.3877C97.0852 13.1716 96.7801 12.8628 96.6057 13.0808C96.3169 13.4422 95.881 13.7346 95.5286 14.0289C94.773 14.6591 94.0519 15.3202 93.3254 15.9832C90.9387 18.1609 88.5429 20.3314 86.1144 22.46C82.7614 25.3988 79.3666 28.2921 76.0064 31.2254C72.2356 34.5165 68.3831 37.7168 64.6251 41.0188C62.4945 42.8914 60.3602 44.7622 58.226 46.6311C57.1853 47.5429 56.1427 48.4547 55.1092 49.3755C54.6024 49.826 54.0956 50.2764 53.5907 50.7269C53.0857 51.1773 52.4863 51.5878 52.1376 52.1726C51.7253 52.8646 52.5154 53.4531 53.1457 53.1806L53.142 53.1843Z"
                    fill={lineColor}
                />
                <Path
                    d="M34.1865 69.5853C34.8259 69.1294 35.4471 68.6372 36.0483 68.1305C37.129 67.2187 38.3206 66.3396 39.2633 65.2862C40.5438 63.8568 42.1313 62.6308 43.548 61.3358C44.389 60.5675 45.1719 59.7465 46.0219 58.9873C46.872 58.2281 47.8456 57.4544 48.5612 56.4936C48.6992 56.3083 48.4395 56.1012 48.2633 56.1957C47.257 56.7478 46.4324 57.5434 45.5588 58.2826C44.6851 59.0218 43.7497 59.6975 42.8615 60.4276C41.3466 61.6736 39.8645 63.054 38.2352 64.1474C36.437 65.3534 34.9022 66.9626 33.1948 68.2958C32.4701 68.8624 33.4291 70.1193 34.1865 69.5799V69.5853Z"
                    fill={lineColor}
                />
                <Path
                    d="M16.8479 19.8317C17.3601 20.867 17.8505 22.024 18.2265 23.0992C18.3936 23.5769 18.8132 23.9093 19.0802 24.3397C19.3962 24.8537 19.6487 25.4222 19.9284 25.9562C20.5387 27.1223 21.1418 28.2919 21.7321 29.4671C23.0489 32.088 24.3585 34.7125 25.6627 37.3389C26.2621 38.5485 26.8597 39.7581 27.4554 40.9696C27.7152 41.4981 27.9894 42.0085 28.1602 42.5716C28.3418 43.1746 28.4435 43.6722 28.7614 44.2226C29.2336 45.0399 29.5333 45.9862 29.9511 46.838C30.0855 47.1105 30.1999 47.3883 30.3816 47.6335C30.5723 47.8915 30.7067 47.9732 30.9901 48.1239C31.1626 48.2148 30.8139 48.0422 30.9864 48.1239C31.3933 48.3128 31.7584 48.1475 31.9237 47.7425C32.356 46.6818 31.1118 45.0562 30.6068 44.1826C30.3325 43.7086 30.1654 43.1292 29.8349 42.7041C29.4716 42.2337 29.0847 41.8432 28.8013 41.3074C28.1892 40.1523 27.588 38.9898 26.9814 37.8311C25.6245 35.2374 24.2623 32.6438 22.8945 30.0556C22.2352 28.8096 21.5759 27.5636 20.9311 26.3104C20.3989 25.2733 19.8013 24.2707 19.4653 23.1519C19.3127 22.6451 18.9185 22.2419 18.6461 21.7769C18.4354 21.4137 18.2356 21.0377 18.0049 20.6854C17.7579 20.3094 17.4745 19.9152 17.1676 19.5829C17.0023 19.4049 16.748 19.6301 16.8461 19.8299L16.8479 19.8317Z"
                    fill={lineColor}
                />
                <Path
                    d="M2.37502 33.4611C2.39318 32.8327 2.27512 32.355 2.07532 31.752C1.85735 31.1 1.49045 30.8184 1.0745 30.2554L1.01638 30.6986C2.80368 29.0585 4.73628 27.5836 6.73791 26.2142C7.18837 25.9054 7.64427 25.6057 8.10381 25.3097C8.64146 24.9646 9.22269 24.8901 9.77668 24.5995C10.5977 24.169 11.9363 23.7622 11.9527 22.6797C11.9563 22.4617 11.831 22.2329 11.6366 22.1275C10.6376 21.5917 9.61502 22.6397 8.84307 23.2137C8.40533 23.5406 8.1583 23.991 7.71511 24.3216C7.18837 24.7157 6.64709 25.0899 6.12216 25.484C4.16595 26.9516 2.31871 28.5481 0.498717 30.1791C0.387919 30.279 0.351592 30.497 0.440594 30.6223C0.783885 31.1018 0.911031 31.6158 1.21618 32.1116C1.50316 32.5766 1.71931 33.087 1.99358 33.5628C2.09711 33.7427 2.36775 33.6591 2.37502 33.4593V33.4611Z"
                    fill={lineColor}
                />
                <Path
                    d="M31.826 48.1878C33.8258 47.1616 35.6312 45.5487 37.3931 44.1592C39.2276 42.7135 41.0186 41.215 42.7895 39.6912C46.3405 36.6362 49.7716 33.4414 53.2517 30.3083C55.0717 28.6682 56.9299 27.0626 58.7099 25.3789C59.5509 24.5852 60.1775 23.6443 60.9985 22.8361C61.9448 21.9061 62.9057 21.0216 63.9192 20.1643C65.7483 18.6169 67.6682 17.1929 69.4918 15.6418C71.2609 14.1361 73.0137 12.6122 74.7774 11.0993C75.7401 10.2728 76.7282 9.48458 77.62 8.58189C78.5627 7.63197 79.5399 6.64392 80.6388 5.87744C81.7286 5.11824 82.8983 4.53339 84.0081 3.81233C85.1179 3.09126 86.1496 2.24124 87.2267 1.43845C87.6136 1.14966 87.283 0.535755 86.8399 0.77732C85.8572 1.31312 84.8836 1.77991 83.9718 2.44285C83.06 3.1058 82.2463 3.91949 81.3581 4.66053C80.4699 5.40158 79.5272 6.14625 78.5282 6.81283C77.5819 7.4449 76.5919 8.04427 75.7128 8.76715C73.9255 10.2383 72.1455 11.7386 70.4581 13.3242C68.758 14.9225 67.1578 16.5826 65.534 18.2572C63.7557 20.0917 61.8576 22.086 59.6944 23.4645C57.6619 24.7613 55.9527 26.594 54.1781 28.2195C50.6852 31.418 47.1851 34.5892 43.536 37.6079C41.5144 39.2807 39.4601 40.9099 37.3422 42.4556C36.2651 43.242 35.1771 44.0158 34.071 44.7568C32.9648 45.4978 31.8677 46.119 30.8651 46.94C30.1386 47.5339 31.0649 48.5746 31.8241 48.1841L31.826 48.1878Z"
                    fill={lineColor}
                />
                <Path
                    d="M86.6444 1.50194C87.182 1.33666 87.5162 2.11766 87.796 2.46094C88.2718 3.04033 88.7695 3.59793 89.2381 4.18459C90.0283 5.1781 90.7984 6.18614 91.5504 7.21052C92.237 8.14409 92.9108 9.08674 93.5901 10.0239C93.9407 10.5089 94.2731 11.0193 94.6563 11.4788C95.1631 12.0891 95.8842 12.5359 96.213 13.2678C96.5054 13.9199 97.5643 13.1607 96.9958 12.6648C96.3038 12.0618 95.9714 10.9266 95.4374 10.1692C94.996 9.54445 94.5564 8.91601 94.1187 8.28758C93.2959 7.11063 92.4713 5.93549 91.6139 4.78397C90.6277 3.45626 89.6123 2.15944 88.6751 0.799041C88.29 0.241442 87.7651 -0.150875 87.0621 0.0579973C86.5663 0.205116 86.1612 0.595617 86.1485 1.12416C86.1431 1.3748 86.4064 1.57823 86.6462 1.50376L86.6444 1.50194Z"
                    fill={lineColor}
                />
                <Path
                    d="M17.4052 68.6881L17.2708 68.8188C17.1945 68.8933 17.1527 69.0259 17.1891 69.1294C17.3653 69.6289 17.7285 69.934 18.0228 70.3681C18.406 70.933 18.6785 71.5741 19.0526 72.1554C19.7265 73.2034 20.3568 74.344 21.1814 75.283C21.3067 75.4265 21.5211 75.4247 21.6773 75.3466L21.8044 75.283C21.9352 75.2176 21.9516 75.0505 21.8952 74.9343C21.3594 73.8209 20.3949 72.7911 19.6611 71.7994C19.247 71.24 18.733 70.7477 18.3406 70.1829C18.0155 69.7143 17.9447 69.2003 17.6867 68.7262C17.6304 68.6227 17.4869 68.6118 17.4052 68.6899V68.6881Z"
                    fill={lineColor}
                />
                <Path
                    d="M21.4124 75.5283C24.1296 75.0906 26.9395 75.403 29.6786 75.5411C32.4558 75.6809 35.2349 75.8226 38.0121 75.9624C38.6859 75.9969 38.6841 74.9489 38.0121 74.9144C35.1168 74.7673 32.2197 74.622 29.3244 74.4749C26.5872 74.3369 23.9426 74.3677 21.2489 74.9362C20.8584 75.018 21.0291 75.5883 21.4124 75.5265V75.5283Z"
                    fill={lineColor}
                />
                <Path
                    d="M33.47 69.1801C34.0204 70.4388 34.9649 71.603 35.7623 72.7182C36.5596 73.8334 37.3443 74.7833 38.3596 75.6116C38.8719 76.0293 39.6075 75.3319 39.1007 74.8705C38.129 73.9896 37.2589 73.0216 36.4343 72.0026C35.5988 70.9692 34.8523 69.7668 33.8514 68.8877C33.6353 68.6988 33.361 68.9331 33.47 69.1819V69.1801Z"
                    fill={lineColor}
                />
                <Path
                    d="M101.103 19.4449C101.152 19.4449 101.152 19.3686 101.103 19.3686C101.054 19.3686 101.054 19.4449 101.103 19.4449Z"
                    fill={lineColor}
                />
                <Path
                    d="M96.0372 12.3325C96.0735 12.4688 96.1171 12.5814 96.217 12.6831C96.4132 12.8792 96.7202 12.7249 96.7383 12.4669C96.7528 12.2508 96.5222 11.8494 96.3387 11.7386C96.0626 11.5715 95.7902 11.8458 95.8374 12.1237C95.9228 12.6177 96.286 13.1353 96.5349 13.5567C96.9508 14.2669 97.3958 14.9625 97.8445 15.6527C98.7363 17.0222 99.6699 18.3626 100.649 19.6703C101.043 20.1971 101.94 19.7085 101.553 19.1418C100.678 17.8613 99.7426 16.6244 98.8253 15.373C98.3494 14.7246 97.879 14.0707 97.4303 13.4042C97.1397 12.9737 96.6566 12.4397 96.4967 11.942L95.9954 12.3271C95.9954 12.3271 96.1444 12.6867 96.128 12.4669L96.5876 12.2036C96.5185 12.1527 96.4768 12.1091 96.3932 12.0583C96.2098 11.9475 95.9845 12.1291 96.0372 12.3325Z"
                    fill={lineColor}
                />
                <Path
                    d="M38.2565 75.5155C38.4818 75.3593 38.6997 75.1886 38.9195 75.0251C39.4154 74.6528 39.9766 74.413 40.467 74.057C42.1381 72.8438 43.6475 71.2945 45.2041 69.9377C47.4673 67.9671 49.814 66.0981 52.0572 64.1038C54.7854 61.6809 57.5118 59.2562 60.2399 56.8314C66.1722 51.5569 72.0844 46.2588 77.9948 40.9589C83.1569 36.331 88.3118 31.6977 93.4484 27.0426C96.0458 24.6887 98.8085 22.411 101.184 19.8265C101.237 19.7702 101.29 19.7084 101.342 19.6521C101.506 19.4796 101.21 19.7756 101.357 19.6557C101.715 19.367 101.206 18.8638 100.852 19.1508C100.692 19.2798 101.07 18.9855 100.843 19.1508C100.796 19.1853 100.748 19.2216 100.699 19.2562C100.552 19.3633 100.407 19.4741 100.26 19.5849C99.7657 19.9572 99.2844 20.3405 98.8103 20.7364C97.221 22.0678 95.6462 23.4154 94.0842 24.7813C89.0892 29.1513 84.1105 33.5394 79.1482 37.9475C73.2124 43.2202 67.2711 48.4838 61.357 53.7801C58.5761 56.2702 55.7953 58.7621 53.0126 61.2523C50.6205 63.3937 48.3101 65.6041 45.9597 67.7891C44.2469 69.3801 42.5014 70.9367 40.7686 72.5059C39.8731 73.3178 39.1066 74.2351 38.3074 75.145C38.2493 75.2104 38.1821 75.2721 38.1185 75.3321C38.0259 75.4193 38.1494 75.5882 38.2584 75.5119L38.2565 75.5155Z"
                    fill={lineColor}
                />
                <Path
                    d="M19.6579 72.359C20.5044 71.34 21.5488 70.5572 22.7657 70.0341L22.219 69.6127C21.9792 71.2655 21.5415 72.902 21.0747 74.5022C20.9839 74.8146 21.3544 75.1143 21.636 74.9344C24.0572 73.3851 25.4049 70.441 28.0277 69.2204L27.4973 68.6901C26.9361 69.8634 26.4384 71.0676 25.9389 72.2681C25.5811 73.1272 24.771 74.2769 25.167 75.2087C25.305 75.532 25.7282 75.4266 25.8917 75.2087C26.7308 74.0862 27.7662 73.0691 28.7379 72.0629C29.7169 71.0494 30.7759 70.0632 31.9111 69.2259L31.4625 68.7772C30.3981 70.5772 29.7006 72.5533 29.123 74.5566C28.9958 74.9998 29.5426 75.265 29.8586 74.9853C31.4061 73.6158 33.0645 72.4153 34.8391 71.3564L34.2996 70.8169C33.6312 72.0556 33.2007 73.4469 32.9155 74.82C32.8465 75.1506 33.1408 75.5592 33.5149 75.4194C34.6157 75.0089 35.6383 74.4804 36.5955 73.7938L35.9035 73.396C35.9543 73.9682 36.0015 74.5421 36.0488 75.1161C36.0996 75.7209 37.0532 75.7191 36.9933 75.1161C36.9333 74.5131 36.8788 73.97 36.8243 73.396C36.7935 73.08 36.4447 72.7803 36.1323 72.9983C35.235 73.6213 34.2905 74.1171 33.2588 74.4786L33.8582 75.0779C34.1706 73.7284 34.6048 72.437 35.0225 71.1202C35.1297 70.7824 34.7337 70.5136 34.4431 70.6753C32.5777 71.7124 30.8394 72.9529 29.2374 74.3623L29.973 74.791C30.5397 72.8221 31.3208 70.9386 32.0619 69.0297C32.189 68.7028 31.7349 68.5102 31.5133 68.71C30.4417 69.6817 29.3791 70.6553 28.3329 71.6579C27.2921 72.655 26.3276 73.7629 25.2323 74.7001L25.9335 74.8854C25.8644 74.4858 26.195 73.9845 26.3458 73.6231C26.5674 73.0927 26.7908 72.5624 27.0087 72.0302C27.4211 71.0203 27.8388 70.0159 28.2039 68.9879C28.322 68.6574 27.9133 68.3922 27.6354 68.5502C25.0816 70.0014 23.7593 72.813 21.2473 74.2733L21.8085 74.7056C22.3534 73.0982 22.6695 71.4817 22.9328 69.8107C22.971 69.5691 22.7675 69.2295 22.4751 69.353C21.1383 69.9106 20.0448 70.7098 19.1494 71.8522C18.8715 72.2064 19.3564 72.7168 19.6543 72.3571L19.6579 72.359Z"
                    fill={lineColor}
                />
                <Path
                    d="M16.9836 19.6611L16.9291 19.8154C16.8764 19.9608 16.94 20.1297 17.0399 20.2368C18.6383 21.9187 20.4692 23.3681 21.9604 25.1535C22.4091 25.6911 23.1828 24.9156 22.7306 24.3834C21.2521 22.6361 19.4302 21.0578 17.652 19.6247C17.4849 19.4903 17.3214 19.4704 17.1289 19.5575C17.0653 19.5866 17.009 19.5957 16.9854 19.6611H16.9836Z"
                    fill={lineColor}
                />
                <Path
                    d="M21.9821 24.309C22.0421 24.4107 22.1165 24.4943 22.0203 24.5869C21.8477 24.7522 21.8477 24.9956 21.9422 25.1972C23.2881 28.0542 24.8574 30.8095 26.3414 33.5975C28.0996 36.8995 29.9596 40.1506 31.8649 43.3709C32.3281 44.1555 32.7713 44.962 33.2853 45.7157C33.4379 45.9409 33.8084 45.7284 33.6522 45.5014C33.2363 44.8911 32.9584 44.1392 32.6351 43.4799C31.9176 42.0123 31.202 40.5448 30.47 39.0826C28.6954 35.5336 26.859 32.0264 24.9882 28.5282C24.2925 27.2278 23.6078 25.9328 22.8122 24.6904C22.6905 24.5015 22.4653 24.3998 22.2437 24.4598C22.1292 24.4906 22.0893 24.3635 22.0239 24.2799C22.0057 24.2563 21.9694 24.2872 21.9839 24.3108L21.9821 24.309Z"
                    fill={lineColor}
                />
                <Path
                    d="M87.2813 23.8677C88.6073 22.718 89.6099 21.1742 90.7033 19.8047L89.9986 19.5123C89.8478 21.0089 89.806 22.4619 90.0167 23.9567C90.1239 24.7214 90.2529 25.4988 90.4908 26.2344C90.707 26.9046 91.072 27.4767 91.3717 28.1088C91.4353 28.2413 91.6751 28.2159 91.6987 28.0652C92.447 23.4718 93.882 19.0419 95.9163 14.8572L95.4567 14.7972C96.1778 18.0011 94.6884 21.2051 95.2678 24.4253C95.3114 24.6669 95.6584 24.6814 95.771 24.4907C97.1205 22.2077 97.8344 19.6776 98.5791 17.1529L97.8979 17.0603C97.947 18.5642 97.9688 20.0735 98.0632 21.5756C98.0886 21.9824 98.6227 22.1586 98.8461 21.7881C99.4927 20.7147 100.15 19.6485 100.808 18.5824C101.084 18.1337 100.377 17.7214 100.101 18.1701C99.4437 19.238 98.7879 20.3042 98.1195 21.3649L98.9024 21.5774C98.8388 20.0717 98.6989 18.566 98.59 17.0621C98.5627 16.6898 98.0105 16.5717 97.9088 16.9695C97.2767 19.4651 96.5611 21.9588 95.2951 24.2146L95.7982 24.28C95.1461 21.0688 96.6537 17.8795 95.9417 14.6646C95.8963 14.4612 95.5766 14.4122 95.4822 14.6047C93.4152 18.8203 92.0438 23.3283 91.3536 27.9707H91.6987C91.3318 26.6121 91.0938 25.0629 90.9304 23.6643C90.7669 22.2658 90.707 20.8872 90.825 19.5123C90.8541 19.1763 90.3382 18.9402 90.1203 19.2199C89.025 20.6366 87.7408 21.9915 86.9199 23.588C86.7982 23.8241 87.0833 24.0385 87.2813 23.8659V23.8677Z"
                    fill={lineColor}
                />
                <Path
                    d="M26.3991 22.4474C27.6452 24.8958 28.9511 27.3114 30.2589 29.7271C30.8837 30.8822 31.5213 32.0301 32.2315 33.1344C33.007 34.3386 33.848 35.5065 34.5037 36.7815C34.5201 36.8124 34.5655 36.8324 34.6 36.8197C35.0777 36.6526 35.2684 36.273 35.5536 35.8589C35.7098 35.63 35.3465 35.3448 35.1649 35.5592C34.9832 35.7735 34.8234 36.0187 34.6345 36.2276C34.4274 36.4582 34.6054 36.4128 34.4674 36.3856C34.1477 36.3238 33.6791 34.7927 33.5229 34.4494C32.8745 33.0345 32.2242 31.6233 31.4704 30.2593C29.9683 27.5439 28.4407 24.8431 26.855 22.1768C26.6807 21.8826 26.2466 22.1423 26.3991 22.4438V22.4474Z"
                    fill={lineColor}
                />
                <Path
                    d="M103.63 23.0015C97.5961 28.4268 91.5276 33.9446 86.0531 39.9402C85.8206 40.1945 86.1676 40.5287 86.4273 40.3143C92.6829 35.1343 98.4952 29.344 104.209 23.5809C104.582 23.205 104.021 22.6528 103.632 23.0034L103.63 23.0015Z"
                    fill={lineColor}
                />
                <Path
                    d="M105.54 28.561C101.5 31.5252 97.3444 34.3332 93.6627 37.7514C93.412 37.9839 93.7444 38.4344 94.0332 38.2327C98.1654 35.3685 101.804 31.9139 105.571 28.6028C105.593 28.5846 105.563 28.5447 105.54 28.5629V28.561Z"
                    fill={lineColor}
                />
                <Path
                    d="M12.4114 68.8355C13.394 70.7843 14.2895 72.7477 14.9306 74.8365C15.2249 75.7973 15.5373 76.7508 15.8297 77.7116C16.0622 78.4781 16.0477 79.4734 16.7434 79.9493C16.9268 80.0746 17.1393 79.9366 17.2065 79.7604C17.5117 78.9703 16.7942 77.926 16.5018 77.1777C16.144 76.2604 15.7535 75.3741 15.3103 74.495C14.3567 72.6024 13.443 70.6863 12.4259 68.8246C12.4204 68.8155 12.4059 68.8246 12.4114 68.8336V68.8355Z"
                    fill={lineColor}
                />
                <Path
                    d="M73.027 7.46505C75.312 5.97025 77.5188 4.37192 79.5368 2.53021C79.8656 2.23052 79.4405 1.68382 79.0627 1.91449C76.7323 3.34027 74.5836 5.0167 72.5129 6.79666C72.1479 7.11087 72.6256 7.72841 73.0288 7.46505H73.027Z"
                    fill={lineColor}
                />
            </G>
            <Defs>
                <ClipPath id="clip0_2225_18577">
                    <Rect
                        width="105.222"
                        height="80"
                        fill="white"
                        transform="translate(0.390625)"
                    />
                </ClipPath>
            </Defs>
        </Svg>
    );
};
