import { Dimensions } from 'react-native';
import Svg, {
    Rect,
    Path,
    G,
    Circle,
    Defs,
    LinearGradient,
    Stop,
    ClipPath,
    SvgProps,
} from 'react-native-svg';

const SVG_HEIGHT = Dimensions.get('window').height * 0.35;

export const GraphSvg = (props: SvgProps) => (
    <Svg width={328} height={SVG_HEIGHT} viewBox="0 0 328 276" fill="none" {...props}>
        <Rect x={124} y={18} width={1} height={99} rx={0.5} fill="#E2E2E2" />
        <Path
            stroke="url(#paint0_linear_14530_54776)"
            strokeDasharray="2 2"
            d="M4 100.5L324 100.5"
        />
        <Path
            d="M4 99.856l15.608 6.262a8 8 0 008.051-1.238l15.39-12.616a8 8 0 012.093-1.239l11.916-4.779a8 8 0 0110.187 3.955l10.276 21.342c2.77 5.755 10.836 6.102 14.09.607l10.839-18.297a7.996 7.996 0 014.448-3.544l13.357-4.268a8.001 8.001 0 005.086-4.892l13.335-36.762c2.224-6.129 10.451-7.167 14.127-1.784l7.715 11.297a7.999 7.999 0 009.297 3.023l11.209-4.004a8 8 0 004.422-3.873l10.219-19.854c3.188-6.192 12.217-5.637 14.622.9l10.34 28.113c1.744 4.742 7.393 6.7 11.698 4.053l9.395-5.776a8 8 0 014.945-1.15L264 56.977l16.339.452a8.002 8.002 0 015.977 2.939l15.488 18.976a8 8 0 005.661 2.923L324 83.376"
            stroke="url(#paint1_linear_14530_54776)"
        />
        <G filter="url(#filter0_d_14530_54776)">
            <Rect x={131} y={75} width={91} height={15.5} rx={7.75} fill="#fff" />
            <Path
                d="M141.5 79.656v6.188M138.969 83.313l2.531 2.53 2.531-2.53"
                stroke="#757575"
                strokeWidth={0.75}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <Path
                d="M151.565 85.84c-.336 0-.657-.072-.963-.216a2.392 2.392 0 01-.81-.63 3.222 3.222 0 01-.549-1.017 4.408 4.408 0 01-.198-1.377c0-.516.066-.975.198-1.377.138-.402.321-.741.549-1.017.234-.276.504-.486.81-.63.306-.144.627-.216.963-.216.336 0 .657.072.963.216.306.144.573.354.801.63a3 3 0 01.549 1.017c.138.402.207.861.207 1.377s-.069.975-.207 1.377a3 3 0 01-.549 1.017 2.306 2.306 0 01-.801.63 2.235 2.235 0 01-.963.216zm0-.9c.204 0 .399-.048.585-.144.192-.096.36-.24.504-.432.15-.198.267-.441.351-.729a3.55 3.55 0 00.135-1.035c0-.396-.045-.738-.135-1.026a2.116 2.116 0 00-.351-.729 1.398 1.398 0 00-.504-.441 1.259 1.259 0 00-.585-.144c-.204 0-.402.048-.594.144a1.504 1.504 0 00-.504.441 2.357 2.357 0 00-.351.729 3.69 3.69 0 00-.126 1.026c0 .396.042.741.126 1.035.09.288.207.531.351.729.15.192.318.336.504.432.192.096.39.144.594.144zm3.033-.225h1.035v1.035h-1.035v-1.035zm4.068 1.125c-.336 0-.657-.072-.963-.216a2.392 2.392 0 01-.81-.63 3.222 3.222 0 01-.549-1.017 4.408 4.408 0 01-.198-1.377c0-.516.066-.975.198-1.377.138-.402.321-.741.549-1.017.234-.276.504-.486.81-.63.306-.144.627-.216.963-.216.336 0 .657.072.963.216.306.144.573.354.801.63a3 3 0 01.549 1.017c.138.402.207.861.207 1.377s-.069.975-.207 1.377a3 3 0 01-.549 1.017 2.306 2.306 0 01-.801.63 2.235 2.235 0 01-.963.216zm0-.9c.204 0 .399-.048.585-.144.192-.096.36-.24.504-.432.15-.198.267-.441.351-.729a3.55 3.55 0 00.135-1.035c0-.396-.045-.738-.135-1.026a2.116 2.116 0 00-.351-.729 1.398 1.398 0 00-.504-.441 1.259 1.259 0 00-.585-.144c-.204 0-.402.048-.594.144a1.504 1.504 0 00-.504.441 2.357 2.357 0 00-.351.729 3.69 3.69 0 00-.126 1.026c0 .396.042.741.126 1.035.09.288.207.531.351.729.15.192.318.336.504.432.192.096.39.144.594.144zm5.058.9c-.336 0-.657-.072-.963-.216a2.392 2.392 0 01-.81-.63 3.222 3.222 0 01-.549-1.017 4.408 4.408 0 01-.198-1.377c0-.516.066-.975.198-1.377.138-.402.321-.741.549-1.017.234-.276.504-.486.81-.63.306-.144.627-.216.963-.216.336 0 .657.072.963.216.306.144.573.354.801.63a3 3 0 01.549 1.017c.138.402.207.861.207 1.377s-.069.975-.207 1.377a3 3 0 01-.549 1.017 2.306 2.306 0 01-.801.63 2.235 2.235 0 01-.963.216zm0-.9c.204 0 .399-.048.585-.144.192-.096.36-.24.504-.432.15-.198.267-.441.351-.729a3.55 3.55 0 00.135-1.035c0-.396-.045-.738-.135-1.026a2.116 2.116 0 00-.351-.729 1.398 1.398 0 00-.504-.441 1.259 1.259 0 00-.585-.144c-.204 0-.402.048-.594.144a1.504 1.504 0 00-.504.441 2.357 2.357 0 00-.351.729 3.69 3.69 0 00-.126 1.026c0 .396.042.741.126 1.035.09.288.207.531.351.729.15.192.318.336.504.432.192.096.39.144.594.144zm5.058.9c-.336 0-.657-.072-.963-.216a2.392 2.392 0 01-.81-.63 3.222 3.222 0 01-.549-1.017 4.408 4.408 0 01-.198-1.377c0-.516.066-.975.198-1.377.138-.402.321-.741.549-1.017.234-.276.504-.486.81-.63.306-.144.627-.216.963-.216.336 0 .657.072.963.216.306.144.573.354.801.63a3 3 0 01.549 1.017c.138.402.207.861.207 1.377s-.069.975-.207 1.377a3 3 0 01-.549 1.017 2.306 2.306 0 01-.801.63 2.235 2.235 0 01-.963.216zm0-.9c.204 0 .399-.048.585-.144.192-.096.36-.24.504-.432.15-.198.267-.441.351-.729a3.55 3.55 0 00.135-1.035c0-.396-.045-.738-.135-1.026a2.116 2.116 0 00-.351-.729 1.398 1.398 0 00-.504-.441 1.259 1.259 0 00-.585-.144c-.204 0-.402.048-.594.144a1.504 1.504 0 00-.504.441 2.357 2.357 0 00-.351.729 3.69 3.69 0 00-.126 1.026c0 .396.042.741.126 1.035.09.288.207.531.351.729.15.192.318.336.504.432.192.096.39.144.594.144zm5.327-1.35h-.045a.669.669 0 01-.117.027 2.574 2.574 0 01-.135.018h-.153c-.282 0-.546-.054-.792-.162a2.156 2.156 0 01-.648-.459 2.275 2.275 0 01-.432-.666 2.231 2.231 0 01-.153-.828c0-.306.054-.588.162-.846.114-.264.27-.492.468-.684.198-.198.429-.351.693-.459.27-.114.564-.171.882-.171.312 0 .603.057.873.171.27.108.504.261.702.459.198.192.351.42.459.684.114.258.171.54.171.846 0 .252-.033.48-.099.684-.06.204-.147.396-.261.576l-1.89 2.97h-1.08l1.395-2.16zm-.27-.81c.18 0 .345-.03.495-.09a1.26 1.26 0 00.405-.27 1.28 1.28 0 00.36-.9c0-.18-.033-.345-.099-.495a1.148 1.148 0 00-.666-.666 1.216 1.216 0 00-.495-.099 1.28 1.28 0 00-.9.36 1.26 1.26 0 00-.27.405c-.06.15-.09.315-.09.495s.03.348.09.504a1.289 1.289 0 00.666.666c.156.06.324.09.504.09zm5.058 3.06c-.372 0-.69-.057-.954-.171a2.211 2.211 0 01-.657-.441 2.024 2.024 0 01-.387-.585 2.445 2.445 0 01-.162-.603h.945c.024.114.066.225.126.333.06.108.141.204.243.288.102.084.222.153.36.207.144.048.306.072.486.072.384 0 .69-.114.918-.342.228-.228.342-.534.342-.918 0-.36-.114-.651-.342-.873-.228-.228-.534-.342-.918-.342-.252 0-.465.048-.639.144-.174.09-.306.192-.396.306h-.99l.36-3.465h3.51v.9h-2.7l-.18 1.53h.045c.138-.09.297-.165.477-.225s.396-.09.648-.09c.294 0 .567.054.819.162.252.102.471.249.657.441.186.186.33.408.432.666.108.258.162.54.162.846 0 .318-.054.609-.162.873a2.056 2.056 0 01-.45.684 2.088 2.088 0 01-.702.441c-.27.108-.567.162-.891.162zm3.078-.99h1.575v-3.825h-1.575v-.9h1.305c.18 0 .27-.09.27-.27v-.405h.945v5.4h1.575v.9h-4.095v-.9zm5.013.09l2.592-2.61c.078-.078.147-.153.207-.225a1.127 1.127 0 00.234-.459c.018-.09.027-.192.027-.306 0-.342-.093-.606-.279-.792-.186-.192-.438-.288-.756-.288a1.094 1.094 0 00-.801.342 1.109 1.109 0 00-.243.378c-.054.15-.081.315-.081.495h-.945c0-.312.051-.597.153-.855.102-.264.243-.489.423-.675.186-.186.405-.33.657-.432.252-.102.531-.153.837-.153.306 0 .582.048.828.144a1.792 1.792 0 011.053 1.035c.096.24.144.507.144.801 0 .192-.027.369-.081.531a1.945 1.945 0 01-.198.441c-.084.138-.18.267-.288.387a9.2 9.2 0 01-.333.351l-1.755 1.755v.045h2.745v.9h-4.14v-.81zm5.058 0l2.592-2.61c.078-.078.147-.153.207-.225a1.127 1.127 0 00.234-.459c.018-.09.027-.192.027-.306 0-.342-.093-.606-.279-.792-.186-.192-.438-.288-.756-.288a1.094 1.094 0 00-.801.342 1.109 1.109 0 00-.243.378c-.054.15-.081.315-.081.495h-.945c0-.312.051-.597.153-.855.102-.264.243-.489.423-.675.186-.186.405-.33.657-.432.252-.102.531-.153.837-.153.306 0 .582.048.828.144a1.792 1.792 0 011.053 1.035c.096.24.144.507.144.801 0 .192-.027.369-.081.531a1.945 1.945 0 01-.198.441c-.084.138-.18.267-.288.387a9.2 9.2 0 01-.333.351l-1.755 1.755v.045h2.745v.9h-4.14v-.81zm7.236-5.49h2.79c.258 0 .495.045.711.135.222.09.414.216.576.378a1.718 1.718 0 01.513 1.242c0 .24-.036.444-.108.612-.072.168-.15.306-.234.414a1.883 1.883 0 01-.333.324v.045c.144.084.27.192.378.324.096.114.183.258.261.432.084.174.126.387.126.639 0 .246-.045.477-.135.693a1.64 1.64 0 01-.378.558 1.708 1.708 0 01-.558.369c-.216.09-.45.135-.702.135h-2.907v-6.3zm2.835 5.445a.854.854 0 00.63-.27.92.92 0 00.27-.675.941.941 0 00-.072-.369.898.898 0 00-.198-.306.844.844 0 00-.63-.27h-1.89v1.89h1.89zm-.09-2.7a.854.854 0 00.63-.27.92.92 0 00.27-.675.941.941 0 00-.072-.369.898.898 0 00-.198-.306.844.844 0 00-.63-.27h-1.8v1.89h1.8zm4.342-1.845h-1.98v-.9h4.905v.9h-1.98v5.4h-.945v-5.4zm6.274 5.49a2.953 2.953 0 01-2.133-.891 3.321 3.321 0 01-.648-1.026 3.582 3.582 0 01-.234-1.323c0-.486.078-.927.234-1.323.162-.396.378-.735.648-1.017a2.89 2.89 0 01.963-.666 2.953 2.953 0 011.17-.234 2.886 2.886 0 011.908.684c.24.204.438.438.594.702.156.264.267.537.333.819h-.99c-.156-.426-.402-.75-.738-.972a1.967 1.967 0 00-1.107-.333c-.294 0-.567.054-.819.162a1.884 1.884 0 00-.657.468c-.186.204-.333.45-.441.738a2.899 2.899 0 00-.153.972c0 .36.051.684.153.972.108.288.255.534.441.738.186.204.405.36.657.468.252.108.525.162.819.162.258 0 .489-.039.693-.117.204-.078.381-.18.531-.306.156-.126.285-.27.387-.432.102-.162.18-.327.234-.495h.99a3.044 3.044 0 01-.297.774 2.953 2.953 0 01-.567.729 3.007 3.007 0 01-.846.54 2.851 2.851 0 01-1.125.207z"
                fill="#757575"
            />
        </G>
        <Circle cx={124.5} cy={83.5} r={2.5} fill="#0F6148" />
        <Circle cx={203.5} cy={24.5} r={2.5} fill="#CD4949" />
        <G filter="url(#filter1_d_14530_54776)" opacity={0.6} clipPath="url(#clip0_14530_54776)">
            <G clipPath="url(#clip1_14530_54776)">
                <Rect x={68} y={231} width={192} height={41.0695} rx={8.2139} fill="#fff" />
                <Rect x={68} y={231} width={192} height={41.0695} rx={8.2139} fill="#fff" />
                <G clipPath="url(#clip2_14530_54776)">
                    <Path
                        transform="translate(76.214 239.214)"
                        fill="#fff"
                        d="M0 0H175.572V24.6417H0z"
                    />
                    <Path
                        transform="translate(172.727 239.214)"
                        fill="url(#paint2_linear_14530_54776)"
                        d="M0 0H20.5348V24.6417H0z"
                    />
                    <Rect
                        x={76.2139}
                        y={239.214}
                        width={24.6417}
                        height={24.6417}
                        rx={12.3209}
                        fill="#F6F6F6"
                    />
                    <Circle cx={88.5348} cy={251.535} r={12.3209} fill="#F6F6F6" />
                    <Path
                        d="M88.535 239.214c2.602 0 5.137.824 7.242 2.353l-7.242 9.968v-12.321z"
                        fill="#fff"
                    />
                    <Path
                        d="M88.535 239.214c2.602 0 5.137.824 7.242 2.353l-7.242 9.968v-12.321z"
                        fill="#60C67E"
                        fillOpacity={0.3}
                    />
                    <Circle cx={88.5348} cy={251.535} r={8.2139} fill="#fff" />
                    <Path
                        d="M88.535 257.695a6.16 6.16 0 100-12.32 6.16 6.16 0 000 12.32z"
                        fill="#60C67E"
                    />
                    <Path
                        d="M86.426 251.059l2.119-.893 2.053.916-2.057-3.243-2.115 3.22zm.007.991l2.115 1.226 2.158-1.226-2.139 2.976-2.134-2.976z"
                        fill="#fff"
                    />
                    <Path
                        d="M88.555 250.603l-2.207.928 2.207 1.226 2.144-1.199-2.144-.955z"
                        fill="#fff"
                    />
                    <Path
                        transform="translate(107.016 239.214)"
                        fill="#fff"
                        d="M0 0H63V24.6417H0z"
                    />
                    <Path
                        d="M107.632 248.285h3.778v.821h-2.915v1.643h2.751v.821h-2.751v1.643h2.915v.822h-3.778v-5.75zm5.79 5.75c-.291 0-.515-.077-.674-.23-.153-.154-.23-.364-.23-.633v-2.464h-.657v-.78h.657v-1.15h.821v1.15h.945v.78h-.945v2.341c0 .164.083.246.247.246h.698v.74h-.862zm1.603-5.75h.822v2.053h.041c.087-.093.189-.175.304-.246.098-.06.221-.115.369-.164.148-.055.321-.082.518-.082.246 0 .471.041.673.123.203.076.375.189.518.337.142.147.252.328.328.542.082.213.124.454.124.722v2.465h-.822v-2.465a.99.99 0 00-.279-.689.875.875 0 00-.312-.214.94.94 0 00-.395-.082c-.153 0-.295.027-.427.082a.917.917 0 00-.336.214.959.959 0 00-.304.689v2.465h-.822v-5.75zm6.367 5.832c-.296 0-.57-.052-.822-.156a1.981 1.981 0 01-.657-.436 2.012 2.012 0 01-.427-.673 2.453 2.453 0 01-.148-.871c0-.317.049-.608.148-.87.104-.263.246-.488.427-.674.186-.186.405-.331.657-.435.252-.104.526-.156.822-.156.279 0 .536.052.772.156.241.098.449.238.624.419.181.18.32.394.419.64a2.03 2.03 0 01.148.961l-.017.132-.016.115h-3.162c.043.35.178.629.402.837.225.209.501.313.83.313.12 0 .232-.017.336-.05a1.06 1.06 0 00.288-.131c.088-.055.161-.115.222-.181a.956.956 0 00.139-.213h.863a2.283 2.283 0 01-.222.427 1.86 1.86 0 01-.378.41c-.153.126-.334.23-.542.313a1.874 1.874 0 01-.706.123zm1.191-2.464a1.298 1.298 0 00-.386-.797c-.208-.208-.477-.312-.805-.312-.351 0-.63.104-.838.312-.203.202-.334.468-.394.797h2.423zm1.44-1.725h.698l.082.369h.041l.107-.123a.763.763 0 01.139-.123.758.758 0 01.214-.09c.088-.022.194-.033.32-.033h.74v.739h-.657c-.575 0-.863.285-.863.854v2.514h-.821v-4.107zm4.442 4.189c-.296 0-.57-.052-.821-.156a1.996 1.996 0 01-.658-.436 2.027 2.027 0 01-.427-.673 2.476 2.476 0 01-.148-.871c0-.317.05-.608.148-.87.104-.263.247-.488.427-.674.187-.186.406-.331.658-.435.251-.104.525-.156.821-.156.279 0 .537.052.772.156.241.098.449.238.624.419.181.18.321.394.419.64a2.03 2.03 0 01.148.961c-.005.05-.011.093-.016.132-.006.043-.011.082-.017.115h-3.162c.044.35.178.629.402.837.225.209.501.313.83.313.12 0 .233-.017.337-.05.109-.033.205-.076.287-.131.088-.055.162-.115.222-.181a.962.962 0 00.14-.213h.862a2.283 2.283 0 01-.222.427 1.835 1.835 0 01-.378.41c-.153.126-.334.23-.542.313a1.87 1.87 0 01-.706.123zm1.191-2.464a1.298 1.298 0 00-.386-.797c-.208-.208-.477-.312-.805-.312-.351 0-.63.104-.838.312-.203.202-.334.468-.394.797h2.423zm3.083 2.464c-.247 0-.471-.039-.674-.115a1.476 1.476 0 01-.854-.887 2.126 2.126 0 01-.115-.723v-2.464h.821v2.464c0 .131.025.257.074.378.05.12.118.227.206.32.087.088.191.159.312.214.12.049.252.074.394.074.153 0 .296-.025.427-.074.132-.055.244-.126.337-.214.093-.093.167-.2.222-.32a.919.919 0 00.082-.378v-2.464h.821v4.107h-.739l-.082-.411h-.041a1.502 1.502 0 01-.304.246 1.784 1.784 0 01-.378.165 1.48 1.48 0 01-.509.082zm2.916-4.189h.74l.082.41h.041c.082-.093.178-.175.287-.246.093-.06.206-.115.337-.164.131-.055.279-.082.444-.082.208 0 .38.03.517.09.142.06.257.126.345.197.099.088.181.184.246.288h.042c.082-.104.188-.2.32-.288a1.858 1.858 0 011.035-.287c.213 0 .411.041.591.123.181.076.337.186.468.328.132.137.233.304.304.501.077.192.115.406.115.641v2.596h-.821v-2.588c0-.268-.077-.479-.23-.632-.148-.154-.345-.23-.591-.23a.944.944 0 00-.641.246.858.858 0 00-.197.28.853.853 0 00-.066.336v2.588h-.821v-2.588c0-.268-.077-.479-.23-.632-.148-.154-.345-.23-.592-.23a.94.94 0 00-.64.246.86.86 0 00-.198.28.87.87 0 00-.065.336v2.588h-.822v-4.107zm11.049 4.189a2.697 2.697 0 01-1.947-.813 3.02 3.02 0 01-.591-.937 3.254 3.254 0 01-.214-1.207c0-.444.071-.846.214-1.208a2.93 2.93 0 01.591-.928 2.647 2.647 0 011.947-.821 2.632 2.632 0 011.741.624c.219.186.4.4.542.641.142.241.244.49.304.747h-.904c-.142-.389-.366-.684-.673-.887a1.792 1.792 0 00-1.01-.304 1.87 1.87 0 00-.748.148c-.23.099-.43.241-.599.427-.17.186-.304.411-.403.674-.093.263-.14.558-.14.887 0 .328.047.624.14.887.099.263.233.487.403.673.169.187.369.329.599.428.23.098.479.147.748.147.235 0 .446-.035.632-.106.186-.072.348-.165.485-.28.142-.115.26-.246.353-.394.093-.148.164-.298.213-.452h.904c-.049.225-.14.46-.271.707a2.682 2.682 0 01-.518.665 2.74 2.74 0 01-.772.493 2.598 2.598 0 01-1.026.189zm3.248-5.832h.821v5.75h-.821v-5.75zm3.041 5.832c-.224 0-.43-.03-.616-.091a1.537 1.537 0 01-.468-.262 1.26 1.26 0 01-.296-.403 1.333 1.333 0 01-.098-.517c0-.411.136-.74.41-.986.274-.246.698-.37 1.273-.37h1.027v-.082c0-.268-.077-.479-.23-.632-.153-.154-.364-.23-.632-.23-.143 0-.266.019-.37.057a.758.758 0 00-.427.329.7.7 0 00-.066.189h-.821a1.28 1.28 0 01.131-.493 1.32 1.32 0 01.337-.403c.148-.115.323-.205.526-.271.202-.071.432-.106.69-.106.536 0 .95.142 1.24.427.296.279.444.657.444 1.133v2.629h-.699l-.082-.452h-.041a1.28 1.28 0 01-.296.271 1.683 1.683 0 01-.936.263zm.082-.698c.373 0 .657-.096.854-.288.198-.197.296-.471.296-.821v-.165h-.986c-.312 0-.542.063-.689.189a.6.6 0 00-.214.469c0 .186.06.336.181.451.126.11.312.165.558.165zm4.273.698c-.329 0-.605-.047-.83-.14a1.948 1.948 0 01-.55-.345 1.304 1.304 0 01-.296-.427 1.126 1.126 0 01-.09-.402h.821c0 .06.017.128.049.205a.645.645 0 00.173.197c.082.06.181.112.296.156.12.038.262.058.427.058.306 0 .525-.058.657-.173.137-.115.205-.235.205-.361a.45.45 0 00-.139-.345c-.088-.088-.247-.151-.477-.189l-.739-.123c-.394-.066-.693-.192-.895-.378-.198-.192-.296-.463-.296-.813 0-.165.033-.318.098-.46a1.08 1.08 0 01.304-.378 1.47 1.47 0 01.51-.255c.208-.066.451-.098.731-.098.295 0 .55.046.764.139.213.088.388.197.525.329.137.131.236.271.296.419a.927.927 0 01.098.386h-.821a.514.514 0 00-.205-.378.678.678 0 00-.263-.14 1.21 1.21 0 00-.394-.057c-.291 0-.501.052-.633.156-.126.098-.189.211-.189.337 0 .126.055.23.165.312.115.082.265.142.451.18l.74.124c.794.131 1.191.542 1.191 1.232 0 .164-.036.32-.107.468a1.095 1.095 0 01-.304.394 1.474 1.474 0 01-.526.271 2.536 2.536 0 01-.747.099zm3.781 0c-.329 0-.605-.047-.83-.14a1.948 1.948 0 01-.55-.345 1.319 1.319 0 01-.296-.427 1.126 1.126 0 01-.09-.402h.821c0 .06.017.128.05.205a.641.641 0 00.172.197c.082.06.181.112.296.156.12.038.263.058.427.058.307 0 .526-.058.657-.173.137-.115.205-.235.205-.361a.45.45 0 00-.139-.345c-.088-.088-.247-.151-.477-.189l-.739-.123c-.394-.066-.693-.192-.895-.378-.197-.192-.296-.463-.296-.813 0-.165.033-.318.099-.46.071-.148.172-.274.304-.378.137-.11.306-.195.509-.255.208-.066.452-.098.731-.098.296 0 .55.046.764.139.213.088.389.197.526.329.136.131.235.271.295.419a.93.93 0 01.099.386h-.822a.514.514 0 00-.205-.378.67.67 0 00-.263-.14 1.205 1.205 0 00-.394-.057c-.29 0-.501.052-.633.156-.125.098-.188.211-.188.337 0 .126.054.23.164.312.115.082.265.142.452.18l.739.124c.794.131 1.191.542 1.191 1.232 0 .164-.036.32-.107.468a1.095 1.095 0 01-.304.394 1.474 1.474 0 01-.526.271 2.532 2.532 0 01-.747.099zm2.303-4.189h.821v4.107h-.821v-4.107zm-.041-1.643h.903v.862h-.903v-.862zm3.577 5.832c-.296 0-.57-.052-.822-.156a1.981 1.981 0 01-.657-.436 2.012 2.012 0 01-.427-.673 2.453 2.453 0 01-.148-.871c0-.317.049-.608.148-.87.104-.263.246-.488.427-.674.186-.186.405-.331.657-.435.252-.104.526-.156.822-.156.306 0 .572.052.796.156a1.79 1.79 0 01.912.854c.088.17.148.326.181.468h-.822a1.142 1.142 0 00-.139-.271.957.957 0 00-.214-.238.844.844 0 00-.304-.164 1.187 1.187 0 00-.41-.066 1.137 1.137 0 00-.879.378c-.11.12-.197.268-.263.443-.06.17-.09.362-.09.575 0 .214.03.408.09.583.066.17.153.315.263.436a1.148 1.148 0 00.879.378 1.132 1.132 0 00.747-.263c.088-.082.156-.167.205-.255.055-.093.093-.181.115-.263h.822a2.205 2.205 0 01-.181.501c-.082.176-.2.34-.353.493a1.919 1.919 0 01-.559.378 1.96 1.96 0 01-.796.148z"
                        fill="#171717"
                    />
                    <Path
                        transform="translate(197.369 239.214)"
                        fill="#fff"
                        d="M0 0H54.4171V24.6417H0z"
                    />
                    <Path
                        d="M206.05 258.81h-.036a.527.527 0 01-.093.021 2.04 2.04 0 01-.108.015h-.122c-.225 0-.436-.043-.633-.13a1.722 1.722 0 01-.517-.366 1.819 1.819 0 01-.345-.532 1.773 1.773 0 01-.122-.661c0-.245.043-.47.129-.676.091-.211.216-.393.374-.546.158-.158.342-.28.553-.367.216-.091.451-.136.704-.136.25 0 .482.045.698.136a1.666 1.666 0 01.927.913c.091.206.136.431.136.676 0 .201-.026.383-.079.546a1.816 1.816 0 01-.208.46l-1.509 2.372h-.863l1.114-1.725zm-.216-.647c.144 0 .276-.024.396-.072.124-.053.232-.125.323-.216a1.033 1.033 0 00.288-.718.986.986 0 00-.079-.396.923.923 0 00-.532-.531.97.97 0 00-.396-.08 1.02 1.02 0 00-.402.08.915.915 0 00-.316.208 1.017 1.017 0 00-.216.323c-.048.12-.072.252-.072.396 0 .143.024.278.072.402a1.032 1.032 0 00.532.532c.125.048.259.072.402.072zm2.328 1.545h.827v.827h-.827v-.827zm3.155.899c-.268 0-.51-.039-.726-.115a1.724 1.724 0 01-.539-.324 1.415 1.415 0 01-.345-.467 1.442 1.442 0 01-.115-.568c0-.215.038-.398.115-.546.077-.149.163-.271.259-.367.11-.11.237-.201.381-.273v-.036a1.072 1.072 0 01-.324-.244 1.364 1.364 0 01-.223-.331 1.118 1.118 0 01-.1-.503c0-.187.036-.364.108-.532.076-.172.184-.323.323-.452.139-.13.307-.23.503-.302a1.9 1.9 0 01.683-.115c.249 0 .474.038.675.115.202.072.372.172.511.302.139.129.244.28.316.452.077.168.115.345.115.532 0 .202-.034.369-.101.503a1.211 1.211 0 01-.546.575v.036c.139.072.264.163.374.273.096.096.182.218.259.367.081.148.122.331.122.546 0 .197-.041.386-.122.568-.077.177-.19.333-.338.467a1.726 1.726 0 01-.546.324 2.114 2.114 0 01-.719.115zm0-.683c.144 0 .275-.022.395-.065a.847.847 0 00.503-.438.745.745 0 00.072-.324.758.758 0 00-.273-.582.86.86 0 00-.302-.18 1.16 1.16 0 00-.395-.064c-.144 0-.276.021-.395.064a.942.942 0 00-.309.18.794.794 0 00-.195.259.751.751 0 00-.071.323c0 .115.024.223.071.324.048.1.113.189.195.266.086.071.189.129.309.172.119.043.251.065.395.065zm0-2.3c.273 0 .484-.072.632-.216a.704.704 0 00.23-.539.707.707 0 00-.23-.539c-.148-.144-.359-.215-.632-.215s-.486.071-.64.215a.723.723 0 00-.223.539.72.72 0 00.223.539c.154.144.367.216.64.216zm4.16 1.186h-.036a.49.49 0 01-.093.021 2.04 2.04 0 01-.108.015h-.122a1.54 1.54 0 01-.632-.13 1.726 1.726 0 01-.518-.366 1.819 1.819 0 01-.345-.532 1.793 1.793 0 01-.122-.661c0-.245.043-.47.129-.676.091-.211.216-.393.374-.546.158-.158.343-.28.553-.367.216-.091.451-.136.705-.136.249 0 .481.045.697.136a1.67 1.67 0 01.927.913c.091.206.137.431.137.676 0 .201-.027.383-.079.546a1.819 1.819 0 01-.209.46l-1.509 2.372h-.863l1.114-1.725zm-.215-.647c.144 0 .275-.024.395-.072.125-.053.232-.125.324-.216a1.015 1.015 0 00.287-.718.97.97 0 00-.079-.396.911.911 0 00-.532-.531.965.965 0 00-.395-.08 1.02 1.02 0 00-.719.288 1.017 1.017 0 00-.216.323c-.047.12-.071.252-.071.396 0 .143.024.278.071.402a1.032 1.032 0 00.532.532c.125.048.259.072.403.072zm3.945 2.444c-.269 0-.525-.058-.769-.173a1.911 1.911 0 01-.647-.503 2.586 2.586 0 01-.439-.812 3.535 3.535 0 01-.158-1.1c0-.412.053-.778.158-1.099.111-.322.257-.592.439-.813.187-.22.402-.388.647-.503.244-.115.5-.172.769-.172.268 0 .524.057.769.172.244.115.457.283.639.503.187.221.333.491.439.813.11.321.165.687.165 1.099 0 .412-.055.779-.165 1.1a2.4 2.4 0 01-.439.812c-.182.22-.395.388-.639.503a1.788 1.788 0 01-.769.173zm0-.719c.163 0 .318-.039.467-.115a1.15 1.15 0 00.402-.345c.12-.158.214-.352.281-.582.072-.235.107-.511.107-.827 0-.316-.035-.589-.107-.819a1.68 1.68 0 00-.281-.582 1.125 1.125 0 00-.402-.353 1.014 1.014 0 00-.942 0 1.215 1.215 0 00-.402.353 1.856 1.856 0 00-.28.582c-.067.23-.101.503-.101.819 0 .316.034.592.101.827.071.23.165.424.28.582.12.153.254.268.402.345.154.076.312.115.475.115zm3.945.719a2.13 2.13 0 01-.712-.115 1.82 1.82 0 01-.546-.324 1.47 1.47 0 01-.345-.481 1.454 1.454 0 01-.122-.59h.754c0 .101.024.199.072.295a.957.957 0 00.194.251c.087.072.19.132.309.18.12.043.252.065.396.065.306 0 .539-.072.697-.216a.753.753 0 00.237-.575c0-.215-.086-.4-.259-.553-.167-.158-.405-.237-.711-.237h-.324v-.683h.324c.287 0 .508-.072.661-.216a.697.697 0 00.237-.539.663.663 0 00-.23-.51c-.148-.139-.359-.209-.632-.209s-.491.07-.654.209a.646.646 0 00-.245.51h-.754c0-.196.038-.381.115-.553a1.3 1.3 0 01.33-.46c.144-.13.316-.233.518-.309.206-.077.436-.115.69-.115.244 0 .464.038.661.115.201.076.371.179.51.309a1.356 1.356 0 01.446 1.013c0 .201-.039.369-.115.503a1.295 1.295 0 01-.245.331 1.303 1.303 0 01-.359.244v.036c.144.063.276.146.395.252.096.091.185.211.266.359.087.144.13.324.13.539 0 .206-.041.4-.123.582a1.405 1.405 0 01-.345.467c-.148.13-.328.233-.539.31a1.956 1.956 0 01-.682.115zm3.945 0c-.269 0-.525-.058-.769-.173a1.911 1.911 0 01-.647-.503 2.566 2.566 0 01-.439-.812 3.535 3.535 0 01-.158-1.1c0-.412.053-.778.158-1.099.11-.322.257-.592.439-.813.187-.22.402-.388.647-.503.244-.115.5-.172.769-.172.268 0 .524.057.769.172.244.115.457.283.639.503.187.221.333.491.439.813.11.321.165.687.165 1.099 0 .412-.055.779-.165 1.1a2.4 2.4 0 01-.439.812c-.182.22-.395.388-.639.503a1.788 1.788 0 01-.769.173zm0-.719c.162 0 .318-.039.467-.115a1.15 1.15 0 00.402-.345c.12-.158.213-.352.281-.582.071-.235.107-.511.107-.827a2.79 2.79 0 00-.107-.819 1.698 1.698 0 00-.281-.582 1.125 1.125 0 00-.402-.353 1.017 1.017 0 00-.942 0 1.215 1.215 0 00-.402.353 1.878 1.878 0 00-.281.582c-.067.23-.1.503-.1.819 0 .316.033.592.1.827.072.23.166.424.281.582.12.153.254.268.402.345.154.076.312.115.475.115zm3.944.719c-.268 0-.524-.058-.769-.173a1.908 1.908 0 01-.646-.503 2.566 2.566 0 01-.439-.812 3.535 3.535 0 01-.158-1.1c0-.412.053-.778.158-1.099.11-.322.257-.592.439-.813.186-.22.402-.388.646-.503.245-.115.501-.172.769-.172.269 0 .525.057.77.172.244.115.457.283.639.503.187.221.333.491.439.813.11.321.165.687.165 1.099 0 .412-.055.779-.165 1.1a2.4 2.4 0 01-.439.812c-.182.22-.395.388-.639.503a1.79 1.79 0 01-.77.173zm0-.719c.163 0 .319-.039.468-.115a1.15 1.15 0 00.402-.345c.12-.158.213-.352.28-.582.072-.235.108-.511.108-.827 0-.316-.036-.589-.108-.819a1.679 1.679 0 00-.28-.582 1.125 1.125 0 00-.402-.353 1.018 1.018 0 00-.942 0 1.205 1.205 0 00-.402.353 1.878 1.878 0 00-.281.582c-.067.23-.1.503-.1.819 0 .316.033.592.1.827.072.23.166.424.281.582.119.153.254.268.402.345.153.076.312.115.474.115zm3.945.719a1.91 1.91 0 01-.761-.137 1.768 1.768 0 01-.525-.352 1.635 1.635 0 01-.309-.467 2.008 2.008 0 01-.13-.482h.755a.94.94 0 00.101.266.796.796 0 00.194.23c.081.067.177.122.287.165.115.039.245.058.388.058.307 0 .551-.091.733-.273.183-.182.274-.427.274-.733 0-.288-.091-.52-.274-.698-.182-.182-.426-.273-.733-.273a1.05 1.05 0 00-.51.115.955.955 0 00-.316.245h-.791l.288-2.767h2.803v.718h-2.156l-.144 1.222h.036c.11-.072.237-.132.381-.179.143-.048.316-.072.517-.072.235 0 .453.043.654.129a1.567 1.567 0 01.87.884c.086.206.129.431.129.676 0 .254-.043.486-.129.697a1.636 1.636 0 01-.359.546 1.669 1.669 0 01-.561.352c-.216.086-.453.13-.712.13zm3.974-5.103h3.306v.718h-2.552v1.438h2.408v.719h-2.408v1.437h2.552v.719h-3.306v-5.031zm5.271.718h-1.581v-.718h3.917v.718h-1.582v4.313h-.754v-4.313zm4.916 4.385a2.372 2.372 0 01-1.704-.712 2.657 2.657 0 01-.517-.819 2.858 2.858 0 01-.187-1.057c0-.388.062-.74.187-1.056a2.57 2.57 0 01.517-.813 2.32 2.32 0 01.769-.531c.293-.125.604-.187.935-.187.316 0 .601.05.855.151.254.096.477.227.668.395.192.163.35.35.475.561.124.21.213.428.266.654h-.791a1.525 1.525 0 00-.589-.777 1.574 1.574 0 00-.884-.266c-.235 0-.453.044-.654.13a1.5 1.5 0 00-.525.374 1.79 1.79 0 00-.352.589c-.082.23-.122.489-.122.776 0 .288.04.546.122.776.086.23.203.427.352.59.149.163.323.287.525.373.201.087.419.13.654.13.206 0 .39-.031.553-.094.163-.062.304-.143.424-.244.125-.101.228-.216.309-.345.082-.129.144-.261.187-.395h.791a2.436 2.436 0 01-.237.618 2.347 2.347 0 01-.453.582 2.41 2.41 0 01-.676.431 2.28 2.28 0 01-.898.166z"
                        fill="#757575"
                    />
                </G>
            </G>
        </G>
        <G opacity={0.8} filter="url(#filter2_d_14530_54776)">
            <G clipPath="url(#clip3_14530_54776)">
                <Rect x={36} y={193.743} width={256} height={54.7594} rx={10.9519} fill="#fff" />
                <Rect x={36} y={193.743} width={256} height={54.7594} rx={10.9519} fill="#fff" />
                <G clipPath="url(#clip4_14530_54776)">
                    <Path
                        transform="translate(46.952 204.695)"
                        fill="#fff"
                        d="M0 0H234.096V32.8556H0z"
                    />
                    <Path
                        transform="translate(175.636 204.695)"
                        fill="url(#paint3_linear_14530_54776)"
                        d="M0 0H27.3797V32.8556H0z"
                    />
                    <Rect
                        x={46.9519}
                        y={204.695}
                        width={32.8556}
                        height={32.8556}
                        rx={16.4278}
                        fill="#F6F6F6"
                    />
                    <Circle cx={63.3797} cy={221.123} r={16.4278} fill="#F6F6F6" />
                    <Path
                        d="M53.38 234.156a16.426 16.426 0 01.695-26.571l9.305 13.538-10 13.033z"
                        fill="#454A75"
                        fillOpacity={0.3}
                    />
                    <Circle cx={63.3797} cy={221.123} r={10.9519} fill="#fff" />
                    <Path
                        d="M63.38 229.337a8.214 8.214 0 100-16.427 8.214 8.214 0 000 16.427z"
                        fill="#454A75"
                    />
                    <Path
                        d="M61.894 218.529l-1.51 2.568-.016.029.334.208 1.948 1.215.555.347.186.116.176-.11 2.208-1.378c.346-.215.63-.394.633-.396a29.58 29.58 0 00-.433-.748 4432.728 4432.728 0 00-2.585-4.391c-.002 0-.674 1.143-1.496 2.54z"
                        fill="#fff"
                    />
                    <Path
                        d="M60.374 221.741c0 .004 3.003 4.301 3.012 4.31.006.005.366-.506 1.516-2.151.83-1.188 1.508-2.16 1.507-2.161 0-.001-.679.421-1.508.938-.829.518-1.51.939-1.515.938-.005-.002-2.59-1.613-2.989-1.864-.012-.007-.023-.012-.023-.01z"
                        fill="#fff"
                    />
                    <Path
                        transform="translate(88.021 204.695)"
                        fill="#fff"
                        d="M0 0H47V32.8556H0z"
                    />
                    <Path
                        d="M88.843 216.957h5.038v1.095h-3.888v2.19h3.669v1.095h-3.67v2.191h3.889v1.095h-5.038v-7.666zm7.72 7.666c-.388 0-.687-.102-.899-.307-.204-.204-.307-.485-.307-.843v-3.285h-.876v-1.041h.876v-1.533h1.096v1.533h1.26v1.041h-1.26v3.121c0 .219.11.328.328.328h.931v.986h-1.15zm2.137-7.666h1.096v2.738h.054c.117-.124.252-.234.405-.329a2.47 2.47 0 01.493-.219c.197-.073.427-.109.69-.109.329 0 .628.054.898.164.27.102.5.252.69.449.19.197.336.438.438.723.11.284.165.606.165.963v3.286h-1.096v-3.286a1.307 1.307 0 00-1.314-1.314c-.204 0-.394.037-.569.11-.176.065-.325.16-.449.285a1.297 1.297 0 00-.296.416 1.2 1.2 0 00-.11.503v3.286H98.7v-7.666zm8.489 7.776c-.394 0-.759-.07-1.095-.209a2.649 2.649 0 01-.876-.58 2.704 2.704 0 01-.57-.898 3.29 3.29 0 01-.197-1.161c0-.423.066-.81.197-1.161.139-.35.329-.65.57-.898.248-.248.54-.442.876-.58a2.836 2.836 0 011.095-.208c.372 0 .715.069 1.029.208.322.131.599.317.833.558.241.241.427.526.558.854a2.702 2.702 0 01.175 1.457c-.007.058-.014.11-.021.153h-4.217c.058.468.237.84.537 1.117.299.278.668.417 1.106.417.16 0 .31-.022.449-.066.146-.044.274-.102.383-.175.117-.073.216-.154.296-.241.08-.095.142-.19.186-.285h1.15a3.068 3.068 0 01-.296.57 2.52 2.52 0 01-.503.547 2.678 2.678 0 01-.723.416c-.27.11-.584.165-.942.165zm1.588-3.286c-.059-.438-.23-.792-.515-1.062-.277-.278-.635-.416-1.073-.416-.467 0-.84.138-1.117.416-.27.27-.446.624-.526 1.062h3.231zm1.92-2.3h.931l.109.493h.055l.142-.164c.052-.059.114-.114.187-.165.08-.051.175-.091.284-.12.117-.029.26-.044.427-.044h.986v.986h-.876c-.767 0-1.15.379-1.15 1.139v3.351h-1.095v-5.476zm5.923 5.586c-.394 0-.759-.07-1.095-.209a2.649 2.649 0 01-.876-.58 2.704 2.704 0 01-.57-.898 3.29 3.29 0 01-.197-1.161c0-.423.066-.81.197-1.161.139-.35.329-.65.57-.898.248-.248.54-.442.876-.58a2.836 2.836 0 011.095-.208c.372 0 .715.069 1.029.208.322.131.599.317.833.558.241.241.427.526.558.854a2.702 2.702 0 01.175 1.457c-.007.058-.014.11-.021.153h-4.217c.058.468.237.84.537 1.117.299.278.668.417 1.106.417.16 0 .31-.022.449-.066.146-.044.274-.102.383-.175.117-.073.216-.154.296-.241.08-.095.142-.19.186-.285h1.15a3.068 3.068 0 01-.296.57 2.52 2.52 0 01-.503.547 2.678 2.678 0 01-.723.416c-.27.11-.584.165-.942.165zm1.588-3.286c-.059-.438-.23-.792-.515-1.062-.277-.278-.635-.416-1.073-.416-.467 0-.84.138-1.117.416-.27.27-.446.624-.526 1.062h3.231zm4.11 3.286c-.328 0-.628-.052-.898-.154a1.97 1.97 0 01-.69-.46 2.13 2.13 0 01-.449-.723 2.84 2.84 0 01-.153-.963v-3.286h1.095v3.286a1.39 1.39 0 00.372.931c.117.116.256.211.417.284.16.066.335.099.525.099.205 0 .395-.033.57-.099a1.49 1.49 0 00.449-.284c.124-.125.223-.267.296-.428.073-.16.109-.328.109-.503v-3.286h1.095v5.476h-.985l-.11-.548h-.055a1.982 1.982 0 01-.405.329c-.131.08-.299.153-.504.219-.197.073-.423.11-.679.11zm3.889-5.586h.986l.109.548h.055c.11-.124.237-.234.383-.329.124-.08.274-.153.449-.219a1.53 1.53 0 01.592-.109c.277 0 .507.04.69.12.19.08.343.168.46.263.131.117.241.244.328.383h.055c.11-.139.252-.266.427-.383a2.474 2.474 0 011.38-.383c.285 0 .548.054.789.164.241.102.449.248.624.438.175.182.31.405.405.668.102.256.153.54.153.854v3.461h-1.095v-3.45c0-.358-.102-.639-.306-.843-.198-.205-.46-.307-.789-.307a1.245 1.245 0 00-.854.329 1.14 1.14 0 00-.263.372 1.156 1.156 0 00-.088.449v3.45h-1.095v-3.45c0-.358-.102-.639-.307-.843-.197-.205-.46-.307-.788-.307a1.245 1.245 0 00-.854.329 1.14 1.14 0 00-.263.372 1.138 1.138 0 00-.088.449v3.45h-1.095v-5.476z"
                        fill="#171717"
                    />
                    <Path
                        transform="translate(208.492 204.695)"
                        fill="#fff"
                        d="M0 0H72.5562V32.8556H0z"
                    />
                    <Path
                        d="M236.567 216.32a3.129 3.129 0 01-.953-.307 2.664 2.664 0 01-.712-.536 2.3 2.3 0 01-.438-.723 2.557 2.557 0 01-.142-.855h1.15c0 .176.04.347.12.515.088.168.208.314.362.438.153.124.336.227.547.307.219.073.46.109.723.109.577 0 .993-.109 1.249-.328.262-.219.394-.493.394-.821a.932.932 0 00-.274-.69c-.182-.19-.493-.325-.931-.406l-1.478-.273c-.606-.11-1.041-.344-1.304-.701-.262-.358-.394-.8-.394-1.326 0-.284.048-.551.143-.799.102-.256.244-.478.427-.668.182-.19.401-.347.657-.471.255-.131.54-.219.854-.263v-1.139h1.095v1.128c.358.044.676.139.953.285.277.139.511.318.701.537.19.211.336.456.438.733.102.27.153.563.153.876h-1.15c0-.175-.04-.346-.12-.514a1.31 1.31 0 00-.34-.438 1.532 1.532 0 00-.514-.296c-.197-.08-.42-.12-.668-.12-.234 0-.442.032-.625.098a1.382 1.382 0 00-.471.252 1.037 1.037 0 00-.383.799c0 .249.069.468.208.658.146.182.424.31.833.383l1.204.219c.767.139 1.314.38 1.643.723.329.343.493.814.493 1.413 0 .292-.051.565-.153.821a2.048 2.048 0 01-.449.668 2.436 2.436 0 01-.745.493 3.42 3.42 0 01-1.008.241v1.117h-1.095v-1.139zm7.341-1.709h-3.559v-.931l2.902-5.092h1.807v4.983h.931v1.04h-.931v1.643h-1.15v-1.643zm0-1.04v-3.559h-.219l-1.971 3.504v.055h2.19zm2.796 1.424h1.26l-.603 2.19h-.876l.219-2.19zm4.714 1.369c-.387 0-.745-.066-1.074-.197a2.787 2.787 0 01-.843-.559 2.727 2.727 0 01-.57-.832 2.732 2.732 0 01-.197-1.041c0-.306.037-.584.11-.832.08-.248.19-.482.328-.701l2.3-3.614h1.314l-1.697 2.628h.055l.142-.022.153-.022a2.256 2.256 0 011.161.198c.3.131.559.314.778.547a2.5 2.5 0 01.526.822c.131.306.197.638.197.996 0 .373-.07.719-.208 1.041a2.577 2.577 0 01-.559.832c-.241.234-.526.42-.854.559a2.845 2.845 0 01-1.062.197zm0-1.096c.219 0 .419-.036.602-.109.19-.08.354-.19.493-.329.138-.138.244-.299.317-.481a1.55 1.55 0 00.121-.614c0-.219-.04-.42-.121-.602a1.396 1.396 0 00-.81-.811 1.484 1.484 0 00-.602-.12 1.564 1.564 0 00-1.096.438 1.541 1.541 0 00-.328.493c-.073.182-.11.383-.11.602 0 .219.037.424.11.614a1.568 1.568 0 00.81.81c.19.073.394.109.614.109zm5.972 1.096c-.387 0-.745-.066-1.074-.197a2.787 2.787 0 01-.843-.559 2.707 2.707 0 01-.569-.832 2.714 2.714 0 01-.198-1.041c0-.306.037-.584.11-.832.08-.248.19-.482.329-.701l2.299-3.614h1.315l-1.698 2.628h.055l.142-.022.154-.022a2.264 2.264 0 011.161.198c.299.131.558.314.777.547.226.234.402.508.526.822.131.306.197.638.197.996 0 .373-.069.719-.208 1.041a2.577 2.577 0 01-.559.832c-.241.234-.525.42-.854.559a2.845 2.845 0 01-1.062.197zm0-1.096c.219 0 .42-.036.602-.109.19-.08.354-.19.493-.329a1.41 1.41 0 00.317-.481 1.55 1.55 0 00.121-.614c0-.219-.04-.42-.121-.602a1.394 1.394 0 00-.81-.811 1.48 1.48 0 00-.602-.12c-.219 0-.424.04-.614.12a1.412 1.412 0 00-.481.318 1.527 1.527 0 00-.329.493c-.073.182-.11.383-.11.602 0 .219.037.424.11.614.08.182.19.343.329.481.138.139.299.249.481.329.19.073.395.109.614.109zm3.508 0l3.154-3.176c.095-.094.179-.186.252-.273a1.412 1.412 0 00.285-.559c.021-.109.032-.234.032-.372 0-.416-.113-.738-.339-.964-.226-.234-.533-.35-.92-.35a1.332 1.332 0 00-.975.416 1.346 1.346 0 00-.296.46 1.78 1.78 0 00-.098.602h-1.15c0-.38.062-.726.186-1.04.124-.322.296-.595.515-.822.226-.226.493-.401.799-.525a2.68 2.68 0 011.019-.187c.372 0 .708.059 1.007.176a2.178 2.178 0 011.282 1.259 2.6 2.6 0 01.175.975c0 .233-.033.449-.098.646-.059.19-.139.369-.241.537a3.21 3.21 0 01-.351.47c-.131.146-.266.289-.405.428l-2.136 2.135v.055h3.341v1.095h-5.038v-.986zm5.972-.273h1.259v1.259h-1.259v-1.259zm5.096-1.369h-.054a.968.968 0 01-.143.033 3.23 3.23 0 01-.164.021h-.186c-.343 0-.665-.065-.964-.197a2.635 2.635 0 01-.789-.558 2.761 2.761 0 01-.525-.811 2.714 2.714 0 01-.186-1.007c0-.373.065-.716.197-1.03a2.55 2.55 0 01.569-.832c.241-.241.522-.427.844-.559a2.74 2.74 0 011.073-.208c.38 0 .734.07 1.062.208.329.132.613.318.854.559.241.234.428.511.559.832.139.314.208.657.208 1.03 0 .306-.04.584-.12.832a2.753 2.753 0 01-.318.701l-2.3 3.614h-1.314l1.697-2.628zm-.328-.986c.219 0 .42-.036.602-.109.19-.081.354-.19.493-.329s.245-.299.318-.482c.08-.19.12-.394.12-.613 0-.219-.04-.42-.12-.603a1.392 1.392 0 00-.811-.81 1.48 1.48 0 00-.602-.12 1.559 1.559 0 00-1.095.438 1.523 1.523 0 00-.329.492 1.613 1.613 0 00-.109.603c0 .219.036.423.109.613a1.558 1.558 0 00.811.811c.189.073.394.109.613.109zm5.972 3.724a3.21 3.21 0 01-1.084-.176 2.777 2.777 0 01-.833-.492 2.27 2.27 0 01-.525-.734 2.226 2.226 0 01-.186-.898h1.15c0 .153.036.303.109.449.073.139.172.266.296.383.131.11.288.201.471.274.182.066.383.098.602.098.467 0 .821-.109 1.062-.328.241-.226.362-.518.362-.876 0-.329-.132-.61-.394-.844-.256-.24-.617-.361-1.085-.361h-.493v-1.04h.493c.438 0 .774-.11 1.008-.329.241-.219.361-.493.361-.821 0-.307-.117-.566-.35-.778-.227-.212-.548-.317-.964-.317-.416 0-.748.105-.997.317a.986.986 0 00-.372.778h-1.15a2.068 2.068 0 01.679-1.545c.219-.197.482-.354.789-.47a2.99 2.99 0 011.051-.176c.372 0 .708.059 1.008.176.306.116.565.273.777.47.219.198.387.431.504.701.117.263.175.544.175.844 0 .306-.058.562-.175.766-.11.205-.234.373-.372.504a2.018 2.018 0 01-.548.372v.055c.219.095.42.223.602.384.146.138.281.321.406.547.131.219.197.493.197.822 0 .313-.062.609-.186.887-.125.27-.3.507-.526.712-.226.197-.5.354-.822.47-.313.117-.66.176-1.04.176z"
                        fill="#171717"
                    />
                    <Path
                        d="M204.431 231.713c.026-.505.17-.885.432-1.141.268-.262.619-.393 1.054-.393.217 0 .399.039.546.115.153.071.291.154.412.25l.355.249c.108.07.23.105.364.105.191 0 .335-.057.431-.172.102-.122.166-.304.192-.547h.958c-.026.505-.173.888-.441 1.15-.262.256-.61.384-1.044.384-.218 0-.403-.035-.556-.106a3.463 3.463 0 01-.412-.249 4.674 4.674 0 00-.345-.249.615.615 0 00-.364-.115c-.371 0-.579.24-.623.719h-.959zm0-1.917c.026-.505.17-.885.432-1.14.268-.262.619-.393 1.054-.393.217 0 .399.038.546.115.153.07.291.153.412.249l.355.249c.108.07.23.106.364.106.191 0 .335-.058.431-.173.102-.121.166-.303.192-.546h.958c-.026.505-.173.888-.441 1.15-.262.255-.61.383-1.044.383a1.33 1.33 0 01-.556-.105 3.75 3.75 0 01-.412-.249 5.022 5.022 0 00-.345-.25.622.622 0 00-.364-.115c-.371 0-.579.24-.623.719h-.959zm7.597 1.869h1.677v-4.073h-1.677v-.958h1.389c.192 0 .288-.096.288-.288v-.431h1.006v5.75h1.677v.958h-4.36v-.958zm5.212-.144h1.102v1.102h-1.102v-1.102zm4.206 1.198c-.339 0-.652-.058-.939-.173a2.44 2.44 0 01-.738-.488 2.394 2.394 0 01-.499-.729 2.378 2.378 0 01-.172-.91c0-.268.032-.511.096-.728.07-.218.166-.422.287-.614l2.013-3.162h1.15l-1.486 2.3h.048l.125-.019a2.159 2.159 0 01.306-.029c.301 0 .582.061.844.182.262.115.488.275.68.479.198.205.352.444.46.719.115.268.173.559.173.872 0 .326-.061.629-.182.91a2.248 2.248 0 01-.489.729c-.211.204-.46.367-.748.488a2.476 2.476 0 01-.929.173zm0-.958c.191 0 .367-.032.527-.096.166-.071.31-.166.431-.288a1.368 1.368 0 00.383-.958c0-.192-.035-.367-.105-.527a1.226 1.226 0 00-.709-.709 1.302 1.302 0 00-.527-.106 1.368 1.368 0 00-.958.384 1.325 1.325 0 00-.288.431c-.064.16-.096.335-.096.527s.032.371.096.537c.07.159.166.3.288.421.121.122.261.217.421.288.166.064.345.096.537.096zm5.547-1.438h-.048a.662.662 0 01-.124.029 2.962 2.962 0 01-.144.019h-.163c-.3 0-.581-.057-.843-.172a2.314 2.314 0 01-.69-.489 2.426 2.426 0 01-.46-.709 2.371 2.371 0 01-.163-.882c0-.326.057-.626.172-.901.122-.281.288-.524.499-.728.211-.211.456-.374.738-.489.287-.121.6-.182.939-.182.332 0 .642.061.929.182.288.115.537.278.748.489.211.204.373.447.488.728.122.275.183.575.183.901 0 .268-.036.511-.106.728a2.394 2.394 0 01-.278.614l-2.012 3.162h-1.15l1.485-2.3zm-.287-.862c.191 0 .367-.032.527-.096.166-.07.31-.166.431-.288a1.368 1.368 0 00.383-.958c0-.192-.035-.367-.105-.527a1.226 1.226 0 00-.709-.709 1.302 1.302 0 00-.527-.106 1.368 1.368 0 00-.959.384 1.339 1.339 0 00-.287.431c-.064.16-.096.335-.096.527s.032.371.096.537a1.374 1.374 0 00.709.709c.166.064.345.096.537.096zm5.26 3.258c-.358 0-.7-.077-1.026-.23a2.538 2.538 0 01-.862-.671 3.43 3.43 0 01-.585-1.083 4.71 4.71 0 01-.211-1.466c0-.549.071-1.038.211-1.466a3.43 3.43 0 01.585-1.083 2.55 2.55 0 01.862-.671c.326-.153.668-.23 1.026-.23.357 0 .699.077 1.025.23.326.154.61.377.853.671.249.294.444.655.584 1.083.147.428.221.917.221 1.466 0 .549-.074 1.038-.221 1.466-.14.428-.335.789-.584 1.083a2.451 2.451 0 01-.853.671c-.326.153-.668.23-1.025.23zm0-.958c.217 0 .424-.052.622-.154.205-.102.384-.255.537-.46.16-.211.284-.469.374-.776.096-.313.144-.68.144-1.102 0-.422-.048-.786-.144-1.092a2.268 2.268 0 00-.374-.777 1.486 1.486 0 00-.537-.469 1.34 1.34 0 00-.622-.154c-.218 0-.428.052-.633.154a1.61 1.61 0 00-.537.469 2.532 2.532 0 00-.373.777 3.9 3.9 0 00-.134 1.092c0 .422.044.789.134 1.102.096.307.22.565.373.776.16.205.339.358.537.46.205.102.415.154.633.154zm5.259.958c-.345 0-.661-.051-.948-.153a2.435 2.435 0 01-.729-.432 1.979 1.979 0 01-.46-.642 1.954 1.954 0 01-.162-.786h1.006c0 .135.032.266.096.393.064.122.15.234.258.336.115.096.253.175.412.239.16.058.336.087.527.087.409 0 .719-.096.93-.288.211-.198.316-.453.316-.767a.952.952 0 00-.345-.737c-.223-.211-.54-.317-.948-.317h-.432v-.91h.432c.383 0 .677-.096.881-.288a.928.928 0 00.316-.718.885.885 0 00-.306-.681c-.198-.185-.479-.278-.844-.278-.364 0-.654.093-.872.278a.863.863 0 00-.325.681h-1.007a1.8 1.8 0 01.154-.738c.102-.236.249-.441.441-.613a2.15 2.15 0 01.69-.412c.274-.103.581-.154.919-.154.326 0 .62.051.882.154.268.102.495.239.68.412.192.172.339.377.441.613.103.23.154.476.154.738 0 .268-.051.492-.154.671a1.719 1.719 0 01-.326.44c-.14.135-.3.243-.479.326v.048c.192.083.368.195.527.336.128.121.246.281.355.479.115.191.172.431.172.718 0 .275-.054.534-.162.777a1.901 1.901 0 01-.46.622c-.198.173-.438.31-.719.413a2.6 2.6 0 01-.911.153zm5.26 0c-.357 0-.699-.077-1.025-.23a2.538 2.538 0 01-.862-.671 3.43 3.43 0 01-.585-1.083 4.681 4.681 0 01-.211-1.466c0-.549.07-1.038.211-1.466a3.43 3.43 0 01.585-1.083 2.55 2.55 0 01.862-.671c.326-.153.668-.23 1.025-.23.358 0 .7.077 1.026.23.326.154.61.377.853.671.249.294.444.655.584 1.083.147.428.221.917.221 1.466 0 .549-.074 1.038-.221 1.466-.14.428-.335.789-.584 1.083a2.451 2.451 0 01-.853.671c-.326.153-.668.23-1.026.23zm0-.958c.218 0 .425-.052.623-.154.205-.102.384-.255.537-.46.16-.211.284-.469.374-.776.095-.313.143-.68.143-1.102 0-.422-.048-.786-.143-1.092a2.268 2.268 0 00-.374-.777 1.486 1.486 0 00-.537-.469 1.342 1.342 0 00-.623-.154 1.4 1.4 0 00-.632.154 1.61 1.61 0 00-.537.469 2.51 2.51 0 00-.373.777c-.09.306-.135.67-.135 1.092 0 .422.045.789.135 1.102.095.307.22.565.373.776.16.205.339.358.537.46a1.4 1.4 0 00.632.154zm5.26.958c-.357 0-.699-.077-1.025-.23a2.55 2.55 0 01-.863-.671 3.449 3.449 0 01-.584-1.083 4.681 4.681 0 01-.211-1.466c0-.549.07-1.038.211-1.466.147-.428.342-.789.584-1.083.25-.294.537-.517.863-.671.326-.153.668-.23 1.025-.23.358 0 .7.077 1.026.23.325.154.61.377.853.671.249.294.444.655.584 1.083.147.428.22.917.22 1.466 0 .549-.073 1.038-.22 1.466-.14.428-.335.789-.584 1.083a2.46 2.46 0 01-.853.671c-.326.153-.668.23-1.026.23zm0-.958c.217 0 .425-.052.623-.154.205-.102.383-.255.537-.46.16-.211.284-.469.374-.776.095-.313.143-.68.143-1.102 0-.422-.048-.786-.143-1.092a2.268 2.268 0 00-.374-.777 1.495 1.495 0 00-.537-.469 1.345 1.345 0 00-1.255 0 1.61 1.61 0 00-.537.469 2.533 2.533 0 00-.374.777c-.089.306-.134.67-.134 1.092 0 .422.045.789.134 1.102.096.307.221.565.374.776.16.205.339.358.537.46a1.4 1.4 0 00.632.154zm5.26.958c-.396 0-.735-.061-1.016-.182a2.34 2.34 0 01-.699-.47 2.143 2.143 0 01-.412-.623 2.587 2.587 0 01-.173-.642h1.006c.026.122.071.24.135.355.064.115.15.217.258.307.109.089.237.162.384.22.153.051.326.077.517.077.409 0 .735-.122.978-.365.242-.242.364-.568.364-.977 0-.383-.122-.693-.364-.93-.243-.242-.569-.364-.978-.364-.268 0-.495.051-.68.154a1.27 1.27 0 00-.422.325h-1.054l.383-3.689h3.738v.958h-2.875l-.192 1.629h.048c.147-.095.316-.175.508-.239s.422-.096.69-.096c.313 0 .604.058.872.172.268.109.501.266.7.47.198.198.351.434.459.709.115.275.173.575.173.901 0 .339-.058.648-.173.93a2.186 2.186 0 01-.479.728 2.215 2.215 0 01-.747.469 2.536 2.536 0 01-.949.173zm5.26 0c-.345 0-.661-.051-.949-.153a2.418 2.418 0 01-.728-.432 1.979 1.979 0 01-.46-.642 1.939 1.939 0 01-.163-.786h1.006c0 .135.032.266.096.393.064.122.15.234.259.336.115.096.252.175.412.239.16.058.335.087.527.087.409 0 .719-.096.93-.288.21-.198.316-.453.316-.767a.952.952 0 00-.345-.737c-.224-.211-.54-.317-.949-.317h-.431v-.91h.431c.383 0 .677-.096.882-.288a.928.928 0 00.316-.718.883.883 0 00-.307-.681c-.198-.185-.479-.278-.843-.278s-.655.093-.872.278a.864.864 0 00-.326.681h-1.006a1.8 1.8 0 01.153-.738c.103-.236.249-.441.441-.613.192-.173.422-.31.69-.412.275-.103.581-.154.92-.154.326 0 .62.051.882.154.268.102.495.239.68.412.192.172.339.377.441.613a1.8 1.8 0 01.153.738c0 .268-.051.492-.153.671a1.742 1.742 0 01-.326.44c-.14.135-.3.243-.479.326v.048c.192.083.367.195.527.336.128.121.246.281.355.479.115.191.172.431.172.718 0 .275-.054.534-.163.777a1.887 1.887 0 01-.46.622c-.198.173-.437.31-.719.413a2.593 2.593 0 01-.91.153zm5.298-6.804h4.408v.958h-3.402v1.917h3.21v.958h-3.21v1.917h3.402v.958h-4.408v-6.708zm7.028.958h-2.108v-.958h5.222v.958h-2.108v5.75h-1.006v-5.75zm3.819-.958h1.006v2.827h3.402v-2.827h1.006v6.708h-1.006V229.7h-3.402v2.923h-1.006v-6.708z"
                        fill="#757575"
                    />
                </G>
            </G>
        </G>
        <G filter="url(#filter3_d_14530_54776)">
            <G clipPath="url(#clip5_14530_54776)">
                <Rect x={4} y={149.251} width={320} height={68.4492} rx={13.6898} fill="#fff" />
                <Rect x={4} y={149.251} width={320} height={68.4492} rx={13.6898} fill="#fff" />
                <G clipPath="url(#clip6_14530_54776)">
                    <Path
                        transform="translate(17.69 162.941)"
                        fill="#fff"
                        d="M0 0H292.62V41.0695H0z"
                    />
                    <Path
                        transform="translate(178.545 162.941)"
                        fill="url(#paint4_linear_14530_54776)"
                        d="M0 0H34.2246V41.0695H0z"
                    />
                    <Rect
                        x={17.6898}
                        y={162.941}
                        width={41.0695}
                        height={41.0695}
                        rx={20.5348}
                        fill="#F6F6F6"
                    />
                    <Circle cx={38.2246} cy={183.476} r={20.5348} fill="#F6F6F6" />
                    <Path
                        d="M38.225 162.941a20.537 20.537 0 0120.282 17.323 20.536 20.536 0 01-23.495 23.494 20.533 20.533 0 01-8.857-3.669l12.07-16.613v-20.535z"
                        fill="#fff"
                    />
                    <Path
                        d="M38.225 162.941a20.537 20.537 0 0120.282 17.323 20.536 20.536 0 01-23.495 23.494 20.533 20.533 0 01-8.857-3.669l12.07-16.613v-20.535z"
                        fill="#F29D40"
                        fillOpacity={0.3}
                    />
                    <Circle cx={38.2246} cy={183.476} r={13.6898} fill="#fff" />
                    <Path
                        d="M38.225 193.743c5.67 0 10.267-4.596 10.267-10.267 0-5.671-4.597-10.268-10.267-10.268-5.67 0-10.268 4.597-10.268 10.268s4.597 10.267 10.268 10.267z"
                        fill="#F29D40"
                    />
                    <Path
                        fillRule="evenodd"
                        clipRule="evenodd"
                        d="M35.091 178.389l.008.003a.106.106 0 01-.025.016l.017-.019zm.071.02l.022-.083-.085.066.063.017zm0 0c-.04.149-.078.303-.117.457-.047.183-.093.366-.14.541-.03.063 0 .095.063.095l.148.038c.208.052.431.108.655.185a.552.552 0 01.37.635c-.37 1.653-.772 3.275-1.173 4.896-.031.223-.217.35-.464.286a5.214 5.214 0 01-.679-.159c-.093 0-.123 0-.154.096a16.282 16.282 0 01-.417 1.001 3.27 3.27 0 01-.078.175c.741.19 1.452.381 2.162.572a.21.21 0 01-.02.085c-.005.016-.01.029-.01.042a23.663 23.663 0 00-.402 1.59c-.031.063-.031.095.062.127.308.063.617.127.926.222.082.028.092.007.114-.042a.285.285 0 01.01-.021c.03-.143.07-.286.108-.429.038-.143.077-.287.108-.43.03-.143.07-.286.108-.429.038-.143.077-.286.108-.429.278.064.525.127.772.191.045.023.041.046.035.08-.002.014-.004.029-.004.047-.154.509-.278 1.049-.401 1.589-.031.064-.031.096.061.128.14.031.286.071.433.111.146.04.293.079.432.111.148.061.154.035.181-.079l.004-.016c.062-.254.124-.517.185-.779.062-.262.124-.525.186-.779.03-.095.092-.127.185-.095.618.095 1.236.159 1.884.063a1.9 1.9 0 001.266-.699c.278-.35.433-.731.556-1.176.093-.35.124-.731.062-1.081a2.005 2.005 0 00-.741-1.081c-.062-.048-.124-.087-.186-.127-.061-.04-.123-.08-.185-.127.036 0 .062-.011.083-.02a.099.099 0 01.04-.012c.248-.095.495-.223.68-.413.247-.255.37-.573.463-.922.124-.509.093-1.018-.185-1.494a2.64 2.64 0 00-.803-.763l-1.02-.477c-.092-.032-.123-.064-.092-.159.062-.159.093-.318.124-.477.092-.381.185-.763.278-1.176-.016 0-.024-.008-.031-.016-.008-.008-.016-.016-.031-.016-.146-.041-.287-.076-.424-.111a9.958 9.958 0 01-.533-.143c-.062-.032-.093 0-.093.063l-.093.382a17.26 17.26 0 00-.308 1.208c-.01.01-.021.025-.031.039-.021.028-.042.056-.062.056-.124-.032-.255-.063-.386-.095a28.393 28.393 0 01-.386-.096c.03-.063.03-.095.03-.127.062-.254.124-.516.186-.779.062-.262.123-.524.185-.778.031-.064.031-.096-.062-.128a9.15 9.15 0 01-.895-.222c-.093-.032-.124 0-.155.095-.061.27-.123.533-.185.795s-.123.525-.185.795c-.031.095-.062.127-.155.095-.17-.048-.34-.087-.51-.127-.169-.04-.339-.08-.509-.127a10.53 10.53 0 00-.51-.127c-.145-.035-.292-.069-.438-.108zm1.504 7.833c.031 0 .062.032.062.032l.234.061c.424.113.867.23 1.31.257.37.032.71.032 1.05-.096.587-.19.834-.985.494-1.494-.154-.254-.401-.413-.648-.572-.54-.308-1.167-.437-1.768-.561l-.054-.011c-.085-.029-.092-.005-.116.071l-.008.024c-.03.159-.07.31-.108.461-.039.151-.077.302-.108.461-.07.254-.13.507-.193.767-.046.196-.094.395-.147.6zm2.934-3.306a1.935 1.935 0 01-.34.063 5.91 5.91 0 01-.988-.102c-.12-.019-.243-.039-.37-.057a3.426 3.426 0 01-.17-.047c-.055-.016-.109-.032-.17-.048-.062-.032-.093-.064-.062-.127.185-.668.34-1.303.494-1.971.03-.095.062-.127.154-.095l.273.073c.362.095.709.187 1.055.34.278.127.556.318.71.604.31.54 0 1.24-.586 1.367z"
                        fill="#fff"
                    />
                    <Path
                        transform="translate(69.027 162.941)"
                        fill="#fff"
                        d="M0 0H46.6898V41.0695H0z"
                    />
                    <Path
                        d="M70.053 167.826h4.244c.393 0 .753.069 1.082.206.337.137.63.328.876.575a2.619 2.619 0 01.78 1.889c0 .365-.054.675-.164.931-.11.255-.228.465-.356.629a2.859 2.859 0 01-.506.493v.069c.219.128.41.292.575.493.146.173.278.392.397.657.127.264.191.588.191.972 0 .374-.068.725-.205 1.054a2.51 2.51 0 01-.575.849c-.237.237-.52.424-.849.561a2.747 2.747 0 01-1.068.205h-4.421v-9.583zm4.313 8.283a1.3 1.3 0 00.958-.411c.128-.128.228-.278.301-.452.073-.173.11-.365.11-.575 0-.201-.037-.388-.11-.561a1.367 1.367 0 00-.3-.466 1.294 1.294 0 00-.96-.41h-2.874v2.875h2.875zm-.137-4.107a1.3 1.3 0 00.958-.411c.128-.128.228-.278.301-.452.073-.173.11-.365.11-.575 0-.201-.037-.388-.11-.561a1.353 1.353 0 00-.3-.465 1.283 1.283 0 00-.96-.411h-2.737v2.875h2.738zm4.25-1.438h1.368v6.845h-1.369v-6.845zm-.07-2.738h1.506v1.438H78.41v-1.438zm4.935 9.583c-.483 0-.857-.128-1.122-.383-.256-.256-.383-.607-.383-1.054v-4.107h-1.096v-1.301h1.096v-1.916h1.368v1.916h1.575v1.301h-1.575v3.901c0 .274.137.411.411.411h1.164v1.232h-1.438zm5.418.137c-.493 0-.95-.087-1.37-.26a3.312 3.312 0 01-1.095-.726 3.368 3.368 0 01-.712-1.122 4.106 4.106 0 01-.246-1.451c0-.53.082-1.013.246-1.451.174-.438.411-.813.712-1.123.31-.31.676-.552 1.096-.726.42-.173.876-.26 1.368-.26.512 0 .954.087 1.328.26.375.165.685.37.931.617.256.246.452.515.589.807.146.283.246.543.301.781h-1.369a1.918 1.918 0 00-.233-.452 1.603 1.603 0 00-.356-.397 1.416 1.416 0 00-.506-.274c-.2-.073-.429-.11-.684-.11-.293 0-.566.055-.822.165-.246.109-.46.264-.643.465a2.269 2.269 0 00-.438.739c-.1.283-.151.603-.151.959s.05.68.15.972c.11.283.256.524.439.725.182.201.397.356.643.466.256.109.53.164.822.164a1.877 1.877 0 001.245-.438c.146-.137.26-.278.343-.424.09-.156.155-.302.191-.439h1.37a3.747 3.747 0 01-.302.836 2.916 2.916 0 01-.589.821 3.227 3.227 0 01-.93.63c-.375.164-.817.246-1.329.246zm7.25 0c-.492 0-.948-.087-1.368-.26a3.311 3.311 0 01-1.095-.726 3.366 3.366 0 01-.712-1.122 4.104 4.104 0 01-.247-1.451 4.1 4.1 0 01.247-1.451 3.37 3.37 0 01.712-1.123c.31-.31.675-.552 1.095-.726.42-.173.876-.26 1.369-.26s.949.087 1.369.26a3.192 3.192 0 011.793 1.849c.174.438.26.921.26 1.451a3.91 3.91 0 01-.26 1.451 3.103 3.103 0 01-.712 1.122 3.164 3.164 0 01-1.081.726c-.42.173-.876.26-1.37.26zm0-1.232a1.974 1.974 0 001.466-.63c.182-.201.324-.442.424-.725a2.75 2.75 0 00.164-.972c0-.356-.055-.676-.164-.959a2.096 2.096 0 00-.424-.739 1.863 1.863 0 00-.657-.465 1.959 1.959 0 00-.808-.165c-.292 0-.566.055-.822.165-.246.109-.46.264-.643.465a2.272 2.272 0 00-.438.739c-.1.283-.15.603-.15.959s.05.68.15.972a2.3 2.3 0 00.438.725c.183.201.397.356.643.466.256.109.53.164.822.164zm4.52-5.75h1.369v6.845h-1.369v-6.845zm-.069-2.738h1.506v1.438h-1.506v-1.438zm2.881 2.738h1.232l.137.685h.069c.146-.155.315-.292.506-.411.165-.1.37-.192.616-.274.247-.091.534-.137.863-.137.411 0 .785.069 1.122.206.338.127.626.315.863.561.237.246.42.548.547.904.137.355.206.757.206 1.204v4.107h-1.369v-4.107c0-.219-.041-.429-.123-.63a1.586 1.586 0 00-.343-.52 1.467 1.467 0 00-.52-.356 1.574 1.574 0 00-.657-.137c-.256 0-.493.046-.712.137a1.552 1.552 0 00-.561.356c-.155.146-.278.32-.37.52a1.511 1.511 0 00-.137.63v4.107h-1.369v-6.845z"
                        fill="#171717"
                    />
                    <Rect
                        x={69.0267}
                        y={185.12}
                        width={46.6898}
                        height={17.7112}
                        rx={8.85561}
                        fill="#F6F6F6"
                    />
                    <Path
                        d="M79.106 197.079c-.452 0-.852-.058-1.201-.175a2.728 2.728 0 01-.883-.493 2.228 2.228 0 01-.555-.739 2.222 2.222 0 01-.185-.903h1.078c0 .164.041.325.124.482.082.158.198.294.349.411.15.116.332.212.544.287.219.069.462.103.729.103.589 0 1.01-.103 1.263-.308a.952.952 0 00.38-.77c0-.527-.411-.869-1.232-1.027l-1.386-.256c-.569-.103-.993-.322-1.274-.658-.28-.335-.42-.749-.42-1.242 0-.294.058-.568.174-.821.123-.26.294-.483.513-.668.22-.191.486-.342.801-.451.322-.11.681-.165 1.078-.165.452 0 .846.062 1.18.185.343.116.627.281.853.493.226.205.397.448.513.729.117.281.175.582.175.903h-1.078c0-.164-.038-.325-.113-.482a1.173 1.173 0 00-.329-.411 1.528 1.528 0 00-.513-.277 1.993 1.993 0 00-.688-.113c-.246 0-.462.031-.647.092a1.28 1.28 0 00-.462.237 1.032 1.032 0 00-.287.338.948.948 0 00-.093.411c0 .233.083.435.247.606.164.171.441.294.832.369l1.129.206c.726.13 1.256.356 1.591.677.343.315.514.757.514 1.325 0 .294-.058.571-.175.832a1.928 1.928 0 01-.513.667c-.226.185-.51.332-.852.441-.336.11-.73.165-1.181.165zm6.075 0c-.37 0-.712-.065-1.027-.195a2.492 2.492 0 01-.821-.545 2.523 2.523 0 01-.534-.841 3.083 3.083 0 01-.185-1.089c0-.397.061-.76.185-1.088.13-.329.308-.609.534-.842a2.49 2.49 0 01.821-.544c.315-.13.657-.195 1.027-.195.349 0 .67.065.965.195.301.123.561.298.78.523.226.226.4.493.524.801a2.533 2.533 0 01.164 1.366 3.556 3.556 0 01-.02.144H83.64c.054.438.222.787.503 1.047.28.26.626.39 1.037.39.15 0 .29-.021.42-.062.138-.041.257-.095.36-.164.11-.068.202-.144.277-.226.076-.089.134-.178.175-.267h1.078a2.823 2.823 0 01-.277.534c-.123.185-.281.356-.473.514a2.531 2.531 0 01-.677.39 2.352 2.352 0 01-.883.154zm1.489-3.08c-.055-.411-.216-.743-.483-.996-.26-.261-.596-.391-1.006-.391-.438 0-.787.13-1.047.391-.254.253-.418.585-.493.996h3.028zm4.23 5.133c-.425 0-.784-.065-1.079-.195a2.2 2.2 0 01-.718-.462 1.83 1.83 0 01-.411-.606 1.902 1.902 0 01-.154-.585h1.027a.907.907 0 00.113.339c.061.109.147.209.256.298.117.089.254.157.411.205.164.055.35.082.555.082.205 0 .393-.034.564-.103a1.25 1.25 0 00.431-.277c.124-.116.22-.256.288-.421.068-.164.102-.342.102-.534v-.821h-.05c-.062.062-.134.13-.216.205a1.54 1.54 0 01-.308.195c-.124.062-.27.113-.442.154-.171.042-.38.062-.626.062a2.184 2.184 0 01-1.612-.667 2.473 2.473 0 01-.472-.781 2.85 2.85 0 01-.175-1.016c0-.37.058-.705.174-1.006.117-.308.274-.568.473-.781.205-.219.445-.386.718-.503.274-.116.572-.174.894-.174.246 0 .458.027.636.082.185.048.34.106.462.174.13.069.233.144.308.226.082.076.144.137.185.185h.052l.102-.565h.924v5.031c0 .336-.055.64-.164.914-.103.281-.257.52-.462.719a2.13 2.13 0 01-.76.462 3.005 3.005 0 01-1.026.164zm-.052-3.388c.206 0 .394-.038.565-.113.178-.075.332-.178.462-.308.13-.137.23-.298.298-.483a1.72 1.72 0 00.112-.636c0-.233-.037-.442-.112-.626a1.278 1.278 0 00-.298-.483 1.355 1.355 0 00-.462-.318 1.375 1.375 0 00-.565-.113c-.205 0-.397.037-.575.113a1.382 1.382 0 00-.452.318c-.13.13-.232.291-.308.483a1.787 1.787 0 00-.102.626c0 .233.034.445.102.636.076.185.178.346.308.483.13.13.281.233.452.308.178.075.37.113.575.113zm3.148-3.902h1.079l.975 3.799h.205l1.006-3.799h1.376l1.006 3.799h.206l.975-3.799h1.078l-1.386 5.134h-1.489l-.975-3.696h-.205l-.976 3.696h-1.489l-1.386-5.134zm8.591 0h1.027v5.134h-1.027v-5.134zm-.051-2.053h1.129v1.078h-1.129v-1.078zm3.872 7.187c-.363 0-.643-.096-.842-.287-.192-.192-.287-.456-.287-.791v-3.08h-.822v-.976h.822v-1.437h1.026v1.437h1.181v.976h-1.181v2.926c0 .205.103.308.308.308h.873v.924h-1.078z"
                        fill="#757575"
                    />
                    <Path
                        transform="translate(219.615 162.941)"
                        fill="#fff"
                        d="M0 0H90.6952V41.0695H0z"
                    />
                    <Path
                        d="M254.459 177.347a3.876 3.876 0 01-1.191-.384 3.299 3.299 0 01-.89-.67 2.867 2.867 0 01-.548-.904 3.213 3.213 0 01-.178-1.068h1.438c0 .219.05.434.15.644.11.21.261.392.452.547.192.156.42.283.685.384.274.091.575.137.903.137.721 0 1.241-.137 1.561-.411.328-.274.493-.616.493-1.027 0-.347-.114-.634-.343-.862-.228-.238-.616-.406-1.163-.507l-1.848-.342c-.758-.137-1.301-.429-1.629-.876-.329-.447-.493-1-.493-1.657 0-.356.059-.689.178-.999.128-.32.305-.598.534-.835.228-.237.502-.434.821-.589a3.3 3.3 0 011.068-.328v-1.424h1.369v1.41c.447.055.844.173 1.191.356.347.173.639.397.876.671.237.264.42.57.548.917.127.338.191.703.191 1.095h-1.437c0-.219-.05-.433-.151-.643-.1-.21-.242-.393-.424-.548a1.94 1.94 0 00-.644-.37 2.2 2.2 0 00-.835-.15c-.292 0-.552.041-.78.123a1.741 1.741 0 00-.589.315 1.314 1.314 0 00-.356.452 1.264 1.264 0 00-.123.547c0 .311.087.584.26.822.183.228.53.388 1.041.479l1.506.274c.958.173 1.642.474 2.053.903.411.429.616 1.018.616 1.766 0 .365-.064.707-.192 1.027-.127.31-.314.589-.561.835a3.01 3.01 0 01-.931.616 4.237 4.237 0 01-1.259.301v1.397h-1.369v-1.424zm5.138-1.314l3.942-3.97c.119-.119.224-.233.315-.343.092-.109.165-.219.219-.328.064-.119.11-.242.137-.37.028-.137.041-.292.041-.465 0-.521-.141-.922-.424-1.205-.283-.292-.666-.438-1.15-.438a1.654 1.654 0 00-1.218.52 1.671 1.671 0 00-.37.575 2.21 2.21 0 00-.123.753h-1.438c0-.475.078-.908.233-1.301a3.02 3.02 0 01.644-1.026c.282-.283.616-.502.999-.657a3.347 3.347 0 011.273-.233c.465 0 .885.073 1.259.219.384.146.708.351.972.616.274.265.484.584.63.958.146.365.219.771.219 1.219 0 .292-.041.561-.123.807a2.936 2.936 0 01-.301.671 4 4 0 01-.438.589c-.164.182-.333.36-.507.534l-2.669 2.669v.069h4.175v1.369h-6.297v-1.232zm7.534-.343h1.574l-.753 2.738h-1.095l.274-2.738zm2.879.206h2.396v-5.819h-2.396v-1.369h1.985c.274 0 .411-.136.411-.41v-.616h1.437v8.214h2.396v1.369h-6.229v-1.369zm10.477 1.506c-.511 0-.972-.073-1.382-.219a3.28 3.28 0 01-1.027-.617 2.714 2.714 0 01-.657-.889 2.764 2.764 0 01-.219-1.082c0-.411.073-.757.219-1.04.146-.283.31-.516.492-.698.21-.21.452-.384.726-.521v-.068a2.072 2.072 0 01-.616-.466 2.594 2.594 0 01-.424-.629c-.128-.256-.192-.575-.192-.959 0-.356.068-.693.205-1.013.146-.328.352-.616.616-.862.265-.247.584-.438.959-.575a3.627 3.627 0 011.3-.219c.475 0 .904.073 1.287.219.383.137.707.328.972.575.265.246.465.534.602.862.146.32.219.657.219 1.013 0 .384-.063.703-.191.959a2.596 2.596 0 01-.425.629 2.33 2.33 0 01-.616.466v.068c.265.137.502.311.712.521.183.182.347.415.493.698.155.283.233.629.233 1.04 0 .374-.078.735-.233 1.082-.146.337-.36.634-.643.889a3.25 3.25 0 01-1.041.617 3.988 3.988 0 01-1.369.219zm0-1.301c.274 0 .525-.041.753-.123.228-.082.42-.192.575-.329.164-.146.292-.315.383-.506.092-.192.137-.397.137-.616a1.439 1.439 0 00-.52-1.109 1.632 1.632 0 00-.575-.342 2.187 2.187 0 00-.753-.124c-.274 0-.525.041-.753.124a1.778 1.778 0 00-.588.342 1.506 1.506 0 00-.37.493 1.416 1.416 0 00-.137.616c0 .219.046.424.137.616.091.191.214.36.37.506.164.137.36.247.588.329.228.082.479.123.753.123zm0-4.381c.52 0 .922-.137 1.205-.41a1.35 1.35 0 00.438-1.027 1.35 1.35 0 00-.438-1.027c-.283-.274-.685-.411-1.205-.411s-.926.137-1.218.411a1.37 1.37 0 00-.425 1.027c0 .411.142.753.425 1.027.292.273.698.41 1.218.41zm7.876 2.259h-.068a1.032 1.032 0 01-.178.041 5.395 5.395 0 01-.206.028h-.232c-.429 0-.831-.083-1.205-.247a3.278 3.278 0 01-.986-.698 3.453 3.453 0 01-.657-1.013 3.4 3.4 0 01-.233-1.26 3.3 3.3 0 01.247-1.286c.173-.402.411-.749.712-1.041a3.166 3.166 0 011.054-.698c.411-.173.858-.26 1.341-.26.475 0 .918.087 1.328.26.411.164.767.397 1.068.698.301.292.534.639.698 1.041.174.392.26.821.26 1.286 0 .384-.05.731-.15 1.041a3.46 3.46 0 01-.397.876l-2.875 4.518h-1.643l2.122-3.286zm-.411-1.232c.274 0 .525-.046.753-.137.238-.1.443-.237.616-.411a1.76 1.76 0 00.397-.602c.101-.237.151-.493.151-.767 0-.273-.05-.524-.151-.753a1.742 1.742 0 00-1.013-1.013c-.228-.1-.479-.15-.753-.15a1.952 1.952 0 00-1.369.547c-.173.174-.31.379-.41.616-.092.229-.137.48-.137.753 0 .274.045.53.137.767a1.954 1.954 0 001.013 1.013c.237.091.493.137.766.137zm4.385 2.943h1.575v1.575h-1.575v-1.575zm5.96 1.712c-.511 0-.999-.11-1.464-.329a3.634 3.634 0 01-1.233-.958c-.346-.42-.625-.936-.835-1.547-.2-.612-.301-1.31-.301-2.095 0-.785.101-1.483.301-2.094.21-.612.489-1.127.835-1.547.356-.42.767-.74 1.233-.959a3.395 3.395 0 011.464-.328c.511 0 1 .109 1.465.328.466.219.872.539 1.219.959.355.42.634.935.835 1.547.21.611.314 1.309.314 2.094 0 .785-.104 1.483-.314 2.095-.201.611-.48 1.127-.835 1.547-.347.42-.753.739-1.219.958a3.4 3.4 0 01-1.465.329zm0-1.369c.311 0 .607-.073.89-.219.292-.146.548-.366.767-.658.228-.301.406-.67.534-1.108.137-.448.205-.972.205-1.575 0-.602-.068-1.122-.205-1.56-.128-.448-.306-.817-.534-1.109a2.13 2.13 0 00-.767-.671 1.914 1.914 0 00-.89-.219c-.31 0-.611.073-.903.219-.283.146-.539.37-.767.671-.219.292-.397.661-.534 1.109-.127.438-.191.958-.191 1.56 0 .603.064 1.127.191 1.575.137.438.315.807.534 1.108.228.292.484.512.767.658.292.146.593.219.903.219zm7.466 1.369c-.493 0-.945-.073-1.356-.219a3.466 3.466 0 01-1.04-.617 2.812 2.812 0 01-.657-.917 2.781 2.781 0 01-.233-1.122h1.437c0 .191.046.378.137.561.092.173.215.333.37.479.164.137.36.251.589.342.228.082.479.124.753.124.584 0 1.026-.137 1.328-.411.301-.283.451-.648.451-1.095 0-.411-.164-.762-.493-1.054-.319-.302-.771-.452-1.355-.452h-.616v-1.301h.616c.548 0 .968-.137 1.26-.41a1.33 1.33 0 00.451-1.027c0-.383-.146-.707-.438-.972-.283-.265-.684-.397-1.204-.397-.521 0-.936.132-1.246.397-.31.265-.466.589-.466.972h-1.437c0-.374.073-.726.219-1.054.146-.338.356-.63.63-.876.273-.247.602-.443.985-.589a3.751 3.751 0 011.315-.219c.465 0 .885.073 1.259.219.383.146.707.342.972.589.274.246.484.538.63.876.146.328.219.68.219 1.054 0 .383-.073.703-.219.958a2.433 2.433 0 01-.466.63c-.2.192-.429.347-.684.465v.069c.274.118.525.278.753.479.182.173.351.401.506.684.165.274.247.616.247 1.027 0 .393-.078.762-.233 1.109a2.718 2.718 0 01-.657.89 3.244 3.244 0 01-1.027.589 3.702 3.702 0 01-1.3.219z"
                        fill="#171717"
                    />
                    <Path
                        d="M226.724 198.096c-.447 0-.874-.096-1.282-.288a3.199 3.199 0 01-1.078-.838 4.293 4.293 0 01-.73-1.354c-.176-.535-.264-1.146-.264-1.833 0-.686.088-1.297.264-1.832.183-.535.427-.987.73-1.354a3.186 3.186 0 011.078-.838 2.975 2.975 0 011.282-.288c.447 0 .875.096 1.282.288a3.07 3.07 0 011.066.838c.311.367.555.819.731 1.354.183.535.275 1.146.275 1.832 0 .687-.092 1.298-.275 1.833-.176.535-.42.986-.731 1.354a3.083 3.083 0 01-1.066.838 2.971 2.971 0 01-1.282.288zm0-1.198c.272 0 .531-.064.779-.192.255-.128.479-.319.67-.575.2-.263.356-.587.468-.97.119-.391.179-.851.179-1.378 0-.527-.06-.982-.179-1.365a2.816 2.816 0 00-.468-.971 1.853 1.853 0 00-.67-.586 1.675 1.675 0 00-.779-.192 1.75 1.75 0 00-.791.192 1.993 1.993 0 00-.67.586 3.114 3.114 0 00-.467.971c-.112.383-.168.838-.168 1.365s.056.987.168 1.378c.119.383.275.707.467.97.199.256.423.447.67.575.256.128.52.192.791.192zm3.88-.3h1.377v1.378h-1.377v-1.378zm2.622.18h2.096v-5.091h-2.096v-1.198h1.737c.24 0 .359-.12.359-.359v-.539h1.258v7.187h2.096v1.198h-5.45v-1.198zm9.21 1.318c-.431 0-.826-.064-1.186-.192a3.025 3.025 0 01-.91-.539 2.485 2.485 0 01-.575-.803 2.427 2.427 0 01-.204-.982h1.258c0 .168.04.332.12.491.08.152.188.292.323.419.144.12.316.22.515.3.2.072.42.108.659.108.511 0 .899-.12 1.162-.36.264-.247.396-.567.396-.958 0-.359-.144-.667-.432-.922-.279-.264-.674-.396-1.186-.396h-.539v-1.138h.539c.48 0 .847-.119 1.102-.359.264-.239.396-.539.396-.898 0-.336-.128-.619-.384-.851-.247-.231-.598-.347-1.054-.347-.455 0-.818.116-1.09.347-.271.232-.407.515-.407.851h-1.258c0-.328.064-.635.192-.923.128-.295.311-.551.551-.766.239-.216.527-.388.862-.515a3.276 3.276 0 011.15-.192c.408 0 .775.064 1.102.192.336.127.619.299.851.515.239.215.423.471.551.766.128.288.192.595.192.923 0 .335-.064.615-.192.838a2.15 2.15 0 01-.407.551 2.221 2.221 0 01-.599.408v.059c.239.104.459.244.658.42.16.151.308.351.444.599.143.239.215.539.215.898 0 .343-.068.667-.203.97a2.39 2.39 0 01-.575.779 2.834 2.834 0 01-.899.515 3.231 3.231 0 01-1.138.192zm7.893-7.307h-4.013v-1.198h5.45v1.078l-2.994 7.307h-1.39l2.947-7.187zm5.257 7.307c-.495 0-.918-.076-1.27-.228a2.935 2.935 0 01-.874-.587 2.69 2.69 0 01-.515-.779 3.247 3.247 0 01-.216-.802h1.258c.032.152.088.299.168.443.079.144.187.272.323.383.136.112.296.204.479.276.192.064.407.096.647.096.511 0 .918-.152 1.222-.455.303-.304.455-.711.455-1.222 0-.479-.152-.867-.455-1.162-.304-.304-.711-.455-1.222-.455-.335 0-.619.064-.85.191-.232.12-.408.256-.527.408h-1.318l.479-4.612h4.672v1.198h-3.594l-.239 2.036h.059c.184-.12.396-.22.635-.299.24-.08.527-.12.863-.12.391 0 .754.072 1.09.215.335.136.627.332.874.587.248.248.439.543.575.887.144.343.216.718.216 1.126 0 .423-.072.81-.216 1.162a2.73 2.73 0 01-.599.91 2.773 2.773 0 01-.934.587 3.16 3.16 0 01-1.186.216zm6.575 0c-.431 0-.827-.064-1.186-.192a3.013 3.013 0 01-.91-.539 2.455 2.455 0 01-.575-.803 2.427 2.427 0 01-.204-.982h1.258c0 .168.04.332.12.491.079.152.187.292.323.419.144.12.315.22.515.3.2.072.419.108.659.108.511 0 .898-.12 1.162-.36.263-.247.395-.567.395-.958 0-.359-.144-.667-.431-.922-.28-.264-.675-.396-1.186-.396h-.539v-1.138h.539c.479 0 .847-.119 1.102-.359a1.16 1.16 0 00.395-.898c0-.336-.127-.619-.383-.851-.248-.231-.599-.347-1.054-.347-.455 0-.819.116-1.09.347a1.076 1.076 0 00-.407.851h-1.258a2.26 2.26 0 01.743-1.689c.239-.216.527-.388.862-.515a3.272 3.272 0 011.15-.192c.407 0 .775.064 1.102.192.335.127.619.299.85.515.24.215.424.471.551.766.128.288.192.595.192.923 0 .335-.064.615-.192.838a2.104 2.104 0 01-1.006.959v.059c.24.104.459.244.659.42.16.151.308.351.443.599.144.239.216.539.216.898 0 .343-.068.667-.204.97a2.377 2.377 0 01-.575.779 2.829 2.829 0 01-.898.515 3.24 3.24 0 01-1.138.192zm3.88-1.198l3.449-3.474c.104-.104.196-.204.276-.3a1.467 1.467 0 00.311-.61c.024-.12.036-.256.036-.408 0-.455-.123-.806-.371-1.054-.248-.255-.583-.383-1.006-.383a1.454 1.454 0 00-1.066.455 1.484 1.484 0 00-.324.503 1.93 1.93 0 00-.108.659h-1.257c0-.415.068-.795.203-1.138.136-.351.324-.651.563-.898.248-.248.539-.44.875-.575a2.938 2.938 0 011.114-.204c.407 0 .774.064 1.102.192.335.127.619.307.85.539.24.231.424.511.551.838.128.32.192.675.192 1.066 0 .256-.036.491-.108.707a2.627 2.627 0 01-.263.587c-.112.184-.24.355-.384.515-.143.16-.291.316-.443.467l-2.336 2.336v.06h3.654v1.198h-5.51v-1.078zm9.27 1.198c-.448 0-.875-.096-1.282-.288a3.19 3.19 0 01-1.078-.838 4.294 4.294 0 01-.731-1.354c-.176-.535-.263-1.146-.263-1.833 0-.686.087-1.297.263-1.832.184-.535.427-.987.731-1.354a3.177 3.177 0 011.078-.838 2.968 2.968 0 011.282-.288c.447 0 .874.096 1.281.288.408.191.763.471 1.066.838.312.367.555.819.731 1.354.184.535.276 1.146.276 1.832 0 .687-.092 1.298-.276 1.833a3.997 3.997 0 01-.731 1.354 3.064 3.064 0 01-1.066.838 2.967 2.967 0 01-1.281.288zm0-1.198c.271 0 .531-.064.778-.192a1.9 1.9 0 00.671-.575c.2-.263.355-.587.467-.97.12-.391.18-.851.18-1.378 0-.527-.06-.982-.18-1.365a2.816 2.816 0 00-.467-.971 1.855 1.855 0 00-.671-.586 1.67 1.67 0 00-.778-.192c-.272 0-.535.064-.791.192a2.005 2.005 0 00-.671.586 3.158 3.158 0 00-.467.971c-.112.383-.168.838-.168 1.365s.056.987.168 1.378c.12.383.276.707.467.97.2.256.424.447.671.575.256.128.519.192.791.192zm6.575 1.198c-.448 0-.875-.096-1.282-.288a3.19 3.19 0 01-1.078-.838 4.294 4.294 0 01-.731-1.354c-.176-.535-.263-1.146-.263-1.833 0-.686.087-1.297.263-1.832.184-.535.427-.987.731-1.354a3.177 3.177 0 011.078-.838 2.968 2.968 0 011.282-.288c.447 0 .874.096 1.281.288.407.191.763.471 1.066.838.312.367.555.819.731 1.354.184.535.276 1.146.276 1.832 0 .687-.092 1.298-.276 1.833a3.997 3.997 0 01-.731 1.354 3.073 3.073 0 01-1.066.838 2.967 2.967 0 01-1.281.288zm0-1.198c.271 0 .531-.064.778-.192a1.9 1.9 0 00.671-.575c.2-.263.355-.587.467-.97.12-.391.18-.851.18-1.378 0-.527-.06-.982-.18-1.365a2.816 2.816 0 00-.467-.971 1.855 1.855 0 00-.671-.586 1.67 1.67 0 00-.778-.192c-.272 0-.536.064-.791.192a1.995 1.995 0 00-.671.586 3.136 3.136 0 00-.467.971c-.112.383-.168.838-.168 1.365s.056.987.168 1.378c.12.383.275.707.467.97.2.256.423.447.671.575.255.128.519.192.791.192zm6.621-7.307h3.714c.343 0 .659.06.946.179.296.12.551.288.767.504a2.285 2.285 0 01.682 1.653c0 .319-.047.591-.143.814-.096.224-.2.407-.312.551a2.432 2.432 0 01-.443.431v.06c.192.112.359.256.503.432.128.151.244.343.348.575.111.231.167.515.167.85 0 .327-.06.635-.179.922-.12.288-.288.535-.504.743a2.267 2.267 0 01-.742.491c-.288.12-.599.18-.935.18h-3.869v-8.385zm3.774 7.247a1.138 1.138 0 00.838-.359 1.227 1.227 0 00.359-.899 1.25 1.25 0 00-.095-.491 1.194 1.194 0 00-.264-.407 1.121 1.121 0 00-.838-.36h-2.516v2.516h2.516zm-.12-3.594a1.134 1.134 0 00.838-.359 1.233 1.233 0 00.36-.898c0-.176-.032-.34-.096-.492a1.203 1.203 0 00-.264-.407 1.134 1.134 0 00-.838-.359h-2.396v2.515h2.396zm5.623-2.455h-2.635v-1.198h6.528v1.198h-2.635v7.187h-1.258v-7.187zm8.193 7.307a3.937 3.937 0 01-2.839-1.186 4.444 4.444 0 01-.862-1.366 4.76 4.76 0 01-.311-1.761c0-.647.103-1.233.311-1.761.216-.527.503-.978.862-1.353a3.868 3.868 0 012.839-1.198c.527 0 1.003.084 1.426.252.423.159.794.379 1.114.658a3.852 3.852 0 011.234 2.025h-1.318c-.208-.567-.535-.998-.982-1.294a2.623 2.623 0 00-1.474-.443c-.391 0-.754.072-1.09.215a2.514 2.514 0 00-.874.623 3.003 3.003 0 00-.587.983 3.847 3.847 0 00-.204 1.293c0 .479.068.911.204 1.294.144.383.339.711.587.982.247.272.539.479.874.623.336.144.699.216 1.09.216a2.46 2.46 0 001.629-.563c.208-.168.38-.36.516-.575.135-.216.239-.435.311-.659h1.318a4.047 4.047 0 01-.396 1.03 3.92 3.92 0 01-.754.97 4.01 4.01 0 01-1.126.719c-.432.184-.931.276-1.498.276z"
                        fill="#757575"
                    />
                </G>
            </G>
        </G>
        <Rect x={98} width={52} height={18} rx={9} fill="#CEF7EB" />
        <Path
            d="M108.173 7.688a.379.379 0 01.654 0l1.309 2.25a.375.375 0 01-.327.562h-2.618a.375.375 0 01-.327-.563l1.309-2.25zM119.728 10.925h-3.413v-.893l2.783-4.882h1.732v4.777h.893v.998h-.893V12.5h-1.102v-1.575zm0-.998V6.516h-.21l-1.89 3.36v.053h2.1zm2.718 1.366h1.207l-.577 2.1h-.84l.21-2.1zm4.871-1.313h-.053a.774.774 0 01-.136.031 3.032 3.032 0 01-.158.022h-.178c-.329 0-.637-.063-.924-.19a2.515 2.515 0 01-.756-.535 2.654 2.654 0 01-.504-.777 2.604 2.604 0 01-.179-.966c0-.357.063-.686.189-.987.133-.308.315-.574.546-.798.231-.231.501-.41.809-.535.315-.133.658-.2 1.029-.2.364 0 .703.067 1.018.2.315.125.588.304.819.535.231.224.41.49.536.798.133.301.199.63.199.987 0 .294-.038.56-.115.798-.07.238-.172.462-.305.672l-2.205 3.465h-1.26l1.628-2.52zm-.315-.945c.21 0 .402-.035.577-.105.182-.077.34-.182.473-.315a1.36 1.36 0 00.304-.462c.077-.182.116-.378.116-.588 0-.21-.039-.403-.116-.578a1.338 1.338 0 00-.777-.777 1.416 1.416 0 00-.577-.115 1.493 1.493 0 00-1.05.42 1.47 1.47 0 00-.315.473c-.07.174-.105.367-.105.577 0 .21.035.406.105.588a1.503 1.503 0 00.777.777c.182.07.378.105.588.105zm5.763 3.57c-.371 0-.714-.063-1.029-.189a2.667 2.667 0 01-.808-.536 2.61 2.61 0 01-.546-.798 2.609 2.609 0 01-.189-.997c0-.294.035-.56.105-.798.077-.238.182-.462.315-.672l2.205-3.465h1.26l-1.628 2.52h.053a5.901 5.901 0 01.283-.042 2.17 2.17 0 011.113.189c.287.126.536.301.746.525.217.224.385.486.504.787a2.4 2.4 0 01.189.956c0 .357-.067.69-.2.997a2.462 2.462 0 01-.535.798 2.636 2.636 0 01-.819.536 2.72 2.72 0 01-1.019.189zm0-1.05c.21 0 .403-.035.578-.105.182-.077.339-.182.472-.315a1.493 1.493 0 00.42-1.05c0-.21-.038-.403-.115-.578a1.34 1.34 0 00-.777-.777 1.42 1.42 0 00-.578-.115 1.493 1.493 0 00-1.05.42 1.47 1.47 0 00-.315.473c-.07.175-.105.367-.105.577 0 .21.035.406.105.588a1.503 1.503 0 00.777.777c.182.07.378.105.588.105zm8.651-6.405h1.05l-4.567 7.35h-1.05l4.567-7.35zm.315 7.455a1.71 1.71 0 01-.661-.126 1.888 1.888 0 01-.536-.357 1.885 1.885 0 01-.357-.536 1.713 1.713 0 01-.126-.661c0-.238.042-.459.126-.662.091-.203.21-.377.357-.524.154-.155.333-.274.536-.357.203-.091.423-.137.661-.137a1.6 1.6 0 01.662.137c.203.084.378.203.525.357.154.146.273.321.357.524.091.204.136.424.136.662 0 .238-.045.458-.136.661a1.632 1.632 0 01-.357.536 1.741 1.741 0 01-.525.357 1.716 1.716 0 01-.662.126zm0-.84c.238 0 .427-.074.567-.22.147-.147.221-.354.221-.62s-.074-.473-.221-.62c-.14-.146-.329-.22-.567-.22a.78.78 0 00-.577.22c-.14.148-.21.354-.21.62s.07.473.21.62a.78.78 0 00.577.22zm-4.147-3.36c-.238 0-.459-.042-.662-.126a1.883 1.883 0 01-.535-.357 1.885 1.885 0 01-.357-.535 1.713 1.713 0 01-.126-.662c0-.238.042-.458.126-.661.091-.204.21-.378.357-.526a1.63 1.63 0 01.535-.357 1.6 1.6 0 01.662-.136c.238 0 .458.045.661.136.203.085.378.204.525.357.154.147.273.322.357.526.091.202.137.423.137.661 0 .238-.046.459-.137.662a1.632 1.632 0 01-.357.535 1.741 1.741 0 01-.525.357 1.71 1.71 0 01-.661.126zm0-.84c.238 0 .427-.074.567-.22.147-.147.22-.354.22-.62s-.073-.472-.22-.62c-.14-.147-.329-.22-.567-.22a.782.782 0 00-.578.22c-.14.147-.21.354-.21.62s.07.473.21.62c.147.147.34.22.578.22z"
            fill="#0F6148"
        />
        <Defs>
            <LinearGradient
                id="paint0_linear_14530_54776"
                x1={324}
                y1={100.999}
                x2={4}
                y2={101}
                gradientUnits="userSpaceOnUse"
            >
                <Stop stopColor="#CBCBCB" stopOpacity={0} />
                <Stop offset={0.506029} stopColor="#CBCBCB" />
                <Stop offset={1} stopColor="#CBCBCB" stopOpacity={0} />
            </LinearGradient>
            <LinearGradient
                id="paint1_linear_14530_54776"
                x1={4}
                y1={62.0002}
                x2={324}
                y2={62.0002}
                gradientUnits="userSpaceOnUse"
            >
                <Stop stopColor="#00854D" stopOpacity={0} />
                <Stop offset={0.493971} stopColor="#00854D" />
                <Stop offset={1} stopColor="#00854D" stopOpacity={0} />
            </LinearGradient>
            <LinearGradient
                id="paint2_linear_14530_54776"
                x1={20.5348}
                y1={12.3209}
                x2={-4.91308e-8}
                y2={12.3209}
                gradientUnits="userSpaceOnUse"
            >
                <Stop stopColor="#fff" />
                <Stop offset={1} stopColor="#fff" stopOpacity={0} />
            </LinearGradient>
            <LinearGradient
                id="paint3_linear_14530_54776"
                x1={27.3797}
                y1={16.4278}
                x2={-6.55078e-8}
                y2={16.4278}
                gradientUnits="userSpaceOnUse"
            >
                <Stop stopColor="#fff" />
                <Stop offset={1} stopColor="#fff" stopOpacity={0} />
            </LinearGradient>
            <LinearGradient
                id="paint4_linear_14530_54776"
                x1={34.2246}
                y1={20.5348}
                x2={-8.18847e-8}
                y2={20.5348}
                gradientUnits="userSpaceOnUse"
            >
                <Stop stopColor="#fff" />
                <Stop offset={1} stopColor="#fff" stopOpacity={0} />
            </LinearGradient>
            <ClipPath id="clip0_14530_54776">
                <Path fill="#fff" transform="translate(36 249)" d="M0 0H256V27H0z" />
            </ClipPath>
            <ClipPath id="clip1_14530_54776">
                <Rect x={68} y={231} width={192} height={41.0695} rx={8.2139} fill="#fff" />
            </ClipPath>
            <ClipPath id="clip2_14530_54776">
                <Path
                    fill="#fff"
                    transform="translate(76.214 239.214)"
                    d="M0 0H175.572V24.6417H0z"
                />
            </ClipPath>
            <ClipPath id="clip3_14530_54776">
                <Rect x={36} y={193.743} width={256} height={54.7594} rx={10.9519} fill="#fff" />
            </ClipPath>
            <ClipPath id="clip4_14530_54776">
                <Path
                    fill="#fff"
                    transform="translate(46.952 204.695)"
                    d="M0 0H234.096V32.8556H0z"
                />
            </ClipPath>
            <ClipPath id="clip5_14530_54776">
                <Rect x={4} y={149.251} width={320} height={68.4492} rx={13.6898} fill="#fff" />
            </ClipPath>
            <ClipPath id="clip6_14530_54776">
                <Path fill="#fff" transform="translate(17.69 162.941)" d="M0 0H292.62V41.0695H0z" />
            </ClipPath>
        </Defs>
    </Svg>
);
