import { Dimensions } from 'react-native';
import Svg, {
    G,
    Path,
    Rect,
    Circle,
    Defs,
    LinearGradient,
    Stop,
    ClipPath,
    SvgProps,
} from 'react-native-svg';

import { useNativeStyles } from '@trezor/styles';

const SVG_HEIGHT = Dimensions.get('screen').height * 0.35;

export const CoinsSvg = (props: SvgProps) => {
    const { utils } = useNativeStyles();

    return (
        <Svg width={253} height={SVG_HEIGHT} viewBox="0 0 253 276" fill="none" {...props}>
            <G clipPath="url(#clip0_14548_55032)">
                <G clipPath="url(#clip1_14548_55032)" fill="#CBCBCB">
                    <Path d="M104.459 175.741a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678zM115.168 175.741a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM133.016 175.741a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M104.459 179.31a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678zM115.168 179.31a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M118.738 179.31a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM147.294 179.31a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM104.459 182.88a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678z" />
                    <Path d="M108.029 182.88a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M111.598 182.88a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677zM125.877 182.88a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM133.016 182.88a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM108.029 186.45a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM115.168 186.45a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M118.738 186.45a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM125.877 186.45a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M129.446 186.45a1.84 1.84 0 100-3.678 1.84 1.84 0 000 3.678z" />
                    <Path d="M133.016 186.45a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M136.585 186.45a1.839 1.839 0 100-3.677 1.839 1.839 0 000 3.677zM111.598 190.019a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677z" />
                    <Path d="M115.168 190.019a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M118.738 190.019a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM133.016 190.019a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M136.585 190.019a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677zM143.725 190.019a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M147.294 190.019a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM104.459 193.589a1.84 1.84 0 100-3.678 1.84 1.84 0 000 3.678z" />
                    <Path d="M108.029 193.589a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM118.738 193.589a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM136.585 193.589a1.839 1.839 0 100-3.677 1.839 1.839 0 000 3.677zM104.459 197.158a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678zM111.598 197.158a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677z" />
                    <Path d="M118.738 197.158a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM125.877 197.158a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM133.016 197.158a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM140.155 197.158a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM147.294 197.158a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM104.459 200.728a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678z" />
                    <Path d="M108.029 200.728a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M111.598 200.728a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677z" />
                    <Path d="M115.168 200.728a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM125.877 200.728a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M129.446 200.728a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678z" />
                    <Path d="M133.016 200.728a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M136.585 200.728a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677z" />
                    <Path d="M140.155 200.728a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M143.725 200.728a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM83.042 204.298a1.84 1.84 0 10-.002-3.678 1.84 1.84 0 00.002 3.678z" />
                    <Path d="M86.611 204.298a1.84 1.84 0 10-.001-3.678 1.84 1.84 0 00.001 3.678z" />
                    <Path d="M90.18 204.298a1.84 1.84 0 100-3.678 1.84 1.84 0 000 3.678zM97.32 204.298a1.84 1.84 0 10-.001-3.678 1.84 1.84 0 00.001 3.678zM104.459 204.298a1.839 1.839 0 100-3.676 1.839 1.839 0 000 3.676z" />
                    <Path d="M108.029 204.298a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678z" />
                    <Path d="M111.598 204.298a1.84 1.84 0 100-3.678 1.84 1.84 0 000 3.678z" />
                    <Path d="M115.168 204.298a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678z" />
                    <Path d="M118.738 204.298a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678z" />
                    <Path d="M122.307 204.298a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678zM129.446 204.298a1.839 1.839 0 100-3.676 1.839 1.839 0 000 3.676zM150.864 204.298a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678z" />
                    <Path d="M154.433 204.298a1.839 1.839 0 100-3.676 1.839 1.839 0 000 3.676z" />
                    <Path d="M158.003 204.298a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678zM168.711 204.298a1.84 1.84 0 100-3.678 1.84 1.84 0 000 3.678z" />
                    <Path d="M172.281 204.298a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678z" />
                    <Path d="M175.851 204.298a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678zM83.042 207.867a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM100.89 207.867a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M104.459 207.867a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678z" />
                    <Path d="M108.029 207.867a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM118.738 207.867a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M122.307 207.867a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM129.446 207.867a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678zM140.155 207.867a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM147.294 207.867a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M150.864 207.867a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM158.003 207.867a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM175.851 207.867a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM75.903 211.437a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM83.042 211.437a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M86.611 211.437a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M90.18 211.437a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM97.32 211.437a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM108.029 211.437a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M111.598 211.437a1.839 1.839 0 100-3.677 1.839 1.839 0 000 3.677zM125.877 211.437a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M129.446 211.437a1.84 1.84 0 100-3.678 1.84 1.84 0 000 3.678z" />
                    <Path d="M133.016 211.437a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM140.155 211.437a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M143.725 211.437a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM150.864 211.437a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M154.433 211.437a1.84 1.84 0 100-3.678 1.84 1.84 0 000 3.678zM168.711 211.437a1.839 1.839 0 100-3.677 1.839 1.839 0 000 3.677zM83.042 215.006a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM100.89 215.006a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M104.459 215.006a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678zM111.598 215.006a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677zM118.738 215.006a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM129.446 215.006a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678zM136.585 215.006a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677zM143.725 215.006a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M147.294 215.006a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M150.864 215.006a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M154.433 215.006a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678z" />
                    <Path d="M158.003 215.006a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM172.281 215.006a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM75.903 218.576a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM83.042 218.576a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M86.611 218.576a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM93.75 218.576a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M97.32 218.576a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M100.89 218.576a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M104.459 218.576a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678z" />
                    <Path d="M108.029 218.576a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM115.168 218.576a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM140.155 218.576a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M143.725 218.576a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M147.294 218.576a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M150.864 218.576a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM158.003 218.576a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM168.711 218.576a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677z" />
                    <Path d="M172.281 218.576a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M175.851 218.576a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM75.903 222.145a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M79.472 222.145a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM86.611 222.145a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M90.18 222.145a1.838 1.838 0 10.001-3.677 1.838 1.838 0 000 3.677zM100.89 222.145a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM108.029 222.145a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M111.598 222.145a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677z" />
                    <Path d="M115.168 222.145a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM122.307 222.145a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM133.016 222.145a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM140.155 222.145a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M143.725 222.145a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M147.294 222.145a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M150.864 222.145a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M154.433 222.145a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678zM161.572 222.145a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677z" />
                    <Path d="M165.142 222.145a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM175.851 222.145a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM79.472 225.715a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM86.611 225.715a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M90.18 225.715a1.838 1.838 0 10.001-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M93.75 225.715a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M97.32 225.715a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM104.459 225.715a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678zM118.738 225.715a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M122.307 225.715a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M125.877 225.715a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM140.155 225.715a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM150.864 225.715a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM158.003 225.715a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM75.903 229.285a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM86.611 229.285a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M90.18 229.285a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM115.168 229.285a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M118.738 229.285a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM129.446 229.285a1.84 1.84 0 100-3.678 1.84 1.84 0 000 3.678zM136.585 229.285a1.839 1.839 0 100-3.677 1.839 1.839 0 000 3.677zM147.294 229.285a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM161.572 229.285a1.839 1.839 0 100-3.677 1.839 1.839 0 000 3.677z" />
                    <Path d="M165.142 229.285a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM175.851 229.285a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM75.903 232.854a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M79.472 232.854a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM97.32 232.854a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M100.89 232.854a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM108.029 232.854a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM118.738 232.854a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M122.307 232.854a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM129.446 232.854a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678zM140.155 232.854a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM147.294 232.854a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M150.864 232.854a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM161.572 232.854a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677z" />
                    <Path d="M165.142 232.854a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M168.711 232.854a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677zM175.851 232.854a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM75.903 236.424a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M79.472 236.424a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM86.611 236.424a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M90.18 236.424a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M93.75 236.424a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM100.89 236.424a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM111.598 236.424a1.839 1.839 0 100-3.677 1.839 1.839 0 000 3.677zM118.738 236.424a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M122.307 236.424a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM129.446 236.424a1.84 1.84 0 100-3.678 1.84 1.84 0 000 3.678zM140.155 236.424a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM161.572 236.424a1.839 1.839 0 100-3.677 1.839 1.839 0 000 3.677z" />
                    <Path d="M165.142 236.424a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M168.711 236.424a1.839 1.839 0 100-3.677 1.839 1.839 0 000 3.677z" />
                    <Path d="M172.281 236.424a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M175.851 236.424a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM75.903 239.993a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM83.042 239.993a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M86.611 239.993a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM93.75 239.993a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M97.32 239.993a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM122.307 239.993a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM133.016 239.993a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM140.155 239.993a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM147.294 239.993a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM154.433 239.993a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678z" />
                    <Path d="M158.003 239.993a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM168.711 239.993a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677zM75.903 243.563a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM108.029 243.563a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M111.598 243.563a1.839 1.839 0 100-3.677 1.839 1.839 0 000 3.677z" />
                    <Path d="M115.168 243.563a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM122.307 243.563a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M125.877 243.563a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM154.433 243.563a1.84 1.84 0 100-3.678 1.84 1.84 0 000 3.678z" />
                    <Path d="M158.003 243.563a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM165.142 243.563a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM75.903 247.132a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM86.611 247.132a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M90.18 247.132a1.838 1.838 0 10.001-3.677 1.838 1.838 0 000 3.677zM97.32 247.132a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM104.459 247.132a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678zM111.598 247.132a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677zM129.446 247.132a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678zM147.294 247.132a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M150.864 247.132a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M154.433 247.132a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678z" />
                    <Path d="M158.003 247.132a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M161.572 247.132a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677zM168.711 247.132a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677z" />
                    <Path d="M172.281 247.132a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM104.459 250.702a1.84 1.84 0 100-3.678 1.84 1.84 0 000 3.678z" />
                    <Path d="M108.029 250.702a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM118.738 250.702a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM125.877 250.702a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM143.725 250.702a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M147.294 250.702a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM161.572 250.702a1.839 1.839 0 100-3.677 1.839 1.839 0 000 3.677z" />
                    <Path d="M165.142 250.702a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM172.281 250.702a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M175.851 250.702a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM140.155 254.271a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M143.725 254.271a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M147.294 254.271a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM154.433 254.271a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678zM161.572 254.271a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677zM118.738 257.841a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M122.307 257.841a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM133.016 257.841a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M136.585 257.841a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677z" />
                    <Path d="M140.155 257.841a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M143.725 257.841a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M147.294 257.841a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM161.572 257.841a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677z" />
                    <Path d="M165.142 257.841a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM172.281 257.841a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M175.851 257.841a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM104.459 261.411a1.839 1.839 0 100-3.676 1.839 1.839 0 000 3.676z" />
                    <Path d="M108.029 261.411a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678zM115.168 261.411a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678z" />
                    <Path d="M118.738 261.411a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678zM125.877 261.411a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678zM133.016 261.411a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678zM140.155 261.411a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678zM147.294 261.411a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678z" />
                    <Path d="M150.864 261.411a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678z" />
                    <Path d="M154.433 261.411a1.839 1.839 0 100-3.676 1.839 1.839 0 000 3.676z" />
                    <Path d="M158.003 261.411a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678z" />
                    <Path d="M161.572 261.411a1.84 1.84 0 100-3.678 1.84 1.84 0 000 3.678z" />
                    <Path d="M165.142 261.411a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678z" />
                    <Path d="M168.711 261.411a1.84 1.84 0 100-3.678 1.84 1.84 0 000 3.678z" />
                    <Path d="M172.281 261.411a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678z" />
                    <Path d="M175.851 261.411a1.839 1.839 0 10-.002-3.678 1.839 1.839 0 00.002 3.678zM104.459 264.98a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678zM118.738 264.98a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM129.446 264.98a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678z" />
                    <Path d="M133.016 264.98a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M136.585 264.98a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677zM143.725 264.98a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M147.294 264.98a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M150.864 264.98a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM158.003 264.98a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM168.711 264.98a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677zM104.459 268.55a1.84 1.84 0 100-3.678 1.84 1.84 0 000 3.678zM111.598 268.55a1.839 1.839 0 100-3.677 1.839 1.839 0 000 3.677zM122.307 268.55a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M125.877 268.55a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM143.725 268.55a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M147.294 268.55a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M150.864 268.55a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M154.433 268.55a1.84 1.84 0 100-3.678 1.84 1.84 0 000 3.678z" />
                    <Path d="M158.003 268.55a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677z" />
                    <Path d="M161.572 268.55a1.839 1.839 0 100-3.677 1.839 1.839 0 000 3.677z" />
                    <Path d="M165.142 268.55a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM172.281 268.55a1.838 1.838 0 100-3.677 1.838 1.838 0 000 3.677zM111.598 272.119a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677zM118.738 272.119a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M122.307 272.119a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M125.877 272.119a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM136.585 272.119a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677z" />
                    <Path d="M140.155 272.119a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM154.433 272.119a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678zM161.572 272.119a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677z" />
                    <Path d="M165.142 272.119a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM172.281 272.119a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM115.168 275.689a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M118.738 275.689a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M122.307 275.689a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M125.877 275.689a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M129.446 275.689a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678z" />
                    <Path d="M133.016 275.689a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676zM143.725 275.689a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M147.294 275.689a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M150.864 275.689a1.838 1.838 0 100-3.676 1.838 1.838 0 000 3.676z" />
                    <Path d="M154.433 275.689a1.839 1.839 0 100-3.678 1.839 1.839 0 000 3.678zM161.572 275.689a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677zM168.711 275.689a1.838 1.838 0 10.001-3.677 1.838 1.838 0 00-.001 3.677zM74.064 184.558c0 6.96 5.533 12.493 12.494 12.493 6.96 0 12.493-5.533 12.493-12.493 0-6.961-5.532-12.494-12.493-12.494-6.96 0-12.494 5.533-12.494 12.494zm12.494 8.924c-4.998 0-8.924-3.927-8.924-8.924 0-4.998 3.926-8.924 8.924-8.924 4.997 0 8.924 3.926 8.924 8.924 0 4.997-3.927 8.924-8.924 8.924z" />
                    <Path d="M86.558 189.912a5.354 5.354 0 100-10.708 5.354 5.354 0 000 10.708zM152.595 184.558c0 6.96 5.533 12.493 12.493 12.493 6.961 0 12.494-5.533 12.494-12.493 0-6.961-5.533-12.494-12.494-12.494-6.96 0-12.493 5.533-12.493 12.494zm12.493 8.924c-4.997 0-8.923-3.927-8.923-8.924 0-4.998 3.926-8.924 8.923-8.924 4.998 0 8.924 3.926 8.924 8.924 0 4.997-3.926 8.924-8.924 8.924z" />
                    <Path d="M165.088 189.912a5.354 5.354 0 10.002-10.708 5.354 5.354 0 00-.002 10.708zM74.064 263.088c0 6.961 5.533 12.494 12.494 12.494 6.96 0 12.493-5.533 12.493-12.494 0-6.96-5.532-12.493-12.493-12.493-6.96 0-12.494 5.533-12.494 12.493zm12.494 8.924c-4.998 0-8.924-3.926-8.924-8.924 0-4.997 3.926-8.924 8.924-8.924 4.997 0 8.924 3.927 8.924 8.924 0 4.998-3.927 8.924-8.924 8.924z" />
                    <Path d="M86.558 268.443a5.355 5.355 0 10-.001-10.71 5.355 5.355 0 000 10.71z" />
                </G>
                <G filter="url(#filter0_d_14548_55032)">
                    <Rect
                        x={106}
                        y={204}
                        width={40}
                        height={40}
                        rx={20}
                        fill={utils.colors.backgroundSurfaceElevation1}
                    />
                    <Path
                        d="M126 218.107v11.786M121.179 225.071l4.821 4.822 4.821-4.822"
                        stroke="#0F6148"
                        strokeWidth={1.07143}
                        strokeLinecap="round"
                        strokeLinejoin="round"
                    />
                </G>
                <Path
                    d="M271.5-13.5c0 80.635-65.144 146-145.5 146S-19.5 67.135-19.5-13.5s65.144-146 145.5-146 145.5 65.365 145.5 146z"
                    stroke="url(#paint0_linear_14548_55032)"
                    strokeOpacity={0.3}
                />
                <Circle
                    cx={125.5}
                    cy={-13.5}
                    r={159}
                    stroke="url(#paint1_linear_14548_55032)"
                    strokeOpacity={0.15}
                />
                <Path
                    opacity={0.4}
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M74.233 64.18c-9.739-.041-18.43-4.524-24.151-11.527a27.897 27.897 0 01-14.536 9.96A23.769 23.769 0 0031.72 75.58c0 13.189 10.692 23.88 23.88 23.88 7.12 0 13.51-3.115 17.885-8.056a31.233 31.233 0 01-2.741-12.839 31.21 31.21 0 013.488-14.385zm3.634 2.752a26.758 26.758 0 00-2.642 11.633c0 2.948.475 5.785 1.352 8.44A23.773 23.773 0 0079.48 75.58c0-3.05-.571-5.967-1.614-8.648zm-22.623-15.23a26.78 26.78 0 0018.178 7.982c-4.373-4.9-10.737-7.984-17.82-7.984-.12 0-.24.001-.358.003zM45.765 19.996c-4.375-4.94-10.766-8.056-17.885-8.056C14.691 11.94 4 22.632 4 35.82 4 49.01 14.691 59.7 27.88 59.7c8.22 0 15.469-4.152 19.765-10.474a31.199 31.199 0 01-4.622-16.39c0-4.575.98-8.921 2.742-12.84zm3.09 4.4a26.84 26.84 0 00-1.352 8.44c0 4.167.95 8.113 2.643 11.633a23.821 23.821 0 001.614-8.649c0-4.138-1.053-8.03-2.905-11.424z"
                    fill={utils.colors.backgroundTertiaryDefaultOnElevation0}
                />
                <Path
                    d="M155.958 29.85c0 16.486-13.364 29.85-29.85 29.85s-29.85-13.364-29.85-29.85S109.622 0 126.108 0s29.85 13.364 29.85 29.85z"
                    fill={utils.colors.backgroundTertiaryDefaultOnElevation0}
                />
                <Path
                    opacity={0.6}
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M122.816 64.516c-9.493-.89-17.878-5.591-23.61-12.558-4.704 6.1-11.605 10.42-19.518 11.773a26.74 26.74 0 00-4.463 14.834c0 14.837 12.028 26.865 26.865 26.865 8.914 0 16.814-4.341 21.7-11.025a31.203 31.203 0 01-4.291-15.84c0-5.051 1.195-9.823 3.317-14.049zm3.651 2.743a26.77 26.77 0 00-2.488 11.306c0 4.039.892 7.87 2.488 11.306a26.77 26.77 0 002.488-11.306c0-4.038-.892-7.87-2.488-11.305zm-20.373-15.262a29.751 29.751 0 0014.633 7.219 26.787 26.787 0 00-14.633-7.22zm-20.128 5.078a26.87 26.87 0 004.526-2.75 26.855 26.855 0 00-4.526 2.75z"
                    fill={utils.colors.backgroundTertiaryDefaultOnElevation0}
                />
                <Path
                    opacity={0.6}
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M127.874 64.626a26.744 26.744 0 00-3.895 13.94c0 14.836 12.028 26.864 26.865 26.864 14.837 0 26.865-12.028 26.865-26.865a26.744 26.744 0 00-4.463-14.834c-7.963-1.361-14.9-5.726-19.606-11.887a27.924 27.924 0 00-.498-.047c-6.038 7.428-15.076 12.32-25.268 12.829zm4.522-5.59a29.762 29.762 0 0013.562-6.892 26.787 26.787 0 00-13.562 6.892zm30.045-4.71a26.883 26.883 0 004.528 2.75 26.85 26.85 0 00-4.528-2.75zM94.554 15.107C89.63 9.505 82.412 5.97 74.368 5.97c-14.837 0-26.865 12.028-26.865 26.865 0 14.837 12.028 26.865 26.865 26.865 9.157 0 17.244-4.581 22.094-11.577a34.657 34.657 0 01-5.174-18.273c0-5.27 1.17-10.266 3.266-14.743zm3.388 4.834a29.803 29.803 0 00-1.684 9.909c0 4.693 1.083 9.133 3.013 13.084a26.79 26.79 0 001.962-10.099c0-4.673-1.193-9.067-3.291-12.894z"
                    fill={utils.colors.backgroundTertiaryDefaultOnElevation0}
                />
                <Path
                    opacity={0.6}
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M156.093 47.562a34.656 34.656 0 004.835-17.712c0-5.056-1.078-9.86-3.016-14.196 4.928-5.917 12.351-9.684 20.654-9.684 14.837 0 26.865 12.028 26.865 26.865 0 14.837-12.028 26.865-26.865 26.865-9.4 0-17.672-4.827-22.473-12.139zm-2.754-5.468a29.737 29.737 0 002.619-12.244c0-3.164-.492-6.213-1.405-9.075a26.752 26.752 0 00-2.852 12.06c0 3.254.578 6.373 1.638 9.26z"
                    fill={utils.colors.backgroundTertiaryDefaultOnElevation0}
                />
                <Path
                    opacity={0.4}
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M205.289 49.226a31.2 31.2 0 004.622-16.39c0-4.576-.98-8.922-2.742-12.84 4.375-4.941 10.766-8.056 17.885-8.056 13.189 0 23.88 10.691 23.88 23.88 0 13.188-10.691 23.88-23.88 23.88-8.219 0-15.469-4.153-19.765-10.474zm-2.501-4.757a26.753 26.753 0 002.643-11.634 26.85 26.85 0 00-1.352-8.439 23.774 23.774 0 00-2.905 11.424c0 3.05.572 5.967 1.614 8.649zM202.852 52.653c-5.721 7.003-14.412 11.486-24.151 11.527a31.215 31.215 0 013.488 14.385c0 4.575-.98 8.92-2.741 12.84 4.375 4.94 10.766 8.055 17.884 8.055 13.189 0 23.88-10.691 23.88-23.88 0-4.78-1.405-9.234-3.824-12.968a27.896 27.896 0 01-14.536-9.96zm-25.143 25.912c0 2.948-.474 5.785-1.352 8.44a23.775 23.775 0 01-2.905-11.425c0-3.05.572-5.967 1.615-8.648a26.768 26.768 0 012.642 11.633zm1.803-18.881a26.779 26.779 0 0018.178-7.981 25.025 25.025 0 00-.358-.003c-7.083 0-13.447 3.085-17.82 7.984z"
                    fill={utils.colors.backgroundTertiaryDefaultOnElevation0}
                />
                <G opacity={0.4}>
                    <Path
                        d="M27.88 47.76c6.594 0 11.94-5.345 11.94-11.94 0-6.594-5.346-11.94-11.94-11.94-6.594 0-11.94 5.346-11.94 11.94 0 6.595 5.346 11.94 11.94 11.94z"
                        fill="#24292E"
                    />
                    <G clipPath="url(#clip2_14548_55032)" fill="#fff">
                        <Path d="M32.165 30.846h1.737l-3.614 3.578a3.378 3.378 0 01-4.74 0l-3.616-3.578h1.738l2.746 2.718a2.138 2.138 0 003.001 0l2.748-2.718zM23.648 40.795H21.91l3.637-3.6a3.377 3.377 0 014.74 0l3.638 3.6h-1.737l-2.769-2.74a2.138 2.138 0 00-3.001 0l-2.77 2.74z" />
                    </G>
                </G>
                <G opacity={0.6}>
                    <Path
                        d="M74.368 46.268c7.419 0 13.433-6.014 13.433-13.433 0-7.418-6.014-13.432-13.433-13.432-7.418 0-13.432 6.014-13.432 13.432 0 7.419 6.014 13.433 13.432 13.433z"
                        fill="#A6A8A9"
                    />
                    <Path
                        d="M83.883 32.274c0 5.563-4.51 10.073-10.075 10.073-5.564 0-10.074-4.51-10.074-10.073 0-5.563 4.51-10.073 10.074-10.073s10.075 4.51 10.075 10.073z"
                        fill="#fff"
                        stroke="#A6A8A9"
                        strokeWidth={1.11937}
                    />
                    <Path
                        d="M75.19 30.579l1.508-5.135h0l.002-.006a.861.861 0 00-.833-1.097m-.677 6.238l.677-6.238m-.677 6.238l.697-.212.995-.303-.295.997-.363 1.227-.086.293-.294.085-1.412.412-.807 2.72H78.794a.865.865 0 01.827 1.104L75.19 30.58zm.677-6.238h0v.56l-.001-.56h.001zm2.31 15.03a.967.967 0 00.93-.696s0 0 0 0l.514-1.772-6.97-11.862-2.058 6.956-1.404.427-.285.087-.087.283-.373 1.207-.312 1.008 1.01-.307.695-.212-1.233 4.163-.213.719h9.786zm0 0l.001-.559v.56h0zM68.212 23.9a10.076 10.076 0 0113.975 13.974 10.075 10.075 0 11-13.975-13.974z"
                        fill="#A6A8A9"
                        stroke="#A6A8A9"
                        strokeWidth={1.11937}
                    />
                </G>
                <Path
                    d="M126.108 44.775c8.243 0 14.925-6.682 14.925-14.925s-6.682-14.925-14.925-14.925-14.925 6.682-14.925 14.925 6.682 14.925 14.925 14.925z"
                    fill="#F29D40"
                />
                <Path
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M121.553 22.456l.01.003a.168.168 0 01-.035.025.147.147 0 01.025-.028zm.103.028l.032-.12-.125.095.093.025zm0 0c-.057.217-.114.441-.171.665-.067.266-.134.532-.202.786-.044.092 0 .138.09.138l.216.055c.302.076.627.157.951.269.404.139.629.554.539.924a327.228 327.228 0 01-1.706 7.116c-.045.324-.314.509-.673.416a7.675 7.675 0 01-.988-.23c-.134 0-.179 0-.224.138-.135.37-.314.785-.494 1.201a4.047 4.047 0 00-.112.255c-.034.08-.068.161-.112.254 1.077.277 2.109.554 3.142.832a.306.306 0 01-.028.124c-.009.022-.017.041-.017.06-.224.74-.404 1.525-.584 2.31-.044.093-.044.14.09.186.449.092.898.185 1.347.323.119.04.133.01.165-.061l.015-.031c.044-.208.101-.416.157-.624.056-.208.112-.416.157-.624.045-.208.101-.416.157-.624.056-.208.112-.416.157-.624.404.093.763.185 1.122.278.065.033.06.066.052.117-.003.02-.007.042-.007.068-.224.739-.404 1.525-.583 2.31-.045.093-.045.139.089.185.202.046.416.104.629.162.213.057.426.115.628.161.215.089.224.05.264-.115l.006-.023c.09-.37.179-.751.269-1.132.09-.382.18-.763.269-1.133.045-.138.135-.184.27-.138.898.138 1.795.23 2.738.092a2.768 2.768 0 001.841-1.016c.404-.509.628-1.063.808-1.71a3.733 3.733 0 00.09-1.571c-.18-.647-.539-1.156-1.078-1.572a3.714 3.714 0 00-.269-.184c-.09-.058-.18-.116-.269-.185.052 0 .089-.016.12-.03.022-.008.04-.016.059-.016.359-.139.718-.324.988-.601.359-.37.538-.832.673-1.34.18-.74.135-1.479-.269-2.172a3.87 3.87 0 00-1.167-1.11l-1.482-.692c-.135-.046-.179-.093-.135-.231a3.93 3.93 0 00.18-.694c.135-.554.269-1.109.404-1.71-.022 0-.034-.01-.045-.022-.011-.012-.022-.023-.045-.023-.212-.06-.417-.111-.617-.161-.263-.066-.519-.13-.774-.21-.09-.045-.135 0-.135.093l-.135.555a25.68 25.68 0 00-.449 1.756.545.545 0 00-.045.056c-.029.041-.059.082-.089.082-.18-.046-.371-.092-.561-.138-.191-.047-.382-.093-.562-.139.045-.092.045-.139.045-.185.09-.37.18-.75.27-1.132.089-.381.179-.762.269-1.132.045-.092.045-.139-.09-.185a13.388 13.388 0 01-1.302-.323c-.134-.047-.179 0-.224.138-.09.393-.18.774-.269 1.155h-.001c-.089.382-.179.763-.269 1.156-.045.138-.09.185-.224.138-.247-.069-.494-.127-.741-.184-.247-.058-.494-.116-.741-.185-.247-.07-.494-.127-.74-.185-.213-.05-.426-.1-.638-.157zm2.186 11.387c.045 0 .09.046.09.046l.341.09c.616.163 1.26.333 1.904.372.538.046 1.032.046 1.526-.138.853-.278 1.212-1.433.718-2.172-.224-.37-.583-.601-.942-.832-.785-.449-1.696-.636-2.57-.816l-.079-.016c-.123-.042-.134-.007-.169.104l-.011.035c-.045.23-.101.45-.157.67-.056.22-.112.439-.157.67-.102.368-.19.737-.28 1.114-.067.285-.136.575-.214.873zm4.265-4.806c-.18.046-.404.092-.494.092-.521 0-.971-.073-1.436-.148-.176-.029-.354-.058-.539-.083a6.76 6.76 0 01-.247-.07c-.079-.022-.157-.045-.247-.069-.09-.046-.135-.092-.09-.184.27-.97.494-1.895.718-2.865.045-.139.09-.185.225-.139.134.037.266.072.396.106.527.14 1.031.273 1.534.495.404.185.808.462 1.033.878.449.785 0 1.802-.853 1.987z"
                    fill="#fff"
                />
                <G opacity={0.6}>
                    <Path
                        d="M178.566 46.268c7.418 0 13.432-6.014 13.432-13.433 0-7.418-6.014-13.432-13.432-13.432-7.419 0-13.433 6.014-13.433 13.432 0 7.419 6.014 13.433 13.433 13.433z"
                        fill="#454A75"
                    />
                    <Path
                        d="M176.136 28.593l-2.469 4.2-.027.047.546.34a6977.118 6977.118 0 004.093 2.554l.305.19.288-.18a7857.858 7857.858 0 004.646-2.901c.004-.004-.314-.555-.708-1.223l-2.468-4.198a731.383 731.383 0 00-1.759-2.982c-.003 0-1.103 1.87-2.447 4.153z"
                        fill="#fff"
                    />
                    <Path
                        d="M173.651 33.845c0 .007 4.91 7.035 4.925 7.05.009.008.599-.829 2.479-3.52 1.357-1.942 2.466-3.531 2.465-3.533-.002-.002-1.111.689-2.467 1.535-1.355.846-2.47 1.535-2.477 1.533-.009-.004-4.235-2.638-4.888-3.047-.021-.013-.037-.021-.037-.018z"
                        fill="#fff"
                    />
                </G>
                <G opacity={0.4}>
                    <Path
                        d="M225.054 47.76c6.594 0 11.94-5.346 11.94-11.94 0-6.594-5.346-11.94-11.94-11.94-6.594 0-11.94 5.346-11.94 11.94 0 6.594 5.346 11.94 11.94 11.94z"
                        fill="#60C67E"
                    />
                    <Path
                        d="M220.967 34.898l4.106-1.73 3.98 1.775-3.986-6.286-4.1 6.241zm.012 1.92l4.1 2.376 4.182-2.375-4.144 5.768-4.138-5.768z"
                        fill="#fff"
                    />
                    <Path
                        d="M225.092 34.013l-4.277 1.8 4.277 2.376 4.157-2.325-4.157-1.851z"
                        fill="#fff"
                    />
                </G>
                <G opacity={0.4}>
                    <Circle cx={55.6007} cy={75.5801} r={11.94} fill="#3468D1" />
                    <G clipPath="url(#clip3_14548_55032)" fill="#fff">
                        <Path d="M59.584 75.523c.037.638-.465 1.185-1.117 1.222h-.07c-.658 0-1.188-.52-1.183-1.163 0-.643.53-1.162 1.187-1.157.629 0 1.15.482 1.182 1.098zM64.004 75.224a.377.377 0 01.403.354.378.378 0 01-.361.395.38.38 0 01-.404-.354.378.378 0 01.361-.395zM59.658 68.787a.375.375 0 01-.168-.505.39.39 0 01.516-.165.37.37 0 01.169.5.383.383 0 01-.517.17s.005 0 0 0zM58.457 70.841a.574.574 0 01-.262-.776.598.598 0 01.793-.258c.29.143.408.492.262.777a.598.598 0 01-.793.257zM62.502 72.252a.497.497 0 01-.676-.138.474.474 0 01.141-.662.497.497 0 01.676.138.47.47 0 01-.141.662zM61.784 75.017a.585.585 0 01.624.547.582.582 0 01-.558.611.585.585 0 01-.624-.547.585.585 0 01.558-.61zM62.436 78.909c.24.12.338.404.216.643a.494.494 0 01-.657.212.475.475 0 01-.216-.644.496.496 0 01.657-.211zM60.137 73.818a.7.7 0 01-.962-.197.668.668 0 01.202-.942.7.7 0 01.962.197.67.67 0 01-.202.942zM52.84 70.795a.603.603 0 01-.82-.165.576.576 0 01.169-.804.603.603 0 01.82.165.567.567 0 01-.168.804zM51.63 68.75a.386.386 0 01-.53-.11.368.368 0 01.113-.519.389.389 0 01.53.106.382.382 0 01-.113.523zM52.752 74.415c.652-.036 1.215.455 1.248 1.094a1.167 1.167 0 01-1.117 1.222h-.066c-.652 0-1.182-.519-1.182-1.162-.005-.611.488-1.121 1.117-1.154zM58.068 73.736a1.19 1.19 0 01-1.06.638c-.653 0-1.183-.519-1.183-1.162 0-.18.042-.359.127-.524a1.195 1.195 0 011.59-.515c.587.294.822.993.526 1.563zM48.782 72.251a.474.474 0 01-.211-.643.494.494 0 01.657-.207c.24.12.333.405.216.64a.501.501 0 01-.662.21zM51.785 72.619c.343.17.483.579.31.914a.703.703 0 01-.934.303.675.675 0 01-.31-.914.707.707 0 01.934-.303zM55.656 68.576a.49.49 0 01-.516-.45.485.485 0 01.46-.506.487.487 0 01.516.446.49.49 0 01-.46.51zM55.66 71.576a.686.686 0 01-.731-.643.682.682 0 01.657-.717.686.686 0 01.732.643.685.685 0 01-.657.717zM59.433 78.541a.675.675 0 01-.31-.914.703.703 0 01.934-.303c.343.17.484.579.31.914a.703.703 0 01-.934.303zM55.21 72.573a1.142 1.142 0 01-.342 1.604c-.55.349-1.281.202-1.638-.336a1.142 1.142 0 01.343-1.603 1.195 1.195 0 011.638.335zM53.15 77.425a1.194 1.194 0 011.591-.515c.587.29.821.988.526 1.558a1.195 1.195 0 01-1.591.514 1.144 1.144 0 01-.53-1.548c0-.005 0-.005.005-.01zM51.081 77.342a.7.7 0 01.962.198.668.668 0 01-.202.942.7.7 0 01-.962-.198.67.67 0 01.202-.942zM48.81 75.6a.582.582 0 01.559-.61.585.585 0 01.624.547.582.582 0 01-.559.61.591.591 0 01-.624-.546zM47.173 75.187a.377.377 0 01.403.354.378.378 0 01-.361.395.38.38 0 01-.404-.354.381.381 0 01.362-.395zM48.716 78.909a.497.497 0 01.676.138.475.475 0 01-.14.661.497.497 0 01-.676-.137.47.47 0 01.14-.662zM59.593 82.41a.39.39 0 01.53.106.371.371 0 01-.108.519.389.389 0 01-.53-.106.364.364 0 01.108-.519zM51.56 82.373a.375.375 0 01.169.506.39.39 0 01-.516.165.37.37 0 01-.17-.5.383.383 0 01.517-.17s-.005 0 0 0zM56.008 78.587a1.148 1.148 0 01.342-1.608 1.203 1.203 0 011.643.336 1.145 1.145 0 01-.343 1.608 1.195 1.195 0 01-.647.188 1.174 1.174 0 01-.995-.524zM58.378 80.365a.603.603 0 01.82.166.576.576 0 01-.168.804.603.603 0 01-.821-.166.568.568 0 01.169-.804zM55.614 82.585a.491.491 0 01.516.45.485.485 0 01-.46.505.487.487 0 01-.516-.445.49.49 0 01.46-.51zM55.61 79.584a.686.686 0 01.731.644.682.682 0 01-.657.716.689.689 0 01-.732-.643.685.685 0 01.657-.717zM52.761 80.32c.291.147.408.496.258.78a.599.599 0 01-.797.253.574.574 0 01-.263-.776.605.605 0 01.802-.257z" />
                    </G>
                </G>
                <G opacity={0.6}>
                    <Path
                        d="M102.09 91.998c7.418 0 13.432-6.014 13.432-13.433 0-7.418-6.014-13.432-13.432-13.432-7.419 0-13.433 6.014-13.433 13.432 0 7.419 6.014 13.433 13.433 13.433z"
                        fill="#E0AB3C"
                    />
                    <Path
                        d="M106.424 74.681v-1.88h-3.37V70.73h-2.072V72.8h-3.37v2.494h5.223l-5.223 7.091v1.88h3.37v2.066h2.072v-2.066h3.37v-2.493h-5.228l5.228-7.092z"
                        fill="#fff"
                    />
                </G>
                <G opacity={0.6} clipPath="url(#clip4_14548_55032)">
                    <Path
                        d="M150.844 91.998c7.419 0 13.433-6.014 13.433-13.433 0-7.418-6.014-13.432-13.433-13.432-7.418 0-13.432 6.014-13.432 13.432 0 7.419 6.014 13.433 13.432 13.433z"
                        fill="#F5AC37"
                    />
                    <Path
                        d="M151.031 79.411h4.555c.097 0 .143 0 .15-.127.037-.464.037-.93 0-1.393 0-.09-.045-.128-.143-.128h-9.064c-.112 0-.142.038-.142.143v1.333c0 .172 0 .172.179.172h4.465zm4.196-3.206a.145.145 0 000-.105 2.934 2.934 0 00-.271-.471 3.816 3.816 0 00-.554-.697 1.83 1.83 0 00-.345-.338 5.383 5.383 0 00-2.247-1.138 5.59 5.59 0 00-1.274-.135h-4.023c-.112 0-.127.045-.127.142v2.66c0 .112 0 .142.143.142h8.644s.075-.015.09-.06h-.036zm0 4.764a1.752 1.752 0 00-.383 0h-8.307c-.113 0-.15 0-.15.15v2.6c0 .12 0 .15.15.15h3.835c.184.014.367.001.547-.037a5.71 5.71 0 001.626-.36c.19-.066.373-.151.546-.254h.053a4.87 4.87 0 002.09-2.105s.052-.113-.007-.142v-.002zm-10.346 4.248v-4.142c0-.098 0-.113-.119-.113h-1.626c-.09 0-.127 0-.127-.12V79.42h1.737c.098 0 .135 0 .135-.127v-1.408c0-.09 0-.113-.119-.113h-1.626c-.09 0-.127 0-.127-.12v-1.317c0-.083 0-.105.119-.105h1.611c.112 0 .142 0 .142-.143V72.05c0-.12 0-.15.15-.15h5.618c.408.016.813.06 1.214.135a7.327 7.327 0 012.345.868c.481.284.924.626 1.318 1.02.297.307.564.64.802.996.235.36.431.744.585 1.146a.195.195 0 00.224.157h1.34c.173 0 .173 0 .18.165v1.229c0 .12-.045.15-.165.15h-1.034c-.105 0-.135 0-.127.135.041.456.041.914 0 1.37 0 .128 0 .143.143.143h1.183c.052.067 0 .135 0 .203.007.086.007.174 0 .261v.907c0 .127-.038.165-.15.165h-1.416a.188.188 0 00-.218.142 5.987 5.987 0 01-1.573 2.293c-.255.229-.522.445-.802.644-.299.172-.591.352-.899.494a8.084 8.084 0 01-1.768.562 9.209 9.209 0 01-1.753.142h-5.199v-.007l.002-.002z"
                        fill="#FEFEFD"
                    />
                </G>
                <G opacity={0.4} clipPath="url(#clip5_14548_55032)">
                    <Path
                        d="M197.332 87.52c6.595 0 11.94-5.346 11.94-11.94 0-6.594-5.345-11.94-11.94-11.94-6.594 0-11.94 5.346-11.94 11.94 0 6.594 5.346 11.94 11.94 11.94z"
                        fill="#53AE94"
                    />
                    <Path
                        d="M198.748 73.918v-1.707h3.904v-2.6h-10.63v2.6h3.904v1.706c-3.173.146-5.559.774-5.559 1.527 0 .753 2.387 1.381 5.559 1.528v5.468h2.823V76.97c3.167-.146 5.548-.774 5.548-1.526s-2.381-1.38-5.548-1.526m0 2.59v-.002c-.08.005-.489.03-1.4.03-.728 0-1.241-.021-1.422-.03v.001c-2.803-.124-4.895-.612-4.895-1.196s2.092-1.072 4.895-1.196v1.906c.184.013.709.044 1.434.044.871 0 1.308-.037 1.389-.044v-1.906c2.797.125 4.885.613 4.885 1.195 0 .582-2.089 1.071-4.885 1.196"
                        fill="#fff"
                    />
                </G>
            </G>
            <Defs>
                <LinearGradient
                    id="paint0_linear_14548_55032"
                    x1={126.466}
                    y1={133}
                    x2={126.466}
                    y2={123.493}
                    gradientUnits="userSpaceOnUse"
                >
                    <Stop stopColor="#00854D" />
                    <Stop offset={1} stopColor="#00854D" stopOpacity={0} />
                </LinearGradient>
                <LinearGradient
                    id="paint1_linear_14548_55032"
                    x1={126.01}
                    y1={146}
                    x2={126.01}
                    y2={112.516}
                    gradientUnits="userSpaceOnUse"
                >
                    <Stop stopColor="#00854D" />
                    <Stop offset={1} stopColor="#00854D" stopOpacity={0} />
                </LinearGradient>
                <ClipPath id="clip0_14548_55032">
                    <Path fill={utils.colors.backgroundSurfaceElevation1} d="M0 0H253V276H0z" />
                </ClipPath>
                <ClipPath id="clip1_14548_55032">
                    <Path
                        fill={utils.colors.backgroundSurfaceElevation1}
                        transform="translate(74 172)"
                        d="M0 0H104V104H0z"
                    />
                </ClipPath>
                <ClipPath id="clip2_14548_55032">
                    <Path
                        fill={utils.colors.backgroundSurfaceElevation1}
                        transform="translate(21.91 30.846)"
                        d="M0 0H12.015V9.94996H0z"
                    />
                </ClipPath>
                <ClipPath id="clip3_14548_55032">
                    <Path
                        fill={utils.colors.backgroundSurfaceElevation1}
                        transform="matrix(-1 0 0 1 64.407 67.62)"
                        d="M0 0H17.5957V15.9199H0z"
                    />
                </ClipPath>
                <ClipPath id="clip4_14548_55032">
                    <Path
                        fill={utils.colors.backgroundSurfaceElevation1}
                        transform="translate(137.412 65.133)"
                        d="M0 0H26.8649V26.8649H0z"
                    />
                </ClipPath>
                <ClipPath id="clip5_14548_55032">
                    <Path
                        fill={utils.colors.backgroundSurfaceElevation1}
                        transform="translate(185.392 63.64)"
                        d="M0 0H23.8799V23.8799H0z"
                    />
                </ClipPath>
            </Defs>
        </Svg>
    );
};
