import * as React from 'react';
import Svg, { G, Path, Defs, ClipPath, SvgProps } from 'react-native-svg';

import { useActiveColorScheme } from '@suite-native/theme';

export const DisconnectedTrezorSvg = (props: SvgProps) => {
    const colorScheme = useActiveColorScheme();
    const lineColor = colorScheme === 'dark' ? '#74DCB1' : '#0F6148';
    const fillColor = colorScheme === 'dark' ? '#092519' : '#F0F9F6';

    return (
        <Svg fill="none" viewBox="0 0 710 684" {...props}>
            <G clipPath="url(#a)">
                <Path
                    d="M47.316 98.616l9.63 72.131L76.155 288.9l46.002 236.56 16.365 63.916s22.922 49.912 76.51 36.262c53.587-13.65 112.3-31.113 112.3-31.113l77.626-33.668s38.072-17.315 29.628-62.54c-8.444-45.225-22.655-117.749-22.655-117.749l-28.068-143.369-30.645-151.28-12.691-46.679S325.505-.334 278.11 3.174c-47.405 3.509-141.781 14.171-141.781 14.171L93.22 26.917S65.587 40.734 58.93 53.696c-6.656 12.962-11.594 31.565-11.614 44.92zm434.418 277.296l-7.329 12.126-.144 10.114 3.61 5.516 5.281-.154 12.141-11.535-13.559-16.067z"
                    fill={fillColor}
                />
                <Path
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M614.017 590.5c9.791-6.452 21.864-18.647 19.484-30.5-2.116-10.537-10.134-16.94-19.484-23.067-6.266-4.106-12.541-8.201-18.816-12.296-5.432-3.546-10.864-7.091-16.291-10.643 11.202-1.328 21.339-5.597 26.508-14.945 12.715-22.989-10.254-50.411-35.968-56.139-12.586-2.805-27.725-.895-36.236 7.995-8.995 9.397-6.598 23.661 1.035 33.88 7.654 10.259 19.581 17.665 30.975 24.739.833.517 1.663 1.033 2.489 1.548-21.128-.541-40.527-9.455-57.37-21.834-22.79-16.74-46.44-42.123-42.459-69.745.944-6.563 3.605-12.55 7.837-17.794 1.507-1.867-2.226-4.444-3.791-2.59-8.679 10.256-11.4 23.381-8.632 36.446 2.793 13.18 10.829 25.014 20.339 35.401 9.931 10.85 21.852 20.294 34.756 28.118 9.867 5.98 19.935 10.633 31.387 13.1 7.048 1.521 15.236 2.516 23.234 2.256a8247.97 8247.97 0 0122.503 14.647l1.827 1.192c1.574 1.026 3.17 2.038 4.768 3.052 5.525 3.505 11.09 7.035 15.944 11.257 10.412 9.06 15.173 19.011 7.445 30.327-8.469 12.401-25.382 18.086-39.879 22.959l-.121.041c-2.323.78-4.656 1.547-7.001 2.299-.521.167-.385.822-.248 1.477.13.624.259 1.247-.18 1.448a.423.423 0 00-.071.027.655.655 0 00.071-.027c.353-.097.257.576.158 1.269-.11.768-.223 1.561.27 1.351 3.238-1.374 6.858-2.682 10.633-4.047 8.355-3.021 17.469-6.316 24.884-11.202zm-50.353-86.444c-12.197-7.835-25.605-16.448-30.526-29.43-2.671-7.038-2.492-14.952 2.692-20.651 4.633-5.092 12.028-7.649 19.305-8.25 13.364-1.1 27.159 4.291 36.772 13.109 11.007 10.104 16.841 26.364 9.708 38.975-4.898 8.654-15.551 12.284-25.938 13.064l-7.131-3.656a544.309 544.309 0 00-4.882-3.161z"
                    fill={lineColor}
                />
                <Path
                    d="M156.437 16.284c24.117-2.614 48.254-5.071 72.381-7.547 16.533-1.7 33.164-3.627 49.795-3.371 15.506.236 30.438 3.36 43.188 12.54 14.854 10.691 20.829 30.06 24.671 47.052 8.355 36.891 15.782 74.008 23.189 111.116 13.342 66.903 26.428 133.846 39.573 200.789 5.738 29.246 11.456 58.501 17.224 87.747 3.486 17.679 8.612 34.788 4.741 52.831-3.872 18.042-14.024 31.771-28.503 41.677-9.244 6.329-19.564 9.788-30.013 13.62-24.769 9.09-49.815 17.453-74.555 26.612-2.251.836-5.234 1.415-5.471 4.275-.326 3.843 4.258 2.712 4.931 2.172 0 0 0-.104.303 0 .287 0 .889-.413 1.176-.541 1.224-.55 3.229-1.307 4.76-1.916a528.049 528.049 0 0116.276-6.044c14.488-5.139 28.996-10.21 43.474-15.379 10.36-3.705 20.957-7.144 31.031-11.606 15.229-6.741 28.749-19.379 36.176-34.238 5.669-11.341 8.227-24.165 7.624-36.803-.326-6.879-1.936-13.542-3.289-20.263a23109.21 23109.21 0 01-16.275-81.998c-13.491-68.486-26.873-136.991-40.492-205.457-5.126-25.757-10.252-51.514-15.585-77.232-2.617-12.648-5.906-25.197-8.365-37.864-3.17-16.343-6.686-33.177-15.515-47.574-8.019-13.08-21.214-22.052-36.028-25.963-19.011-5.012-39.899-2.526-59.108-.285-15.881 1.847-31.762 3.92-47.593 6.142a4539.154 4539.154 0 00-39.939 5.788c-.968.147-.75 1.828.237 1.72h-.019zm-7.545-1.239c-14.103-1.258-28.71 1.337-42.131 5.7-13.422 4.363-25.56 11.488-33.45 23.241-19.486 29.02-11.042 64.87-6.716 96.778 6.113 45.117 13.816 89.959 23.436 134.466 9.56 44.271 18.764 88.661 27.346 133.138 4.82 24.981 9.728 49.923 14.963 74.825 5.234 24.902 9.737 50.285 16.364 74.932.455 1.69 2.874.953 2.588-.708-3.704-21.472-8.652-42.728-12.513-64.181-3.862-21.453-7.536-43.279-11.447-64.889-7.812-43.131-15.149-86.312-24.275-129.188-9.106-42.797-18.27-85.555-25.698-128.687-3.634-21.079-6.784-42.227-9.856-63.395-2.034-14.053-2.459-27.359 1.64-41.166 2.805-9.434 6.488-18.908 13.727-25.855 5.807-5.582 13.126-9.503 20.582-12.471 14.706-5.847 30.527-6.81 45.627-11.095.84-.236.613-1.376-.197-1.445h.01zm1.135 549.085c4.217 24.764 20.305 49.303 44.66 58.54 27.208 10.319 57.785-2.869 83.66-11.154 2.508-.806 1.422-4.157-1.057-3.822-12.819 1.749-25.352 5.149-37.973 7.891-12.898 2.8-27.021 4.864-39.969 1.238-24.018-6.732-40.511-30.641-46.644-53.44-.474-1.75-2.973-.983-2.677.737v.01z"
                    fill={lineColor}
                />
                <Path
                    d="M377.355 252.677c11.693 60.486 23.554 120.943 35.396 181.4 3.525 17.993 7.397 35.957 10.597 54.01 2.597 14.691.553 30.611-6.479 43.829-14.765 27.722-47.415 35.84-75.275 44.399-.919.285-.524 1.73.395 1.435 24.532-7.911 52.886-14.485 69.774-35.525 10.775-13.434 15.179-30.809 13.826-47.8-1.185-14.898-5.402-29.796-8.276-44.419-5.471-27.889-10.962-55.789-16.424-83.678a49956.407 49956.407 0 01-22.191-114.005c-.168-.865-1.501-.501-1.333.363l-.01-.009zM165.286 26.131a5138.207 5138.207 0 0175.67-8.972c20.127-2.231 42.951-5.582 62.535 1.454 8.997 3.233 17.58 8.766 23.486 16.313C333.919 43.8 337.89 54.7 340.773 65.45c2.884 10.752 5.146 22.407 7.299 33.61 3.93 20.45 7.357 40.989 11.298 61.439.168.865 1.501.501 1.333-.364-5.925-30.68-10.31-61.93-17.895-92.277-4.978-19.93-13.599-38.434-32.848-47.956-19.732-9.769-43.642-6.712-64.708-4.413-26.725 2.919-53.4 6.535-80.026 10.21-.237.03-.187.462.06.433zm-8.444.294c-23.535.826-53.943 5.936-68.49 26.543-8.326 11.803-12.247 28.293-12.158 42.581.099 14.23 3.052 28.725 4.997 42.778 5.758 41.589 13.076 82.942 21.777 124.019 6.084 28.725 12.444 57.273 16.839 86.322 4.345 28.774 9.323 57.411 15.969 85.752.099.423.731.246.652-.177-5.185-25.501-10.321-50.914-13.925-76.691-3.319-23.742-7.457-47.298-12.335-70.775-8.188-39.407-16.286-78.746-22.735-118.487-3.072-18.907-5.64-37.874-8.336-56.84-1.935-13.66-2.054-26.534 2.183-39.86 2.785-8.775 6.39-17.275 13.106-23.781 5.639-5.464 12.671-9.267 19.979-12.058 13.688-5.218 28.157-6.751 42.526-8.972.208-.03.158-.374-.049-.364v.01zm6.054 526.079c4.405 22.023 18.725 44.389 40.689 52.595 24.839 9.287 52.699-3.498 76.698-9.689.622-.158.355-1.081-.267-.954-23.367 4.875-49.114 16.844-73.201 9.877-22.972-6.653-38.26-29.973-43.248-52.006-.098-.432-.76-.246-.671.187v-.01zM45.352 105.505c16.344 122.152 40.422 242.918 64.174 363.802 6.706 34.13 12.987 68.417 20.7 102.34.494 2.172 3.605 1.199 3.279-.904-4.641-30.602-10.863-61.007-16.858-91.373-6.005-30.435-12.108-60.85-18.123-91.285-11.98-60.525-23.85-121.061-34.823-181.773-6.074-33.609-12.206-67.198-17.52-100.935-.069-.452-.879-.354-.82.108l-.01.02z"
                    fill={lineColor}
                />
                <Path
                    d="M102.899 23.9c-12.75 4.01-25.204 8.795-35.584 17.482-11.1 9.287-17.6 22.377-20.236 36.42-2.983 15.9-1.718 32.282.07 48.242 1.787 15.959 4.483 33.697 8.927 49.872.375 1.366 2.282.757 2.074-.569-2.41-15.812-4.938-31.457-6.291-47.426-1.294-15.262-2.775-31.153-.385-46.375 2.133-13.59 7.634-26.494 17.994-35.879 9.797-8.884 22.221-14.74 33.756-21.03.415-.226.129-.904-.325-.757v.02zm23.742 520.221c1.116 8.54 1.462 16.873 3.368 25.335 1.738 7.704 4.059 15.409 7.486 22.553 6.044 12.589 15.397 24.254 27.86 30.995 21.639 11.704 50.664 6.388 72.945-.629 1.698-.531.997-3.135-.741-2.663-11.367 3.056-23.1 3.43-34.813 3.685-11.713.256-23.456.039-33.658-5.267-11.95-6.221-20.651-17.208-26.379-29.148-3.496-7.291-6.143-14.819-8.404-22.563-2.262-7.744-4.701-14.937-6.518-22.445-.149-.629-1.245-.511-1.156.157l.01-.01z"
                    fill={lineColor}
                />
                <Path
                    d="M186.974 624.93a3191.356 3191.356 0 00-3.19-12.991c-.198-.796-1.304-.708-1.541 0-1.185 3.498-2.36 6.997-3.546 10.495h1.59a3949.097 3949.097 0 00-5.777-15.173c-.286-.757-1.373-.835-1.63 0-1.461 4.855-2.933 9.709-4.394 14.564h1.659a1826.438 1826.438 0 00-3.803-24.342c-.108-.698-1.125-.59-1.303 0-1.669 5.415-3.467 10.78-5.235 16.166l1.324.177c-.948-8.187-1.886-16.373-2.835-24.559-.098-.815-1.254-1.09-1.52-.206-1.531 5.149-4.938 8.982-9.946 11.016l1.027 1.022 6.163-23.143c.277-1.032-1.333-1.474-1.61-.442l-6.162 23.143c-.148.55.414 1.278 1.027 1.022 5.53-2.29 9.333-6.476 10.982-12.215l-1.521-.206 3.022 24.558c.089.727 1.086.943 1.324.177 1.728-5.396 3.417-10.8 5.234-16.166h-1.304a1836.481 1836.481 0 003.457 24.44c.128.885 1.432.737 1.659 0 1.452-4.855 2.913-9.719 4.365-14.574h-1.629c1.935 5.052 3.871 10.113 5.817 15.164.286.747 1.323.806 1.59 0 1.165-3.499 2.33-7.007 3.496-10.506h-1.541c1.274 4.275 2.578 8.54 3.862 12.805.168.551 1.007.325.869-.236l.02.01zM69.508 48.477c-10.685 12.068-16.77 26.838-18.813 42.729-.168 1.346 1.797 1.641 2.41.648 3.663-5.915 7.337-11.822 11.001-17.738l-2.31-.972c-4.92 14.249-9.837 28.498-14.765 42.748-.376 1.1 1.234 2.063 2.004 1.159a3545.96 3545.96 0 0016.81-19.959l-1.68-1.287c-9.007 18.308-14.32 38.916-11.782 59.386.148 1.159 1.896 1.238 1.877 0-.385-20.225 2.4-40.115 11.752-58.315.524-1.012-.84-2.25-1.679-1.287a3580.289 3580.289 0 00-16.996 19.782l2.005 1.16c4.957-14.24 9.925-28.47 14.893-42.71.484-1.385-1.58-2.142-2.311-.972-3.684 5.906-7.368 11.802-11.052 17.708l2.41.649c2.005-15.272 8.177-29.53 17.036-42.1.336-.481-.424-1.07-.82-.629h.01zm-.406 138.141c5.422 31.703 10.736 63.425 16.355 95.088 2.785 15.665 5.56 31.329 8.345 46.994 2.785 15.664 5.096 32.115 8.82 47.868.227.943 1.866.766 1.738-.236-1.926-15.517-5.284-30.926-8.069-46.306-2.894-15.969-5.797-31.938-8.69-47.907-5.788-31.919-11.892-63.788-17.886-95.678-.08-.403-.682-.226-.613.167v.01zm36.364 199.483c4.85 28.577 9.323 57.223 14.795 85.693.296 1.562 2.666.894 2.39-.659-4.988-28.499-10.963-56.82-16.572-85.211-.079-.403-.682-.226-.613.167v.01zm69.578-333.329c-1.018-3.35-2.45-5.67-5.956-6.898-3.111-1.081-6.409-.472-8.967 1.552-5.768 4.56-5.086 13.277 1.185 17.011 6.271 3.734 14.775-.334 16.059-7.577.582-3.262-.524-7.154-3.664-8.766-2.776-1.424-6.173-.638-7.319 2.31-.622 1.602 1.353 2.506 2.578 1.975 5.452-2.348 4.711 5.209 2.074 7.675-3.012 2.83-7.832 2.113-10.064-1.336-1.856-2.86-.74-6.761 2.025-8.609 3.16-2.103 8.651-.452 10.103 3.174.464 1.16 2.311.727 1.926-.53l.02.02zm18.221.973c5.077.669 10.419-.471 15.486-1.031l13.55-1.494c9.688-1.062 19.357-2.211 29.035-3.332 3.023-.353 3.062-5.12 0-4.766-10.685 1.239-21.371 2.477-32.057 3.725-5.185.6-10.36 1.199-15.545 1.808-5.185.61-10.202.796-14.972 2.702-1.176.472-1.63 2.614 0 2.86 9.757 1.445 20.769-1.395 30.507-2.535l32.058-3.774v-4.766c-10.005 1.18-20.009 2.339-30.004 3.577l-14.518 1.798c-4.612.57-9.57.737-13.935 2.398-1.59.61-1.244 2.624.385 2.84l.01-.01z"
                    fill={lineColor}
                />
                <Path
                    d="M169.552 54.521c1.679-2.005 1.966-4.884-.642-6.29-2.824-1.522-5.5.6-6.735 3.077-1.442 2.899-2.607 6.869-.454 9.7 2.153 2.83 5.708 2.102 7.94-.1 2.341-2.309 4.543-5.994 3.674-9.384-.869-3.39-4.148-4.825-7.328-3.754-5.452 1.847-10.982 12.323-2.864 14.534 3.318.904 6.449-.904 8.483-3.42 2.035-2.515 4.336-6.063 2.736-9.237-1.511-2.987-5.086-3.056-7.17-.658-2.084 2.397-3.684 7.272-2.805 10.338.978 3.4 5.077 3.272 7.052.904 1.975-2.369 2.617-6.427.108-8.609-5.738-4.992-12.552 8.226-6.567 10.496 3.516 1.336 6.854-3.46 7.298-6.437.494-3.361-2.498-6.437-5.886-4.914-3.387 1.523-3.15 6.044-.059 7.675 3.861 2.035 7.15-1.946 7.051-5.513-.049-1.66-2.143-2.633-3.358-1.385-1.471 1.513-2.854 3.813-1.441 5.867 1.155 1.68 3.229 1.68 4.671.422 1.58-1.395-.435-3.44-2.094-2.702.721.01 1.274-.256 1.65-.816l-3.358-1.386c.197.639.049 1.16-.445 1.563-.286.639-.444.727-.484.285-.098-.482-.108-.325-.039.471l-.316.826c-.296.717-1.659 3.017-1.333 1.032.187-1.13 1.59-3.911 2.478-2.113.524 1.061-1.086 4.5-1.382 2.083-.148-1.179.582-2.84 1.007-3.92.099-.256 1.304-3.558 2.38-1.308.227.472-.454 1.7-.661 2.103-1.097 2.123-3.023 5.16-5.768 5.1-4.375-.098-1.61-5.011.069-6.584 1.106-1.041 3.091-2.535 4.523-1.13 1.057 1.042.672 2.732.119 3.941-.553 1.209-1.482 2.771-2.519 3.616-2.706 2.202-3.762-1.09-3.308-3.223.247-1.17.652-2.437 1.254-3.479.356-.619.889-1.385 1.64-1.592 1.827-.52 3.674 1.651 2.409 3.558-.187.275.247.619.465.353l.009.01z"
                    fill={lineColor}
                />
                <Path
                    d="M163.913 47.2c3.19.325 6.775-.245 9.096 2.555 1.867 2.241 1.037 4.433.573 6.938-.217 1.14 1.047 1.917 1.946 1.12 2.637-2.318 1.629-7.153-.474-9.463-2.548-2.81-8.039-4.01-11.378-2.054-.444.266-.207.855.247.904h-.01zM4.997 111.99a82.895 82.895 0 012.568-33.638 77.55 77.55 0 016.262-15.4c2.37-4.392 7.298-9.109 8.226-13.964.336-1.759-1.284-2.879-2.854-2.181-4.74 2.073-7.792 9.08-10.034 13.443a85.203 85.203 0 00-6.498 16.766C-.464 88.63-.75 100.678 1.363 112.492c.365 2.014 3.901 1.572 3.634-.492v-.01zM75.878 11.872c-19.92 11.802-35.563 30.032-44.521 51.297-9.728 23.104-13.076 53.067-3.447 76.78 1.057 2.605 4.85 1.671 4.286-1.179-2.478-12.579-4.82-24.774-4.197-37.677.583-12.166 3.21-24.293 7.842-35.575 8.483-20.696 23.208-38.326 41.44-51.268 1.432-1.012.167-3.312-1.403-2.388v.01zM681.35 132.008c.235.614.541 1.114.876 1.675.425.695.972 1.141 1.611 1.636 1.695 1.327 3.582-1.213 1.757-2.363-.691-.429-1.309-.832-2.119-.986-.652-.125-1.231-.257-1.911-.267-.148-.001-.276.168-.222.303l.008.002zm-202.362 244.74c-2.482 4.334-6.976 7.994-8.035 13.049-.938 4.45 1.218 8.151 3.92 11.515 3.6 4.479 5.399 3.874 10.114.92 2.622-1.647 5.097-3.513 7.575-5.361 1.87-1.396 3.445-2.299 3.402-4.771-.009-.393-.297-.716-.665-.823-3.273-.946-5.751 2.258-8.141 4.136-1.363 1.076-2.732 2.134-4.01 3.291-1.109.999-1.543 1.668-3.122 1.978-2.122.421-2.222-.246-3.616-2.196-5.739-8.036 2.523-13.455 4.353-21.062.254-1.042-1.23-1.622-1.763-.691l-.012.015zm166.694 182.748c4.679 9.23.371 22.085-3.438 30.887-4.356 10.043-11.123 18.897-18.635 26.795-1.165 1.229.478 3.483 1.923 2.4 10.096-7.563 17.182-17.87 21.714-29.566 3.99-10.297 6.113-21.502-.959-30.881-.278-.364-.819-.044-.615.372l.01-.007zM534.279 439.882c-10.172-2.796-16.81 7.464-17.71 16.272-.151 1.441 2.073 1.819 2.681.654 3.295-6.266 6.134-15.036 14.803-14.816 1.242.033 1.357-1.799.218-2.112l.008.002z"
                    fill={lineColor}
                />
                <Path
                    d="M463.022 333.292l-1.564 25.148s2.044 8.103 10.43 13.944l26.412 17.898s9.757 3.23 14.664 4.404c4.906 1.173 20.039.212 20.039.212s5.786-1.516 12.688-7.966c6.902-6.45 35.936-38.346 35.936-38.346l31.091-37.871s15.327-18.482 23.605-42.614c8.279-24.144 40.786-115.009 40.786-115.009l18.058-50.678s5.327-12.996 4.966-16.45c-.362-3.454-2.674-5.256-2.674-5.256l-24.843-23.442s-21.362-3.253-33.256-3.933c-11.893-.691-74.391-4.103-74.391-4.103s-17.94-2.73-26.883 10.193c0 0-5.525 8.063-14.033 34.523s-43.974 118.841-43.974 118.841-8.692 16.63-10.646 47.029l-6.414 73.512.003-.036z"
                    fill={fillColor}
                />
                <Path
                    d="M507.348 392.578s6.324 1.405 21.109-19.17c14.785-20.575 49.529-59.528 49.529-59.528l17.57-26.279s9.855-17.064 15.636-35.368L674.35 80.241s2.71-7.33.346-15.24-6.247-6.546-6.247-6.546l3.196-4.34s4.42.077 7.176 3.457c2.756 3.38 14.725 15.623 14.725 15.623l8.504 8.274-.079 8.004s-3.713 16.47-9.294 27.664c-5.581 11.195-38.489 107.287-38.5 107.286-.012-.001-17.09 50.337-17.09 50.337s-6.412 16.678-13.306 25.258c-6.894 8.58-44.776 56.019-44.776 56.019s-24.988 30.199-33.507 34.914c0 0-6.724 7.751-12.975 7.629-6.25-.135-14.987.343-14.987.343l-10.764-1.898.376-3.892"
                    fill={fillColor}
                />
                <Path
                    d="M506.205 391.56l2.013.163-1.458 5.291s-11.092-3.268-13.286-5.808c-2.194-2.54-13.224-9.601-13.224-9.601l-12.3-7.744s-8.299-6.084-7.432-15.328c.88-9.255 3.928-55.308 3.928-55.308l5.062-53.391c0-.012 1.564-17.659 11.315-41.698s28.764-77.295 28.764-77.295l23.616-64.145s4.803-18.945 19.882-20.17c0 0 39.101 1.285 39.372 1.302l59.569 3.523 21.076 3.282-4.665 3.81s-38.262-4.473-45.23-5.03c-6.98-.56-58.777-2.007-58.777-2.007l-10.699.059s-6.096-.125-12.045 7.154-17.082 42.907-17.082 42.907l-10.257 29.426-17.257 47.191-16.175 44.467s-3.22 10.161-4.525 15.828c-1.304 5.667-6.076 44.359-6.076 44.359l-5.068 51.238-1.022 21.254s1.101 8.812 5.265 14.434 20.69 14.461 20.69 14.461l16.028 7.341-.002.035z"
                    fill={fillColor}
                />
                <Path
                    d="M664.966 52.699c12.953-1.667 19.397 7.199 17.271 19.522-.875 5.055-2.707 9.897-4.43 14.71-4.511 12.61-9.08 25.205-13.625 37.802-12.944 35.822-26.863 71.357-38.739 107.507-3.647 11.115-8.286 21.825-12.267 32.789-.644 1.769-3.424.825-2.779-.957 20.371-56.032 40.63-112.167 60.878-168.302 1.62-4.5 3.242-9.012 4.852-13.524 1.018-2.822 2.141-5.614 2.926-8.499 1.337-4.884 2.276-11.32-1.117-15.663-3.394-4.343-8.493-3.777-12.984-5.35-.023-.002-.032-.05.004-.06l.01.025z"
                    fill={lineColor}
                    stroke={lineColor}
                />
                <Path
                    d="M612.234 264.579c.335 5.002-3.246 10.384-5.461 14.739-3.23 6.386-6.885 12.556-10.777 18.557-8.626 13.332-19.663 24.939-29.183 37.624-9.881 13.159-20.946 25.593-31.558 38.161a869.126 869.126 0 01-14.932 17.265c-3.272 3.674-7.318 7.985-12.66 6.406-.825-.242-.795-1.66.111-1.756 8.527-.894 13.641-9.574 18.836-15.599 4.902-5.688 9.724-11.43 14.514-17.208 9.615-11.579 19.146-23.127 29.065-34.45 9.026-10.302 16.769-21.266 24.179-32.77 3.527-5.468 6.84-11.091 9.808-16.879 2.308-4.515 3.767-10.764 7.301-14.469.304-.312.709.021.734.366l.023.013z"
                    fill={lineColor}
                    stroke={lineColor}
                />
                <Path
                    d="M462.298 352.825c-.667 5.885-.665 12.416 3.423 17.181 3.791 4.427 9.915 7.109 14.747 10.218 8.605 5.547 20.217 15.756 31.056 14.417 1.049-.135 1.915.961 1.287 1.915-2.919 4.442-9.133 2.05-13.063.217-7.16-3.339-13.813-8.515-20.257-13.062-5.517-3.885-12.964-8.295-16.904-13.903-3.452-4.914-3.74-11.416-3.093-17.16.208-1.797 3.025-1.631 2.816.178l-.012-.001z"
                    fill={lineColor}
                    stroke={lineColor}
                />
                <Path
                    d="M476.662 219.693c-2.814 6.542-3.283 14.345-4.219 21.301-2.441 18.254-4.141 36.555-5.559 54.909-1.518 19.732-2.007 40.05-5.321 59.562-.224 1.299-2.004 1.199-2.039-.129-.532-18.181 1.641-36.866 3.292-54.969 1.082-11.892 2.235-23.78 3.634-35.641 1.399-11.86 2.801-23.957 6.561-35.349 1.081-3.256 2.709-6.383 3.582-9.712.002-.035.072-.019.058.016l.011.012z"
                    fill={lineColor}
                    stroke={lineColor}
                />
                <Path
                    d="M543.989 50.803c-6.968 6.197-9.775 17.117-12.933 25.72-4.498 12.22-8.96 24.444-13.434 36.666-10.796 29.534-21.603 59.055-32.585 88.529-2.72 7.305-5.871 14.856-8.796 21.84-.46 1.107-2.244.509-1.783-.609 2.52-6.005 4.095-12.59 6.363-18.717 5.052-13.7 10.036-27.428 15.158-41.1 10.732-28.71 21.441-57.433 32.219-86.127 3.342-8.899 6.491-22.246 15.219-27.066.527-.286 1.023.467.584.865l-.012-.001z"
                    fill={lineColor}
                    stroke={lineColor}
                />
                <Path
                    d="M469.964 243.734c.936-5.277.5-10.368 2.287-15.425 1.671-4.733 3.429-10.1 6.167-14.304.38-.58 1.177-.092 1.032.515-1.085 4.628-3.191 8.955-4.291 13.629-1.296 5.538-4.037 9.979-5.136 15.588-.002.036-.061.032-.059-.003zm75.752-194.22c.288-.265.577-.531.843-.81.329-.334.782.357.346.519-.363.13-.728.297-1.093.451-.097.041-.196-.083-.108-.16h.012z"
                    fill={lineColor}
                />
                <Path
                    d="M542.403 51.402c2.766-7.279 15.233-6.492 21.654-6.631 12.487-.277 25.116.745 37.587 1.284 24.623 1.069 49.283 2.483 73.642 6.41 2.717.444 2.468 4.77-.272 4.313-21.459-3.578-43.183-5.222-64.89-6.367-10.777-.574-21.562-1.018-32.346-1.485-5.368-.233-10.751-.608-16.123-.58-5.693.031-13.676 0-18.583 3.512-.309.217-.826-.028-.67-.444l.001-.012zm112.625 10.122c4.736-.245 9.975-.033 12.863 4.267 2.887 4.299 2.729 10.358 1.888 15.073-.842 4.714-2.499 8.856-4.049 13.171a12423.292 12423.292 0 01-12.606 34.968c-12.082 33.404-24.709 66.644-36.198 100.239-3.482 10.179-7.529 20.133-11.207 30.229-.387 1.064-2.054.497-1.667-.578a65568.48 65568.48 0 0056.484-156.04c1.507-4.2 3.025-8.386 4.52-12.587.92-2.58 1.911-5.155 2.622-7.796 1.149-4.329 1.635-9.03.24-13.365-2.006-6.267-7.513-6.177-12.916-7.547-.023-.001-.009-.036.003-.035l.023.001zm-51.009 200.893c-.508 4.865-3.289 9.564-5.477 13.862-3.147 6.178-6.694 12.154-10.48 17.96-7.965 12.239-17.836 23.174-26.796 34.676-9.449 12.133-19.432 23.913-29.309 35.7-4.387 5.224-8.798 10.435-13.33 15.52-2.713 3.047-6.359 7.206-10.894 6.34-.689-.138-.644-1.046.069-1.096 7.339-.436 12.824-9.743 17.09-14.727 4.266-4.983 8.72-10.322 13.024-15.54 8.622-10.458 16.985-21.121 25.922-31.323 8.937-10.202 16.34-20.276 23.482-31.289 3.25-5 6.306-10.131 9.066-15.422 2.49-4.788 4.155-10.35 7.146-14.822.144-.216.515-.098.487.161z"
                    fill={lineColor}
                    stroke={lineColor}
                />
                <Path
                    d="M468.14 345.351c-.608 4.764-1.006 9.945.956 14.47 2.593 5.972 8.106 8.781 13.372 11.94 4.32 2.604 8.677 5.174 13.023 7.731 4.836 2.849 10.22 6.951 16.083 5.156.592-.187 1.2.667.768 1.149-2.884 3.32-7.483 1.598-10.988-.043-6.654-3.106-12.949-7.774-19.124-11.713-5.175-3.296-10.55-6.794-13.673-12.243-2.877-5.021-2.81-10.955-2.102-16.554.139-1.079 1.824-.973 1.685.107z"
                    fill={lineColor}
                    stroke={lineColor}
                />
                <Path
                    d="M483.775 219.1c-2.463 6.221-3.371 13.108-4.388 19.669-2.595 16.742-4.275 33.612-5.825 50.48-1.681 18.396-2.667 37.014-5.312 55.303-.108.774-1.24.726-1.225-.077.523-27.97 4.076-56.34 7.579-84.098 1.367-10.786 2.732-21.738 5.933-32.159.952-3.087 2.275-6.044 3.203-9.132.002-.024.036-.01.036.002l-.001.012z"
                    fill={lineColor}
                    stroke={lineColor}
                />
                <Path
                    d="M544.406 63.889c-6.374 6.14-9.046 16.43-12.015 24.665-4.115 11.394-8.206 22.8-12.297 34.195-9.875 27.51-19.74 55.032-29.731 82.498-2.533 6.962-5.146 13.872-7.945 20.723-.279.668-1.344.305-1.065-.363 2.296-5.64 3.907-11.679 5.985-17.415 4.687-12.967 9.327-25.947 14.038-38.912 9.745-26.761 19.455-53.524 29.235-80.27 3.074-8.407 5.913-20.212 13.375-25.597.323-.24.71.187.42.476zm8.325-7.448c7.676-2.769 17.329-1.26 25.333-.992 9.409.31 18.804.655 28.206 1.094 19.25.896 38.521 2.23 57.566 5.254 1.629.257 1.477 2.85-.163 2.58-18.314-2.989-36.845-4.419-55.358-5.374-9.422-.488-18.839-.858-28.257-1.215-8.923-.339-18.396.175-27.226-.879-.223-.026-.343-.376-.101-.468z"
                    fill={lineColor}
                    stroke={lineColor}
                />
                <Path
                    d="M670.164 53.217c9.76-3.004 13.443 11.745 11.162 18.462-.159.463-.799.293-.806-.157-.118-4.515-.621-8.723-3.449-12.462-1.922-2.535-5.027-3.015-7.095-5.298-.177-.2-.053-.477.176-.545h.012z"
                    fill={lineColor}
                />
                <Path
                    d="M672.369 53.7l.629-.6c.454-.444 1.132-.508 1.725-.34 5.704 1.661 8.365 6.739 12.525 10.55 5.782 5.299 11.391 10.716 16.317 16.836 1.623 2.019-1.397 4.703-3.032 2.671-5.143-6.417-11.066-11.925-17.016-17.565-2.634-2.497-4.545-5.776-7.574-7.825-1.725-1.162-3.136-1.298-3.691-3.38a.357.357 0 01.117-.347z"
                    fill={lineColor}
                    stroke={lineColor}
                />
                <Path
                    d="M700.553 79.316c2.77-.594 3.517 5.38 3.546 7.169.104 6.608-2.78 12.566-5.076 18.572-.878 2.288-1.641 4.629-2.449 6.944-4.347 12.444-8.763 24.871-13.144 37.3-11.702 33.203-23.381 66.42-35.106 99.621-3.01 8.517-6.587 17.389-9.933 25.412-.502 1.211-2.448.555-1.933-.666 2.384-5.718 3.906-13.347 6.108-19.561 5.082-14.349 10.129-28.712 15.188-43.062 10.753-30.542 21.482-61.086 32.293-91.612a989.624 989.624 0 014.658-12.873c.327-.879.644-1.77.982-2.636 1.054-2.631 2.302-5.166 3.229-7.853.362-1.053 3.421-15.968 1.717-15.969-.449-.005-.477-.68-.058-.76l-.022-.026zm-68.489 206.792c-2.443 12.469-12.818 24.272-20.303 34.151-8.569 11.302-17.795 21.97-27.173 32.593-1.479 1.682-4.452-.884-2.971-2.6 9.093-10.606 18.312-21.157 26.921-32.16a306.695 306.695 0 0012.017-16.455c3.587-5.287 6.702-11.159 11.326-15.623.063-.067.202-.011.183.094z"
                    fill={lineColor}
                    stroke={lineColor}
                />
                <Path
                    d="M505.166 396.794c8.009.375 16.025.644 24.071.62 2.071-.011 3.854.243 5.762-.382 3.309-1.069 6.257-3.722 8.844-5.913 5.674-4.8 10.853-10.199 15.895-15.666 4.369-4.74 8.616-9.607 12.784-14.537 4.59-5.437 8.772-11.526 14.02-16.329 1.168-1.074 2.785.484 2.018 1.772-3.92 6.614-9.703 12.389-14.764 18.163-4.079 4.652-8.226 9.252-12.519 13.726-5.458 5.689-11.08 11.355-17.324 16.19-2.488 1.926-5.305 4.209-8.35 5.211-2.114.695-4.318.556-6.546.628-8.205.287-16.281.215-24.164-2.152-.755-.225-.505-1.38.274-1.343l-.001.012z"
                    fill={lineColor}
                    stroke={lineColor}
                />
                <Path
                    d="M515.508 398.441a14.432 14.432 0 01.155-4.154.664.664 0 011.247-.253c3.468 6.146 1.976-.384 1.586-3.39-.152-1.157 1.248-1.589 1.863-.651l5.022 7.592-1.827.642a3454.25 3454.25 0 01-1.139-11.015c-.104-.976 1.337-1.69 1.779-.621 1.71 4.201 3.202 7.939 6.558 11.18l-1.576.787c-.738-5.358-1.066-10.478-2.93-15.623-.462-1.295 1.139-2.105 1.894-.957a561.533 561.533 0 019.311 14.618l-1.478.747c-2.768-6.575-4.287-13.249-5.501-20.258-.276-1.614 1.876-2.354 2.685-.931 3.184 5.608 5.971 11.486 10.068 16.5l-1.47.984c-2.975-7.416-4.969-14.995-5.84-22.941-.121-1.084 1.307-2.142 2.114-1.061 4.285 5.771 7.931 11.917 11.256 18.29l-1.428.501c-1.192-4.168-2.627-8.246-3.819-12.414-1.192-4.169-.801-8.486-1.992-12.666-.427-1.482 2.067-2.39 2.588-.901 1.134 3.218 1.889 6.448 3.618 9.408 1.975 3.39 4.313 6.649 6.659 9.778l-1.582 1.072c-1.589-3.685-3.18-7.536-3.863-11.518-.874-5.084.739-10.4-1.055-15.34-.665-1.84 1.762-3.178 2.774-1.399 3.875 6.835 6.743 14.433 10.006 21.596l-1.948.681c-1.139-7.064-2.834-13.772-3.28-20.946-.153-2.446 3.823-2.278 3.865.244.103 6.809.519 13.52 1.453 20.275.156 1.098-1.464 1.824-1.948.681-3.164-7.404-7.255-14.004-10.91-21.143l2.903-1.012c1.222 3.887.609 7.231.414 11.253-.276 5.685 1.145 10.543 3.312 15.755.39.947-.896 2.013-1.582 1.071-4.336-5.905-8.243-12.599-11.304-19.216l2.589-.902c1.058 3.297 1.365 6.676 1.621 10.123.416 5.587 1.054 9.732 2.909 15.019.321.908-.843 1.544-1.357.683-3.596-6-7.613-11.707-11.728-17.362l2.114-1.061c.786 7.775 2.395 15.282 5.042 22.642.312.86-.792 1.867-1.47.984-4.075-5.356-8.341-10.298-11.293-16.388l2.685-.931c.765 6.993 1.054 13.672 4.173 20.103.399.806-.806 1.712-1.359.92-3.351-4.825-6.643-9.659-9.846-14.581l1.894-.957c1.89 5.301 2.701 10.818 2.843 16.446.02.995-1.296 1.042-1.726.352-2.308-3.73-5.066-7.264-6.749-11.345l1.778-.621c.396 3.669.803 7.338 1.199 11.007.117 1.131-1.211 1.556-1.827.642-1.687-2.52-3.373-5.052-5.059-7.572l1.882-.39c.008 2.686-.068 5.379-.131 8.072-.008.319-.404.401-.605.211-1.384-1.306-2.69-2.548-3.91-4.021l1.136-.567c.005 1.408.262 2.773.783 4.083.439 1.483-2.18 1.921-2.246.166z"
                    fill={lineColor}
                />
            </G>
            <Path
                d="M517.818 526.978c-2.91 1.083-4.815 3.321-9.776 8.586-6.685 7.043-20.845 20.107-25.501 28.681-.307.58.47 1.204.994.839 5.14-4.496 4.313-3.345 10.769-9.91 5.375-5.46 24.116-18.701 24.974-26.63.09-.796-.543-1.659-1.46-1.566zm-40.131-8.611c-4.566 1.93-2.794 3.009-4.475 8.944-2.29 7.961-7.789 24.977-7.56 33.136.023.549 1.006.652 1.278.162 2.218-6.24 1.47-3.172 3.799-10.691 1.942-6.256 12.199-25.047 9.001-31.076-.317-.608-1.295-.944-2.043-.475zm-33.855 155.256c6.418-4.294 9.86-28.333 11.924-35.266 2.804-9.297 3.705-12.002 2.829-13.882.013-.657-.962-.865-1.265-.303-4.612 8.095-6.905 16.7-9.719 25.467-2.346 7.293-8.576 15.774-5.778 23.242.278.752 1.232 1.238 2.009.742zm-34.482-30.38c7.377.221 11.714-6.679 16.504-10.584 6.454-5.217 13.05-10.206 17.556-17.032.297-.464-.449-1.113-.954-.867-7.482 3.429-13.196 8.413-19.429 13.245-5.188 4.017-14.227 6.891-15.077 13.675-.09.681.517 1.519 1.4 1.563zm-57.234-291.209c-31.253 7.598-62.532 15.09-93.731 22.883-15.435 3.861-30.871 7.712-46.305 11.572-15.435 3.86-31.687 7.302-47.145 12.105-.926.292-.636 1.915.355 1.718 15.347-2.994 30.488-7.408 45.638-11.249 15.731-3.989 31.462-7.989 47.193-11.979 31.443-7.978 62.814-16.269 94.213-24.452.397-.107.179-.695-.209-.599l-.009.001z"
                fill={lineColor}
            />
            <Path
                d="M159.006 225.405c5.421 31.703 10.735 63.425 16.354 95.088 2.785 15.665 5.56 31.329 8.346 46.994 2.785 15.664 5.096 32.115 8.819 47.868.227.943 1.866.767 1.738-.236-1.926-15.517-5.284-30.926-8.069-46.306-2.893-15.969-5.797-31.938-8.691-47.907-5.787-31.919-11.89-63.788-17.885-95.678-.079-.402-.682-.226-.612.168v.009z"
                fill={lineColor}
            />
            <Path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M274.414 256.675c-1.835 11.479-1.918 27.926.076 50.606.808 9.193.81 16.481.113 22.138-.693 5.62-2.103 9.872-4.327 12.769-2.324 3.027-5.408 4.401-8.853 4.41-3.29.008-6.773-1.222-10.194-3.034-6.849-3.626-14.412-10.114-21.379-16.619-3.033-2.832-5.932-5.645-8.647-8.279-3.661-3.553-6.987-6.78-9.85-9.285-1.541-1.349-3.082-1.832-4.679-1.753-1.681.082-3.646.803-5.89 2.286-4.521 2.987-9.489 8.604-14.484 15.766-9.938 14.25-19.358 33.691-24.991 47.277-.529 1.276-3.342 9.071-4.617 8.543-1.276-.529 6.279-19.725 6.808-21 5.7-13.748 8.47-23.014 18.699-37.68 5.088-7.297 10.495-13.554 15.829-17.078 2.683-1.773 5.515-2.966 8.399-3.108 2.968-.147 5.76.833 8.219 2.984 2.917 2.553 6.435 5.964 10.209 9.624 2.713 2.629 5.557 5.388 8.407 8.048 6.97 6.508 14.106 12.572 20.307 15.856 3.104 1.643 5.734 2.457 7.841 2.452 1.954-.005 3.555-.704 4.9-2.455 1.444-1.882 2.687-5.115 3.331-10.335.638-5.182.66-12.088-.132-21.089-2.006-22.82-1.964-39.748-.033-51.833 1.917-11.992 5.794-19.829 12.063-23.538 6.302-3.729 14.115-2.759 22.523.544 8.475 3.328 18.203 9.28 28.847 16.543 1.14.778 7.368 5.311 6.59 6.451-.778 1.141-10.36-4.608-11.5-5.386-10.606-7.238-17.85-9.846-25.765-12.954-7.983-3.136-13.888-3.416-18.149-.895-4.294 2.541-7.822 8.454-9.671 20.024z"
                fill={lineColor}
            />
            <Path
                d="M531.023 624.499c2.002.006 43.494-4.18 43.494-4.18l1.564-34.675-54.156-2.944.173 42.299 8.925-.5z"
                fill={fillColor}
            />
            <Path
                d="M501.586 618.899c2.467.056 21.265-.944 21.265-.944l-.925-12.284-1.969-16.559-30.074 2.197.001 25.69 11.702 1.9z"
                fill={fillColor}
            />
            <Path
                d="M520.22 581.219c-4.753 6.087-1.825 15.359-1.617 22.591.245 9.707.398 13.689 2.398 21.581.193.628 3.03.629 3.143 0 0-12.892.069-11.005 0-20.212-.054-7.661-1.713-22.963 1.59-24.687-.498-.627-4.931.014-5.514.727z"
                fill={lineColor}
            />
            <Path
                d="M521.939 588.469c-1.548-2.684-11.714-1.864-16.625-1.606-6.61.31-11.591.629-16.304 2.172-.327.208-.826 1.287-.254 2.401 2.542 1.088 5.066-.697 11.428-.817 5.297-.096 19.542-.127 21.851-.794.154-.533.536-.259-.096-1.356zm-.94 26.53c-6.575-.142-11 0-15.645 0-6.355.161-14.269-.126-16.451.161-.289.21-.357 2.918.106 2.994 6.856 1.298 12.49.555 18.346.555 5.144 0 12.144.291 14.144-.209.115-.496 1.018-3.468-.5-3.501z"
                fill={lineColor}
            />
            <Path
                d="M488.463 590.192c-.265 2.175-1.006 10.647-.962 15.308.024 6.268-.463 7 .999 12.5.172.343 2.925.383 2.925-.621-.523-3.966-.869-7.739-.735-13.741.115-4.996 1.406-12.289-.168-14.139-.467-.237-1.482.024-2.059.693zm86.642 30.273c1.712-.226 2.914-6.946 3.224-11.597.451-6.252-.273-18.533-2.331-23.868-.145-.356-1.843 1.06-1.998 1.5 1.698 12.888.509 17.967-.079 23.942-.494 4.973-2.351 8.594-.921 10.558.447.272 1.479.089 2.105-.535z"
                fill={lineColor}
            />
            <Path
                d="M522.851 583.298c12.739.908 18.197 1.409 25.803 1.491 8.946.103 16.614 1.034 25.476 1.862 2.617.251 2.378-3.112-.256-3.633-8.956-1.769-16.282-2.133-25.521-2.513-7.794-.323-24.75-.768-27.672.439-.752.461 1.44 1.994 2.17 2.354zm52.998 36.35c-.635 3.053-20.151 4.118-27.747 4.516-8.934.473-17.611.719-26.43 1.914-.688.093-1.902-3.431.708-4.062 7.883-1.903 14.224-.934 23.438-1.697 7.775-.646 20.375-2.479 26.858-2.948.77.429 3.037 1.948 2.323 2.338l.85-.061zm-40.346-30.216c2.666-.46 5.526-.306 8.223-.34l7.213-.094c5.157-.069 10.336.299 15.489.251 1.61-.014 1.693.654.063.67-5.69.053-11.332.68-17.022.729-2.761.026-5.517.052-8.278.075-2.761.022-5.421.184-8.001-.261-.635-.111-.939-.832-.084-.99 5.12-.94 11.03-.453 16.215-.497 5.691-.046 11.417.32 17.107.274l.038.382c-5.328.043-10.587.948-15.912.969l-7.734.032c-2.457.01-4.903-.107-7.262-.485-.859-.139-.917-.57-.061-.718l.006.003z"
                fill={lineColor}
            />
            <Defs>
                <ClipPath id="a">
                    <Path fill="#fff" d="M0 0h710v673.811H0z" />
                </ClipPath>
            </Defs>
        </Svg>
    );
};
