import * as React from 'react';
import Svg, { G, Path, Defs, ClipPath, SvgProps } from 'react-native-svg';

import { useIllustrationColors } from '@suite-native/atoms';

export const ConnectTrezorSvg = (props: SvgProps) => {
    const { lineColor, fillColor } = useIllustrationColors();

    return (
        <Svg width={224} height={224} fill="none" {...props}>
            <G clipPath="url(#a)">
                <Path
                    d="M149.941 45.01s6.9-1.785 13.316-2.558c6.418-.773 18.818-2.025 20.314-1.93 1.496.096 4.681 1.496 4.681 1.496s3.185 2.751 3.135 2.992c-.05.241.53 2.317.193 3.956-.339 1.641-6.031 30.3-6.031 30.3s-3.427 13.028-3.474 13.269c-.048.24-2.076 5.5-3.185 7.43-1.11 1.93-3.861 5.886-3.861 6.031 0 .146-3.474 5.163-3.474 5.163l-4.101 6.08s-3.378 4.39-3.86 4.681c-.482.291-1.014.868-1.833.964-.818.095-1.641.529-2.364.193-.723-.339-1.883-.53-2.076-.53-.193 0-.434-.096-.434-.096s-.628 2.365-.723 2.413c-.096.047-1.883.675-2.026.675-.143 0-3.956-.53-3.86-.723.095-.193.434-3.04.434-3.04l-2.799-.723-5.258-3.569s-2.219-8.878-2.944-13.22c-.723-4.343-1.883-12.013-.916-17.37.964-5.356 8.491-37.633 8.491-37.633s1.109-3.378 2.846-4.342M94.713 178.876c.072-.217 6.351-2.412 6.659-2.534.308-.121 3.111 8.83 3.111 8.83l-7.165 1.809-2.605-8.105z"
                    fill={fillColor}
                />
                <Path
                    d="M102.219 175.239c.041.094.113.17.204.215.111.057.228.061.35.072.075.006.149.015.225.006a.535.535 0 0 0 .315-.175c.102-.103.146-.3.054-.426-.084-.117-.167-.213-.31-.261-.1-.032-.241-.026-.347-.034-.341-.029-.639.269-.491.603zM151.259 121.533c-.349-.927-1.639-.812-2.475-.951-.571-.095-1.704-.191-1.494.762.161.721 1.144.743 1.729.849.471.087.998.256 1.478.195.358-.045.934-.397.762-.855zM190.861 44.708c-.023-.154 0-.006-.006.037.039-.297-.043-.163-.024.126.022.326.041.204.059.421.034.422.05.853.056 1.277.02 1.424-.245 2.814-.499 4.21-.96 5.287-2.156 10.532-3.264 15.789-.442 2.103-.87 4.21-1.27 6.322-.44 2.319-1.302 4.818-1.126 7.187.028.384.59.625.792.215.968-1.972 1.118-4.33 1.563-6.466.411-1.96.817-3.923 1.203-5.888.638-3.26 1.29-6.516 1.928-9.775.745-3.8 1.487-7.61 1.971-11.45.068-.537.126-1.071.005-1.605-.122-.534-.269-.756-.645-.97-.413-.237-.806.151-.74.568l-.003.002z"
                    fill={lineColor}
                />
                <Path
                    d="M185.616 77.004c-.567 1.581-1.164 3.15-1.707 4.74-.61 1.778-.977 3.652-1.376 5.489-.384 1.767-.741 3.545-1.216 5.291-.601 2.212-1.544 4.397-2.545 6.46-1.001 2.062-2.355 4.077-3.793 5.879-.929 1.164-1.546 2.423-2.279 3.695a105.337 105.337 0 0 1-2.43 3.971c-.832 1.307-2.006 2.319-2.903 3.565-.671.932-1.333 1.835-1.841 2.866-.163.33.23.647.51.393 1.729-1.554 2.753-3.637 3.906-5.61 1.566-2.682 3.882-4.859 5.548-7.462 1.359-2.124 2.516-4.386 3.879-6.514 1.066-1.663 2.05-3.302 2.719-5.17.668-1.867 1.029-3.834 1.524-5.755.519-2.009 1.103-4.013 1.498-6.05.367-1.89.517-3.844.723-5.76.015-.132-.18-.14-.219-.03l.002.002z"
                    fill={lineColor}
                />
                <Path
                    d="M167.799 116.261c-.262.415-1.044.585-1.413.956-.519.523-.951 1.144-1.398 1.728-.743.973-1.579 2.28-2.656 2.909-.944.554-2.299.231-3.337.118-1.112-.12-2.152-.061-3.263.013-.259.017-.376.36-.135.501 1.047.613 2.21.88 3.4 1.019 1.255.145 2.66.421 3.845-.152 1.299-.628 2.211-1.915 3.081-3.023.517-.655 1.029-1.305 1.446-2.03.194-.336.326-.612.376-.994.043-.332-.061-.725.076-1.034.006-.013-.013-.026-.02-.013l-.002.002zM186.641 41.12c.028 1.1 1.493 1.797 2.269 2.368.621.46 1.126.977 1.554 1.622.599.9.638 1.607.723 2.65.035.437.665.57.793.107.456-1.667.386-3.45-.932-4.674-.634-.589-1.396-1.062-2.167-1.448-.618-.31-1.428-.819-2.138-.728-.052.007-.102.041-.1.1l-.002.002zM149.453 120.903c-.686-.286-1.405-.425-2.065-.779-.543-.291-1.064-.636-1.589-.958-.526-.321-1.032-.586-1.503-.931-.445-.328-.744-.749-1.274-.931-.13-.044-.304.052-.33.186-.248 1.307 1.448 2.315 2.39 2.901 1.283.801 2.766 1.991 4.371 1.546.558-.154.458-.845 0-1.036v.002zM167.636 41.432c-1.215-.191-2.438.089-3.636.3-1.377.24-2.76.427-4.143.631-2.597.383-5.219.747-7.786 1.31-2.223.486-4.138 1.491-5.022 3.623-.675 1.63-1.107 3.366-1.548 5.07-.794 3.07-1.513 6.162-2.245 9.247-.551 2.325-1.07 4.66-1.604 6.989-.656 2.857-1.598 5.715-1.815 8.646-.026.364.564.542.714.193.962-2.263 1.396-4.694 1.956-7.082.508-2.165 1.04-4.325 1.559-6.488.758-3.161 1.442-6.34 2.2-9.503.464-1.939.92-3.895 1.556-5.786.584-1.737 1.227-2.717 3.09-3.41 2.373-.885 5.096-1.12 7.582-1.528 1.6-.262 3.209-.551 4.824-.712 1.409-.14 2.992-.08 4.321-.623.358-.145.497-.794 0-.875l-.003-.002z"
                    fill={lineColor}
                />
                <Path
                    d="M140.67 74.818c-.534 1.57-1.109 3.144-1.53 4.748-.448 1.71-.71 3.468-1.029 5.203-.337 1.836-.797 3.656-.96 5.52-.139 1.61 0 3.166.25 4.754.343 2.192.71 4.39.89 6.602.221 2.727 1.335 5.337 1.871 8.018.458 2.297.317 4.614 1.292 6.811.12.269.554.128.545-.147-.065-1.933-.623-3.828-1.237-5.643-.878-2.597-.697-5.483-1.197-8.144-.427-2.28-1.111-4.514-1.268-6.844-.221-3.326.135-6.607.871-9.848.421-1.857.858-3.709 1.175-5.587.317-1.878.362-3.617.521-5.42.01-.118-.163-.127-.198-.025l.004.002z"
                    fill={lineColor}
                />
                <Path
                    d="M141.259 114.399c.03.436-.285.862-.311 1.296-.026.434.135.99.291 1.409.259.69.758 1.379 1.431 1.715.832.417 1.932.469 2.833.615 2.269.366 4.838 1.061 7.122.49.245-.061.213-.391 0-.467-.714-.251-1.422-.566-2.171-.692-1.305-.217-2.619-.374-3.924-.586-.977-.159-2.012-.267-2.959-.563-.491-.152-.721-.48-1.014-1.068-.184-.373-.297-.792-.499-1.153-.202-.36-.604-.623-.78-1.001-.004-.008-.021-.004-.019.005zM166.805 42.407c1.285.17 2.603-.13 3.875-.308 1.622-.226 3.251-.35 4.883-.47 2.779-.204 5.619-.503 8.409-.423.945.026 2.373.113 2.966.99.059.087.087.152.126.378.07.384.044 1.044.007 1.537-.152 2.063-.587 4.114-.984 6.142-.677 3.457-1.422 6.898-2.149 10.344-.535 2.525-1.025 5.06-1.529 7.592-.604 3.04-1.455 6.086-1.589 9.191-.02.454.614.49.751.102 1.029-2.881 1.405-5.975 2.028-8.965.506-2.425 1.038-4.846 1.531-7.273.742-3.65 1.502-7.295 2.186-10.956.391-2.1.823-4.234.934-6.37.093-1.787-.32-3.044-2.291-3.589-1.151-.317-2.386-.263-3.565-.206-1.785.084-3.57.204-5.35.336-1.78.133-3.509.324-5.265.45-1.756.126-3.509.006-5.096.61-.495.189-.386.823.122.89v-.002z"
                    fill={lineColor}
                />
                <Path
                    d="M181.625 74.306c-.571 1.641-1.17 3.27-1.721 4.92-.578 1.73-.938 3.547-1.334 5.326-.406 1.83-.777 3.675-1.287 5.482-.608 2.153-1.555 4.27-2.551 6.27-.997 2-2.41 4.106-3.863 5.936-.942 1.19-1.58 2.486-2.362 3.765a168.571 168.571 0 0 1-2.382 3.799c-.812 1.253-1.976 2.326-2.881 3.557-.695.942-1.379 1.874-1.924 2.914-.154.293.211.581.459.353 1.715-1.587 2.792-3.665 3.979-5.64 1.613-2.684 3.93-4.885 5.604-7.523 1.325-2.089 2.51-4.276 3.852-6.36 1.04-1.62 2.012-3.226 2.688-5.037.675-1.81 1.072-3.858 1.574-5.797.532-2.058 1.129-4.112 1.548-6.199.38-1.886.564-3.83.799-5.74.015-.12-.163-.128-.198-.026zM161.147 116.878c-.313.23-.734.326-1.055.554-.404.284-.734.692-1.095 1.031-.538.508-1.179.992-1.765 1.027-.884.054-1.817-.111-2.69-.204-1.17-.126-2.338-.326-3.509-.436-.751-.072-1.506.03-2.26.08-.23.015-.341.323-.121.451 1.895 1.099 4.322 1.143 6.448 1.375.845.091 1.8.284 2.647.119.846-.165 1.569-.673 2.149-1.259.326-.33.686-.756.899-1.175.254-.499.15-1.05.369-1.546.004-.008-.004-.021-.015-.015l-.002-.002zM179.845 43.015c-.89-.172-1.796-.041-2.688.07-1.93.238-3.858.447-5.793.635-4.472.435-8.945.877-13.407 1.418-2.926.356-7.028.428-8.708 3.25-1.025 1.718-1.381 3.928-1.844 5.839-.575 2.37-1.107 4.752-1.643 7.132-.851 3.771-2.05 7.575-2.449 11.422-.042.396.523.407.645.087 1.235-3.222 1.791-6.726 2.581-10.078.53-2.247 1.057-4.495 1.574-6.744.517-2.25.875-4.577 1.804-6.637 1.203-2.664 4.831-2.85 7.493-3.2 4.256-.559 8.526-1.012 12.793-1.462 2.186-.23 4.366-.451 6.561-.588 1.051-.065 2.065-.139 3.081-.395.358-.09.384-.678 0-.751v.002z"
                    fill={lineColor}
                />
                <Path
                    d="M144.253 70.044c-1.672 4.787-2.621 9.685-3.537 14.66-.541 2.935-.99 5.705-.786 8.706a46.84 46.84 0 0 0 .717 5.445c.445 2.391.877 4.777 1.244 7.18.275 1.804.414 3.732.868 5.5.454 1.767.604 3.904 2.801 4.32 1.706.324 3.463.487 5.196.591 1.732.104 3.463.617 5.204.84.764.098 1.552.243 2.29-.041 1.451-.558 2.167-1.978 2.923-3.224.147-.243-.196-.513-.393-.304-.888.929-1.744 2.618-3.125 2.868-.636.115-1.391.013-2.032-.02a50 50 0 0 1-4.613-.445c-1.546-.219-3.084-.397-4.608-.725-.935-.202-1.582-.293-1.96-1.294-.378-1.001-.541-2.106-.814-3.155-1.014-3.858-1.659-7.844-2.057-11.81-.18-1.807-.429-3.61-.571-5.42-.221-2.87.109-5.536.706-8.335.51-2.397.964-4.807 1.407-7.217.493-2.686.766-5.402 1.311-8.08.022-.108-.13-.151-.167-.045l-.004.005zM180.186 43.707c1.55.458 4.199-.252 4.24 1.902.024 1.216-.206 2.451-.408 3.646-.858 5.063-2.021 10.078-3.079 15.102a378.45 378.45 0 0 0-1.229 6.097c-.453 2.338-1.196 4.744-1.196 7.135 0 .395.515.414.645.086.879-2.177 1.109-4.644 1.587-6.937.412-1.975.823-3.949 1.22-5.927.638-3.185 1.288-6.368 1.911-9.555.417-2.132.836-4.267 1.155-6.416.171-1.164.393-2.4.282-3.58-.204-2.184-3.357-2.953-5.126-2.3-.35.129-.389.637 0 .752l-.002-.005z"
                    fill={lineColor}
                />
                <Path
                    d="M179.293 74.492c-.631 2.827-1.595 5.53-2.39 8.31-.756 2.642-1.192 5.416-2.126 7.998-1.441 3.986-4.029 7.489-6.159 11.116-2.13 3.629-4.369 7.072-6.939 10.318-.348.438-.682.884-1.038 1.318-.866 1.053-1.54 2.872-3.018 3.15-1.479.278-3.279-.143-4.761-.299-1.483-.157-2.884-.409-4.315-.684-.951-.185-1.906-.354-2.85-.574-1.533-.356-1.616-2.099-2.063-3.369-.087-.248-.532-.233-.493.067.15 1.175.163 2.501 1.034 3.42.501.527 1.168.662 1.86.781 1.644.283 3.301.278 4.957.398 1.657.119 3.259.56 4.887.742.639.072 1.355.222 1.996.102 1.009-.186 2.032-1.055 2.631-1.845 2.469-3.248 4.488-6.816 6.837-10.155 2.486-3.537 4.981-7.076 6.972-10.925 1.646-3.179 2.423-6.492 3.339-9.92.873-3.268 1.509-6.546 1.809-9.92.008-.098-.15-.118-.17-.024v-.005zM138.043 91.1c-.332 2.088.076 4.255.328 6.34.28 2.316.621 4.62 1.012 6.921.391 2.302.844 4.701 1.318 7.041a248.5 248.5 0 0 0 .74 3.531c.204.938.308 2.002.953 2.742.23.265.76.063.723-.3-.091-.912-.462-1.821-.666-2.72a254.493 254.493 0 0 1-.732-3.313 300.864 300.864 0 0 1-1.366-6.816c-.844-4.459-1.676-8.923-2.277-13.422-.002-.017-.031-.026-.035-.004h.002zM141.131 73.183c-.669 1.147-.869 2.6-1.194 3.874-.302 1.176-.96 2.529-.747 3.745.043.25.427.354.588.156.777-.957.842-2.466 1.088-3.643.269-1.288.695-2.736.525-4.058-.017-.13-.186-.204-.262-.072l.002-.002zM144.754 68.103c-.773 1.58-1.181 3.385-1.565 5.095-.202.895-.384 1.796-.565 2.695-.154.764-.393 1.504-.262 2.28.045.275.44.286.569.073.412-.683.458-1.541.614-2.318.18-.901.38-1.796.56-2.697.335-1.667.751-3.385.797-5.087 0-.074-.111-.109-.145-.04l-.003-.001zM152.347 125.845c-2.176 3.296-3.4 7.284-3.975 11.175-.48 3.244.06 6.802 2.199 9.39 4.731 5.728 14.13 3.722 20.307 2.211 7.99-1.957 15.85-5.209 24.178-5.333 3.943-.058 8.262.519 11.505 2.942 3.19 2.384 4.875 6.605 4.104 10.524-.784 3.986-3.674 7.054-7.48 8.355-3.806 1.3-7.701 1.111-11.544.966-8.403-.317-17.115-1.223-25.238 1.52-3.454 1.166-6.596 3.044-8.35 6.35-1.754 3.307-2.336 7.028-3.45 10.504-2.167 6.774-5.155 14.028-10.721 18.716-13.208 11.116-30.914-1.869-38.832-13.227a146.797 146.797 0 0 1-3.213-4.772c-.2-.311-.793-.111-.632.267 2.938 6.965 8.628 12.942 14.74 17.285 5.993 4.257 13.728 7.204 21.117 5.378 7.215-1.785 12.217-7.884 15.192-14.378 1.47-3.207 2.781-6.468 3.812-9.844 1.136-3.717 1.7-8.179 4.288-11.231 2.588-3.053 7.213-4.421 11.147-5.122 4.458-.795 9.017-.758 13.527-.589 4.209.159 8.452.569 12.666.333 3.6-.202 7.276-1.012 10.111-3.366 5.743-4.765 5.559-13.96-.327-18.52-6.323-4.9-15.739-3.567-22.937-1.804-8.035 1.967-16.14 5.48-24.538 5.334-3.846-.067-7.778-1.326-9.586-4.998-1.846-3.743-.806-7.846.167-11.67.536-2.106 1.268-4.17 2.241-6.116.158-.317-.278-.573-.476-.278l-.002-.002z"
                    fill={lineColor}
                />
                <Path
                    d="M151.261 119.427c-.579.63-.779 1.463-1.014 2.271a28.443 28.443 0 0 0-.714 3.059c-.056.328.085.693.441.778 1.6.382 3.226.634 4.866.766.238.02.56-.204.594-.452.257-1.852.834-3.656 1.066-5.499.07-.552-.84-.793-1.061-.287-.751 1.72-.971 3.776-1.216 5.624l.617-.617a26.218 26.218 0 0 1-4.53-.753l.441.777a66 66 0 0 1 .593-2.875c.2-.842.547-1.698.452-2.568-.027-.252-.337-.443-.539-.224h.004z"
                    fill={lineColor}
                />
                <Path
                    d="M154.85 126.205c.094-.015.198-.026.28-.08.578-.375-.067-1.227-.579-.751l-.037.035c-.113.106-.185.317-.124.466.358.891 1.9.528 2.232-.221.703-1.589.521-3.376 1.012-5.018l-1.077-.297c-.339 1.489-.819 2.918-1.296 4.366l1.098.304c.33-1.468.725-2.92 1.053-4.39l-1.096-.302c-.285 1.509-.847 3.025-1.034 4.542l.901-.373-.082-.087c-.241-.254-.673-.122-.766.202l-.033.117c-.159.56.699.956.964.406.651-1.348.866-3.048 1.146-4.505.137-.712-.933-1.023-1.096-.302-.332 1.468-.725 2.92-1.055 4.39-.161.717.868 1.001 1.098.304.48-1.448.947-2.879 1.275-4.37.154-.699-.875-.99-1.077-.298-.337 1.155-.324 2.321-.53 3.494-.054.315-.154.625-.247.931-.172.571-.27.61-.904.552l.417.238-.026-.049-.076.581.035-.039h-.677l.008.009-.119-.452-.052.135c-.115.295.212.506.462.462h.002zM187.572 42.95c1.166 1.815 2.156 3.756 3.018 5.731l.554-.718a255.04 255.04 0 0 0-3.381-.816c-.469-.111-.749.425-.451.775a18.65 18.65 0 0 1 2.722 4.246l.56-.56c-1.17-.558-2.34-1.11-3.519-1.648-.302-.136-.706.161-.493.493 1.14 1.776 2.18 3.613 3.248 5.432l.576-.575c-1.253-.862-2.53-1.693-3.794-2.538-.301-.202-.727.206-.51.51a29.663 29.663 0 0 1 3.036 5.352l.592-.458c-1.272-1.012-2.731-1.74-4.268-2.254-.217-.071-.447.209-.309.402 1.175 1.644 1.833 3.42 2.3 5.374l.401-.309a13.36 13.36 0 0 0-3.041-1.48c-.157-.055-.3.113-.261.26a27.901 27.901 0 0 0 1.522 4.31l.187-.241a3.429 3.429 0 0 1-1.338-.773c-.123-.109-.295 0-.265.154.12.651.341 1.153.741 1.69.069.093.226.008.16-.094a3.757 3.757 0 0 1-.588-1.64l-.271.114c.447.401.907.67 1.476.864.15.052.239-.122.187-.241a22.907 22.907 0 0 1-1.396-4.256l-.261.26a12.89 12.89 0 0 1 2.879 1.544c.209.148.447-.095.402-.308-.432-1.956-1.32-3.797-2.356-5.504l-.308.402c1.45.584 2.712 1.38 3.956 2.319.334.252.658-.217.516-.517a39.83 39.83 0 0 0-3.041-5.348l-.511.51c1.249.876 2.489 1.761 3.748 2.62.349.236.794-.231.575-.576-1.131-1.78-2.293-3.548-3.35-5.372l-.493.493c1.151.588 2.31 1.164 3.47 1.733.384.189.731-.187.56-.56a20.867 20.867 0 0 0-2.775-4.488l-.451.775c1.12.297 2.242.586 3.367.868.447.113.719-.338.554-.718-.888-2.035-2.041-3.843-3.426-5.574-.198-.247-.606.074-.437.337l-.013-.002zM95.414 178.481c-.53 1.081.398 2.857.72 3.945.377 1.285.624 3.061 1.463 4.138.907 1.166 2.327.452 3.465.07 1.259-.424 2.514-.852 3.801-1.175.645-.161.83-.868.574-1.409-1.138-2.406-1.772-5.005-2.882-7.421-.538-1.173-2.294-.154-1.739 1.016 1.136 2.397 1.798 4.983 2.966 7.373l.573-1.409c-1.037.276-2.06.612-3.087.925-.508.154-1.014.313-1.522.465-.115.034-.551.223-.675.199.178.035-.03-.29-.098-.479-.41-1.151-.788-2.311-1.168-3.472-.282-.86-.597-2.603-1.51-2.998-.299-.131-.709-.111-.876.23l-.005.002z"
                    fill={lineColor}
                />
                <Path
                    d="M94.661 179.671c.358 1.912.55 4.366 1.637 6.029.447.684.44 1.526 1.424 1.7.862.152 2.139-.187 2.107-1.242-.007-.23-.15-.395-.359-.471-.495-.18-1.055-.022-1.543-.206l.57.44c.213.378.011-.334-.036-.482-.08-.249-.24-.406-.37-.62-.342-.563-.503-1.229-.668-1.859-.348-1.331-.51-2.74-1.24-3.928-.51-.831-1.691-.267-1.52.641l-.002-.002z"
                    fill={lineColor}
                />
                <Path
                    d="M101.52 175.734c-1.016.113-1.963.521-2.927.849-1.023.348-2.054.675-3.061 1.068-.563.22-.823.767-.54 1.327.503.999.935 2.677 2.1 3.048.222.072.437-.084.509-.288.367-1.071-.619-2.463-.958-3.457l-.632 1.112c1.032-.319 2.052-.676 3.077-1.01.953-.313 2-.545 2.855-1.083.645-.406.458-1.663-.423-1.566z"
                    fill={lineColor}
                />
                <Path
                    d="M95.245 177.829c-.25.168-.397.454-.226.739a.867.867 0 0 0 .163.193c.057.052-.02-.026-.03-.044.032.055-.024-.065-.024-.067-.037-.139-.007-.21.078-.315-.18.224-.232.511-.046.752.187.241.476.269.739.147.48-.221.716-.71.705-1.224a.686.686 0 0 0-.417-.621c-.271-.115-.52-.035-.742.141a2.024 2.024 0 0 0-.612.799l1.255.53c.069-.33.171-.747.09-1.082-.143-.588-.872-.76-1.293-.343-.265.263-.435.73-.328 1.097.06.206.22.41.404.519.212.123.447.093.66-.005.163-.076.24-.269.25-.434-.018.109-.02.133-.01.074a.639.639 0 0 0 0-.326c.025.094-.01.376.031-.006.015-.144-.05.134.009-.013-.04.084-.04.091-.005.021.094-.145.007-.084-.258.183l-.53-.07.033.016-.248-.248c-.04-.256-.065-.326-.067-.213 0 .031-.004.063-.006.094l-.016.154c-.01.113.03-.161-.006.032l-.035.183c-.072.338.072.673.397.81.283.119.726.034.858-.281.052-.123.12-.232.191-.343.028-.041.02-.028-.028.035a1.545 1.545 0 0 1 .224-.221l-1.16-.48c.002.035.004.069.002.104a.413.413 0 0 0 .005-.026c.013.02-.079.208 0 .035-.044.095-.07.163-.094.256-.022.065-.02.061.009-.011a.566.566 0 0 1-.05.085l1.066.289a.701.701 0 0 0-.421-.715.976.976 0 0 0-.204-.063c-.09-.017.021.011.058.039.066.052.12.198.122.278 0 .07.015-.03-.01.031.062-.146.064-.306-.055-.426-.107-.106-.298-.141-.426-.054l-.002-.005zM100.619 175.977c.041.094.113.17.204.215.111.055.228.061.349.07.076.006.15.015.226.004a.54.54 0 0 0 .315-.176c.1-.102.146-.299.054-.425-.084-.117-.167-.213-.31-.259-.1-.032-.241-.026-.348-.034-.338-.026-.638.269-.49.605z"
                    fill={lineColor}
                />
                <Path
                    d="M94.52 177.953c2.306-.393 4.477-1.37 6.761-1.889l-.58-.154c.291.365.437.56.871.708.243.082.538-.139.521-.397-.028-.465-.178-.654-.456-1.032-.167-.228-.391-.332-.673-.273-2.34.484-4.82 1.042-6.742 2.527-.269.208.037.554.298.51z"
                    fill={lineColor}
                />
                <Path
                    d="M97.927 186.744c-.178-.818-2.836-7.681-3.305-7.518l-.814-.621c.06 2.199.864 4.273 1.797 6.244.326.688.69 1.939 1.34 2.369.65.43 1.891-.168 2.588-.335.81-.195.46-1.391-.34-1.237-.376.071-.76.18-1.143.219-.475.048-.36.096-.55-.334-.366-.832-.796-1.629-1.132-2.478-.593-1.493-.967-3.052-1.297-4.622-.067-.317-.482-.571-.792-.45-1.611.628-.217 2.573.254 3.587.844 1.82 1.628 3.893 2.883 5.469.204.259.57-.028.51-.297v.004zM101.211 185.839c-.128 1.001.852 2.106 1.362 2.92a34.563 34.563 0 0 0 2.002 2.89c1.391 1.798 2.907 3.834 4.802 5.128.3.204.702-.202.502-.501-1.292-1.933-3.025-3.583-4.39-5.474a88.22 88.22 0 0 1-1.974-2.814c-.51-.768-.966-2.03-1.841-2.414-.228-.1-.428.022-.46.263l-.003.002zM152.703 125.591c-1.42.627-2.054 3.168-2.367 4.546a408.94 408.94 0 0 0-1.354 6.214c-.066.307.375.432.471.131.603-1.898 1.064-3.843 1.784-5.7.322-.827.619-1.661.956-2.484.336-.822.89-1.624.877-2.494-.002-.2-.202-.285-.367-.211v-.002z"
                    fill={lineColor}
                />
                <Path
                    d="m28.418 43.013 2.22 19.238 4.546 31.532L46.5 156.947l4.043 17.085s5.842 13.388 20.094 9.998c14.251-3.389 29.663-7.768 29.663-7.768l20.71-8.607s10.159-4.433 8.131-16.509c-2.027-12.074-5.46-31.441-5.46-31.441l-6.776-38.282-7.421-40.4-3.146-12.48s-3.8-10.597-16.369-9.878c-12.569.719-37.609 3.124-37.609 3.124L40.9 24.141s-7.381 3.552-9.203 6.97c-1.822 3.417-3.216 8.347-3.28 11.9l.001.002z"
                    fill={fillColor}
                />
                <Path
                    d="M57.697 21.616c6.4-.576 12.803-1.112 19.208-1.655 4.412-.373 8.852-.812 13.284-.658 4.04.141 7.883 1.045 11.183 3.472 3.891 2.864 5.398 8.02 6.342 12.532a662.653 662.653 0 0 1 2.25 11.294c1.191 6.227 2.318 12.47 3.445 18.707 1.561 8.642 3.103 17.287 4.642 25.933 1.639 9.206 3.272 18.414 4.907 27.622 1.385 7.803 2.762 15.608 4.156 23.409.875 4.905 2.136 9.232.935 14.156-1.094 4.497-3.934 8.27-7.796 10.789-2.423 1.578-4.957 2.392-7.723 3.376-6.848 2.438-13.724 4.857-20.668 7.011-.547.169-1.096.332-1.641.506-1.05.334-.601 1.995.458 1.658.048-.015.098-.039.148-.047.378-.074.032-.016.38-.137.401-.141.803-.285 1.205-.428 1.394-.495 2.785-.988 4.188-1.455 3.834-1.276 7.664-2.564 11.485-3.871 3.125-1.07 6.269-2.115 9.345-3.315 3.798-1.483 7.226-4.143 9.521-7.521 2.091-3.077 3.168-6.776 3.263-10.483.048-1.854-.254-3.608-.584-5.419a6405.949 6405.949 0 0 1-3.873-21.512c-1.642-9.182-3.266-18.366-4.899-27.55-1.628-9.156-3.261-18.31-4.906-27.46a2984.614 2984.614 0 0 0-3.88-21.25c-.643-3.42-1.453-6.818-2.072-10.237-.773-4.277-1.517-8.602-3.543-12.502-2-3.85-5.45-6.561-9.583-7.83-4.834-1.48-10.242-.991-15.186-.516-4.294.413-8.585.912-12.866 1.437-3.71.454-7.417.945-11.12 1.442-.313.041-.329.532 0 .504l-.005-.002z"
                    fill={lineColor}
                />
                <Path
                    d="M67.938 20.163c-3.1-.156-6.166.287-9.242.662-2.46.3-4.927.571-7.374.958-3.304.519-6.737 1.029-9.885 2.206-2.21.825-4.171 2.071-5.587 3.984-1.016 1.372-1.697 2.972-2.308 4.553-.942 2.44-1.543 5.026-1.648 7.644-.073 1.859.155 3.691.35 5.533.367 3.42.725 6.837 1.138 10.252.855 7.084 1.847 14.15 3.052 21.182 2.387 13.948 5.287 27.811 7.92 41.713 2.643 13.941 5.084 27.917 7.893 41.827.345 1.705.693 3.402 1.114 5.092.122.49.814.271.74-.204-1.055-6.846-2.492-13.635-3.597-20.475-1.114-6.895-2.2-13.793-3.35-20.682-1.136-6.803-2.137-13.635-3.396-20.418-1.26-6.774-2.67-13.518-3.937-20.29-2.447-13.103-4.418-26.28-6.096-39.5-.61-4.807.102-9.392 2.301-13.754.99-1.963 2.436-3.49 4.399-4.497 3.033-1.559 6.587-2.038 9.922-2.503 2.564-.358 5.133-.7 7.7-1.04 3.35-.443 6.732-.77 9.952-1.83a.213.213 0 0 0-.056-.417l-.005.004zM53.68 167.377c.793 5.405 3.457 10.207 7.775 13.579 2.18 1.704 4.566 2.792 7.326 3.148 2.928.378 5.864-.026 8.736-.629 3.325-.7 6.518-1.872 9.755-2.879.582-.181.515-1.192-.151-1.119-3.435.385-6.798 1.229-10.179 1.915-3.372.684-7.065 1.155-10.422.144-2.88-.869-5.501-2.981-7.455-5.22-2.293-2.627-3.772-5.784-4.62-9.151-.129-.508-.839-.28-.767.21l.002.002zM27.82 44.836A884.173 884.173 0 0 0 34.473 92.9c2.72 16.362 5.686 32.678 8.61 49.005 1.64 9.147 3.114 18.364 5.155 27.429.156.699 1.36.562 1.275-.172-.951-8.105-2.484-16.162-3.926-24.193-1.461-8.136-2.966-16.262-4.447-24.393-2.957-16.241-5.907-32.479-8.632-48.763-1.505-9-3.07-17.988-4.375-27.02-.026-.176-.332-.137-.313.041l-.002.002z"
                    fill={lineColor}
                />
                <Path
                    d="M43.465 23.333c-3.522.886-6.916 2.074-9.773 4.42-2.955 2.426-4.742 5.871-5.512 9.578-.897 4.31-.63 8.775-.185 13.124.45 4.386 1.066 8.959 2.267 13.208.121.427.857.364.805-.109-.23-2.11-.614-4.199-.831-6.312-.22-2.116-.358-4.238-.487-6.359-.243-4.058-.57-8.296.13-12.324.617-3.545 2.09-6.895 4.814-9.318 2.608-2.32 5.897-3.874 8.893-5.615.157-.091.052-.334-.121-.29v-.003zM47.536 161.934c.152 1.731.056 3.433.301 5.172a34.445 34.445 0 0 0 1.173 5.287c.903 2.916 2.423 5.656 4.481 7.918 1.798 1.976 4.102 3.576 6.694 4.29 2.592.715 5.38.806 8.06.647 2.878-.169 5.868-.981 8.619-1.83.65-.202.382-1.181-.282-1.02-3.01.729-6.067.627-9.139.631-3.072.005-6.222-.097-8.893-1.591-3-1.676-5.137-4.529-6.561-7.606-.875-1.891-1.546-3.83-2.128-5.829-.3-1.027-.56-2.067-.87-3.09-.311-1.027-.76-2.002-1.017-3.042-.058-.241-.464-.197-.44.061l.002.002zM62.56 31.358c-.258-.986-.58-1.644-1.604-2.026-.873-.326-1.807-.17-2.547.389-1.683 1.27-1.548 3.819.247 4.917 1.796 1.099 4.269-.037 4.636-2.14.167-.962-.146-2.078-1.055-2.567-.79-.425-2.054-.252-2.254.751-.102.51.302.919.814.815.476-.098.834-.28.936.401.063.42-.176.88-.454 1.168a1.508 1.508 0 0 1-2.386-.271c-.436-.712-.1-1.707.645-2.07.697-.338 1.997.09 2.297.837.176.438.853.282.725-.2v-.004zM67.157 32.18c1.18.372 2.573-.017 3.778-.169l4.046-.517c2.645-.336 5.285-.71 7.925-1.07 1.223-.167.702-2.023-.512-1.856-2.81.384-5.617.77-8.426 1.155-1.334.182-2.669.364-4.002.55-1.4.19-2.812.23-4.043.98-.436.267-.358.954.144 1.095 1.283.36 2.492.082 3.788-.098l4.42-.619c2.878-.401 5.754-.803 8.631-1.207l-.512-1.856c-2.625.367-5.252.725-7.875 1.118l-3.823.57c-1.197.179-2.643.183-3.678.86a.593.593 0 0 0 .139 1.069v-.005z"
                    fill={lineColor}
                />
                <Path
                    d="M61.014 31.855c.52-.571.66-1.381-.095-1.83-.808-.478-1.637.112-2.013.84-.428.827-.753 1.926-.165 2.753.63.886 1.783.664 2.462-.033.68-.697 1.246-1.698.964-2.666-.271-.934-1.227-1.38-2.138-1.077-.912.304-1.757 1.216-1.976 2.126-.22.91.295 1.897 1.248 2.121.953.224 1.89-.321 2.482-1.088.593-.766 1.181-1.789.59-2.7-.59-.913-1.76-.656-2.31.153-.486.715-.979 2.102-.56 2.936.471.94 1.694.745 2.226-.022.532-.766.66-2.039-.254-2.605-1.822-1.131-3.602 2.735-1.713 3.313 1.077.33 2.134-1.1 2.184-2.056.056-1.042-.96-1.86-1.94-1.349-.978.513-.922 1.879.014 2.393 1.164.639 2.225-.52 2.217-1.637-.005-.64-.808-.98-1.266-.523-.458.456-.838 1.172-.432 1.821.356.567 1.105.589 1.56.146.457-.443-.006-1.31-.633-1.088.21.354.395.41.551.17l-1.265-.524c0 .052-.03.378-.08.432.036.137-.02.152-.172.046v.078c-.072.059-.157.308-.22.4-.054.08-.115.158-.18.232l.309.135c.2-.105.11-.641.401-.765-.108.048-.032.144-.108.36-.024.072-.185.255-.183.316.165.19.237.21.215.063a.889.889 0 0 1 .035-.294c.026-.154.067-.308.113-.458.03-.102.373-.855.39-.82.103.221-.349.781-.48.961-.201.28-.464.589-.809.689-.315.089-.636.015-.673-.352-.037-.367.25-.673.478-.905.215-.22.569-.587.91-.491.34.095.29.497.186.781-.121.33-.365.73-.627.964-.515.459-.723.02-.66-.48.043-.336.175-.742.351-1.037.078-.133.183-.296.346-.341.384-.106.807.378.542.788-.07.106.092.23.176.135l.002-.011z"
                    fill={lineColor}
                />
                <Path
                    d="M59.484 29.905c.81.22 1.754-.015 2.34.76.196.259.278.59.272.912-.007.321-.174.61-.191.938-.018.328.384.547.657.378.89-.554.639-2.037.055-2.723-.66-.775-2.306-1.266-3.177-.6-.12.092-.121.29.044.335zM60.602 21.361c3.5.066 6.98-.323 10.452-.729 3.472-.406 6.92-1.11 10.376-1.103.421 0 .536-.669.102-.753-1.674-.324-3.49.143-5.157.356-1.773.228-3.547.445-5.321.653-3.5.409-7.015.752-10.467 1.472-.061.013-.044.102.013.104h.002zM35.364 30.064c-2.505 2.223-4.503 4.85-6.038 7.825-.139.269.135.505.39.39a8.431 8.431 0 0 1 3.64-.738l-.21-.51a36.305 36.305 0 0 0-4.23 6.809c-.135.278.15.636.45.45l3.788-2.363-.523-.523a747.493 747.493 0 0 0-3.932 7.8c-.194.387.19.75.57.572l4.048-1.896-.571-.57c-1.266 2.186-2.53 4.372-3.798 6.558-.197.343.217.819.571.572 1.216-.852 2.432-1.7 3.648-2.552l-.575-.575c-.908 2.073-1.816 4.147-2.723 6.223-.152.347.19.853.584.584 1.231-.851 2.464-1.7 3.695-2.55l-.59-.59a73.197 73.197 0 0 0-2.886 6.887c-.132.367.33.682.643.495l3.463-2.078-.6-.599a35.564 35.564 0 0 0-2.616 6.711c-.08.289.215.654.528.528a31.588 31.588 0 0 1 3.506-1.162l-.516-.517c-.838 2.493-1.687 4.981-2.534 7.471-.083.246.141.548.402.528.894-.065 1.897-.263 2.794-.198.23-.104.421-.069.569.102.25.105.254.276.015.517-.07.441-.371.938-.536 1.357-.686 1.746-1.373 3.49-2.056 5.235-.066.167.04.43.204.504.786.358 1.454.282 2.301.252.424-.016 1.003-.068 1.364.23.746.618.115 1.346-.161 1.962-.754 1.683-1.377 3.511-1.613 5.348-.068.525-.07 1.014.252 1.461.419.586 1.165.688 1.641 1.192.812.864.287 2.206.052 3.18-.204.85-.306 1.636-.085 2.491.15.57 1.032.328.884-.243-.473-1.828 1.138-3.713.215-5.519-.334-.654-.903-.901-1.487-1.274-1.049-.671-.298-2.617-.009-3.613.324-1.123.753-2.195 1.244-3.255.267-.575.495-1.166.202-1.78-.836-1.752-3.016-.597-4.349-1.203l.204.504c.504-1.294 1.008-2.588 1.514-3.88.404-1.034 1.146-2.276 1.283-3.379.074-.603-.309-.957-.877-1.05-1.097-.183-2.46.145-3.565.225l.401.528c.845-2.49 1.687-4.98 2.538-7.469.107-.313-.223-.593-.516-.517a31.103 31.103 0 0 0-3.511 1.145l.527.527a35.21 35.21 0 0 1 2.545-6.496c.193-.376-.206-.834-.6-.6-1.154.693-2.307 1.386-3.462 2.078l.642.495a71.594 71.594 0 0 1 2.786-6.684c.17-.352-.204-.858-.59-.591l-3.691 2.558.584.584c.905-2.076 1.808-4.152 2.714-6.227.147-.341-.191-.847-.576-.576l-3.643 2.556.57.57 3.798-6.558c.222-.385-.208-.74-.57-.571l-4.048 1.895.571.571c1.3-2.607 2.603-5.213 3.874-7.836.154-.319-.178-.75-.524-.523-1.244.819-2.49 1.637-3.734 2.453l.45.45a34.234 34.234 0 0 1 4.085-6.718c.153-.195.07-.508-.21-.51a9.122 9.122 0 0 0-3.928.842l.391.391a29.503 29.503 0 0 1 5.804-7.855c.171-.165-.085-.415-.259-.258h-.002zM31.7 22.25c-1.017-.689-3.186.964-3.98 1.567-1.47 1.118-2.719 2.473-3.8 3.967-1.216 1.683-2.148 3.524-2.95 5.434a61.488 61.488 0 0 0-1.063 2.714c-.334.912-.822 1.9-.63 2.897.079.401.576.445.841.221.675-.57.895-1.526 1.19-2.332.31-.849.632-1.693.977-2.527.745-1.8 1.609-3.58 2.668-5.217.945-1.457 2.078-2.799 3.411-3.915a18.668 18.668 0 0 1 2.024-1.474c.512-.322 1.229-.517 1.38-1.157a.165.165 0 0 0-.073-.18l.004.002zM29.632 15.054c-4.757 2.334-8.652 5.706-11.809 9.953a33.256 33.256 0 0 0-3.94 6.85c-.967 2.271-1.996 4.911-1.872 7.425.026.554.862.893 1.133.307 1.027-2.209 1.544-4.645 2.519-6.883a38.538 38.538 0 0 1 3.595-6.481c2.827-4.095 6.648-7.701 10.841-10.372.506-.323.065-1.061-.467-.799zM49.822 183.646c.473 2.716 2.746 5.267 4.761 7.004 2.213 1.907 4.846 3.214 7.715 3.774.785.154 1.087-.932.33-1.199-2.556-.907-4.981-2.269-7.057-4.021-.996-.842-1.856-1.791-2.703-2.783-.847-.992-1.524-2.165-2.384-3.161-.284-.33-.725.034-.664.386h.002zM190.935 34.076c2.582 2.065 4.831 4.546 6.188 7.588a18.21 18.21 0 0 1 1.383 4.66c.261 1.717.133 3.426.078 5.152-.017.562.806.651.962.13.984-3.28.154-7.224-1.242-10.267-1.476-3.214-3.847-6.112-7.08-7.634-.226-.107-.514.193-.289.373v-.002zM91.083 86.25c-1.053-5.867-7.01-9.886-13.2-8.848-6.19 1.038-10.4 6.76-9.35 12.625l.617 3.43-4.642.778 4.429 24.684 17.248 4.748 14.586-10.083-4.41-24.57-4.642.776-.636-3.543v.002zM74.28 89.064c-.497-2.766 1.54-5.388 4.633-5.907 3.097-.52 5.926 1.287 6.42 4.053l.617 3.43-11.053 1.853-.617-3.43v.001zm19.363 21.61-8.713 6.021-10.3-2.834-2.662-14.833 19.013-3.187 2.662 14.833zM159.922 68.732c-4.794-.484-8.346 5.433-9.054 9.52-.707 4.085 1.142 8.499 5.454 9.56 4.486 1.106 8.926-2.175 11.097-5.873 2.176-3.703 2.554-9.383-1.105-12.336-1.96-1.583-4.503-1.724-6.885-1.155-2.097.5-5.191 1.815-5.812 4.097-.134.495.439.73.788.458.71-.55 1.273-1.24 2.026-1.741a9.649 9.649 0 0 1 2.757-1.247c1.716-.482 3.987-.755 5.617.113 3.481 1.857 3.509 7.115 2.074 10.24-1.524 3.322-4.992 6.544-8.844 6.51-3.851-.032-6.476-3.597-6.203-7.316.335-4.546 3.861-8.969 8.134-10.502.184-.065.145-.313-.046-.33l.002.002z"
                    fill={lineColor}
                />
                <Path
                    d="M165.15 74.334c-.482-.356-.97.072-1.413.547-.562.397-1.092.934-1.598 1.392l-1.739 1.57c-.68.612-1.353 1.222-2.024 1.83-.202.106-.401.215-.601.323-.139-.09-.143-.412-.204-.612-.337-1.096-.877-2.04-1.451-2.929-.006-.009-.013-.015-.019-.022.104-.262-.115-.551-.363-.32-.529.49-1.083.991-1.483 1.614-.028.044-.032.105-.013.141.469.95.908 1.935 1.386 2.908.308.627.636 1.617 1.341 1.832.797.241 1.637-.695 2.289-1.266 1.042-.914 2.067-1.804 3.174-2.664.512-.4 1.031-.8 1.535-1.224.515-.434 1.138-.853 1.609-1.346.666-.697.05-1.416-.426-1.768v-.006zm-8.385 7.63a1.607 1.607 0 0 1-.184-.216c.058.074.119.146.184.215z"
                    fill={lineColor}
                />
            </G>
            <Defs>
                <ClipPath id="a">
                    <Path fill="#fff" transform="translate(12 15)" d="M0 0h200v193.647H0z" />
                </ClipPath>
            </Defs>
        </Svg>
    );
};
