import { ReactNode } from 'react';

import { BottomSheet, Box, Button, Text, VStack } from '@suite-native/atoms';
import { Translation } from '@suite-native/intl';
import { useOpenLink } from '@suite-native/link';

export type HowToUpdateBottomSheetProps = {
    isVisible: boolean;
    onClose: (isVisible: boolean) => void;
    title?: ReactNode;
};

export const HowToUpdateBottomSheet = ({
    isVisible,
    onClose,
    title,
}: HowToUpdateBottomSheetProps) => {
    const openLink = useOpenLink();

    const handleHelpClick = () => {
        openLink('https://trezor.io/learn/a/update-trezor-device-firmware');
        onClose(false);
    };

    return (
        <BottomSheet isVisible={isVisible} onClose={onClose} title={title}>
            <VStack spacing="sp24">
                <VStack paddingHorizontal="sp24">
                    <Text variant="callout">
                        <Translation id="moduleDeviceSettings.updateHowTo.subtitle" />
                    </Text>
                    <Box>
                        <Text color="textSubdued">
                            <Translation id="moduleDeviceSettings.updateHowTo.lines.1" />
                        </Text>
                        <Text color="textSubdued">
                            <Translation id="moduleDeviceSettings.updateHowTo.lines.2" />
                        </Text>
                        <Text color="textSubdued">
                            <Translation id="moduleDeviceSettings.updateHowTo.lines.3" />
                        </Text>
                    </Box>
                </VStack>
                <Button
                    colorScheme="tertiaryElevation0"
                    onPress={handleHelpClick}
                    viewRight="arrowUpRight"
                >
                    <Translation id="moduleDeviceSettings.updateHowTo.button" />
                </Button>
            </VStack>
        </BottomSheet>
    );
};
