import Svg, { ClipPath, Defs, G, Path, SvgProps } from 'react-native-svg';

import { useIllustrationColors } from '@suite-native/atoms';

export const EmptyWalletSvg = (props: SvgProps) => {
    const { lineColor, fillColor } = useIllustrationColors();

    return (
        <Svg width={224} height={224} fill="none" {...props}>
            <G clipPath="url(#a)">
                <Path
                    d="M91.423 36.05a10.97 10.97 0 0 0-.098-.851c.024.285.058.568.098.852zM157.583 83.525s2.856-3.98 3.01-6.18c.151-2.202-1.149-5.927-1.149-5.927l-.526-1.455 7.541-12.234 6.182-7.794s-2.535-2.976-3.276-3.352c-.74-.376-6.014-.513-6.014-.513l-64.878 3.606s-6.044-6.503-7.047-13.626c.199 2.329.294 8.967-4.218 14.115l-8.34.458-7.145 1.058L49.321 79.08s-18.813 24.89-18.742 24.798c.072-.093-17.834 24.11-17.834 24.11l-1.791 2.529s-3.493 4.445.915 9.398c4.409 4.952 12.33 7.587 12.33 7.587l109.923 40.157s10.065 4.521 15.238-1.321l15.785-25.306 2.325-.685s2.909-2.931 3.931-4.291c1.019-1.36 7.326-11.879 7.326-11.879l7.509-13.842s.86-1.437.029-1.876l-.831-.439 1.749-3.006 15.042-26.34-40.029-12.747-4.616-2.395.003-.007z"
                    fill={fillColor}
                />
                <Path
                    d="M179.478 73.167s.685-6.215 1.6-7.175c.916-.96 1.423-1.746 1.423-1.746s-3.756-1.604-3.517-4.924c0 0-.337 2.683-1.242 3.892a173.693 173.693 0 0 1-2.275 2.931s3.034 3.98 3.297 4.696c.263.717.714 2.326.714 2.326zM219.212 95.753s-.822 4.373-2.667 6.9c-1.845 2.529-5.911 5.185-5.911 5.185s2.059.474 2.588 4.424c.528 3.95.841 8.323.841 8.323s2.272-7.662 4.775-10.432c2.503-2.77 3.621-3.749 3.621-3.749s-3.512-5.265-3.247-10.651zM11.66 152.468s-1.338 2.511-3.032 6.03c-1.693 3.519-7.073 7.159-7.073 7.159s3.686 1.611 5.74 3.966c2.055 2.355 4.577 8.344 4.577 8.344s.594-4.246 1.531-7.183c.937-2.936 4.414-6.27 4.414-6.27s-2.882-3.643-3.832-5.185c-.95-1.543-2.323-6.861-2.323-6.861h-.003z"
                    fill={fillColor}
                />
                <Path
                    d="M165.485 46.36c1.499-.214 2.882.421 4.021 1.355.472.386.894.839 1.298 1.297.515.582.756.735.305 1.389-1.439 2.08-3.225 3.963-4.719 6.016a90.994 90.994 0 0 0-4.22 6.365c-.659 1.085-1.344 2.175-1.885 3.323-.542 1.149-.794 2.329-1.216 3.493-.077.217.231.31.348.145.942-1.317 2.028-2.458 2.88-3.847.852-1.389 1.754-2.846 2.686-4.235a106.757 106.757 0 0 1 5.948-8.078c.773-.947 2.121-2.026 2.554-3.17.432-1.142-.672-2-1.375-2.698-1.813-1.802-4.356-3.32-6.856-1.902-.321.182-.085.595.233.55l-.002-.002zM135.478 102.695c-5.04 5.643-9.473 11.808-13.685 18.075-2.18 3.241-4.26 6.549-6.312 9.869a403.314 403.314 0 0 0-2.843 4.669c-.711 1.188-2.365 2.974-2.028 4.408.075.318.449.521.757.429 1.353-.4 2.065-2.569 2.742-3.709a369.112 369.112 0 0 1 2.94-4.882c1.996-3.262 4.054-6.479 6.124-9.694 4.106-6.37 8.401-12.617 12.727-18.839.173-.249-.22-.551-.422-.326z"
                    fill={lineColor}
                />
                <Path
                    d="M18.372 135.928c4.167.465 8.425.293 12.616.444 5.961.214 11.923.426 17.882.709 13.858.656 27.708 1.463 41.563 2.175 3.596.185 7.195.365 10.795.534 3.294.154 6.688.524 9.974.135.375-.045.545-.635.099-.722-2.806-.55-5.715-.529-8.563-.662-3.19-.148-6.378-.306-9.569-.47-6.983-.358-13.966-.749-20.95-1.114-13.106-.686-26.221-1.413-39.344-1.77-2.768-.074-5.54-.088-8.308-.072-2.102.014-4.18.04-6.245.461-.213.042-.138.33.047.352h.003z"
                    fill={lineColor}
                />
                <Path
                    d="M18.82 135.433c-.71-.606-1.13.555-.947 1.151.43 1.407 2.492 1.883 3.665 2.309 1.038.376 2.05.831 3.072 1.249a492.024 492.024 0 0 0 8.878 3.506c9.407 3.63 18.845 7.167 28.29 10.696 11.62 4.342 23.259 8.644 34.863 13.028a9666.21 9666.21 0 0 1 31.825 12.069c6.593 2.516 13.157 5.106 19.814 7.421.379.133.767.265 1.138.418.457.191.659-.553.205-.741-2.081-.865-4.056-1.915-6.166-2.727a1895.61 1895.61 0 0 0-10.479-3.995 8199.304 8199.304 0 0 0-29.332-11.017c-11.273-4.214-22.53-8.474-33.79-12.718-9.889-3.727-19.763-7.5-29.677-11.167a7288.22 7288.22 0 0 0-17.5-6.448 24.05 24.05 0 0 0-1.278-.431c-.452-.137-.914-.264-1.352-.442a4.887 4.887 0 0 1-.684-.333l-.144-.085c-.565-.259-.783-.73-.658-1.412.194.137.438-.175.258-.331z"
                    fill={lineColor}
                />
                <Path
                    d="M149.689 186.899c-1.824.651-3.538 1.477-5.465 1.815-2.089.365-4.271.035-6.299-.495-.974-.254-1.924-.571-2.874-.899-1.76-.611-3.517-1.23-5.272-1.847a4413.355 4413.355 0 0 1-21.38-7.596c-9.903-3.545-19.82-7.042-29.714-10.611-10.39-3.747-20.762-7.535-31.1-11.416-8.528-3.202-17.046-6.435-25.521-9.782a284.89 284.89 0 0 1-2.487-.994c-.57-.231-.987.746-.422.997 8.048 3.564 16.252 6.762 24.483 9.876 10.333 3.911 20.706 7.718 31.095 11.48 10.388 3.762 20.387 7.381 30.622 10.956a4548.32 4548.32 0 0 0 22.646 7.839c5.165 1.773 11.501 4.82 16.947 3.418 1.792-.46 3.172-1.794 4.77-2.675.037-.021.011-.082-.029-.068v.002z"
                    fill={lineColor}
                />
                <Path
                    d="M14.226 129.104c-2.354-.476-4.207 1.437-4.791 3.577-.746 2.736.443 5.601 2.1 7.752 1.94 2.521 4.583 4.339 7.437 5.704 3.09 1.479 6.64 2.955 10.051 3.429.327.045.542-.352.234-.55-2.171-1.395-4.876-2.067-7.27-2.99-2.652-1.024-5.285-2.278-7.448-4.151-1.959-1.696-3.745-3.931-4.143-6.556-.396-2.627.92-5.59 3.795-5.971.125-.016.184-.212.032-.241l.003-.003zM16.514 129.319c3.185-.127 6.428.103 9.614.19 1.473.04 2.946.111 4.419.172 5.863.249 11.73.408 17.595.617 14.742.523 29.481 1.045 44.22 1.632 2.62.103 5.242.209 7.862.265 1.014.021 2.447-.141 3.331.047.351.074.502-.463.149-.537-2.763-.587-6.078-.524-8.985-.675-6.694-.349-13.404-.526-20.103-.769-14.129-.508-28.268-1.024-42.405-1.334a350.917 350.917 0 0 0-5.712-.077c-3.312-.018-6.683-.153-9.985.069-.258.019-.26.413 0 .402v-.002zM108.205 133.658c.913.51 1.572 1.243 2.026 2.18.414.862.448 1.791.653 2.709.063.286.522.362.655.084 1.046-2.222-.929-4.807-2.925-5.669-.462-.201-.87.434-.406.693l-.003.003z"
                    fill={lineColor}
                />
                <Path
                    d="M9.541 133.16c1.152-2.397 3.215-4.474 4.82-6.59 1.763-2.328 3.486-4.686 5.216-7.038 3.459-4.698 6.965-9.363 10.503-14.003 6.856-8.99 13.664-18.015 20.486-27.031 1.932-2.556 3.82-5.133 5.89-7.58 1.855-2.193 4.04-4.225 5.693-6.567.281-.396-.332-.844-.664-.51C57.64 67.677 54.24 72.026 50.8 76.22c-3.49 4.257-6.7 8.75-9.977 13.167-6.941 9.353-14.126 18.518-21.027 27.902-1.93 2.624-3.87 5.243-5.699 7.939-1.662 2.448-3.798 5.022-4.732 7.858-.035.106.132.18.183.077l-.006-.003zM65.445 59.719c1.349-1.27 2.615-2.57 3.751-4.035.998-1.288 1.744-2.746 3.09-3.717.708-.51.114-1.498-.68-1.156-1.5.645-2.153 2.288-2.962 3.585-1.088 1.743-2.397 3.352-3.613 5.008-.18.246.202.51.412.315h.002zM98.472 49.8c11.39-.22 22.753-.82 34.129-1.431 9.035-.487 18.076-.897 27.105-1.482 1.84-.119 3.984-.46 5.699-.49.417-.007.419-.655 0-.648-15.772.289-31.933 1.416-47.809 2.358-6.394.378-12.748.865-19.124 1.45-.153.013-.161.248 0 .246V49.8z"
                    fill={lineColor}
                />
                <Path
                    d="M71.842 51.75c.337-.516.6-.214 1.264-.177 1.01.055 2.065-.093 3.076-.143 1.635-.077 3.265-.18 4.9-.278 1.99-.12 4.34.066 6.221-.64.313-.117.372-.6 0-.693-2.184-.55-4.801-.008-7.03.134-1.639.106-3.271.233-4.906.384-.91.085-1.906.08-2.782.365-.645.212-.83.26-.995.942-.037.15.164.236.25.106h.002zM149.556 186.669c.94-.593 1.415-1.664 1.996-2.579.725-1.143 1.423-2.305 2.126-3.461a485.39 485.39 0 0 1 4.152-6.683c1.401-2.214 2.768-4.453 4.172-6.665l2.174-3.423c.64-1.005 1.449-1.995 1.847-3.122.117-.328-.318-.508-.541-.315-.905.786-1.532 1.932-2.222 2.905a248.265 248.265 0 0 0-2.325 3.336c-1.484 2.165-2.967 4.334-4.379 6.546a451.81 451.81 0 0 0-4.181 6.667 117.84 117.84 0 0 0-2.086 3.484c-.542.953-1.248 1.868-1.317 2.982-.018.288.343.481.582.331l.002-.003zM113.472 65.563c-1.351 1.384-2.315 3.225-3.374 4.834-1.123 1.703-2.219 3.426-3.326 5.138-2.261 3.5-4.525 7.003-6.784 10.506-.955 1.484-1.927 2.96-2.867 4.452-.708 1.125-1.552 2.387-1.812 3.715-.17.865.132 1.442.966 1.754.666.251 1.3.19 1.996.222 1.022.045 2.041.204 3.065.177.335-.008.314-.463 0-.502-1.186-.148-4.188.4-4.907-.813-.57-.96.913-2.93 1.417-3.751 1.63-2.643 3.355-5.233 5.035-7.847l5.797-9.003c.927-1.44 1.856-2.879 2.766-4.329.91-1.45 1.906-2.757 2.498-4.28.103-.268-.284-.46-.468-.273h-.002zM103.664 96.216c5.54 1.323 11.244 1.09 16.894.926 2.803-.082 5.604-.217 8.409-.243 3.002-.027 5.938-.106 7.971 2.43.212.265.626-.023.547-.317-.629-2.299-3.217-3.024-5.343-3.182-3.106-.23-6.278-.024-9.386.071-6.357.199-12.706.405-19.063.095-.124-.005-.151.19-.029.22zM137.678 101.071c-.199 1.973.016 4.053.529 5.974.353 1.322 1.043 2.145 2.495 2.116 1.337-.026 2.42-1.201 3.145-2.198 1.378-1.905 2.514-4.006 3.668-6.048 2.344-4.146 5.001-8.112 7.525-12.147 1.213-1.939 2.455-3.876 3.586-5.865.892-1.567 1.855-3.334 2.123-5.138.29-1.95.229-4.334-.549-6.175-.802-1.905-2.105-3.707-3.198-5.458-.231-.373-.722-.111-.667.28.284 1.992 1.617 3.651 2.599 5.347.549.947 1.136 1.87 1.343 2.963.252 1.334-.165 2.559-.571 3.813-.719 2.23-1.935 4.23-3.156 6.215a902.52 902.52 0 0 0-3.994 6.55c-2.596 4.31-5.381 8.498-8.008 12.784-.746 1.217-3.289 6.453-4.815 3.686-1.08-1.958-1.014-4.625-1.492-6.776-.074-.339-.536-.225-.568.077h.005z"
                    fill={lineColor}
                />
                <Path
                    d="M113.955 65.227c1.467.357 3.246-.085 4.743-.212a204.014 204.014 0 0 1 16.201-.709c7.156-.026 14.307.326 21.426 1.037l-.558-.727c-.273.656-.201 1.15.096 1.78.247.524 1.069.151.921-.386-.128-.391-.096-.754.098-1.087.157-.379-.228-.696-.557-.728a201.206 201.206 0 0 0-21.688-.926 201.053 201.053 0 0 0-15.939.826c-1.513.137-3.419.066-4.796.743-.168.082-.123.35.05.392l.003-.003zM95.776 94.49c-.576.916-.41 2.009.138 2.906.047.08.148.153.25.143.54-.053 1.082-.088 1.626-.133.114-.01.197-.182.067-.243-.582-.264-1.144-.304-1.768-.19l.326.132c-.538-.741-.589-1.646-.414-2.522.027-.132-.146-.211-.223-.092h-.002zM99.096 97.256c4.812.643 9.77.476 14.622.582 4.874.106 9.749.206 14.623.341 1.197.032 2.396.058 3.594.1.48.02.995-.005 1.473.075 1.252.203 1.858.658 2.224 1.783.698 2.143 1.178 4.291 1.555 6.508.223 1.31.672 2.961 2.169 3.334.905.225 1.802-.172 1.932-1.125.008-.05-.064-.068-.095-.039-1.447 1.383-2.838.008-3.278-1.469-.261-.87-.359-1.799-.553-2.688-.408-1.881-.745-4.13-1.658-5.844-.616-1.156-2.129-.95-3.276-.992-2.142-.082-4.289-.098-6.434-.14-4.438-.093-8.878-.228-13.316-.344-4.438-.117-9.088-.48-13.577-.096a.01.01 0 0 0 0 .019l-.005-.005zM109.355 126.888s.013-.019 0-.019a.01.01 0 0 0 0 .019zM107.969 128.305c1.635-2.452 3.382-4.828 4.988-7.304.777-1.199 1.547-2.403 2.338-3.593.743-1.122 1.651-2.223 2.057-3.516.061-.193-.178-.289-.313-.18-1.001.804-1.662 1.989-2.362 3.045a180.708 180.708 0 0 0-2.477 3.802c-1.571 2.503-2.885 5.119-4.244 7.736-.005.01.011.018.016.01h-.003z"
                    fill={lineColor}
                />
                <Path
                    d="M121.971 106.894c1.452-1.73 3.079-3.447 4.257-5.381.136-.225-.167-.437-.353-.27-1.691 1.51-2.933 3.616-3.978 5.595-.024.045.037.098.074.056zM153.267 64.052c1.261-1.836 2.45-3.722 3.689-5.572 1.24-1.849 2.816-3.547 3.772-5.492a.235.235 0 0 0-.366-.283c-1.585 1.381-2.758 3.458-3.915 5.194-1.277 1.918-2.471 3.915-3.44 6.002-.08.172.148.31.257.151h.003zM163.488 49.147c.574-.593 1.439-1.233 1.683-2.048.072-.233-.204-.44-.411-.315-.361.214-.611.587-.847.929-.265.383-.486.801-.735 1.195-.117.188.154.397.308.236l.002.003zM185.641 128.215c1.813-1.793 2.991-4.46 4.3-6.63a538.798 538.798 0 0 0 4.401-7.392c2.84-4.881 5.709-9.749 8.488-14.665.449-.793-.756-1.495-1.224-.714-2.901 4.847-5.712 9.744-8.554 14.628a545.38 545.38 0 0 0-4.125 7.252c-1.279 2.278-3.084 4.706-3.766 7.244-.075.275.276.479.477.277h.003z"
                    fill={lineColor}
                />
                <Path
                    d="M157.389 83.855c1.539 1.127 3.411 1.805 5.178 2.503 1.768.698 3.483 1.344 5.237 1.984a317.664 317.664 0 0 0 11.334 3.858c7.607 2.45 15.246 4.839 22.928 7.053.759.22 1.064-.926.323-1.172-7.511-2.49-15.105-4.72-22.635-7.157a321.029 321.029 0 0 1-11.092-3.783 208.478 208.478 0 0 1-5.24-1.981c-1.868-.736-3.758-1.643-5.738-2.008-.441-.082-.653.441-.298.703h.003zM165.371 161.255c.732-.738 1.624-2.511 1.491-3.593-.132-1.082-1.276-1.376-2.115-1.818a149.34 149.34 0 0 0-4.733-2.376c-.759-.367-1.765-.635-2.293-1.314-.618-.797-.234-2.083.324-2.892.186-.273.345-.728.536-.339.053.111-.021.508-.011.614.051.587.258 1.18.515 1.706.542 1.112 1.521 1.895 2.593 2.471 1.407.757 2.952 1.225 4.356 1.987.316.172.634.352.934.551.76.508.913.984.685 1.905-.207.836-.873 1.64-1.17 2.471-.154.426.446.592.677.283.687-.916 1.988-2.585 1.762-3.834-.196-1.079-1.532-1.772-2.429-2.153-1.245-.532-2.588-.765-3.848-1.241-.959-.363-1.973-.85-2.687-1.601-.857-.905-1.542-2.381-.756-3.566.074-.111.042-.273-.048-.365-1.003-1.035-1.982.441-2.378 1.285-.581 1.239-.836 2.765.295 3.768.647.571 1.613.881 2.386 1.22 1.083.476 2.163.957 3.251 1.42.977.416 3.146.691 3.151 2.022.003 1.05-.908 2.1-1.025 3.164-.031.283.361.405.542.225h-.005z"
                    fill={lineColor}
                />
                <Path
                    d="M158.671 147.87c2.166-4.429 4.281-8.842 6.835-13.07 2.553-4.227 5.491-8.138 8.448-12.093l-.536.217c2.224.926 4.372 2.061 6.546 3.101 1.029.492 2.067.963 3.102 1.439.691.317 2.437.765 2.896 1.442.494.727-.854 2.415-1.184 3.021l-1.741 3.231c-1.035 1.923-2.083 3.841-3.129 5.759-1.901 3.493-3.745 7.025-5.861 10.395-2.139 3.408-4.621 6.376-7.493 9.186-.467.458.215 1.087.704.701 3.264-2.593 5.773-6.223 7.936-9.736 2.463-4.003 4.613-8.202 6.848-12.332 1.205-2.227 2.421-4.452 3.634-6.677.613-1.125 2.2-2.91 1.138-4.178-.6-.717-1.672-1.029-2.489-1.41-1.113-.518-2.225-1.045-3.342-1.55-2.397-1.085-4.86-2.059-7.204-3.254-.178-.09-.433-.09-.576.074-3.254 3.717-6.06 7.921-8.624 12.13-2.566 4.217-4.979 8.641-6.744 13.258-.183.476.605.809.831.349l.005-.003z"
                    fill={lineColor}
                />
                <Path
                    d="M168.871 153.73c1.747-2.778 3.231-5.709 4.813-8.582 1.582-2.873 3.535-5.599 4.878-8.551.072-.159-.133-.363-.263-.204-2.054 2.506-3.591 5.609-5.226 8.398-1.669 2.852-3.315 5.725-4.576 8.781-.09.222.258.346.374.158zM180.561 133.187c.91-1.963 2.322-3.503 3.75-5.101.101-.114-.029-.307-.17-.22-1.913 1.178-3.049 3.172-3.734 5.254-.029.09.114.151.154.064v.003zM118.884 147.026c-.815 2.667-2.19 5.106-4.316 6.942-.428.371-.088 1.151.467 1.122 2.423-.116 3.222 2.437 3.753 4.323.204.73 1.364.601 1.343-.182-.061-2.426 1.245-4.54 3.429-5.599.582-.283.351-1.082-.167-1.264-2.227-.791-3.45-2.773-3.567-5.059l-.337.588c.148-.114.297-.231.448-.344.361-.278.298-.953-.254-.937l-.537.016a.696.696 0 0 0-.682.68c-.138 2.894 1.898 5.453 4.56 6.395l-.167-1.265a7.285 7.285 0 0 0-4.096 6.794l1.344-.183c-.714-2.476-1.999-5.444-5.073-5.275l.467 1.122c2.315-2.024 3.823-4.71 3.953-7.797.013-.333-.476-.381-.568-.077zM219.074 94.824c-1.046 5.215-4.05 9.874-8.711 12.557-.401.23-.305.838.127.965 2.315.688 2.331 4.731 2.556 6.617a73.62 73.62 0 0 1 .502 7.935c.008.727 1.083.717 1.125 0 .364-6.234 3.337-12.126 8.167-16.113.173-.142.21-.471.085-.656-2.309-3.394-3.328-7.33-3.081-11.419.045-.746-1.099-.732-1.157 0-.34 4.252.867 8.467 3.301 11.964l.085-.656c-5.037 4.233-8.124 10.318-8.522 16.877h1.125a67.967 67.967 0 0 0-.815-10.115c-.326-2.082-.727-4.775-3.087-5.458l.128.966c4.83-2.828 8.268-7.783 8.724-13.395.027-.312-.488-.384-.549-.074l-.003.005zM179.029 59.364a15.25 15.25 0 0 1-3.984 6.188c-.231.217-.223.614 0 .834 2.224 2.177 3.583 4.929 3.998 8.006l1.167-.32c-.522-3.472-.22-6.71 2.726-9.009.308-.24.205-.812-.127-.976-1.088-.54-2.285-1.14-2.936-2.215-.61-1.005-.366-1.931-.146-3.002.072-.347-.278-.64-.602-.463-1.261.69-1.205 2.32-.706 3.5.682 1.61 2.256 2.516 3.761 3.251l-.128-.976c-3.296 2.59-3.609 6.328-3.012 10.207.119.77 1.274.437 1.168-.32-.451-3.265-1.967-6.218-4.332-8.517v.834c1.967-1.876 3.238-4.194 3.743-6.858.071-.386-.465-.54-.595-.164h.005zM90.582 33.762c1.202 4.48.047 9.688-2.121 13.691-2.169 4.003-5.224 7.017-8.621 9.76-.295.238-.21.805.124.963 8.245 3.916 10.007 13.657 11.244 21.753l.756-.317c-1.18-2.471-.631-5.25.032-7.79a35.729 35.729 0 0 1 2.54-6.799 37.085 37.085 0 0 1 8.425-11.114c.26-.233.234-.67 0-.908-5.186-5.243-11.028-11.953-11.47-19.67-.023-.44-.716-.445-.69 0 .226 3.94 1.323 7.701 3.3 11.13 2.054 3.561 4.985 6.633 7.95 9.448V53c-3.836 3.546-6.912 7.84-8.967 12.639-1.8 4.206-3.843 9.942-1.831 14.39.165.362.823.193.77-.21-1.107-8.468-2.806-18.601-11.432-22.702l.125.963c3.694-2.984 7.102-6.49 9.218-10.786 2.166-4.398 2.593-8.996.998-13.628-.075-.215-.401-.127-.343.095h-.007zM11.288 151.46c-1.726 5.577-5.112 10.461-10.02 13.71a.57.57 0 0 0 .287 1.053c3.294.183 5.37 3.633 6.837 6.189 1.608 2.801 2.747 5.82 3.459 8.966.167.733 1.279.42 1.125-.31-1.245-5.958.873-12.239 5.422-16.281.234-.207.226-.627 0-.836a19.863 19.863 0 0 1-4.363-5.8c-1.112-2.254-1.47-4.55-2.017-6.963-.13-.569-.97-.418-.99.132-.197 4.961 3.004 10.212 6.532 13.464v-.836c-4.865 4.331-7.047 11.075-5.71 17.427l1.126-.309c-.839-3.681-2.272-7.213-4.297-10.406-1.646-2.595-3.793-5.389-7.124-5.569l.286 1.053c5.062-3.363 8.876-8.522 10.166-14.488.1-.465-.579-.659-.72-.198v.002zM58.778 106.394c1.63-2.641.406-4.956-2.726-5.101-3.132-.148-7.058 1.923-8.687 4.564l-.953 1.545-2.35-.111-6.852 11.112 5.995 3.717 10.116-2.958 6.821-11.062-2.349-.111.985-1.595zm-8.504-.402c.767-1.246 2.614-2.186 4.18-2.112 1.566.074 2.182 1.127 1.415 2.374l-.953 1.545-5.595-.265.953-1.545v.003zm.91 11.22-6.04 1.767-3.584-2.219 4.117-6.678 9.621.452-4.117 6.678h.003zM166.018 160.609a.762.762 0 0 0-.38.381l.162-.161c-.3.129-.329.51-.273.788a.99.99 0 0 0 .414.617.927.927 0 0 0 1.301-.268c.252-.383.252-.944-.069-1.291a.861.861 0 0 0-.239-.182c-.202-.106-.332-.043-.526-.008-.226.037-.472-.006-.69-.056-.279-.063-.539.236-.382.495.31.516.926.648 1.478.489l-.39-.05c.109.064-.096-.09-.037-.066.066.029-.035.087.005.011-.018.037.003.055.008-.006 0 .019-.008.114-.013.064.013-.029.013-.027 0 0-.019.032-.013.026.021-.016l-.029.032.042-.029-.037.021a.127.127 0 0 1 .075-.027c.018 0 .108.016.061 0-.048-.013.058.037.071.048-.045-.032-.026-.029 0 .01-.021-.031-.034-.063-.053-.095-.04-.069.029.08 0 .006-.018-.048-.026-.088-.01-.014-.032-.153-.056-.293-.181-.402l.133.318c-.006.058.005.008 0 .008.01 0-.085.09.013-.003a.39.39 0 0 0 .032-.513c-.13-.164-.321-.18-.504-.101h-.003zM119.754 73.317c-1.871-.283-3.477.52-5.104 1.352-1.847.948-3.573 1.95-4.836 3.644-1.943 2.603-1.176 5.63 2.049 6.574 3.761 1.1 8.374-.667 11.132-3.246 2.092-1.958 3.971-5.792.884-7.784-3.812-2.458-9.163.127-12.162 2.654-.077.063.021.177.104.132 3.047-1.645 8.268-4.283 11.625-2.045 1.882 1.254 1.264 3.484.167 5.056-1.305 1.868-3.381 3.18-5.502 3.945-1.874.674-4.074 1.05-6.025.481-1.927-.563-3.137-2.138-2.28-4.124.815-1.892 2.62-3.191 4.356-4.18 1.818-1.038 3.514-1.882 5.592-2.252.101-.019.104-.188 0-.204v-.002z"
                    fill={lineColor}
                />
                <Path
                    d="M123.489 74.072c4.624 3.447-1.489 9.744-5.133 10.813-1.917.56-4.921 1.317-6.848.576-.94-.362-1.667-1.17-2.119-2.058-.475-.931-.217-1.783-.127-2.757.008-.08-.101-.09-.138-.037-1.107 1.558.056 4.228 1.51 5.148 1.163.736 2.554.683 3.87.546 1.577-.167 3.18-.373 4.68-.908 2.691-.958 5.138-3.355 6.171-6.021.778-2.006.448-4.683-1.755-5.57-.167-.068-.236.18-.114.27l.003-.002zM156.707 79.807c-1.568 1.892-2.835 3.998-4.109 6.099-1.274 2.1-2.898 4.209-3.57 6.476-.071.244.266.46.441.257 1.502-1.74 2.466-4.167 3.61-6.162 1.258-2.193 2.614-4.334 3.692-6.62.018-.039-.035-.09-.066-.05h.002zM146.071 96.928c-.387.73-.931 1.5-1.104 2.315-.026.13.146.27.247.142.533-.666.783-1.571 1.107-2.352.061-.142-.181-.24-.252-.105h.002zM49.918 140.973a421.69 421.69 0 0 0-5.956-4.921c-.194-.159-.507-.066-.51.212a48.05 48.05 0 0 0 1.08 10.881l.513-.296c-3.525-3.021-4.13-8.487-8.305-10.866-.292-.167-.77.04-.73.418.279 2.593.395 5.191.355 7.797l.868-.236c-1.555-3.592-4.159-6.563-7.503-8.606-.292-.18-.658.053-.666.381-.043 1.841-.088 3.68-.117 5.522l.786-.212a23.01 23.01 0 0 0-4.46-5.813c-.19-.18-.536-.111-.602.159a11.53 11.53 0 0 0-.332 3.357l.568-.235c-1.009-.799-1.834-1.685-2.487-2.802-.08-.137-.305-.151-.385 0a4.996 4.996 0 0 0-.581 2.194l.287-.217a3.18 3.18 0 0 1-1.497-1.223c-.11-.161-.361-.143-.42.056a5.001 5.001 0 0 0-.212 1.558l.456-.061c-.215-.74-.546-1.286-1.096-1.831-.194-.193-.486.101-.3.299.48.503.757 1.001.948 1.657.071.246.459.203.456-.061a4.785 4.785 0 0 1 .191-1.437l-.419.056c.462.674 1.014 1.114 1.773 1.426.143.058.281-.088.287-.217.029-.786.154-1.27.515-1.971h-.385c.6 1.185 1.37 2.201 2.402 3.048.21.172.579.076.568-.236a10.974 10.974 0 0 1 .36-3.164l-.602.159a22.345 22.345 0 0 1 4.242 5.728c.199.386.772.182.786-.212.06-1.842.108-3.68.159-5.522l-.666.381c3.214 1.979 5.666 4.853 7.145 8.316.191.449.86.188.868-.236a63.737 63.737 0 0 0-.319-7.797l-.73.418c4.067 2.345 4.898 7.504 8.361 10.464.234.199.579.011.513-.296a47.247 47.247 0 0 1-1.073-10.721l-.51.212a409.394 409.394 0 0 0 6.066 4.813c.22.172.536-.127.313-.313l-.003-.01zM125.987 104.417c.111-.894.196-1.775.241-2.677l-.491.204a22.671 22.671 0 0 1 3.169 3.876c.168.256.513.188.616-.08.388-.997.085-1.987.029-3.021-.079-1.423.101-2.83.446-4.212l-.48.063c1.492 2.117 1.324 4.935 2.92 7.014.193.254.576.111.517-.217a26.64 26.64 0 0 1-.35-6.564l-.579.156c1.216 1.85.478 4.366 2.108 6.017.199.201.586.055.576-.238a44.358 44.358 0 0 1 .175-6.067l-.624.085c.51 1.711 1.253 3.222 2.386 4.611.138.169.409-.047.3-.23-.876-1.429-1.603-2.937-2.07-4.548-.106-.362-.589-.26-.624.085a41.243 41.243 0 0 0-.212 6.066l.576-.238c-1.54-1.534-.866-4.087-2.047-5.855a.313.313 0 0 0-.578.156c-.138 2.26.008 4.49.424 6.715l.473-.275c-1.574-2.019-1.545-4.783-2.909-6.934-.122-.19-.417-.16-.481.063-.329 1.111-.536 2.228-.573 3.389-.04 1.217.422 2.656-.043 3.805l.616-.08a18.885 18.885 0 0 0-3.347-3.942c-.183-.166-.486-.053-.491.204-.016.897.008 1.781.056 2.677.011.18.255.172.276 0l-.005-.008z"
                    fill={lineColor}
                />
            </G>
            <Defs>
                <ClipPath id="a">
                    <Path fill="#fff" transform="translate(1 33)" d="M0 0h222v157H0z" />
                </ClipPath>
            </Defs>
        </Svg>
    );
};
