import { BottomSheet, Box, Button, Text, VStack } from '@suite-native/atoms';
import { Video, VideoName } from '@suite-native/video-assets';
import { NetworkType } from '@suite-common/wallet-config';
import { isAddressBasedNetwork } from '@suite-common/wallet-utils';
import { Translation, TxKeyPath } from '@suite-native/intl';

type XpubHintBottomSheetProps = {
    networkType: NetworkType;
    isVisible: boolean;
    handleClose: () => void;
};

export const XpubHintBottomSheet = ({
    networkType,
    isVisible,
    handleClose,
}: XpubHintBottomSheetProps) => {
    const isAddressBased = isAddressBasedNetwork(networkType);
    const video: VideoName = isAddressBased ? 'xpubImportETH' : 'xpubImportBTC';
    const title = (
        <Translation
            id={
                isAddressBased
                    ? 'moduleAccountImport.xpubScanScreen.hintBottomSheet.title.address'
                    : 'moduleAccountImport.xpubScanScreen.hintBottomSheet.title.xpub'
            }
        />
    );

    const textTranslationTag: TxKeyPath = isAddressBased
        ? 'moduleAccountImport.xpubScanScreen.hintBottomSheet.text.address'
        : 'moduleAccountImport.xpubScanScreen.hintBottomSheet.text.xpub';

    return (
        <BottomSheet title={title} isVisible={isVisible} onClose={handleClose}>
            <Box paddingTop="sp8" justifyContent="space-between">
                <Video name={video} aspectRatio={1} />
                <VStack spacing="sp24" paddingTop="sp24">
                    <Text color="textSubdued" textAlign="center" variant="hint">
                        <Translation
                            id={textTranslationTag}
                            values={{
                                emphasized: chunks => (
                                    <Text color="textDefault" variant="hint">
                                        {chunks}
                                    </Text>
                                ),
                            }}
                        />
                    </Text>
                </VStack>
                <Box marginTop="sp32">
                    <Button
                        data-testID="@accounts-import/xpub-help-modal/confirm-btn"
                        onPress={handleClose}
                    >
                        <Translation id="generic.buttons.gotIt" />
                    </Button>
                </Box>
            </Box>
        </BottomSheet>
    );
};
