import * as React from 'react';
import Svg, { G, Path, Defs, ClipPath, SvgProps } from 'react-native-svg';

import { useIllustrationColors } from '@suite-native/atoms';

export const BiometricsSvg = (props: SvgProps) => {
    const { lineColor, fillColor } = useIllustrationColors();

    return (
        <Svg width={224} height={224} fill="none" {...props}>
            <G clipPath="url(#a)">
                <Path
                    d="m205.818 54.886-5.069 19.819-9.258 32.354-20.862 64.495-6.671 17.305s-8.03 13.18-22.478 7.603c-14.449-5.578-29.969-12.357-29.969-12.357l-20.47-11.959s-10.01-6.089-6.166-18.439c3.848-12.349 10.204-32.127 10.204-32.127l12.557-39.1 13.535-41.228 5.075-12.613s5.491-10.552 18.555-8.008c13.065 2.543 38.493 9.162 38.493 9.162l11.691 3.749s7.67 4.58 9.091 8.416c1.421 3.837 2.178 9.197 1.74 12.923l.002.005z"
                    fill={fillColor}
                />
                <Path
                    d="M109.826 182.706a.474.474 0 0 0-.216-.224.902.902 0 0 0-.369-.071c-.081-.005-.159-.012-.239 0a.543.543 0 0 0-.333.19c-.101.108-.158.319-.057.449.092.12.176.223.328.271.106.034.255.023.367.03.352.018.687-.287.519-.645z"
                    fill={lineColor}
                />
                <Path
                    d="M178.439 28.199a983.75 983.75 0 0 0-19.981-5.204c-4.674-1.165-9.375-2.353-14.178-2.844-4.384-.45-8.606.049-12.524 2.154-4.41 2.367-6.908 7.111-8.657 11.6-1.001 2.57-1.733 5.233-2.718 7.806-.569 1.484-1.065 2.997-1.572 4.502-2.124 6.274-4.169 12.574-6.219 18.874-2.895 8.893-5.769 17.793-8.641 26.696-3.076 9.536-6.143 19.074-9.214 28.612a9045.288 9045.288 0 0 1-7.805 24.146c-1.697 5.222-3.753 10.162-3.065 15.776.613 5.008 3.106 9.496 6.887 12.826 2.392 2.108 5.128 3.465 7.943 4.91 6.914 3.548 13.929 6.889 20.848 10.428.556.284 1.107.585 1.671.851.891.422 1.672-.904.776-1.328-.431-.204-1.046-.489-1.703-.796-1.343-.631-2.684-1.261-4.013-1.919a1685.612 1685.612 0 0 1-11.094-5.541c-3.168-1.598-6.345-3.185-9.458-4.892-3.73-2.043-6.882-5.164-8.742-9.012-1.68-3.473-2.167-7.506-1.55-11.302.318-1.947 1.013-3.793 1.62-5.664 2.375-7.328 4.724-14.662 7.084-21.993 2.952-9.167 5.897-18.335 8.849-27.504 2.924-9.086 5.854-18.172 8.797-27.254a3155.657 3155.657 0 0 1 6.939-21.238c.73-2.197 1.46-4.397 2.218-6.584a94.06 94.06 0 0 1 .681-1.922c.267-.723.29-.686.561-1.429 1.455-3.977 2.483-8.029 4.683-11.705 1.269-2.121 2.883-4.128 5.025-5.42a17.423 17.423 0 0 1 5.78-2.182c5.525-1.028 11.381.412 16.767 1.568 4.272.918 8.519 1.95 12.786 2.89 3.705.816 7.401 1.667 11.097 2.525.28.064.399-.358.119-.434l.003.003z"
                    fill={lineColor}
                />
                <Path
                    d="M167.698 26.087c2.968 1.339 6.106 2.148 9.242 3.002 2.513.683 5.02 1.387 7.534 2.073 3.452.94 7.01 1.887 10.153 3.641 2.1 1.172 3.801 2.775 4.809 4.982 1.965 4.295 2.399 9.49 1.398 14.078-1.278 5.862-3.06 11.662-4.722 17.422a693.467 693.467 0 0 1-6.404 20.94c-2.227 6.9-4.656 13.729-6.963 20.599-2.307 6.871-4.38 13.769-6.529 20.67a4837.818 4837.818 0 0 0-7.189 23.341c-2.365 7.727-5.044 15.356-7.394 23.083-.131.431.505.584.661.183 2.674-6.836 4.839-13.89 7.187-20.844a1602.26 1602.26 0 0 0 7.009-21.314c4.552-14.129 9.517-28.118 14.138-42.222 4.357-13.304 8.198-26.807 11.372-40.443 1.15-4.942.802-10.029-.906-14.815-.834-2.334-2.232-4.286-4.245-5.742-2.548-1.844-5.675-2.87-8.634-3.84-5.073-1.66-10.323-3.134-15.536-4.274-1.637-.358-3.225-.686-4.887-.878-.184-.02-.262.277-.097.353l.003.005zM161.04 181.548c-2.417 6.153-7.736 12.152-14.542 13.386-3.609.654-7.38-.33-10.785-1.481-3.404-1.151-7.02-2.672-10.647-3.64-.537-.142-.934.686-.392.929 5.691 2.55 11.384 5.729 17.729 6.206 5.64.424 10.865-2.358 14.579-6.479 2.247-2.493 3.792-5.534 4.742-8.735.134-.447-.521-.603-.684-.188v.002zM206.031 57.177c-4.692 16.537-9.923 32.939-15.155 49.311-5.287 16.544-10.753 33.028-16.136 49.54-3.044 9.339-6.211 18.684-8.737 28.178-.195.732.868 1 1.118.307 2.975-8.182 5.558-16.523 8.235-24.806 2.685-8.309 5.387-16.611 8.078-24.917 5.325-16.45 10.564-32.939 15.376-49.545 2.688-9.279 5.123-18.626 7.495-27.992.045-.177-.225-.253-.274-.076z"
                    fill={lineColor}
                />
                <Path
                    d="M192.871 32.78c2.888 2.147 6.021 4.177 8.432 6.874 2.77 3.1 3.879 7.15 3.927 11.244.051 4.314-.874 8.648-1.735 12.856-.87 4.254-2.059 8.378-3.157 12.57-.123.47.531.617.708.195 1.797-4.282 3.089-8.919 4.164-13.432 1.04-4.378 1.965-8.93 1.68-13.455-.25-3.997-1.533-7.811-4.217-10.836-2.615-2.947-6.102-4.743-9.66-6.26-.167-.072-.291.135-.142.245zM168.554 176.9c-.806 2.105-1.86 4.183-2.764 6.256a42.557 42.557 0 0 1-2.826 5.44c-1.96 3.167-4.701 6.052-8.241 7.418-3.046 1.177-6.499.847-9.662.399-3.163-.447-6.467-.878-9.522-2.089-.494-.197-.852.642-.365.865 5.064 2.321 10.64 4.066 16.271 3.632 6.021-.463 11.088-4.871 13.799-10.083a35 35 0 0 0 2.286-5.513c.652-2.06.914-4.133 1.412-6.218.062-.256-.296-.344-.388-.107zM173.173 39.262c.22-.363 1.108-.507 1.462-.322.496.26.606.966.202 1.347-.425.401-1.047.302-1.343-.19-.103-.17-.246-.567-.06-.735.117-.105-.069.033.092.003.117-.023.37.112.514.112a.714.714 0 0 0 .675-.514c.269-.954-.78-1.502-1.6-1.334-.886.18-1.421 1.043-1.451 1.906-.059 1.775 1.793 3.118 3.444 2.449 1.65-.67 2.089-2.683.872-3.938-.565-.58-1.373-.83-2.16-.61-.319.09-.682.255-.918.493-.296.296-.315.656-.457 1.025-.165.431.5.681.728.308zM167.989 37.438c-.95-.82-2.289-1.043-3.471-1.387l-4.148-1.206c-2.766-.805-5.541-1.578-8.312-2.356l-.542 1.961c2.957.83 5.913 1.66 8.87 2.493 1.442.406 2.886.81 4.327 1.215 1.442.406 2.652.84 4.123.64.457-.062.625-.775.28-1.057-1.088-.883-2.305-1.149-3.634-1.52-1.515-.422-3.03-.844-4.547-1.264-2.959-.823-5.918-1.647-8.877-2.468-1.265-.35-1.805 1.61-.542 1.961 2.775.77 5.548 1.55 8.331 2.296l3.953 1.06c1.317.352 2.605.887 3.918.664.45-.075.606-.743.273-1.032h-.002z"
                    fill={lineColor}
                />
                <Path
                    d="M174.036 39.317c-.085-.2.133-.39.328-.342.158.039.188.24.225.378.055.2.188 1.147-.147.645-.08-.122-.489-.833-.255-.94.216-.1.696.703.666.857-.069.353-.457-.062-.558-.218a2.534 2.534 0 0 1-.271-.543c-.018-.05-.03-.2-.062-.227l-.381.05.037.076c-.028.142.112.413.133.569.009.073-.021.29.021.346.025.034.496.011.537-.08.144-.314-.322-.294-.402-.117-.014.03.053.24.069.273.108.245-.138.094.14-.05l.381-.104h-.133l.381.103c-.119-.053-.445-.603-.427-.722l-1.432.188c.043.05.08.105.114.16.053.058.051.071-.009.04l.106-.393c.165-.12.183-.142.053-.066l.376-.101.016.004c-.567-.222-1.081.532-.778 1.012.328.516 1.031.66 1.49.206.459-.454.351-1.176-.014-1.651-.195-.255-.439-.424-.781-.374-.275.041-.608.257-.651.562-.127.88.312 1.874 1.347 1.848.934-.023 1.524-1.1 1.035-1.89-.454-.733-1.577-.756-2.034-.015-.456.74-.094 1.724.496 2.282.721.678 1.832.153 1.851-.812.016-.794-.37-1.773-1.222-1.963-1.946-.436-1.956 3.116-.098 2.98.987-.07 1.099-1.084.991-1.859-.108-.775-.381-1.658-1.226-1.807-.899-.16-1.494.722-1.382 1.534.106.766.627 1.66 1.307 2.05.679.39 1.641.296 2.098-.39.493-.74.204-1.616-.305-2.26-.51-.645-1.311-1.11-2.096-.703-.728.379-.907 1.29-.655 2.014.278.796.962 1.784 1.938 1.569.975-.216 1.129-1.303.948-2.126-.152-.695-.627-1.603-1.488-1.431-.335.066-.709.3-.789.658-.071.323.121.651.305.899.092.124.264.02.204-.12h.003z"
                    fill={lineColor}
                />
                <Path
                    d="M175.11 37.968c-.452-.743-1.898-.504-2.479-.062-.611.466-1.1 1.833-.248 2.31a.468.468 0 0 0 .679-.276c.138-.481-.172-.949.269-1.36.489-.458 1.118-.121 1.662-.325.112-.044.186-.17.115-.285l.002-.002zM175.36 27.889c-3.634-1.291-7.396-2.17-11.129-3.13a509.407 509.407 0 0 1-5.482-1.448c-1.556-.42-3.28-1.125-4.917-1.004-.422.032-.59.727-.108.796 3.625.518 7.163 1.722 10.709 2.63 3.547.908 7.215 1.828 10.913 2.266.067.007.072-.09.014-.11zM200.23 40.97a31.117 31.117 0 0 1 4.915 8.988l.489-.374a9.59 9.59 0 0 0-4.017-1.427c-.273-.034-.42.317-.301.523a35.848 35.848 0 0 1 3.324 7.598l.641-.371-3.554-3.101c-.312-.273-.891-.018-.744.433.953 2.927 1.945 5.837 2.934 8.75l.714-.549-3.971-2.56c-.331-.212-.877.15-.714.549 1.014 2.47 2.029 4.938 3.041 7.407l.813-.472-3.452-3.195c-.352-.323-.955-.009-.82.477l1.954 6.903.828-.481a4423.556 4423.556 0 0 1-3.5-3.204c-.352-.321-.999-.011-.838.488a76.95 76.95 0 0 1 1.994 7.509l.852-.496-3.331-2.667c-.353-.284-1.037-.036-.851.496a37.938 37.938 0 0 1 1.772 7.276l.732-.564a33.448 33.448 0 0 0-3.634-1.745c-.374-.154-.663.28-.601.6.539 2.725 1.063 5.452 1.595 8.179l.597-.596c-1.168-.246-2.521-.76-3.712-.764-.656 0-1.157.34-1.18 1.025-.034 1.108.569 2.5.829 3.578.36 1.497.721 2.995 1.083 4.492l.363-.637c-1.506.45-3.586-1.035-4.777.628-.432.6-.296 1.266-.101 1.926.365 1.236.695 2.466.877 3.745.172 1.207.652 3.122-.709 3.697-.634.268-1.217.516-1.61 1.119-1.166 1.791.232 3.965-.548 5.825-.232.551.739.966.973.411.331-.782.406-1.511.335-2.358-.078-.933-.376-1.983-.034-2.901.558-1.486 2.653-1.02 2.858-2.866.218-1.957-.342-4.268-.886-6.133-.166-.569-.682-1.497-.12-2.038.365-.351 1.109-.228 1.536-.15.87.163 1.607.358 2.479.097a.53.53 0 0 0 .363-.638l-1.41-5.77c-.114-.47-.339-1.013-.367-1.495-.032-.567-.225-.62.599-.461.969.188 1.935.401 2.902.605.376.08.67-.224.597-.596-.531-2.727-1.065-5.451-1.589-8.18l-.601.6a31.537 31.537 0 0 1 3.39 1.668c.416.234.79-.151.733-.564a37.095 37.095 0 0 0-1.752-7.281l-.852.495 3.331 2.667c.393.314.962.03.852-.495a75.378 75.378 0 0 0-2.009-7.504l-.838.489 3.508 3.194c.356.323.969.011.829-.481-.657-2.3-1.311-4.6-1.967-6.901l-.82.477 3.457 3.188c.322.298 1.01.009.813-.473-1.015-2.468-2.03-4.937-3.042-7.407l-.714.548 3.972 2.56c.346.222.849-.15.713-.549-.991-2.915-1.981-5.827-3.011-8.728l-.744.433c1.214 1.005 2.429 2.007 3.641 3.011.271.225.766.023.64-.371-.881-2.706-2.013-5.29-3.459-7.745l-.301.523a8.82 8.82 0 0 1 3.682 1.305c.237.147.585-.099.489-.374-1.194-3.357-2.922-6.412-5.255-9.111-.181-.211-.466.09-.3.3l-.003-.009zM120.804 165.309c-1.564-1.346-3.549-1.488-5.172-.181-.136.11.011.337.167.287 1.538-.484 3.375-.656 4.848.096.124.062.274-.101.157-.202zM113.717 166.504c-1.889 2.408-2.456 6.031-.59 8.637a5.622 5.622 0 0 0 3.336 2.199c1.005.225 3.197.406 3.769-.67a.24.24 0 0 0-.142-.346c-.443-.142-.682.007-1.123.112a4.966 4.966 0 0 1-2.112.058 4.708 4.708 0 0 1-3.081-2.106c-1.441-2.275-1.076-5.504.012-7.834.018-.041-.034-.094-.067-.052l-.002.002zM123.012 173.356c.721-1.19 1.189-2.637 1.026-4.043-.126-1.075-.679-2.77-1.869-3.057-.289-.068-.498.177-.45.45.083.468.333.789.567 1.197.303.527.473 1.057.618 1.642.314 1.277.337 2.472-.09 3.729-.039.117.136.186.198.082zM133.101 67.449c-1.784-.876-3.822-1.438-5.757-1.87a24.502 24.502 0 0 0-3.079-.497c-.723-.066-1.595-.202-2.213.284-.617.487-.723 1.36-.927 2.05a69.02 69.02 0 0 1-1.015 3.099c-.355 1.025-.72 2.052-1.044 3.091-.269.86-.698 1.762-.521 2.667.03.15.236.193.337.09.466-.482.59-1.053.82-1.679.303-.819.629-1.628.945-2.442.317-.814.632-1.629.935-2.445.303-.816.516-1.869.925-2.674.611-1.202 1.972-.782 3.053-.6.831.14 1.655.325 2.47.536 1.602.413 3.214.968 4.855 1.186.42.054.579-.615.216-.794v-.002zM112.539 130.62c-1.462-.77-3.131-1.185-4.692-1.713-1.111-.376-4.653-1.321-4.531-2.777.069-.821.599-1.848.826-2.644.228-.796.459-1.674.684-2.513.225-.84.434-1.681.664-2.521.206-.752.528-1.456.42-2.236-.021-.16-.239-.179-.338-.089-.665.614-.858 1.646-1.143 2.483-.326.961-.615 1.931-.909 2.904a73.076 73.076 0 0 1-1.063 3.307c-.245.69-.665 1.463-.413 2.21.478 1.413 2.893 2.138 4.139 2.626 1.91.75 3.999 1.42 6.026 1.743.441.071.79-.534.328-.777l.002-.003zM170.668 78.473c1.759.708 3.685 1.073 5.507 1.596.918.264 1.827.552 2.72.892.719.273 2.168.62 2.493 1.36.308.697-.42 1.968-.645 2.722-.289.97-.551 1.95-.812 2.926-.262.977-.51 1.961-.776 2.938-.23.842-.664 1.725-.56 2.6.02.17.206.271.344.143.709-.668.914-1.791 1.214-2.693.391-1.167.735-2.348 1.089-3.527a61.72 61.72 0 0 1 1.143-3.51c.282-.773.691-1.633.172-2.402-.436-.647-1.361-.951-2.039-1.25a29.34 29.34 0 0 0-3.025-1.133c-2.153-.68-4.458-1.297-6.712-1.5-.519-.045-.521.673-.113.838zM148.844 144.938c1.894 1.114 4.026 2.004 6.088 2.765 1.083.402 2.19.75 3.322.989.762.16 1.74.445 2.481.064.689-.355.845-1.105 1.042-1.791.34-1.179.728-2.342 1.137-3.497.408-1.156.828-2.305 1.205-3.472.312-.968.845-2.046.656-3.069-.027-.149-.238-.193-.337-.089-.54.573-.691 1.355-.962 2.084-.353.95-.739 1.885-1.104 2.83-.365.945-.737 1.885-1.084 2.835-.172.474-.342.951-.5 1.431-.119.36-.179 1.007-.413 1.298-.606.754-2.424.025-3.168-.191a29.264 29.264 0 0 1-2.697-.942c-1.747-.695-3.504-1.582-5.335-2.023-.464-.112-.753.528-.329.778h-.002zM110.515 94.826c-.26.964-.604 1.9-.895 2.853-.209.681-.577 1.42-.258 2.094.046.099.205.14.292.076.595-.425.686-1.241.916-1.908.324-.943.615-1.897.858-2.862.15-.59-.755-.84-.913-.253zM170.122 113.799a37.484 37.484 0 0 0-1.029 2.88c-.231.737-.695 1.581-.498 2.349.035.13.198.199.312.126.673-.42.831-1.312 1.079-2.03.354-1.025.652-2.061 1.047-3.073.223-.571-.686-.805-.913-.252h.002z"
                    fill={lineColor}
                />
                <Path
                    d="M110.294 97.526c6.653 2.502 13.496 4.52 20.266 6.685 10.318 3.3 20.646 6.581 31.027 9.682 1.809.541 3.618 1.092 5.449 1.557.82.209 1.715.521 2.569.546.503.014.503-.766 0-.78.014 0-.014.005-.181-.03-.168-.034-.328-.078-.491-.119a36.633 36.633 0 0 1-1.373-.39c-1.517-.451-3.035-.903-4.55-1.36a1075.302 1075.302 0 0 1-13.886-4.3c-10.293-3.238-20.587-6.469-30.873-9.73-2.578-.817-5.172-1.677-7.81-2.284-.346-.08-.468.403-.144.525l-.003-.002zM133.535 90.882c4.908-3.332 9.818-6.587 15.052-9.396.161-.087.018-.332-.142-.245-5.188 2.786-10.395 5.838-14.995 9.53-.062.051.021.157.085.113v-.002zM130.206 96.43c1.837-1.044 3.526-2.397 5.273-3.585 1.71-1.163 3.439-2.3 5.184-3.41a229.165 229.165 0 0 1 10.931-6.527c.172-.096.019-.365-.156-.266a228.279 228.279 0 0 0-11.074 6.708 250.364 250.364 0 0 0-5.346 3.55c-1.632 1.114-3.359 2.185-4.828 3.511-.009.01.003.025.014.018h.002zM130.551 100.151c2.291-1.268 4.274-3.047 6.487-4.446.05-.032.005-.113-.048-.083-2.268 1.26-4.578 2.695-6.554 4.38-.085.071.023.2.115.149zM140.082 93.97c4.786-3.074 9.57-6.15 14.356-9.225.166-.108.01-.376-.156-.266l-14.223 9.45c-.025.017 0 .058.023.042z"
                    fill={lineColor}
                />
                <Path
                    d="M131.161 103.713c.824-.745 1.91-1.255 2.826-1.878a196.273 196.273 0 0 1 3.868-2.548c2.179-1.404 4.284-2.943 6.554-4.197.053-.03.007-.108-.048-.083-2.346 1.18-4.626 2.592-6.813 4.037a139.552 139.552 0 0 0-3.82 2.589c-.902.637-1.697 1.406-2.583 2.059-.014.012 0 .032.016.021zM145.947 94.345a51.968 51.968 0 0 0 5.089-2.931c1.509-.98 3.228-1.917 4.527-3.165.081-.078-.02-.192-.115-.149-1.68.81-3.213 2.096-4.777 3.114-1.563 1.019-3.156 2.073-4.738 3.11-.014.01 0 .028.012.02h.002zM135.729 105.227c7.126-4.472 13.955-9.403 21.381-13.393.053-.03.005-.113-.048-.083-7.268 4.204-14.588 8.421-21.452 13.271-.122.088-.011.287.119.205zM140.068 106.765c2.874-1.676 5.659-3.508 8.468-5.293 2.81-1.784 5.746-3.462 8.636-5.171.106-.062.014-.216-.096-.163-3.014 1.454-5.833 3.346-8.684 5.089-2.835 1.734-5.691 3.495-8.347 5.497-.023.018-.002.057.023.041zM144.967 108.277c.652-.124 1.26-.748 1.811-1.108.666-.436 1.322-.888 1.995-1.314.078-.051.011-.161-.071-.122-.769.354-1.522.723-2.243 1.168-.542.334-1.292.656-1.612 1.222-.048.085.03.174.12.156v-.002zM150.428 104.472c1.908-1.325 3.909-2.465 5.929-3.605.161-.089.019-.33-.142-.245-2.048 1.082-3.962 2.424-5.799 3.829-.011.01.001.03.012.021zM149.278 81.394c-3.152-2.022-7.927-.222-10.592 1.824-3.276 2.513-5.319 6.286-6.724 10.09l.655-.266c-1.977-1.197-2.613 2.326-2.923 3.456-.333 1.206-1.492 4.731 1.047 4.355.537-.08.395-.929-.126-.929-1.143 0-.209-2.97-.103-3.435.105-.466.482-3.355 1.655-2.676.261.151.56.004.654-.266 1.221-3.523 2.998-6.954 5.883-9.407a12.4 12.4 0 0 1 4.943-2.578c1.951-.498 3.579-.209 5.514.115.167.027.273-.182.119-.283h-.002z"
                    fill={lineColor}
                />
                <Path
                    d="M130.509 99.95c-.523 1.158-.369 2.642-.31 3.885.067 1.366.239 2.733.519 4.072.299 1.422.907 2.693 1.32 4.067.413 1.373-.473 3.293-1.251 4.41-.259.373.36.738.613.357.73-1.091 1.21-2.437 1.549-3.701.34-1.264-.484-2.424-.833-3.573a25.743 25.743 0 0 1-.987-4.795c-.156-1.5.129-3.243-.296-4.683-.039-.133-.259-.188-.324-.042v.003z"
                    fill={lineColor}
                />
                <Path
                    d="M131.324 116.292c-2.465 1.068-5.303 1.013-7.947.986-2.645-.028-4.981-.489-7.486-.573-1.862-.062-3.687.383-4.956 1.83-1.27 1.447-1.791 3.403-2.252 5.233-.168.665.854.947 1.026.282.478-1.835.992-3.967 2.527-5.226 1.791-1.47 4.309-.987 6.424-.764 2.465.259 4.965.33 7.437.156 1.88-.131 4.031-.284 5.514-1.555.221-.19-.062-.47-.287-.371v.002zM149 81.63c1.589.638 3.019 1.152 4.293 2.36a11.22 11.22 0 0 1 2.817 4.344c1.432 3.967.792 8.318-.404 12.253-.09.294.151.537.426.56 1.398.112.214 2.24.039 2.646-.19.443-.383.883-.576 1.323-.282.647-.95 2.869-2.004 2.083-.438-.328-.943.371-.574.743 1.683 1.685 2.893-1.374 3.327-2.509.477-1.252 2.461-5.011-.212-5.171l.427.559c1.201-4.25 1.796-9.043.033-13.23-1.21-2.874-4.126-6.32-7.548-6.265-.184.002-.195.24-.042.302l-.002.003z"
                    fill={lineColor}
                />
                <Path
                    d="M153.442 107.128c-1.139.812-1.896 2.327-2.828 3.373a26.654 26.654 0 0 1-3.448 3.227c-.657.516-1.338.995-2.048 1.435-.447.28-.941.514-1.239.971-.358.548-.469 1.291-.657 1.905-.266.874-.473 1.679-.509 2.594-.019.456.7.456.709 0 .043-1.796.585-3.699 2.167-4.662a21.914 21.914 0 0 0 3.264-2.411 26.336 26.336 0 0 0 2.86-3.034c.74-.922 1.77-2.013 1.988-3.199.026-.135-.121-.298-.261-.199h.002z"
                    fill={lineColor}
                />
                <Path
                    d="M142.593 120.42c.501 2.055 2.353 3.609 3.9 4.928a50.97 50.97 0 0 0 5.868 4.298c1.793 1.128 3.912 2.128 5.112 3.949 1.573 2.387.507 5.229-.452 7.632-.255.638.771.908 1.026.282.914-2.231 1.855-4.763 1.04-7.171-.647-1.913-2.257-3.202-3.907-4.245-2.137-1.351-4.304-2.608-6.324-4.139-2.154-1.631-4.477-3.333-5.829-5.718-.135-.236-.496-.075-.432.181l-.002.003z"
                    fill={lineColor}
                />
                <Path
                    d="M109.427 124.518c12.051 4.373 24.273 8.283 36.254 12.852 3.9 1.486 7.743 3.199 11.698 4.531.413.14.709-.532.301-.713-6.182-2.74-12.775-4.66-19.12-6.99-6.06-2.227-12.123-4.449-18.209-6.602a572.556 572.556 0 0 0-10.754-3.693c-.395-.13-.554.477-.17.615z"
                    fill={lineColor}
                />
                <Path
                    d="m66.848 92.31 6.093 3.54s6.363 4.886 8.218 10.308c1.852 5.421 3.572 14.129 1.28 23.919-2.292 9.792-8.275 20.482-15.517 27.398 0 0-5.719 6.412-12.591 8.827-6.873 2.415-11.228 3.064-17.465 1.356l-4.651-1.808-2.048-.667-3.083-1.555 4.295.819 35.47-72.134v-.002z"
                    fill={fillColor}
                />
                <Path
                    d="M67.264 93.914s14.616 10.253 6.046 37.842c-8.57 27.588-30.604 32.241-30.604 32.241s-16.134 5.344-26.241-10.342c-10.108-15.687.966-36.439 2.702-39.838 1.735-3.398 12.605-21.729 29.367-24.706 0 0 9.405-3.339 18.73 4.803z"
                    fill={fillColor}
                />
                <Path
                    d="M13.62 128.49c-1.42 5.669-2.332 12.028-.901 17.782 1.133 4.56 3.41 8.862 6.737 12.203 6.478 6.506 16.32 8.676 25.026 6.013 10.776-3.291 19.6-12.26 25.054-21.832 5.439-9.543 8.983-21.025 7.009-32.042-.978-5.454-2.984-10.818-6.614-15.074-3.322-3.897-7.929-6.637-13.014-7.422a22.381 22.381 0 0 0-3.796-.252c-.634.01-.636.993 0 .984 10.878-.177 19.443 8.357 21.532 18.684 1.003 4.96.716 10.338-.066 15.312-.834 5.284-2.496 10.442-4.835 15.251-4.646 9.554-12.368 18.502-22.028 23.21-7.93 3.865-17.69 3.874-24.893-1.552-3.531-2.658-6.199-6.38-7.766-10.497-.861-2.263-1.311-4.586-1.745-6.958-.51-2.795-.707-5.536-.47-8.373.153-1.825.433-3.637.787-5.432 0-.01-.014-.014-.016-.005z"
                    fill={lineColor}
                />
                <Path
                    d="M82.966 112.99c-.131-1.571-.106-3.041-.6-4.548-.466-1.424-1.079-2.78-1.664-4.156-1.086-2.557-2.59-4.98-4.587-6.94-1.485-1.456-3.291-2.866-5.171-3.774-1.456-.704-3.035-1.053-4.504-1.74-1.38-.647-2.755-1.305-4.13-1.961-.418-.2-.783.422-.365.623 1.035.496 2.068.996 3.104 1.493.84.406 1.714.782 2.525 1.246.681.39 1.274.908 1.958 1.288 1.487.828 2.986 1.58 4.281 2.72 2.064 1.817 3.675 3.883 5.183 6.162.97 1.464 1.667 2.959 2.216 4.628.243.741.378 1.56.688 2.273.393.906.788 1.725 1.05 2.69 0 .007.01.005.01 0l.006-.004zM17.75 155.586c2.796 3.859 6.185 7.272 10.565 9.265 1.526.692 3.142 1.183 4.715 1.763 2.408.885 4.802 1.738 7.33 2.234 7.256 1.422 14.572-.963 20.589-5.025 2.7-1.821 5.227-3.976 7.527-6.277 2.3-2.3 4.561-4.85 6.235-7.666 1.894-3.188 3.58-6.649 5.043-10.054a56.759 56.759 0 0 0 3.34-10.426c.133-.616-.815-.88-.95-.261-1.306 6.015-3.524 12.359-7.176 17.372-3.687 5.064-7.681 10.166-12.745 13.93-5.652 4.203-12.133 7.414-19.336 7.116-2.819-.117-5.434-.597-8.069-1.601-1.664-.633-3.351-1.222-5.004-1.883-1.394-.557-2.695-1.309-3.953-2.126-1.258-.816-2.431-1.559-3.653-2.337-1.687-1.073-3.138-2.536-4.446-4.036-.007-.007-.018.002-.014.009l.002.003zM52.202 92.98s.012-.016 0-.016a.008.008 0 0 0 0 .016zM38.344 92.994c-1.208.197-2.348 1.053-3.342 1.73a43.955 43.955 0 0 0-3.072 2.292 47.278 47.278 0 0 0-5.736 5.58c-1.637 1.878-3.214 3.802-4.548 5.91-1.442 2.277-2.431 4.676-3.528 7.128-.032.073.07.14.112.064 1.143-2.176 2.578-4.174 3.923-6.226 1.426-2.175 2.895-4.355 4.591-6.328a47.073 47.073 0 0 1 5.227-5.21 42.331 42.331 0 0 1 3.393-2.594c1.001-.688 2.262-1.296 3.051-2.229.048-.057 0-.133-.071-.122v.005zM48.984 88.877c.776.205 1.648.079 2.459.124.955.055 1.914-.08 2.871-.094 1.885-.025 3.666.597 5.512.594.12 0 .18-.149.096-.234-1.29-1.323-3.434-1.421-5.201-1.472-.994-.03-2.034-.034-3.014.154-.87.167-1.982.38-2.737.825-.041.026-.034.092.014.103zM83.576 122.181c-.397.947-.532 1.709-.592 2.747-.046.776-.19 1.679.135 2.399.032.074.152.085.202.026.528-.615.593-1.574.68-2.358.12-1.073.041-1.83-.347-2.816-.016-.039-.062-.037-.078 0v.002zM205.407 37.014c1.724 2.144 3.336 4.096 4.256 6.745.427 1.234.719 2.516.845 3.816.117 1.208-.023 2.477.213 3.662.067.333.599.41.749.099 1.122-2.392.259-5.924-.604-8.274-.937-2.55-2.527-5.31-4.83-6.855-.523-.353-.966.387-.627.81l-.002-.003zM148.566 203.943c.041 0 .041-.065 0-.065s-.041.065 0 .065zM151.697 202.991c1.398.422 3.191-.124 4.534-.541a17.892 17.892 0 0 0 4.543-2.142c2.466-1.633 5.386-4.284 6.152-7.266.094-.367-.413-.731-.684-.396-.98 1.215-1.726 2.561-2.789 3.726a17.205 17.205 0 0 1-3.457 2.938c-1.279.823-2.642 1.507-4.082 1.988-1.386.464-2.972.5-4.295 1.085-.277.122-.172.534.081.61l-.003-.002zM161.233 204.277c6.226-2.598 11.694-8.07 13.117-14.805.101-.482-.553-.647-.725-.2-2.408 6.229-6.472 11.575-12.598 14.515-.271.13-.076.61.206.49z"
                    fill={lineColor}
                />
                <Path
                    d="M78.898 110.616a78.113 78.113 0 0 0-3.285-1.449l-.08.587c2.141-.076 4.095-.321 6.147-.998.376-.124.489-.665.115-.874-2.326-1.298-4.734-2.431-7.146-3.559v.482a44.905 44.905 0 0 1 4.077-2.59c.192-.107.124-.364-.058-.433l-6.354-2.438.074.56c1.212-.75 3.126-.362 3.668-1.986.05-.152-.06-.303-.2-.349a49.29 49.29 0 0 1-6.053-2.488l.069.525.525-.21c.237.004.354-.216.322-.42-.11-.712-.588-1.168-1.288-1.303-.326-.064-.462.401-.138.502.512.195.774.52.785.977l.322-.42c-.446-.013-.69.09-1.001.402-.145.144-.129.429.069.525a39.086 39.086 0 0 0 6.239 2.458l-.2-.348c-.395 1.32-2.445 1.016-3.43 1.607-.238.142-.17.473.074.56l6.39 2.307-.056-.433a131.586 131.586 0 0 0-4.119 2.52c-.167.108-.193.378 0 .482 2.349 1.242 4.69 2.495 6.944 3.903l.115-.874c-1.949.534-3.969 1.05-5.973 1.332-.319.046-.248.491 0 .578 1.113.388 2.234.732 3.363 1.067.113.034.193-.142.083-.195v-.007zM41.799 104.988c.773.112 1.554-.025 2.337-.007.844.021 1.685.142 2.525.239 1.848.213 3.705.458 5.528.839 1.691.353 3.349.844 4.91 1.589 1.56.746 2.872 1.823 4.394 2.571.376.186.96-.234.647-.647-2.066-2.726-6.168-4.089-9.389-4.756-1.87-.388-3.776-.619-5.672-.842-1.566-.183-3.986-.47-5.345.542-.153.114-.183.435.063.472h.002zM36.374 107.795h-.013v.413c1.15.08 2.284.048 3.445.025.928-.018 1.857 0 2.785.048.82.044 1.542.236 2.31-.133.084-.041.116-.172.066-.25-.914-1.357-3.625-.906-5.016-.795-1.253.098-2.472.249-3.643.697-.246.094-.14.495.11.399l.011-.005c.216-.082.184-.383-.055-.401v.002zM47.334 108.419c1.377.69 2.83 1.075 4.278 1.617a31.71 31.71 0 0 1 4.445 2.071c1.425.8 2.667 1.644 3.918 2.589 1.006.759 2.163 2.298 3.453 2.467.17.023.365-.176.344-.344-.174-1.364-1.926-2.442-2.936-3.238a27.966 27.966 0 0 0-4.084-2.662c-2.748-1.482-6.154-3.071-9.324-2.84-.168.012-.267.253-.092.34h-.002zM31.772 113.437c1.951-.099 3.84-.691 5.791-.874a33.614 33.614 0 0 1 5.496-.06c2.192.156 4.46.553 6.588 1.122a20.047 20.047 0 0 1 6.164 2.848c1.212.842 2.323 1.821 3.352 2.878.624.64 1.216 1.312 1.78 2.007.623.766 1.135 1.676 1.874 2.33.335.298 1.017.016.827-.482-.623-1.635-2.16-3.199-3.347-4.472a25.217 25.217 0 0 0-3.352-3.016 20.392 20.392 0 0 0-6.74-3.286 37.158 37.158 0 0 0-6.937-1.22c-1.965-.156-3.91-.041-5.856.259-1.947.301-4.036.654-5.714 1.704-.112.071-.073.268.071.262h.003z"
                    fill={lineColor}
                />
                <Path
                    d="M28.347 119.278c1.802-.736 3.418-1.812 5.275-2.468a20.787 20.787 0 0 1 5.771-1.144c3.726-.211 7.706-.17 10.977 1.811.439.267.87-.332.535-.692-1.063-1.138-3.02-1.647-4.506-1.888-2.194-.355-4.575-.35-6.79-.24-2.215.11-4.238.484-6.251 1.197-1.843.653-3.919 1.559-5.232 3.045-.133.152-.007.47.22.379zM53.458 118.762c.367.353.815.552 1.212.869.473.378.884.825 1.293 1.27.84.92 1.625 1.89 2.341 2.911a29.35 29.35 0 0 1 1.736 2.802c.525.966.863 2.218 1.673 2.954.269.245.707.076.716-.296.032-1.156-.78-2.302-1.334-3.273a29.822 29.822 0 0 0-2.256-3.391 27.332 27.332 0 0 0-2.378-2.75c-.714-.711-1.688-1.711-2.769-1.665-.28.011-.452.36-.236.569h.002z"
                    fill={lineColor}
                />
                <Path
                    d="M26.715 124.986c1.411-.493 2.6-1.546 3.875-2.319 1.297-.786 2.658-1.474 4.088-1.988 2.998-1.076 6.161-1.415 9.32-.956 2.881.419 5.695 1.465 8.058 3.185 1.166.849 2.235 1.876 3.078 3.048.604.837.96 2.19 1.797 2.784.127.089.31-.005.347-.142.294-1.094-.824-2.578-1.426-3.408a14.623 14.623 0 0 0-2.878-2.954c-2.5-1.942-5.542-3.162-8.664-3.653-3.122-.491-6.682-.321-9.809.816a23.546 23.546 0 0 0-4.208 2.051c-1.333.814-2.986 1.807-3.847 3.183-.106.167.071.415.266.346l.003.007zM58.642 131.201c.16.86.355 1.731.399 2.607.037.729-.096 1.454.034 2.172.06.328.611.417.749.099.645-1.505.096-3.72-.67-5.094-.164-.291-.568-.082-.513.216zM49.856 131.932c.042 0 .042-.064 0-.064-.041 0-.041.064 0 .064zM45.12 143.222l.154-.153s-.007-.028-.016-.016l-.154.153s.007.028.017.016zM55.24 83.761c5.075.862 9.262 3.426 13.137 6.701.44.372.973-.181.624-.624-3.255-4.123-8.53-6.338-13.645-6.944-.489-.057-.605.782-.117.867zM29.69 170.421c3.379 2.766 7.522 4.24 11.9 3.876.33-.028.335-.496 0-.516-4.086-.248-8.085-1.587-11.366-4.053-.397-.298-.922.377-.534.693zM33.489 175.783c2.435 1.977 5.596 2.667 8.617 1.717.287-.089.255-.58-.073-.548-2.828.271-5.633-.309-8.087-1.759-.356-.211-.797.315-.457.592v-.002z"
                    fill={lineColor}
                />
                <Path
                    d="M24.704 132.662c1.737-1.659 3.308-3.463 5.144-5.021a23.06 23.06 0 0 1 2.9-2.123 9.341 9.341 0 0 1 1.744-.851c.457-.165.617-.19.863-.615.094-.162.03-.355-.12-.456-.796-.53-1.86.174-2.593.599-1.109.639-2.08 1.518-3.042 2.355-1.96 1.701-3.941 3.571-5.303 5.8-.156.254.195.513.407.312zM38.266 123.188c.562.378 1.118.165 1.763.092.732-.085 1.48-.12 2.217-.111 1.376.017 2.746.28 4.004.842 2.69 1.197 4.819 3.543 6.13 6.142 1.31 2.598 1.774 5.279 1.716 8.049a16.067 16.067 0 0 1-.624 4.135c-.388 1.346-1.226 2.52-1.62 3.837-.109.358.339.566.594.346 1.04-.908 1.63-2.607 2.091-3.889.53-1.475.84-3.028.957-4.589.232-3.073-.48-6.24-1.942-8.949-1.506-2.786-3.916-5.233-6.861-6.469a11.542 11.542 0 0 0-4.445-.879c-1.145-.004-3.454-.039-4.083 1.046-.083.142-.028.31.103.397z"
                    fill={lineColor}
                />
                <Path
                    d="M25.65 140.018c.817-.559 1.195-1.674 1.691-2.504.592-.991 1.185-1.979 1.844-2.928 1.405-2.021 3.087-3.897 5.11-5.321 2.414-1.699 4.958-2.504 7.91-2.018 1.19.197 2.404.47 3.503.979 1.1.509 1.738 1.358 2.65 2.131.367.312.989.023.844-.491-.615-2.202-3.813-3.19-5.769-3.598-3.076-.645-5.79-.386-8.53 1.208-2.259 1.312-4.167 3.154-5.762 5.208a29.906 29.906 0 0 0-2.424 3.622c-.54.958-1.506 2.364-1.426 3.508.012.165.198.312.356.204h.002zM50.026 132.595c.365 3.364.101 6.696-1.57 9.701-.753 1.355-1.671 2.632-2.358 4.025-.5 1.013-.936 2.325-.117 3.27.308.353.81.039.845-.349.083-.906.076-1.571.508-2.415.348-.683.78-1.334 1.172-1.993.74-1.231 1.493-2.449 2.016-3.79 1.068-2.732 1.276-5.789.18-8.536-.132-.326-.722-.33-.678.092l.002-.005z"
                    fill={lineColor}
                />
                <Path
                    d="M28.035 144.263c3.565-4.109 4.577-11.216 10.252-13.216 2.582-.91 5.32-.119 6.719 2.284 1.237 2.126.858 4.3 1.134 6.591.02.172.239.259.34.092 1.175-1.94.52-5.004-.485-6.924-1.228-2.346-3.634-3.683-6.285-3.396-7.084.764-8.999 9.217-11.997 14.322-.115.195.165.426.322.247zM45.166 143.098a10.85 10.85 0 0 0-3.041 4.069c-.496 1.144-1.387 3.077-.416 4.146.14.156.469.135.558-.071.282-.647.163-1.236.3-1.938.16-.796.455-1.571.781-2.312.574-1.295 1.318-2.492 2.14-3.644.145-.201-.156-.385-.322-.247v-.003z"
                    fill={lineColor}
                />
                <Path
                    d="M31.262 147.334c1.01-2.383 1.839-4.804 3.205-7.029a23.037 23.037 0 0 1 2.444-3.291c.912-1.02 1.913-2.199 3.235-2.559 1.912-.523 2.823 1.176 2.488 2.825-.303 1.5-1.09 2.947-1.724 4.33-1.278 2.793-2.722 5.504-4.145 8.226-.38.725.654 1.33 1.097.64 2.11-3.3 3.815-6.852 5.33-10.46.597-1.422 1.228-2.951.852-4.52-.315-1.314-1.297-2.33-2.658-2.518-3.067-.424-5.48 2.947-7.013 5.126-1.844 2.619-3.471 5.841-3.637 9.086-.013.263.411.401.521.142l.005.002z"
                    fill={lineColor}
                />
                <Path
                    d="M39.177 137.124c-1.047.938-1.804 2.069-2.479 3.303-.548 1.006-1.276 2.215-1.067 3.387.055.31.431.321.629.165.886-.697 1.237-2.041 1.73-3.032.572-1.146 1.215-2.233 1.727-3.408.151-.348-.234-.692-.542-.417l.002.002zM34.639 146.059c-.326.755-.58 1.537-.92 2.282-.189.41-.634 1.268.05 1.502.684.234 1-.787 1.162-1.236.28-.78.454-1.516.452-2.346 0-.365-.579-.58-.742-.202h-.002zM74.026 95.806c1.146 1 2.209 2.08 3.17 3.258 1.04 1.276 1.83 2.695 2.797 4.018.043.06.165.028.133-.055-1.162-2.855-3.66-5.387-5.985-7.334-.078-.066-.193.046-.115.115v-.002z"
                    fill={lineColor}
                />
                <Path
                    d="M77.261 100.131c3.083 3.749 5.851 7.772 8.613 11.762 3.861 5.58 7.7 11.173 11.478 16.808 7.077 10.552 14.024 21.193 20.954 31.84 1.478 2.273 3.145 4.525 4.589 6.773.119.185.418.013.298-.175-1.159-1.805-2.245-3.804-3.432-5.641a1782.675 1782.675 0 0 0-8.964-13.769c-7.635-11.605-15.247-23.259-23.325-34.563-3.21-4.49-6.421-9.031-10.011-13.232-.117-.138-.31.06-.198.197h-.002zM120.209 176.794c-.705.142-1.885-.096-2.674-.169-2.066-.195-4.13-.422-6.194-.631a1750.913 1750.913 0 0 1-19.113-2.066 14638.825 14638.825 0 0 1-41.915-4.775c-3.15-.362-6.303-.688-9.453-1.06-.356-.041-.353.519 0 .56 8.58 1.011 17.616 2.121 26.346 3.139 14.173 1.652 28.355 3.25 42.556 4.674 2.463.248 4.924.48 7.394.647.971.064 2.201.323 3.168.096.271-.064.156-.47-.115-.415zM71.267 126.385c8.914 9.155 19.051 16.977 28.213 25.873.163.158.381-.076.243-.243-3.535-4.3-8.064-7.891-12.215-11.568-5.362-4.749-10.796-9.407-16.21-14.092-.022-.018-.051.011-.03.03zM104.03 155.393c3.767 4.071 7.913 7.811 11.937 11.622.213.202.509-.1.319-.318-3.662-4.17-8.152-7.573-12.075-11.485-.117-.117-.296.059-.184.183l.003-.002zM119.633 170.497c.551.461 1.081.94 1.591 1.445.461.458.913.981 1.455 1.346.138.091.298-.087.22-.22-.672-1.156-2.034-2.023-3.11-2.773-.12-.083-.269.108-.156.202zM58.015 160.344c5.41 1.752 11.023 2.775 16.634 3.644 2.456.381 4.919.732 7.377 1.101 2.15.323 4.401.917 6.582.904.17 0 .174-.218.037-.276-1.981-.83-4.323-.99-6.428-1.323-2.523-.397-5.048-.775-7.566-1.183a221.205 221.205 0 0 1-16.51-3.325c-.296-.072-.415.362-.126.456v.002zM98.681 168.242c4.956 1.074 9.949 1.97 14.903 3.05.179.039.319-.229.133-.314-2.234-1.013-4.899-1.309-7.298-1.713-2.557-.431-5.126-.786-7.68-1.227-.134-.023-.196.177-.058.207v-.003zM74.747 149.325c4.731 3.096 9.99 5.632 15.243 7.715.147.057.25-.186.108-.255-5.129-2.47-10.112-5.158-15.156-7.793-.222-.117-.404.197-.195.335v-.002zM97.781 160.885c3.645 1.592 7.158 3.507 10.854 4.97.103.041.165-.122.075-.177-3.434-2.031-7.104-3.609-10.846-4.99-.113-.041-.195.147-.083.197z"
                    fill={lineColor}
                />
            </G>
            <Defs>
                <ClipPath id="a">
                    <Path fill="#fff" transform="translate(12 20)" d="M0 0h200v184.296H0z" />
                </ClipPath>
            </Defs>
        </Svg>
    );
};
