import { conditionalDescribe } from '@suite-common/test-utils';
import { TrezorUserEnvLink } from '@trezor/trezor-user-env-link';

import { onAlertSheet } from '../pageObjects/alertSheetActions';
import { onCoinEnablingInit } from '../pageObjects/coinEnablingActions';
import { onConnectingDevice } from '../pageObjects/connectingDevice';
import { onDeviceAuthenticitySummary } from '../pageObjects/deviceAuthenticitySummary';
import { onDeviceManager } from '../pageObjects/deviceManagerActions';
import { onDeviceSettings } from '../pageObjects/deviceSettingsActions';
import { onOnboarding } from '../pageObjects/onboardingActions';
import {
    appIsFullyLoaded,
    disconnectTrezorUserEnv,
    openApp,
    prepareTrezorEmulator,
    restartApp,
} from '../utils';

conditionalDescribe(device.getPlatform() === 'android', 'Device settings', () => {
    beforeAll(async () => {
        await prepareTrezorEmulator();
        await openApp({ newInstance: true });

        await onOnboarding.finishOnboarding();

        await onCoinEnablingInit.waitForScreen();
        await onCoinEnablingInit.enableNetwork('btc');
        await onCoinEnablingInit.clickOnConfirmButton();

        await onAlertSheet.skipViewOnlyMode();
    });

    beforeEach(async () => {
        await prepareTrezorEmulator();
        await restartApp();
        await appIsFullyLoaded();

        await onConnectingDevice.waitForScreen();
        await onDeviceManager.tapDeviceSwitch();
        await onDeviceManager.tapDeviceSettingsButton();
    });

    afterAll(async () => {
        disconnectTrezorUserEnv();
        await device.terminateApp();
    });

    test('Enable, change & disable PIN', async () => {
        await onDeviceSettings.tapEnablePinProtectionButton();

        await TrezorUserEnvLink.pressNo();
        await onAlertSheet.tapPrimaryButton();

        await TrezorUserEnvLink.pressYes();
        await TrezorUserEnvLink.inputEmu('42');
        await TrezorUserEnvLink.inputEmu('42');
        await TrezorUserEnvLink.pressYes();

        await onDeviceSettings.tapChangePinProtectionButton();

        await TrezorUserEnvLink.pressNo();
        await onAlertSheet.tapSecondaryButton();

        await onDeviceSettings.tapChangePinProtectionButton();

        await TrezorUserEnvLink.pressYes();
        await TrezorUserEnvLink.inputEmu('42');
        await TrezorUserEnvLink.inputEmu('21');
        await TrezorUserEnvLink.inputEmu('21');
        await TrezorUserEnvLink.pressYes();

        await onDeviceSettings.tapDisablePinProtectionButton();

        await TrezorUserEnvLink.pressYes();
        await TrezorUserEnvLink.inputEmu('21');
        await TrezorUserEnvLink.pressYes();

        await onDeviceSettings.waitForScreen();
    });

    test('Check device authenticity', async () => {
        await onDeviceSettings.scrollUntilCheckAuthenticityButtonIsVisible();
        await onDeviceSettings.tapCheckAuthenticityButton();

        await onAlertSheet.tapPrimaryButton();
        await TrezorUserEnvLink.pressNo();

        await onDeviceSettings.tapCheckAuthenticityButton();

        await onAlertSheet.tapPrimaryButton();
        await TrezorUserEnvLink.pressYes();

        await onDeviceAuthenticitySummary.waitForScreen();
        await onDeviceAuthenticitySummary.tapCloseButton();

        await onDeviceSettings.waitForScreen();
    });
});
