import { testMocks } from '@suite-common/test-utils';

export const ACCOUNTS = {
    test: {
        deviceState: '1stTestnetAddress@device_id:0',
        index: 0,
        path: "m/84\\'/1\\'/0\\'",
        descriptor:
            'vpub5YoEd2jJofNDXriAXpt4fyX23uRhrViFG3721C1wRRKUvDS4P6St7tqFfDP4JZsRARVhaVcGvW5jerdWBVc1c3fgqZeAYt29QSTiafKdwck',
        key: 'vpub5YoEd2jJofNDXriAXpt4fyX23uRhrViFG3721C1wRRKUvDS4P6St7tqFfDP4JZsRARVhaVcGvW5jerdWBVc1c3fgqZeAYt29QSTiafKdwck-test-mvAmt1x3QTsSmJrR4tbPtMpYnLbi3gDEBu@912734FCB107274D3CC465EC:0',
        accountType: 'normal',
        symbol: 'test',
        empty: false,
        visible: true,
        balance: '68000',
        availableBalance: '68000',
        formattedBalance: '0.00068',
        tokens: [],
        addresses: {
            change: [
                {
                    address: 'tb1q7vdky8srvnfrue2c7s5uv4czs06t2ya303kpq0',
                    path: "m/84\\'/1\\'/0\\'/1/0",
                    transfers: 0,
                },
                {
                    address: 'tb1q0dxyq2ry3030g2zgmgkdl30dm9r2mr4tunlqs8',
                    path: "m/84\\'/1\\'/0\\'/1/1",
                    transfers: 0,
                },
                {
                    address: 'tb1qtcsv49ejunw74hahfmgt07y6zncyqqhxt8w3p9',
                    path: "m/84\\'/1\\'/0\\'/1/2",
                    transfers: 0,
                },
                {
                    address: 'tb1qdgrp9200sngp2ce7hy08vdw9h5gng2k6e4e75t',
                    path: "m/84\\'/1\\'/0\\'/1/3",
                    transfers: 0,
                },
                {
                    address: 'tb1qnldm789ac2s40w0txxrx5pl72gk83zetcumc0c',
                    path: "m/84\\'/1\\'/0\\'/1/4",
                    transfers: 0,
                },
                {
                    address: 'tb1qmhvgfgsrwle4whl4dczkr7q5gta36c94q9jn86',
                    path: "m/84\\'/1\\'/0\\'/1/5",
                    transfers: 0,
                },
                {
                    address: 'tb1qyw5ql23md2pg96amajd0g37a42qsf5zl08jwnq',
                    path: "m/84\\'/1\\'/0\\'/1/6",
                    transfers: 0,
                },
                {
                    address: 'tb1qvu8yycwvhl5ph7e0vgsh727d7w2wnrp5hyktfg',
                    path: "m/84\\'/1\\'/0\\'/1/7",
                    transfers: 0,
                },
                {
                    address: 'tb1qxgpfva67h4xqsuu5tv0ml7l38regf7kse4xyll',
                    path: "m/84\\'/1\\'/0\\'/1/8",
                    transfers: 0,
                },
                {
                    address: 'tb1qpf9hjqcxw8m8w2hlf89nsgnppptmx5eyvjyh0k',
                    path: "m/84\\'/1\\'/0\\'/1/9",
                    transfers: 0,
                },
                {
                    address: 'tb1qzae45j82mjagtdsdwxk9m09f0kpvzggftu785p',
                    path: "m/84\\'/1\\'/0\\'/1/10",
                    transfers: 0,
                },
                {
                    address: 'tb1qx4vtgmeqsllwldledsd5uvar774c7503e3m670',
                    path: "m/84\\'/1\\'/0\\'/1/11",
                    transfers: 0,
                },
                {
                    address: 'tb1q6aqselqlp9aj9avdu7ln8hpauvjnjd4avc70e9',
                    path: "m/84\\'/1\\'/0\\'/1/12",
                    transfers: 0,
                },
                {
                    address: 'tb1qjy9v0klkf35qdvau34chzw2lmvvepvm6a0aq2x',
                    path: "m/84\\'/1\\'/0\\'/1/13",
                    transfers: 0,
                },
                {
                    address: 'tb1qpwhwdzq5zkp4zyxavft6zga8tcflxq6sk0vfzj',
                    path: "m/84\\'/1\\'/0\\'/1/14",
                    transfers: 0,
                },
                {
                    address: 'tb1qjmfdgj4qsflzfp09sqnm5ghf8fdvm90q4q7xyc',
                    path: "m/84\\'/1\\'/0\\'/1/15",
                    transfers: 0,
                },
                {
                    address: 'tb1q0z0kjar9dx4t7kyq24t0djutsge2cakasnvwuu',
                    path: "m/84\\'/1\\'/0\\'/1/16",
                    transfers: 0,
                },
                {
                    address: 'tb1qm5d37evlx9qjggxf7xyha08pttmh4nly4ug2gf',
                    path: "m/84\\'/1\\'/0\\'/1/17",
                    transfers: 0,
                },
                {
                    address: 'tb1qcttg6heyvfm979nvmprfqfwjtelfw4c8sn2de5',
                    path: "m/84\\'/1\\'/0\\'/1/18",
                    transfers: 0,
                },
                {
                    address: 'tb1qeh825c485s3t33g2xf4s940y8y0vtws076x0z0',
                    path: "m/84\\'/1\\'/0\\'/1/19",
                    transfers: 0,
                },
                {
                    address: 'tb1qvedutvamt7u2f0tfls9rk6qrpdj5lfpv4a7e3m',
                    path: "m/84\\'/1\\'/0\\'/1/20",
                    transfers: 0,
                },
            ],
            used: [
                {
                    address: 'tb1qdu4etzzpr3hqqkrqntpq32e8xjkeupajtarefl',
                    path: "m/84\\'/1\\'/0\\'/0/0",
                    transfers: 1,
                    balance: '68000',
                    sent: '0',
                    received: '68000',
                },
            ],
            unused: [
                {
                    address: 'tb1qk0qgmxtaw3kc9366eccjjgklef0g8lxv3l8nvk',
                    path: "m/84\\'/1\\'/0\\'/0/1",
                    transfers: 0,
                },
                {
                    address: 'tb1q99ml7urce6m77c2hmxeppm3ylvx7lqk6avhgh7',
                    path: "m/84\\'/1\\'/0\\'/0/2",
                    transfers: 0,
                },
                {
                    address: 'tb1qfs22x23v9l87u47e2592c64yzkf9dhxa28scnw',
                    path: "m/84\\'/1\\'/0\\'/0/3",
                    transfers: 0,
                },
                {
                    address: 'tb1qr0slx45frtcnfr2j23hprn6465h5z4kwuxujrc',
                    path: "m/84\\'/1\\'/0\\'/0/4",
                    transfers: 0,
                },
                {
                    address: 'tb1qh7ukfc9eazwmk5nf505s0vgvexyxjn0naehj73',
                    path: "m/84\\'/1\\'/0\\'/0/5",
                    transfers: 0,
                },
                {
                    address: 'tb1qzvful96xvvs2dn6g09vqq9wzeg6a3ntsjs0pax',
                    path: "m/84\\'/1\\'/0\\'/0/6",
                    transfers: 0,
                },
                {
                    address: 'tb1qj0t800hmxe2gptu6rchj8fzgs9ttwq3jmkdusf',
                    path: "m/84\\'/1\\'/0\\'/0/7",
                    transfers: 0,
                },
                {
                    address: 'tb1qtj2lu9f00ncl305d289h572mjny4nm5k4k85km',
                    path: "m/84\\'/1\\'/0\\'/0/8",
                    transfers: 0,
                },
                {
                    address: 'tb1qwhd4zsp5t7awjaks2d6gcrx56t4rvmv4fz2zlg',
                    path: "m/84\\'/1\\'/0\\'/0/9",
                    transfers: 0,
                },
                {
                    address: 'tb1qcdpgddd6vyeclmv95weg930clqqzfxvyrq3427',
                    path: "m/84\\'/1\\'/0\\'/0/10",
                    transfers: 0,
                },
                {
                    address: 'tb1qklqydzv0tqq7fxw3vvhky5kd7y0psxsllmdrfc',
                    path: "m/84\\'/1\\'/0\\'/0/11",
                    transfers: 0,
                },
                {
                    address: 'tb1qzqyuplrwagars7cp4hs8t8zlfttuy3u6zrg9yv',
                    path: "m/84\\'/1\\'/0\\'/0/12",
                    transfers: 0,
                },
                {
                    address: 'tb1qyzh6gwq3xw6p2ym54havg85yy64jwm8evv9ggl',
                    path: "m/84\\'/1\\'/0\\'/0/13",
                    transfers: 0,
                },
                {
                    address: 'tb1qrq7r0kqektdnky2a0fre6cpqehzzcqruzy2enz',
                    path: "m/84\\'/1\\'/0\\'/0/14",
                    transfers: 0,
                },
                {
                    address: 'tb1qj74zftdc44djnyh0472ppdn9nhx8mn9n0usn3v',
                    path: "m/84\\'/1\\'/0\\'/0/15",
                    transfers: 0,
                },
                {
                    address: 'tb1q37ufahkgaf5fs2scv55r06yfmkpg0zr6nl6s04',
                    path: "m/84\\'/1\\'/0\\'/0/16",
                    transfers: 0,
                },
                {
                    address: 'tb1qsjn5fp4nkrk80utqnqmdfhdzf07w4hgeqzrdk8',
                    path: "m/84\\'/1\\'/0\\'/0/17",
                    transfers: 0,
                },
                {
                    address: 'tb1qfp78gqketqy9ugmfmxq4q0zg8e92sjx8vs58x5',
                    path: "m/84\\'/1\\'/0\\'/0/18",
                    transfers: 0,
                },
                {
                    address: 'tb1qmwmja024rath0wzu6tdzy00kh4yaq7zwqs43q6',
                    path: "m/84\\'/1\\'/0\\'/0/19",
                    transfers: 0,
                },
                {
                    address: 'tb1qwg5fy5n2rnqstzprqynuwdghunpmxhjeffl6xd',
                    path: "m/84\\'/1\\'/0\\'/0/20",
                    transfers: 0,
                },
            ],
        },
        utxo: [
            {
                txid: '70ad253c25aa8a76ebcdb7fded56f2f57ec9b40967b7e79937b4f44445968c93',
                vout: 1,
                amount: '68000',
                blockHeight: 2349586,
                address: 'tb1qdu4etzzpr3hqqkrqntpq32e8xjkeupajtarefl',
                path: "m/84\\'/1\\'/0\\'/0/0",
                confirmations: 4,
            },
        ],
        history: {
            total: 1,
            unconfirmed: 0,
        },
        metadata: {
            key: 'tpubDCqPkbtppJQdWFHFejSQJ53PixpFj8CJdtjkvXrrXLq8mhjDxdd6WTpMwfP1pt8VmcGDh2KGNvct7cMF1kHH5xVBdqnKQEKMXrBR7udE7xA',
            fileName: '',
            aesKey: '',
            outputLabels: {},
            addressLabels: {},
        },
        networkType: 'bitcoin',
        page: {
            index: 1,
            size: 25,
            total: 1,
        },
    },
    txrp: {
        ...testMocks.getWalletAccount({
            deviceState: '1stTestnetAddress@device_id:0',
            descriptor: 'rNaqKtKrMSwpwZSzRckPf7S96DkimjkF4H',
            symbol: 'txrp',
        }),
    },
};
