import { WalletAccountTransaction } from '@suite-common/wallet-types';
import { BigNumber } from '@trezor/utils';

import { AccountHistoryMovementItem } from '../../types';

export const ethAccountTransactions: WalletAccountTransaction[] = [
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'recv',
        txid: '0x5484eea519c741b0a57b19ec5664def8d0a7291b8bf6523b6402d5969d662fc1',
        blockTime: 1720304171,
        blockHeight: 20250394,
        blockHash: '0x022c98a901f90bbafdfbbe9db5f5bca29afd06210f3510fbb6e7a5115004bad3',
        amount: '0',
        fee: '1101625884873855',
        targets: [],
        tokens: [
            {
                type: 'recv',
                from: '0x3fC29836E84E471a053D2D9E80494A867D670EAD',
                to: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
                contract: '0x3fC29836E84E471a053D2D9E80494A867D670EAD',
                name: 'Ethereum Games',
                symbol: 'ETHG',
                decimals: 8,
                amount: '200000000000000',
                standard: 'ERC20',
            },
        ],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 115,
            gasLimit: 873787,
            gasUsed: 857835,
            gasPrice: '1284193213',
            data: '0x',
            parsedData: {
                methodId: '0xaff44c4a',
                name: 'Transfer',
                function: 'transfer(address[], address, uint256)',
                params: [],
            },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0xcB4b7a5114E02c144a915c05C59192a6c6f33d5A'],
                    isAddress: true,
                },
            ],
            vout: [
                {
                    value: '0',
                    n: 0,
                    addresses: ['0x3fC29836E84E471a053D2D9E80494A867D670EAD'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '0',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'failed',
        txid: '0x6f0002073337a2fa75d431670e52616011aafa2a9dde6dbadd4dfe90094e735e',
        blockTime: 1719941207,
        blockHeight: 20220312,
        blockHash: '0xeb29a4959be49e99ac239962b9bf5b555a8b37435903972a65045b5c0977059e',
        amount: '0',
        fee: '135705000000000',
        targets: [
            {
                n: 0,
                addresses: ['0x0D3716e3e411aF431a6E87E715D4B05BbCD67000'],
                isAddress: true,
                amount: '0',
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 0,
            error: 'Reverted. ERC20: transfer amount exceeds balance',
            nonce: 19,
            gasLimit: 200000,
            gasUsed: 27141,
            gasPrice: '5000000000',
            data: '0xa9059cbb000000000000000000000000607ce71ae895d7759141c6ae2695a2eb64e92bb700000000000000000000000000000000000000000000000000000000000003e8',
            parsedData: {
                methodId: '0xa9059cbb',
                name: 'Transfer',
                function: 'transfer(address, uint256)',
                params: [
                    { type: 'address', values: ['0x607ce71Ae895D7759141c6ae2695a2eb64e92Bb7'] },
                    { type: 'uint256', values: ['1000'] },
                ],
            },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '0',
                    n: 0,
                    addresses: ['0x0D3716e3e411aF431a6E87E715D4B05BbCD67000'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '0',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0x825a6c28261a02df02aaef0a6922ed9cd194904a533bf8702fe203da23ec4488',
        blockTime: 1716201815,
        blockHeight: 19910615,
        blockHash: '0xf394e409a770b44f5b2e3297d1751939370d12627cd8ce7ff3b032937e1c26f9',
        amount: '103000000000000000',
        fee: '147000000000000',
        targets: [
            {
                n: 0,
                addresses: ['0xb06E587ACdFe468eDF025ED489354bE04e92d992'],
                isAddress: true,
                amount: '103000000000000000',
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 18,
            gasLimit: 21000,
            gasUsed: 21000,
            gasPrice: '7000000000',
            data: '0x',
            parsedData: { methodId: '', name: 'Transfer' },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '103000000000000000',
                    n: 0,
                    addresses: ['0xb06E587ACdFe468eDF025ED489354bE04e92d992'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '103000000000000000',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0x942942271b2e729974663c81b7528e407705c44a3d43abee7c1eed1770da1107',
        blockTime: 1716201707,
        blockHeight: 19910606,
        blockHash: '0x658bff264932caa8333e109fc866c8f373b7c5a04303cac3b7b8c35294dd7171',
        amount: '0',
        fee: '545853000000000',
        targets: [
            {
                n: 0,
                addresses: ['0x7a7f0b3c23C23a31cFcb0c44709be70d4D545c6e'],
                isAddress: true,
                amount: '0',
            },
        ],
        tokens: [],
        internalTransfers: [
            {
                type: 'recv',
                amount: '100040641478110596',
                from: '0x19449f0f696703Aa3b1485DfA2d855F33659397a',
                to: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
            },
        ],
        ethereumSpecific: {
            status: 1,
            nonce: 17,
            gasLimit: 306240,
            gasUsed: 77979,
            gasPrice: '7000000000',
            data: '0x33986ffa',
            parsedData: {
                methodId: '0x33986ffa',
                name: 'Claim Withdraw Request',
                function: 'claimWithdrawRequest()',
            },
            internalTransfers: [
                {
                    type: 0,
                    from: '0x19449f0f696703Aa3b1485DfA2d855F33659397a',
                    to: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
                    value: '100040641478110596',
                },
            ],
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '0',
                    n: 0,
                    addresses: ['0x7a7f0b3c23C23a31cFcb0c44709be70d4D545c6e'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '0',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0x00912d6743b8b6625d722d8bb05d4c02760128cf1078391ccfc45d0ce5e7add4',
        blockTime: 1715698031,
        blockHeight: 19868923,
        blockHash: '0x838764f6a04b4579e238fb0cceed0451c9d29281314a0a135bd071be113dc4c6',
        amount: '0',
        fee: '2399808000000000',
        targets: [
            {
                n: 0,
                addresses: ['0xD523794C879D9eC028960a231F866758e405bE34'],
                isAddress: true,
                amount: '0',
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 16,
            gasLimit: 238779,
            gasUsed: 199984,
            gasPrice: '12000000000',
            data: '0x76ec871c00000000000000000000000000000000000000000000000001636a6ef267ad8400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001',
            parsedData: {
                methodId: '0x76ec871c',
                name: 'Unstake',
                function: 'unstake(uint256, uint16, uint64)',
                params: [
                    { type: 'uint256', values: ['100040641478110596'] },
                    { type: 'uint16', values: ['0'] },
                    { type: 'uint64', values: ['1'] },
                ],
            },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '0',
                    n: 0,
                    addresses: ['0xD523794C879D9eC028960a231F866758e405bE34'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '0',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0x15db693ee8970a031230ce2e6761346aa24a1a19001983ca59568bf233553d95',
        blockTime: 1715328635,
        blockHeight: 19838353,
        blockHash: '0xe5262a36832d4c533a717a87aa8e2bb6c17b06f210d1cb3283f04cf0f7c98cdd',
        amount: '100000000000000000',
        fee: '1329385000000000',
        targets: [
            {
                n: 0,
                addresses: ['0xD523794C879D9eC028960a231F866758e405bE34'],
                isAddress: true,
                amount: '100000000000000000',
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 15,
            gasLimit: 295609,
            gasUsed: 265877,
            gasPrice: '5000000000',
            data: '0x3a29dbae0000000000000000000000000000000000000000000000000000000000000001',
            parsedData: {
                methodId: '0x3a29dbae',
                name: 'Stake',
                function: 'stake(uint64)',
                params: [{ type: 'uint64', values: ['1'] }],
            },
            internalTransfers: [
                {
                    type: 0,
                    from: '0x6bE457e04092B28865E0cBa84E3b2CFa0f871E67',
                    to: '0xD523794C879D9eC028960a231F866758e405bE34',
                    value: '299745850500000000',
                },
            ],
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '100000000000000000',
                    n: 0,
                    addresses: ['0xD523794C879D9eC028960a231F866758e405bE34'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '100000000000000000',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'recv',
        txid: '0x59a785fa2ac16abfbf9460d4a935cef6cf4d9c25b428e948b7664aa17be5c7dc',
        blockTime: 1715027555,
        blockHeight: 19813446,
        blockHash: '0x0c53f3bb23355a92b9db76d9c53ad09888a4a5e0f4bc4c9b6df72dc0bcb2ccb6',
        amount: '100000000000000000',
        fee: '147000000000000',
        targets: [
            {
                n: 0,
                addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                isAddress: true,
                amount: '100000000000000000',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 17,
            gasLimit: 21000,
            gasUsed: 21000,
            gasPrice: '7000000000',
            data: '0x',
            parsedData: { methodId: '', name: 'Transfer' },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x3673f8b98691367bf1e47E56577A04771430F422'],
                    isAddress: true,
                },
            ],
            vout: [
                {
                    value: '100000000000000000',
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '100000000000000000',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0x77a49494df625295a836f06d54aa6ca09ef1029390a005ca9a0a205aac3d0c64',
        blockTime: 1700570711,
        blockHeight: 18620218,
        blockHash: '0x874b7a949e5f6c94b457fc17c0f2510ef8fad0a1e107b417c3bd09e69c247a12',
        amount: '2544148458548186',
        fee: '2551020873988956',
        targets: [
            {
                n: 0,
                addresses: ['0x253553366Da8546fC250F225fe3d25d0C782303b'],
                isAddress: true,
                amount: '2544148458548186',
            },
        ],
        tokens: [],
        internalTransfers: [
            {
                type: 'recv',
                amount: '49885263893101',
                from: '0x253553366Da8546fC250F225fe3d25d0C782303b',
                to: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
            },
        ],
        ethereumSpecific: {
            status: 1,
            nonce: 14,
            gasLimit: 94524,
            gasUsed: 94524,
            gasPrice: '26988075769',
            data: '0xacf1a84100000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000001e13380000000000000000000000000000000000000000000000000000000000000000d7472657a6f7270726f6475637400000000000000000000000000000000000000',
            parsedData: {
                methodId: '0xacf1a841',
                name: 'Renew',
                function: 'renew(string, uint256)',
                params: [
                    { type: 'string', values: ['trezorproduct'] },
                    { type: 'uint256', values: ['31536000'] },
                ],
            },
            internalTransfers: [
                {
                    type: 0,
                    from: '0x253553366Da8546fC250F225fe3d25d0C782303b',
                    to: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
                    value: '49885263893101',
                },
            ],
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '2544148458548186',
                    n: 0,
                    addresses: ['0x253553366Da8546fC250F225fe3d25d0C782303b'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '2544148458548186',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'recv',
        txid: '0x92599a835a14a99ec3c0b7a4faeada11c7d192f580155ae7bb6e813bf8346296',
        blockTime: 1678360427,
        blockHeight: 16790283,
        blockHash: '0xe2716459c71d840067c13e6313ff87c28f7e520768721bb6e3aae0e7fb96569c',
        amount: '6693140000000000',
        fee: '504000000000000',
        targets: [
            {
                n: 0,
                addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                isAddress: true,
                amount: '6693140000000000',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 0,
            gasLimit: 21000,
            gasUsed: 21000,
            gasPrice: '24000000000',
            data: '0x',
            parsedData: { methodId: '', name: 'Transfer' },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0xA6AbbDABA7D724d28fBa6CEfC0E3Fcae33B5cB38'],
                    isAddress: true,
                },
            ],
            vout: [
                {
                    value: '6693140000000000',
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '6693140000000000',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0xa6e62f58a97fca9994198e76db4964dddec64b961c71dd64dfa1f9dab252562c',
        blockTime: 1674135767,
        blockHeight: 16441221,
        blockHash: '0xa2eeb1480e3698031a3f0283f77dc8941e4a922c6855c627a1e47fc10b15d47e',
        amount: '0',
        fee: '789067791431770',
        targets: [
            {
                n: 0,
                addresses: ['0xdAC17F958D2ee523a2206206994597C13D831ec7'],
                isAddress: true,
                amount: '0',
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 13,
            gasLimit: 65214,
            gasUsed: 43174,
            gasPrice: '18276457855',
            data: '0x23b872dd00000000000000000000000073d0385f4d8e00c5e6504c6030f47bf6212736a80000000000000000000000009fe6529815dffcb7b42e46b73984a85c786c995f0000000000000000000000000000000000000000000000000000000000000000',
            parsedData: {
                methodId: '0x23b872dd',
                name: 'Transfer From',
                function: 'transferFrom(address, address, uint256)',
                params: [
                    { type: 'address', values: ['0x73d0385F4d8E00C5e6504C6030F47BF6212736A8'] },
                    { type: 'address', values: ['0x9Fe6529815DffCB7B42E46B73984A85c786c995F'] },
                    { type: 'uint256', values: ['0'] },
                ],
            },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '0',
                    n: 0,
                    addresses: ['0xdAC17F958D2ee523a2206206994597C13D831ec7'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '0',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0x897eaebac0cfe80852d509d58d97007c0e42d228bc974049082c92da14c7c7fa',
        blockTime: 1673008487,
        blockHeight: 16347775,
        blockHash: '0x7c4399497f91a5f272907c4737486a8e8b9ff47bee1278b69328a17aef28b452',
        amount: '0',
        fee: '1153120436501860',
        targets: [],
        tokens: [
            {
                type: 'sent',
                from: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
                to: '0x2f2e848033a772eaeb6340D48F2A47f0e04667b8',
                contract: '0x495f947276749Ce646f68AC8c248420045cb7b5e',
                name: 'OpenSea Shared Storefront',
                symbol: 'OPENSTORE',
                decimals: 18,
                multiTokenValues: [
                    {
                        id: '44395624018362851188573534520166294602281522662001509492944499026354721783809',
                        value: '1',
                    },
                ],
                amount: '',
                standard: 'ERC1155',
            },
        ],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 12,
            gasLimit: 113223,
            gasUsed: 82172,
            gasPrice: '14033009255',
            data: '0xf242432a00000000000000000000000062270860b9a5337e46be8563c512c9137afa03840000000000000000000000002f2e848033a772eaeb6340d48f2a47f0e04667b862270860b9a5337e46be8563c512c9137afa0384000000000000010000000001000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000360c6ebe',
            parsedData: { methodId: '0xf242432a', name: '' },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '0',
                    n: 0,
                    addresses: ['0x495f947276749Ce646f68AC8c248420045cb7b5e'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '0',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0xb970d1dc159a93b1f0610009ace4c51b1d0ae73891a21497075cfa725f4e35ff',
        blockTime: 1672848431,
        blockHeight: 16334513,
        blockHash: '0xd6c2e2d61083a043e96b2042f7ed2afa150b983b96abfa66231dcbf837dd62d1',
        amount: '0',
        fee: '3924773151249236',
        targets: [],
        tokens: [
            {
                type: 'recv',
                from: '0x2f2e848033a772eaeb6340D48F2A47f0e04667b8',
                to: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
                contract: '0xdAC17F958D2ee523a2206206994597C13D831ec7',
                name: 'Tether USD',
                symbol: 'USDT',
                decimals: 6,
                amount: '0',
                standard: 'ERC20',
            },
        ],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 11,
            gasLimit: 172744,
            gasUsed: 43186,
            gasPrice: '90880682426',
            data: '0x23b872dd0000000000000000000000002f2e848033a772eaeb6340d48f2a47f0e04667b800000000000000000000000062270860b9a5337e46be8563c512c9137afa03840000000000000000000000000000000000000000000000000000000000000000',
            parsedData: {
                methodId: '0x23b872dd',
                name: 'Transfer From',
                function: 'transferFrom(address, address, uint256)',
                params: [
                    { type: 'address', values: ['0x2f2e848033a772eaeb6340D48F2A47f0e04667b8'] },
                    { type: 'address', values: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'] },
                    { type: 'uint256', values: ['0'] },
                ],
            },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '0',
                    n: 0,
                    addresses: ['0xdAC17F958D2ee523a2206206994597C13D831ec7'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '0',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0x65548c339b4ede588e604ec69ea3a2d71105f884140c8140336bb3e30f71fac7',
        blockTime: 1669295795,
        blockHeight: 16040078,
        blockHash: '0xe9ff6addbf2c28f438d0bebf16058b57055e78f7bd29be6be4e028e2ce27b375',
        amount: '0',
        fee: '1054220198090416',
        targets: [
            {
                n: 0,
                addresses: ['0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e'],
                isAddress: true,
                amount: '0',
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 10,
            gasLimit: 74392,
            gasUsed: 74392,
            gasPrice: '14171150098',
            data: '0x5ef2c7f028ae3be67eda1a1c52ba2d1e742ea42e83daee4f5c75adf73ff8dd8f369150edadc756803e4eb4ccfb136b73d5f72e3dc0d452d30ae1f4bc82af394c73ce711500000000000000000000000062270860b9a5337e46be8563c512c9137afa03840000000000000000000000004976fb03c32e5b8cfe2b6ccb31c09ba78ebaba410000000000000000000000000000000000000000000000000000000000000000',
            parsedData: {
                methodId: '0x5ef2c7f0',
                name: 'Set Subnode Record',
                function: 'setSubnodeRecord(bytes32, bytes32, address, address, uint64)',
                params: [
                    {
                        type: 'bytes32',
                        values: [
                            '0x28ae3be67eda1a1c52ba2d1e742ea42e83daee4f5c75adf73ff8dd8f369150ed',
                        ],
                    },
                    {
                        type: 'bytes32',
                        values: [
                            '0xadc756803e4eb4ccfb136b73d5f72e3dc0d452d30ae1f4bc82af394c73ce7115',
                        ],
                    },
                    { type: 'address', values: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'] },
                    { type: 'address', values: ['0x4976fb03C32e5B8cfe2b6cCB31c09Ba78EBaBa41'] },
                    { type: 'uint64', values: ['0'] },
                ],
            },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '0',
                    n: 0,
                    addresses: ['0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '0',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'recv',
        txid: '0x185f78ab78cf563c7ac39ab237ca7617415d9c94805b1cdeb1acd6c9d1aab778',
        blockTime: 1669227215,
        blockHeight: 16034410,
        blockHash: '0x38f055e20178d8370a2601fe2ae85169c4388df8aba830b0d6d3b23b5dad177d',
        amount: '0',
        fee: '42815796699289720',
        targets: [],
        tokens: [
            {
                type: 'recv',
                from: '0x28FFE35688fFFfd0659AEE2E34778b0ae4E193aD',
                to: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
                contract: '0x0D3716e3e411aF431a6E87E715D4B05BbCD67000',
                name: '$ NFTGiftX.com',
                symbol: '$ Visit NFTGiftX.com to claim',
                decimals: 0,
                amount: '4000',
                standard: 'ERC20',
            },
        ],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 281,
            gasLimit: 3000111,
            gasUsed: 2582680,
            gasPrice: '16578049429',
            data: '0x',
            parsedData: { methodId: '0x616da87c', name: '' },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0xE931B17106bA9A58C998408230d99260B9b1ecA8'],
                    isAddress: true,
                },
            ],
            vout: [
                {
                    value: '0',
                    n: 0,
                    addresses: ['0x0D3716e3e411aF431a6E87E715D4B05BbCD67000'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '0',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0x370303c232902b823e0537bc0ea105fed2291f6dabee816f3bf9a06a5e527294',
        blockTime: 1669112003,
        blockHeight: 16024880,
        blockHash: '0xf8c85775674c5f6d3a6f49671e7c019cc5604d32e0f30f9519b7ee0884d1c7b6',
        amount: '0',
        fee: '778385174814768',
        targets: [
            {
                n: 0,
                addresses: ['0x4976fb03C32e5B8cfe2b6cCB31c09Ba78EBaBa41'],
                isAddress: true,
                amount: '0',
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 9,
            gasLimit: 57458,
            gasUsed: 57458,
            gasPrice: '13547028696',
            data: '0x8b95dd7128ae3be67eda1a1c52ba2d1e742ea42e83daee4f5c75adf73ff8dd8f369150ed000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000600000000000000000000000000000000000000000000000000000000000000016001448277a20dc69033fe61775ef4ff7f48c4abb307400000000000000000000',
            parsedData: {
                methodId: '0x8b95dd71',
                name: 'Set Addr',
                function: 'setAddr(bytes32, uint256, bytes)',
                params: [
                    {
                        type: 'bytes32',
                        values: [
                            '0x28ae3be67eda1a1c52ba2d1e742ea42e83daee4f5c75adf73ff8dd8f369150ed',
                        ],
                    },
                    { type: 'uint256', values: ['0'] },
                    { type: 'bytes', values: ['0x001448277a20dc69033fe61775ef4ff7f48c4abb3074'] },
                ],
            },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '0',
                    n: 0,
                    addresses: ['0x4976fb03C32e5B8cfe2b6cCB31c09Ba78EBaBa41'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '0',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0x68e48806bd6d6e684cd7661c60aabe1a25039cfcdf9f37b617feb6f70ee3ce82',
        blockTime: 1669015247,
        blockHeight: 16016860,
        blockHash: '0xa1488f6a9876bc61b4c28e42a47a4edd4bb9d9f1c46e46c92acdb33d44cf6493',
        amount: '0',
        fee: '1368748478636770',
        targets: [
            {
                n: 0,
                addresses: ['0x084b1c3C81545d370f3634392De611CaaBFf8148'],
                isAddress: true,
                amount: '0',
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 8,
            gasLimit: 127926,
            gasUsed: 127610,
            gasPrice: '10726028357',
            data: '0x',
            parsedData: {
                methodId: '0xc47f0027',
                name: 'Set Name',
                function: 'setName(string)',
                params: [{ type: 'string', values: ['trezorproduct.eth'] }],
            },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '0',
                    n: 0,
                    addresses: ['0x084b1c3C81545d370f3634392De611CaaBFf8148'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '0',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0x3a98e4346e3b63723d48f9e837050b75495b0ddd24b4abfe7976a5557fbfb05f',
        blockTime: 1669015139,
        blockHeight: 16016851,
        blockHash: '0xb5fd7ed6ec0d9407b50cc1f1b04366188581907c0573dfa5a9cba6ac26cc0bb3',
        amount: '4876316049789737',
        fee: '3133892482131531',
        targets: [
            {
                n: 0,
                addresses: ['0x283Af0B28c62C092C9727F1Ee09c02CA627EB7F5'],
                isAddress: true,
                amount: '4876316049789737',
            },
        ],
        tokens: [
            {
                type: 'recv',
                from: '0x283Af0B28c62C092C9727F1Ee09c02CA627EB7F5',
                to: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
                contract: '0x57f1887a8BF19b14fC0dF6Fd9B2acc9Af147eA85',
                name: '',
                symbol: '',
                decimals: 0,
                amount: '53685781660361861602479528826332654757969937544629728874903983443500115773249',
                standard: 'ERC721',
            },
        ],
        internalTransfers: [
            {
                type: 'recv',
                amount: '443301459071794',
                from: '0x283Af0B28c62C092C9727F1Ee09c02CA627EB7F5',
                to: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
            },
        ],
        ethereumSpecific: {
            status: 1,
            nonce: 7,
            gasLimit: 308676,
            gasUsed: 277059,
            gasPrice: '11311282009',
            data: '0x',
            parsedData: {
                methodId: '0xf7a16963',
                name: 'Register With Config',
                function: 'registerWithConfig(string, address, uint256, bytes32, address, address)',
                params: [
                    { type: 'string', values: ['trezorproduct'] },
                    { type: 'address', values: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'] },
                    { type: 'uint256', values: ['31556952'] },
                    {
                        type: 'bytes32',
                        values: [
                            '0x44a2035ff822ad464104c67da329150592c6924a05b8bb8958875e2e0ead82ca',
                        ],
                    },
                    { type: 'address', values: ['0x4976fb03C32e5B8cfe2b6cCB31c09Ba78EBaBa41'] },
                    { type: 'address', values: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'] },
                ],
            },
            internalTransfers: [
                {
                    type: 0,
                    from: '0x283Af0B28c62C092C9727F1Ee09c02CA627EB7F5',
                    to: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
                    value: '443301459071794',
                },
            ],
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '4876316049789737',
                    n: 0,
                    addresses: ['0x283Af0B28c62C092C9727F1Ee09c02CA627EB7F5'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '4876316049789737',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0x26dff8909ebaa755b01a82265181e2c8fc8e6fc0d6217881d6e599bfb69f2b57',
        blockTime: 1669015031,
        blockHeight: 16016842,
        blockHash: '0x7d9e9c63173a96c97c69851cf38481a68e43db61af021b5098938e2eaa9a33da',
        amount: '0',
        fee: '492565665692022',
        targets: [
            {
                n: 0,
                addresses: ['0x283Af0B28c62C092C9727F1Ee09c02CA627EB7F5'],
                isAddress: true,
                amount: '0',
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 6,
            gasLimit: 46267,
            gasUsed: 46267,
            gasPrice: '10646155266',
            data: '0xf14fcbc84690c81fe4c6f146266da882b09f043834c30eb008ba291b126b6fac2f54bc81',
            parsedData: {
                methodId: '0xf14fcbc8',
                name: 'Commit',
                function: 'commit(bytes32)',
                params: [
                    {
                        type: 'bytes32',
                        values: [
                            '0x4690c81fe4c6f146266da882b09f043834c30eb008ba291b126b6fac2f54bc81',
                        ],
                    },
                ],
            },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '0',
                    n: 0,
                    addresses: ['0x283Af0B28c62C092C9727F1Ee09c02CA627EB7F5'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '0',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0x65430886fd0b8b03449e8752aa50edf6a92edf7739b2fec2e36c67e953bcc819',
        blockTime: 1666787435,
        blockHeight: 15832258,
        blockHash: '0x439f7864ce6c3e88089e9c14716c47e6507ee7b9da56428db650321d020d75f8',
        amount: '0',
        fee: '1508775669608064',
        targets: [],
        tokens: [
            {
                type: 'sent',
                from: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
                to: '0x2f2e848033a772eaeb6340D48F2A47f0e04667b8',
                contract: '0x495f947276749Ce646f68AC8c248420045cb7b5e',
                name: 'OpenSea Shared Storefront',
                symbol: 'OPENSTORE',
                decimals: 18,
                multiTokenValues: [
                    {
                        id: '44395624018362851188573534520166294602281522662001509492944499027454233411585',
                        value: '1',
                    },
                ],
                amount: '',
                standard: 'ERC1155',
            },
        ],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 5,
            gasLimit: 87031,
            gasUsed: 82108,
            gasPrice: '18375501408',
            data: '0x',
            parsedData: { methodId: '0xf242432a', name: '' },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '0',
                    n: 0,
                    addresses: ['0x495f947276749Ce646f68AC8c248420045cb7b5e'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '0',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'recv',
        txid: '0x2cbbf54ee400b75ddd7f49375fd06f0a7862db8fbcfcb4c4f34b241f016e51fa',
        blockTime: 1666344347,
        blockHeight: 15795573,
        blockHash: '0x7d02dd5cd42404982ce69053abd68125eb5add6fc5afc854b23fd4ea94fc8651',
        amount: '1840677926140699',
        fee: '448350000000000',
        targets: [
            {
                n: 0,
                addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                isAddress: true,
                amount: '1840677926140699',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 0,
            gasLimit: 21000,
            gasUsed: 21000,
            gasPrice: '21350000000',
            data: '0x',
            parsedData: { methodId: '', name: 'Transfer' },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x63a2aB7a208093C7dF7A17513ECC4bB93f09C49c'],
                    isAddress: true,
                },
            ],
            vout: [
                {
                    value: '1840677926140699',
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '1840677926140699',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0xdd714419b68678ed1574ef671667ea08a749cff8ef0c5cd94b80fe50c80a53cd',
        blockTime: 1666343279,
        blockHeight: 15795484,
        blockHash: '0xbb808071f304f178cf73e7bb79b80e03902787b6ea0d6b050b4aa1f6b1e0fbe5',
        amount: '2289027926140699',
        fee: '441000000000000',
        targets: [
            {
                n: 0,
                addresses: ['0x63a2aB7a208093C7dF7A17513ECC4bB93f09C49c'],
                isAddress: true,
                amount: '2289027926140699',
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 4,
            gasLimit: 21000,
            gasUsed: 21000,
            gasPrice: '21000000000',
            data: '0x',
            parsedData: { methodId: '', name: 'Transfer' },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '2289027926140699',
                    n: 0,
                    addresses: ['0x63a2aB7a208093C7dF7A17513ECC4bB93f09C49c'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '2289027926140699',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0xdebceb20f924fe5972fa6b6d5dfee0303fee7baf182890a707170677f5613ea7',
        blockTime: 1666281347,
        blockHeight: 15790341,
        blockHash: '0x2a7de1bcc631f6751f8cc1d9aea50a28fddebb8c9e6e05ffa5bbc2a9d8ce4043',
        amount: '1509490924185818',
        fee: '840000000000000',
        targets: [
            {
                n: 0,
                addresses: ['0x2a06f070e963D36196eDD59166095D474F0A0974'],
                isAddress: true,
                amount: '1509490924185818',
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 3,
            gasLimit: 21000,
            gasUsed: 21000,
            gasPrice: '40000000000',
            data: '0x',
            parsedData: { methodId: '', name: 'Transfer' },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '1509490924185818',
                    n: 0,
                    addresses: ['0x2a06f070e963D36196eDD59166095D474F0A0974'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '1509490924185818',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'recv',
        txid: '0x270b60eb8651c1916c275987370adb83c97cf69f47b631bca412fd9f2fc2886e',
        blockTime: 1665761171,
        blockHeight: 15747233,
        blockHash: '0x90f1aea15cab729453cb2a93ac00c5e0fd1e7442b21a72a8cc04e41160043f8f',
        amount: '0',
        fee: '1145958000000000',
        targets: [],
        tokens: [
            {
                type: 'recv',
                from: '0x48c04ed5691981C42154C6167398f95e8f38a7fF',
                to: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
                contract: '0x514910771AF9Ca656af840dff83E8264EcF986CA',
                name: 'ChainLink Token',
                symbol: 'LINK',
                decimals: 18,
                amount: '920485180000000000',
                standard: 'ERC20',
            },
        ],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 456029,
            gasLimit: 180000,
            gasUsed: 52089,
            gasPrice: '22000000000',
            data: '0xa9059cbb00000000000000000000000062270860b9a5337e46be8563c512c9137afa03840000000000000000000000000000000000000000000000000cc63864eee95800',
            parsedData: {
                methodId: '0xa9059cbb',
                name: 'Transfer',
                function: 'transfer(address, uint256)',
                params: [
                    { type: 'address', values: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'] },
                    { type: 'uint256', values: ['920485180000000000'] },
                ],
            },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x48c04ed5691981C42154C6167398f95e8f38a7fF'],
                    isAddress: true,
                },
            ],
            vout: [
                {
                    value: '0',
                    n: 0,
                    addresses: ['0x514910771AF9Ca656af840dff83E8264EcF986CA'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '0',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'recv',
        txid: '0x49460cf4a097564bb24fd065632984eb3a7734c5469cb42cdfaac37c0deca018',
        blockTime: 1665761075,
        blockHeight: 15747225,
        blockHash: '0x25c6c14d4359c6ac455631a248e85742aaa906987fad4b30fbc303d2cc5a7128',
        amount: '0',
        fee: '1139996000000000',
        targets: [],
        tokens: [
            {
                type: 'recv',
                from: '0x48c04ed5691981C42154C6167398f95e8f38a7fF',
                to: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
                contract: '0x6B175474E89094C44Da98b954EedeAC495271d0F',
                name: 'Dai Stablecoin',
                symbol: 'DAI',
                decimals: 18,
                amount: '16243034330000000000',
                standard: 'ERC20',
            },
        ],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 456028,
            gasLimit: 180000,
            gasUsed: 51818,
            gasPrice: '22000000000',
            data: '0xa9059cbb00000000000000000000000062270860b9a5337e46be8563c512c9137afa0384000000000000000000000000000000000000000000000000e16ad9a9f2200400',
            parsedData: {
                methodId: '0xa9059cbb',
                name: 'Transfer',
                function: 'transfer(address, uint256)',
                params: [
                    { type: 'address', values: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'] },
                    { type: 'uint256', values: ['16243034330000000000'] },
                ],
            },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x48c04ed5691981C42154C6167398f95e8f38a7fF'],
                    isAddress: true,
                },
            ],
            vout: [
                {
                    value: '0',
                    n: 0,
                    addresses: ['0x6B175474E89094C44Da98b954EedeAC495271d0F'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '0',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0x3cebeb6142548c99c90e1356aba6ca65da6eefab11c366610a504d4d3b474620',
        blockTime: 1665761003,
        blockHeight: 15747219,
        blockHash: '0x1cde0b7640b62a14dd629a43c123c52247a5a7c08bee4e3fa6659f97b9ffcb7d',
        amount: '7604909729721508',
        fee: '441000000000000',
        targets: [
            {
                n: 0,
                addresses: ['0x98C071F239f3574192aca726a38Ed9b41A660656'],
                isAddress: true,
                amount: '7604909729721508',
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 2,
            gasLimit: 21000,
            gasUsed: 21000,
            gasPrice: '21000000000',
            data: '0x',
            parsedData: { methodId: '', name: 'Transfer' },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '7604909729721508',
                    n: 0,
                    addresses: ['0x98C071F239f3574192aca726a38Ed9b41A660656'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '7604909729721508',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'recv',
        txid: '0x4d2bce60dd55a6a567a9e43305db4e6051e1ca252fc474d5cbe43d593176c44f',
        blockTime: 1665761003,
        blockHeight: 15747219,
        blockHash: '0x1cde0b7640b62a14dd629a43c123c52247a5a7c08bee4e3fa6659f97b9ffcb7d',
        amount: '0',
        fee: '1258532000000000',
        targets: [],
        tokens: [
            {
                type: 'recv',
                from: '0x48c04ed5691981C42154C6167398f95e8f38a7fF',
                to: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
                contract: '0x1f9840a85d5aF5bf1D1762F925BDADdC4201F984',
                name: 'Uniswap',
                symbol: 'UNI',
                decimals: 18,
                amount: '997077580000000000',
                standard: 'ERC20',
            },
        ],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 456027,
            gasLimit: 180000,
            gasUsed: 57206,
            gasPrice: '22000000000',
            data: '0xa9059cbb00000000000000000000000062270860b9a5337e46be8563c512c9137afa03840000000000000000000000000000000000000000000000000dd654c6b967f800',
            parsedData: {
                methodId: '0xa9059cbb',
                name: 'Transfer',
                function: 'transfer(address, uint256)',
                params: [
                    { type: 'address', values: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'] },
                    { type: 'uint256', values: ['997077580000000000'] },
                ],
            },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x48c04ed5691981C42154C6167398f95e8f38a7fF'],
                    isAddress: true,
                },
            ],
            vout: [
                {
                    value: '0',
                    n: 0,
                    addresses: ['0x1f9840a85d5aF5bf1D1762F925BDADdC4201F984'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '0',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0x27f5e42ce95ae5c5a4786d62a4f66bfa2c090f262bbab00929da855eaefd1612',
        blockTime: 1665760907,
        blockHeight: 15747211,
        blockHash: '0xc327c43d348c744adf32f069f7631214d48d2f6c5c8d686f15f1e95fa34729fd',
        amount: '15148301875359772',
        fee: '441000000000000',
        targets: [
            {
                n: 0,
                addresses: ['0x1d7eDc13624CDF4CE0e828814Eb66C7fe2397F94'],
                isAddress: true,
                amount: '15148301875359772',
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 1,
            gasLimit: 21000,
            gasUsed: 21000,
            gasPrice: '21000000000',
            data: '0x',
            parsedData: { methodId: '', name: 'Transfer' },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '15148301875359772',
                    n: 0,
                    addresses: ['0x1d7eDc13624CDF4CE0e828814Eb66C7fe2397F94'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '15148301875359772',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'sent',
        txid: '0x495e89c1b931cfcee7d97a39affdb63914e2d6957c3cd6e0024ae2e074b2e9fb',
        blockTime: 1665760847,
        blockHeight: 15747206,
        blockHash: '0x87c079aa0e7c7d2b6cebc6bbc543b84fe33c86178a9ce2b2927e495926b73422',
        amount: '7583973547100268',
        fee: '441000000000000',
        targets: [
            {
                n: 0,
                addresses: ['0x8a280E2d535C51eF8CbB02Ef414Da638dcD57c30'],
                isAddress: true,
                amount: '7583973547100268',
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 0,
            gasLimit: 21000,
            gasUsed: 21000,
            gasPrice: '21000000000',
            data: '0x',
            parsedData: { methodId: '', name: 'Transfer' },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '7583973547100268',
                    n: 0,
                    addresses: ['0x8a280E2d535C51eF8CbB02Ef414Da638dcD57c30'],
                    isAddress: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '7583973547100268',
        },
    },
    {
        descriptor: '0x62270860B9a5337e46bE8563c512c9137AFa0384',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'eth',
        type: 'recv',
        txid: '0xbcaf9676c21d29f5890e47b5d67dd7bdfe6ee85dd0353d9367f0c7982631cb6f',
        blockTime: 1665666335,
        blockHeight: 15739382,
        blockHash: '0x21bf101852b3867cb5c5c9dfe85cce28f586032ebb969d28fc982de977307cce',
        amount: '74174290000000000',
        fee: '462000000000000',
        targets: [
            {
                n: 0,
                addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                isAddress: true,
                amount: '74174290000000000',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        ethereumSpecific: {
            status: 1,
            nonce: 0,
            gasLimit: 21000,
            gasUsed: 21000,
            gasPrice: '22000000000',
            data: '0x',
            parsedData: { methodId: '', name: 'Transfer' },
        },
        details: {
            vin: [
                {
                    n: 0,
                    addresses: ['0x9Fe6529815DffCB7B42E46B73984A85c786c995F'],
                    isAddress: true,
                },
            ],
            vout: [
                {
                    value: '74174290000000000',
                    n: 0,
                    addresses: ['0x62270860B9a5337e46bE8563c512c9137AFa0384'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 0,
            totalInput: '0',
            totalOutput: '74174290000000000',
        },
    },
];

export const ethAccountBalanceHistoryResult: AccountHistoryMovementItem[] = [
    {
        time: 1665666335,
        txs: 1,
        received: '74174290000000000',
        sent: '0',
        sentToSelf: '0',
    },
    {
        time: 1665760847,
        txs: 1,
        received: '0',
        sent: '8024973547100268',
        sentToSelf: '0',
    },
    {
        time: 1665760907,
        txs: 1,
        received: '0',
        sent: '15589301875359772',
        sentToSelf: '0',
    },
    {
        time: 1665761003,
        txs: 2,
        received: '0',
        sent: '8045909729721508',
        sentToSelf: '0',
    },
    {
        time: 1665761075,
        txs: 1,
        received: '0',
        sent: '0',
        sentToSelf: '0',
    },
    {
        time: 1665761171,
        txs: 1,
        received: '0',
        sent: '0',
        sentToSelf: '0',
    },
    {
        time: 1666281347,
        txs: 1,
        received: '0',
        sent: '2349490924185818',
        sentToSelf: '0',
    },
    {
        time: 1666343279,
        txs: 1,
        received: '0',
        sent: '2730027926140699',
        sentToSelf: '0',
    },
    {
        time: 1666344347,
        txs: 1,
        received: '1840677926140699',
        sent: '0',
        sentToSelf: '0',
    },
    {
        time: 1666787435,
        txs: 1,
        received: '0',
        sent: '1508775669608064',
        sentToSelf: '0',
    },
    {
        time: 1669015031,
        txs: 1,
        received: '0',
        sent: '492565665692022',
        sentToSelf: '0',
    },
    {
        time: 1669015139,
        txs: 1,
        received: '443301459071794',
        sent: '8010208531921268',
        sentToSelf: '0',
    },
    {
        time: 1669015247,
        txs: 1,
        received: '0',
        sent: '1368748478636770',
        sentToSelf: '0',
    },
    {
        time: 1669112003,
        txs: 1,
        received: '0',
        sent: '778385174814768',
        sentToSelf: '0',
    },
    {
        time: 1669227215,
        txs: 1,
        received: '0',
        sent: '0',
        sentToSelf: '0',
    },
    {
        time: 1669295795,
        txs: 1,
        received: '0',
        sent: '1054220198090416',
        sentToSelf: '0',
    },
    {
        time: 1672848431,
        txs: 1,
        received: '0',
        sent: '3924773151249236',
        sentToSelf: '0',
    },
    {
        time: 1673008487,
        txs: 1,
        received: '0',
        sent: '1153120436501860',
        sentToSelf: '0',
    },
    {
        time: 1674135767,
        txs: 1,
        received: '0',
        sent: '789067791431770',
        sentToSelf: '0',
    },
    {
        time: 1678360427,
        txs: 1,
        received: '6693140000000000',
        sent: '0',
        sentToSelf: '0',
    },
    {
        time: 1700570711,
        txs: 1,
        received: '49885263893101',
        sent: '5095169332537142',
        sentToSelf: '0',
    },
    {
        time: 1715027555,
        txs: 1,
        received: '100000000000000000',
        sent: '0',
        sentToSelf: '0',
    },
    {
        time: 1715328635,
        txs: 1,
        received: '0',
        sent: '101329385000000000',
        sentToSelf: '0',
    },
    {
        time: 1715698031,
        txs: 1,
        received: '0',
        sent: '2399808000000000',
        sentToSelf: '0',
    },
    {
        time: 1716201707,
        txs: 1,
        received: '100040641478110596',
        sent: '545853000000000',
        sentToSelf: '0',
    },
    {
        time: 1716201815,
        txs: 1,
        received: '0',
        sent: '103147000000000000',
        sentToSelf: '0',
    },
    {
        time: 1719941207,
        txs: 1,
        received: '0',
        sent: '135705000000000',
        sentToSelf: '0',
    },
    {
        time: 1720304171,
        txs: 1,
        received: '0',
        sent: '0',
        sentToSelf: '0',
    },
].map(item => ({
    ...item,
    received: new BigNumber(item.received),
    sent: new BigNumber(item.sent),
    sentToSelf: new BigNumber(item.sentToSelf),
}));

export const ethTokenBalanceHistoryResult: Record<string, AccountHistoryMovementItem[]> = {
    '0x3fC29836E84E471a053D2D9E80494A867D670EAD': [
        {
            time: 1720304171,
            txs: 1,
            received: new BigNumber('200000000000000').div(10 ** 8),
            sent: new BigNumber('0'),
            sentToSelf: new BigNumber('0'),
        },
    ],
    '0xdAC17F958D2ee523a2206206994597C13D831ec7': [
        {
            time: 1672848431,
            txs: 1,
            received: new BigNumber('0'),
            sent: new BigNumber('0'),
            sentToSelf: new BigNumber('0'),
        },
    ],
    '0x0D3716e3e411aF431a6E87E715D4B05BbCD67000': [
        {
            time: 1669227215,
            txs: 1,
            received: new BigNumber('4000').div(10 ** 0),
            sent: new BigNumber('0'),
            sentToSelf: new BigNumber('0'),
        },
    ],
    '0x514910771AF9Ca656af840dff83E8264EcF986CA': [
        {
            time: 1665761171,
            txs: 1,
            received: new BigNumber('920485180000000000').div(10 ** 18),
            sent: new BigNumber('0'),
            sentToSelf: new BigNumber('0'),
        },
    ],
    '0x6B175474E89094C44Da98b954EedeAC495271d0F': [
        {
            time: 1665761075,
            txs: 1,
            received: new BigNumber('16243034330000000000').div(10 ** 18),
            sent: new BigNumber('0'),
            sentToSelf: new BigNumber('0'),
        },
    ],
    '0x1f9840a85d5aF5bf1D1762F925BDADdC4201F984': [
        {
            time: 1665761003,
            txs: 1,
            received: new BigNumber('997077580000000000').div(10 ** 18),
            sent: new BigNumber('0'),
            sentToSelf: new BigNumber('0'),
        },
    ],
};
