import { BigNumber } from '@trezor/utils';
import { WalletAccountTransaction } from '@suite-common/wallet-types';

import { AccountHistoryMovementItem } from '../../types';

export const btcAccountTransactions: WalletAccountTransaction[] = [
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'sent',
        txid: '861fbc92e6bb55e96765251232b453db168332716faf9b3bf3023085fe27317a',
        blockTime: 1712963150,
        blockHeight: 838931,
        blockHash: '000000000000000000007bc13d9caf362cb897f8b292f9aecc18b2f5a284dd64',
        amount: '71492',
        fee: '6131',
        vsize: 111,
        feeRate: '55.23',
        targets: [
            {
                n: 0,
                addresses: ['3PhNBgH6AXVvxcY4KThp4mp1ri9oVCg5An'],
                isAddress: true,
                amount: '71492',
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: 'f21d58b6a41001af73558e5033513e1290385e82a7e745210d9cd43d38d4d5f2',
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qt448h2ye6zgmtanfemrge9wc9mrlnhyd9xaplw'],
                    isAddress: true,
                    isOwn: true,
                    value: '77623',
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '71492',
                    n: 0,
                    spent: true,
                    spentTxId: 'b87f887ece9394a2f3880bfbe8472e890cfa096bae83aa708164da7c56d6c5fb',
                    spentIndex: 5,
                    spentHeight: 838933,
                    hex: 'a914f163ae22eb8490235870e7e8f949013de9c6632487',
                    addresses: ['3PhNBgH6AXVvxcY4KThp4mp1ri9oVCg5An'],
                    isAddress: true,
                },
            ],
            size: 192,
            totalInput: '77623',
            totalOutput: '71492',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'recv',
        txid: '8bc3914b4cd9bdfd0e9cf369ab3761f55fc9ada9eae96fe7fc4f728cf26c26ef',
        blockTime: 1711445680,
        blockHeight: 836357,
        blockHash: '0000000000000000000219ca9a9bdca6f8a1bf0b4bc707b78d4ea11b862ba339',
        lockTime: 836355,
        amount: '181023',
        fee: '4380',
        vsize: 146,
        feeRate: '30',
        targets: [
            {
                n: 0,
                addresses: ['bc1qrlry5t94hunm3n987ed6ttmt3vec4w84s2r2ae'],
                isAddress: true,
                amount: '181023',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: 'f21d58b6a41001af73558e5033513e1290385e82a7e745210d9cd43d38d4d5f2',
                    vout: 1,
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qm59vk3d2uwwp0fqekchcy3pyvd7zcn9v0f8j4hwzu7yne4kwmlds9d4j3f'],
                    isAddress: true,
                    value: '185403',
                },
            ],
            vout: [
                {
                    value: '181023',
                    n: 0,
                    hex: '00141fc64a2cb5bf27b8cca7f65ba5af6b8b338ab8f5',
                    addresses: ['bc1qrlry5t94hunm3n987ed6ttmt3vec4w84s2r2ae'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 337,
            totalInput: '185403',
            totalOutput: '181023',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'recv',
        txid: 'f21d58b6a41001af73558e5033513e1290385e82a7e745210d9cd43d38d4d5f2',
        blockTime: 1711118625,
        blockHeight: 835791,
        blockHash: '0000000000000000000063e0848c2789dce254a525492e4fa9d853f97493fb70',
        lockTime: 835780,
        amount: '77623',
        fee: '3024',
        vsize: 189,
        feeRate: '16',
        targets: [
            {
                n: 0,
                addresses: ['bc1qt448h2ye6zgmtanfemrge9wc9mrlnhyd9xaplw'],
                isAddress: true,
                amount: '77623',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: 'f5db01b95956387f696f4ac67898e0c65a79a4ae6dedff4405b356e17c293580',
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qu6e274lcf6guvdf28hc0j9huzeud50q55fdfex3lhgm2q8xm8ftqd6s486'],
                    isAddress: true,
                    value: '266050',
                },
            ],
            vout: [
                {
                    value: '77623',
                    n: 0,
                    spent: true,
                    spentTxId: '861fbc92e6bb55e96765251232b453db168332716faf9b3bf3023085fe27317a',
                    spentHeight: 838931,
                    hex: '00145d6a7ba899d091b5f669cec68c95d82ec7f9dc8d',
                    addresses: ['bc1qt448h2ye6zgmtanfemrge9wc9mrlnhyd9xaplw'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
                {
                    value: '185403',
                    n: 1,
                    spent: true,
                    spentTxId: '8bc3914b4cd9bdfd0e9cf369ab3761f55fc9ada9eae96fe7fc4f728cf26c26ef',
                    spentHeight: 836357,
                    hex: '0020dd0acb45aae39c17a419b62f824424637c2c4cac7a4f2addc2e7893cd6cedfdb',
                    addresses: ['bc1qm59vk3d2uwwp0fqekchcy3pyvd7zcn9v0f8j4hwzu7yne4kwmlds9d4j3f'],
                    isAddress: true,
                },
            ],
            size: 379,
            totalInput: '266050',
            totalOutput: '263026',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'sent',
        txid: 'f5db01b95956387f696f4ac67898e0c65a79a4ae6dedff4405b356e17c293580',
        blockTime: 1711110549,
        blockHeight: 835780,
        blockHash: '000000000000000000033a4dc73c3888f21879e1f94f9b14b196e5faf0321324',
        amount: '266050',
        fee: '3354',
        vsize: 258,
        feeRate: '13',
        targets: [
            {
                n: 0,
                addresses: ['bc1qu6e274lcf6guvdf28hc0j9huzeud50q55fdfex3lhgm2q8xm8ftqd6s486'],
                isAddress: true,
                amount: '266050',
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: '4bb76ff13fa81f9d127fa6d215f315d0d32770379b16663fbb99800f396809eb',
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qhacn6m7usslzdvym7pynmerktep0e8a4ty35f9'],
                    isAddress: true,
                    isOwn: true,
                    value: '138577',
                    isAccountOwned: true,
                },
                {
                    txid: 'c7a677368e3391b51880237522cde0f60cca83029ea0bb747507ffb673f47d26',
                    vout: 1,
                    sequence: 4294967293,
                    n: 1,
                    addresses: ['bc1qvslap5yajxcm67y2u3dacpxv2lcm4g962hlk5j'],
                    isAddress: true,
                    isOwn: true,
                    value: '124579',
                    isAccountOwned: true,
                },
                {
                    txid: 'f7e8570d9770927e02d82012788483b5ba53df6c5321bba2bed657732c1fd74e',
                    vout: 1,
                    sequence: 4294967293,
                    n: 2,
                    addresses: ['bc1qxc3x3u4xxrsjsqd5fpkrg6u5njumqgxr8h3knt'],
                    isAddress: true,
                    isOwn: true,
                    value: '6248',
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '266050',
                    n: 0,
                    spent: true,
                    spentTxId: 'f21d58b6a41001af73558e5033513e1290385e82a7e745210d9cd43d38d4d5f2',
                    spentHeight: 835791,
                    hex: '0020e6b2af57f84e91c6352a3df0f916fc1678da3c14a25a9c9a3fba36a01cdb3a56',
                    addresses: ['bc1qu6e274lcf6guvdf28hc0j9huzeud50q55fdfex3lhgm2q8xm8ftqd6s486'],
                    isAddress: true,
                },
            ],
            size: 501,
            totalInput: '269404',
            totalOutput: '266050',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'recv',
        txid: 'c7a677368e3391b51880237522cde0f60cca83029ea0bb747507ffb673f47d26',
        blockTime: 1698402008,
        blockHeight: 814047,
        blockHash: '00000000000000000000640e1a146dc74cef173a7feb8926cca43acad7000b85',
        amount: '124579',
        fee: '836',
        vsize: 209,
        feeRate: '4',
        targets: [
            {
                n: 1,
                addresses: ['bc1qvslap5yajxcm67y2u3dacpxv2lcm4g962hlk5j'],
                isAddress: true,
                amount: '124579',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: '7757679f0c082992a3c02fdbede6e7c2f54fd88a2d9150cf735ba0be990a638f',
                    vout: 1,
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qet4d85kpw0tg4xwlp0q4fnxmyuuhy3t4nu05xl'],
                    isAddress: true,
                    value: '114147',
                },
                {
                    txid: 'c384482eb4cf223265778ea9d3c866a78ff8a858b86d4f06001885cc0d4463d5',
                    vout: 1,
                    sequence: 4294967293,
                    n: 1,
                    addresses: ['bc1qckx26an6w8wagwjy50kn63ncww0kdl8pdsmvx6'],
                    isAddress: true,
                    value: '48745',
                },
            ],
            vout: [
                {
                    value: '37477',
                    n: 0,
                    spent: true,
                    spentTxId: 'd909a642fe1de954d169e7908cac8f5feac2656a1bffa3a7380889a181717808',
                    spentHeight: 829780,
                    hex: '0014081d874b6bc8bf232f316241b49a5050dff33e28',
                    addresses: ['bc1qpqwcwjmtezljxte3vfqmfxjs2r0lx03gsqgvjx'],
                    isAddress: true,
                },
                {
                    value: '124579',
                    n: 1,
                    spent: true,
                    spentTxId: 'f5db01b95956387f696f4ac67898e0c65a79a4ae6dedff4405b356e17c293580',
                    spentIndex: 1,
                    spentHeight: 835780,
                    hex: '0014643fd0d09d91b1bd788ae45bdc04cc57f1baa0ba',
                    addresses: ['bc1qvslap5yajxcm67y2u3dacpxv2lcm4g962hlk5j'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 371,
            totalInput: '162892',
            totalOutput: '162056',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'recv',
        txid: '4bb76ff13fa81f9d127fa6d215f315d0d32770379b16663fbb99800f396809eb',
        blockTime: 1694515520,
        blockHeight: 807321,
        blockHash: '00000000000000000001e773bcd9163ef84a4c00b8c4f9766de14ee80e4ab75e',
        amount: '138577',
        fee: '8944',
        vsize: 559,
        feeRate: '16',
        targets: [
            {
                n: 0,
                addresses: ['bc1qhacn6m7usslzdvym7pynmerktep0e8a4ty35f9'],
                isAddress: true,
                amount: '138577',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        details: {
            vin: [
                {
                    txid: '02d7d3f5754fb86bb955d3accb144beef960f90d339be34e21546ce86cb4390a',
                    vout: 169,
                    sequence: 4294967295,
                    n: 0,
                    addresses: ['bc1pvjt5t3k4zknqxxh2hsf8xq2mayadhgzkphe6vduqarnapajmlakshc79ag'],
                    isAddress: true,
                    value: '20000',
                },
                {
                    txid: '0da73f5b995da5441212aaaf512499c5fb99bfa21ad858b472406fdf76119610',
                    vout: 148,
                    sequence: 4294967295,
                    n: 1,
                    addresses: ['bc1p5gakveh2zfk662ecyzysyc32aht46jd8dg47za0grj3a6mug0fpshtct4w'],
                    isAddress: true,
                    value: '20000',
                },
                {
                    txid: '0da73f5b995da5441212aaaf512499c5fb99bfa21ad858b472406fdf76119610',
                    vout: 195,
                    sequence: 4294967295,
                    n: 2,
                    addresses: ['bc1ps8uyq2m3weswxw2naxwzv2smam746lhrhrg35xs2357a06hqr96smjrgkk'],
                    isAddress: true,
                    value: '8192',
                },
                {
                    txid: '1a4f7f0fd9900afcb7403be39bd72cdcb070b679abe7a7f258fa94dee1da3e5e',
                    vout: 248,
                    sequence: 4294967295,
                    n: 3,
                    addresses: ['bc1pan5f46twn4aw22fxn4ukhcsy8hrnnqwfk9h2jglfljty2zuxxpnqw3eyr4'],
                    isAddress: true,
                    value: '10000',
                },
                {
                    txid: '420927951877fcfae9e8a507fa2b016e23c8f3f46686ae171fd1729a93fb355a',
                    vout: 163,
                    sequence: 4294967295,
                    n: 4,
                    addresses: ['bc1psm8v3aqsl76mejq2dnpkx98n5ktwfaqtssvpsg5paplneyy9v64shpmwzd'],
                    isAddress: true,
                    value: '32768',
                },
                {
                    txid: '420927951877fcfae9e8a507fa2b016e23c8f3f46686ae171fd1729a93fb355a',
                    vout: 189,
                    sequence: 4294967295,
                    n: 5,
                    addresses: ['bc1p5qgscx6cc9f7820yvdwavqx8gmqa0j5s6uyh4jnxduaryyjsa20qg8z55l'],
                    isAddress: true,
                    value: '20000',
                },
                {
                    txid: '420927951877fcfae9e8a507fa2b016e23c8f3f46686ae171fd1729a93fb355a',
                    vout: 192,
                    sequence: 4294967295,
                    n: 6,
                    addresses: ['bc1pezl4cmm67l9m7e4cp92ztwcwly60p94sd6uhk6hvdmf7zescry6q8qqcul'],
                    isAddress: true,
                    value: '20000',
                },
                {
                    txid: '420927951877fcfae9e8a507fa2b016e23c8f3f46686ae171fd1729a93fb355a',
                    vout: 239,
                    sequence: 4294967295,
                    n: 7,
                    addresses: ['bc1p3ftsehy9m65hmhhypgus3ctws5hmpm3rqmj8899dvw83xgufvk3sgt77dg'],
                    isAddress: true,
                    value: '10000',
                },
                {
                    txid: '420927951877fcfae9e8a507fa2b016e23c8f3f46686ae171fd1729a93fb355a',
                    vout: 272,
                    sequence: 4294967295,
                    n: 8,
                    addresses: ['bc1pkhagxsv0jlhqxftwnnxdyu3c24jmntsqqq4cd52mhdz2ze52trmsvlu2p7'],
                    isAddress: true,
                    value: '6561',
                },
            ],
            vout: [
                {
                    value: '138577',
                    n: 0,
                    spent: true,
                    spentTxId: 'f5db01b95956387f696f4ac67898e0c65a79a4ae6dedff4405b356e17c293580',
                    spentHeight: 835780,
                    hex: '0014bf713d6fdc843e26b09bf0493de4765e42fc9fb5',
                    addresses: ['bc1qhacn6m7usslzdvym7pynmerktep0e8a4ty35f9'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 1006,
            totalInput: '147521',
            totalOutput: '138577',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'sent',
        txid: 'f7e8570d9770927e02d82012788483b5ba53df6c5321bba2bed657732c1fd74e',
        blockTime: 1694466639,
        blockHeight: 807236,
        blockHash: '00000000000000000002a4d9ecfd0c8bcd8b08aed453d3c6fba68ef9bb856d3c',
        amount: '60000',
        fee: '2926',
        vsize: 210,
        feeRate: '13.93',
        targets: [
            {
                n: 0,
                addresses: ['3FdLnqWdpZQBL3Ku5rjEqVRCAjXPHNk9bF'],
                isAddress: true,
                amount: '60000',
            },
        ],
        tokens: [],
        internalTransfers: [],
        details: {
            vin: [
                {
                    txid: 'f7c9f241d186d96e17939409e76cd80a8f7a2c0ab53e3453201b6d810e5d519d',
                    vout: 1,
                    n: 0,
                    addresses: ['bc1qnx3gypazcwf2u9gmpgdjt0ujmy9apc4nn57nt2'],
                    isAddress: true,
                    isOwn: true,
                    value: '30899',
                    isAccountOwned: true,
                },
                {
                    txid: '9d20a027959c870afd339e1631ee2a446380c3d804e8248c04eef7b09df082e4',
                    n: 1,
                    addresses: ['bc1qp4u0adgvrd83lyte6ewcgd3kj4u0fcd34ysmz8'],
                    isAddress: true,
                    isOwn: true,
                    value: '38275',
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '60000',
                    n: 0,
                    spent: true,
                    spentTxId: 'baf0c48a15639a7323d1dee5911ec49bf1a76d54561a66de7ab9055aa1a0e593',
                    spentHeight: 807238,
                    hex: 'a91498dfd8bb88b3c9a7898a1f793783772fd4a914df87',
                    addresses: ['3FdLnqWdpZQBL3Ku5rjEqVRCAjXPHNk9bF'],
                    isAddress: true,
                },
                {
                    value: '6248',
                    n: 1,
                    spent: true,
                    spentTxId: 'f5db01b95956387f696f4ac67898e0c65a79a4ae6dedff4405b356e17c293580',
                    spentIndex: 2,
                    spentHeight: 835780,
                    hex: '0014362268f2a630e12801b4486c346b949cb9b020c3',
                    addresses: ['bc1qxc3x3u4xxrsjsqd5fpkrg6u5njumqgxr8h3knt'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 372,
            totalInput: '69174',
            totalOutput: '66248',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'sent',
        txid: '9d20a027959c870afd339e1631ee2a446380c3d804e8248c04eef7b09df082e4',
        blockTime: 1680694226,
        blockHeight: 784046,
        blockHash: '000000000000000000002e0d8e1543711aa265c06fa20e82d78ad1397d9cdf93',
        amount: '70195',
        fee: '1530',
        vsize: 153,
        feeRate: '10',
        targets: [
            {
                n: 1,
                addresses: ['bc1p2fwc90t9mj5n4g8vdx6466scfmt8x0y5dz6yezgsrwcjt56zu4qqme6nry'],
                isAddress: true,
                amount: '70195',
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: 'f7c9f241d186d96e17939409e76cd80a8f7a2c0ab53e3453201b6d810e5d519d',
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qfdr7yzhqmlltpwws5l9fr8f7h85mtq9pfcg9es'],
                    isAddress: true,
                    isOwn: true,
                    value: '110000',
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '38275',
                    n: 0,
                    spent: true,
                    spentTxId: 'f7e8570d9770927e02d82012788483b5ba53df6c5321bba2bed657732c1fd74e',
                    spentIndex: 1,
                    spentHeight: 807236,
                    hex: '00140d78feb50c1b4f1f9179d65d8436369578f4e1b1',
                    addresses: ['bc1qp4u0adgvrd83lyte6ewcgd3kj4u0fcd34ysmz8'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
                {
                    value: '70195',
                    n: 1,
                    spent: true,
                    spentTxId: '02d7d3f5754fb86bb955d3accb144beef960f90d339be34e21546ce86cb4390a',
                    spentIndex: 155,
                    spentHeight: 786113,
                    hex: '5120525d82bd65dca93aa0ec69b55d6a184ed6733c9468b44c89101bb125d342e540',
                    addresses: ['bc1p2fwc90t9mj5n4g8vdx6466scfmt8x0y5dz6yezgsrwcjt56zu4qqme6nry'],
                    isAddress: true,
                },
            ],
            size: 235,
            totalInput: '110000',
            totalOutput: '108470',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'joint',
        txid: 'f7c9f241d186d96e17939409e76cd80a8f7a2c0ab53e3453201b6d810e5d519d',
        blockTime: 1680515463,
        blockHeight: 783739,
        blockHash: '000000000000000000048c58d1080ca97e124d0b34e923695bc4c1bc3b310086',
        amount: '97913',
        fee: '2583',
        vsize: 368,
        feeRate: '7.02',
        targets: [],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: '1907c19ccf24aba0798b4d73f4f537af5767c978bbfb48e526d90c32350701fc',
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qn7kj622yfrn695qv9rqcaxpwlltnfynxd0zt0z'],
                    isAddress: true,
                    isOwn: true,
                    value: '20608',
                    isAccountOwned: true,
                },
                {
                    txid: '02da428b7d819bd89083e203c243f8875a99e2d449db7e254b0ab70cd674d906',
                    sequence: 4294967293,
                    n: 1,
                    addresses: ['3QWhTErhEM4C78DNiSaTK18P79NbRbrMw7'],
                    isAddress: true,
                    value: '100496',
                    hex: '160014c2054b73d83d718da052c918c148e7478c3a4827',
                },
                {
                    txid: 'b8ccb6e85d3c5fe008b0534d4f9ff8b1de71f2b7a3d856490b9a96f6ae1e49bb',
                    sequence: 4294967293,
                    n: 2,
                    addresses: ['bc1qt5mjvp7nt4lpq77s4c3trvyre2smtcxz4zmmjs'],
                    isAddress: true,
                    isOwn: true,
                    value: '19580',
                    isAccountOwned: true,
                },
                {
                    txid: 'c6529a24fa5133f0f39935a9ac930cc84c412d0dd7be48179d9f03238ee1e1ac',
                    sequence: 4294967293,
                    n: 3,
                    addresses: ['bc1q9vj2rrrqxuqs6quzj9havx0mj9ctuhwykyzmcx'],
                    isAddress: true,
                    isOwn: true,
                    value: '2798',
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '110000',
                    n: 0,
                    spent: true,
                    spentTxId: '9d20a027959c870afd339e1631ee2a446380c3d804e8248c04eef7b09df082e4',
                    spentHeight: 784046,
                    hex: '00144b47e20ae0dffeb0b9d0a7ca919d3eb9e9b580a1',
                    addresses: ['bc1qfdr7yzhqmlltpwws5l9fr8f7h85mtq9pfcg9es'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
                {
                    value: '30899',
                    n: 1,
                    spent: true,
                    spentTxId: 'f7e8570d9770927e02d82012788483b5ba53df6c5321bba2bed657732c1fd74e',
                    spentHeight: 807236,
                    hex: '001499a28207a2c392ae151b0a1b25bf92d90bd0e2b3',
                    addresses: ['bc1qnx3gypazcwf2u9gmpgdjt0ujmy9apc4nn57nt2'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 693,
            totalInput: '143482',
            totalOutput: '140899',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'sent',
        txid: 'b8ccb6e85d3c5fe008b0534d4f9ff8b1de71f2b7a3d856490b9a96f6ae1e49bb',
        blockTime: 1679482960,
        blockHeight: 781958,
        blockHash: '00000000000000000003111b544a1ed4663b2a0597dfa8420b2d2970226cdd1d',
        amount: '40107',
        fee: '2926',
        vsize: 209,
        feeRate: '14',
        targets: [
            {
                n: 1,
                addresses: ['bc1ql2ntmq4jlq5g2q53q89c7f7d27s35se96jq6kw'],
                isAddress: true,
                amount: '40107',
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: '85c6a01a7480aa98b342dfc4299a5682f9d0f35938f2c625758538db0b4a5c6e',
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qj477aj92qsttes0c5kgw9u4avkjh8w46kpf2ae'],
                    isAddress: true,
                    isOwn: true,
                    value: '24800',
                    isAccountOwned: true,
                },
                {
                    txid: 'c9970eff2f35310d5405dbd41d90f89b231353823d16c59ce522d303cc432ac2',
                    sequence: 4294967293,
                    n: 1,
                    addresses: ['bc1qqrueed2uvj42qql0qmn2rhwpum3k6mrhflc98f'],
                    isAddress: true,
                    isOwn: true,
                    value: '37813',
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '19580',
                    n: 0,
                    spent: true,
                    spentTxId: 'f7c9f241d186d96e17939409e76cd80a8f7a2c0ab53e3453201b6d810e5d519d',
                    spentIndex: 2,
                    spentHeight: 783739,
                    hex: '00145d372607d35d7e107bd0ae22b1b083caa1b5e0c2',
                    addresses: ['bc1qt5mjvp7nt4lpq77s4c3trvyre2smtcxz4zmmjs'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
                {
                    value: '40107',
                    n: 1,
                    spent: true,
                    spentTxId: '017889b069d3baa1dd6c3f455619b92dbb22c4d403ba3e63605aa2bcb477f715',
                    spentHeight: 781960,
                    hex: '0014faa6bd82b2f82885029101cb8f27cd57a11a4325',
                    addresses: ['bc1ql2ntmq4jlq5g2q53q89c7f7d27s35se96jq6kw'],
                    isAddress: true,
                },
            ],
            size: 371,
            totalInput: '62613',
            totalOutput: '59687',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'sent',
        txid: 'c9970eff2f35310d5405dbd41d90f89b231353823d16c59ce522d303cc432ac2',
        blockTime: 1678187959,
        blockHeight: 779723,
        blockHash: '00000000000000000004628fb5258215350f427e1d9a91f68d54e668a61da01e',
        amount: '101174',
        fee: '3060',
        vsize: 153,
        feeRate: '20',
        targets: [
            {
                n: 1,
                addresses: ['bc1p0x6pkf30hfgsd2dwtdad6htf823mdvwxa6sqjr3x90lze2yyt8rquu87jv'],
                isAddress: true,
                amount: '101174',
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: '3b19971d0bf9185c5f6033316fe507d32b65efab6247bc9b2ff79084e2220038',
                    vout: 1,
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1q7uupvkequzlh3twll87prax2nxy5m5leynl5yn'],
                    isAddress: true,
                    isOwn: true,
                    value: '142047',
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '37813',
                    n: 0,
                    spent: true,
                    spentTxId: 'b8ccb6e85d3c5fe008b0534d4f9ff8b1de71f2b7a3d856490b9a96f6ae1e49bb',
                    spentIndex: 1,
                    spentHeight: 781958,
                    hex: '001400f99cb55c64aaa003ef06e6a1ddc1e6e36d6c77',
                    addresses: ['bc1qqrueed2uvj42qql0qmn2rhwpum3k6mrhflc98f'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
                {
                    value: '101174',
                    n: 1,
                    spent: true,
                    spentTxId: 'f08445e4e9443045a2fbf3453d6c78543000e70a90b87e380758b298872d691d',
                    spentIndex: 198,
                    spentHeight: 779733,
                    hex: '512079b41b262fba5106a9ae5b7add5d693aa3b6b1c6eea0090e262bfe2ca88459c6',
                    addresses: ['bc1p0x6pkf30hfgsd2dwtdad6htf823mdvwxa6sqjr3x90lze2yyt8rquu87jv'],
                    isAddress: true,
                },
            ],
            size: 235,
            totalInput: '142047',
            totalOutput: '138987',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'sent',
        txid: '3b19971d0bf9185c5f6033316fe507d32b65efab6247bc9b2ff79084e2220038',
        blockTime: 1678101937,
        blockHeight: 779581,
        blockHash: '0000000000000000000029b84ba6aa21b42c302c01dd12ca00aef75c3428b527',
        amount: '50328',
        fee: '1836',
        vsize: 153,
        feeRate: '12',
        targets: [
            {
                n: 0,
                addresses: ['bc1q285md2twfrkwhdqs594anacaefu7x76d6hany3a7ganu73axmdvqc42dng'],
                isAddress: true,
                amount: '50328',
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: '3216d57139f6ec27425dfc821e7077051a976c3db7ab8e4420dfc15b42735da1',
                    vout: 1,
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qx89rjquukmfgpxa5y0gmaqvuhhr7flychflhc4'],
                    isAddress: true,
                    isOwn: true,
                    value: '194211',
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '50328',
                    n: 0,
                    spent: true,
                    spentTxId: 'c1db7ead350be3eb81823ec809ec206b397b7e823754238ec13d9e87189c8c5e',
                    spentIndex: 4,
                    spentHeight: 789283,
                    hex: '002051e9b6a96e48ecebb410a16bd9f71dca79e37b4dd5fb3247be4767cf47a6db58',
                    addresses: ['bc1q285md2twfrkwhdqs594anacaefu7x76d6hany3a7ganu73axmdvqc42dng'],
                    isAddress: true,
                },
                {
                    value: '142047',
                    n: 1,
                    spent: true,
                    spentTxId: 'c9970eff2f35310d5405dbd41d90f89b231353823d16c59ce522d303cc432ac2',
                    spentHeight: 779723,
                    hex: '0014f738165b20e0bf78addff9fc11f4ca99894dd3f9',
                    addresses: ['bc1q7uupvkequzlh3twll87prax2nxy5m5leynl5yn'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 235,
            totalInput: '194211',
            totalOutput: '192375',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'recv',
        txid: '3216d57139f6ec27425dfc821e7077051a976c3db7ab8e4420dfc15b42735da1',
        blockTime: 1677839961,
        blockHeight: 779104,
        blockHash: '00000000000000000005fee975c65305f2f5f5ff81a10ea9751fd47c435737a0',
        amount: '194211',
        fee: '3278',
        vsize: 168,
        feeRate: '19.51',
        targets: [
            {
                n: 1,
                addresses: ['bc1qx89rjquukmfgpxa5y0gmaqvuhhr7flychflhc4'],
                isAddress: true,
                amount: '194211',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        details: {
            vin: [
                {
                    txid: '85c6a01a7480aa98b342dfc4299a5682f9d0f35938f2c625758538db0b4a5c6e',
                    vout: 1,
                    sequence: 4294967295,
                    n: 0,
                    addresses: ['bc1qvfhr9tywxrzahnujcnpgnv229z6nmh4pmrsntj3gua0a402mlnqsh9nuph'],
                    isAddress: true,
                    value: '200000',
                },
            ],
            vout: [
                {
                    value: '2511',
                    n: 0,
                    spent: true,
                    spentTxId: '21c646e07354157945ef124f3b35522c3f59e58d44ecb5984ba27ecf6d99f261',
                    spentIndex: 13,
                    spentHeight: 782836,
                    hex: '00146a9c1084ff561a298cfaf3e4a0e59bb9c9d04ead',
                    addresses: ['bc1qd2wppp8l2cdznr8670j2pevmh8yaqn4dln6snn'],
                    isAddress: true,
                },
                {
                    value: '194211',
                    n: 1,
                    spent: true,
                    spentTxId: '3b19971d0bf9185c5f6033316fe507d32b65efab6247bc9b2ff79084e2220038',
                    spentHeight: 779581,
                    hex: '001431ca39039cb6d2809bb423d1be819cbdc7e4fc98',
                    addresses: ['bc1qx89rjquukmfgpxa5y0gmaqvuhhr7flychflhc4'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 333,
            totalInput: '200000',
            totalOutput: '196722',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'sent',
        txid: '85c6a01a7480aa98b342dfc4299a5682f9d0f35938f2c625758538db0b4a5c6e',
        blockTime: 1675784738,
        blockHeight: 775449,
        blockHash: '00000000000000000000a296cd481886ab5b3bdb3f06e21d47148e90a751e25b',
        lockTime: 775448,
        amount: '200000',
        fee: '2355',
        vsize: 289,
        feeRate: '8.15',
        targets: [
            {
                n: 1,
                addresses: ['bc1qvfhr9tywxrzahnujcnpgnv229z6nmh4pmrsntj3gua0a402mlnqsh9nuph'],
                isAddress: true,
                amount: '200000',
            },
        ],
        tokens: [],
        internalTransfers: [],
        details: {
            vin: [
                {
                    txid: '727f252c6fa4f9b7cc3d2b33368a3acae4d9773e66cab0106e01f85c999839f7',
                    sequence: 4294967294,
                    n: 0,
                    addresses: ['bc1quk722fnq5rc30rc5xlc9w68zye8kwzv84k6lkz'],
                    isAddress: true,
                    isOwn: true,
                    value: '31391',
                    isAccountOwned: true,
                },
                {
                    txid: '9a9c91b33ff3aadb67e8baa6f683b8ed4db0ca5c107137f406a6ffafeb16b0e7',
                    sequence: 4294967294,
                    n: 1,
                    addresses: ['bc1q8de0s529sqvm660tk4df9j4z5jdcnsxafp2033'],
                    isAddress: true,
                    isOwn: true,
                    value: '61964',
                    isAccountOwned: true,
                },
                {
                    txid: 'e147a67e4ba5244c1845a91250d99510ccf5751dd5de506a4dea0df18be375b0',
                    sequence: 4294967294,
                    n: 2,
                    addresses: ['bc1qvgq6anu0eyqaln06jzd0ljf8qt6sh26xaehyf6'],
                    isAddress: true,
                    isOwn: true,
                    value: '133800',
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '24800',
                    n: 0,
                    spent: true,
                    spentTxId: 'b8ccb6e85d3c5fe008b0534d4f9ff8b1de71f2b7a3d856490b9a96f6ae1e49bb',
                    spentHeight: 781958,
                    hex: '0014957deec8aa0416bcc1f8a590e2f2bd65a573baba',
                    addresses: ['bc1qj477aj92qsttes0c5kgw9u4avkjh8w46kpf2ae'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
                {
                    value: '200000',
                    n: 1,
                    spent: true,
                    spentTxId: '3216d57139f6ec27425dfc821e7077051a976c3db7ab8e4420dfc15b42735da1',
                    spentHeight: 779104,
                    hex: '0020626e32ac8e30c5dbcf92c4c289b14a28b53ddea1d8e135ca28e75fdabd5bfcc1',
                    addresses: ['bc1qvfhr9tywxrzahnujcnpgnv229z6nmh4pmrsntj3gua0a402mlnqsh9nuph'],
                    isAddress: true,
                },
            ],
            size: 533,
            totalInput: '227155',
            totalOutput: '224800',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'sent',
        txid: 'e147a67e4ba5244c1845a91250d99510ccf5751dd5de506a4dea0df18be375b0',
        blockTime: 1675087005,
        blockHeight: 774339,
        blockHash: '00000000000000000006d3423ed87843cf4cf4563d079ed798cb3e2a0666daf3',
        lockTime: 774336,
        amount: '250000',
        fee: '182',
        vsize: 141,
        feeRate: '1.29',
        targets: [
            {
                n: 1,
                addresses: ['bc1qhlfzn0nv40c3rj3hygrcz68rd3uf53makrw3wu'],
                isAddress: true,
                amount: '250000',
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: 'b69218afce1575bc1463fcf8833bfb89a2cead504b51b906d9cc118d642672db',
                    vout: 1,
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1q5znx6jmsy740wp66t5meau44jux4ek7hp9x3k0'],
                    isAddress: true,
                    isOwn: true,
                    value: '383982',
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '133800',
                    n: 0,
                    spent: true,
                    spentTxId: '85c6a01a7480aa98b342dfc4299a5682f9d0f35938f2c625758538db0b4a5c6e',
                    spentIndex: 2,
                    spentHeight: 775449,
                    hex: '00146201aecf8fc901dfcdfa909affc92702f50bab46',
                    addresses: ['bc1qvgq6anu0eyqaln06jzd0ljf8qt6sh26xaehyf6'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
                {
                    value: '250000',
                    n: 1,
                    spent: true,
                    spentTxId: 'a3ead64609f5684d115eed1a7ed1169721edb4582a22233b2b07288501eef3bd',
                    spentHeight: 774356,
                    hex: '0014bfd229be6cabf111ca3722078168e36c789a477d',
                    addresses: ['bc1qhlfzn0nv40c3rj3hygrcz68rd3uf53makrw3wu'],
                    isAddress: true,
                },
            ],
            size: 223,
            totalInput: '383982',
            totalOutput: '383800',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'recv',
        txid: '9a9c91b33ff3aadb67e8baa6f683b8ed4db0ca5c107137f406a6ffafeb16b0e7',
        blockTime: 1673263501,
        blockHeight: 771110,
        blockHash: '00000000000000000006703ea31d9a5e05dc665f6a45b3ce08650a735cea8196',
        lockTime: 771108,
        amount: '61964',
        fee: '179',
        vsize: 137,
        feeRate: '1.31',
        targets: [
            {
                n: 0,
                addresses: ['bc1q8de0s529sqvm660tk4df9j4z5jdcnsxafp2033'],
                isAddress: true,
                amount: '61964',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: 'b69218afce1575bc1463fcf8833bfb89a2cead504b51b906d9cc118d642672db',
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qyf932z68hj4s3zcgrg622fqnj04h50sqymsf5h45khaqkpk7qm9sfd9wrq'],
                    isAddress: true,
                    value: '62143',
                },
            ],
            vout: [
                {
                    value: '61964',
                    n: 0,
                    spent: true,
                    spentTxId: '85c6a01a7480aa98b342dfc4299a5682f9d0f35938f2c625758538db0b4a5c6e',
                    spentIndex: 1,
                    spentHeight: 775449,
                    hex: '00143b72f851458019bd69ebb55a92caa2a49b89c0dd',
                    addresses: ['bc1q8de0s529sqvm660tk4df9j4z5jdcnsxafp2033'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 302,
            totalInput: '62143',
            totalOutput: '61964',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'sent',
        txid: 'b69218afce1575bc1463fcf8833bfb89a2cead504b51b906d9cc118d642672db',
        blockTime: 1673253283,
        blockHeight: 771093,
        blockHash: '00000000000000000007e51f2a3a2057c49ec41e01539ee6b2c59c171af5252f',
        amount: '62143',
        fee: '153',
        vsize: 153,
        feeRate: '1',
        targets: [
            {
                n: 0,
                addresses: ['bc1qyf932z68hj4s3zcgrg622fqnj04h50sqymsf5h45khaqkpk7qm9sfd9wrq'],
                isAddress: true,
                amount: '62143',
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: 'e012bc7dbab58527d09b60339a9b1eccfa488ad1f571bbb4d981cbe0dac2f8bd',
                    vout: 1,
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qgumedq8968wxv8dfqapnqa9s9uzmhwqca7gl8j'],
                    isAddress: true,
                    isOwn: true,
                    value: '446278',
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '62143',
                    n: 0,
                    spent: true,
                    spentTxId: '9a9c91b33ff3aadb67e8baa6f683b8ed4db0ca5c107137f406a6ffafeb16b0e7',
                    spentHeight: 771110,
                    hex: '0020224b150b47bcab088b081a34a5241393eb7a3e0026e09a5eb4b5fa0b06de06cb',
                    addresses: ['bc1qyf932z68hj4s3zcgrg622fqnj04h50sqymsf5h45khaqkpk7qm9sfd9wrq'],
                    isAddress: true,
                },
                {
                    value: '383982',
                    n: 1,
                    spent: true,
                    spentTxId: 'e147a67e4ba5244c1845a91250d99510ccf5751dd5de506a4dea0df18be375b0',
                    spentHeight: 774339,
                    hex: '0014a0a66d4b7027aaf7075a5d379ef2b5970d5cdbd7',
                    addresses: ['bc1q5znx6jmsy740wp66t5meau44jux4ek7hp9x3k0'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 234,
            totalInput: '446278',
            totalOutput: '446125',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'recv',
        txid: '727f252c6fa4f9b7cc3d2b33368a3acae4d9773e66cab0106e01f85c999839f7',
        blockTime: 1672763404,
        blockHeight: 770205,
        blockHash: '0000000000000000000182e2c3b45a8d980f36b801296556c8d53df098ba6c02',
        lockTime: 770202,
        amount: '31391',
        fee: '290',
        vsize: 137,
        feeRate: '2.12',
        targets: [
            {
                n: 0,
                addresses: ['bc1quk722fnq5rc30rc5xlc9w68zye8kwzv84k6lkz'],
                isAddress: true,
                amount: '31391',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: 'e012bc7dbab58527d09b60339a9b1eccfa488ad1f571bbb4d981cbe0dac2f8bd',
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1q34p2df0jhgyfued9kfy2z7z4979wdzktsvg8skcq5mel993pat9q6jts5u'],
                    isAddress: true,
                    value: '31681',
                },
            ],
            vout: [
                {
                    value: '31391',
                    n: 0,
                    spent: true,
                    spentTxId: '85c6a01a7480aa98b342dfc4299a5682f9d0f35938f2c625758538db0b4a5c6e',
                    spentHeight: 775449,
                    hex: '0014e5bca52660a0f1178f1437f05768e2264f670987',
                    addresses: ['bc1quk722fnq5rc30rc5xlc9w68zye8kwzv84k6lkz'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 302,
            totalInput: '31681',
            totalOutput: '31391',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'sent',
        txid: 'e012bc7dbab58527d09b60339a9b1eccfa488ad1f571bbb4d981cbe0dac2f8bd',
        blockTime: 1672762602,
        blockHeight: 770203,
        blockHash: '00000000000000000001da294c9384eb80ff90799f64ab47c5009a6d24b445b1',
        amount: '31681',
        fee: '765',
        vsize: 153,
        feeRate: '5',
        targets: [
            {
                n: 0,
                addresses: ['bc1q34p2df0jhgyfued9kfy2z7z4979wdzktsvg8skcq5mel993pat9q6jts5u'],
                isAddress: true,
                amount: '31681',
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: '46a28891773771da9067dfde7e4dfadadce0995a4772e3461214c47cbcd11eb5',
                    vout: 1,
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qux7xuufl8l4wh8r0lf2mye2mq28qyjwucfntdf'],
                    isAddress: true,
                    isOwn: true,
                    value: '478724',
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '31681',
                    n: 0,
                    spent: true,
                    spentTxId: '727f252c6fa4f9b7cc3d2b33368a3acae4d9773e66cab0106e01f85c999839f7',
                    spentHeight: 770205,
                    hex: '00208d42a6a5f2ba089e65a5b248a178552f8ae68acb8310785b00a6f3f29621eaca',
                    addresses: ['bc1q34p2df0jhgyfued9kfy2z7z4979wdzktsvg8skcq5mel993pat9q6jts5u'],
                    isAddress: true,
                },
                {
                    value: '446278',
                    n: 1,
                    spent: true,
                    spentTxId: 'b69218afce1575bc1463fcf8833bfb89a2cead504b51b906d9cc118d642672db',
                    spentHeight: 771093,
                    hex: '001447379680e5d1dc661da907433074b02f05bbb818',
                    addresses: ['bc1qgumedq8968wxv8dfqapnqa9s9uzmhwqca7gl8j'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 235,
            totalInput: '478724',
            totalOutput: '477959',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'sent',
        txid: '46a28891773771da9067dfde7e4dfadadce0995a4772e3461214c47cbcd11eb5',
        blockTime: 1671124142,
        blockHeight: 767548,
        blockHash: '0000000000000000000068d2e2126ef7490e4ab49a23e36742e334ba82e69dbb',
        amount: '10159',
        fee: '141',
        vsize: 141,
        feeRate: '1',
        targets: [
            {
                n: 0,
                addresses: ['bc1q7ujq3l9lr9exkdnvvdt7ltme8dfg3f62czww5v'],
                isAddress: true,
                amount: '10159',
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: '1e9aa3aaa2e2d0c068848164698c5bfed70a747c55cbf5bd50e057fb2179ec84',
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qm8gyv254t3nf45x7wc2luwjlueymrlem9da40z'],
                    isAddress: true,
                    isOwn: true,
                    value: '489024',
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '10159',
                    n: 0,
                    hex: '0014f72408fcbf19726b366c6357efaf793b5288a74a',
                    addresses: ['bc1q7ujq3l9lr9exkdnvvdt7ltme8dfg3f62czww5v'],
                    isAddress: true,
                },
                {
                    value: '478724',
                    n: 1,
                    spent: true,
                    spentTxId: 'e012bc7dbab58527d09b60339a9b1eccfa488ad1f571bbb4d981cbe0dac2f8bd',
                    spentHeight: 770203,
                    hex: '0014e1bc6e713f3feaeb9c6ffa55b2655b028e0249dc',
                    addresses: ['bc1qux7xuufl8l4wh8r0lf2mye2mq28qyjwucfntdf'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 223,
            totalInput: '489024',
            totalOutput: '488883',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'recv',
        txid: 'c6529a24fa5133f0f39935a9ac930cc84c412d0dd7be48179d9f03238ee1e1ac',
        blockTime: 1671107422,
        blockHeight: 767516,
        blockHash: '000000000000000000076794a44bb5208940b9a020acbe238537b26f731f7fbf',
        amount: '2798',
        fee: '330',
        vsize: 110,
        feeRate: '3',
        targets: [
            {
                n: 0,
                addresses: ['bc1q9vj2rrrqxuqs6quzj9havx0mj9ctuhwykyzmcx'],
                isAddress: true,
                amount: '2798',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: 'a996c7b98aea76da709486425ccf01b4764b69b83eebd60d38a26aaa8fddd462',
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qr0vhxdfvk023rrvd7znd9v5d6xz5zxlp0qzd98'],
                    isAddress: true,
                    value: '3128',
                },
            ],
            vout: [
                {
                    value: '2798',
                    n: 0,
                    spent: true,
                    spentTxId: 'f7c9f241d186d96e17939409e76cd80a8f7a2c0ab53e3453201b6d810e5d519d',
                    spentIndex: 3,
                    spentHeight: 783739,
                    hex: '00142b24a18c6037010d0382916fd619fb9170be5dc4',
                    addresses: ['bc1q9vj2rrrqxuqs6quzj9havx0mj9ctuhwykyzmcx'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 192,
            totalInput: '3128',
            totalOutput: '2798',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'recv',
        txid: '1907c19ccf24aba0798b4d73f4f537af5767c978bbfb48e526d90c32350701fc',
        blockTime: 1671107422,
        blockHeight: 767516,
        blockHash: '000000000000000000076794a44bb5208940b9a020acbe238537b26f731f7fbf',
        amount: '20608',
        fee: '942',
        vsize: 313,
        feeRate: '3.01',
        targets: [
            {
                n: 0,
                addresses: ['bc1qn7kj622yfrn695qv9rqcaxpwlltnfynxd0zt0z'],
                isAddress: true,
                amount: '20608',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: '2bb60f922f6144c1dde1b1393d080dd02f097d571bca75cd16d3e9e221dbdd06',
                    vout: 1,
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1q59xd6fxe83yyzak708gywqvxuwcu2y3d654aa5'],
                    isAddress: true,
                    value: '8615',
                },
                {
                    txid: '5cbc54620a23f28cb035c55994ada88ea605e9609bebdbc9555b642967e1bed3',
                    vout: 1,
                    sequence: 4294967293,
                    n: 1,
                    addresses: ['bc1qjs9u65ajwa90vy99r3c0stns2sz2gvxjue730m'],
                    isAddress: true,
                    value: '5565',
                },
                {
                    txid: 'a996c7b98aea76da709486425ccf01b4764b69b83eebd60d38a26aaa8fddd462',
                    vout: 1,
                    sequence: 4294967293,
                    n: 2,
                    addresses: ['bc1qtnph3g3wcqtvfutqrjcdqyj5wh563tgl3wpqkt'],
                    isAddress: true,
                    value: '5663',
                },
                {
                    txid: 'fae7917a95db51cfc64908c203577268b02a5fa642cd9355d0cf5dec75a3f16b',
                    sequence: 4294967293,
                    n: 3,
                    addresses: ['bc1q8efpng2qmx475jkq5h69qmt989c4a4ey0dsvjj'],
                    isAddress: true,
                    value: '1707',
                },
            ],
            vout: [
                {
                    value: '20608',
                    n: 0,
                    spent: true,
                    spentTxId: 'f7c9f241d186d96e17939409e76cd80a8f7a2c0ab53e3453201b6d810e5d519d',
                    spentHeight: 783739,
                    hex: '00149fad2d294448e7a2d00c28c18e982effd7349266',
                    addresses: ['bc1qn7kj622yfrn695qv9rqcaxpwlltnfynxd0zt0z'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 637,
            totalInput: '21550',
            totalOutput: '20608',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'self',
        txid: '1e9aa3aaa2e2d0c068848164698c5bfed70a747c55cbf5bd50e057fb2179ec84',
        blockTime: 1671047702,
        blockHeight: 767426,
        blockHash: '00000000000000000003f34b5f178ba0641864059ccfb9a54c4bf09c9644db67',
        amount: '382',
        fee: '382',
        vsize: 381,
        feeRate: '1',
        targets: [
            {
                n: 0,
                addresses: ['bc1qm8gyv254t3nf45x7wc2luwjlueymrlem9da40z'],
                isAddress: true,
                amount: '489024',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: '351458fb36870aba92e43038d4fd6af1500984cb09f1d8570d06c89582966b7f',
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qph5vk20vl5sjltxus0s82gwug0vum5hkganr2g'],
                    isAddress: true,
                    isOwn: true,
                    value: '30807',
                    isAccountOwned: true,
                },
                {
                    txid: '4eef819cea666c796c597dd1ffa8cc71ad0d794ea65e2933fba9e6556b58a95c',
                    vout: 1,
                    sequence: 4294967293,
                    n: 1,
                    addresses: ['bc1qxm4qkadavwptrdlp9p80rmxn7dlhfvte050ewl'],
                    isAddress: true,
                    isOwn: true,
                    value: '433756',
                    isAccountOwned: true,
                },
                {
                    txid: '95ac28eec140ccf3e8416401881d1cbfe2a8ffc81fa6f8b6278a1289d3dea34d',
                    sequence: 4294967293,
                    n: 2,
                    addresses: ['bc1qa5e54k3p2cw3dmzdvzc0ehgg3wtvrv74lrtngj'],
                    isAddress: true,
                    isOwn: true,
                    value: '5000',
                    isAccountOwned: true,
                },
                {
                    txid: 'a3688b100da54ea4cc34d5727efc52a1fe1bbc73956ff5f74d58274fb29a59b5',
                    vout: 1,
                    sequence: 4294967293,
                    n: 3,
                    addresses: ['bc1q569v8dpu2w9mfy0vxch8zfcg68s782kvh0f5cr'],
                    isAddress: true,
                    isOwn: true,
                    value: '11433',
                    isAccountOwned: true,
                },
                {
                    txid: 'fae7917a95db51cfc64908c203577268b02a5fa642cd9355d0cf5dec75a3f16b',
                    vout: 1,
                    sequence: 4294967293,
                    n: 4,
                    addresses: ['bc1qapt7c0lncw6w2lzh2c275d2zq6t4z7h38swaqv'],
                    isAddress: true,
                    isOwn: true,
                    value: '8410',
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '489024',
                    n: 0,
                    spent: true,
                    spentTxId: '46a28891773771da9067dfde7e4dfadadce0995a4772e3461214c47cbcd11eb5',
                    spentHeight: 767548,
                    hex: '0014d9d0462a955c669ad0de7615fe3a5fe649b1ff3b',
                    addresses: ['bc1qm8gyv254t3nf45x7wc2luwjlueymrlem9da40z'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 783,
            totalInput: '489406',
            totalOutput: '489024',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'recv',
        txid: 'fae7917a95db51cfc64908c203577268b02a5fa642cd9355d0cf5dec75a3f16b',
        blockTime: 1671010442,
        blockHeight: 767365,
        blockHash: '00000000000000000001c0ca2b5cb4aeb75a0de95d36372fa10dc54805b3b246',
        amount: '8410',
        fee: '282',
        vsize: 141,
        feeRate: '2',
        targets: [
            {
                n: 1,
                addresses: ['bc1qapt7c0lncw6w2lzh2c275d2zq6t4z7h38swaqv'],
                isAddress: true,
                amount: '8410',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: 'a3688b100da54ea4cc34d5727efc52a1fe1bbc73956ff5f74d58274fb29a59b5',
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qqwyz2r8arwg3zx28kmlmr3ve7xud4see2paqkv'],
                    isAddress: true,
                    value: '10399',
                },
            ],
            vout: [
                {
                    value: '1707',
                    n: 0,
                    spent: true,
                    spentTxId: '1907c19ccf24aba0798b4d73f4f537af5767c978bbfb48e526d90c32350701fc',
                    spentIndex: 3,
                    spentHeight: 767516,
                    hex: '00143e5219a140d9abea4ac0a5f4506d6539715ed724',
                    addresses: ['bc1q8efpng2qmx475jkq5h69qmt989c4a4ey0dsvjj'],
                    isAddress: true,
                },
                {
                    value: '8410',
                    n: 1,
                    spent: true,
                    spentTxId: '1e9aa3aaa2e2d0c068848164698c5bfed70a747c55cbf5bd50e057fb2179ec84',
                    spentIndex: 4,
                    spentHeight: 767426,
                    hex: '0014e857ec3ff3c3b4e57c575615ea35420697517af1',
                    addresses: ['bc1qapt7c0lncw6w2lzh2c275d2zq6t4z7h38swaqv'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 223,
            totalInput: '10399',
            totalOutput: '10117',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'recv',
        txid: 'a3688b100da54ea4cc34d5727efc52a1fe1bbc73956ff5f74d58274fb29a59b5',
        blockTime: 1670939471,
        blockHeight: 767220,
        blockHash: '0000000000000000000774d2b00ffd464f6bf2d4502f34ac6dff99f0fee6b300',
        amount: '11433',
        fee: '627',
        vsize: 209,
        feeRate: '3',
        targets: [
            {
                n: 1,
                addresses: ['bc1q569v8dpu2w9mfy0vxch8zfcg68s782kvh0f5cr'],
                isAddress: true,
                amount: '11433',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: '588064cd49212b5579014af1ae529fa4970e14020507a49e69499e89300ed35b',
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1q7p7jygzj277vqde9qwnnfww32cyyd5m3qz8aam'],
                    isAddress: true,
                    value: '10712',
                },
                {
                    txid: 'eb15ad888d1593d41d71afab6070cdf52b775adbe36dc6b66f9b3f0f72215b19',
                    vout: 1,
                    sequence: 4294967293,
                    n: 1,
                    addresses: ['bc1q2qynn6qjk89g68fuag4vpkgxwmjvu0s5ehunre'],
                    isAddress: true,
                    value: '11747',
                },
            ],
            vout: [
                {
                    value: '10399',
                    n: 0,
                    spent: true,
                    spentTxId: 'fae7917a95db51cfc64908c203577268b02a5fa642cd9355d0cf5dec75a3f16b',
                    spentHeight: 767365,
                    hex: '00140388250cfd1b91111947b6ffb1c599f1b8dac339',
                    addresses: ['bc1qqwyz2r8arwg3zx28kmlmr3ve7xud4see2paqkv'],
                    isAddress: true,
                },
                {
                    value: '11433',
                    n: 1,
                    spent: true,
                    spentTxId: '1e9aa3aaa2e2d0c068848164698c5bfed70a747c55cbf5bd50e057fb2179ec84',
                    spentIndex: 3,
                    spentHeight: 767426,
                    hex: '0014a68ac3b43c538bb491ec362e712708d1e1e3aacc',
                    addresses: ['bc1q569v8dpu2w9mfy0vxch8zfcg68s782kvh0f5cr'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 372,
            totalInput: '22459',
            totalOutput: '21832',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'recv',
        txid: '351458fb36870aba92e43038d4fd6af1500984cb09f1d8570d06c89582966b7f',
        blockTime: 1670375884,
        blockHeight: 766214,
        blockHash: '000000000000000000044c1ec9dd567179b8f8394c2c33b105b1e1efb1a8dcd7',
        lockTime: 766151,
        amount: '30807',
        fee: '110',
        vsize: 110,
        feeRate: '1',
        targets: [
            {
                n: 0,
                addresses: ['bc1qph5vk20vl5sjltxus0s82gwug0vum5hkganr2g'],
                isAddress: true,
                amount: '30807',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: '4eef819cea666c796c597dd1ffa8cc71ad0d794ea65e2933fba9e6556b58a95c',
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qed83uzy60fjp80453v0pvwc4zkk23c27k57lh2'],
                    isAddress: true,
                    value: '30917',
                },
            ],
            vout: [
                {
                    value: '30807',
                    n: 0,
                    spent: true,
                    spentTxId: '1e9aa3aaa2e2d0c068848164698c5bfed70a747c55cbf5bd50e057fb2179ec84',
                    spentHeight: 767426,
                    hex: '00140de8cb29ecfd212facdc83e07521dc43d9cdd2f6',
                    addresses: ['bc1qph5vk20vl5sjltxus0s82gwug0vum5hkganr2g'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 191,
            totalInput: '30917',
            totalOutput: '30807',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'sent',
        txid: '4eef819cea666c796c597dd1ffa8cc71ad0d794ea65e2933fba9e6556b58a95c',
        blockTime: 1670332769,
        blockHeight: 766149,
        blockHash: '000000000000000000016e4193014dd008ac6f8c7377d6245f5e4df7d5c08f1a',
        amount: '30917',
        fee: '141',
        vsize: 141,
        feeRate: '1',
        targets: [
            {
                n: 0,
                addresses: ['bc1qed83uzy60fjp80453v0pvwc4zkk23c27k57lh2'],
                isAddress: true,
                amount: '30917',
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: '7a40e7fba7af291db41b614fb16c452ebc3b5a3a5fcb6569c76a586d9d316bd9',
                    vout: 1,
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qnwvem4f238u6dkz7zn53an4h2ealr390h7284t'],
                    isAddress: true,
                    isOwn: true,
                    value: '464814',
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '30917',
                    n: 0,
                    spent: true,
                    spentTxId: '351458fb36870aba92e43038d4fd6af1500984cb09f1d8570d06c89582966b7f',
                    spentHeight: 766214,
                    hex: '0014cb4f1e089a7a6413beb48b1e163b1515aca8e15e',
                    addresses: ['bc1qed83uzy60fjp80453v0pvwc4zkk23c27k57lh2'],
                    isAddress: true,
                },
                {
                    value: '433756',
                    n: 1,
                    spent: true,
                    spentTxId: '1e9aa3aaa2e2d0c068848164698c5bfed70a747c55cbf5bd50e057fb2179ec84',
                    spentIndex: 1,
                    spentHeight: 767426,
                    hex: '001436ea0b75bd6382b1b7e1284ef1ecd3f37f74b179',
                    addresses: ['bc1qxm4qkadavwptrdlp9p80rmxn7dlhfvte050ewl'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 222,
            totalInput: '464814',
            totalOutput: '464673',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'sent',
        txid: '7a40e7fba7af291db41b614fb16c452ebc3b5a3a5fcb6569c76a586d9d316bd9',
        blockTime: 1666697866,
        blockHeight: 760240,
        blockHash: '00000000000000000001c89705ee1d86ecd6fc8fdb5f4418b81bbcd68912f8de',
        amount: '51133',
        fee: '141',
        vsize: 141,
        feeRate: '1',
        targets: [
            {
                n: 0,
                addresses: ['bc1qwscpsjhu0f3rc8fuffgrc8efrc9pq6dpsrzgyr'],
                isAddress: true,
                amount: '51133',
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: '95ac28eec140ccf3e8416401881d1cbfe2a8ffc81fa6f8b6278a1289d3dea34d',
                    vout: 1,
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qdy0jxh83s5ddtw6dctjr8jwpcl7fjn9z3cjlux'],
                    isAddress: true,
                    isOwn: true,
                    value: '516088',
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '51133',
                    n: 0,
                    spent: true,
                    spentTxId: 'd1ad78bc1e26740eb8c1e26a9113a21019f531c0b96c81bac357d2ad7bb476ee',
                    spentHeight: 765507,
                    hex: '00147430184afc7a623c1d3c4a503c1f291e0a1069a1',
                    addresses: ['bc1qwscpsjhu0f3rc8fuffgrc8efrc9pq6dpsrzgyr'],
                    isAddress: true,
                },
                {
                    value: '464814',
                    n: 1,
                    spent: true,
                    spentTxId: '4eef819cea666c796c597dd1ffa8cc71ad0d794ea65e2933fba9e6556b58a95c',
                    spentHeight: 766149,
                    hex: '00149b999dd52a89f9a6d85e14e91eceb7567bf1c4af',
                    addresses: ['bc1qnwvem4f238u6dkz7zn53an4h2ealr390h7284t'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 222,
            totalInput: '516088',
            totalOutput: '515947',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'self',
        txid: '95ac28eec140ccf3e8416401881d1cbfe2a8ffc81fa6f8b6278a1289d3dea34d',
        blockTime: 1666021435,
        blockHeight: 759095,
        blockHash: '00000000000000000007d6d93fd9680e6bbef9d376d8bef3f08212a33517e47f',
        amount: '141',
        fee: '141',
        vsize: 141,
        feeRate: '1',
        targets: [
            {
                n: 0,
                addresses: ['bc1qa5e54k3p2cw3dmzdvzc0ehgg3wtvrv74lrtngj'],
                isAddress: true,
                amount: '5000',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: 'dfdc5af5fae8fd0681907a32bab361e356535be70bacebb64586b23a38bd5a5e',
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qfqnh5gxudypnleshwhh5lal5339tkvr5fsxjtl'],
                    isAddress: true,
                    isOwn: true,
                    value: '521229',
                    isAccountOwned: true,
                },
            ],
            vout: [
                {
                    value: '5000',
                    n: 0,
                    spent: true,
                    spentTxId: '1e9aa3aaa2e2d0c068848164698c5bfed70a747c55cbf5bd50e057fb2179ec84',
                    spentIndex: 2,
                    spentHeight: 767426,
                    hex: '0014ed334ada21561d16ec4d60b0fcdd088b96c1b3d5',
                    addresses: ['bc1qa5e54k3p2cw3dmzdvzc0ehgg3wtvrv74lrtngj'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
                {
                    value: '516088',
                    n: 1,
                    spent: true,
                    spentTxId: '7a40e7fba7af291db41b614fb16c452ebc3b5a3a5fcb6569c76a586d9d316bd9',
                    spentHeight: 760240,
                    hex: '0014691f235cf1851ad5bb4dc2e433c9c1c7fc994ca2',
                    addresses: ['bc1qdy0jxh83s5ddtw6dctjr8jwpcl7fjn9z3cjlux'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 222,
            totalInput: '521229',
            totalOutput: '521088',
        },
    },
    {
        descriptor:
            'zpub6rjNNddoAVvuYaD6WPdxiqFEToQHgrERjWMg7kM9gGGk6rhPMWNEmL5X745FGqBq8Wp136LfA3A7UjRGEYdJrf8dUfshzNrb5rvaryNfVJf',
        deviceState: 'state@hiddenDeviceWithImportedAccounts:1',
        symbol: 'btc',
        type: 'recv',
        txid: 'dfdc5af5fae8fd0681907a32bab361e356535be70bacebb64586b23a38bd5a5e',
        blockTime: 1665666497,
        blockHeight: 758471,
        blockHash: '0000000000000000000751d6abf5434290e196be8e53905ba4d07a12faceb718',
        amount: '521229',
        fee: '880',
        vsize: 110,
        feeRate: '8',
        targets: [
            {
                n: 0,
                addresses: ['bc1qfqnh5gxudypnleshwhh5lal5339tkvr5fsxjtl'],
                isAddress: true,
                amount: '521229',
                isAccountTarget: true,
            },
        ],
        tokens: [],
        internalTransfers: [],
        rbf: true,
        details: {
            vin: [
                {
                    txid: 'db6046541a59e61c4a7fffaa41a49b3a9cc3215aea724ffb175d1de99c5dbb94',
                    vout: 1,
                    sequence: 4294967293,
                    n: 0,
                    addresses: ['bc1qeu4u5sredlsjvw7yhkrpvm79479yrcz9dl2r70'],
                    isAddress: true,
                    value: '522109',
                },
            ],
            vout: [
                {
                    value: '521229',
                    n: 0,
                    spent: true,
                    spentTxId: '95ac28eec140ccf3e8416401881d1cbfe2a8ffc81fa6f8b6278a1289d3dea34d',
                    spentHeight: 759095,
                    hex: '001448277a20dc69033fe61775ef4ff7f48c4abb3074',
                    addresses: ['bc1qfqnh5gxudypnleshwhh5lal5339tkvr5fsxjtl'],
                    isAddress: true,
                    isOwn: true,
                    isAccountOwned: true,
                },
            ],
            size: 191,
            totalInput: '522109',
            totalOutput: '521229',
        },
    },
];

export const btcAccountBalanceHistoryResult: AccountHistoryMovementItem[] = [
    { time: 1665666497, txs: 1, received: '521229', sent: '0', sentToSelf: '0' },
    { time: 1666021435, txs: 1, received: '521088', sent: '521229', sentToSelf: '521088' },
    { time: 1666697866, txs: 1, received: '464814', sent: '516088', sentToSelf: '464814' },
    { time: 1670332769, txs: 1, received: '433756', sent: '464814', sentToSelf: '433756' },
    { time: 1670375884, txs: 1, received: '30807', sent: '0', sentToSelf: '0' },
    { time: 1670939471, txs: 1, received: '11433', sent: '0', sentToSelf: '0' },
    { time: 1671010442, txs: 1, received: '8410', sent: '0', sentToSelf: '0' },
    { time: 1671047702, txs: 1, received: '489024', sent: '489406', sentToSelf: '489024' },
    { time: 1671107422, txs: 2, received: '23406', sent: '0', sentToSelf: '0' },
    { time: 1671124142, txs: 1, received: '478724', sent: '489024', sentToSelf: '478724' },
    { time: 1672762602, txs: 1, received: '446278', sent: '478724', sentToSelf: '446278' },
    { time: 1672763404, txs: 1, received: '31391', sent: '0', sentToSelf: '0' },
    { time: 1673253283, txs: 1, received: '383982', sent: '446278', sentToSelf: '383982' },
    { time: 1673263501, txs: 1, received: '61964', sent: '0', sentToSelf: '0' },
    { time: 1675087005, txs: 1, received: '133800', sent: '383982', sentToSelf: '133800' },
    { time: 1675784738, txs: 1, received: '24800', sent: '227155', sentToSelf: '24800' },
    { time: 1677839961, txs: 1, received: '194211', sent: '0', sentToSelf: '0' },
    { time: 1678101937, txs: 1, received: '142047', sent: '194211', sentToSelf: '142047' },
    { time: 1678187959, txs: 1, received: '37813', sent: '142047', sentToSelf: '37813' },
    { time: 1679482960, txs: 1, received: '19580', sent: '62613', sentToSelf: '19580' },
    { time: 1680515463, txs: 1, received: '140899', sent: '42986', sentToSelf: '140899' },
    { time: 1680694226, txs: 1, received: '38275', sent: '110000', sentToSelf: '38275' },
    { time: 1694466639, txs: 1, received: '6248', sent: '69174', sentToSelf: '6248' },
    { time: 1694515520, txs: 1, received: '138577', sent: '0', sentToSelf: '0' },
    { time: 1698402008, txs: 1, received: '124579', sent: '0', sentToSelf: '0' },
    { time: 1711110549, txs: 1, received: '0', sent: '269404', sentToSelf: '0' },
    { time: 1711118625, txs: 1, received: '77623', sent: '0', sentToSelf: '0' },
    { time: 1711445680, txs: 1, received: '181023', sent: '0', sentToSelf: '0' },
    { time: 1712963150, txs: 1, received: '0', sent: '77623', sentToSelf: '0' },
].map(item => ({
    ...item,
    received: new BigNumber(item.received),
    sent: new BigNumber(item.sent),
    sentToSelf: new BigNumber(item.sentToSelf),
}));
