#!/usr/bin/env bash

# Paths
JSON_PATH='./submodules/trezor-common/models.json'
TS_PATH='./packages/connect/src/data/models.ts'

# Check if the JSON file exists
if [ ! -f "$JSON_PATH" ]; then
    echo "JSON file does not exist: $JSON_PATH"
    exit 1
fi

echo "// !!! IMPORTANT: This file is autogenerated !!! use yarn update-models"

# Begin the output with the export declaration
echo "export const models = " > "$TS_PATH"

# Append the JSON content to the .ts file
if cat "$JSON_PATH" >> "$TS_PATH"; then
    echo "File converted and saved successfully to $TS_PATH!"
else
    echo "Operation failed!"
    exit 2
fi

yarn prettier --write $TS_PATH
