export default {
    valid: [
        {
            description: 'Version 1 transaction (1:1)',
            network: 'zcash',
            hex: '01000000013f5cdd55fac42f620796ac33f3acbce8417e75fde7457662fdc612c8759d400a01000000fdfd00004730440220785552c1ce40d5eba426b9a3b0e4e58cb243334f35290902d58746755c13531a02200801731fbda2a334f76b21732a5213b344edc2b966e149301ea688fc0df0abf901483045022100fa5027215031352af57ad343b6680aa47bbae174abec3450aaaf1811c9942a6d02202ce3d68ecc468381e0c4610493ff043ba61c8875e74d7d65b46f6e17f0583752014c695221037acffd52bb7c39a4ac3d4c01af33ce0367afec45347e332edca63a38d1fb2e472102658831a87322b3583515ca8725841335505755ada53ee133c70a6b4b8d3978702102641ee6557561c9038242cafa7f538070d7646a969bcf6169f9950abfcfefd6b853aeffffffff01601ce0110000000017a914040c4ab99a665c767adaa50fb28dce2ae514363b8700000000',
            id: '372602847af17b4b2df37a9d2d3f6e9fc2d602ccb6240ac4cd8c8d2f89145c9f',
            hash: '9f5c14892f8d8ccdc40a24b6cc02d6c29f6e3f2d9d7af32d4b7bf17a84022637',
            coinbase: false,
            virtualSize: 338,
            weight: 1352,
            raw: {
                version: 1,
                overwintered: 0,
                locktime: 0,
                expiry: 0,
                versionGroupId: 0,
                ins: [
                    {
                        hash: '3f5cdd55fac42f620796ac33f3acbce8417e75fde7457662fdc612c8759d400a',
                        index: 1,
                        data: '004730440220785552c1ce40d5eba426b9a3b0e4e58cb243334f35290902d58746755c13531a02200801731fbda2a334f76b21732a5213b344edc2b966e149301ea688fc0df0abf901483045022100fa5027215031352af57ad343b6680aa47bbae174abec3450aaaf1811c9942a6d02202ce3d68ecc468381e0c4610493ff043ba61c8875e74d7d65b46f6e17f0583752014c695221037acffd52bb7c39a4ac3d4c01af33ce0367afec45347e332edca63a38d1fb2e472102658831a87322b3583515ca8725841335505755ada53ee133c70a6b4b8d3978702102641ee6557561c9038242cafa7f538070d7646a969bcf6169f9950abfcfefd6b853ae',
                        sequence: 4294967295,
                    },
                ],
                outs: [
                    {
                        value: '299900000',
                        data: 'a914040c4ab99a665c767adaa50fb28dce2ae514363b87',
                    },
                ],
                joinsplitsLength: 0,
                joinsplitPubkeyLength: 0,
                joinsplitSigLength: 0,
            },
        },
        {
            description: 'Version 1 transaction (1:3)',
            network: 'zcash',
            hex: '01000000010000000000000000000000000000000000000000000000000000000000000000ffffffff0403058a00ffffffff03000d2834000000001976a9149c93193a41a0dcc93c8c6beefaab996084f2f83a88ac80b2e60e0000000017a914ab13d4675630d69f9c9000c701a981938b0d585d8700bd7207000000001976a914d45f8fdbd5624b89a720cd9c170d50927eac5bdc88ac00000000',
            id: 'ffffbf7899efc6e91209cf2d1029c7ad794427015f4648b83848e81e706dac87',
            hash: '87ac6d701ee84838b848465f01274479adc729102dcf0912e9c6ef9978bfffff',
            coinbase: true,
            virtualSize: 155,
            weight: 620,
            raw: {
                version: 1,
                overwintered: 0,
                locktime: 0,
                expiry: 0,
                versionGroupId: 0,
                ins: [
                    {
                        hash: '0000000000000000000000000000000000000000000000000000000000000000',
                        index: 4294967295,
                        data: '03058a00',
                        sequence: 4294967295,
                    },
                ],
                outs: [
                    {
                        value: '875040000',
                        data: '76a9149c93193a41a0dcc93c8c6beefaab996084f2f83a88ac',
                    },
                    {
                        value: '250000000',
                        data: 'a914ab13d4675630d69f9c9000c701a981938b0d585d87',
                    },
                    {
                        value: '124960000',
                        data: '76a914d45f8fdbd5624b89a720cd9c170d50927eac5bdc88ac',
                    },
                ],
                joinsplitsLength: 0,
                joinsplitPubkeyLength: 0,
                joinsplitSigLength: 0,
            },
        },
        {
            description: 'Version 2 transaction (3:1)',
            network: 'zcash',
            hex: '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',
            id: 'ffb606001b8a6e80fb883c6745618128208fafc94f8ea5eae4b5a1a2aa0a5a5e',
            hash: '5e5a0aaaa2a1b5e4eaa58e4fc9af8f2028816145673c88fb806e8a1b0006b6ff',
            coinbase: false,
            virtualSize: 2386,
            weight: 9544,
            raw: {
                version: 2,
                overwintered: 0,
                locktime: 0,
                expiry: 0,
                versionGroupId: 0,
                ins: [
                    {
                        hash: 'e9bf44b27f0784cfcb33f8c159f3b69b9726bc2214366ad834a678094f8d5de4',
                        index: 1,
                        data: '4830450221009ef714b94f700554711ae904a065de00e182fced0e82ac8dc109ba234c0bc5b102206bf2deae0168a69511821f7d754fcecf8d05a7d19fe77c5ebe2fb6b6c206c4df01210201d494a45f36f545443bafd1a9050b02f448dd236bb4ce2602f83978980b98f2',
                        sequence: 4294967295,
                    },
                    {
                        hash: '4761e1441eb007b7f339f57fd6f276965e1a53d5e5d585a7dbbc72ee2d44b62f',
                        index: 0,
                        data: '473044022047fce86902b769a329e2010bd3eaca8f6d3818b7adfe03982651fe2165d23b42022048a2246efbb7934aa06d11b621b51e70bb27ca66a57115b002d36158b9c0cc3f01210201d494a45f36f545443bafd1a9050b02f448dd236bb4ce2602f83978980b98f2',
                        sequence: 4294967295,
                    },
                    {
                        hash: 'd28cb1a3bd695b43bfdc59eaef5d047740955f057c36137e42ad92fcc55c7f17',
                        index: 2,
                        data: '483045022100a06516dd99e2c156755ab37ef776cc773d8404587ff7ae56d2ce716046cca7460220087543467d271c9af7bc998342349862833e7429ee0eebdd73b34129a918e92a01210201d494a45f36f545443bafd1a9050b02f448dd236bb4ce2602f83978980b98f2',
                        sequence: 4294967295,
                    },
                ],
                outs: [
                    {
                        value: '124044438',
                        data: '76a914d6733a8dfde223f481332d354847639d0fa9e20788ac',
                    },
                ],
                outsLength: 1,
                joinsplitsLength: 1,
                joinsplitPubkeyLength: 32,
                joinsplitSigLength: 64,
            },
            extraData:
                '013097402500000000000000000000000075d8accc9c558e6e3535081f24fe79dee3e6b25e0bb68e07419ba16bb1be9d8b3ca0418663fe179e6faed4b507917107bb5024da77d4fde616a53e2bb7815e16612cadcf85f574f7a88644b040412091ab63d30ff0ec82ff7af711753d76de91d4dd4f569ef7201bce0e0a5edc88ec1e98f86d2604f721f12e10e63b9093e4f065edb26a8e5e303b1ae6b67320ba25e97578d76cae6cf91e224d678010e49b17427db24e38a8cf1a7246ddd22b3e0254f4fda70d1391da4b0966f3e857b7e655b15a2d3bfb4b8e824ff9f5e0ed75112a671d5d44559ebf738b3a14f45d4342e84add4bbd5795f7c103d5175b7b633dc50063048bec71c18397f66673118ec7436378639f56c122e4454edbec93db27fa5fc34586596112079a43889d8ee7d5ed032bb412a7ea62fa71b648ca499c5420a2657863a882c0e059b9ea18d542ec704a03233b8a39e63824a83b2c3de172859c1d99bb40c6e87a9fb9da5b85f245176c8d0a02af17f894dd758f27ba00c6a5468ee0a2e8c2828866ef4a43f503603a26be98272b958ea77693cec47f274520034be49c8836bbe88fde847d566c69b97b3cb6030710a6b22983e4675371f4fb302732114ac0bfca7e50d4b0790fb8c496315c3c03011cf767bd6a6ea10b4cde14e5bdf995b63c72ab43c9bf1d6b680c1135b15ca70320a77cf95eea1147c81a353a0d7e0973805eab3a37324892157395b767a627630206dd9ea41df4fbe93203c3abcb28336cf8031519ef35f1d68cf00060e5e1385503060ccf460b70b23d03b9faabc4e564df87f66ee61abc376de156548d9d934351ede7e8809aead84fda544f5dc91371d4669949b4366d249f591aa842d5dc93d2b04adff389dbc442c67a86965b6391e71900b6b0bbf0eb8d8976e1d5a17807898e97e96b71ec97e69d179566b0a52937dae0aa945dc4fb9f65217518514b5c6c8fc706bb17823c6d7b924f99630a9636d4b04dcc687d5e1c539ad4a876638ac5eceaa1becface1846fbef96153cd7333cf1bab8f6d50605e21583a5a61230151edde9b3b9a2ea22484cdcd4e788bb4ee12b093db6ead549d75ceedaf33a3b94c7d93df4dde593aee0040408434c63057b945812c798e30b31724d7d2ba554545768cc6ad9f118632981c9092d15ae78ca927fbaf0ac5255f30179e5df952599c0f6225e6608a675bcc67fb424840ee0b043d18a68b4e660ec105d3c8e098ff8a30c3275428ba51e82947ae5918acad110bc60331b2130b60361581d073a0fa4648e485bdf632e4f6730987144b7852cfca4a854b09b18c174c4a9069d07774c0ff5444a994322d86a40d838cd7668b74c89abb5115a0d785def8f8c517b89433738148d3958f6ce5c2f6dea8ea05ba0011b9aa5344f42531279f9981bb6d73bc7dc9af76371645ae18b7c382ffe841f48469aa69291c191acbc5a14a3a6d80bad137b07b8c8f19f24c47c94e309e27591949add68d9c2267a8301fa35f9c385febb858b861857bc0c6c5ac7d5e5fb1a8d1cf11f48136406193f778a9b30ccb7685553671b2bb98e670c5c2a63a42427b8216e1d9444963a551fab436d5393bf54c6869ebe45243b6b015464143a2b80a53b63e978e862fc22f6b8359feba0d10ef4bf7178e69d6262acf6b22b9c93d0a2355df1695706b5c46477012a1bac72f67c60ec8bd869d54890c8dad256c23e3d0a325723c11b3112f5bd66df40e42c2ee19a6314d5c7dfd9a6cabb9ce41854d17ed68b6f934538330f30454cb0ea39ab7e2430d20ca5aa151afc13f1bb1a17da29d31d008863eb624f8d4bfec4b1ae15bcb7487c0d1b3c0db4bbfffa3f39c6fe0e4e57d223671198f798ac788521888caa9438b8dafed6b7eea6d703ea703459ecc2dfd770ea49de8546032ba426758c9e6f31044f01b6d788dc626a52f047e552c7bf60716b116ac8122dddba2d461896eebf3d8a8796947a3d301ace3cd0d4bc5ed8999835b54b5d0709878a0c522fa1d7835fe8fad03cbfde00ad8451041893a29d007e1a877cb60b547330935d7be2a56f93b54769bf23407edc488efc606e757186ea6eef2d251439aeac37a184be6b2d35776550358313d19ad5efc3547603eef8cedfbb516214a81e5db96b928d310600ada52f1e5144f1311299001a20b9a6b3e77b54e9475841c8ca50f7888bd3781bd736489c288137459b35ed809df719ce2730c91703442866ae9121396db1d48b9915a3b4a81a62e7d49b819cadc93299f31ca7b336e91528db788c0342d755b8aebe83f7ea978a6fd673b0b8c25771cda462f500bef6eb063b71134f61740acab1fc0d01e68b24204cbea6809ef84b1b290ce46fc809cf2a551550f61e0ec5d173e1ebead0869bff0b880aff71776286b2113fe3e0d82f2d362acf36077b939092ce941198bb203ce67036abd8860c4f786e32b3abbb302af9a24336d4ec56e36f35be5f1affefd271bd4fa0980b1106357fd7255d039211665317f4b957975adf75258935fe51e410806f2f3b9ea0283e51a8f481b27e85783a465ad6d10cf52554995a86a8174793e685de4401269145f79bf3d7d603903a07f03b7b2827c0b8e4e273df0fa8c0b95954715d68df17281ca9626e102385ea90b493764e982d76ed41887b6fcfff8ed3d17aa0d',
        },
        {
            description: 'Version 2 transaction (4:0) with JoinSplit',
            network: 'zcash',
            hex: '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',
            id: 'ffeaa08f91c87aa0fc493ffa080566913d36363a0dfbf3c4d41c02c2f5cb1f3d',
            hash: '3d1fcbf5c2021cd4c4f3fb0d3a36363d91660508fa3f49fca07ac8918fa0eaff',
            coinbase: false,
            virtualSize: 2497,
            weight: 9988,
            raw: {
                version: 2,
                overwintered: 0,
                locktime: 0,
                expiry: 0,
                versionGroupId: 0,
                ins: [
                    {
                        hash: '388550971589e75e5bb1028a36dea5e02553108d3a7fd6ff6b0f6ebba50a494d',
                        index: 0,
                        data: '4730440220118a49bf67eef4a98dc154c8f5422645fd979e4122205addd0a22dd60656b06c0220209da845f7bf3af9e7e7b9732e6fb3d2f09c94b401ee69fa17f987c77049673e012103e9083677f121003ab9abc4610194440e5605576cf67ed1e40b520aeeb8a04dde',
                        sequence: 4294967295,
                    },
                    {
                        hash: '5ce50e125eb8a70603debcd38ad2cfdaf1fbe9fffc87f2697f4fcd6eff6a1490',
                        index: 0,
                        data: '47304402205abb286d4757088d8259ab07e9f4aaf4d1a549f9fbce8308293095d264aae262022026ae2d5d255caa446da86ecd08ffc98dd221a115b3274bc4758efd381ad1abb8012103e9083677f121003ab9abc4610194440e5605576cf67ed1e40b520aeeb8a04dde',
                        sequence: 4294967295,
                    },
                    {
                        hash: 'c4af66507f7d97a3f74e88b0ab9fd39bc4bd3ce8c5374c366bb6cad22c1ef359',
                        index: 0,
                        data: '47304402205a4b852596ff9829098803d8eba6dda630bd6074c88ba16a3aa4c0a9f5b080b402200dbd820b579cd6f4d1efdf979e995d4dca1f5c61a812a15bcdc46981e2ddef7b012103e9083677f121003ab9abc4610194440e5605576cf67ed1e40b520aeeb8a04dde',
                        sequence: 4294967295,
                    },
                    {
                        hash: '0a2c229118bea9c5a415ec02b49c0eb6ac8a8f34047ce6df7d4fa67ad7e6bfbc',
                        index: 0,
                        data: '47304402204d212b232be4199f55210742d5d077187eabd1a1ed1354c3ffa2674fbf86a4900220365a049537a28d23c15d9c8283e95cc71a60a036ecb35a4d14eb3431a95bef04012103e9083677f121003ab9abc4610194440e5605576cf67ed1e40b520aeeb8a04dde',
                        sequence: 4294967295,
                    },
                ],
                outs: [],
                joinsplitsLength: 1,
                joinsplitPubkeyLength: 32,
                joinsplitSigLength: 64,
            },
            extraData:
                '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',
        },
        {
            description:
                'Version 2 transaction (0:1) with JoinSplit and bits that look like marker and witness',
            network: 'zcash',
            hex: '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',
            id: 'ffc3c7e2ea06811f7fccd9cf4f9ae92e7ccc5d11dd59b9a8b4e8e2c1ec6b4161',
            hash: '61416becc1e2e8b4a8b959dd115dcc7c2ee99a4fcfd9cc7f1f8106eae2c7c3ff',
            coinbase: false,
            virtualSize: 1943,
            weight: 7772,
            raw: {
                version: 2,
                overwintered: 0,
                locktime: 0,
                expiry: 0,
                versionGroupId: 0,
                ins: [],
                outs: [
                    {
                        value: '1369306864',
                        data: '76a914a99534ac90feba29f0a227f3fc3fae435a9f142488ac',
                    },
                ],
                joinsplitsLength: 1,
                joinsplitPubkeyLength: 32,
                joinsplitSigLength: 64,
            },
            extraData:
                '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',
        },
        {
            description: 'Version 3 transaction (4:2)',
            network: 'zcash',
            hex: '030000807082c403047e6070481b33c176e887a3d7662d708891b6e643b6ae038a29b4b57e0da5a107000000006a473044022029d58b11f67a83e472f36695486046d670e666a52f367d78d7fddfba3308b5a902206290bc7a822027158cc39e7ab02d2acf2d2ae54cac5ef5931ceb948159d4c0790121031db18bdce8d9fa4f0054c5be45163917ea1f3faba8defdbb2b3975d4bba055c5feffffffeae9560561ce09393263ca98bb01b15d16c88b02dc504d8c9ed1b0efe81222a0010000006b483045022100f97edbcda6287a156803ef614080c3b264cc446f949c6596dddca8af2dd2fa500220267ce4b50dbae8c1ef66cff2ef802583c75fefdfd87be401a595e4f4399ebd2d0121024eb7c7c1244f5e318c3def22a4a61257acc82862b2352bd442bd2d691b5eabecfeffffff1a578230b8c382713319771f2c904399297087b51530965b3589c27f9139d6e8000000006a473044022037f5aa4a8e1ce24dfa10919f37e718c4066bd72e1cd258439be24cb69a534b5302207604c1b3faec20b95ed4bcb530d6ccfe823f2c6002e5d5bef2e61c48b59187c20121028170001108bb31f159092b97cceab2522f9266435efd3d72357d8070bf846ebdfeffffffef8f47a709c437898a3bab2570362cc0325015bde19544ca0576ec07f9364428000000006a47304402206c4b7e1efd8b7493878e39912b20864f1b450ac845214236973d47a0bd447274022042689b896acfa16c4dd8eac6d10e3a55ab41fc04457de7f2885966c267f1fb9e012102b2ed048db551bb3dfa9a57585eaa2437b086c28c47bd4c13bdecf8f89c0c109dfeffffff0200a3e111000000001976a9141b4ca322da3708bf4cc7a265ebf7ad011f35c5de88acff384700000000001976a914034c9da5a8cdca724275e96fea3d4d58d7c28c7988ac9f920300be92030000',
            id: 'c5a7138a6319b907424a16a37938eeb44257ce5c22f4f24920349ae7e17f5949',
            hash: '49597fe1e79a342049f2f4225cce5742b4ee3879a3164a4207b919638a13a7c5',
            coinbase: false,
            virtualSize: 676,
            weight: 2704,
            raw: {
                version: 3,
                overwintered: 1,
                locktime: 234143,
                expiry: 234174,
                versionGroupId: '0x3C48270',
                ins: [
                    {
                        hash: '7e6070481b33c176e887a3d7662d708891b6e643b6ae038a29b4b57e0da5a107',
                        index: 0,
                        data: '473044022029d58b11f67a83e472f36695486046d670e666a52f367d78d7fddfba3308b5a902206290bc7a822027158cc39e7ab02d2acf2d2ae54cac5ef5931ceb948159d4c0790121031db18bdce8d9fa4f0054c5be45163917ea1f3faba8defdbb2b3975d4bba055c5',
                        sequence: 4294967294,
                    },
                    {
                        hash: 'eae9560561ce09393263ca98bb01b15d16c88b02dc504d8c9ed1b0efe81222a0',
                        index: 1,
                        data: '483045022100f97edbcda6287a156803ef614080c3b264cc446f949c6596dddca8af2dd2fa500220267ce4b50dbae8c1ef66cff2ef802583c75fefdfd87be401a595e4f4399ebd2d0121024eb7c7c1244f5e318c3def22a4a61257acc82862b2352bd442bd2d691b5eabec',
                        sequence: 4294967294,
                    },
                    {
                        hash: '1a578230b8c382713319771f2c904399297087b51530965b3589c27f9139d6e8',
                        index: 0,
                        data: '473044022037f5aa4a8e1ce24dfa10919f37e718c4066bd72e1cd258439be24cb69a534b5302207604c1b3faec20b95ed4bcb530d6ccfe823f2c6002e5d5bef2e61c48b59187c20121028170001108bb31f159092b97cceab2522f9266435efd3d72357d8070bf846ebd',
                        sequence: 4294967294,
                    },
                    {
                        hash: 'ef8f47a709c437898a3bab2570362cc0325015bde19544ca0576ec07f9364428',
                        index: 0,
                        data: '47304402206c4b7e1efd8b7493878e39912b20864f1b450ac845214236973d47a0bd447274022042689b896acfa16c4dd8eac6d10e3a55ab41fc04457de7f2885966c267f1fb9e012102b2ed048db551bb3dfa9a57585eaa2437b086c28c47bd4c13bdecf8f89c0c109d',
                        sequence: 4294967294,
                    },
                ],
                outs: [
                    {
                        value: '300000000',
                        data: '76a9141b4ca322da3708bf4cc7a265ebf7ad011f35c5de88ac',
                    },
                    {
                        value: '4667647',
                        data: '76a914034c9da5a8cdca724275e96fea3d4d58d7c28c7988ac',
                    },
                ],
                joinsplitsLength: 0,
                joinsplitPubkeyLength: 0,
                joinsplitSigLength: 0,
            },
            extraData: '00',
        },
        {
            description: 'Version 3 transaction (2:2)',
            network: 'zcash',
            hex: '030000807082c40302ca6461f8faee6b6ab6bdec3ea72b8efa02d9ea6fa47631f7ca48be972141d3c1010000006a473044022078120f45e89d805675c9252fc84851d36a7b1bad9d3bdf29850d086f50eb7842022065b32e392d7fee460ba77ed6bf66c9088ae9e6f70735710d5ca9af22dfd572c5012102e941bb1e2d2d13aa901efca2e62cb3883a71e5db0cc741b4837e9a8e5164639bfeffffff5685689a1a158df93ee1979b6322843ef06365b2f62204feccbcb076cdaf9490010000006a47304402207244a75fdfdfcbc65a80d2796ed24cde8758968304a983dec055c002f05b843d02206fa8613df5482310820ef4b92016b2dc01bb8fe5affebc229ef82b6764fd87ef012103a802561f573d200dddd381adda1c7043445140b6f8ff352985517e866504f082feffffff0218210000000000001976a91483867e664ff6dd7ef1bec58a766062704cfdf23988ac10270000000000001976a9142e6e46800c3e1d48a1ff298a483de421f30850d688ac86760300a576030000',
            id: 'ffffdb87199e9e96456997bb6004993b7752e4dbac874d691447f620f0ba37b8',
            hash: 'b837baf020f64714694d87acdbe452773b990460bb976945969e9e1987dbffff',
            coinbase: false,
            virtualSize: 381,
            weight: 1524,
            raw: {
                version: 3,
                overwintered: 1,
                locktime: 226950,
                expiry: 226981,
                versionGroupId: '0x3C48270',
                ins: [
                    {
                        hash: 'ca6461f8faee6b6ab6bdec3ea72b8efa02d9ea6fa47631f7ca48be972141d3c1',
                        index: 1,
                        data: '473044022078120f45e89d805675c9252fc84851d36a7b1bad9d3bdf29850d086f50eb7842022065b32e392d7fee460ba77ed6bf66c9088ae9e6f70735710d5ca9af22dfd572c5012102e941bb1e2d2d13aa901efca2e62cb3883a71e5db0cc741b4837e9a8e5164639b',
                        sequence: 4294967294,
                    },
                    {
                        hash: '5685689a1a158df93ee1979b6322843ef06365b2f62204feccbcb076cdaf9490',
                        index: 1,
                        data: '47304402207244a75fdfdfcbc65a80d2796ed24cde8758968304a983dec055c002f05b843d02206fa8613df5482310820ef4b92016b2dc01bb8fe5affebc229ef82b6764fd87ef012103a802561f573d200dddd381adda1c7043445140b6f8ff352985517e866504f082',
                        sequence: 4294967294,
                    },
                ],
                outs: [
                    {
                        value: '8472',
                        data: '76a91483867e664ff6dd7ef1bec58a766062704cfdf23988ac',
                    },
                    {
                        value: '10000',
                        data: '76a9142e6e46800c3e1d48a1ff298a483de421f30850d688ac',
                    },
                ],
                joinsplitsLength: 0,
                joinsplitPubkeyLength: 0,
                joinsplitSigLength: 0,
            },
            extraData: '00',
        },
        {
            description: 'Version 3 transaction (1:2) zero lock_time',
            network: 'zcash',
            hex: '030000807082c403010000000000000000000000000000000000000000000000000000000000000000ffffffff06033e5a03011affffffff0200ca9a3b000000001976a914b142bd45409b058dc076d25d9f257b98578188d788ac80b2e60e0000000017a9144c5ade3c465399986b230b7cddc877c72877a02e87000000000000000000',
            id: '00010f4200b4746288993893104aba87b32a6a5470eb6332803f3de8e4cc4515',
            hash: '1545cce4e83d3f803263eb70546a2ab387ba4a10933899886274b400420f0100',
            coinbase: true,
            virtualSize: 132,
            weight: 528,
            raw: {
                version: 3,
                overwintered: 1,
                locktime: 0,
                expiry: 0,
                versionGroupId: '0x3C48270',
                ins: [
                    {
                        hash: '0000000000000000000000000000000000000000000000000000000000000000',
                        index: 4294967295,
                        data: '033e5a03011a',
                        sequence: 4294967295,
                    },
                ],
                outs: [
                    {
                        value: '1000000000',
                        data: '76a914b142bd45409b058dc076d25d9f257b98578188d788ac',
                    },
                    {
                        value: '250000000',
                        data: 'a9144c5ade3c465399986b230b7cddc877c72877a02e87',
                    },
                ],
                joinsplitsLength: 0,
                joinsplitPubkeyLength: 0,
                joinsplitSigLength: 0,
            },
            extraData: '00',
        },
        {
            description: 'Version 4 transaction (1:1) zero lock_time',
            network: 'zcash',
            hex: '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',
            id: 'fffcf53caed862513c24ce8ea4ea6e61aa95b7c22f2db91d45b5fb58dd7718e1',
            hash: 'e11877dd58fbb5451db92d2fc2b795aa616eeaa48ece243c5162d8ae3cf5fcff',
            coinbase: false,
            virtualSize: 1222,
            weight: 4888,
            raw: {
                version: 4,
                overwintered: 1,
                versionGroupId: '0x892F2085',
                ins: [
                    {
                        hash: '8ab58c677cf7e4569d599001aef71aaaafcb4f01477a0d923f2c98b72d8c1328',
                        index: 0,
                        data: '47304402206a89c837b1bf3ff8356ebf2b57711efa94dc9ba34715c36b39f2c56d1734af7402204717d63f47a6d8ae3a50634716bda5ebc649bd950ec4b89fd9b6eda98abfb986012103db4a5ea0faab423e4f12fb7f66eaaac634692dfd8a8b0d2bb4ce842679600e7c',
                        sequence: 4294967295,
                    },
                ],
                outs: [
                    {
                        value: '363061000',
                        data: '76a9147f86e83ab6cb41f8330c269acb0dc4fb17d2c82588ac',
                    },
                ],
                locktime: 0,
                expiry: 1282773,
                joinsplitsLength: 0,
                joinsplitPubkeyLength: 0,
                joinsplitSigLength: 0,
            },
            extraData:
                '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',
        },
        {
            description: 'Version 4 transaction, ZIP 243 Test Vector 1',
            network: 'zcash',
            hex: '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',
            id: '5fc4867a1b8bd5ab709799adf322a85d10607e053726d5f5ab4b1c9ab897e6bc',
            hash: 'bce697b89a1c4babf5d52637057e60105da822f3ad999770abd58b1b7a86c45f',
            coinbase: false,
            virtualSize: 5714,
            weight: 22856,
            raw: {
                version: 4,
                overwintered: 1,
                versionGroupId: '0x892F2085',
                ins: [],
                outs: [
                    { value: '68758426644967', data: '5200ac6551ac636565' },
                    { value: '691614428857266', data: '5151' },
                ],
                locktime: 2262637640,
                expiry: 407096499,
                valueBalance: 1666019459801412,
                nShieldedSpend: 3,
                vShieldedSpend: [
                    {
                        cv: '1b3d1a027c2c40590958b7eb13d742a997738c46a458965baf276ba92f272c72',
                        anchor: '1fe01f7e9c8e36d6a5e29d4e30a73594bf5098421c69378af1e40f64e125946f',
                        nullifier:
                            '62c2fa7b2fecbcb64b6968912a6381ce3dc166d56a1d62f5a8d7551db5fd9313',
                        rk: 'e8c7203d996af7d477083756d59af80d06a745f44ab023752cb5b406ed8985e1',
                        zkproof:
                            '8130ab33362697b0e4e4c763ccb8f676495c222f7fba1e31defa3d5a57efc2e1e9b01a035587d5fb1a38e01d94903d3c3e0ad3360c1d3710acd20b183e31d49f25c9a138f49b1a537edcf04be34a9851a7af9db6990ed83dd64af3597c04323ea51b0052ad8084a8b9da948d320dadd64f5431e61ddf658d24ae67c22c8d1309131fc00fe7f235734276d38d47f1e191e00c7a1d48af046827591e9733a97fa6b679f3dc601d008285edcbdae69ce8fc1be4aac00ff2711ebd931de518856878',
                        spendAuthSig:
                            'f73476f21a482ec9378365c8f7393c94e2885315eb4671098b79535e790fe53e29fef2b3766697ac32b4f473f468a008e72389fc03880d780cb07fcfaabe3f1a',
                    },
                    {
                        cv: '15825b7acb4d6b57a61bc68f242b52e4fbf85cf1a09cc45b6d6bb3a391578f49',
                        anchor: '9486a7afd04a0d9c74c2995d96b4de37b36046a1ef6d190b916b1111c9288731',
                        nullifier:
                            '1a20da8aba18d1dbebbc862ded42435e92476930d069896cff30eb414f727b89',
                        rk: 'e001afa2fb8dc3436d75a4a6f26572504b192232ecb9f0c02411e52596bc5e90',
                        zkproof:
                            '457e745939ffedbd12863ce71a02af117d417adb3d15cc54dcb1fce467500c6b8fb86b12b56da9c382857deecc40a98d5f2935395ee4762dd21afdbb5d47fa9a6dd984d567db2857b927b7fae2db587105415d4642789d38f50b8dbcc129cab3d17d19f3355bcf73cecb8cb8a5da01307152f13936a270572670dc82d39026c6cb4cd4b0f7f5aa2a4f5a5341ec5dd715406f2fdd2afa733f5f641c8c21862a1bafce2609d9eecfa158cfb5cd79f88008e315dc7d8388e76c1782fd2795d18a76',
                        spendAuthSig:
                            '3624c25fa959cc97489ce75745824b77868c53239cfbdf73caec65604037314faaceb56218c6bd30f8374ac13386793f21a9fb80ad03bc0cda4a44946c00e1b1',
                    },
                    {
                        cv: '02c78f11876b7065212183199fb5979ca77d2c24c738fe5145f02602053bb4c2',
                        anchor: 'f6556df6ed4b4ddd3d9a69f53357d7767f4f5ccbdbc596631277f8fecd08cb05',
                        nullifier:
                            '6b95e3025b9792fff7f244fc716269b926d62e9596fa825c6bf21aff9e68625a',
                        rk: '192440ea06828123d97884806f15fa08da52754a1095e3ff1abd5ce4fddfccfc',
                        zkproof:
                            '3a6128aef784a64610a89d1a7099216d0814d3a2d452431c32d411ac1cce82ad0229407bbc48985675e3f874a4533f1d63a84dfa3e0f460fe2f57e34fbc75423c3737f5b2a0615f5722db041a3ef66fa483afd3c2e19e59444a64add6df1d963f5dd5b5010d3d025f0287c4cf19c75f33d51ddddba5d657b43ee8da645443814cc7329f3e9b4e54c236c29af3923101756d9fa4bd0f7d2ddaacb6b0f86a2658e0a07a05ac5b950051cd24c47a88d13d659ba2a46ca1830816d09cd7646f76f71',
                        spendAuthSig:
                            '6abec5de07fe9b523410806ea6f288f8736c23357c85f45791e1708029d9824d90704607f387a03e49bf9836574431345a7877efaa8a08e73081ef8d62cb780a',
                    },
                ],
                nShieldedOutput: 0,
                joinsplitsLength: 2,
                joinsplitPubkeyLength: 32,
                joinsplitSigLength: 64,
                bindingSig:
                    'c01400f1ab5730eac0ae8d5843d5051c376240172af218d7a1ecfe65b4f75100638983c14de4974755dade8018c9b8f4543fb095961513e67c61dbc59c607f9b',
            },
            extraData:
                '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',
        },
        {
            description: 'Version 4 transaction, ZIP 243 Test Vector 2',
            network: 'zcash',
            hex: '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',
            id: '6732cf8d67aac5b82a2a0f0217a7d4aa245b2adb0b97fd2d923dfc674415e221',
            hash: '21e2154467fc3d922dfd970bdb2a5b24aad4a717020f2a2ab8c5aa678dcf3267',
            coinbase: false,
            virtualSize: 1371,
            weight: 5484,
            raw: {
                version: 4,
                overwintered: 1,
                versionGroupId: '0x892F2085',
                ins: [
                    {
                        hash: '56e551406a7ee8355656a21e43e38ce129fdadb759eddfa08f00fc8e567cef93',
                        index: 19757510,
                        data: '63656300ac63ac',
                        sequence: 1162014861,
                    },
                    {
                        hash: '1a33590d3e8cf49b2627218f0c292fa66ada945fa55bb23548e33a83a562957a',
                        index: 2477345073,
                        data: '6a5352516a65006a',
                        sequence: 3833387384,
                    },
                ],
                outs: [
                    { value: '483112328240361', data: '516a6a656aac636565' },
                    { value: '1053219040642908', data: '636a' },
                ],
                locktime: 1052269671,
                expiry: 396157507,
                valueBalance: 1657637153650756,
                nShieldedSpend: 3,
                vShieldedSpend: [
                    {
                        cv: 'b0f5b874a6ecabe6c56ee58b67d02f5d47db8cc3458435d5088d69b2240c28f3',
                        anchor: '71c012c415d2382a6eebc8b3db07ea1cbf28288daaa91538de4552eeeef72c24',
                        nullifier:
                            'c85d83db20efad48be8996fb1bff591efff360fe1199056c56e5feec61a7b8b9',
                        rk: 'f699d6012c2849232f329fef95c7af370098ffe4918e0ca1df47f275867b739e',
                        zkproof:
                            '0a514d3209325e217045927b479c1ce2e5d54f25488cad1513e3f44a21266cfd841633327dee6cf810fbf7393e317d9e53d1be1d5ae7839b66b943b9ed18f2c530e975422332c3439cce49a29f2a336a4851263c5e9bd13d731109e844b7f8c392a5c1dcaa2ae5f50ff63fab9765e016702c35a67cd7364d3fab552fb349e35c15c50250453fd18f7b855992632e2c76c0fbf1ef963ea80e3223de3277bc559251725829ec03f213ba8955cab2822ff21a9b0a4904d668fcd77224bde3dd01f6',
                        spendAuthSig:
                            'ffc4828f6b64230b35c6a049873494276ea1d7ed5e92cb4f90ba83a9e49601b194042f2900d99d312d7b70508cf176066d154dbe96ef9d4367e4c840e4a17b5e',
                    },
                    {
                        cv: '26bca7fdd7cc43201c56f468fadc42cff0d81a966417ad8f097ebf3b25879e55',
                        anchor: 'c23e34da91c816d8d1790dfe34bdce040db1727af24d59ef78d3f4aac2b59822',
                        nullifier:
                            'd6f12f24fd364496b3be0871ca3dd9625348a614b59bde45885649bae36de34d',
                        rk: 'ef8fcec85343475d976ae1e9b27829ce2ac5efd0b399a8b448be6504294ee6b3',
                        zkproof:
                            'c1c6a5342d7c01ae9d8ad3070c2b1a91573af5e0c5e4cbbf4acdc6b54c9272200d9970250c17c1036f06085c41858ed3a0c48150bc697e4a695fef335f7ad07e1a46dc767ff822db70e6669080b9816b2232c81a4c66cc586abfe1eaa8ca6cf41fc3c3e6c7b886fb6dac9f4822b4fc6fff9d0513d61a21c80a377671d135a668a0ae2bb934c82c4142da69d12ca7de9a7df706400ec79878d868e17e8f71ea31495af819a016cc419e07c501aa8309b2e6c85b79b2763733a37bbc0420d42537',
                        spendAuthSig:
                            'b871b4294a65d3e055ff718dd9dc8c75e7e5b2efe442637371b7c48f6ee99e3ea38a4b0f2f67fc2b908cda657eae754e037e262e9a9f9bd7ec4267ed8e96930e',
                    },
                    {
                        cv: 'eb89a85980f97d7faaed78d8f38beb624b774c73a46ced614be219b3d94873b6',
                        anchor: '0df7fc90b579abf62037975edd6aacc442190a0ba55b15f81f86bade794ace2a',
                        nullifier:
                            '9d9a816baf728a955b960b7701fa626687dc3c9cba646337b53e29816e9482dd',
                        rk: 'f5578a8768aae477fce410ac2d5de6095861c111d7feb3e6bb4fbb5a54955495',
                        zkproof:
                            '972798350a253f05f66c2ecfcbc0ed43f5ec2e6d8dba15a51254d97b1821107c07dd9a16ef8406f943e282b95d4b362530c913d6ba421df6027de5af1e4745d5868106954be6c1962780a2941072e95131b1679df0637625042c37d48ffb152e5ebc185c8a2b7d4385f1c95af937df78dfd8757fab434968b0b57c66574468f160b447ac8221e5060676a842a1c6b7172dd3340f764070ab1fe091c5c74c95a5dc043390723a4c127da14cdde1dc2675a62340b3e6afd0522a31de26e7d1ec3a',
                        spendAuthSig:
                            '9c8a091ffdc75b7ecfdc7c12995a5e37ce3488bd29f8629d68f696492448dd526697476dc061346ebe3f677217ff9c60efce943af28dfd3f9e59692598a6047c',
                    },
                ],
                nShieldedOutput: 0,
                joinsplitsLength: 0,
                joinsplitPubkeyLength: 0,
                joinsplitSigLength: 0,
                bindingSig:
                    'c01400f1ab5730eac0ae8d5843d5051c376240172af218d7a1ecfe65b4f75100638983c14de4974755dade8018c9b8f4543fb095961513e67c61dbc59c607f9b',
            },
            extraData:
                '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',
        },
        {
            description: 'Version 5 transaction, ZIP 225 (3:2 mainnet tx)',
            network: 'zcash',
            hex: '050000800a27a726b4d0d6c200000000eec51900039d2930ca9eb368cb7ebd6b89266ec6f5b75d42458bac66d5878bc19ea073af6b5e0000006b48304502210081ee275d9dc37ad245a3f76eebb005a2e35e69077e6eb2245bf948558871bbc80220474d32efc3d5510953952447d8ecd42e64c946f245d6a044de3182860ce5de7b0121030165aa2d2874f5a7f3c03c9da89c54df5c5d95f2ae70c4a23f693fae0aed326fffffffff172c5ad595f8f05eb30a95e0521908deda5479612afcc30e32e74b02c43afb07b50000006a473044022037cfc85b6be72e5a49a3e8e48317a3f943708835902bfc9c8e940bebd02cd5f9022019a73ea16397240b0d7b3c6381ba7c07796c7beb5d0a21ce482a8790a43af0980121032145fe947eb7743f1ba06b4ec56d399ba13b4d0ca0b31c954645002533b96c34ffffffff172c5ad595f8f05eb30a95e0521908deda5479612afcc30e32e74b02c43afb071c0000006a4730440220662021210062a8e8769a4f167e4b13a836368797f2cd3d3575b7a14759fd5f12022067c0aeb8d8f02d1dcbed5a77b3d1bb79b4725aa2d66a9737ce7b81c2f1f77138012103e2d22122b2b55a34c3de05fb10e3080c06987b6926ad94f502aa9f7c76a5e18cffffffff02e0fc2b01000000001976a914b266783b60b230af4014b28c521179bd151322a088ac2327cb09000000001976a91452c8909040222e956beca8bcb76a8de671e1d42888ac000000',
            id: '9fcbc749de99e181efc99de0686cd5f4afa9b2c6aade09d0032390cb59c831de',
            hash: 'de31c859cb902303d009deaac6b2a9aff4d56c68e09dc9ef81e199de49c7cb9f',
            coinbase: false,
            virtualSize: 535,
            weight: 2140,
            raw: {
                version: 5,
                overwintered: 1,
                versionGroupId: '0x26a7270a',
                ins: [
                    {
                        hash: '9d2930ca9eb368cb7ebd6b89266ec6f5b75d42458bac66d5878bc19ea073af6b',
                        index: 94,
                        data: '48304502210081ee275d9dc37ad245a3f76eebb005a2e35e69077e6eb2245bf948558871bbc80220474d32efc3d5510953952447d8ecd42e64c946f245d6a044de3182860ce5de7b0121030165aa2d2874f5a7f3c03c9da89c54df5c5d95f2ae70c4a23f693fae0aed326f',
                        sequence: 4294967295,
                    },
                    {
                        hash: '172c5ad595f8f05eb30a95e0521908deda5479612afcc30e32e74b02c43afb07',
                        index: 181,
                        data: '473044022037cfc85b6be72e5a49a3e8e48317a3f943708835902bfc9c8e940bebd02cd5f9022019a73ea16397240b0d7b3c6381ba7c07796c7beb5d0a21ce482a8790a43af0980121032145fe947eb7743f1ba06b4ec56d399ba13b4d0ca0b31c954645002533b96c34',
                        sequence: 4294967295,
                    },
                    {
                        hash: '172c5ad595f8f05eb30a95e0521908deda5479612afcc30e32e74b02c43afb07',
                        index: 28,
                        data: '4730440220662021210062a8e8769a4f167e4b13a836368797f2cd3d3575b7a14759fd5f12022067c0aeb8d8f02d1dcbed5a77b3d1bb79b4725aa2d66a9737ce7b81c2f1f77138012103e2d22122b2b55a34c3de05fb10e3080c06987b6926ad94f502aa9f7c76a5e18c',
                        sequence: 4294967295,
                    },
                ],
                outs: [
                    {
                        value: '19660000',
                        data: '76a914b266783b60b230af4014b28c521179bd151322a088ac',
                    },
                    {
                        value: '164308771',
                        data: '76a91452c8909040222e956beca8bcb76a8de671e1d42888ac',
                    },
                ],
                locktime: 0,
                expiry: 1689070,
                valueBalance: 0,
                nShieldedSpend: 0,
                vShieldedSpend: [],
                nShieldedOutput: 0,
                joinsplitsLength: 0,
                joinsplitPubkeyLength: 0,
                joinsplitSigLength: 0,
                bindingSig: '',
            },
        },
    ],

    hashForSignature: {
        valid: [
            {
                description: 'version 3 transaction (3:4) from zcash test data',
                txHex: '030000807082c403037ea166f815b7d87c8b91cb01c0299e5835ce30abaae76ae5f972d4818a5a7624000000000151e96efb2c4788af18eee19eb10181e6383fa84280ae8ec3b25d09f8a9e3195320c71016d90100000005656352ac537213520d2f63d056c96b9ab57c269cc8564f3c2e4342e40169c429a30dc0c979e7d9b63002000000046a6a5100ffffffff0453aeec030000000005ac000065accf0d5203000000000352636345eecf0400000000036351518cecd802000000000700005252635153000000001ec11f5500',
                script: 'ac6a5200525352',
                inIndex: 2,
                type: 33836424,
                version: 3,
                branchId: '0x74736554',
                hash: '967f00c292b9af74c7e770bd393f80b6a6d1c50ae639356dd66d29020d5904ed',
                value: 0,
            },
            {
                description: 'version 3 transaction (3:2) from zcash test data',
                txHex: '030000807082c40303bd161a9180878f13c24e6581a2fc38eb4f6f9508f602f44a1ec393d3e6e0a5900100000005536351636aedc34093ac074098e8fb351d31ab1cb2f86d84af574f2047ff191c621fda0fe564b7f0ed030000000800656a65ac6a6500ffffffff7b3043b94e25688a8ea39be5349e77192875bd77ffa01f78c3492a0a757e60eb03000000096aac53535253650051ffffffff022f798f0200000000035151ac3598b700000000000552ac650053080805520000000000',
                script: 'ac52ac0063',
                inIndex: 0,
                type: 623524693,
                version: 3,
                branchId: '0x76B809BB',
                hash: '44db5f1c43284937e6bb2b25790c06fb2f22b5a25062e8455b964dbbcd9f64de',
                value: 0,
            },
            {
                description: 'version 3 transaction (4:3) from zcash test data',
                txHex: '030000807082c4030473657247394fabc62d82c9ca0538ccca51d91b19035b96ed11caa41a8c20f4470100000000ffffffffe8da3f24922eb0bec8c3071c0a54ad3c6e1ee2424b2f05545cad38232a6e12ff0200000008526563ac005263000ad1d430faa60ae53bc91498569373f589830a1f19f57c0daf63d0c734c5032ca08c3d3e01000000020052ffffffffe1a664f0032ac41f3fd64b2f2c2a9bd41b3afaecb75d55bfba455a2aa52ff8b401000000096565656363ac006552ffffffff034dffa304000000000153b5453b05000000000251accfd7e305000000000153c574f357797a024b00',
                script: '53',
                inIndex: 3,
                type: 1844639429,
                version: 3,
                branchId: '0x76B809BB',
                hash: 'ed51c8db5ba2accabb1d8a718ecc0e61a55ebdf4a2a2aaa3999593e6c207f9c1',
                value: 0,
            },
        ],
        invalid: [
            {
                description: 'version 3 with joinsplits',
                txHex: '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',
                script: '636a',
                inIndex: 0,
                type: 1222904061,
                version: 3,
                branchId: '0x74736554',
                hash: '334d6bd1842cd7564868943f6fcbb49de66389cde4652c07939b9d1faaf01615',
                value: 0,
                exception: 'Hash signature for Zcash protected transactions is not supported',
            },
        ],
    },
};
