export default {
    valid: [
        {
            network: 'bitcoin',
            seed: '000102030405060708090a0b0c0d0e0f',
            wif: 'L52XzL2cMkHxqxBXRyEpnPQZGUs3uKiL3R11XbAdHigRzDozKZeW',
            pubKey: '0339a36013301597daef41fbe593a02cc513d0b55527ec2df1050e2e8ff49c85c2',
            privKey: 'e8f32e723decf4051aefac8e2c93c9c5b214313817cdb01a1494b917c8436b35',
            chainCode: '873dff81c02f525623fd1fe5167eac3a55a049de3d314bb42ee227ffed37d508',
            base58: 'xpub661MyMwAqRbcFtXgS5sYJABqqG9YLmC4Q1Rdap9gSE8NqtwybGhePY2gZ29ESFjqJoCu1Rupje8YtGqsefD265TMg7usUDFdp6W1EGMcet8',
            base58Priv:
                'xprv9s21ZrQH143K3QTDL4LXw2F7HEK3wJUD2nW2nRk4stbPy6cq3jPPqjiChkVvvNKmPGJxWUtg6LnF5kejMRNNU3TGtRBeJgk33yuGBxrMPHi',
            identifier: '3442193e1bb70916e914552172cd4e2dbc9df811',
            fingerprint: '3442193e',

            children: [
                {
                    path: "m/0'",
                    m: 0,
                    hardened: true,
                    wif: 'L5BmPijJjrKbiUfG4zbiFKNqkvuJ8usooJmzuD7Z8dkRoTThYnAT',
                    pubKey: '035a784662a4a20a65bf6aab9ae98a6c068a81c52e4b032c0fb5400c706cfccc56',
                    privKey: 'edb2e14f9ee77d26dd93b4ecede8d16ed408ce149b6cd80b0715a2d911a0afea',
                    chainCode: '47fdacbd0f1097043b78c63c20c34ef4ed9a111d980047ad16282c7ae6236141',
                    base58: 'xpub68Gmy5EdvgibQVfPdqkBBCHxA5htiqg55crXYuXoQRKfDBFA1WEjWgP6LHhwBZeNK1VTsfTFUHCdrfp1bgwQ9xv5ski8PX9rL2dZXvgGDnw',
                    base58Priv:
                        'xprv9uHRZZhk6KAJC1avXpDAp4MDc3sQKNxDiPvvkX8Br5ngLNv1TxvUxt4cV1rGL5hj6KCesnDYUhd7oWgT11eZG7XnxHrnYeSvkzY7d2bhkJ7',
                    identifier: '5c1bd648ed23aa5fd50ba52b2457c11e9e80a6a7',
                    fingerprint: '5c1bd648',
                    index: 2147483648,
                    depth: 1,
                },
                {
                    path: "m/0'/1",
                    m: 1,
                    wif: 'KyFAjQ5rgrKvhXvNMtFB5PCSKUYD1yyPEe3xr3T34TZSUHycXtMM',
                    pubKey: '03501e454bf00751f24b1b489aa925215d66af2234e3891c3b21a52bedb3cd711c',
                    privKey: '3c6cb8d0f6a264c91ea8b5030fadaa8e538b020f0a387421a12de9319dc93368',
                    chainCode: '2a7857631386ba23dacac34180dd1983734e444fdbf774041578e9b6adb37c19',
                    base58: 'xpub6ASuArnXKPbfEwhqN6e3mwBcDTgzisQN1wXN9BJcM47sSikHjJf3UFHKkNAWbWMiGj7Wf5uMash7SyYq527Hqck2AxYysAA7xmALppuCkwQ',
                    base58Priv:
                        'xprv9wTYmMFdV23N2TdNG573QoEsfRrWKQgWeibmLntzniatZvR9BmLnvSxqu53Kw1UmYPxLgboyZQaXwTCg8MSY3H2EU4pWcQDnRnrVA1xe8fs',
                    identifier: 'bef5a2f9a56a94aab12459f72ad9cf8cf19c7bbe',
                    fingerprint: 'bef5a2f9',
                    index: 1,
                    depth: 2,
                },
                {
                    path: "m/0'/1/2'",
                    m: 2,
                    hardened: true,
                    wif: 'L43t3od1Gh7Lj55Bzjj1xDAgJDcL7YFo2nEcNaMGiyRZS1CidBVU',
                    pubKey: '0357bfe1e341d01c69fe5654309956cbea516822fba8a601743a012a7896ee8dc2',
                    privKey: 'cbce0d719ecf7431d88e6a89fa1483e02e35092af60c042b1df2ff59fa424dca',
                    chainCode: '04466b9cc8e161e966409ca52986c584f07e9dc81f735db683c3ff6ec7b1503f',
                    base58: 'xpub6D4BDPcP2GT577Vvch3R8wDkScZWzQzMMUm3PWbmWvVJrZwQY4VUNgqFJPMM3No2dFDFGTsxxpG5uJh7n7epu4trkrX7x7DogT5Uv6fcLW5',
                    base58Priv:
                        'xprv9z4pot5VBttmtdRTWfWQmoH1taj2axGVzFqSb8C9xaxKymcFzXBDptWmT7FwuEzG3ryjH4ktypQSAewRiNMjANTtpgP4mLTj34bhnZX7UiM',
                    identifier: 'ee7ab90cde56a8c0e2bb086ac49748b8db9dce72',
                    fingerprint: 'ee7ab90c',
                    index: 2147483650,
                    depth: 3,
                },
                {
                    path: "m/0'/1/2'/2",
                    m: 2,
                    wif: 'KwjQsVuMjbCP2Zmr3VaFaStav7NvevwjvvkqrWd5Qmh1XVnCteBR',
                    pubKey: '02e8445082a72f29b75ca48748a914df60622a609cacfce8ed0e35804560741d29',
                    privKey: '0f479245fb19a38a1954c5c7c0ebab2f9bdfd96a17563ef28a6a4b1a2a764ef4',
                    chainCode: 'cfb71883f01676f587d023cc53a35bc7f88f724b1f8c2892ac1275ac822a3edd',
                    base58: 'xpub6FHa3pjLCk84BayeJxFW2SP4XRrFd1JYnxeLeU8EqN3vDfZmbqBqaGJAyiLjTAwm6ZLRQUMv1ZACTj37sR62cfN7fe5JnJ7dh8zL4fiyLHV',
                    base58Priv:
                        'xprvA2JDeKCSNNZky6uBCviVfJSKyQ1mDYahRjijr5idH2WwLsEd4Hsb2Tyh8RfQMuPh7f7RtyzTtdrbdqqsunu5Mm3wDvUAKRHSC34sJ7in334',
                    identifier: 'd880d7d893848509a62d8fb74e32148dac68412f',
                    fingerprint: 'd880d7d8',
                    index: 2,
                    depth: 4,
                },
                {
                    path: "m/0'/1/2'/2/1000000000",
                    m: 1000000000,
                    wif: 'Kybw8izYevo5xMh1TK7aUr7jHFCxXS1zv8p3oqFz3o2zFbhRXHYs',
                    pubKey: '022a471424da5e657499d1ff51cb43c47481a03b1e77f951fe64cec9f5a48f7011',
                    privKey: '471b76e389e528d6de6d816857e012c5455051cad6660850e58372a6c3e6e7c8',
                    chainCode: 'c783e67b921d2beb8f6b389cc646d7263b4145701dadd2161548a8b078e65e9e',
                    base58: 'xpub6H1LXWLaKsWFhvm6RVpEL9P4KfRZSW7abD2ttkWP3SSQvnyA8FSVqNTEcYFgJS2UaFcxupHiYkro49S8yGasTvXEYBVPamhGW6cFJodrTHy',
                    base58Priv:
                        'xprvA41z7zogVVwxVSgdKUHDy1SKmdb533PjDz7J6N6mV6uS3ze1ai8FHa8kmHScGpWmj4WggLyQjgPie1rFSruoUihUZREPSL39UNdE3BBDu76',
                    identifier: 'd69aa102255fed74378278c7812701ea641fdf32',
                    fingerprint: 'd69aa102',
                    index: 1000000000,
                    depth: 5,
                },
            ],
        },
        {
            network: 'bitcoin',
            seed: 'fffcf9f6f3f0edeae7e4e1dedbd8d5d2cfccc9c6c3c0bdbab7b4b1aeaba8a5a29f9c999693908d8a8784817e7b7875726f6c696663605d5a5754514e4b484542',
            wif: 'KyjXhyHF9wTphBkfpxjL8hkDXDUSbE3tKANT94kXSyh6vn6nKaoy',
            pubKey: '03cbcaa9c98c877a26977d00825c956a238e8dddfbd322cce4f74b0b5bd6ace4a7',
            privKey: '4b03d6fc340455b363f51020ad3ecca4f0850280cf436c70c727923f6db46c3e',
            chainCode: '60499f801b896d83179a4374aeb7822aaeaceaa0db1f85ee3e904c4defbd9689',
            base58: 'xpub661MyMwAqRbcFW31YEwpkMuc5THy2PSt5bDMsktWQcFF8syAmRUapSCGu8ED9W6oDMSgv6Zz8idoc4a6mr8BDzTJY47LJhkJ8UB7WEGuduB',
            base58Priv:
                'xprv9s21ZrQH143K31xYSDQpPDxsXRTUcvj2iNHm5NUtrGiGG5e2DtALGdso3pGz6ssrdK4PFmM8NSpSBHNqPqm55Qn3LqFtT2emdEXVYsCzC2U',
            identifier: 'bd16bee53961a47d6ad888e29545434a89bdfe95',
            fingerprint: 'bd16bee5',

            children: [
                {
                    path: 'm/0',
                    m: 0,
                    wif: 'L2ysLrR6KMSAtx7uPqmYpoTeiRzydXBattRXjXz5GDFPrdfPzKbj',
                    pubKey: '02fc9e5af0ac8d9b3cecfe2a888e2117ba3d089d8585886c9c826b6b22a98d12ea',
                    privKey: 'abe74a98f6c7eabee0428f53798f0ab8aa1bd37873999041703c742f15ac7e1e',
                    chainCode: 'f0909affaa7ee7abe5dd4e100598d4dc53cd709d5a5c2cac40e7412f232f7c9c',
                    base58: 'xpub69H7F5d8KSRgmmdJg2KhpAK8SR3DjMwAdkxj3ZuxV27CprR9LgpeyGmXUbC6wb7ERfvrnKZjXoUmmDznezpbZb7ap6r1D3tgFxHmwMkQTPH',
                    base58Priv:
                        'xprv9vHkqa6EV4sPZHYqZznhT2NPtPCjKuDKGY38FBWLvgaDx45zo9WQRUT3dKYnjwih2yJD9mkrocEZXo1ex8G81dwSM1fwqWpWkeS3v86pgKt',
                    identifier: '5a61ff8eb7aaca3010db97ebda76121610b78096',
                    fingerprint: '5a61ff8e',
                    index: 0,
                    depth: 1,
                },
                {
                    path: "m/0/2147483647'",
                    m: 2147483647,
                    hardened: true,
                    wif: 'L1m5VpbXmMp57P3knskwhoMTLdhAAaXiHvnGLMribbfwzVRpz2Sr',
                    pubKey: '03c01e7425647bdefa82b12d9bad5e3e6865bee0502694b94ca58b666abc0a5c3b',
                    privKey: '877c779ad9687164e9c2f4f0f4ff0340814392330693ce95a58fe18fd52e6e93',
                    chainCode: 'be17a268474a6bb9c61e1d720cf6215e2a88c5406c4aee7b38547f585c9a37d9',
                    base58: 'xpub6ASAVgeehLbnwdqV6UKMHVzgqAG8Gr6riv3Fxxpj8ksbH9ebxaEyBLZ85ySDhKiLDBrQSARLq1uNRts8RuJiHjaDMBU4Zn9h8LZNnBC5y4a',
                    base58Priv:
                        'xprv9wSp6B7kry3Vj9m1zSnLvN3xH8RdsPP1Mh7fAaR7aRLcQMKTR2vidYEeEg2mUCTAwCd6vnxVrcjfy2kRgVsFawNzmjuHc2YmYRmagcEPdU9',
                    identifier: 'd8ab493736da02f11ed682f88339e720fb0379d1',
                    fingerprint: 'd8ab4937',
                    index: 4294967295,
                    depth: 2,
                },
                {
                    path: "m/0/2147483647'/1",
                    m: 1,
                    wif: 'KzyzXnznxSv249b4KuNkBwowaN3akiNeEHy5FWoPCJpStZbEKXN2',
                    pubKey: '03a7d1d856deb74c508e05031f9895dab54626251b3806e16b4bd12e781a7df5b9',
                    privKey: '704addf544a06e5ee4bea37098463c23613da32020d604506da8c0518e1da4b7',
                    chainCode: 'f366f48f1ea9f2d1d3fe958c95ca84ea18e4c4ddb9366c336c927eb246fb38cb',
                    base58: 'xpub6DF8uhdarytz3FWdA8TvFSvvAh8dP3283MY7p2V4SeE2wyWmG5mg5EwVvmdMVCQcoNJxGoWaU9DCWh89LojfZ537wTfunKau47EL2dhHKon',
                    base58Priv:
                        'xprv9zFnWC6h2cLgpmSA46vutJzBcfJ8yaJGg8cX1e5StJh45BBciYTRXSd25UEPVuesF9yog62tGAQtHjXajPPdbRCHuWS6T8XA2ECKADdw4Ef',
                    identifier: '78412e3a2296a40de124307b6485bd19833e2e34',
                    fingerprint: '78412e3a',
                    index: 1,
                    depth: 3,
                },
                {
                    path: "m/0/2147483647'/1/2147483646'",
                    m: 2147483646,
                    hardened: true,
                    wif: 'L5KhaMvPYRW1ZoFmRjUtxxPypQ94m6BcDrPhqArhggdaTbbAFJEF',
                    pubKey: '02d2b36900396c9282fa14628566582f206a5dd0bcc8d5e892611806cafb0301f0',
                    privKey: 'f1c7c871a54a804afe328b4c83a1c33b8e5ff48f5087273f04efa83b247d6a2d',
                    chainCode: '637807030d55d01f9a0cb3a7839515d796bd07706386a6eddf06cc29a65a0e29',
                    base58: 'xpub6ERApfZwUNrhLCkDtcHTcxd75RbzS1ed54G1LkBUHQVHQKqhMkhgbmJbZRkrgZw4koxb5JaHWkY4ALHY2grBGRjaDMzQLcgJvLJuZZvRcEL',
                    base58Priv:
                        'xprvA1RpRA33e1JQ7ifknakTFpgNXPmW2YvmhqLQYMmrj4xJXXWYpDPS3xz7iAxn8L39njGVyuoseXzU6rcxFLJ8HFsTjSyQbLYnMpCqE2VbFWc',
                    identifier: '31a507b815593dfc51ffc7245ae7e5aee304246e',
                    fingerprint: '31a507b8',
                    index: 4294967294,
                    depth: 4,
                },
                {
                    path: "m/0/2147483647'/1/2147483646'/2",
                    m: 2,
                    wif: 'L3WAYNAZPxx1fr7KCz7GN9nD5qMBnNiqEJNJMU1z9MMaannAt4aK',
                    pubKey: '024d902e1a2fc7a8755ab5b694c575fce742c48d9ff192e63df5193e4c7afe1f9c',
                    privKey: 'bb7d39bdb83ecf58f2fd82b6d918341cbef428661ef01ab97c28a4842125ac23',
                    chainCode: '9452b549be8cea3ecb7a84bec10dcfd94afe4d129ebfd3b3cb58eedf394ed271',
                    base58: 'xpub6FnCn6nSzZAw5Tw7cgR9bi15UV96gLZhjDstkXXxvCLsUXBGXPdSnLFbdpq8p9HmGsApME5hQTZ3emM2rnY5agb9rXpVGyy3bdW6EEgAtqt',
                    base58Priv:
                        'xprvA2nrNbFZABcdryreWet9Ea4LvTJcGsqrMzxHx98MMrotbir7yrKCEXw7nadnHM8Dq38EGfSh6dqA9QWTyefMLEcBYJUuekgW4BYPJcr9E7j',
                    identifier: '26132fdbe7bf89cbc64cf8dafa3f9f88b8666220',
                    fingerprint: '26132fdb',
                    index: 2,
                    depth: 5,
                },
            ],
        },
        {
            comment: 'Private key has leading zeros (seed vers.)',
            network: 'bitcoin',
            seed: 'd13de7bd1e54422d1a3b3b699a27fb460de2849e7e66a005c647e8e4a54075cb',
            wif: 'KwDiCU5bs8xQwsRgxjhkcJcVuR7NE4Mei8X9uSAVviVTE7JmMoS6',
            pubKey: '0298ccc720d5dea817c7077605263bae52bca083cf8888fee77ff4c1b4797ee180',
            privKey: '0000081d1e4bad6731c84450c9a3dbb70e8ba30118d3419f2c74077b7996a078',
            chainCode: 'c23ab32b36ddff49fae350a1bed8ec6b4d9fc252238dd789b7273ba4416054eb',
            base58: 'xpub661MyMwAqRbcGUbHLLJ5n2DzFAt8mmaDxbmbdimh68m8EiXGEQPiJya4BJat5yMzy4e68VSUoLGCu5uvzf8dUoGvwuJsLE6F1cibmWsxFNn',
            base58Priv:
                'xprv9s21ZrQH143K3zWpEJm5QtHFh93eNJrNbNqzqLN5XoE9MvC7gs5TmBFaL2PpaXpDc8FBYVe5EChc73ApjSQ5fWsXS7auHy1MmG6hdpywE1q',
            identifier: '1a87677be6f73cc9655e8b4c5d2fd0aeeb1b23c7',
            fingerprint: '1a87677b',

            children: [
                {
                    hardened: true,
                    path: "m/44'/0'/0'/0/0'",
                    wif: 'L3z3MSqZtDQ1FPHKi7oWf1nc9rMEGFtZUDCoFa7n4F695g5qZiSu',
                    pubKey: '027c3591221e28939e45f8ea297d62c3640ebb09d7058b01d09c963d984a40ad49',
                    privKey: 'c9d464f63c78ed923b5fed4917bbbbd6936543baf12227067ddc99b63a54a058',
                    chainCode: 'ca27553aa89617e982e621637d6478f564b32738f8bbe2e48d0a58a8e0f6da40',
                    base58: 'xpub6GcBnm7FfDg5ERWACCvtuotN6Tdoc37r3SZ1asBHvCWzPkqWn3MVKPWKzy6GsfmdMUGanR3D12dH1cp5tJauuubwc4FAJDn67SH2uUjwAT1',
                    base58Priv:
                        'xprvA3cqPFaMpr7n1wRh6BPtYfwdYRoKCaPzgDdQnUmgMrz1WxWNEW3EmbBr9ieh9BJAsRGKFPLvotb4p4Aq79jddUVKPVJt7exVzLHcv777JVf',
                    identifier: 'e371d69b5dae6eacee832a130ee9f55545275a09',
                    fingerprint: 'e371d69b',
                    index: 2147483648,
                    depth: 5,
                },
            ],
        },
        {
            comment: 'Private key has leading zeros',
            network: 'bitcoin',
            wif: 'KwDiBh3sys6SzXrv4cSUVpDHsVc8XiD3o3xyMx9wvUcu3nPJJ6PE',
            pubKey: '02b3e3e297165289611a2387e8089fcaf099926e4d31fdddb50c0ae0dfa36c97e6',
            privKey: '00000055378cf5fafb56c711c674143f9b0ee82ab0ba2924f19b64f5ae7cdbfd',
            chainCode: '9c8a5c863e5941f3d99453e6ba66b328bb17cf0b8dec89ed4fc5ace397a1c089',
            base58: 'xpub661MyMwAqRbcG6q1FFDUUHr61LatpoMSZRQpVWR4MHzfGnfUp8GMT5xfKcrt4xB7nJCgXn1NBqgCGGDkJx1ZLRKeM58HZkhV5NjBWK1AyQY',
            base58Priv:
                'xprv9s21ZrQH143K3ckY9DgU79uMTJkQRLdbCCVDh81SnxTgPzLLGax6uHeBULTtaEtcAvKjXfT7ZWtHzKjTpujMkUd9dDb8msDeAfnJxrgAYhr',
            identifier: 'afc10e1e7abbe99731c4c4606a3556d832372680',
            fingerprint: 'afc10e1e',

            children: [
                {
                    hardened: true,
                    path: "m/44'/0'/0'/0/0'",
                    wif: 'KxwPsTN9AdQ2CjGihVP8MnSadbtyByskCiX1GCEhjovKj4m3d7Xs',
                    pubKey: '030e13168e3f9560da5cebca9c91b78280e7ffa221d097c6dac3e98f450355d6f6',
                    privKey: '3348069561d2a0fb925e74bf198762acc47dce7db27372257d2d959a9e6f8aeb',
                    chainCode: '7a16b2f4ad4cc1069338237f373dabf1fe329a5f3a0d95c4b98d061204676293',
                    base58: 'xpub6FqvhT2Bdh4YaWA3nqsNTaYNmCEXJnSJnBgntrH8GQVX8hf6exHusxyqgyd6kKKNTvtbpmNPGEH74VxJaAuo14NS52WBmWG9krq1ESqdR6T',
                    base58Priv:
                        'xprvA2raHwVHoKWFN25agpLN6SbeDAQ2uKiTQxmC6TsWi4xYFuKx7QyfLAfMqgvyXVr6fcDspooYFsas1ngymgmVSPjTCU5JRfwj6w4zukhfucS',
                    identifier: 'b2d8238bfeb71a89c8244b7e53105cd97021904e',
                    fingerprint: 'b2d8238b',
                    index: 2147483648,
                    depth: 5,
                },
            ],
        },
        {
            network: 'litecoin',
            seed: '000102030405060708090a0b0c0d0e0f',
            wif: 'TAroS5Knm8GZcnpPycBgzjwwDLWMyQjDrcuGPPoArgrbW7Ln22qp',
            pubKey: '0339a36013301597daef41fbe593a02cc513d0b55527ec2df1050e2e8ff49c85c2',
            privKey: 'e8f32e723decf4051aefac8e2c93c9c5b214313817cdb01a1494b917c8436b35',
            chainCode: '873dff81c02f525623fd1fe5167eac3a55a049de3d314bb42ee227ffed37d508',
            base58: 'Ltub2SSUS19CirucWFod2ZsYA2J4v4U76YiCXHdcQttnoiy5aGanFHCPDBX7utfG6f95u1cUbZJNafmvzNCzZZJTw1EmyFoL8u1gJbGM8ipu491',
            base58Priv:
                'Ltpv71G8qDifUiNetP6nmxPA5STrUVmv2J9YSmXajv8VsYBUyuPhvN9xCaQrfX2wo5xxJNtEazYCFRUu5FmokYMM79pcqz8pcdo4rNXAFPgyB4k',
            identifier: '3442193e1bb70916e914552172cd4e2dbc9df811',
            fingerprint: '3442193e',

            children: [
                {
                    path: "m/0'",
                    m: 0,
                    hardened: true,
                    wif: 'TB22qU2V9EJCVKJ8cdYaTfvDhnYcCzthcWgFm1k6hbvbKM1NLxoL',
                    pubKey: '035a784662a4a20a65bf6aab9ae98a6c068a81c52e4b032c0fb5400c706cfccc56',
                    privKey: 'edb2e14f9ee77d26dd93b4ecede8d16ed408ce149b6cd80b0715a2d911a0afea',
                    chainCode: '47fdacbd0f1097043b78c63c20c34ef4ed9a111d980047ad16282c7ae6236141',
                    base58: 'Ltub2UhtRiSfp82berwLEKkB34QBEt2TUdCDCu4WNzGumvAMwYsxfWjULKsXhADxqy3cuDu3TnqoKJr1xmB8Wb2qzthWAtbb4CutpXPuSU1YMgG',
                    base58Priv:
                        'Ltpv73XYpw28ZyVe2zEVyiFnxUZxoKLGQNdZ8NxUi1WcqjNmMBgtLbh3KimGSnPHCoLv1RmvxHs4dnKmo1oXQ8dXuDu8uroxrbVxZPA1gXboYvx',
                    identifier: '5c1bd648ed23aa5fd50ba52b2457c11e9e80a6a7',
                    fingerprint: '5c1bd648',
                    index: 2147483648,
                    depth: 1,
                },
            ],
        },
    ],
    invalid: {
        fromBase58: [
            {
                exception: 'Invalid checksum',
                string: 'xprvQQQQQQQQQQQQQQQQCviVfJSKyQ1mDYahRjijr5idH2WwLsEd4Hsb2Tyh8RfQMuPh7f7RtyzTtdrbdqqsunu5Mm3wDvUAKRHSC34sJ7in334',
            },
            {
                exception: 'Invalid buffer length',
                network: 'bitcoin',
                string: 'HAsbc6CgKmTYEQg2CTz7m5STEPAB',
            },
            {
                exception: 'Invalid parent fingerprint',
                network: 'bitcoin',
                string: 'xprv9tnJFvAXAXPfPnMTKfwpwnkty7MzJwELVgp4NTBquaKXy4RndyfJJCJJf7zNaVpBpzrwVRutZNLRCVLEcZHcvuCNG3zGbGBcZn57FbNnmSP',
            },
            {
                exception: 'Invalid private key',
                network: 'bitcoin',
                string: 'xprv9s21ZrQH143K3yLysFvsu3n1dMwhNusmNHr7xArzAeCc7MQYqDBBStmqnZq6WLi668siBBNs3SjiyaexduHu9sXT9ixTsqptL67ADqcaBdm',
            },
            {
                exception: 'Invalid index',
                network: 'bitcoin',
                string: 'xprv9s21ZrQYdgnodnKW4Drm1Qg7poU6Gf2WUDsjPxvYiK7iLBMrsjbnF1wsZZQgmXNeMSG3s7jmHk1b3JrzhG5w8mwXGxqFxfrweico7k8DtxR',
            },
            {
                exception: 'Invalid network version',
                network: 'litecoin',
                string: '1111111111111adADjFaSNPxwXqLjHLj4mBfYxuewDPbw9hEj1uaXCzMxRPXDFF3cUoezTFYom4sEmEVSQmENPPR315cFk9YUFVek73wE9',
            },
            {
                exception: 'Invalid network version',
                string: '8FH81Rao5EgGmdScoN66TJAHsQP7phEMeyMTku9NBJd7hXgaj3HTvSNjqJjoqBpxdbuushwPEM5otvxXt2p9dcw33AqNKzZEPMqGHmz7Dpayi6Vb',
            },
            {
                exception: 'Invalid network version',
                network: 'bitcoin',
                string: 'Ltpv73XYpw28ZyVe2zEVyiFnxUZxoKLGQNdZ8NxUi1WcqjNmMBgtLbh3KimGSnPHCoLv1RmvxHs4dnKmo1oXQ8dXuDu8uroxrbVxZPA1gXboYvx',
            },
            {
                exception: 'Invalid buffer length',
                string: '9XpNiB4DberdMn4jZiMhNGtuZUd7xUrCEGw4MG967zsVNvUKBEC9XLrmVmFasanWGp15zXfTNw4vW4KdvUAynEwyKjdho9QdLMPA2H5uyt',
            },
            {
                exception: 'Invalid buffer length',
                string: '7JJikZQ2NUXjSAnAF2SjFYE3KXbnnVxzRBNddFE1DjbDEHVGEJzYC7zqSgPoauBJS3cWmZwsER94oYSFrW9vZ4Ch5FtGeifdzmtS3FGYDB1vxFZsYKgMc',
            },
            {
                exception: 'Invalid parent fingerprint',
                string: 'xpub67tVq9SuNQCfm2PXBqjGRAtNZ935kx2uHJaURePth4JBpMfEy6jum7Euj7FTpbs7fnjhfZcNEktCucWHcJf74dbKLKNSTZCQozdDVwvkJhs',
            },
            {
                exception: 'Invalid index',
                string: 'xpub661MyMwTWkfYZq6BEh3ywGVXFvNj5hhzmWMhFBHSqmub31B1LZ9wbJ3DEYXZ8bHXGqnHKfepTud5a2XxGdnnePzZa2m2DyzTnFGBUXtaf9M',
            },
            {
                exception: 'Point is not on the curve',
                string: 'xpub661MyMwAqRbcFtXgS5sYJABqqG9YLmC4Q1Rdap9gSE8NqtwybGhePY2gYymDsxxRe3WWeZQ7TadaLSdKUffezzczTCpB8j3JP96UwE2n6w1',
            },
        ],
        fromSeed: [
            {
                exception: 'Seed should be at least 128 bits',
                seed: 'ffff',
            },
            {
                exception: 'Seed should be at most 512 bits',
                seed: 'ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff',
            },
        ],
        deriveHardened: [2147483648, null, 'foo', -1],
        derive: [4294967296, null, 'foo', -1],
        derivePath: [2, [2, 3, 4], '/', 'm/m/123', 'a/0/1/2', 'm/0/  1  /2', 'm/0/1.5/2'],
    },
};
