export default {
    standard: [
        {
            network: 'bitcoin',
            version: 0,
            hash: '751e76e8199196d454941c45d1b3a323f1433bd6',
            base58check: '1BgGZ9tcN4rm9KBzDn7KprQz87SZ26SAMH',
            script: 'OP_DUP OP_HASH160 751e76e8199196d454941c45d1b3a323f1433bd6 OP_EQUALVERIFY OP_CHECKSIG',
        },
        {
            network: 'bitcoin',
            version: 5,
            hash: 'cd7b44d0b03f2d026d1e586d7ae18903b0d385f6',
            base58check: '3LRW7jeCvQCRdPF8S3yUCfRAx4eqXFmdcr',
            script: 'OP_HASH160 cd7b44d0b03f2d026d1e586d7ae18903b0d385f6 OP_EQUAL',
        },
        {
            network: 'bitcoin',
            version: 0,
            bech32: 'BC1QW508D6QEJXTDG4Y5R3ZARVARY0C5XW7KV8F3T4',
            data: '751e76e8199196d454941c45d1b3a323f1433bd6',
            script: 'OP_0 751e76e8199196d454941c45d1b3a323f1433bd6',
        },
        {
            network: 'bitcoin',
            bech32: 'bc1pw508d6qejxtdg4y5r3zarvary0c5xw7kw508d6qejxtdg4y5r3zarvary0c5xw7kt5nd6y',
            version: 1,
            data: '751e76e8199196d454941c45d1b3a323f1433bd6751e76e8199196d454941c45d1b3a323f1433bd6',
            script: 'OP_1 751e76e8199196d454941c45d1b3a323f1433bd6751e76e8199196d454941c45d1b3a323f1433bd6',
        },
        {
            network: 'bitcoin',
            bech32: 'BC1SW50QGDZ25J',
            version: 16,
            data: '751e',
            script: 'OP_16 751e',
        },
        {
            network: 'bitcoin',
            bech32: 'bc1zw508d6qejxtdg4y5r3zarvaryvaxxpcs',
            version: 2,
            data: '751e76e8199196d454941c45d1b3a323',
            script: 'OP_2 751e76e8199196d454941c45d1b3a323',
        },
        {
            network: 'bitcoin',
            bech32: 'bc1p0xlxvlhemja6c4dqv22uapctqupfhlxm9h8z3k2e72q4k9hcz7vqzk5jj0',
            version: 1,
            data: '79be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798',
            script: 'OP_1 79be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798',
        },
        {
            network: 'litecoin',
            version: 50,
            hash: '332bdfb31f688c0be0137c7c038a6d0fea0de0b6',
            base58check: 'MCZjFcwYJwwYqXAbd3bbnxaCVGs81cp43Z',
            script: 'OP_HASH160 332bdfb31f688c0be0137c7c038a6d0fea0de0b6 OP_EQUAL',
        },
        {
            network: 'litecoin',
            version: 48,
            hash: '6ac624143d19a3c91d2ac5605f0aebdfeac5b826',
            base58check: 'LUxXFcwXFPpRZdMv4aYu6bDwPdC2skQ5YW',
            script: 'OP_DUP OP_HASH160 6ac624143d19a3c91d2ac5605f0aebdfeac5b826 OP_EQUALVERIFY OP_CHECKSIG',
        },
        {
            network: 'litecoin',
            version: 0,
            bech32: 'ltc1qr8da6nrrpgfxtw9afyz4ct3npugtyeqrn0zg99',
            data: '19dbdd4c630a1265b8bd49055c2e330f10b26403',
            script: 'OP_0 19dbdd4c630a1265b8bd49055c2e330f10b26403',
        },
        {
            network: 'litecoin',
            version: 0,
            bech32: 'ltc1qd5wm03t5kcdupjuyq5jffpuacnaqahvfsdu8smf8z0u0pqdqpatqsdrn8h',
            data: '6d1db7c574b61bc0cb84052494879dc4fa0edd898378786d2713f8f081a00f56',
            script: 'OP_0 6d1db7c574b61bc0cb84052494879dc4fa0edd898378786d2713f8f081a00f56',
        },
        {
            network: 'litecoinTest',
            version: 0,
            bech32: 'tltc1qq7fzt3ek5ege3v92wh0q6wzcjr39pqswlpe36mu28f6yufark3ws2x86ht',
            data: '079225c736a65198b0aa75de0d385890e250820ef8731d6f8a3a744e27a3b45d',
            script: 'OP_0 079225c736a65198b0aa75de0d385890e250820ef8731d6f8a3a744e27a3b45d',
        },
        {
            network: 'testnet',
            version: 111,
            hash: '751e76e8199196d454941c45d1b3a323f1433bd6',
            base58check: 'mrCDrCybB6J1vRfbwM5hemdJz73FwDBC8r',
            script: 'OP_DUP OP_HASH160 751e76e8199196d454941c45d1b3a323f1433bd6 OP_EQUALVERIFY OP_CHECKSIG',
        },
        {
            network: 'testnet',
            version: 196,
            hash: 'cd7b44d0b03f2d026d1e586d7ae18903b0d385f6',
            base58check: '2NByiBUaEXrhmqAsg7BbLpcQSAQs1EDwt5w',
            script: 'OP_HASH160 cd7b44d0b03f2d026d1e586d7ae18903b0d385f6 OP_EQUAL',
        },

        {
            network: 'testnet',
            version: 0,
            bech32: 'tb1qrp33g0q5c5txsp9arysrx4k6zdkfs4nce4xj0gdcccefvpysxf3q0sl5k7',
            data: '1863143c14c5166804bd19203356da136c985678cd4d27a1b8c6329604903262',
            script: 'OP_0 1863143c14c5166804bd19203356da136c985678cd4d27a1b8c6329604903262',
        },
        {
            network: 'testnet',
            version: 0,
            bech32: 'tb1qqqqqp399et2xygdj5xreqhjjvcmzhxw4aywxecjdzew6hylgvsesrxh6hy',
            data: '000000c4a5cad46221b2a187905e5266362b99d5e91c6ce24d165dab93e86433',
            script: 'OP_0 000000c4a5cad46221b2a187905e5266362b99d5e91c6ce24d165dab93e86433',
        },
        {
            network: 'testnet',
            bech32: 'tb1pqqqqp399et2xygdj5xreqhjjvcmzhxw4aywxecjdzew6hylgvsesf3hn0c',
            version: 1,
            data: '000000c4a5cad46221b2a187905e5266362b99d5e91c6ce24d165dab93e86433',
            script: 'OP_1 000000c4a5cad46221b2a187905e5266362b99d5e91c6ce24d165dab93e86433',
        },
        {
            network: 'regtest',
            version: 0,
            bech32: 'bcrt1qjh3dnrafy8f2zszh5sdqn6c3ycfljh930yza9nt72v30dkw8mlvscn82zx',
            data: '95e2d98fa921d2a14057a41a09eb112613f95cb17905d2cd7e5322f6d9c7dfd9',
            script: 'OP_0 95e2d98fa921d2a14057a41a09eb112613f95cb17905d2cd7e5322f6d9c7dfd9',
        },
        {
            network: 'regtest',
            version: 0,
            bech32: 'bcrt1qqqqqqqqqqqqqqahrwf6d62emdxmpq8gu3xe9au9fjwc9sxxn4k2qujfh7u',
            data: '000000000000000076e37274dd2b3b69b6101d1c89b25ef0a993b05818d3ad94',
            script: 'OP_0 000000000000000076e37274dd2b3b69b6101d1c89b25ef0a993b05818d3ad94',
        },
        {
            network: 'zcash',
            version: 7352,
            hash: '751e76e8199196d454941c45d1b3a323f1433bd6',
            base58check: 't1UYsZVJkLPeMjxEtACvSxfWuNmddpWfxzs',
            script: 'OP_DUP OP_HASH160 751e76e8199196d454941c45d1b3a323f1433bd6 OP_EQUALVERIFY OP_CHECKSIG',
        },
        {
            network: 'zcashTest',
            version: 7461,
            hash: '751e76e8199196d454941c45d1b3a323f1433bd6',
            base58check: 'tmLPctKo9j49rtCSKpwEBpLBeykiTGomGQs',
            script: 'OP_DUP OP_HASH160 751e76e8199196d454941c45d1b3a323f1433bd6 OP_EQUALVERIFY OP_CHECKSIG',
        },
        {
            network: 'decred',
            version: 1855,
            hash: '751e76e8199196d454941c45d1b3a323f1433bd6',
            base58check: 'DsbeB3ap3RiS4CLpgd1yXMSKLdrNMppeBE9',
            script: 'OP_DUP OP_HASH160 751e76e8199196d454941c45d1b3a323f1433bd6 OP_EQUALVERIFY OP_CHECKSIG',
        },
        {
            network: 'decredTest',
            version: 3873,
            hash: '751e76e8199196d454941c45d1b3a323f1433bd6',
            base58check: 'TsbhQ2iKSDmYAZ2BW1e8fvTavjpHvXD2HKq',
            script: 'OP_DUP OP_HASH160 751e76e8199196d454941c45d1b3a323f1433bd6 OP_EQUALVERIFY OP_CHECKSIG',
        },
        {
            network: 'decredSim',
            version: 3729,
            hash: '751e76e8199196d454941c45d1b3a323f1433bd6',
            base58check: 'Ssf2YF5Pwynoznc72VEAn6QPe7BC6655TjT',
            script: 'OP_DUP OP_HASH160 751e76e8199196d454941c45d1b3a323f1433bd6 OP_EQUALVERIFY OP_CHECKSIG',
        },
        {
            network: 'bitcoincash',
            version: 0,
            hash: '2ac8ab6bea0ddc28bb2690e9692daaf6041c6487',
            base58check: 'bitcoincash:qq4v32mtagxac29my6gwj6fd4tmqg8rysu23dax807',
            script: 'OP_DUP OP_HASH160 2ac8ab6bea0ddc28bb2690e9692daaf6041c6487 OP_EQUALVERIFY OP_CHECKSIG',
        },
        {
            network: 'bitcoincashTest',
            version: 111,
            hash: '1b887f583f8b9810c4ee362f234c589d2939629c',
            base58check: 'bchtest:qqdcsl6c879esyxyacmz7g6vtzwjjwtznsggspc457',
            script: 'OP_DUP OP_HASH160 1b887f583f8b9810c4ee362f234c589d2939629c OP_EQUALVERIFY OP_CHECKSIG',
        },
    ],
    bech32: [
        {
            address: 'BC1QW508D6QEJXTDG4Y5R3ZARVARY0C5XW7KV8F3T4',
            version: 0,
            prefix: 'bc',
            data: '751e76e8199196d454941c45d1b3a323f1433bd6',
        },
        {
            address: 'bc1pw508d6qejxtdg4y5r3zarvary0c5xw7kw508d6qejxtdg4y5r3zarvary0c5xw7kt5nd6y',
            version: 1,
            prefix: 'bc',
            data: '751e76e8199196d454941c45d1b3a323f1433bd6751e76e8199196d454941c45d1b3a323f1433bd6',
        },
        {
            address: 'bc1zw508d6qejxtdg4y5r3zarvaryvaxxpcs',
            version: 2,
            prefix: 'bc',
            data: '751e76e8199196d454941c45d1b3a323',
        },
        {
            address: 'BC1SW50QGDZ25J',
            version: 16,
            prefix: 'bc',
            data: '751e',
        },
    ],
    invalid: {
        bech32: [
            {
                address: 'bc1qw508d6qejxtdg4y5r3zarvary0c5xw7kv8f3t5',
                exception: 'Invalid checksum',
            },
            {
                address: 'tb1qrp33g0q5c5txsp9arysrx4k6zdkfs4nce4xj0gdcccefvpysxf3q0sL5k7',
                exception: 'Mixed-case string',
            },
            {
                address: 'tb1pw508d6qejxtdg4y5r3zarquvzkan',
                exception: 'Excess padding',
            },
            {
                address: 'bc1zw508d6qejxtdg4y5r3zarvaryvq37eag7',
                exception: 'Excess padding',
            },
            {
                address: 'tb1qrp33g0q5c5txsp9arysrx4k6zdkfs4nce4xj0gdcccefvpysxf3pjxtptv',
                exception: 'Non-zero padding',
            },
            {
                address: 'bc1zw508d6qejxtdg4y5r3zarvaryvqyzf3du',
                exception: 'uses wrong encoding',
            },
            {
                address: 'bc1p0xlxvlhemja6c4dqv22uapctqupfhlxm9h8z3k2e72q4k9hcz7vqh2y7hd',
                exception: 'uses wrong encoding',
            },
        ],
        fromBase58Check: [
            {
                address: '7SeEnXWPaCCALbVrTnszCVGfRU8cGfx',
                exception: 'is too short',
            },
            {
                address: 'j9ywUkWg2fTQrouxxh5rSZhRvrjMkEUfuiKe',
                exception: 'is too long',
            },
            {
                address: 'DsmcYVbP1Nmag2H4AS17UTvmWXmGeA7nLD',
                exception: 'invalid address length',
                network: 'decred',
            },
            {
                address: 'DsmcYVbP1Nmag2H4AS17UTvmWXmGeA7nLDy',
                exception: 'invalid checksum',
                network: 'decred',
            },
        ],
        fromOutputScript: [
            {
                exception: 'has no matching Address',
                script: '031f1e68f82112b373f0fe980b3a89d212d2b5c01fb51eb25acb8b4c4b4299ce95 OP_CHECKSIG',
            },
            {
                exception: 'has no matching Address',
                script: 'OP_TRUE 032487c2a32f7c8d57d2a93906a6457afd00697925b0e6e145d89af6d3bca33016 02308673d16987eaa010e540901cc6fe3695e758c19f46ce604e174dac315e685a OP_2 OP_CHECKMULTISIG',
            },
            {
                exception: 'has no matching Address',
                script: 'OP_RETURN 06deadbeef03f895a2ad89fb6d696497af486cb7c644a27aa568c7a18dd06113401115185474',
            },
            {
                exception: 'has no matching Address',
                script: 'OP_0 75',
            },
            {
                exception: 'has no matching Address',
                script: 'OP_0 751e76e8199196d454941c45d1b3a323f1433bd6751e76e8199196d454941c45d1b3a323f1433bd675',
            },
        ],
        toOutputScript: [
            {
                exception: 'has no matching Script',
                address: '24kPZCmVgzfkpGdXExy56234MRHrsqQxNWE',
            },
            {
                exception: 'has an invalid prefix',
                address: 'BC1SW50QGDZ25J',
                network: 'testnet',
            },
            {
                exception: 'has no matching Script',
                address: 'bc1rw5uspcuh',
            },
            {
                exception: 'has no matching Script',
                address:
                    'bc10w508d6qejxtdg4y5r3zarvary0c5xw7kw508d6qejxtdg4y5r3zarvary0c5xw7kw5rljs90',
            },
            {
                exception: 'has no matching Script',
                address: 'BC13W508D6QEJXTDG4Y5R3ZARVARY0C5XW7KN40WF2',
            },
            {
                exception: 'has no matching Script',
                address: 'bc1qw508d6qejxtdg4y5r3zarvary0c5xw7kv8f3t5',
            },
            {
                exception: 'has no matching Script',
                address: 'bc1qqqqqqqqqqv9qus',
            },
            {
                address: 'tc1p0xlxvlhemja6c4dqv22uapctqupfhlxm9h8z3k2e72q4k9hcz7vq5zuyut',
                exception: 'has an invalid prefix',
            },
            {
                address: 'bc1p0xlxvlhemja6c4dqv22uapctqupfhlxm9h8z3k2e72q4k9hcz7vqh2y7hd',
                exception: 'has no matching Script',
            },
            {
                address: 'tb1z0xlxvlhemja6c4dqv22uapctqupfhlxm9h8z3k2e72q4k9hcz7vqglt7rf',
                exception: 'has no matching Script',
                network: {
                    bech32: 'tb',
                },
            },
            {
                address: 'BC1S0XLXVLHEMJA6C4DQV22UAPCTQUPFHLXM9H8Z3K2E72Q4K9HCZ7VQ54WELL',
                exception: 'has no matching Script',
            },
            {
                address: 'bc1qw508d6qejxtdg4y5r3zarvary0c5xw7kemeawh',
                exception: 'has no matching Script',
            },
            {
                address: 'tb1q0xlxvlhemja6c4dqv22uapctqupfhlxm9h8z3k2e72q4k9hcz7vq24jc47',
                exception: 'has no matching Script',
                network: 'testnet',
            },
            {
                address: 'bc1p38j9r5y49hruaue7wxjce0updqjuyyx0kh56v8s25huc6995vvpql3jow4',
                exception: 'has no matching Script',
            },
            {
                address: 'BC130XLXVLHEMJA6C4DQV22UAPCTQUPFHLXM9H8Z3K2E72Q4K9HCZ7VQ7ZWS8R',
                exception: 'has no matching Script',
            },
            {
                address: 'bc1pw5dgrnzv',
                exception: 'has no matching Script',
            },
            {
                address:
                    'bc1p0xlxvlhemja6c4dqv22uapctqupfhlxm9h8z3k2e72q4k9hcz7v8n0nx0muaewav253zgeav',
                exception: 'has no matching Script',
            },
            {
                address: 'BC1QR508D6QEJXTDG4Y5R3ZARVARYV98GJ9P',
                exception: 'has no matching Script',
            },
            {
                address: 'tb1p0xlxvlhemja6c4dqv22uapctqupfhlxm9h8z3k2e72q4k9hcz7vq47Zagq',
                exception: 'has no matching Script',
                network: 'testnet',
            },
            {
                address: 'bc1p0xlxvlhemja6c4dqv22uapctqupfhlxm9h8z3k2e72q4k9hcz7v07qwwzcrf',
                exception: 'has no matching Script',
            },
            {
                address: 'tb1p0xlxvlhemja6c4dqv22uapctqupfhlxm9h8z3k2e72q4k9hcz7vpggkg4j',
                exception: 'has no matching Script',
            },
            {
                address: 'bc1gmk9yu',
                exception: 'has no matching Script',
            },
        ],
    },
    // based on https://github.com/trezor/trezor-address-validator/blob/master/test/wallet_address_validator.js
    addressTypes: [
        ['bitcoin', '1NSAR5mUUL3qZP29BfFj5jBPR5yWiiZZWi', 'p2pkh'],
        ['bitcoin', '3CgkdgWwZ1RJGyHfcYnDe2qGTwaAtifeQw', 'p2sh'],
        ['bitcoin', 'bc1qwqdg6squsna38e46795at95yu9atm8azzmyvckulcc7kytlcckxswvvzej', 'p2wsh'],
        ['bitcoin', 'bc1qr0c0jscha3tzr7963zz4u2wsezsxvpzkwmrvhg', 'p2wpkh'],
        ['bitcoin', 'bc1p5cyxnuxmeuwuvkwfem96lqzszd02n6xdcjrs20cac6yqjjwudpxqkedrcr', 'p2tr'],
        ['bitcoin', 'bc1pqyqszqgpqyqszqgpqyqszqgpqyqszqgpqyqszqgpqyqszqgpqyqsyjer9e', 'p2tr'],
        ['bitcoin', 'bc1sw50qgdz25j', 'p2w-unknown'],
        ['testnet', 'bc1sw50qgdz25j', 'unknown'],
        ['bitcoin', 'qwerty', 'unknown'],
        ['regtest', 'mvbu1Gdy8SUjTenqerxUaZyYjmveZvt33q', 'p2pkh'],
        ['regtest', 'ms1B699PA2tAfHTFTwN12Tzxa933WpmuHX', 'p2pkh'],
        ['regtest', '2N4Q5FhU2497BryFfUgbqkAJE87aKHUhXMp', 'p2sh'],
        ['regtest', 'bcrt1q8zx9dlztqz9apm7y5gtx8a0tlz57fhncycvun5', 'p2wpkh'],
        ['regtest', 'bcrt1pzndg2aenknysnqs0d8gwhg54nqnc6yut2c6as76h4tyqhr8spr6slpjy3x', 'p2tr'],
        ['litecoin', 'LVg2kJoFNg45Nbpy53h7Fe1wKyeXVRhMH9', 'p2pkh'],
        ['litecoin', 'ltc1qajkrze8gc5qdx2ehldsmd596a2gprnn50a53mj3xxvy0zgtdq6gqumv03a', 'p2wsh'],
        ['doge', 'DMqRVLrhbam3Kcfddpxd6EYvEBbpi3bEpP', 'p2pkh'],
        ['doge', 'A7JjzK9k9x5b2MkkQzqt91WZsuu7wTu6iS', 'p2sh'],
        ['doge', 'qwerty', 'unknown'],
    ] as const,
};
