import { CSSColor } from './types';

export const palette: Record<string, CSSColor> = {
    coinsAdaBold: '#3468D1',
    coinsAdaSubdued: '#3468D14D',
    coinsBchBold: '#0AC18E',
    coinsBchSubdued: '#0AC18E4D',
    coinsBnbBold: '#F0B90B',
    coinsBnbSubdued: '#F0B90B33',
    coinsBtcBold: '#F29D40',
    coinsBtcSubdued: '#F29D404D',
    coinsBtgBold: '#3B5185',
    coinsBtgSubdued: '#3B51854D',
    coinsCroBold: '#002D74',
    coinsCroSubdued: '#002D744D',
    coinsDaiBold: '#F5AC37',
    coinsDaiSubdued: '#F5AC374D',
    coinsDashBold: '#1796E4',
    coinsDashSubdued: '#1796E44D',
    coinsDgbBold: '#3A75C9',
    coinsDgbSubdued: '#3A75C94D',
    coinsDogeBold: '#C8AF47',
    coinsDogeSubdued: '#C8AF474D',
    coinsEosBold: '#000000',
    coinsEosSubdued: '#0000004D',
    coinsErc20Bold: '#A6A8A9',
    coinsErc20Subdued: '#A6A8A94D',
    coinsEtcBold: '#60C67E',
    coinsEtcSubdued: '#60C67E4D',
    coinsEthBold: '#454A75',
    coinsEthSubdued: '#454A754D',
    coinsGntBold: '#8A92B2',
    coinsGntSubdued: '#8A92B24D',
    coinsLeoBold: '#171C1F',
    coinsLeoSubdued: '#171C1F4D',
    coinsLinkBold: '#2A5ADA',
    coinsLinkSubdued: '#2A5ADA4D',
    coinsLtcBold: '#A6A8A9',
    coinsLtcSubdued: '#A6A8A94D',
    coinsMaticBold: '#8247E5',
    coinsMaticSubdued: '#8247E533',
    coinsNameBold: '#2D78A4',
    coinsNameSubdued: '#2D78A44D',
    coinsNemBold: '#000000',
    coinsNemSubdued: '#0000004D',
    coinsOkbBold: '#000000',
    coinsOkbSubdued: '#0000004D',
    coinsShibBold: '#DD3935',
    coinsShibSubdued: '#DD39354D',
    coinsSolBold: '#000000',
    coinsSolSubdued: '#0000004D',
    coinsTnetBold: '#E75F5F',
    coinsTnetSubdued: '#E75F5F4D',
    coinsUniBold: '#ED2B88',
    coinsUniSubdued: '#ED2B884D',
    coinsUsdcBold: '#2775CA',
    coinsUsdcSubdued: '#2775CA4D',
    coinsUsdtBold: '#53AE94',
    coinsUsdtSubdued: '#53AE944D',
    coinsVtcBold: '#1B9065',
    coinsVtcSubdued: '#1B90654D',
    coinsWbtcBold: '#F29D40',
    coinsWbtcSubdued: '#F29D404D',
    coinsXlmBold: '#000000',
    coinsXlmSubdued: '#0000004D',
    coinsXmrBold: '#F4702A',
    coinsXmrSubdued: '#F4702A4D',
    coinsXrpBold: '#24292E',
    coinsXrpSubdued: '#24292E4D',
    coinsXtzBold: '#2C7DF7',
    coinsXtzSubdued: '#2C7DF74D',
    coinsZecBold: '#E0AB3C',
    coinsZecSubdued: '#E0AB3C4D',
    darkAccentBlue100: '#0E222A',
    darkAccentBlue200: '#16262D',
    darkAccentBlue300: '#1B2E37',
    darkAccentBlue400: '#1E333E',
    darkAccentBlue50: '#0B1C22',
    darkAccentBlue500: '#233C48',
    darkAccentBlue600: '#27789B',
    darkAccentBlue700: '#2B85AB',
    darkAccentBlue800: '#70BBDB',
    darkAccentRed100: '#301717',
    darkAccentRed200: '#351D1D',
    darkAccentRed300: '#3F2222',
    darkAccentRed400: '#452727',
    darkAccentRed50: '#261212',
    darkAccentRed500: '#522E2E',
    darkAccentRed600: '#B65454',
    darkAccentRed700: '#C15C5C',
    darkAccentRed800: '#D89797',
    darkAccentYellow100: '#29200A',
    darkAccentYellow200: '#2E260F',
    darkAccentYellow300: '#342B14',
    darkAccentYellow400: '#3B3117',
    darkAccentYellow50: '#231B06',
    darkAccentYellow500: '#463A1B',
    darkAccentYellow600: '#D2AC4B',
    darkAccentYellow700: '#D8B864',
    darkAccentYellow800: '#E2CA8D',
    darkGray000: '#0F0F0F',
    darkGray100: '#1D1D1D',
    darkGray1000: '#FFFFFF',
    darkGray200: '#252525',
    darkGray300: '#2B2B2B',
    darkGray400: '#333333',
    darkGray50: '#171717',
    darkGray500: '#3B3B3B',
    darkGray600: '#6B6B6B',
    darkGray700: '#A3A3A3',
    darkGray800: '#E1E1E1',
    darkGray900: '#F4F4F4',
    darkPrimaryForest100: '#0E2F25',
    darkPrimaryForest200: '#0E2F25',
    darkPrimaryForest300: '#135340',
    darkPrimaryForest400: '#186850',
    darkPrimaryForest500: '#1D8163',
    darkPrimaryForest600: '#28AF86',
    darkPrimaryForest700: '#2ECC9C',
    darkPrimaryForest800: '#61DBB7',
    darkPrimaryForest900: '#A7F1DB',
    darkSecondaryGreen100: '#092519',
    darkSecondaryGreen200: '#0C3122',
    darkSecondaryGreen300: '#145238',
    darkSecondaryGreen700: '#259365',
    darkSecondaryGreen800: '#2FBC81',
    darkSecondaryGreen900: '#74DCB1',
    lightAccentBlue100: '#F0F7FA',
    lightAccentBlue200: '#E4F1F6',
    lightAccentBlue300: '#D5E9F1',
    lightAccentBlue400: '#C2DFEB',
    lightAccentBlue600: '#007DB2',
    lightAccentBlue700: '#006F9E',
    lightAccentBlue800: '#00597F',
    lightAccentRed100: '#FBEFEF',
    lightAccentRed200: '#F7E3E3',
    lightAccentRed300: '#F3D3D3',
    lightAccentRed400: '#EEBFBF',
    lightAccentRed600: '#CD4949',
    lightAccentRed700: '#B43C3C',
    lightAccentRed800: '#862D2D',
    lightAccentYellow50: '#FDF5E1', // @TODO this color should be defined from figma export
    lightAccentYellow100: '#FEF6E1',
    lightAccentYellow200: '#FCF1D5',
    lightAccentYellow300: '#FAE9BD',
    lightAccentYellow400: '#FBE19D',
    lightAccentYellow600: '#F8C135',
    lightAccentYellow700: '#F2B20D',
    lightAccentYellow800: '#8A6300',
    lightBlackAlpha100: '#0000000A',
    lightBlackAlpha1000: '#000000EB',
    lightBlackAlpha200: '#00000014',
    lightBlackAlpha300: '#0000001F',
    lightBlackAlpha400: '#00000029',
    lightBlackAlpha500: '#0000003D',
    lightBlackAlpha600: '#0000007A',
    lightBlackAlpha700: '#000000A3',
    lightBlackAlpha800: '#000000CC',
    lightBlackAlpha900: '#000000E0',
    lightGray100: '#F6F6F6',
    lightGray1000: '#171717',
    lightGray200: '#EEEEEE',
    lightGray300: '#E2E2E2',
    lightGray400: '#D6D6D6',
    lightGray500: '#B8B8B8',
    lightGray600: '#8C8C8C',
    lightGray700: '#616161',
    lightGray800: '#333333',
    lightGray900: '#1F1F1F',
    lightPrimaryForest100: '#F0F9F6',
    lightPrimaryForest200: '#E6F4F0',
    lightPrimaryForest300: '#D7EEE8',
    lightPrimaryForest400: '#C6E7DD',
    lightPrimaryForest500: '#94DBC6',
    lightPrimaryForest600: '#31C498',
    lightPrimaryForest700: '#189A73',
    lightPrimaryForest800: '#0F6148',
    lightPrimaryForest900: '#0C4B38',
    lightSecondaryEmerald100: '#EDFDF6',
    lightSecondaryEmerald200: '#DFFBEF',
    lightSecondaryEmerald300: '#CDF9E7',
    lightSecondaryEmerald400: '#B6F6DC',
    lightSecondaryEmerald500: '#7EF1BF',
    lightSecondaryEmerald600: '#3CDD96',
    lightSecondaryEmerald700: '#00B368',
    lightSecondaryEmerald800: '#00854D',
    lightSecondaryEmerald900: '#005C36',
    lightSecondaryEmeraldBase10opacity: '#00854D1A',
    lightSecondaryEmeraldBase20opacity: '#00854D33',
    lightSecondaryLime100: '#F1FBEE',
    lightSecondaryLime200: '#E6F9E2',
    lightSecondaryLime300: '#D8F5D1',
    lightSecondaryLime400: '#C7F1BC',
    lightSecondaryLime500: '#9BE887',
    lightSecondaryLime600: '#7DBD6D',
    lightSecondaryLime700: '#619454',
    lightSecondaryLime800: '#44693A',
    lightSecondaryLime900: '#395A30',
    lightWhiteAlpha100: '#FFFFFF1F',
    lightWhiteAlpha1000: '#FFFFFF',
    lightWhiteAlpha200: '#FFFFFF33',
    lightWhiteAlpha300: '#FFFFFF61',
    lightWhiteAlpha400: '#FFFFFF8C',
    lightWhiteAlpha500: '#FFFFFFBF',
    lightWhiteAlpha600: '#FFFFFFD6',
    lightWhiteAlpha700: '#FFFFFFE3',
    lightWhiteAlpha800: '#FFFFFFED',
    lightWhiteAlpha900: '#FFFFFFF5',
    lightAccentPurple800: '#4A2D86',
    lightAccentPurple700: '#643CB4',
    lightAccentPurple600: '#7549CD',
    lightAccentPurple400: '#CEBFEE',
    lightAccentPurple300: '#DED3F3',
    lightAccentPurple200: '#EAE3F7',
    lightAccentPurple100: '#F3EFFB',
    darkAccentPurple800: '#AD97D8',
    darkAccentPurple700: '#7E5CC1',
    darkAccentPurple600: '#7454B6',
    darkAccentPurple500: '#3A2E52',
    darkAccentPurple400: '#312745',
    darkAccentPurple300: '#2C223F',
    darkAccentPurple200: '#251D35',
    darkAccentPurple100: '#1F1730',
    darkAccentPurple50: '#191226',
};
