import styled from 'styled-components';

const Wrapper = styled.div<{ $width: number; $height: number }>`
    width: ${({ $width }) => $width}px;
    height: ${({ $height }) => $height}px;
`;

interface EverstakeLogoProps {
    width?: number;
    height?: number;
    color?: string;
}

export const EverstakeLogo = ({ width = 103, height = 17, color = '#000' }: EverstakeLogoProps) => {
    return (
        <Wrapper $width={width} $height={height}>
            <svg viewBox="0 0 250 44" fill={color} xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M11.458.767c-1.678 1.027-1.574.875-6.659 9.65C2.288 14.751.245 18.763.134 19.583c-.173 1.269.409 2.518 4.465 9.584 2.565 4.468 5.036 8.531 5.49 9.029 1.571 1.718 2.608 1.853 13.166 1.721l10.061-.125 1.008-1.042c.554-.573 3.104-4.698 5.667-9.167C45.88 19.316 45.89 20.509 39.815 10c-2.451-4.24-5.008-8.224-5.684-8.854L32.904 0 22.806.002c-9.06.001-10.226.08-11.348.765M29.88 3.646c-1.811 3.35-7.684 13.42-8.14 13.958-.549.647-1.508.729-8.499.729-4.921 0-8.2.172-8.733.457-1.077.577-1.257.955 3.359-7.073l3.908-6.798 2.55 4.415c1.402 2.428 2.887 4.524 3.299 4.658.919.299 1.959-.5 1.959-1.504 0-1.053-4.02-7.755-5.11-8.518-.828-.58-.177-.637 7.334-.637 4.533 0 8.166.141 8.073.313m3.72 1.458c.032.516 1.666 3.703 3.632 7.084l3.573 6.145h-4.952c-2.723 0-5.248.114-5.611.253-.776.298-.873 1.866-.159 2.581.609.609 8.529.69 10.073.103.91-.346.576.412-2.618 5.938-2.013 3.483-3.848 6.681-4.078 7.106-.351.65-1.087-.386-4.647-6.537-2.326-4.02-4.23-7.53-4.23-7.8 0-.378 8.698-15.811 8.911-15.81.026 0 .074.422.106.937m176.87-.377c-.256.309-.583 1.152-.728 1.875-.262 1.31-.257 1.315 1.507 1.315 1.454 0 1.685.102 1.294.572-.334.403-.442 3.533-.363 10.521l.112 9.948 1.979.127 1.979.127v-3.773c0-3.665.028-3.772.964-3.772.708 0 1.778.994 4.036 3.75 2.716 3.314 3.229 3.75 4.419 3.75 2.014 0 2.634-.371 3.305-1.977.335-.802.609-1.529.609-1.616 0-.086-.742-.157-1.648-.157-1.536 0-1.807-.196-3.959-2.859-1.27-1.572-2.309-3.001-2.309-3.174 0-.174 1.52-1.981 3.378-4.017l3.379-3.7-2.441.003-2.441.004-2.89 3.538c-4.287 5.248-4.402 5.15-4.402-3.754V4.167h-2.657c-1.718 0-2.822.198-3.123.56m-37.762 2.087c-1.641.493-1.668.533-1.792 2.677-.121 2.085-.176 2.176-1.314 2.176-.957 0-1.276.254-1.645 1.312-.683 1.961-.633 2.021 1.71 2.021 1.685 0 2.055.111 1.666.5-.688.688-.615 7.2.104 9.215 1.129 3.164 3.321 4.586 7.105 4.606 1.73.009 3.17-.283 4.674-.95 3.017-1.336 3.321-1.797 2.211-3.357l-.901-1.265-1.779 1.042c-1.89 1.108-4.297 1.357-5.726.592-1.363-.729-2.021-2.953-2.021-6.828V15h7.959l.604-1.445c.332-.795.604-1.545.604-1.667 0-.122-2.063-.221-4.584-.221H175V8.958c0-1.489-.141-2.694-.312-2.676-.172.018-1.063.257-1.98.532M66.042 12.038c-3.192 1.472-4.798 4.248-4.783 8.261.018 4.647 2.605 7.983 6.88 8.871 2.802.581 6.299.096 8.913-1.237 1.527-.779 1.679-.992 1.436-2.007-.149-.624-.317-1.191-.373-1.259-.056-.069-1.295.278-2.754.77-1.927.65-3.325.847-5.11.719-2.127-.153-2.618-.355-3.646-1.506-.654-.731-1.188-1.702-1.188-2.157 0-.787.294-.826 6.263-.826 7.116 0 6.877.124 6.841-3.569-.026-2.666-1.158-4.67-3.336-5.903-2.146-1.216-6.68-1.294-9.143-.157m42.916-.434c-4.238 1.378-6.672 6.013-5.621 10.704.902 4.027 2.93 6.008 7.054 6.892 2.453.526 6.077.028 8.618-1.183 1.181-.563 1.408-.894 1.408-2.053 0-1.607.061-1.595-2.917-.547-4.105 1.444-8.438.816-9.485-1.373-1.185-2.479-1.488-2.346 5.648-2.471l6.545-.115.115-2.708c.213-5.014-2.422-7.54-7.784-7.458-1.511.022-3.122.163-3.581.312m27.084.132c-.459.254-1.265.852-1.793 1.331-.818.742-1.017.779-1.348.255-.213-.337-.391-.848-.395-1.134-.004-.373-.946-.521-3.299-.521h-3.292l-.458 1.312c-.251.722-.457 1.472-.457 1.667 0 .194 1.163.354 2.583.354 2.01 0 2.473.111 2.084.5-.33.33-.5 2.102-.5 5.208v4.709l-1.146.006c-.63.004-1.369.148-1.641.321-.487.31-1.38 2.272-1.38 3.033 0 .226 2.937.39 7.004.39 7.648 0 7.993-.095 8.754-2.396l.449-1.354h-7.874v-4.13c0-4.118.004-4.133 1.309-5.23 1.735-1.461 3.663-1.332 4.44.297.46.964.808 1.146 2.191 1.146 1.529 0 1.644-.083 1.644-1.188 0-1.837-.795-3.691-1.892-4.41-1.147-.751-3.766-.839-4.983-.166m14.382.402c-1.746 1.064-2.366 1.854-2.679 3.412-.536 2.67 1.645 4.618 6.777 6.053 4.934 1.38 6.182 2.644 4.013 4.065-1.419.929-4.533.602-7.299-.767l-2.138-1.058-.798 1.308c-.438.719-.798 1.431-.798 1.583-.003.538 3.705 2.059 6.104 2.503 6.473 1.2 11.793-2.756 9.547-7.099-.823-1.591-2.729-2.595-7.227-3.807-3.679-.991-4.649-1.806-3.697-3.107.848-1.16 3.837-1.278 6.715-.265 1.367.481 2.534.874 2.593.874.131 0 1.38-2.386 1.38-2.636 0-.098-.926-.576-2.057-1.062-2.917-1.255-8.375-1.254-10.436.003m42.798-.298c-1.092.294-2.048.61-2.124.701-.077.092.03.796.238 1.564.32 1.187.514 1.355 1.291 1.116.503-.155 2.227-.382 3.831-.506 2.564-.198 3.009-.123 3.675.616.487.539.711 1.319.625 2.174l-.133 1.333-3.333.087c-5.926.155-8.697 2.861-7.29 7.122.657 1.991 2.508 3.116 5.13 3.118 2.147.002 3.259-.419 4.786-1.81.818-.746 1.017-.784 1.348-.261.213.338.391.942.394 1.344.005.592.379.727 1.986.722 2.448-.008 2.937-.305 3.275-1.993.243-1.217.175-1.334-.779-1.334-1.349 0-1.563-1.038-1.289-6.25.246-4.666-.392-6.415-2.77-7.603-1.738-.868-5.907-.934-8.861-.14m44.338-.165c-4.207 1.773-6.246 6.299-5.061 11.237 1.341 5.592 7.248 7.916 14.24 5.603 2.417-.8 2.996-1.46 2.652-3.026l-.266-1.212-2.375.976c-2.68 1.103-5.699 1.274-7.701.437-1.601-.67-2.219-1.351-2.6-2.869l-.284-1.133 6.605-.115 6.605-.115v-2.991c0-2.371-.178-3.229-.859-4.141-1.749-2.341-2.898-2.86-6.567-2.966-1.874-.054-3.849.088-4.389.315M81.714 12.959c-.683 1.96-.629 2.041 1.353 2.041 1.694 0 1.804.068 1.626 1.001-.175.918 3.92 11.248 5.022 12.665.265.34 1.125.495 2.324.417l1.904-.125 3.03-7.916c1.667-4.354 3.139-8.255 3.272-8.669.216-.671.004-.739-1.957-.625l-2.2.127-1.896 5.313c-1.043 2.922-2.079 5.252-2.302 5.178-.223-.074-1.461-2.465-2.752-5.313l-2.345-5.178-2.308-.124c-2.261-.121-2.316-.097-2.771 1.208m-8.827 1.817c1.276.66 1.696 1.395 1.696 2.966 0 1.005-.013 1.008-4.583 1.008-4.114 0-4.583-.076-4.583-.741 0-2.765 4.558-4.738 7.47-3.233m42.562.609c.716.716 1.218 1.66 1.218 2.291v1.074h-4.584c-3.881 0-4.583-.1-4.583-.652 0-1.952 2.582-3.927 5.136-3.93 1.208-.001 1.89.294 2.813 1.217m129.433.222c.523.608.951 1.564.951 2.125v1.018h-4.791c-2.636 0-4.792-.112-4.792-.25 0-.974 1.537-3.124 2.634-3.684 1.948-.995 4.783-.621 5.998.791m-44.778 5.637c1.237.01.974 2.67-.369 3.726-1.602 1.261-4.499 1.195-5.361-.122-.895-1.365-.225-3.069 1.34-3.414.639-.142 1.349-.324 1.578-.406.229-.081.791-.068 1.25.031a9.312 9.312 0 0 0 1.562.185M21.745 22.396c.343.401 2.177 3.448 4.076 6.771 1.898 3.323 3.849 6.365 4.336 6.761.845.688.528.721-7.136.729-4.412.005-8.021-.103-8.021-.24 0-.138 1.046-2.097 2.323-4.354 2.616-4.619 2.814-6.021.851-6.021-1.098 0-1.446.429-4.061 5-1.894 3.311-2.86 4.665-2.861 4.008-.001-.545-1.528-3.639-3.394-6.875a2239.14 2239.14 0 0 1-3.566-6.196c-.096-.172 3.651-.312 8.327-.312 7.581 0 8.569.079 9.126.729"
                    fillRule="evenodd"
                />
            </svg>
        </Wrapper>
    );
};
