import { useTheme } from 'styled-components';

export const IllustrativeExample = () => {
    const theme = useTheme();

    return (
        <svg
            width="143"
            height="43"
            viewBox="0 0 143 43"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <path
                d="M1.29361 18.5556C1.40557 17.6565 1.5028 16.7065 1.58532 15.7054C1.68166 14.706 1.77195 13.6989 1.85619 12.684C1.95598 11.657 2.07394 10.6533 2.21006 9.67297C2.34618 8.69262 2.52296 7.78054 2.7404 6.93674C2.76979 6.92635 2.8329 6.92719 2.92972 6.93924C3.0421 6.93919 3.11903 6.94175 3.16053 6.94692C3.35418 6.97103 3.50202 7.02456 3.60407 7.10749C3.72167 7.17832 3.76755 7.31748 3.74171 7.52496C3.64009 8.34104 3.52208 9.23235 3.38769 10.1989C3.26884 11.1533 3.1405 12.1276 3.00266 13.1217C2.88037 14.1038 2.75894 15.079 2.63837 16.0472C2.51781 17.0154 2.42227 17.8955 2.35176 18.6874C2.33631 18.9242 2.26895 19.0704 2.14968 19.1257C2.04253 19.1967 1.91287 19.2227 1.76072 19.2037C1.59474 19.1831 1.46158 19.1243 1.36126 19.0276C1.25922 18.9446 1.23667 18.7873 1.29361 18.5556ZM2.68698 3.64322C2.70765 3.47724 2.77676 3.37347 2.8943 3.33192C3.01185 3.29037 3.13978 3.27821 3.2781 3.29543C3.55474 3.32988 3.71645 3.44132 3.76322 3.62975C3.80998 3.81817 3.81873 4.02996 3.78945 4.2651C3.68751 4.40692 3.56999 4.50466 3.43689 4.55832C3.30551 4.59814 3.17239 4.59561 3.03751 4.55072C2.91819 4.49373 2.81873 4.39004 2.73913 4.23966C2.67336 4.09101 2.65598 3.8922 2.68698 3.64322ZM4.08671 18.2502C4.26276 17.626 4.42404 16.8384 4.57055 15.8875C4.73089 14.9382 4.87131 13.9233 4.99183 12.8427C5.12617 11.7638 5.24407 10.6477 5.34554 9.49452C5.447 8.3413 5.52687 7.2486 5.58517 6.21642C5.64519 5.17041 5.67759 4.23333 5.68239 3.40519C5.70102 2.57877 5.6912 1.92439 5.65294 1.44204C5.78776 1.37455 5.89925 1.32523 5.98741 1.29406C6.09112 1.25079 6.20522 1.23691 6.32971 1.25241C6.42654 1.26447 6.50694 1.29555 6.57094 1.34566C6.63665 1.38193 6.68337 1.45798 6.71108 1.5738C6.65014 4.31932 6.4967 7.07439 6.25077 9.83901C6.01868 12.6054 5.76064 15.3544 5.47666 18.0862C5.46116 18.2107 5.43963 18.3836 5.41207 18.6049C5.38624 18.8124 5.36554 18.9222 5.34999 18.9343C5.14428 19.007 4.96536 19.0339 4.8132 19.0149C4.66277 18.9822 4.52962 18.9234 4.41375 18.8388C4.29959 18.7403 4.21396 18.6383 4.15686 18.5329C4.09976 18.4274 4.07637 18.3332 4.08671 18.2502ZM6.79971 18.5881C6.97576 17.9639 7.13704 17.1763 7.28355 16.2253C7.44389 15.2761 7.58432 14.2611 7.70483 13.1805C7.83918 12.1016 7.95708 10.9856 8.05854 9.83235C8.16 8.67912 8.23988 7.58642 8.29817 6.55425C8.35819 5.50824 8.3906 4.57116 8.3954 3.74302C8.41402 2.91659 8.40421 2.26221 8.36594 1.77987C8.50076 1.71238 8.61226 1.66305 8.70041 1.63189C8.80413 1.58862 8.91823 1.57473 9.04272 1.59024C9.13954 1.60229 9.21995 1.63337 9.28394 1.68348C9.34966 1.71976 9.39637 1.79581 9.42409 1.91163C9.36314 4.65715 9.20971 7.41221 8.96378 10.1768C8.73168 12.9432 8.47365 15.6922 8.18967 18.424C8.17416 18.5485 8.15264 18.7214 8.12508 18.9427C8.09924 19.1502 8.07855 19.26 8.06299 19.2721C7.85729 19.3448 7.67836 19.3717 7.52621 19.3528C7.37578 19.32 7.24263 19.2613 7.12675 19.1766C7.0126 19.0781 6.92697 18.9761 6.86986 18.8707C6.81276 18.7653 6.78938 18.6711 6.79971 18.5881ZM14.5149 18.1792C14.4389 18.3383 14.2722 18.5493 14.0147 18.8123C13.7728 19.0631 13.4885 19.3156 13.1619 19.5699C12.8369 19.8104 12.5016 20.0215 12.1559 20.2032C11.8258 20.3728 11.5432 20.4429 11.308 20.4136C10.8654 20.3585 10.5247 20.1054 10.2859 19.6543C10.0609 19.2049 9.91282 18.6456 9.84162 17.9766C9.77042 17.3075 9.75625 16.5753 9.79909 15.78C9.84366 14.9709 9.9064 14.1851 9.9873 13.4226C10.0682 12.6601 10.1474 11.9677 10.2249 11.3452C10.3024 10.7228 10.3402 10.2499 10.3383 9.9266C10.4109 9.79517 10.4904 9.72079 10.5768 9.70346C10.6771 9.68785 10.7895 9.6878 10.914 9.7033C11.0246 9.71708 11.1197 9.74297 11.1993 9.78097C11.2926 9.82069 11.3653 9.91402 11.4172 10.0609C11.3983 10.2131 11.3664 10.469 11.3216 10.8286C11.2907 11.19 11.2606 11.6006 11.2315 12.0605C11.204 12.5066 11.1731 12.9803 11.1388 13.4817C11.1061 13.9693 11.0692 14.4352 11.0279 14.8796C11.0005 15.3256 10.9713 15.7293 10.9403 16.0907C10.9249 16.4399 10.9138 16.6984 10.907 16.8661C10.9087 16.9647 10.9028 17.1255 10.889 17.3485C10.8891 17.5732 10.8944 17.8127 10.9049 18.0668C10.931 18.3089 10.9665 18.531 11.0116 18.7333C11.0705 18.9373 11.1613 19.0539 11.284 19.0833C11.4915 19.1091 11.7102 19.045 11.9401 18.891C12.1838 18.7388 12.4266 18.5372 12.6685 18.2864C12.9104 18.0356 13.142 17.7554 13.3631 17.4459C13.5843 17.1363 13.783 16.838 13.9592 16.5509C14.1509 16.2517 14.2969 15.9819 14.3971 15.7416C14.5111 15.5029 14.5819 15.3291 14.6095 15.2202C14.6664 14.9885 14.7354 14.66 14.8165 14.2346C14.8993 13.7954 14.9786 13.3277 15.0544 12.8315C15.1302 12.3353 15.1957 11.8659 15.2508 11.4232C15.3198 10.9823 15.3689 10.6443 15.3982 10.4092L16.5316 10.6135C16.4059 11.7356 16.2724 12.7514 16.131 13.6609C15.9914 14.5565 15.8786 15.4063 15.7925 16.2103C15.7082 17.0004 15.6748 17.7759 15.6925 18.5366C15.7101 19.2973 15.8142 20.0968 16.0048 20.9353C15.9581 20.9716 15.8683 21.0166 15.7352 21.0702C15.6003 21.1377 15.5053 21.168 15.4499 21.1611C15.1041 21.1181 14.8836 20.9712 14.7884 20.7206C14.7053 20.4855 14.662 20.2132 14.6584 19.9038C14.6703 19.5822 14.6814 19.2675 14.6916 18.9598C14.7174 18.6399 14.6585 18.3797 14.5149 18.1792ZM18.6476 20.8219C18.6459 20.8357 18.8014 20.7708 19.1143 20.6272C19.441 20.4852 19.823 20.294 20.2603 20.0535C20.7131 19.8009 21.1755 19.5283 21.6473 19.2359C22.1209 18.9297 22.5158 18.6347 22.8321 18.351C23.1483 18.0674 23.3271 17.8157 23.3685 17.5961C23.4255 17.3644 23.2577 17.189 22.8652 17.0699C22.3758 16.9388 21.9531 16.8931 21.597 16.9331C21.2547 16.9747 20.9383 17.0337 20.6479 17.1099C20.3575 17.1861 20.0817 17.2571 19.8207 17.3229C19.5735 17.3905 19.3064 17.3923 19.0194 17.3285C18.4108 17.2527 18.0121 17.0134 17.8235 16.6107C17.6504 16.1958 17.6043 15.6634 17.6853 15.0132C17.7662 14.3631 17.9881 13.7657 18.3509 13.2209C18.7155 12.6623 19.1527 12.197 19.6625 11.8251C20.1724 11.4531 20.7402 11.1797 21.366 11.0048C21.9935 10.816 22.6184 10.7604 23.2409 10.8379C23.4898 10.8689 23.7016 10.9164 23.8763 10.9803C24.0509 11.0442 24.121 11.2144 24.0866 11.4911C24.0625 11.6847 23.9562 11.8611 23.7679 12.0203C23.5812 12.1656 23.3842 12.2253 23.1767 12.1995C23.1628 12.1978 23.1291 12.1865 23.0755 12.1658C23.0236 12.1313 22.9726 12.0898 22.9224 12.0414C22.8723 11.993 22.8204 11.9585 22.7668 11.9377C22.7149 11.9032 22.6821 11.885 22.6682 11.8833C22.2411 11.7037 21.8046 11.7126 21.3586 11.9099C20.9126 12.1072 20.497 12.3996 20.1116 12.787C19.7418 13.1624 19.4291 13.587 19.1734 14.0608C18.9195 14.5208 18.7684 14.9444 18.7202 15.3317C18.7012 15.4839 18.7134 15.6118 18.7567 15.7155C18.8155 15.8071 18.8907 15.8797 18.9824 15.9333C19.0879 15.9885 19.202 16.0309 19.3248 16.0602C19.4631 16.0774 19.6014 16.0946 19.7397 16.1119C20.0164 16.1463 20.2982 16.1393 20.5852 16.0907C20.886 16.0439 21.1747 15.9815 21.4513 15.9036C21.7417 15.8274 22.0304 15.765 22.3173 15.7165C22.6181 15.6696 22.9207 15.6652 23.225 15.7031C23.3633 15.7203 23.5103 15.7807 23.666 15.8844C23.8233 15.9742 23.9617 16.1038 24.0811 16.2732C24.2022 16.4287 24.2991 16.6094 24.3718 16.8151C24.4462 17.0069 24.4766 17.2144 24.4628 17.4374C24.5217 17.6414 24.4622 17.8938 24.2843 18.1948C24.1202 18.4974 23.8843 18.8122 23.5767 19.1391C23.2691 19.466 22.9054 19.7929 22.4854 20.1199C22.0671 20.433 21.6523 20.7185 21.241 20.9763C20.8314 21.2202 20.4355 21.4097 20.0535 21.5448C19.6698 21.6936 19.3543 21.7456 19.107 21.7008C18.8304 21.6664 18.6747 21.5627 18.6401 21.3898C18.6192 21.2187 18.6217 21.0294 18.6476 20.8219ZM26.2011 13.0818C26.0542 13.1337 25.9133 13.1934 25.7785 13.2609C25.6592 13.3163 25.54 13.3717 25.4207 13.427C25.3032 13.4686 25.1873 13.4963 25.0732 13.5102C24.9591 13.5241 24.8416 13.5094 24.7205 13.4663C24.6375 13.4559 24.5744 13.3989 24.5311 13.2952C24.4896 13.1777 24.4627 13.0549 24.4506 12.927C24.4263 12.7835 24.415 12.6486 24.4166 12.5224C24.42 12.3824 24.433 12.2787 24.4554 12.2112L26.5893 11.3181L27.3752 6.02212C27.4252 5.84575 27.5445 5.79037 27.733 5.85598C27.9232 5.90775 28.1186 5.97422 28.3192 6.05539C28.3468 6.05883 28.3866 6.07783 28.4385 6.11238C28.5059 6.13483 28.5526 6.15469 28.5786 6.17196C28.5044 6.54198 28.419 6.94572 28.3224 7.38318C28.2413 7.80852 28.1594 8.24079 28.0766 8.67996C27.9956 9.10531 27.9223 9.5246 27.8568 9.93784C27.8051 10.3528 27.7794 10.7288 27.7795 11.066L31.0002 10.5821C31.0573 10.5752 31.0936 10.6218 31.1092 10.7221C31.1404 10.8102 31.162 10.9183 31.1742 11.0462C31.2002 11.1759 31.2124 11.3038 31.2107 11.43C31.209 11.5562 31.2082 11.6193 31.2082 11.6193L27.495 12.674C27.4795 12.7985 27.4494 13.0967 27.4047 13.5687C27.3738 14.0425 27.3317 14.6061 27.2784 15.2597C27.2268 15.8994 27.1684 16.5944 27.103 17.3448C27.0394 18.0813 26.9818 18.7695 26.9303 19.4092C26.8787 20.0489 26.8297 20.6117 26.7832 21.0975C26.7385 21.5695 26.7084 21.8678 26.6929 21.9923C26.6135 22.4038 26.4632 22.5957 26.2419 22.5682C26.0344 22.5424 25.8191 22.4102 25.596 22.1717L26.2011 13.0818ZM31.2763 12.5549L31.2969 12.3889C31.3142 12.2506 31.3746 12.1598 31.4783 12.1165C31.5959 12.075 31.7238 12.0628 31.8621 12.08C31.9728 12.0938 32.0748 12.1206 32.1682 12.1603C32.2633 12.1862 32.3299 12.2717 32.368 12.4169C32.3837 12.6296 32.389 12.9252 32.384 13.3038C32.3807 13.6686 32.3792 14.0758 32.3794 14.5253C32.3796 14.9748 32.3763 15.452 32.3697 15.9568C32.3785 16.4496 32.3831 16.9207 32.3833 17.3702C32.3991 17.8076 32.42 18.2035 32.4461 18.5579C32.4722 18.9123 32.5156 19.1846 32.5762 19.3748C32.7 18.0417 32.8845 16.8988 33.1295 15.9461C33.3763 14.9795 33.7105 14.2135 34.1321 13.6479C34.5692 13.0703 35.1067 12.7018 35.7446 12.5424C36.398 12.3709 37.1795 12.4121 38.089 12.6658C38.5178 12.7192 38.7038 12.9741 38.647 13.4305C38.6246 13.6104 38.4915 13.7202 38.2477 13.7601C38.0057 13.7861 37.7377 13.7949 37.4438 13.7864C37.1516 13.7641 36.8655 13.7495 36.5854 13.7427C36.3053 13.7359 36.0961 13.7801 35.9579 13.8753C35.4255 14.0899 35.0194 14.4748 34.7395 15.0299C34.4736 15.5867 34.25 16.2542 34.0688 17.0323C33.8876 17.8104 33.7178 18.6671 33.5591 19.6025C33.4161 20.5258 33.2073 21.469 32.9329 22.4321C32.9157 22.5705 32.8474 22.6673 32.7281 22.7227C32.6089 22.7781 32.4663 22.7954 32.3003 22.7748C32.1481 22.7558 32.0003 22.7023 31.8567 22.6142C31.727 22.5278 31.6293 22.4103 31.5635 22.2616L31.2763 12.5549ZM44.2018 23.7722C44.1774 23.4039 44.1686 22.9674 44.1753 22.4625C44.1975 21.9456 44.2128 21.4278 44.2212 20.9091C44.2313 20.3766 44.2233 19.8769 44.1972 19.4102C44.1848 18.9451 44.1207 18.5578 44.0047 18.2484C43.1201 19.5991 42.3565 20.6558 41.7137 21.4186C41.0726 22.1675 40.5222 22.6959 40.0625 23.0039C39.6183 23.2997 39.2587 23.4235 38.9838 23.3752C38.7089 23.327 38.4962 23.1741 38.3456 22.9165C38.1951 22.659 38.1007 22.3452 38.0625 21.9753C38.0399 21.5932 38.0345 21.2414 38.0465 20.9198C38.0843 20.6155 38.2069 20.1953 38.4141 19.6592C38.6213 19.1232 38.883 18.5448 39.1991 17.9239C39.5169 17.2893 39.8771 16.6529 40.2796 16.0147C40.696 15.3783 41.1253 14.8067 41.5677 14.2999C42.01 13.7931 42.4542 13.3849 42.9001 13.0752C43.346 12.7655 43.7695 12.6357 44.1706 12.6856C44.7775 12.6629 45.1968 12.8485 45.4287 13.2426C45.6761 13.6246 45.6582 14.2193 45.3751 15.0268C45.2614 15.9398 45.1986 16.7256 45.1869 17.3843C45.1889 18.0447 45.1944 18.6775 45.2033 19.2826C45.2261 19.8894 45.2316 20.5222 45.2198 21.1809C45.2218 21.8414 45.166 22.628 45.0523 23.5409C45.0316 23.7069 44.9928 23.8496 44.9358 23.9689C44.8944 24.0761 44.7215 24.1108 44.4172 24.0729C44.3757 24.0677 44.3247 24.0262 44.2641 23.9485C44.2174 23.8724 44.1966 23.8137 44.2018 23.7722ZM44.2363 14.3583C44.1117 14.118 43.9068 14.0715 43.6216 14.2186C43.3364 14.3656 43.0227 14.6286 42.6806 15.0074C42.3384 15.3862 41.979 15.8471 41.6024 16.3901C41.2257 16.9332 40.869 17.4857 40.5321 18.0478C40.1952 18.6098 39.8964 19.1485 39.6356 19.6639C39.3765 20.1654 39.1908 20.5847 39.0786 20.9219C39.0166 21.4198 39.0574 21.7129 39.2009 21.801C39.3462 21.8753 39.5432 21.8155 39.7921 21.6218C40.041 21.428 40.3296 21.1409 40.6579 20.7604C41 20.3816 41.3318 19.9734 41.6531 19.5358C41.9883 19.1 42.3011 18.6754 42.5913 18.2621C42.8954 17.8504 43.1339 17.5149 43.3066 17.2555C43.4673 16.9805 43.5977 16.7229 43.6978 16.4825C43.798 16.2421 43.8826 16.0139 43.9517 15.7977C44.0363 15.5695 44.0932 15.3378 44.1225 15.1026C44.1656 14.8692 44.2035 14.6211 44.2363 14.3583ZM47.4736 15.7306C47.3267 15.7826 47.1858 15.8423 47.051 15.9098C46.9317 15.9651 46.8124 16.0205 46.6932 16.0759C46.5756 16.1175 46.4598 16.1452 46.3457 16.1591C46.2316 16.1729 46.114 16.1583 45.993 16.1151C45.91 16.1048 45.8469 16.0478 45.8036 15.9441C45.762 15.8265 45.7352 15.7038 45.723 15.5758C45.6988 15.4324 45.6875 15.2975 45.6891 15.1713C45.6925 15.0313 45.7054 14.9275 45.7279 14.8601L47.8618 13.967L48.6477 8.67099C48.6977 8.49462 48.817 8.43924 49.0055 8.50485C49.1957 8.55662 49.3911 8.62309 49.5917 8.70426C49.6193 8.7077 49.6591 8.7267 49.711 8.76125C49.7784 8.7837 49.8251 8.80356 49.851 8.82083C49.7769 9.19085 49.6915 9.59459 49.5949 10.032C49.5138 10.4574 49.4319 10.8897 49.3491 11.3288C49.2681 11.7542 49.1948 12.1735 49.1293 12.5867C49.0776 13.0017 49.0518 13.3777 49.052 13.7149L52.2727 13.231C52.3298 13.224 52.3661 13.2707 52.3817 13.371C52.4129 13.4591 52.4345 13.5672 52.4467 13.6951C52.4727 13.8248 52.4848 13.9527 52.4832 14.0789C52.4815 14.2051 52.4807 14.2682 52.4807 14.2682L48.7675 15.3229C48.752 15.4473 48.7219 15.7456 48.6772 16.2176C48.6463 16.6913 48.6042 17.255 48.5509 17.9085C48.4993 18.5482 48.4409 19.2433 48.3755 19.9937C48.3119 20.7302 48.2543 21.4183 48.2027 22.058C48.1512 22.6978 48.1022 23.2605 48.0557 23.7464C48.011 24.2184 47.9809 24.5166 47.9654 24.6411C47.886 25.0526 47.7357 25.2446 47.5144 25.2171C47.3069 25.1912 47.0916 25.0591 46.8685 24.8206L47.4736 15.7306ZM51.6871 24.8307C51.7991 23.9316 51.8963 22.9815 51.9788 21.9804C52.0752 20.9811 52.1655 19.974 52.2497 18.9591C52.3495 17.932 52.4674 16.9284 52.6036 15.948C52.7397 14.9677 52.9165 14.0556 53.1339 13.2118C53.1633 13.2014 53.2264 13.2022 53.3232 13.2143C53.4356 13.2142 53.5125 13.2168 53.554 13.222C53.7477 13.2461 53.8955 13.2996 53.9976 13.3825C54.1152 13.4534 54.161 13.5925 54.1352 13.8C54.0336 14.6161 53.9156 15.5074 53.7812 16.4739C53.6623 17.4283 53.534 18.4026 53.3962 19.3968C53.2739 20.3789 53.1524 21.354 53.0319 22.3223C52.9113 23.2905 52.8158 24.1705 52.7453 24.9624C52.7298 25.1993 52.6624 25.3454 52.5432 25.4008C52.436 25.4717 52.3064 25.4977 52.1542 25.4788C51.9882 25.4581 51.8551 25.3994 51.7548 25.3026C51.6527 25.2197 51.6302 25.0623 51.6871 24.8307ZM53.0805 9.91827C53.1011 9.75228 53.1703 9.64852 53.2878 9.60697C53.4053 9.56542 53.5333 9.55326 53.6716 9.57048C53.9482 9.60493 54.1099 9.71636 54.1567 9.90479C54.2035 10.0932 54.2122 10.305 54.1829 10.5401C54.081 10.682 53.9635 10.7797 53.8304 10.8334C53.699 10.8732 53.5659 10.8707 53.431 10.8258C53.3117 10.7688 53.2122 10.6651 53.1326 10.5147C53.0669 10.3661 53.0495 10.1672 53.0805 9.91827ZM54.6997 17.0097C54.7014 16.9958 54.6971 16.9742 54.6867 16.9448C54.6919 16.9034 54.6953 16.8757 54.697 16.8619C54.7229 16.6544 54.8205 16.5471 54.9899 16.5401C55.1611 16.5193 55.3158 16.5175 55.4541 16.5347C55.6063 16.5537 55.7628 16.7066 55.9237 16.9935C56.0864 17.2666 56.2586 17.6322 56.4403 18.0903C56.6376 18.5362 56.8298 19.0237 57.0167 19.5527C57.2175 20.0833 57.4192 20.6071 57.6217 21.1239C57.8398 21.6287 58.0631 22.0919 58.2915 22.5136C58.5337 22.9371 58.775 23.2551 59.0155 23.4677C59.2552 22.2193 59.4509 21.1551 59.6026 20.275C59.7544 19.3949 59.875 18.6514 59.9647 18.0445C60.0681 17.4394 60.1414 16.9639 60.1844 16.6181C60.2292 16.2585 60.2567 15.981 60.267 15.7856C60.2911 15.5919 60.2997 15.4666 60.2928 15.4095C60.3014 15.3404 60.3074 15.292 60.3109 15.2643C60.3419 15.0153 60.4023 14.8683 60.4922 14.8233C60.5959 14.7801 60.7238 14.7679 60.876 14.7869C61.0558 14.8093 61.2391 14.8602 61.4258 14.9396C61.6126 15.019 61.6922 15.1694 61.6646 15.3907C61.5942 16.295 61.4805 17.2079 61.3236 18.1295C61.1823 19.0389 61.0202 19.9458 60.8373 20.8501C60.6562 21.7406 60.4907 22.6189 60.3407 23.4852C60.1907 24.3514 60.0856 25.1952 60.0255 26.0164C59.9944 26.0407 59.9278 26.0675 59.8258 26.0969C59.7256 26.1125 59.6184 26.1273 59.5043 26.1412C59.3902 26.1551 59.2769 26.162 59.1646 26.1621C59.066 26.1638 58.996 26.1622 58.9545 26.157C58.8196 26.1121 58.6285 25.8987 58.3811 25.5167C58.1354 25.1209 57.8663 24.6309 57.5738 24.0467C57.2814 23.4624 56.9828 22.8142 56.6782 22.1021C56.3736 21.3899 56.0802 20.7002 55.7981 20.033C55.5298 19.3675 55.2961 18.7625 55.097 18.218C54.898 17.6735 54.7655 17.2707 54.6997 17.0097ZM62.3915 22.0339C62.3206 22.0391 62.2143 22.047 62.0726 22.0574C61.9308 22.0678 61.7847 22.0567 61.6343 22.0239C61.4838 21.9911 61.3576 21.9333 61.2556 21.8503C61.1397 21.7657 61.0921 21.6403 61.1127 21.4744C61.1248 21.3775 61.1542 21.311 61.2008 21.2746C61.2475 21.2383 61.3244 21.1847 61.4316 21.1137C61.7669 20.9027 62.0624 20.6164 62.3181 20.2549C62.5893 19.8813 62.8424 19.4844 63.0774 19.0642C63.314 18.6302 63.5567 18.2039 63.8055 17.7854C64.0698 17.3547 64.3558 16.976 64.6633 16.6491C64.9709 16.3222 65.3322 16.0722 65.747 15.8991C66.1619 15.726 66.652 15.6817 67.2174 15.7661C67.4525 15.7954 67.7084 15.8835 67.9851 16.0303C68.2618 16.1771 68.5126 16.3628 68.7375 16.5875C68.964 16.7983 69.144 17.0455 69.2772 17.3289C69.4105 17.6124 69.4573 17.9132 69.4177 18.2314C69.4731 18.3506 69.3841 18.5011 69.1508 18.6827C68.9313 18.8661 68.6332 19.0607 68.2564 19.2666C67.8813 19.4587 67.4561 19.6586 66.9807 19.8663C66.5209 20.0619 66.0767 20.2454 65.648 20.4167C65.2193 20.5881 64.8425 20.7378 64.5175 20.8659C64.1925 20.994 63.9765 21.0935 63.8693 21.1645C63.7829 21.2942 63.7078 21.4463 63.6439 21.621C63.58 21.7956 63.5239 21.9642 63.4756 22.1268C63.4428 22.2772 63.4109 22.4207 63.3798 22.5573C63.3643 22.6818 63.3523 22.7786 63.3437 22.8478C63.3109 23.1106 63.2609 23.3993 63.1937 23.714C63.1402 24.0304 63.1162 24.3365 63.1215 24.6321C63.1424 24.9156 63.2307 25.1654 63.3864 25.3815C63.5438 25.5837 63.8369 25.7115 64.2657 25.7649C64.7221 25.8217 65.1647 25.7644 65.5934 25.5931C66.0238 25.4079 66.4326 25.1708 66.8197 24.8819C67.2068 24.593 67.5628 24.2721 67.8877 23.9193C68.2264 23.5682 68.5271 23.2404 68.7897 22.936C69.0679 22.6195 69.3107 22.3617 69.5181 22.1628C69.7255 21.9639 69.8914 21.8722 70.0159 21.8877C70.1542 21.9049 70.296 21.9507 70.4413 22.0249C70.6021 22.0871 70.6713 22.2081 70.6489 22.3879C70.6179 22.6369 70.4771 22.9214 70.2266 23.2413C69.9899 23.563 69.6814 23.8968 69.3012 24.2428C68.9349 24.5905 68.5132 24.9313 68.0362 25.2652C67.5747 25.5869 67.1106 25.8733 66.6439 26.1242C66.179 26.3613 65.727 26.5508 65.2879 26.6928C64.8505 26.8209 64.4728 26.8652 64.1547 26.8256C63.5322 26.7481 63.0809 26.5374 62.8006 26.1934C62.5204 25.8495 62.3395 25.4407 62.2581 24.9671C62.1904 24.4951 62.1815 24.0024 62.2314 23.4889C62.2969 22.9632 62.3502 22.4783 62.3915 22.0339ZM66.9067 16.9073C66.6716 16.8781 66.408 16.9646 66.1159 17.167C65.8255 17.3556 65.5421 17.6013 65.2656 17.904C65.0047 18.1945 64.7766 18.5033 64.5814 18.8301C64.4017 19.1448 64.2981 19.4129 64.2706 19.6342C64.478 19.66 64.7849 19.621 65.1912 19.5171C65.6129 19.401 66.0321 19.2495 66.4487 19.0626C66.8653 18.8757 67.2352 18.6689 67.5584 18.4423C67.8816 18.2157 68.0578 17.9848 68.0871 17.7496C68.1026 17.6251 68.0671 17.5154 67.9806 17.4203C67.8941 17.3253 67.7852 17.2415 67.6537 17.1689C67.5361 17.0981 67.4099 17.0402 67.275 16.9953C67.1401 16.9505 67.0174 16.9211 66.9067 16.9073ZM81.3452 24.394C81.2743 24.3993 81.168 24.4071 81.0262 24.4175C80.8845 24.428 80.7384 24.4168 80.5879 24.384C80.4375 24.3513 80.3113 24.2934 80.2092 24.2105C80.0934 24.1258 80.0458 24.0005 80.0664 23.8345C80.0785 23.7377 80.1078 23.6711 80.1545 23.6348C80.2012 23.5984 80.2781 23.5448 80.3852 23.4739C80.7205 23.2628 81.016 22.9765 81.2718 22.6151C81.543 22.2415 81.7961 21.8446 82.031 21.4243C82.2677 20.9903 82.5104 20.564 82.7592 20.1455C83.0235 19.7149 83.3094 19.3361 83.617 19.0092C83.9246 18.6823 84.2858 18.4323 84.7007 18.2592C85.1155 18.0861 85.6057 18.0418 86.1711 18.1263C86.4062 18.1555 86.6621 18.2436 86.9388 18.3904C87.2155 18.5372 87.4663 18.723 87.6911 18.9476C87.9177 19.1584 88.0977 19.4056 88.2309 19.6891C88.3642 19.9725 88.411 20.2734 88.3714 20.5915C88.4268 20.7108 88.3378 20.8612 88.1045 21.0429C87.885 21.2262 87.5868 21.4209 87.21 21.6268C86.835 21.8189 86.4098 22.0188 85.9344 22.2264C85.4746 22.422 85.0304 22.6055 84.6017 22.7769C84.173 22.9482 83.7962 23.098 83.4712 23.226C83.1462 23.3541 82.9302 23.4536 82.823 23.5246C82.7366 23.6543 82.6615 23.8065 82.5976 23.9811C82.5337 24.1558 82.4776 24.3244 82.4293 24.4869C82.3965 24.6373 82.3646 24.7808 82.3335 24.9174C82.318 25.0419 82.306 25.1388 82.2973 25.2079C82.2646 25.4707 82.2146 25.7595 82.1473 26.0742C82.0939 26.3906 82.0698 26.6966 82.0752 26.9922C82.096 27.2758 82.1843 27.5255 82.34 27.7416C82.4975 27.9438 82.7906 28.0716 83.2194 28.125C83.6758 28.1818 84.1184 28.1246 84.5471 27.9532C84.9775 27.768 85.3863 27.531 85.7734 27.242C86.1605 26.9531 86.5165 26.6323 86.8414 26.2794C87.1801 25.9283 87.4808 25.6005 87.7434 25.2961C88.0216 24.9796 88.2644 24.7219 88.4718 24.5229C88.6792 24.324 88.8451 24.2323 88.9696 24.2478C89.1079 24.265 89.2497 24.3108 89.3949 24.3851C89.5558 24.4472 89.625 24.5682 89.6026 24.748C89.5716 24.997 89.4308 25.2815 89.1803 25.6014C88.9436 25.9231 88.6351 26.257 88.2549 26.6029C87.8886 26.9506 87.4669 27.2914 86.9898 27.6253C86.5284 27.9471 86.0643 28.2334 85.5976 28.4843C85.1327 28.7214 84.6807 28.9109 84.2416 29.0529C83.8042 29.1811 83.4265 29.2253 83.1083 29.1857C82.4859 29.1082 82.0346 28.8975 81.7543 28.5536C81.4741 28.2097 81.2932 27.8009 81.2117 27.3272C81.1441 26.8552 81.1352 26.3625 81.1851 25.849C81.2506 25.3234 81.3039 24.8384 81.3452 24.394ZM85.8604 19.2675C85.6253 19.2382 85.3616 19.3248 85.0695 19.5272C84.7792 19.7158 84.4958 19.9614 84.2193 20.2641C83.9584 20.5547 83.7303 20.8634 83.5351 21.1902C83.3554 21.505 83.2518 21.773 83.2243 21.9943C83.4317 22.0202 83.7386 21.9811 84.1448 21.8772C84.5666 21.7612 84.9858 21.6097 85.4024 21.4228C85.819 21.2358 86.1889 21.0291 86.512 20.8024C86.8352 20.5758 87.0115 20.3449 87.0408 20.1098C87.0563 19.9853 87.0208 19.8755 86.9343 19.7804C86.8478 19.6854 86.7388 19.6016 86.6074 19.529C86.4898 19.4582 86.3636 19.4004 86.2287 19.3555C86.0938 19.3106 85.9711 19.2813 85.8604 19.2675ZM92.6558 31.6598C92.4381 31.8294 92.2401 31.896 92.062 31.8598C91.8978 31.8253 91.7681 31.7389 91.6729 31.6006C91.5916 31.4641 91.5431 31.2895 91.5274 31.0769C91.5256 30.8659 91.5929 30.6636 91.7294 30.4699L93.7523 25.0541C93.5516 24.7481 93.2852 24.4059 92.9531 24.0275C92.6348 23.6507 92.3173 23.2671 92.0008 22.8765C91.698 22.4876 91.4229 22.1022 91.1755 21.7202C90.9298 21.3244 90.7922 20.9632 90.7627 20.6364C90.8075 20.2768 91.0166 20.1202 91.39 20.1667C91.6304 20.1545 91.8145 20.1985 91.9425 20.2987C92.0843 20.4007 92.2002 20.5415 92.2902 20.7213C92.3819 20.8872 92.4684 21.0946 92.5498 21.3436C92.645 21.5942 92.7601 21.8543 92.8951 22.124C93.0439 22.3954 93.2334 22.6788 93.4634 22.9743C93.7091 23.2578 94.0334 23.5299 94.4363 23.7908C94.5486 23.566 94.6712 23.202 94.8041 22.6988C94.9387 22.1818 95.0629 21.6354 95.1767 21.0596C95.3061 20.4718 95.4208 19.8891 95.5208 19.3116C95.6208 18.7341 95.6941 18.2586 95.7406 17.8851C95.789 17.835 95.8771 17.8038 96.0051 17.7916C96.1486 17.7674 96.2955 17.7716 96.4459 17.8044C96.5981 17.8233 96.733 17.8682 96.8506 17.9391C96.9699 17.9961 97.0374 18.0747 97.053 18.175C97.0481 18.7783 96.961 19.3645 96.7919 19.9334C96.6383 20.4901 96.4561 21.0504 96.2455 21.6141C96.0504 22.1657 95.8622 22.7182 95.6809 23.2715C95.4996 23.8249 95.4005 24.3954 95.3835 24.9833L98.6141 29.157C98.6263 29.1726 98.6401 29.2305 98.6557 29.3308C98.6713 29.431 98.6766 29.5019 98.6714 29.5434C98.6611 29.6264 98.6438 29.7085 98.6196 29.7898C98.5955 29.8711 98.5506 29.9498 98.4849 30.0259C98.4348 30.0899 98.3657 30.1374 98.2775 30.1686C98.2032 30.2015 98.1046 30.2033 97.9819 30.1739C97.8262 29.9579 97.6272 29.6943 97.385 29.3832C97.1584 29.06 96.9049 28.7265 96.6247 28.3826C96.3462 28.0248 96.059 27.68 95.7632 27.3482C95.4674 27.0164 95.1777 26.7486 94.8941 26.5447L94.7903 26.5318L94.7722 26.5084C94.703 26.4998 94.6356 26.5336 94.5699 26.6097C94.506 26.672 94.4032 26.8769 94.2616 27.2245C94.1356 27.5599 93.9448 28.0769 93.6892 28.7755C93.4492 29.462 93.1048 30.4235 92.6558 31.6598ZM105.182 31.3654C105.157 30.9972 105.149 30.5607 105.155 30.0558C105.177 29.5389 105.193 29.021 105.201 28.5024C105.211 27.9699 105.203 27.4702 105.177 27.0034C105.165 26.5384 105.101 26.1511 104.985 25.8417C104.1 27.1924 103.336 28.2491 102.694 29.0119C102.053 29.7608 101.502 30.2892 101.042 30.5972C100.598 30.893 100.239 31.0168 99.9637 30.9685C99.6888 30.9202 99.4761 30.7673 99.3256 30.5098C99.175 30.2523 99.0807 29.9385 99.0424 29.5686C99.0198 29.1865 99.0144 28.8346 99.0264 28.5131C99.0643 28.2088 99.1868 27.7886 99.394 27.2525C99.6013 26.7165 99.8629 26.138 100.179 25.5172C100.497 24.8826 100.857 24.2462 101.26 23.608C101.676 22.9716 102.105 22.4 102.548 21.8932C102.99 21.3864 103.434 20.9782 103.88 20.6685C104.326 20.3588 104.749 20.229 105.151 20.2789C105.757 20.2561 106.177 20.4418 106.409 20.8359C106.656 21.2179 106.638 21.8126 106.355 22.6201C106.241 23.533 106.179 24.3189 106.167 24.9776C106.169 25.638 106.174 26.2708 106.183 26.8759C106.206 27.4827 106.211 28.1155 106.2 28.7742C106.202 29.4346 106.146 30.2213 106.032 31.1342C106.012 31.3002 105.973 31.4429 105.916 31.5622C105.874 31.6694 105.701 31.7041 105.397 31.6662C105.356 31.661 105.305 31.6195 105.244 31.5418C105.197 31.4657 105.177 31.4069 105.182 31.3654ZM105.216 21.9516C105.092 21.7113 104.887 21.6647 104.602 21.8118C104.316 21.9589 104.003 22.2219 103.66 22.6007C103.318 22.9794 102.959 23.4404 102.582 23.9834C102.206 24.5265 101.849 25.079 101.512 25.6411C101.175 26.2031 100.876 26.7418 100.616 27.2571C100.356 27.7586 100.171 28.178 100.059 28.5152C99.9965 29.0131 100.037 29.3062 100.181 29.3943C100.326 29.4685 100.523 29.4088 100.772 29.215C101.021 29.0213 101.31 28.7342 101.638 28.3536C101.98 27.9749 102.312 27.5667 102.633 27.1291C102.968 26.6933 103.281 26.2687 103.571 25.8553C103.875 25.4437 104.114 25.1082 104.287 24.8488C104.447 24.5738 104.578 24.3161 104.678 24.0758C104.778 23.8354 104.863 23.6072 104.932 23.391C105.016 23.1628 105.073 22.9311 105.102 22.6959C105.146 22.4625 105.183 22.2144 105.216 21.9516ZM107.628 32.1546C107.635 31.7622 107.665 31.2322 107.72 30.5649C107.775 29.8975 107.837 29.1748 107.906 28.3967C107.977 27.6049 108.044 26.7845 108.107 25.9356C108.185 25.0884 108.25 24.2818 108.303 23.5159C108.356 22.75 108.387 22.0515 108.396 21.4204C108.418 20.7911 108.418 20.2854 108.395 19.9033C108.429 19.6267 108.511 19.4754 108.641 19.4494C108.772 19.4095 108.935 19.4017 109.129 19.4258C109.156 19.4292 109.218 19.437 109.315 19.449C109.412 19.4611 109.48 19.4766 109.52 19.4956C109.593 19.9261 109.602 20.475 109.547 21.1424C109.507 21.7977 109.446 22.5134 109.364 23.2898C109.295 24.0678 109.216 24.8726 109.126 25.7043C109.051 26.5376 109.001 27.3321 108.977 28.0876C109.307 27.019 109.579 26.1328 109.793 25.4291C110.021 24.727 110.217 24.1685 110.381 23.7535C110.56 23.3264 110.711 23.0151 110.834 22.8197C110.972 22.6121 111.108 22.4815 111.241 22.4279C111.388 22.376 111.537 22.3664 111.687 22.3991C111.853 22.4198 112.047 22.4439 112.268 22.4715C112.517 22.5025 112.705 22.6243 112.833 22.8369C112.975 23.0512 113.069 23.3157 113.114 23.6303C113.173 23.9467 113.201 24.2873 113.197 24.6521C113.208 25.0186 113.212 25.3773 113.211 25.7283C113.211 26.0654 113.215 26.3749 113.222 26.6567C113.243 26.9402 113.301 27.1442 113.398 27.2686C113.872 26.2881 114.273 25.4883 114.603 24.8692C114.933 24.2501 115.211 23.765 115.437 23.414C115.666 23.0491 115.859 22.7922 116.018 22.6435C116.177 22.4947 116.314 22.4134 116.428 22.3995C116.543 22.3718 116.641 22.3769 116.721 22.4149C116.814 22.4546 116.909 22.4805 117.006 22.4926C117.379 22.5391 117.639 22.7681 117.784 23.1795C117.928 23.8295 118.006 24.4432 118.019 25.0206C118.033 25.5842 118.014 26.1297 117.962 26.6571C117.912 27.1706 117.851 27.6616 117.779 28.1302C117.72 28.6004 117.677 29.0586 117.65 29.5047C117.636 29.9525 117.658 30.3977 117.715 30.8402C117.786 31.2845 117.941 31.7322 118.18 32.1834C118.042 32.3909 117.912 32.5293 117.791 32.5985C117.672 32.6539 117.516 32.6695 117.322 32.6454C117.156 32.6247 117.018 32.5513 116.907 32.4251C116.798 32.2852 116.712 32.127 116.65 31.9507C116.589 31.7605 116.543 31.5721 116.51 31.3854C116.491 31.2004 116.469 31.0362 116.445 30.8927C116.636 28.9078 116.734 27.382 116.741 26.3153C116.763 25.2365 116.66 24.6547 116.431 24.5701C116.203 24.4855 115.841 24.911 115.345 25.8466C114.865 26.77 114.226 28.2356 113.428 30.2432C113.378 30.3072 113.311 30.3409 113.226 30.3444C113.141 30.3479 113.051 30.3436 112.954 30.3316C112.871 30.3213 112.781 30.3101 112.684 30.298C112.603 30.2738 112.52 30.2635 112.435 30.267C112.342 28.1906 112.234 26.6952 112.109 25.7807C111.999 24.854 111.814 24.4798 111.553 24.658C111.292 24.8362 110.936 25.5504 110.486 26.8006C110.037 28.037 109.44 29.7817 108.696 32.0348L107.628 32.1546ZM118.264 39.0836C118.597 37.6502 118.852 36.2773 119.03 34.965C119.219 33.6682 119.373 32.381 119.49 31.1033C119.62 29.8273 119.732 28.5349 119.825 27.2261C119.918 25.9173 120.047 24.5358 120.214 23.0817C120.28 22.8933 120.347 22.7541 120.414 22.6641C120.497 22.5621 120.673 22.5559 120.943 22.6457C121.225 22.751 121.377 22.9386 121.4 23.2083C121.424 23.4641 121.403 23.7494 121.335 24.0641C121.268 24.3788 121.187 24.6917 121.092 25.003C120.997 25.3142 120.965 25.5701 120.996 25.7707C121.479 25.5076 121.99 25.2342 122.531 24.9504C123.072 24.6667 123.629 24.4269 124.201 24.2313C124.775 24.0218 125.36 23.891 125.956 23.8389C126.555 23.7729 127.136 23.8383 127.702 24.0352C128.4 24.2907 128.867 24.6017 129.103 24.9681C129.354 25.3224 129.418 25.7096 129.295 26.1298C129.188 26.5379 128.937 26.9772 128.541 27.4476C128.147 27.9042 127.676 28.3583 127.128 28.8098C126.581 29.2613 125.978 29.699 125.321 30.1229C124.665 30.5467 124.026 30.9378 123.406 31.2959C122.787 31.6403 122.209 31.9405 121.671 32.1967C121.147 32.4545 120.731 32.6414 120.421 32.7574C120.387 32.9217 120.333 33.1819 120.261 33.5381C120.204 33.8822 120.134 34.2738 120.051 34.713C119.982 35.1539 119.904 35.6147 119.816 36.0953C119.742 36.5777 119.663 37.0385 119.581 37.4777C119.512 37.9186 119.442 38.3102 119.371 38.6526C119.314 38.9967 119.276 39.2517 119.255 39.4177C119.225 39.4281 119.175 39.4359 119.104 39.4411C119.034 39.4463 118.95 39.4429 118.853 39.4308C118.754 39.4326 118.664 39.4283 118.581 39.418C118.496 39.4215 118.441 39.4146 118.415 39.3973C118.373 39.3921 118.337 39.3455 118.306 39.2573C118.273 39.183 118.259 39.1251 118.264 39.0836ZM120.842 27.8584C120.776 28.0469 120.732 28.2872 120.71 28.5794C120.703 28.8595 120.694 29.1603 120.682 29.4819C120.685 29.7914 120.69 30.0939 120.695 30.3896C120.7 30.6852 120.697 30.9376 120.685 31.1468C121.261 30.8111 121.92 30.4789 122.663 30.15C123.42 29.8229 124.154 29.4578 124.865 29.0546C125.589 28.6532 126.244 28.1869 126.83 27.6559C127.415 27.1248 127.838 26.4962 128.097 25.7699C128.188 25.4863 128.185 25.2892 128.086 25.1786C128.003 25.0559 127.84 24.9583 127.596 24.8858C127.084 24.7097 126.477 24.6763 125.775 24.7855C125.075 24.881 124.385 25.0689 123.704 25.3493C123.036 25.6314 122.437 25.9922 121.904 26.4315C121.372 26.8709 121.018 27.3465 120.842 27.8584ZM129.486 33.8651C129.662 33.2408 129.823 32.4533 129.97 31.5023C130.13 30.5531 130.27 29.5381 130.391 28.4575C130.525 27.3786 130.643 26.2626 130.745 25.1093C130.846 23.9561 130.926 22.8634 130.984 21.8312C131.044 20.7852 131.077 19.8481 131.081 19.02C131.1 18.1936 131.09 17.5392 131.052 17.0569C131.187 16.9894 131.298 16.94 131.386 16.9089C131.49 16.8656 131.604 16.8517 131.729 16.8672C131.826 16.8793 131.906 16.9104 131.97 16.9605C132.036 16.9967 132.082 17.0728 132.11 17.1886C132.049 19.9341 131.896 22.6892 131.65 25.4538C131.418 28.2202 131.16 30.9692 130.876 33.701C130.86 33.8255 130.839 33.9984 130.811 34.2197C130.785 34.4272 130.765 34.537 130.749 34.5491C130.543 34.6218 130.364 34.6487 130.212 34.6297C130.062 34.597 129.929 34.5383 129.813 34.4536C129.699 34.3551 129.613 34.2531 129.556 34.1477C129.499 34.0423 129.475 33.948 129.486 33.8651ZM132.791 30.8001C132.72 30.8054 132.614 30.8132 132.472 30.8236C132.33 30.8341 132.184 30.8229 132.034 30.7901C131.883 30.7573 131.757 30.6995 131.655 30.6165C131.539 30.5319 131.492 30.4066 131.512 30.2406C131.524 30.1438 131.554 30.0772 131.6 30.0408C131.647 30.0045 131.724 29.9509 131.831 29.88C132.166 29.6689 132.462 29.3826 132.718 29.0211C132.989 28.6476 133.242 28.2507 133.477 27.8304C133.714 27.3964 133.956 26.9701 134.205 26.5516C134.469 26.121 134.755 25.7422 135.063 25.4153C135.37 25.0884 135.732 24.8384 136.147 24.6653C136.561 24.4922 137.052 24.4479 137.617 24.5323C137.852 24.5616 138.108 24.6497 138.385 24.7965C138.661 24.9433 138.912 25.1291 139.137 25.3537C139.364 25.5645 139.543 25.8117 139.677 26.0952C139.81 26.3786 139.857 26.6794 139.817 26.9976C139.873 27.1168 139.784 27.2673 139.55 27.4489C139.331 27.6323 139.033 27.8269 138.656 28.0329C138.281 28.2249 137.856 28.4248 137.38 28.6325C136.92 28.8281 136.476 29.0116 136.048 29.1829C135.619 29.3543 135.242 29.504 134.917 29.6321C134.592 29.7602 134.376 29.8597 134.269 29.9307C134.182 30.0604 134.107 30.2126 134.043 30.3872C133.98 30.5619 133.923 30.7304 133.875 30.893C133.842 31.0434 133.81 31.1869 133.779 31.3235C133.764 31.448 133.752 31.5448 133.743 31.614C133.71 31.8768 133.66 32.1656 133.593 32.4802C133.54 32.7967 133.516 33.1027 133.521 33.3983C133.542 33.6819 133.63 33.9316 133.786 34.1477C133.943 34.3499 134.236 34.4777 134.665 34.5311C135.122 34.5879 135.564 34.5306 135.993 34.3593C136.423 34.1741 136.832 33.937 137.219 33.6481C137.606 33.3592 137.962 33.0383 138.287 32.6855C138.626 32.3344 138.927 32.0066 139.189 31.7022C139.467 31.3857 139.71 31.128 139.918 30.929C140.125 30.7301 140.291 30.6384 140.415 30.6539C140.554 30.6711 140.696 30.7169 140.841 30.7912C141.002 30.8533 141.071 30.9743 141.048 31.1541C141.017 31.4031 140.877 31.6876 140.626 32.0075C140.389 32.3292 140.081 32.663 139.701 33.009C139.334 33.3567 138.913 33.6975 138.436 34.0314C137.974 34.3532 137.51 34.6395 137.043 34.8904C136.579 35.1275 136.126 35.317 135.687 35.459C135.25 35.5872 134.872 35.6314 134.554 35.5918C133.932 35.5143 133.48 35.3036 133.2 34.9597C132.92 34.6157 132.739 34.2069 132.658 33.7333C132.59 33.2613 132.581 32.7686 132.631 32.2551C132.696 31.7295 132.75 31.2445 132.791 30.8001ZM137.306 25.6736C137.071 25.6443 136.807 25.7308 136.515 25.9333C136.225 26.1219 135.942 26.3675 135.665 26.6702C135.404 26.9608 135.176 27.2695 134.981 27.5963C134.801 27.9111 134.698 28.1791 134.67 28.4004C134.878 28.4262 135.184 28.3872 135.591 28.2833C136.012 28.1672 136.432 28.0158 136.848 27.8288C137.265 27.6419 137.635 27.4351 137.958 27.2085C138.281 26.9819 138.457 26.751 138.487 26.5158C138.502 26.3914 138.467 26.2816 138.38 26.1865C138.294 26.0915 138.185 26.0077 138.053 25.9351C137.936 25.8643 137.809 25.8064 137.675 25.7616C137.54 25.7167 137.417 25.6873 137.306 25.6736Z"
                fill={theme.textSubdued}
            />
        </svg>
    );
};
