import { CryptoId, ExchangeTrade } from 'invity-api';

import { ExchangeInfo } from 'src/actions/wallet/coinmarketExchangeActions';

const litecoin = 'litecoin' as CryptoId;
const bitcoin = 'bitcoin' as CryptoId;
const ethereum = 'ethereum' as CryptoId;
const cronoseth = 'ethereum__0xa0b73e1ff0b80914ab6fe0444e65848c4c34450b' as CryptoId;

const tickers1 = [ethereum, 'monero', bitcoin] as CryptoId[];
const tickers2 = [ethereum, bitcoin] as CryptoId[];
const tickers3 = [bitcoin] as CryptoId[];
const tickers4 = [ethereum] as CryptoId[];
const tickers5 = [cronoseth] as CryptoId[];

export const EXCHANGE_INFO: ExchangeInfo = {
    exchangeList: [
        {
            name: 'changenow',
            companyName: 'ChangeNOW',
            logo: 'changenow-icon.jpg',
            isActive: true,
            isFixedRate: false,
            isDex: false,
            buyTickers: tickers1,
            sellTickers: tickers1,
            addressFormats: {
                BCH: 'legacy',
                LTC: 'type3',
            },
            statusUrl: 'https://changenow.io/exchange/txs/{{orderId}}',
            kycUrl: 'https://changenow.io/faq#kyc',
            supportUrl: 'https://support.changenow.io',
            kycPolicy: 'KYC requested in exceptional cases. KYC not required for refunds. 🤝',
            kycPolicyType: 'KYC-yesrefund',
            isRefundRequired: false,
        },
        {
            name: 'changenowfr',
            companyName: 'ChangeNOW',
            logo: 'changenowfr-icon.jpg',
            isActive: true,
            isFixedRate: true,
            isDex: false,
            buyTickers: tickers2,
            sellTickers: tickers2,
            addressFormats: {
                BCH: 'legacy',
                LTC: 'type3',
            },
            statusUrl: 'https://changenow.io/exchange/txs/{{orderId}}',
            kycUrl: 'https://changenow.io/faq#kyc',
            supportUrl: 'https://support.changenow.io',
            kycPolicy: 'KYC requested in exceptional cases. KYC not required for refunds. 🤝',
            kycPolicyType: 'KYC-yesrefund',
            isRefundRequired: false,
        },
        {
            name: 'changelly',
            companyName: 'Changelly',
            logo: 'changelly-icon.jpg',
            isActive: true,
            isFixedRate: false,
            isDex: false,
            buyTickers: tickers2,
            sellTickers: tickers2,
            addressFormats: {
                BCH: 'cashaddr',
                LTC: 'type3',
            },
            statusUrl: '',
            kycUrl: 'https://changelly.com/aml-kyc',
            supportUrl: 'https://support.changelly.com',
            kycPolicy: 'KYC requested in exceptional cases. KYC required for refunds. 👈',
            kycPolicyType: 'KYC-norefund',
            isRefundRequired: false,
        },
        {
            name: 'changellyfr',
            companyName: 'Changelly',
            logo: 'changellyfr-icon.jpg',
            isActive: true,
            isFixedRate: true,
            isDex: false,
            buyTickers: tickers2,
            sellTickers: tickers2,
            addressFormats: {
                BCH: 'cashaddr',
                LTC: 'type3',
            },
            statusUrl: '',
            kycUrl: 'https://changelly.com/aml-kyc',
            supportUrl: 'https://support.changelly.com',
            kycPolicy: 'KYC requested in exceptional cases. KYC required for refunds. 👈',
            kycPolicyType: 'KYC-norefund',
            isRefundRequired: true,
        },
        {
            name: 'changehero',
            companyName: 'ChangeHero',
            logo: 'changehero-icon.jpg',
            isActive: true,
            isFixedRate: false,
            isDex: false,
            buyTickers: tickers3,
            sellTickers: tickers3,
            addressFormats: {
                BCH: 'legacy',
                LTC: 'type3',
            },
            statusUrl: '',
            kycUrl: 'https://changehero.io/aml-kyc',
            supportUrl: 'https://support.changehero.io',
            kycPolicy: 'KYC requested in exceptional cases. KYC required for refunds. 👈',
            kycPolicyType: 'KYC-norefund',
            isRefundRequired: false,
        },
        {
            name: 'changeherofr',
            companyName: 'ChangeHero',
            logo: 'changeherofr-icon.jpg',
            isActive: true,
            isFixedRate: true,
            isDex: false,
            buyTickers: tickers3,
            sellTickers: tickers3,
            addressFormats: {
                BCH: 'legacy',
                LTC: 'type3',
            },
            statusUrl: '',
            kycUrl: 'https://changehero.io/aml-kyc',
            supportUrl: 'https://support.changehero.io',
            kycPolicy: 'KYC requested in exceptional cases. KYC required for refunds. 👈',
            kycPolicyType: 'KYC-norefund',
            isRefundRequired: true,
        },
        {
            name: 'foxexchange',
            companyName: 'FoxExchange',
            logo: 'foxexchange-icon.jpg',
            isActive: true,
            isFixedRate: false,
            isDex: false,
            buyTickers: tickers3,
            sellTickers: tickers3,
            addressFormats: {
                BCH: 'cashaddr',
                LTC: 'type3',
            },
            statusUrl: 'https://fox.exchange/tx/{{orderId}}',
            kycUrl: 'https://fox.exchange',
            supportUrl: 'https://fox.exchange',
            kycPolicy: 'KYC never required. Exceptional cases automatically refunded. 👍',
            kycPolicyType: 'noKYC',
            isRefundRequired: false,
        },
        {
            name: 'foxexchangefr',
            companyName: 'FoxExchange',
            logo: 'foxexchange-icon.jpg',
            isActive: true,
            isFixedRate: true,
            isDex: false,
            buyTickers: tickers3,
            sellTickers: tickers2,
            addressFormats: {
                BCH: 'cashaddr',
                LTC: 'type3',
            },
            statusUrl: 'https://fox.exchange/tx/{{orderId}}',
            kycUrl: 'https://fox.exchange',
            supportUrl: 'https://fox.exchange',
            kycPolicy: 'KYC never required. Exceptional cases automatically refunded. 👍',
            kycPolicyType: 'noKYC',
            isRefundRequired: false,
        },
        {
            name: 'coinswitch',
            companyName: 'CoinSwitch',
            logo: 'coinswitch-icon.jpg',
            isActive: true,
            isFixedRate: false,
            isDex: false,
            buyTickers: tickers4,
            sellTickers: tickers4,
            addressFormats: {
                BCH: 'legacy',
                LTC: 'type3',
            },
            statusUrl: 'https://coinswitch.co/app/exchange/transaction/{{orderId}}',
            kycUrl: 'https://coinswitch.co',
            supportUrl: 'https://coinswitch.co',
            kycPolicy: 'KYC never required. Exceptional cases automatically refunded. 👍',
            kycPolicyType: 'noKYC',
            isRefundRequired: false,
        },
        {
            name: 'coinswitchfr',
            companyName: 'CoinSwitch',
            logo: 'coinswitchfr-icon.jpg',
            isActive: true,
            isFixedRate: true,
            isDex: false,
            buyTickers: tickers3,
            sellTickers: tickers3,
            addressFormats: {
                BCH: 'legacy',
                LTC: 'type3',
            },
            statusUrl: 'https://coinswitch.co/app/exchange/transaction/{{orderId}}',
            kycUrl: 'https://coinswitch.co',
            supportUrl: 'https://coinswitch.co',
            kycPolicy: 'KYC never required. Exceptional cases automatically refunded. 👍',
            kycPolicyType: 'noKYC',
            isRefundRequired: true,
        },
        {
            name: '1inch',
            companyName: '1inch',
            logo: '1inch-icon.png',
            isActive: true,
            isFixedRate: false,
            isDex: true,
            buyTickers: tickers5,
            sellTickers: tickers5,
            addressFormats: {},
            statusUrl: 'https://help.1inch.io/',
            supportUrl: 'https://help.1inch.io/',
            kycPolicy: 'KYC never required. DEX swaps either succeed or fail. 👍',
            kycPolicyType: 'DEX',
            isRefundRequired: false,
        },
    ],
    providerInfos: {
        changenow: {
            name: 'changenow',
            companyName: 'ChangeNOW',
            logo: 'changenow-icon.jpg',
            isActive: true,
            isFixedRate: false,
            isDex: false,
            buyTickers: tickers1,
            sellTickers: tickers1,
            addressFormats: {
                BCH: 'legacy',
                LTC: 'type3',
            },
            statusUrl: 'https://changenow.io/exchange/txs/{{orderId}}',
            kycUrl: 'https://changenow.io/faq#kyc',
            supportUrl: 'https://support.changenow.io',
            kycPolicy: 'KYC requested in exceptional cases. KYC not required for refunds. 🤝',
            kycPolicyType: 'KYC-yesrefund',
            isRefundRequired: false,
        },
        changenowfr: {
            name: 'changenowfr',
            companyName: 'ChangeNOW',
            logo: 'changenowfr-icon.jpg',
            isActive: true,
            isFixedRate: true,
            isDex: false,
            buyTickers: tickers1,
            sellTickers: tickers1,
            addressFormats: {
                BCH: 'legacy',
                LTC: 'type3',
            },
            statusUrl: 'https://changenow.io/exchange/txs/{{orderId}}',
            kycUrl: 'https://changenow.io/faq#kyc',
            supportUrl: 'https://support.changenow.io',
            kycPolicy: 'KYC requested in exceptional cases. KYC not required for refunds. 🤝',
            kycPolicyType: 'KYC-yesrefund',
            isRefundRequired: false,
        },
        changelly: {
            name: 'changelly',
            companyName: 'Changelly',
            logo: 'changelly-icon.jpg',
            isActive: true,
            isFixedRate: false,
            isDex: false,
            buyTickers: tickers2,
            sellTickers: tickers2,
            addressFormats: {
                BCH: 'cashaddr',
                LTC: 'type3',
            },
            statusUrl: '',
            kycUrl: 'https://changelly.com/aml-kyc',
            supportUrl: 'https://support.changelly.com',
            kycPolicy: 'KYC requested in exceptional cases. KYC required for refunds. 👈',
            kycPolicyType: 'KYC-norefund',
            isRefundRequired: false,
        },
        changellyfr: {
            name: 'changellyfr',
            companyName: 'Changelly',
            logo: 'changellyfr-icon.jpg',
            isActive: true,
            isFixedRate: true,
            isDex: false,
            buyTickers: tickers2,
            sellTickers: tickers2,
            addressFormats: {
                BCH: 'cashaddr',
                LTC: 'type3',
            },
            statusUrl: '',
            kycUrl: 'https://changelly.com/aml-kyc',
            supportUrl: 'https://support.changelly.com',
            kycPolicy: 'KYC requested in exceptional cases. KYC required for refunds. 👈',
            kycPolicyType: 'KYC-norefund',
            isRefundRequired: true,
        },
        changehero: {
            name: 'changehero',
            companyName: 'ChangeHero',
            logo: 'changehero-icon.jpg',
            isActive: true,
            isFixedRate: false,
            isDex: false,
            buyTickers: tickers3,
            sellTickers: tickers3,
            addressFormats: {
                BCH: 'legacy',
                LTC: 'type3',
            },
            statusUrl: '',
            kycUrl: 'https://changehero.io/aml-kyc',
            supportUrl: 'https://support.changehero.io',
            kycPolicy: 'KYC requested in exceptional cases. KYC required for refunds. 👈',
            kycPolicyType: 'KYC-norefund',
            isRefundRequired: false,
        },
        changeherofr: {
            name: 'changeherofr',
            companyName: 'ChangeHero',
            logo: 'changeherofr-icon.jpg',
            isActive: true,
            isFixedRate: true,
            isDex: false,
            buyTickers: tickers3,
            sellTickers: tickers3,
            addressFormats: {
                BCH: 'legacy',
                LTC: 'type3',
            },
            statusUrl: '',
            kycUrl: 'https://changehero.io/aml-kyc',
            supportUrl: 'https://support.changehero.io',
            kycPolicy: 'KYC requested in exceptional cases. KYC required for refunds. 👈',
            kycPolicyType: 'KYC-norefund',
            isRefundRequired: true,
        },
        foxexchange: {
            name: 'foxexchange',
            companyName: 'FoxExchange',
            logo: 'foxexchange-icon.jpg',
            isActive: true,
            isFixedRate: false,
            isDex: false,
            buyTickers: tickers3,
            sellTickers: tickers3,
            addressFormats: {
                BCH: 'cashaddr',
                LTC: 'type3',
            },
            statusUrl: 'https://fox.exchange/tx/{{orderId}}',
            kycUrl: 'https://fox.exchange',
            supportUrl: 'https://fox.exchange',
            kycPolicy: 'KYC never required. Exceptional cases automatically refunded. 👍',
            kycPolicyType: 'noKYC',
            isRefundRequired: false,
        },
        foxexchangefr: {
            name: 'foxexchangefr',
            companyName: 'FoxExchange',
            logo: 'foxexchange-icon.jpg',
            isActive: true,
            isFixedRate: true,
            isDex: false,
            buyTickers: tickers3,
            sellTickers: tickers3,
            addressFormats: {
                BCH: 'cashaddr',
                LTC: 'type3',
            },
            statusUrl: 'https://fox.exchange/tx/{{orderId}}',
            kycUrl: 'https://fox.exchange',
            supportUrl: 'https://fox.exchange',
            kycPolicy: 'KYC never required. Exceptional cases automatically refunded. 👍',
            kycPolicyType: 'noKYC',
            isRefundRequired: false,
        },
        coinswitch: {
            name: 'coinswitch',
            companyName: 'CoinSwitch',
            logo: 'coinswitch-icon.jpg',
            isActive: true,
            isFixedRate: false,
            isDex: false,
            buyTickers: tickers4,
            sellTickers: tickers4,
            addressFormats: {
                BCH: 'legacy',
                LTC: 'type3',
            },
            statusUrl: 'https://coinswitch.co/app/exchange/transaction/{{orderId}}',
            kycUrl: 'https://coinswitch.co',
            supportUrl: 'https://coinswitch.co',
            kycPolicy: 'KYC never required. Exceptional cases automatically refunded. 👍',
            kycPolicyType: 'noKYC',
            isRefundRequired: false,
        },
        coinswitchfr: {
            name: 'coinswitchfr',
            companyName: 'CoinSwitch',
            logo: 'coinswitchfr-icon.jpg',
            isActive: true,
            isFixedRate: true,
            isDex: false,
            buyTickers: tickers3,
            sellTickers: tickers3,
            addressFormats: {
                BCH: 'legacy',
                LTC: 'type3',
            },
            statusUrl: 'https://coinswitch.co/app/exchange/transaction/{{orderId}}',
            kycUrl: 'https://coinswitch.co',
            supportUrl: 'https://coinswitch.co',
            kycPolicy: 'KYC never required. Exceptional cases automatically refunded. 👍',
            kycPolicyType: 'noKYC',
            isRefundRequired: true,
        },
        '1inch': {
            name: '1inch',
            companyName: '1inch',
            logo: '1inch-icon.png',
            isActive: true,
            isFixedRate: false,
            isDex: true,
            buyTickers: tickers5,
            sellTickers: tickers5,
            addressFormats: {},
            statusUrl: 'https://help.1inch.io/',
            supportUrl: 'https://help.1inch.io/',
            kycPolicy: 'KYC never required. DEX swaps either succeed or fail. 👍',
            kycPolicyType: 'DEX',
            isRefundRequired: false,
        },
    },
    buySymbols: new Set(),
    sellSymbols: new Set(),
};
export const MIN_MAX_QUOTES_OK: ExchangeTrade[] = [
    {
        send: litecoin,
        sendStringAmount: '12',
        receive: bitcoin,
        receiveStringAmount: '0.0609979',
        rate: 0.005083158333333333,
        min: 0.5688,
        max: 'NONE',
        fee: 'UNKNOWN',
        exchange: 'changelly',
    },
    {
        send: litecoin,
        sendStringAmount: '12',
        receive: bitcoin,
        receiveStringAmount: '0.0605096167302',
        rate: 0.00504246806085,
        min: 1.68,
        max: 130,
        fee: 'UNKNOWN',
        exchange: 'foxexchange',
        quoteToken: '',
    },
    {
        send: litecoin,
        sendStringAmount: '12',
        receive: bitcoin,
        receiveStringAmount: '0.06047229',
        rate: 0.0050393575,
        min: 1.68,
        max: 130,
        fee: 'INCLUDED',
        exchange: 'foxexchangefr',
        quoteToken: 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9',
    },
    {
        send: litecoin,
        sendStringAmount: '12',
        receive: bitcoin,
        receiveStringAmount: '0.06036741979259172204',
        rate: 0.005030618316049311,
        min: 0.35206704205749473,
        max: 195.59280114305264,
        fee: 'INCLUDED',
        rateIdentificator: '6ad45ee9-a8fa-4d25-a3c8-05361176b49d',
        exchange: 'changeherofr',
    },
    {
        send: litecoin,
        sendStringAmount: '12',
        receive: bitcoin,
        receiveStringAmount: '0.060238681',
        rate: 0.005019890083333333,
        min: 0.35121471511608626,
        max: 'NONE',
        fee: 'UNKNOWN',
        exchange: 'changehero',
    },
    {
        send: litecoin,
        sendStringAmount: '12',
        receive: bitcoin,
        receiveStringAmount: '0.059907672',
        rate: 0.004992305999999999,
        min: 0.5245852799999999,
        max: 'NONE',
        fee: 'UNKNOWN',
        exchange: 'changenow',
    },
    {
        send: litecoin,
        sendStringAmount: '12',
        receive: bitcoin,
        receiveStringAmount: '0.05984359',
        rate: 0.004986965833333333,
        min: 0.8295,
        max: 719.15,
        fee: 'INCLUDED',
        offerReferenceId: 'db551578-915a-47c9-9197-a656e9372f2c',
        exchange: 'coinswitchfr',
    },
    {
        send: litecoin,
        sendStringAmount: '12',
        receive: bitcoin,
        receiveStringAmount: '0.05980199613749862984',
        rate: 0.004983499678124886,
        min: 0.85,
        max: 80,
        fee: 'UNKNOWN',
        exchange: 'coinswitch',
    },
    {
        send: litecoin,
        sendStringAmount: '12',
        receive: bitcoin,
        receiveStringAmount: '0.0595996968',
        rate: 0.0049666414,
        min: 0.948,
        max: 757,
        fee: 'INCLUDED',
        rateIdentificator: 'e98f80e3e29dd57c0356141836c113f1c19ecadf66ee77fde5835796499cfe065e73',
        exchange: 'changellyfr',
    },
    {
        send: litecoin,
        sendStringAmount: '12',
        receive: bitcoin,
        receiveStringAmount: '0.0595048',
        rate: 0.004958733333333333,
        min: 0.70367472,
        max: 293.1036283,
        fee: 'INCLUDED',
        exchange: 'changenowfr',
    },
    {
        send: ethereum,
        sendStringAmount: '0.033466001597224105',
        receive: cronoseth,
        receiveStringAmount: '1116.96945045',
        rate: 33376.2444612639,
        min: 0,
        max: 'NONE',
        fee: 'UNKNOWN',
        exchange: '1inch',
        isDex: true,
        approvalGasEstimate: 57000,
        swapGasEstimate: 189386,
        swapSlippage: '1',
    },
];

export const MIN_MAX_QUOTES_LOW: ExchangeTrade[] = [
    {
        send: litecoin,
        sendStringAmount: '.1',
        receive: bitcoin,
        receiveStringAmount: '0.000503106150246929012',
        rate: 0.00503106150246929,
        min: 0.3520800003243513,
        max: 195.60000018019517,
        fee: 'INCLUDED',
        rateIdentificator: 'ed43e76b-eb1d-4363-bc32-e2e768933de9',
        exchange: 'changeherofr',
    },
    {
        send: litecoin,
        sendStringAmount: '.1',
        receive: bitcoin,
        receiveStringAmount: '0.000498498993472488582',
        rate: 0.0049849899347248865,
        min: 0.85,
        max: 80,
        fee: 'UNKNOWN',
        exchange: 'coinswitch',
    },
    {
        send: litecoin,
        sendStringAmount: '.1',
        receive: bitcoin,
        receiveStringAmount: '0.00049665676',
        rate: 0.0049665676,
        min: 0.948,
        max: 757,
        fee: 'INCLUDED',
        rateIdentificator: 'e98f80e3e29dd57c0356141836c113f1c29cccdd66ee77fde58357964a98f5045471',
        exchange: 'changellyfr',
    },
    {
        send: litecoin,
        sendStringAmount: '.1',
        receive: bitcoin,
        receiveStringAmount: '0.000342342',
        rate: 0.00342342,
        min: 0.5245852799999999,
        max: 'NONE',
        fee: 'UNKNOWN',
        exchange: 'changenow',
    },
    {
        send: litecoin,
        sendStringAmount: '.1',
        receive: bitcoin,
        receiveStringAmount: '0.00015492504',
        rate: 0.0015492504,
        min: 0.35121471511608626,
        max: 'NONE',
        fee: 'UNKNOWN',
        exchange: 'changehero',
    },
    { error: 'Invalid amount: minimal amount is 0.474', exchange: 'changelly' },
    {
        send: litecoin,
        sendStringAmount: '.1',
        receive: bitcoin,
        min: 0.7043630399999999,
        max: 293.3972814,
        fee: 'INCLUDED',
        error: 'Amount out of range.',
        exchange: 'changenowfr',
    },
    {
        send: litecoin,
        sendStringAmount: '.1',
        receive: bitcoin,
        min: 0.8295,
        max: 719.15,
        error: 'Amount out of range.',
        exchange: 'coinswitchfr',
    },
    {
        send: litecoin,
        sendStringAmount: '.1',
        receive: bitcoin,
        min: 1.68,
        max: 130,
        fee: 'UNKNOWN',
        error: 'Amount out of range.',
        exchange: 'foxexchange',
        quoteToken: '',
    },
    {
        send: litecoin,
        sendStringAmount: '.1',
        receive: bitcoin,
        min: 1.68,
        max: 130,
        fee: 'INCLUDED',
        error: 'Amount out of range.',
        exchange: 'foxexchangefr',
    },
];

export const MIN_MAX_QUOTES_CANNOT_TRADE: ExchangeTrade[] = [
    { error: 'Cannot trade pair LTC-DATA.', exchange: 'changehero' },
    { error: 'Cannot trade pair LTC-DATA.', exchange: 'changeherofr' },
    { error: 'Cannot trade pair LTC-DATA.', exchange: 'changelly' },
    { error: 'Cannot trade pair LTC-DATA.', exchange: 'changellyfr' },
    { error: 'Cannot trade pair LTC-DATA.', exchange: 'changenow' },
    { error: 'Cannot trade pair LTC-DATA.', exchange: 'changenowfr' },
    { error: 'Cannot trade pair LTC-DATA.', exchange: 'coinswitch' },
    { error: 'Cannot trade pair LTC-DATA.', exchange: 'coinswitchfr' },
    { error: 'Cannot trade pair LTC-DATA.', exchange: 'foxexchange' },
    { error: 'Cannot trade pair LTC-DATA.', exchange: 'foxexchangefr' },
];

export const EXCHANGE_SUCCESS_ORDERED_QUOTES = [
    {
        exchange: 'changelly',
        fee: 'UNKNOWN',
        max: 'NONE',
        min: 0.5688,
        rate: 0.005083158333333333,
        receive: bitcoin,
        receiveStringAmount: '0.0609979',
        send: litecoin,
        sendStringAmount: '12',
    },
    {
        exchange: 'foxexchange',
        fee: 'UNKNOWN',
        max: 130,
        min: 1.68,
        quoteToken: '',
        rate: 0.00504246806085,
        receive: bitcoin,
        receiveStringAmount: '0.0605096167302',
        send: litecoin,
        sendStringAmount: '12',
    },
    {
        exchange: 'foxexchangefr',
        fee: 'INCLUDED',
        max: 130,
        min: 1.68,
        quoteToken: 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9',
        rate: 0.0050393575,
        receive: bitcoin,
        receiveStringAmount: '0.06047229',
        send: litecoin,
        sendStringAmount: '12',
    },
    {
        exchange: 'changeherofr',
        fee: 'INCLUDED',
        max: 195.59280114305264,
        min: 0.35206704205749473,
        rate: 0.005030618316049311,
        rateIdentificator: '6ad45ee9-a8fa-4d25-a3c8-05361176b49d',
        receive: bitcoin,
        receiveStringAmount: '0.06036741979259172204',
        send: litecoin,
        sendStringAmount: '12',
    },
    {
        exchange: 'changehero',
        fee: 'UNKNOWN',
        max: 'NONE',
        min: 0.35121471511608626,
        rate: 0.005019890083333333,
        receive: bitcoin,
        receiveStringAmount: '0.060238681',
        send: litecoin,
        sendStringAmount: '12',
    },
    {
        exchange: 'changenow',
        fee: 'UNKNOWN',
        max: 'NONE',
        min: 0.5245852799999999,
        rate: 0.004992305999999999,
        receive: bitcoin,
        receiveStringAmount: '0.059907672',
        send: litecoin,
        sendStringAmount: '12',
    },
    {
        exchange: 'coinswitchfr',
        fee: 'INCLUDED',
        max: 719.15,
        min: 0.8295,
        offerReferenceId: 'db551578-915a-47c9-9197-a656e9372f2c',
        rate: 0.004986965833333333,
        receive: bitcoin,
        receiveStringAmount: '0.05984359',
        send: litecoin,
        sendStringAmount: '12',
    },
    {
        exchange: 'coinswitch',
        fee: 'UNKNOWN',
        max: 80,
        min: 0.85,
        rate: 0.004983499678124886,
        receive: bitcoin,
        receiveStringAmount: '0.05980199613749862984',
        send: litecoin,
        sendStringAmount: '12',
    },
    {
        exchange: 'changellyfr',
        fee: 'INCLUDED',
        max: 757,
        min: 0.948,
        rate: 0.0049666414,
        rateIdentificator: 'e98f80e3e29dd57c0356141836c113f1c19ecadf66ee77fde5835796499cfe065e73',
        receive: bitcoin,
        receiveStringAmount: '0.0595996968',
        send: litecoin,
        sendStringAmount: '12',
    },
    {
        exchange: 'changenowfr',
        fee: 'INCLUDED',
        max: 293.1036283,
        min: 0.70367472,
        rate: 0.004958733333333333,
        receive: bitcoin,
        receiveStringAmount: '0.0595048',
        send: litecoin,
        sendStringAmount: '12',
    },
    {
        approvalGasEstimate: 57000,
        exchange: '1inch',
        fee: 'UNKNOWN',
        isDex: true,
        max: 'NONE',
        min: 0,
        rate: 33376.2444612639,
        receive: cronoseth,
        receiveStringAmount: '1116.96945045',
        send: ethereum,
        sendStringAmount: '0.033466001597224105',
        swapGasEstimate: 189386,
        swapSlippage: '1',
    },
];
