import styled from 'styled-components';

import { Button } from '@trezor/components';

import { useSelector } from 'src/hooks/suite/useSelector';
import { Modal, Translation } from 'src/components/suite';
import { selectSelectedAccount } from 'src/reducers/wallet/selectedAccountReducer';
import { useDispatch } from 'src/hooks/suite';
import { stopCoinjoinSession } from 'src/actions/wallet/coinjoinClientActions';

const StyledModal = styled(Modal)`
    width: 435px;
`;

// eslint-disable-next-line local-rules/no-override-ds-component
const StyledButton = styled(Button)`
    flex: 1;
`;

const CancelButton = styled(StyledButton)`
    color: ${({ theme }) => theme.legacy.TYPE_DARK_GREY};
    background: ${({ theme }) => theme.legacy.BG_WHITE_ALT_HOVER};

    &:hover {
        background: ${({ theme }) => theme.legacy.STROKE_GREY};
    }
`;

interface CancelCoinjoinModalProps {
    onClose: () => void;
}

export const CancelCoinjoinModal = ({ onClose }: CancelCoinjoinModalProps) => {
    const account = useSelector(selectSelectedAccount);

    const dispatch = useDispatch();

    if (!account) {
        return null;
    }

    return (
        <StyledModal
            isCancelable
            onCancel={onClose}
            heading={<Translation id="TR_CANCEL_COINJOIN" />}
            bottomBarComponents={
                <>
                    <CancelButton variant="primary" onClick={onClose}>
                        <Translation id="TR_CANCEL_COINJOIN_NO" />
                    </CancelButton>
                    <StyledButton
                        variant="destructive"
                        onClick={() => {
                            dispatch(stopCoinjoinSession(account.key));
                            onClose();
                        }}
                    >
                        <Translation id="TR_CANCEL_COINJOIN_YES" />
                    </StyledButton>
                </>
            }
        >
            <Translation id="TR_CANCEL_COINJOIN_QUESTION" />
        </StyledModal>
    );
};
